/*
 * Decompiled with CFR 0.152.
 */
package io.delta.sharing.spark;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import io.delta.sharing.client.DeltaSharingClient;
import io.delta.sharing.client.DeltaSharingRestClient$;
import io.delta.sharing.client.ParsedDeltaSharingTablePath;
import io.delta.sharing.client.model.DeltaTableMetadata;
import io.delta.sharing.client.model.Table;
import io.delta.sharing.client.util.ConfUtils$;
import io.delta.sharing.spark.DeltaFormatSharingLimitPushDown$;
import io.delta.sharing.spark.DeltaFormatSharingSource;
import io.delta.sharing.spark.DeltaSharingCDFUtils$;
import io.delta.sharing.spark.DeltaSharingDataSource$;
import io.delta.sharing.spark.DeltaSharingErrors$;
import io.delta.sharing.spark.DeltaSharingFileIndex;
import io.delta.sharing.spark.DeltaSharingFileIndexParams;
import io.delta.sharing.spark.DeltaSharingLogFileSystem$;
import io.delta.sharing.spark.DeltaSharingOptions;
import io.delta.sharing.spark.DeltaSharingOptions$;
import io.delta.sharing.spark.DeltaSharingSource;
import io.delta.sharing.spark.DeltaSharingUtils;
import io.delta.sharing.spark.DeltaSharingUtils$;
import io.delta.sharing.spark.DeltaTableUtils$;
import io.delta.sharing.spark.RemoteDeltaLog;
import io.delta.sharing.spark.RemoteDeltaLog$;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.delta.DeltaColumnMapping$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.SnapshotDescriptor;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.schema.SchemaUtils$;
import org.apache.spark.sql.delta.sources.DeltaDataSource$;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.streaming.Source;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.RelationProvider;
import org.apache.spark.sql.sources.StreamSourceProvider;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Uc!\u0002\u0007\u000e\u0001=)\u0002\"\u0002\u001c\u0001\t\u0003A\u0004\"B\u001e\u0001\t\u0003b\u0004\"B2\u0001\t\u0003\"\u0007\"B:\u0001\t\u0003\"\b\"\u0002>\u0001\t\u0013Y\bbBA\u0002\u0001\u0011%\u0011Q\u0001\u0005\b\u0003{\u0001A\u0011IA \u000f!\t\t%\u0004E\u0001\u001f\u0005\rca\u0002\u0007\u000e\u0011\u0003y\u0011Q\t\u0005\u0007m%!\t!a\u0012\t\u000f\u0005%\u0013\u0002\"\u0001\u0002L\t1B)\u001a7uCNC\u0017M]5oO\u0012\u000bG/Y*pkJ\u001cWM\u0003\u0002\u000f\u001f\u0005)1\u000f]1sW*\u0011\u0001#E\u0001\bg\"\f'/\u001b8h\u0015\t\u00112#A\u0003eK2$\u0018MC\u0001\u0015\u0003\tIwn\u0005\u0004\u0001-qICf\f\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005u9S\"\u0001\u0010\u000b\u0005}\u0001\u0013aB:pkJ\u001cWm\u001d\u0006\u0003C\t\n1a]9m\u0015\tq1E\u0003\u0002%K\u00051\u0011\r]1dQ\u0016T\u0011AJ\u0001\u0004_J<\u0017B\u0001\u0015\u001f\u0005A\u0011V\r\\1uS>t\u0007K]8wS\u0012,'\u000f\u0005\u0002\u001eU%\u00111F\b\u0002\u0015'R\u0014X-Y7T_V\u00148-\u001a)s_ZLG-\u001a:\u0011\u0005ui\u0013B\u0001\u0018\u001f\u0005I!\u0015\r^1T_V\u00148-\u001a*fO&\u001cH/\u001a:\u0011\u0005A\"T\"A\u0019\u000b\u0005I\u001a\u0014\u0001C7fi\u0016\u0014\u0018N\\4\u000b\u0005I\u0001\u0013BA\u001b2\u00051!U\r\u001c;b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}\r\u0001A#A\u001d\u0011\u0005i\u0002Q\"A\u0007\u0002\u0019M|WO]2f'\u000eDW-\\1\u0015\u000bu\nv\u000b\u00180\u0011\t]q\u0004iS\u0005\u0003\u007fa\u0011a\u0001V;qY\u0016\u0014\u0004CA!I\u001d\t\u0011e\t\u0005\u0002D15\tAI\u0003\u0002Fo\u00051AH]8pizJ!a\u0012\r\u0002\rA\u0013X\rZ3g\u0013\tI%J\u0001\u0004TiJLgn\u001a\u0006\u0003\u000fb\u0001\"\u0001T(\u000e\u00035S!A\u0014\u0011\u0002\u000bQL\b/Z:\n\u0005Ak%AC*ueV\u001cG\u000fV=qK\")!K\u0001a\u0001'\u0006Q1/\u001d7D_:$X\r\u001f;\u0011\u0005Q+V\"\u0001\u0011\n\u0005Y\u0003#AC*R\u0019\u000e{g\u000e^3yi\")\u0001L\u0001a\u00013\u000611o\u00195f[\u0006\u00042a\u0006.L\u0013\tY\u0006D\u0001\u0004PaRLwN\u001c\u0005\u0006;\n\u0001\r\u0001Q\u0001\raJ|g/\u001b3fe:\u000bW.\u001a\u0005\u0006?\n\u0001\r\u0001Y\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001c\b\u0003B!b\u0001\u0002K!A\u0019&\u0003\u00075\u000b\u0007/\u0001\u0007de\u0016\fG/Z*pkJ\u001cW\r\u0006\u0004f[:\u0004\u0018O\u001d\t\u0003M.l\u0011a\u001a\u0006\u0003Q&\f\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005)\u0004\u0013!C3yK\u000e,H/[8o\u0013\tawM\u0001\u0004T_V\u00148-\u001a\u0005\u0006%\u000e\u0001\ra\u0015\u0005\u0006_\u000e\u0001\r\u0001Q\u0001\r[\u0016$\u0018\rZ1uCB\u000bG\u000f\u001b\u0005\u00061\u000e\u0001\r!\u0017\u0005\u0006;\u000e\u0001\r\u0001\u0011\u0005\u0006?\u000e\u0001\r\u0001Y\u0001\u000fGJ,\u0017\r^3SK2\fG/[8o)\r)\b0\u001f\t\u0003;YL!a\u001e\u0010\u0003\u0019\t\u000b7/\u001a*fY\u0006$\u0018n\u001c8\t\u000bI#\u0001\u0019A*\t\u000b}#\u0001\u0019\u00011\u0002O\u0005,Ho\u001c*fg>dg/\u001a\"bg\u0016\u0014V\r\\1uS>tgi\u001c:T]\u0006\u00048\u000f[8u#V,'/\u001f\u000b\u0003krDQ!`\u0003A\u0002y\fqa\u001c9uS>t7\u000f\u0005\u0002;\u007f&\u0019\u0011\u0011A\u0007\u0003'\u0011+G\u000e^1TQ\u0006\u0014\u0018N\\4PaRLwN\\:\u0002Q\u001d,G\u000fS1e_>\u0004hi\u001d*fY\u0006$\u0018n\u001c8G_J$U\r\u001c;b':\f\u0007o\u001d5piF+XM]=\u0015\u0017U\f9!a\u0003\u0002\u000e\u0005\u0005\u00121\u0006\u0005\u0007\u0003\u00131\u0001\u0019\u0001!\u0002\tA\fG\u000f\u001b\u0005\u0006{\u001a\u0001\rA \u0005\b\u0003\u001f1\u0001\u0019AA\t\u0003\u001d!7\u000fV1cY\u0016\u0004B!a\u0005\u0002\u001e5\u0011\u0011Q\u0003\u0006\u0005\u0003/\tI\"A\u0003n_\u0012,GNC\u0002\u0002\u001c=\taa\u00197jK:$\u0018\u0002BA\u0010\u0003+\u0011Q\u0001V1cY\u0016Dq!a\u0007\u0007\u0001\u0004\t\u0019\u0003\u0005\u0003\u0002&\u0005\u001dRBAA\r\u0013\u0011\tI#!\u0007\u0003%\u0011+G\u000e^1TQ\u0006\u0014\u0018N\\4DY&,g\u000e\u001e\u0005\b\u0003[1\u0001\u0019AA\u0018\u0003e!W\r\u001c;b'\"\f'/\u001b8h)\u0006\u0014G.Z'fi\u0006$\u0017\r^1\u0011\t\u0005E\u0012q\u0007\b\u0004u\u0005M\u0012bAA\u001b\u001b\u0005\tB)\u001a7uCNC\u0017M]5oOV#\u0018\u000e\\:\n\t\u0005e\u00121\b\u0002\u001a\t\u0016dG/Y*iCJLgn\u001a+bE2,W*\u001a;bI\u0006$\u0018MC\u0002\u000265\t\u0011b\u001d5peRt\u0015-\\3\u0015\u0003\u0001\u000ba\u0003R3mi\u0006\u001c\u0006.\u0019:j]\u001e$\u0015\r^1T_V\u00148-\u001a\t\u0003u%\u0019\"!\u0003\f\u0015\u0005\u0005\r\u0013aD:fiV\u0004h)\u001b7f'f\u001cH/Z7\u0015\t\u00055\u00131\u000b\t\u0004/\u0005=\u0013bAA)1\t!QK\\5u\u0011\u0015\u00116\u00021\u0001T\u0001")
public class DeltaSharingDataSource
implements RelationProvider,
StreamSourceProvider,
DataSourceRegister,
DeltaLogging {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static void setupFileSystem(SQLContext sqlContext) {
        DeltaSharingDataSource$.MODULE$.setupFileSystem(sqlContext);
    }

    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$((DeltaLogging)this, (DeltaLog)deltaLog, (String)opType, tags, (Object)data, path);
    }

    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$((DeltaLogging)this);
    }

    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$((DeltaLogging)this);
    }

    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$((DeltaLogging)this);
    }

    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$((DeltaLogging)this, (String)tablePath, (String)opType, tags, thunk);
    }

    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$((DeltaLogging)this);
    }

    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$((DeltaLogging)this, (DeltaLog)deltaLog, (String)opType, tags, thunk);
    }

    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$((DeltaLogging)this);
    }

    public void deltaAssert(Function0<Object> check, String name, String msg, DeltaLog deltaLog, Object data, Option<Path> path) {
        DeltaLogging.deltaAssert$((DeltaLogging)this, check, (String)name, (String)msg, (DeltaLog)deltaLog, (Object)data, path);
    }

    public DeltaLog deltaAssert$default$4() {
        return DeltaLogging.deltaAssert$default$4$((DeltaLogging)this);
    }

    public Object deltaAssert$default$5() {
        return DeltaLogging.deltaAssert$default$5$((DeltaLogging)this);
    }

    public Option<Path> deltaAssert$default$6() {
        return DeltaLogging.deltaAssert$default$6$((DeltaLogging)this);
    }

    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$((DeltaLogging)this, (String)group, (String)name, thunk);
    }

    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$((DeltaLogging)this, (DeltaLog)deltaLog, (String)tahoeId);
    }

    public Map<String, Object> getErrorData(Throwable e) {
        return DeltaLogging.getErrorData$((DeltaLogging)this, (Throwable)e);
    }

    public void logConsole(String line) {
        DatabricksLogging.logConsole$((DatabricksLogging)this, (String)line);
    }

    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$((DatabricksLogging)this, (MetricDefinition)metric, (double)quantity, additionalTags, (String)blob, (boolean)forceSample, (boolean)trimBlob, (boolean)silent);
    }

    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$((DatabricksLogging)this);
    }

    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$((DatabricksLogging)this);
    }

    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$((DatabricksLogging)this);
    }

    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$((DatabricksLogging)this);
    }

    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$((DatabricksLogging)this);
    }

    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$((DatabricksLogging)this, (MetricDefinition)metric, additionalTags, (String)blob, (boolean)trimBlob);
    }

    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$((DatabricksLogging)this);
    }

    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$((DatabricksLogging)this);
    }

    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$((DatabricksLogging)this);
    }

    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$((DatabricksLogging)this, (OpType)opType, (String)opTarget, extraTags, (boolean)isSynchronous, (boolean)alwaysRecordStats, (boolean)allowAuthTags, (boolean)killJvmIfStuck, (MetricDefinition)outputMetric, (boolean)silent, thunk);
    }

    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$((DatabricksLogging)this);
    }

    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$((DatabricksLogging)this);
    }

    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$((DatabricksLogging)this);
    }

    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$((DatabricksLogging)this);
    }

    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$((DatabricksLogging)this);
    }

    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$((DatabricksLogging)this);
    }

    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$((DatabricksLogging)this);
    }

    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$((DatabricksLogging)this, (MetricDefinition)metric, (double)quantity, additionalTags, (String)blob, (boolean)forceSample, (boolean)trimBlob, (boolean)silent);
    }

    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$((DatabricksLogging)this);
    }

    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$((DatabricksLogging)this);
    }

    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$((DatabricksLogging)this);
    }

    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$((DatabricksLogging)this);
    }

    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$((DatabricksLogging)this);
    }

    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$((DatabricksLogging)this, (MetricDefinition)metric, additionalTags, (String)blob, (boolean)trimBlob);
    }

    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$((DatabricksLogging)this);
    }

    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$((DatabricksLogging)this);
    }

    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$((DatabricksLogging)this);
    }

    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$((DeltaProgressReporter)this, (String)statusCode, (String)defaultMessage, data, body);
    }

    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$((DeltaProgressReporter)this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Tuple2<String, StructType> sourceSchema(SQLContext sqlContext, Option<StructType> schema, String providerName, Map<String, String> parameters) {
        DeltaSharingDataSource$.MODULE$.setupFileSystem(sqlContext);
        if (schema.nonEmpty() && ((IterableOnceOps)schema.get()).nonEmpty()) {
            throw DeltaErrors$.MODULE$.specifySchemaAtReadTimeException();
        }
        DeltaSharingOptions options = new DeltaSharingOptions(parameters);
        if (options.isTimeTravel()) {
            throw DeltaErrors$.MODULE$.timeTravelNotSupportedException();
        }
        String path = (String)options.options().getOrElse((Object)"path", (Function0 & Serializable)() -> {
            throw DeltaSharingErrors$.MODULE$.pathNotSpecifiedException();
        });
        String string = options.responseFormat();
        String string2 = DeltaSharingOptions$.MODULE$.RESPONSE_FORMAT_PARQUET();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(61).append("sourceSchema with parquet format for table path:").append(path).append(", parameters:").append(parameters).toString());
            RemoteDeltaLog deltaLog = RemoteDeltaLog$.MODULE$.apply(path, true, options.responseFormat(), RemoteDeltaLog$.MODULE$.apply$default$4());
            StructType schemaToUse = deltaLog.snapshot(deltaLog.snapshot$default$1(), deltaLog.snapshot$default$2()).schema();
            if (schemaToUse.isEmpty()) {
                throw DeltaSharingErrors$.MODULE$.schemaNotSetException();
            }
            if (options.readChangeFeed()) {
                return new Tuple2((Object)this.shortName(), (Object)DeltaTableUtils$.MODULE$.addCdcSchema(schemaToUse));
            }
            return new Tuple2((Object)this.shortName(), (Object)schemaToUse);
        }
        String string3 = options.responseFormat();
        String string4 = DeltaSharingOptions$.MODULE$.RESPONSE_FORMAT_DELTA();
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(59).append("sourceSchema with delta format for table path:").append(path).append(", parameters:").append(parameters).toString());
            if (options.readChangeFeed()) {
                throw new UnsupportedOperationException("Delta sharing cdc streaming is not supported when responseforma=delta.");
            }
            ParsedDeltaSharingTablePath parsedPath = DeltaSharingRestClient$.MODULE$.parsePath(path);
            DeltaSharingClient client = DeltaSharingRestClient$.MODULE$.apply(parsedPath.profileFile(), true, options.responseFormat(), DeltaSharingUtils$.MODULE$.STREAMING_SUPPORTED_READER_FEATURES().mkString(","));
            String x$12 = parsedPath.share();
            String x$2 = parsedPath.schema();
            String x$3 = parsedPath.table();
            Table dsTable = new Table(x$3, x$2, x$12);
            DeltaSharingUtils.DeltaSharingTableMetadata deltaSharingTableMetadata = DeltaSharingUtils$.MODULE$.getDeltaSharingTableMetadata(client, dsTable);
            String customTablePathWithUUIDSuffix = DeltaSharingUtils$.MODULE$.getTablePathWithIdSuffix(client.getProfileProvider().getCustomTablePath(path), DeltaSharingUtils$.MODULE$.getFormattedTimestampWithUUID());
            String deltaLogPath = new StringBuilder(11).append(DeltaSharingLogFileSystem$.MODULE$.encode(customTablePathWithUUIDSuffix).toString()).append("/_delta_log").toString();
            Tuple2<DeltaLog, SnapshotDescriptor> tuple2 = DeltaSharingUtils$.MODULE$.getDeltaLogAndSnapshotDescriptor(sqlContext.sparkSession(), deltaSharingTableMetadata, customTablePathWithUUIDSuffix);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            SnapshotDescriptor snapshotDescriptor = (SnapshotDescriptor)tuple2._2();
            SnapshotDescriptor snapshotDescriptor2 = snapshotDescriptor;
            boolean shouldMergeConsecutiveSchemas = BoxesRunTime.unboxToBoolean((Object)sqlContext.sparkSession().sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_STREAMING_ENABLE_SCHEMA_TRACKING_MERGE_CONSECUTIVE_CHANGES()));
            SparkSession x$4 = sqlContext.sparkSession();
            SnapshotDescriptor x$5 = snapshotDescriptor2;
            Map<String, String> x$6 = parameters;
            boolean x$7 = shouldMergeConsecutiveSchemas;
            Option x$8 = DeltaDataSource$.MODULE$.getMetadataTrackingLogForDeltaSource$default$4();
            StructType readSchema = (StructType)DeltaDataSource$.MODULE$.getMetadataTrackingLogForDeltaSource(x$4, x$5, x$6, x$8, x$7).flatMap((Function1 & Serializable)x$1 -> x$1.getCurrentTrackedMetadata().map((Function1 & Serializable)x$2 -> x$2.dataSchema())).getOrElse((Function0 & Serializable)() -> snapshotDescriptor2.schema());
            StructType schemaToUse = org.apache.spark.sql.delta.DeltaTableUtils$.MODULE$.removeInternalMetadata(sqlContext.sparkSession(), readSchema);
            if (schemaToUse.isEmpty()) {
                throw DeltaErrors$.MODULE$.schemaNotSetException();
            }
            DeltaSharingLogFileSystem$.MODULE$.tryToCleanUpDeltaLog(deltaLogPath);
            return new Tuple2((Object)this.shortName(), (Object)schemaToUse);
        }
        throw new UnsupportedOperationException(new StringBuilder(51).append("responseformat(").append(options.responseFormat()).append(") is not ").append("supported in delta sharing.").toString());
    }

    public Source createSource(SQLContext sqlContext, String metadataPath, Option<StructType> schema, String providerName, Map<String, String> parameters) {
        DeltaSharingDataSource$.MODULE$.setupFileSystem(sqlContext);
        if (schema.nonEmpty() && ((IterableOnceOps)schema.get()).nonEmpty()) {
            throw DeltaSharingErrors$.MODULE$.specifySchemaAtReadTimeException();
        }
        DeltaSharingOptions options = new DeltaSharingOptions(parameters);
        String path = (String)options.options().getOrElse((Object)"path", (Function0 & Serializable)() -> {
            throw DeltaSharingErrors$.MODULE$.pathNotSpecifiedException();
        });
        String string = options.responseFormat();
        String string2 = DeltaSharingOptions$.MODULE$.RESPONSE_FORMAT_PARQUET();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(61).append("createSource with parquet format for table path:").append(path).append(", parameters:").append(parameters).toString());
            RemoteDeltaLog deltaLog = RemoteDeltaLog$.MODULE$.apply(path, true, options.responseFormat(), RemoteDeltaLog$.MODULE$.apply$default$4());
            return new DeltaSharingSource(SparkSession$.MODULE$.active(), deltaLog, options);
        }
        String string3 = options.responseFormat();
        String string4 = DeltaSharingOptions$.MODULE$.RESPONSE_FORMAT_DELTA();
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(59).append("createSource with delta format for table path:").append(path).append(", parameters:").append(parameters).toString());
            if (options.readChangeFeed()) {
                throw new UnsupportedOperationException("Delta sharing cdc streaming is not supported when responseforma=delta.");
            }
            ParsedDeltaSharingTablePath parsedPath = DeltaSharingRestClient$.MODULE$.parsePath(path);
            DeltaSharingClient client = DeltaSharingRestClient$.MODULE$.apply(parsedPath.profileFile(), true, options.responseFormat(), DeltaSharingUtils$.MODULE$.STREAMING_SUPPORTED_READER_FEATURES().mkString(","));
            String x$1 = parsedPath.share();
            String x$2 = parsedPath.schema();
            String x$3 = parsedPath.table();
            Table dsTable = new Table(x$3, x$2, x$1);
            return new DeltaFormatSharingSource(sqlContext.sparkSession(), client, dsTable, options, parameters, sqlContext.sparkSession().sessionState().conf(), metadataPath);
        }
        throw new UnsupportedOperationException(new StringBuilder(51).append("responseformat(").append(options.responseFormat()).append(") is not ").append("supported in delta sharing.").toString());
    }

    public BaseRelation createRelation(SQLContext sqlContext, Map<String, String> parameters) {
        DeltaSharingDataSource$.MODULE$.setupFileSystem(sqlContext);
        DeltaSharingOptions options = new DeltaSharingOptions(parameters);
        Option userInputResponseFormat = options.options().get(DeltaSharingOptions$.MODULE$.RESPONSE_FORMAT());
        if (userInputResponseFormat.isEmpty() && !options.readChangeFeed()) {
            return this.autoResolveBaseRelationForSnapshotQuery(options);
        }
        String path = (String)options.options().getOrElse((Object)"path", (Function0 & Serializable)() -> {
            throw DeltaSharingErrors$.MODULE$.pathNotSpecifiedException();
        });
        String string = options.responseFormat();
        String string2 = DeltaSharingOptions$.MODULE$.RESPONSE_FORMAT_PARQUET();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(63).append("createRelation with parquet format for table path:").append(path).append(", parameters:").append(parameters).toString());
            RemoteDeltaLog deltaLog = RemoteDeltaLog$.MODULE$.apply(path, false, options.responseFormat(), RemoteDeltaLog$.MODULE$.apply$default$4());
            return deltaLog.createRelation(options.versionAsOf(), options.timestampAsOf(), options.cdfOptions());
        }
        String string3 = options.responseFormat();
        String string4 = DeltaSharingOptions$.MODULE$.RESPONSE_FORMAT_DELTA();
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(61).append("createRelation with delta format for table path:").append(path).append(", parameters:").append(parameters).toString());
            ParsedDeltaSharingTablePath parsedPath = DeltaSharingRestClient$.MODULE$.parsePath(path);
            DeltaSharingClient client = DeltaSharingRestClient$.MODULE$.apply(parsedPath.profileFile(), false, options.responseFormat(), DeltaSharingUtils$.MODULE$.SUPPORTED_READER_FEATURES().mkString(","));
            String x$1 = parsedPath.share();
            String x$2 = parsedPath.schema();
            String x$3 = parsedPath.table();
            Table dsTable = new Table(x$3, x$2, x$1);
            if (options.readChangeFeed()) {
                return DeltaSharingCDFUtils$.MODULE$.prepareCDFRelation(sqlContext, options, dsTable, client);
            }
            DeltaTableMetadata deltaTableMetadata = DeltaSharingUtils$.MODULE$.queryDeltaTableMetadata(client, dsTable, (Option<Object>)options.versionAsOf(), (Option<String>)options.timestampAsOf());
            DeltaSharingUtils.DeltaSharingTableMetadata deltaSharingTableMetadata = DeltaSharingUtils$.MODULE$.getDeltaSharingTableMetadata(dsTable, deltaTableMetadata);
            return this.getHadoopFsRelationForDeltaSnapshotQuery(path, options, dsTable, client, deltaSharingTableMetadata);
        }
        throw new UnsupportedOperationException(new StringBuilder(51).append("responseformat(").append(options.responseFormat()).append(") is not supported in delta sharing.").toString());
    }

    private BaseRelation autoResolveBaseRelationForSnapshotQuery(DeltaSharingOptions options) {
        String path = (String)options.options().getOrElse((Object)"path", (Function0 & Serializable)() -> {
            throw DeltaSharingErrors$.MODULE$.pathNotSpecifiedException();
        });
        ParsedDeltaSharingTablePath parsedPath = DeltaSharingRestClient$.MODULE$.parsePath(path);
        DeltaSharingClient client = DeltaSharingRestClient$.MODULE$.apply(parsedPath.profileFile(), false, new StringBuilder(1).append(DeltaSharingOptions$.MODULE$.RESPONSE_FORMAT_PARQUET()).append(",").append(DeltaSharingOptions$.MODULE$.RESPONSE_FORMAT_DELTA()).toString(), DeltaSharingUtils$.MODULE$.SUPPORTED_READER_FEATURES().mkString(","));
        Table dsTable = new Table(parsedPath.table(), parsedPath.schema(), parsedPath.share());
        DeltaTableMetadata deltaTableMetadata = DeltaSharingUtils$.MODULE$.queryDeltaTableMetadata(client, dsTable, (Option<Object>)options.versionAsOf(), (Option<String>)options.timestampAsOf());
        String string = deltaTableMetadata.respondedFormat();
        String string2 = DeltaSharingOptions$.MODULE$.RESPONSE_FORMAT_PARQUET();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            RemoteDeltaLog deltaLog = RemoteDeltaLog$.MODULE$.apply(path, false, DeltaSharingOptions$.MODULE$.RESPONSE_FORMAT_PARQUET(), (Option)new Some((Object)deltaTableMetadata));
            return deltaLog.createRelation(options.versionAsOf(), options.timestampAsOf(), options.cdfOptions());
        }
        String string3 = deltaTableMetadata.respondedFormat();
        String string4 = DeltaSharingOptions$.MODULE$.RESPONSE_FORMAT_DELTA();
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            DeltaSharingUtils.DeltaSharingTableMetadata deltaSharingTableMetadata = DeltaSharingUtils$.MODULE$.getDeltaSharingTableMetadata(dsTable, deltaTableMetadata);
            DeltaSharingClient deltaOnlyClient = DeltaSharingRestClient$.MODULE$.apply(parsedPath.profileFile(), false, DeltaSharingOptions$.MODULE$.RESPONSE_FORMAT_DELTA(), DeltaSharingUtils$.MODULE$.SUPPORTED_READER_FEATURES().mkString(","));
            return this.getHadoopFsRelationForDeltaSnapshotQuery(path, options, dsTable, deltaOnlyClient, deltaSharingTableMetadata);
        }
        throw new UnsupportedOperationException(new StringBuilder(48).append("Unexpected respondedFormat for getMetadata rpc:").append(deltaTableMetadata.respondedFormat()).append(".").toString());
    }

    private BaseRelation getHadoopFsRelationForDeltaSnapshotQuery(String path, DeltaSharingOptions options, Table dsTable, DeltaSharingClient client, DeltaSharingUtils.DeltaSharingTableMetadata deltaSharingTableMetadata) {
        SparkSession spark = SparkSession$.MODULE$.active();
        DeltaSharingFileIndexParams params = new DeltaSharingFileIndexParams(new Path(path), spark, deltaSharingTableMetadata, options);
        if (ConfUtils$.MODULE$.limitPushdownEnabled(spark.sessionState().conf())) {
            DeltaFormatSharingLimitPushDown$.MODULE$.setup(spark);
        }
        DeltaSharingFileIndex fileIndex = new DeltaSharingFileIndex(params, dsTable, client, (Option<Object>)None$.MODULE$);
        return new HadoopFsRelation((FileIndex)fileIndex, DeltaColumnMapping$.MODULE$.dropColumnMappingMetadata(fileIndex.partitionSchema()), DeltaColumnMapping$.MODULE$.dropColumnMappingMetadata(org.apache.spark.sql.delta.DeltaTableUtils$.MODULE$.removeInternalMetadata(spark, SchemaUtils$.MODULE$.dropNullTypeColumns(deltaSharingTableMetadata.metadata().schema()))), (Option)None$.MODULE$, fileIndex.fileFormat(deltaSharingTableMetadata.protocol().deltaProtocol(), deltaSharingTableMetadata.metadata().deltaMetadata()), Predef$.MODULE$.Map().empty(), spark);
    }

    public String shortName() {
        return "deltaSharing";
    }

    public DeltaSharingDataSource() {
        Logging.$init$((Logging)this);
        DeltaProgressReporter.$init$((DeltaProgressReporter)this);
        DatabricksLogging.$init$((DatabricksLogging)this);
        DeltaLogging.$init$((DeltaLogging)this);
    }
}

