/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import io.delta.exceptions.ConcurrentTransactionException;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionSet$;
import org.apache.spark.sql.delta.CurrentTransactionInfo;
import org.apache.spark.sql.delta.DeltaColumnMapping$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaLog$;
import org.apache.spark.sql.delta.DeltaTableReadPredicate;
import org.apache.spark.sql.delta.DeltaTableReadPredicate$;
import org.apache.spark.sql.delta.DomainMetadataUtils$;
import org.apache.spark.sql.delta.IsolationLevel;
import org.apache.spark.sql.delta.RowId;
import org.apache.spark.sql.delta.RowId$;
import org.apache.spark.sql.delta.RowId$RowTrackingMetadataDomain$;
import org.apache.spark.sql.delta.RowTracking$;
import org.apache.spark.sql.delta.Serializable$;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.SnapshotIsolation$;
import org.apache.spark.sql.delta.TableFeature$;
import org.apache.spark.sql.delta.WinningCommitSummary;
import org.apache.spark.sql.delta.WriteSerializable$;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.Action$;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.CommitInfo;
import org.apache.spark.sql.delta.actions.DeletionVectorDescriptor;
import org.apache.spark.sql.delta.actions.DomainMetadata;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.actions.RemoveFile;
import org.apache.spark.sql.delta.actions.SetTransaction;
import org.apache.spark.sql.delta.implicits.package$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.delta.util.FileNames$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001de!\u0002\u0011\"\u0001\u0005Z\u0003\u0002\u0003\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u001d\t\u0011u\u0002!\u0011!Q\u0001\nyB\u0001B\u0011\u0001\u0003\u0002\u0003\u0006Ia\u0011\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\")!\n\u0001C\u0001\u0017\"9\u0011\u000b\u0001b\u0001\n#\u0011\u0006BB*\u0001A\u0003%1\tC\u0004U\u0001\t\u0007I\u0011C+\t\r%\u0004\u0001\u0015!\u0003W\u0011\u001dQ\u0007A1A\u0005\u0012-Daa\u001c\u0001!\u0002\u0013a\u0007b\u00029\u0001\u0001\u0004%\t\"\u001d\u0005\be\u0002\u0001\r\u0011\"\u0005t\u0011\u0019I\b\u0001)Q\u0005}!A!\u0010\u0001EC\u0002\u0013E1\u0010\u0003\u0004\u0000\u0001\u0011\u0005\u0011\u0011\u0001\u0005\b\u0003\u0007\u0001A\u0011CA\u0003\u0011\u001d\t9\u0001\u0001C\t\u0003\u0013Aq!a\u0003\u0001\t#\tI\u0001C\u0004\u0002\u000e\u0001!\t\"a\u0004\t\u000f\u0005e\u0002\u0001\"\u0005\u0002\n!9\u00111\b\u0001\u0005\u0012\u0005%\u0001bBA\u001f\u0001\u0011E\u0011\u0011\u0002\u0005\b\u0003\u007f\u0001A\u0011CA\u0005\u0011\u001d\t\t\u0005\u0001C\u0005\u0003\u0013Aq!a\u0011\u0001\t\u0013\tI\u0001C\u0004\u0002F\u0001!I!!\u0003\t\u000f\u0005\u001d\u0003\u0001\"\u0005\u0002J!9\u0011Q\u000b\u0001\u0005\u0012\u0005]\u0003bBAA\u0001\u0011E\u0011\u0011\u0002\u0005\u000b\u0003\u0007\u0003\u0001R1A\u0005\u0012\u0005\u0015%aD\"p]\u001ad\u0017n\u0019;DQ\u0016\u001c7.\u001a:\u000b\u0005\t\u001a\u0013!\u00023fYR\f'B\u0001\u0013&\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003M\u001d\nQa\u001d9be.T!\u0001K\u0015\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0013aA8sON\u0019\u0001\u0001\f\u001a\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0003=\nQa]2bY\u0006L!!\r\u0018\u0003\r\u0005s\u0017PU3g!\t\u0019d'D\u00015\u0015\t)\u0014%\u0001\u0005nKR,'/\u001b8h\u0013\t9DG\u0001\u0007EK2$\u0018\rT8hO&twm\u0001\u0001\u0011\u0005iZT\"A\u0012\n\u0005q\u001a#\u0001D*qCJ\\7+Z:tS>t\u0017!H5oSRL\u0017\r\\\"veJ,g\u000e\u001e+sC:\u001c\u0018m\u0019;j_:LeNZ8\u0011\u0005}\u0002U\"A\u0011\n\u0005\u0005\u000b#AF\"veJ,g\u000e\u001e+sC:\u001c\u0018m\u0019;j_:LeNZ8\u0002)]LgN\\5oO\u000e{W.\\5u-\u0016\u00148/[8o!\tiC)\u0003\u0002F]\t!Aj\u001c8h\u00039I7o\u001c7bi&|g\u000eT3wK2\u0004\"a\u0010%\n\u0005%\u000b#AD%t_2\fG/[8o\u0019\u00164X\r\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b1kej\u0014)\u0011\u0005}\u0002\u0001\"\u0002\u0014\u0006\u0001\u0004I\u0004\"B\u001f\u0006\u0001\u0004q\u0004\"\u0002\"\u0006\u0001\u0004\u0019\u0005\"\u0002$\u0006\u0001\u00049\u0015aC:uCJ$H+[7f\u001bN,\u0012aQ\u0001\rgR\f'\u000f\u001e+j[\u0016l5\u000fI\u0001\fi&l\u0017N\\4Ti\u0006$8/F\u0001W!\u00119FLX\"\u000e\u0003aS!!\u0017.\u0002\u000f5,H/\u00192mK*\u00111LL\u0001\u000bG>dG.Z2uS>t\u0017BA/Y\u0005\u001dA\u0015m\u001d5NCB\u0004\"a\u00184\u000f\u0005\u0001$\u0007CA1/\u001b\u0005\u0011'BA29\u0003\u0019a$o\\8u}%\u0011QML\u0001\u0007!J,G-\u001a4\n\u0005\u001dD'AB*ue&twM\u0003\u0002f]\u0005aA/[7j]\u001e\u001cF/\u0019;tA\u0005AA-\u001a7uC2{w-F\u0001m!\tyT.\u0003\u0002oC\tAA)\u001a7uC2{w-A\u0005eK2$\u0018\rT8hA\u000512-\u001e:sK:$HK]1og\u0006\u001cG/[8o\u0013:4w.F\u0001?\u0003i\u0019WO\u001d:f]R$&/\u00198tC\u000e$\u0018n\u001c8J]\u001a|w\fJ3r)\t!x\u000f\u0005\u0002.k&\u0011aO\f\u0002\u0005+:LG\u000fC\u0004y\u001b\u0005\u0005\t\u0019\u0001 \u0002\u0007a$\u0013'A\fdkJ\u0014XM\u001c;Ue\u0006t7/Y2uS>t\u0017J\u001c4pA\u0005!r/\u001b8oS:<7i\\7nSR\u001cV/\\7bef,\u0012\u0001 \t\u0003\u007fuL!A`\u0011\u0003)]KgN\\5oO\u000e{W.\\5u'VlW.\u0019:z\u00039\u0019\u0007.Z2l\u0007>tg\r\\5diN$\u0012AP\u0001\u001bGJ,\u0017\r^3XS:t\u0017N\\4D_6l\u0017\u000e^*v[6\f'/\u001f\u000b\u0002y\u0006Q2\r[3dWB\u0013x\u000e^8d_2\u001cu.\u001c9bi&\u0014\u0017\u000e\\5usR\tA/\u0001\fdQ\u0016\u001c7NT8NKR\fG-\u0019;b+B$\u0017\r^3t\u0003\u001d:W\r\u001e$jeN$h)\u001b7f\u001b\u0006$8\r[5oOB\u000b'\u000f^5uS>t\u0007K]3eS\u000e\fG/Z:\u0015\t\u0005E\u00111\u0005\t\u0006[\u0005M\u0011qC\u0005\u0004\u0003+q#AB(qi&|g\u000e\u0005\u0003\u0002\u001a\u0005}QBAA\u000e\u0015\r\ti\"I\u0001\bC\u000e$\u0018n\u001c8t\u0013\u0011\t\t#a\u0007\u0003\u000f\u0005#GMR5mK\"9\u0011Q\u0005\u000bA\u0002\u0005\u001d\u0012!\u00024jY\u0016\u001c\bCBA\u0015\u0003g\t9B\u0004\u0003\u0002,\u0005=bbA1\u0002.%\tq&C\u0002\u000229\nq\u0001]1dW\u0006<W-\u0003\u0003\u00026\u0005]\"aA*fc*\u0019\u0011\u0011\u0007\u0018\u0002i\rDWmY6G_J\fE\rZ3e\r&dWm\u001d+iCR\u001c\u0006n\\;mI\"\u000bg/\u001a\"fK:\u0014V-\u00193Cs\u000e+(O]3oiRCh.\u0001\u0018dQ\u0016\u001c7NR8s\t\u0016dW\r^3e\r&dWm]!hC&t7\u000f^\"veJ,g\u000e\u001e+y]J+\u0017\r\u001a$jY\u0016\u001c\u0018!M2iK\u000e\\gi\u001c:EK2,G/\u001a3GS2,7/Q4bS:\u001cHoQ;se\u0016tG\u000f\u0016=o\t\u0016dW\r^3e\r&dWm]\u0001@G\",7m\u001b$peV\u0003H-\u0019;fI\u0006\u0003\b\u000f\\5dCRLwN\u001c+sC:\u001c\u0018m\u0019;j_:LEm\u001d+iCR\u001cUO\u001d:f]R$\u0006P\u001c#fa\u0016tGm](o\u0003u\u0019\u0007.Z2l\u0013\u001a$u.\\1j]6+G/\u00193bi\u0006\u001cuN\u001c4mS\u000e$\u0018!\u0007:fCN\u001c\u0018n\u001a8Pm\u0016\u0014H.\u00199qS:<'k\\<JIN\f\u0011D]3bgNLwM\u001c*po\u000e{W.\\5u-\u0016\u00148/[8og\u0006Ir-\u001a;Qe\u0016$H/\u001f)beRLG/[8o\u001b\u0016\u001c8/Y4f)\rq\u00161\n\u0005\b\u0003\u001bb\u0002\u0019AA(\u0003=\u0001\u0018M\u001d;ji&|gNV1mk\u0016\u001c\b#B0\u0002Rys\u0016bAA*Q\n\u0019Q*\u00199\u0002\u0015I,7m\u001c:e)&lW-\u0006\u0003\u0002Z\u0005\u0005D\u0003BA.\u0003{\"B!!\u0018\u0002tA!\u0011qLA1\u0019\u0001!q!a\u0019\u001e\u0005\u0004\t)GA\u0001U#\u0011\t9'!\u001c\u0011\u00075\nI'C\u0002\u0002l9\u0012qAT8uQ&tw\rE\u0002.\u0003_J1!!\u001d/\u0005\r\te.\u001f\u0005\t\u0003kjB\u00111\u0001\u0002x\u0005\ta\rE\u0003.\u0003s\ni&C\u0002\u0002|9\u0012\u0001\u0002\u00102z]\u0006lWM\u0010\u0005\u0007\u0003\u007fj\u0002\u0019\u00010\u0002\u000bAD\u0017m]3\u0002\u00151|w-T3ue&\u001c7/A\u0005m_\u001e\u0004&/\u001a4jqV\ta\f")
public class ConflictChecker
implements DeltaLogging {
    private WinningCommitSummary winningCommitSummary;
    private String logPrefix;
    private final SparkSession spark;
    private final CurrentTransactionInfo initialCurrentTransactionInfo;
    private final long winningCommitVersion;
    private final IsolationLevel isolationLevel;
    private final long startTimeMs;
    private final HashMap<String, Object> timingStats;
    private final DeltaLog deltaLog;
    private CurrentTransactionInfo currentTransactionInfo;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public long startTimeMs() {
        return this.startTimeMs;
    }

    public HashMap<String, Object> timingStats() {
        return this.timingStats;
    }

    public DeltaLog deltaLog() {
        return this.deltaLog;
    }

    public CurrentTransactionInfo currentTransactionInfo() {
        return this.currentTransactionInfo;
    }

    public void currentTransactionInfo_$eq(CurrentTransactionInfo x$1) {
        this.currentTransactionInfo = x$1;
    }

    private WinningCommitSummary winningCommitSummary$lzycompute() {
        ConflictChecker conflictChecker = this;
        synchronized (conflictChecker) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.winningCommitSummary = this.createWinningCommitSummary();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.winningCommitSummary;
    }

    public WinningCommitSummary winningCommitSummary() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.winningCommitSummary$lzycompute();
        }
        return this.winningCommitSummary;
    }

    public CurrentTransactionInfo checkConflicts() {
        this.checkProtocolCompatibility();
        this.checkNoMetadataUpdates();
        this.checkForAddedFilesThatShouldHaveBeenReadByCurrentTxn();
        this.checkForDeletedFilesAgainstCurrentTxnReadFiles();
        this.checkForDeletedFilesAgainstCurrentTxnDeletedFiles();
        this.checkForUpdatedApplicationTransactionIdsThatCurrentTxnDependsOn();
        this.reassignOverlappingRowIds();
        this.reassignRowCommitVersions();
        this.checkIfDomainMetadataConflict();
        this.logMetrics();
        return this.currentTransactionInfo();
    }

    public WinningCommitSummary createWinningCommitSummary() {
        return (WinningCommitSummary)this.recordTime("initialize-old-commit", (Function0 & Serializable & scala.Serializable)() -> {
            Seq winningCommitActions = (Seq)this.deltaLog().store().read(FileNames$.MODULE$.deltaFile(this.deltaLog().logPath(), $this.winningCommitVersion), this.deltaLog().newDeltaHadoopConf()).map((Function1 & Serializable & scala.Serializable)json -> Action$.MODULE$.fromJson((String)json), Seq$.MODULE$.canBuildFrom());
            return new WinningCommitSummary((Seq<Action>)winningCommitActions, $this.winningCommitVersion);
        });
    }

    public void checkProtocolCompatibility() {
        Protocol readProtocol;
        Protocol currentProtocol;
        if (this.winningCommitSummary().protocol().nonEmpty()) {
            Protocol readProtocol2;
            this.winningCommitSummary().protocol().foreach((Function1 & Serializable & scala.Serializable)p -> {
                ConflictChecker.$anonfun$checkProtocolCompatibility$1(this, p);
                return BoxedUnit.UNIT;
            });
            if (this.currentTransactionInfo().actions().exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ConflictChecker.$anonfun$checkProtocolCompatibility$2(x$4)))) {
                throw DeltaErrors$.MODULE$.protocolChangedException(this.winningCommitSummary().commitInfo());
            }
            Protocol winningProtocol = (Protocol)this.winningCommitSummary().protocol().get();
            boolean isWinnerDroppingFeatures = TableFeature$.MODULE$.isProtocolRemovingExplicitFeatures(winningProtocol, readProtocol2 = this.currentTransactionInfo().readSnapshot().protocol());
            if (isWinnerDroppingFeatures) {
                throw DeltaErrors$.MODULE$.protocolChangedException(this.winningCommitSummary().commitInfo());
            }
        }
        if (TableFeature$.MODULE$.isProtocolRemovingExplicitFeatures(currentProtocol = this.currentTransactionInfo().protocol(), readProtocol = this.currentTransactionInfo().readSnapshot().protocol())) {
            Snapshot winningSnapshot = this.deltaLog().getSnapshotAt(this.winningCommitSummary().commitVersion(), this.deltaLog().getSnapshotAt$default$2());
            boolean isDowngradeCommitValid = TableFeature$.MODULE$.validateFeatureRemovalAtSnapshot(currentProtocol, readProtocol, winningSnapshot);
            if (!isDowngradeCommitValid) {
                throw DeltaErrors$.MODULE$.dropTableFeatureConflictRevalidationFailed(this.winningCommitSummary().commitInfo());
            }
            return;
        }
    }

    public void checkNoMetadataUpdates() {
        if (this.winningCommitSummary().metadataUpdates().nonEmpty()) {
            throw DeltaErrors$.MODULE$.metadataChangedException(this.winningCommitSummary().commitInfo());
        }
    }

    public Option<AddFile> getFirstFileMatchingPartitionPredicates(Seq<AddFile> files) {
        Dataset<Row> filesDf = package$.MODULE$.RichAddFileSeq(files).toDF(this.spark);
        Tuple2 tuple2 = this.currentTransactionInfo().readPredicates().partition((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.shouldRewriteFilter()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq rewrites = (Seq)tuple2._1();
        Seq nonRewrites = (Seq)tuple2._2();
        Set canonicalRewrites = (Set)ExpressionSet$.MODULE$.apply((TraversableOnce)rewrites.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.partitionPredicate(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)e -> new DeltaTableReadPredicate((Seq<Expression>)((Seq)new .colon.colon(e, (List)Nil$.MODULE$)), DeltaTableReadPredicate$.MODULE$.apply$default$2(), DeltaTableReadPredicate$.MODULE$.apply$default$3()), Set$.MODULE$.canBuildFrom());
        Set canonicalNonRewrites = (Set)ExpressionSet$.MODULE$.apply((TraversableOnce)nonRewrites.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.partitionPredicate(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)e -> {
            Seq x$1 = (Seq)new .colon.colon(e, (List)Nil$.MODULE$);
            boolean x$2 = false;
            Seq<Expression> x$3 = DeltaTableReadPredicate$.MODULE$.apply$default$2();
            return new DeltaTableReadPredicate((Seq<Expression>)x$1, x$3, x$2);
        }, Set$.MODULE$.canBuildFrom());
        Set canonicalPredicates = canonicalRewrites.$plus$plus((GenTraversableOnce)canonicalNonRewrites);
        AddFile[] filesMatchingPartitionPredicates = (AddFile[])canonicalPredicates.iterator().flatMap((Function1 & Serializable & scala.Serializable)readPredicate -> {
            StructType x$4 = this.currentTransactionInfo().partitionSchemaAtReadTime();
            Dataset x$5 = filesDf;
            Seq<Expression> x$6 = readPredicate.partitionPredicates();
            boolean x$7 = readPredicate.shouldRewriteFilter();
            Seq<String> x$8 = DeltaLog$.MODULE$.filterFileList$default$4();
            return Option$.MODULE$.option2Iterable(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])DeltaLog$.MODULE$.filterFileList(x$4, (Dataset<Row>)x$5, x$6, x$8, x$7).as(package$.MODULE$.addFileEncoder()).head(1))).headOption());
        }).take(1).toArray(ClassTag$.MODULE$.apply(AddFile.class));
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filesMatchingPartitionPredicates)).headOption();
    }

    public void checkForAddedFilesThatShouldHaveBeenReadByCurrentTxn() {
        this.recordTime("checked-appends", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq seq;
            IsolationLevel isolationLevel = $this.isolationLevel;
            if (WriteSerializable$.MODULE$.equals(isolationLevel) && !this.currentTransactionInfo().metadataChanged()) {
                seq = this.winningCommitSummary().changedDataAddedFiles();
            } else if (Serializable$.MODULE$.equals(isolationLevel) ? true : WriteSerializable$.MODULE$.equals(isolationLevel)) {
                seq = (Seq)this.winningCommitSummary().changedDataAddedFiles().$plus$plus(this.winningCommitSummary().blindAppendAddedFiles(), Seq$.MODULE$.canBuildFrom());
            } else if (SnapshotIsolation$.MODULE$.equals(isolationLevel)) {
                seq = (Seq)Nil$.MODULE$;
            } else {
                throw new MatchError((Object)isolationLevel);
            }
            Seq addedFilesToCheckForConflicts = seq;
            Option<AddFile> fileMatchingPartitionReadPredicates = this.getFirstFileMatchingPartitionPredicates(addedFilesToCheckForConflicts);
            if (fileMatchingPartitionReadPredicates.nonEmpty()) {
                IsolationLevel isolationLevel2 = $this.isolationLevel;
                WriteSerializable$ writeSerializable$ = WriteSerializable$.MODULE$;
                boolean isWriteSerializable = !(isolationLevel2 != null ? !isolationLevel2.equals(writeSerializable$) : writeSerializable$ != null);
                None$ retryMsg = isWriteSerializable && this.winningCommitSummary().onlyAddFiles() && this.winningCommitSummary().isBlindAppendOption().isEmpty() ? new Some((Object)"Upgrading all your concurrent writers to use the latest Delta Lake may avoid this error. Please upgrade and then retry this operation again.") : None$.MODULE$;
                throw DeltaErrors$.MODULE$.concurrentAppendException(this.winningCommitSummary().commitInfo(), this.getPrettyPartitionMessage(((AddFile)fileMatchingPartitionReadPredicates.get()).partitionValues()), (Option<String>)retryMsg);
            }
        });
    }

    public void checkForDeletedFilesAgainstCurrentTxnReadFiles() {
        this.recordTime("checked-deletes", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Map readFilePaths = ((TraversableOnce)this.currentTransactionInfo().readFiles().map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.path()), f.partitionValues()), scala.collection.immutable.Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            Option deleteReadOverlap = this.winningCommitSummary().removedFiles().find((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)readFilePaths.contains((Object)r.path())));
            if (deleteReadOverlap.nonEmpty()) {
                String filePath = ((RemoveFile)deleteReadOverlap.get()).path();
                String partition = this.getPrettyPartitionMessage((Map<String, String>)((Map)readFilePaths.apply((Object)filePath)));
                throw DeltaErrors$.MODULE$.concurrentDeleteReadException(this.winningCommitSummary().commitInfo(), new StringBuilder(4).append(filePath).append(" in ").append(partition).toString());
            }
            if (this.winningCommitSummary().removedFiles().nonEmpty() && this.currentTransactionInfo().readWholeTable()) {
                String filePath = ((RemoveFile)this.winningCommitSummary().removedFiles().head()).path();
                throw DeltaErrors$.MODULE$.concurrentDeleteReadException(this.winningCommitSummary().commitInfo(), String.valueOf(filePath));
            }
        });
    }

    public void checkForDeletedFilesAgainstCurrentTxnDeletedFiles() {
        this.recordTime("checked-2x-deletes", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            scala.collection.immutable.Set txnDeletes = ((TraversableOnce)((TraversableLike)this.currentTransactionInfo().actions().collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends Action, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof RemoveFile) {
                        RemoveFile removeFile = (RemoveFile)A1;
                        return (B1)removeFile;
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Action x1) {
                    Action action = x1;
                    return action instanceof RemoveFile;
                }
            }, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.path(), Seq$.MODULE$.canBuildFrom())).toSet();
            scala.collection.immutable.Set deleteOverlap = (scala.collection.immutable.Set)((TraversableOnce)this.winningCommitSummary().removedFiles().map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.path(), Seq$.MODULE$.canBuildFrom())).toSet().intersect((GenSet)txnDeletes);
            if (deleteOverlap.nonEmpty()) {
                throw DeltaErrors$.MODULE$.concurrentDeleteDeleteException(this.winningCommitSummary().commitInfo(), (String)deleteOverlap.head());
            }
        });
    }

    public void checkForUpdatedApplicationTransactionIdsThatCurrentTxnDependsOn() {
        if (this.winningCommitSummary().appLevelTransactions().exists((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ConflictChecker.$anonfun$checkForUpdatedApplicationTransactionIdsThatCurrentTxnDependsOn$1(this, x$10)))) {
            throw DeltaErrors$.MODULE$.concurrentTransactionException(this.winningCommitSummary().commitInfo());
        }
    }

    private void checkIfDomainMetadataConflict() {
        if (!DomainMetadataUtils$.MODULE$.domainMetadataSupported(this.currentTransactionInfo().protocol())) {
            return;
        }
        Map<String, DomainMetadata> winningDomainMetadataMap = DomainMetadataUtils$.MODULE$.extractDomainMetadatasMap(this.winningCommitSummary().actions());
        Buffer mergedDomainMetadata = (Buffer)Buffer$.MODULE$.empty();
        Seq updatedActions = (Seq)this.currentTransactionInfo().actions().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Action action = x0$1;
            if (action instanceof DomainMetadata) {
                DomainMetadata domainMetadata = (DomainMetadata)action;
                DomainMetadata mergedAction = ConflictChecker.resolveConflict$1(domainMetadata, winningDomainMetadataMap);
                mergedDomainMetadata.$plus$eq((Object)mergedAction);
                return mergedAction;
            }
            return action;
        }, Seq$.MODULE$.canBuildFrom());
        CurrentTransactionInfo qual$1 = this.currentTransactionInfo();
        Seq x$1 = mergedDomainMetadata.toSeq();
        Seq x$2 = updatedActions;
        String x$3 = qual$1.copy$default$1();
        Seq<DeltaTableReadPredicate> x$4 = qual$1.copy$default$2();
        scala.collection.immutable.Set<AddFile> x$5 = qual$1.copy$default$3();
        boolean x$6 = qual$1.copy$default$4();
        scala.collection.immutable.Set<String> x$7 = qual$1.copy$default$5();
        Metadata x$8 = qual$1.copy$default$6();
        Protocol x$9 = qual$1.copy$default$7();
        Snapshot x$10 = qual$1.copy$default$9();
        Option<CommitInfo> x$11 = qual$1.copy$default$10();
        long x$12 = qual$1.copy$default$11();
        this.currentTransactionInfo_$eq(qual$1.copy(x$3, x$4, x$5, x$6, x$7, x$8, x$9, (Seq<Action>)x$2, x$10, x$11, x$12, (Seq<DomainMetadata>)x$1));
    }

    private void reassignOverlappingRowIds() {
        if (!RowId$.MODULE$.isSupported(this.currentTransactionInfo().protocol())) {
            return;
        }
        long readHighWaterMark = this.currentTransactionInfo().readRowIdHighWatermark();
        long winningHighWaterMark = BoxesRunTime.unboxToLong((Object)this.winningCommitSummary().actions().collectFirst((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Action, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Option<RowId.RowTrackingMetadataDomain> option = RowId$RowTrackingMetadataDomain$.MODULE$.unapply(A1);
                if (!option.isEmpty()) {
                    RowId.RowTrackingMetadataDomain domain = (RowId.RowTrackingMetadataDomain)option.get();
                    return (B1)BoxesRunTime.boxToLong((long)domain.rowIdHighWaterMark());
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Action x1) {
                Action action = x1;
                Option<RowId.RowTrackingMetadataDomain> option = RowId$RowTrackingMetadataDomain$.MODULE$.unapply(action);
                return !option.isEmpty();
            }
        }).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> readHighWaterMark));
        LongRef highWaterMark = LongRef.create((long)winningHighWaterMark);
        Seq actionsWithReassignedRowIds = (Seq)this.currentTransactionInfo().actions().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DomainMetadata domainMetadata;
            AddFile addFile;
            Action action = x0$1;
            if (action instanceof AddFile && !(addFile = (AddFile)action).baseRowId().exists((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$11 -> x$11 <= readHighWaterMark)) {
                long newBaseRowId = highWaterMark$1.elem + 1L;
                highWaterMark$1.elem += BoxesRunTime.unboxToLong((Object)addFile.numPhysicalRecords().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw DeltaErrors$.MODULE$.rowIdAssignmentWithoutStats();
                }));
                Some x$1 = new Some((Object)BoxesRunTime.boxToLong((long)newBaseRowId));
                String x$2 = addFile.copy$default$1();
                Map<String, String> x$3 = addFile.copy$default$2();
                long x$4 = addFile.copy$default$3();
                long x$5 = addFile.copy$default$4();
                boolean x$6 = addFile.copy$default$5();
                String x$7 = addFile.copy$default$6();
                Map<String, String> x$8 = addFile.copy$default$7();
                DeletionVectorDescriptor x$9 = addFile.copy$default$8();
                Option<Object> x$10 = addFile.copy$default$10();
                return Option$.MODULE$.option2Iterable((Option)new Some((Object)addFile.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, (Option<Object>)x$1, x$10)));
            }
            if (action instanceof DomainMetadata && RowId$RowTrackingMetadataDomain$.MODULE$.isRowTrackingDomain(domainMetadata = (DomainMetadata)action)) {
                return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return Option$.MODULE$.option2Iterable((Option)new Some((Object)action));
        }, Seq$.MODULE$.canBuildFrom());
        CurrentTransactionInfo qual$1 = this.currentTransactionInfo();
        DomainMetadata domainMetadata = new RowId.RowTrackingMetadataDomain(highWaterMark.elem).toDomainMetadata(ManifestFactory$.MODULE$.Nothing());
        Seq x$11 = (Seq)actionsWithReassignedRowIds.$plus$colon((Object)domainMetadata, Seq$.MODULE$.canBuildFrom());
        long x$12 = winningHighWaterMark;
        String x$13 = qual$1.copy$default$1();
        Seq<DeltaTableReadPredicate> x$14 = qual$1.copy$default$2();
        scala.collection.immutable.Set<AddFile> x$15 = qual$1.copy$default$3();
        boolean x$16 = qual$1.copy$default$4();
        scala.collection.immutable.Set<String> x$17 = qual$1.copy$default$5();
        Metadata x$18 = qual$1.copy$default$6();
        Protocol x$19 = qual$1.copy$default$7();
        Snapshot x$20 = qual$1.copy$default$9();
        Option<CommitInfo> x$21 = qual$1.copy$default$10();
        Seq<DomainMetadata> x$22 = qual$1.copy$default$12();
        this.currentTransactionInfo_$eq(qual$1.copy(x$13, x$14, x$15, x$16, x$17, x$18, x$19, (Seq<Action>)x$11, x$20, x$21, x$12, x$22));
    }

    private void reassignRowCommitVersions() {
        if (!RowTracking$.MODULE$.isSupported(this.currentTransactionInfo().protocol())) {
            return;
        }
        Seq newActions = (Seq)this.currentTransactionInfo().actions().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            boolean bl = false;
            AddFile addFile = null;
            Action action = x0$1;
            if (action instanceof AddFile) {
                bl = true;
                addFile = (AddFile)action;
                if (addFile.defaultRowCommitVersion().contains((Object)BoxesRunTime.boxToLong((long)$this.winningCommitVersion))) {
                    Some x$1 = new Some((Object)BoxesRunTime.boxToLong((long)($this.winningCommitVersion + 1L)));
                    String x$2 = addFile.copy$default$1();
                    Map<String, String> x$3 = addFile.copy$default$2();
                    long x$4 = addFile.copy$default$3();
                    long x$5 = addFile.copy$default$4();
                    boolean x$6 = addFile.copy$default$5();
                    String x$7 = addFile.copy$default$6();
                    Map<String, String> x$8 = addFile.copy$default$7();
                    DeletionVectorDescriptor x$9 = addFile.copy$default$8();
                    Option<Object> x$10 = addFile.copy$default$9();
                    return addFile.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, (Option<Object>)x$1);
                }
            }
            if (bl && addFile.defaultRowCommitVersion().isEmpty()) {
                Some x$11 = new Some((Object)BoxesRunTime.boxToLong((long)($this.winningCommitVersion + 1L)));
                String x$12 = addFile.copy$default$1();
                Map<String, String> x$13 = addFile.copy$default$2();
                long x$14 = addFile.copy$default$3();
                long x$15 = addFile.copy$default$4();
                boolean x$16 = addFile.copy$default$5();
                String x$17 = addFile.copy$default$6();
                Map<String, String> x$18 = addFile.copy$default$7();
                DeletionVectorDescriptor x$19 = addFile.copy$default$8();
                Option<Object> x$20 = addFile.copy$default$9();
                return addFile.copy(x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, (Option<Object>)x$11);
            }
            return action;
        }, Seq$.MODULE$.canBuildFrom());
        CurrentTransactionInfo qual$1 = this.currentTransactionInfo();
        Seq x$21 = newActions;
        String x$22 = qual$1.copy$default$1();
        Seq<DeltaTableReadPredicate> x$23 = qual$1.copy$default$2();
        scala.collection.immutable.Set<AddFile> x$24 = qual$1.copy$default$3();
        boolean x$25 = qual$1.copy$default$4();
        scala.collection.immutable.Set<String> x$26 = qual$1.copy$default$5();
        Metadata x$27 = qual$1.copy$default$6();
        Protocol x$28 = qual$1.copy$default$7();
        Snapshot x$29 = qual$1.copy$default$9();
        Option<CommitInfo> x$30 = qual$1.copy$default$10();
        long x$31 = qual$1.copy$default$11();
        Seq<DomainMetadata> x$32 = qual$1.copy$default$12();
        this.currentTransactionInfo_$eq(qual$1.copy(x$22, x$23, x$24, x$25, x$26, x$27, x$28, (Seq<Action>)x$21, x$29, x$30, x$31, x$32));
    }

    public String getPrettyPartitionMessage(Map<String, String> partitionValues) {
        StructType partitionColumns = this.currentTransactionInfo().partitionSchemaAtReadTime();
        if (partitionColumns.isEmpty()) {
            return "the root of the table";
        }
        String partition = ((TraversableOnce)partitionColumns.map((Function1 & Serializable & scala.Serializable)field -> new StringBuilder(1).append(field.name()).append("=").append(partitionValues.apply((Object)DeltaColumnMapping$.MODULE$.getPhysicalName((StructField)field))).toString(), Seq$.MODULE$.canBuildFrom())).mkString("[", ", ", "]");
        return new StringBuilder(10).append("partition ").append(partition).toString();
    }

    public <T> T recordTime(String phase, Function0<T> f) {
        long startTimeNs = System.nanoTime();
        Object ret = f.apply();
        long timeTakenMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimeNs);
        this.timingStats().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)phase), (Object)BoxesRunTime.boxToLong((long)timeTakenMs)));
        return (T)ret;
    }

    public void logMetrics() {
        long totalTimeTakenMs = System.currentTimeMillis() - this.startTimeMs();
        String timingStr = ((TraversableOnce)((TraversableLike)this.timingStats().keys().toSeq().sorted((Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable & scala.Serializable)k -> new StringBuilder(1).append((String)k).append("=").append(this.timingStats().apply(k)).toString(), Seq$.MODULE$.canBuildFrom())).mkString(",");
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("[").append(this.logPrefix()).append("] Timing stats against ").append($this.winningCommitVersion).append(" ").append("[").append(timingStr).append(", totalTimeTakenMs: ").append(totalTimeTakenMs).append("]").toString());
    }

    private String logPrefix$lzycompute() {
        ConflictChecker conflictChecker = this;
        synchronized (conflictChecker) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logPrefix = new StringBuilder(18).append("[tableId=").append(ConflictChecker.truncate$1(this.initialCurrentTransactionInfo.readSnapshot().metadata().id())).append(",").append("txnId=").append(ConflictChecker.truncate$1(this.initialCurrentTransactionInfo.txnId())).append("] ").toString();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.logPrefix;
    }

    public String logPrefix() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.logPrefix$lzycompute();
        }
        return this.logPrefix;
    }

    public static final /* synthetic */ void $anonfun$checkProtocolCompatibility$1(ConflictChecker $this, Protocol p) {
        $this.deltaLog().protocolRead(p);
        $this.deltaLog().protocolWrite(p);
        CurrentTransactionInfo qual$1 = $this.currentTransactionInfo();
        Protocol x$1 = p;
        String x$2 = qual$1.copy$default$1();
        Seq<DeltaTableReadPredicate> x$3 = qual$1.copy$default$2();
        scala.collection.immutable.Set<AddFile> x$4 = qual$1.copy$default$3();
        boolean x$5 = qual$1.copy$default$4();
        scala.collection.immutable.Set<String> x$6 = qual$1.copy$default$5();
        Metadata x$7 = qual$1.copy$default$6();
        Seq<Action> x$8 = qual$1.copy$default$8();
        Snapshot x$9 = qual$1.copy$default$9();
        Option<CommitInfo> x$10 = qual$1.copy$default$10();
        long x$11 = qual$1.copy$default$11();
        Seq<DomainMetadata> x$12 = qual$1.copy$default$12();
        $this.currentTransactionInfo_$eq(qual$1.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$1, x$8, x$9, x$10, x$11, x$12));
    }

    public static final /* synthetic */ boolean $anonfun$checkProtocolCompatibility$2(Action x$4) {
        return x$4 instanceof Protocol;
    }

    public static final /* synthetic */ boolean $anonfun$checkForUpdatedApplicationTransactionIdsThatCurrentTxnDependsOn$1(ConflictChecker $this, SetTransaction x$10) {
        return $this.currentTransactionInfo().isConflict(x$10);
    }

    private static final DomainMetadata resolveConflict$1(DomainMetadata domainMetadataFromCurrentTransaction, Map winningDomainMetadataMap$1) {
        Option option;
        DomainMetadata domain;
        Tuple2 tuple2 = new Tuple2((Object)domainMetadataFromCurrentTransaction, (Object)winningDomainMetadataMap$1.get((Object)domainMetadataFromCurrentTransaction.domain()));
        if (tuple2 != null) {
            DomainMetadata domain2 = (DomainMetadata)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option2)) {
                return domain2;
            }
        }
        if (tuple2 != null && RowId$RowTrackingMetadataDomain$.MODULE$.isRowTrackingDomain(domain = (DomainMetadata)tuple2._1())) {
            return domain;
        }
        if (tuple2 != null && (option = (Option)tuple2._2()) instanceof Some) {
            throw new ConcurrentTransactionException(new StringBuilder(40).append("A conflicting metadata domain ").append(domainMetadataFromCurrentTransaction.domain()).append(" is ").append("added.").toString());
        }
        throw new MatchError((Object)tuple2);
    }

    private static final String truncate$1(String uuid) {
        return (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])uuid.split("-"))).head();
    }

    public ConflictChecker(SparkSession spark, CurrentTransactionInfo initialCurrentTransactionInfo, long winningCommitVersion, IsolationLevel isolationLevel) {
        this.spark = spark;
        this.initialCurrentTransactionInfo = initialCurrentTransactionInfo;
        this.winningCommitVersion = winningCommitVersion;
        this.isolationLevel = isolationLevel;
        Logging.$init$((Logging)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
        this.startTimeMs = System.currentTimeMillis();
        this.timingStats = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.deltaLog = initialCurrentTransactionInfo.readSnapshot().deltaLog();
        this.currentTransactionInfo = initialCurrentTransactionInfo;
    }
}

