/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import java.io.FileNotFoundException;
import java.io.Serializable;
import java.net.URL;
import org.apache.spark.ErrorClassesJsonReader;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.util.matching.Regex;

public final class DeltaThrowableHelper$ {
    public static DeltaThrowableHelper$ MODULE$;
    private URL sparkErrorClassSource;
    private final ErrorClassesJsonReader errorClassReader;
    private volatile boolean bitmap$0;

    static {
        new DeltaThrowableHelper$();
    }

    private URL safeGetErrorClassesSource(String sourceFile) {
        ClassLoader classLoader = Utils$.MODULE$.getContextOrSparkClassLoader();
        return (URL)Option$.MODULE$.apply((Object)classLoader.getResource(sourceFile)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new FileNotFoundException(new StringBuilder(79).append("Cannot find the error class definition file on path ").append(sourceFile).append("\" through the ").append("class loader ").append(classLoader.toString()).toString());
        });
    }

    private URL sparkErrorClassSource$lzycompute() {
        DeltaThrowableHelper$ deltaThrowableHelper$ = this;
        synchronized (deltaThrowableHelper$) {
            if (!this.bitmap$0) {
                this.sparkErrorClassSource = this.safeGetErrorClassesSource("error/error-classes.json");
                this.bitmap$0 = true;
            }
        }
        return this.sparkErrorClassSource;
    }

    public URL sparkErrorClassSource() {
        if (!this.bitmap$0) {
            return this.sparkErrorClassSource$lzycompute();
        }
        return this.sparkErrorClassSource;
    }

    public URL deltaErrorClassSource() {
        return this.safeGetErrorClassesSource("error/delta-error-classes.json");
    }

    private ErrorClassesJsonReader errorClassReader() {
        return this.errorClassReader;
    }

    public String getMessage(String errorClass, String[] messageParameters) {
        String template = this.errorClassReader().getMessageTemplate(errorClass);
        String message = String.format(template.replaceAll("<[a-zA-Z0-9_-]+>", "%s"), messageParameters);
        return new StringBuilder(3).append("[").append(errorClass).append("] ").append(message).toString();
    }

    public String getSqlState(String errorClass) {
        return this.errorClassReader().getSqlState(errorClass);
    }

    public boolean isInternalError(String errorClass) {
        String string = errorClass;
        String string2 = "INTERNAL_ERROR";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public String[] getParameterNames(String errorClass, String errorSubClass) {
        String wholeErrorClass = errorSubClass == null ? errorClass : new StringBuilder(1).append(errorClass).append(".").append(errorSubClass).toString();
        String parameterizedMessage = this.errorClassReader().getMessageTemplate(wholeErrorClass);
        Regex pattern = new StringOps(Predef$.MODULE$.augmentString("<[a-zA-Z0-9_-]+>")).r();
        Regex.MatchIterator matches = pattern.findAllIn((CharSequence)parameterizedMessage);
        String[] parameterSeq = (String[])matches.toArray(ClassTag$.MODULE$.apply(String.class));
        String[] parameterNames = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parameterSeq)).map((Function1 & Serializable & scala.Serializable)p -> new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(p)).stripPrefix("<"))).stripSuffix(">"), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        return parameterNames;
    }

    private DeltaThrowableHelper$() {
        MODULE$ = this;
        this.errorClassReader = new ErrorClassesJsonReader((Seq)new .colon.colon((Object)this.deltaErrorClassSource(), (List)new .colon.colon((Object)this.sparkErrorClassSource(), (List)Nil$.MODULE$)));
    }
}

