/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.delta.ColumnMappingTableFeature$;
import org.apache.spark.sql.delta.DeletionVectorsTableFeature$;
import org.apache.spark.sql.delta.DeltaColumnMapping$;
import org.apache.spark.sql.delta.DeltaColumnMappingMode;
import org.apache.spark.sql.delta.DeltaConfig;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.IdMapping$;
import org.apache.spark.sql.delta.NameMapping$;
import org.apache.spark.sql.delta.RequiredDeltaTableProperty;
import org.apache.spark.sql.delta.TableFeature;
import org.apache.spark.sql.delta.UniversalFormat$;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.Format;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.actions.Protocol$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.schema.SchemaUtils$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.SetLike;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class IcebergCompatV1$
implements DeltaLogging {
    public static IcebergCompatV1$ MODULE$;
    private final Seq<ColumnMappingTableFeature$> REQUIRED_TABLE_FEATURES;
    private final Seq<DeletionVectorsTableFeature$> INCOMPATIBLE_TABLE_FEATURES;
    private final Seq<RequiredDeltaTableProperty<DeltaColumnMappingMode>> REQUIRED_DELTA_TABLE_PROPERTIES;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new IcebergCompatV1$();
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Seq<ColumnMappingTableFeature$> REQUIRED_TABLE_FEATURES() {
        return this.REQUIRED_TABLE_FEATURES;
    }

    public Seq<DeletionVectorsTableFeature$> INCOMPATIBLE_TABLE_FEATURES() {
        return this.INCOMPATIBLE_TABLE_FEATURES;
    }

    public Seq<RequiredDeltaTableProperty<DeltaColumnMappingMode>> REQUIRED_DELTA_TABLE_PROPERTIES() {
        return this.REQUIRED_DELTA_TABLE_PROPERTIES;
    }

    public boolean isEnabled(Metadata metadata) {
        return BoxesRunTime.unboxToBoolean((Object)DeltaConfigs$.MODULE$.ICEBERG_COMPAT_V1_ENABLED().fromMetaData(metadata).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
    }

    public Tuple2<Option<Protocol>, Option<Metadata>> enforceInvariantsAndDependencies(Protocol prevProtocol, Metadata prevMetadata, Protocol newestProtocol, Metadata newestMetadata, boolean isCreatingNewTable, Seq<Action> actions) {
        boolean bl;
        boolean wasEnabled = this.isEnabled(prevMetadata);
        boolean isEnabled = this.isEnabled(newestMetadata);
        String tableId = newestMetadata.id();
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(wasEnabled, isEnabled);
        if (sp2 != null) {
            boolean bl2 = sp2._1$mcZ$sp();
            boolean bl3 = sp2._2$mcZ$sp();
            if (!bl2 && !bl3) {
                return new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
            }
        }
        if (sp2 != null) {
            boolean bl4 = sp2._1$mcZ$sp();
            boolean bl5 = sp2._2$mcZ$sp();
            if (bl4 && !bl5) {
                Predef$.MODULE$.assert(!UniversalFormat$.MODULE$.icebergEnabled(newestMetadata));
                return new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
            }
        }
        if (sp2 != null && (bl = sp2._2$mcZ$sp())) {
            None$ none$;
            None$ protocolResult;
            None$ none$2;
            Set tblFeatureUpdates = Set$.MODULE$.empty();
            scala.collection.mutable.Map tblPropertyUpdates = Map$.MODULE$.empty();
            if (prevMetadata.partitionColumns().nonEmpty()) {
                Seq<String> seq = prevMetadata.partitionColumns();
                Seq<String> seq2 = newestMetadata.partitionColumns();
                if (seq == null ? seq2 != null : !seq.equals(seq2)) {
                    throw DeltaErrors$.MODULE$.icebergCompatV1ReplacePartitionedTableException(prevMetadata.partitionColumns(), newestMetadata.partitionColumns());
                }
            }
            if (SchemaUtils$.MODULE$.typeExistsRecursively((DataType)newestMetadata.schema(), (Function1<DataType, Object>)(Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)IcebergCompatV1$.$anonfun$enforceInvariantsAndDependencies$1(f)))) {
                throw DeltaErrors$.MODULE$.icebergCompatV1UnsupportedDataTypeException(newestMetadata.schema());
            }
            actions.collect((PartialFunction)new scala.Serializable(tableId){
                public static final long serialVersionUID = 0L;
                private final String tableId$1;

                public final <A1 extends Action, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    AddFile addFile;
                    A1 A1 = x1;
                    if (A1 instanceof AddFile && (addFile = (AddFile)A1).numLogicalRecords().isEmpty()) {
                        throw new UnsupportedOperationException(new StringBuilder(129).append("[tableId=").append(this.tableId$1).append("] IcebergCompatV1 requires ").append("all AddFiles to contain the numRecords statistic. AddFile ").append(addFile.path()).append(" is missing ").append("this statistic. Stats: ").append(addFile.stats()).toString());
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Action x1) {
                    AddFile addFile;
                    Action action = x1;
                    return action instanceof AddFile && (addFile = (AddFile)action).numLogicalRecords().isEmpty();
                }
                {
                    this.tableId$1 = tableId$1;
                }
            }, Seq$.MODULE$.canBuildFrom());
            this.REQUIRED_TABLE_FEATURES().foreach((Function1 & Serializable & scala.Serializable)f -> {
                boolean bl;
                Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(prevProtocol.isFeatureSupported((TableFeature)f), newestProtocol.isFeatureSupported((TableFeature)f));
                if (sp2 != null && (bl = sp2._2$mcZ$sp())) {
                    return BoxedUnit.UNIT;
                }
                if (sp2 != null) {
                    boolean bl2 = sp2._1$mcZ$sp();
                    boolean bl3 = sp2._2$mcZ$sp();
                    if (!bl2 && !bl3) {
                        if (isCreatingNewTable) {
                            return tblFeatureUpdates.$plus$eq(f);
                        }
                        throw DeltaErrors$.MODULE$.icebergCompatV1MissingRequiredTableFeatureException((TableFeature)f);
                    }
                }
                if (sp2 != null) {
                    boolean bl4 = sp2._1$mcZ$sp();
                    boolean bl5 = sp2._2$mcZ$sp();
                    if (bl4 && !bl5) {
                        throw DeltaErrors$.MODULE$.icebergCompatV1DisablingRequiredTableFeatureException((TableFeature)f);
                    }
                }
                throw new MatchError((Object)sp2);
            });
            this.INCOMPATIBLE_TABLE_FEATURES().foreach((Function1 & Serializable & scala.Serializable)f -> {
                IcebergCompatV1$.$anonfun$enforceInvariantsAndDependencies$4(newestProtocol, f);
                return BoxedUnit.UNIT;
            });
            this.REQUIRED_DELTA_TABLE_PROPERTIES().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                RequiredDeltaTableProperty requiredDeltaTableProperty = x0$1;
                if (requiredDeltaTableProperty != null) {
                    DeltaConfig deltaConfig = requiredDeltaTableProperty.deltaConfig();
                    Function1 validator = requiredDeltaTableProperty.validator();
                    String autoSetValue = requiredDeltaTableProperty.autoSetValue();
                    DeltaColumnMappingMode newestValue = (DeltaColumnMappingMode)deltaConfig.fromMetaData(newestMetadata);
                    boolean newestValueOkay = BoxesRunTime.unboxToBoolean((Object)validator.apply((Object)newestValue));
                    boolean newestValueExplicitlySet = newestMetadata.configuration().contains((Object)deltaConfig.key());
                    Throwable err = DeltaErrors$.MODULE$.icebergCompatV1WrongRequiredTablePropertyException(deltaConfig.key(), newestValue.toString(), autoSetValue);
                    if (!newestValueOkay) {
                        if (!newestValueExplicitlySet && isCreatingNewTable) {
                            return tblPropertyUpdates.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)deltaConfig.key()), (Object)autoSetValue));
                        }
                        throw err;
                    }
                    return BoxedUnit.UNIT;
                }
                throw new MatchError((Object)requiredDeltaTableProperty);
            });
            if (tblFeatureUpdates.nonEmpty()) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("[tableId=").append(tableId).append("] IcebergCompatV1 auto-supporting table features: ").append(tblFeatureUpdates.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Set$.MODULE$.canBuildFrom())).toString());
                none$2 = new Some((Object)newestProtocol.merge((Seq<Protocol>)((SetLike)tblFeatureUpdates.map((Function1 & Serializable & scala.Serializable)tf -> Protocol$.MODULE$.forTableFeature((TableFeature)tf), Set$.MODULE$.canBuildFrom())).toSeq()));
            } else {
                none$2 = protocolResult = None$.MODULE$;
            }
            if (tblPropertyUpdates.nonEmpty()) {
                Map newConfiguration;
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("[tableId=").append(tableId).append("] IcebergCompatV1 auto-setting table properties: ").append(tblPropertyUpdates).toString());
                Map x$1 = newConfiguration = newestMetadata.configuration().$plus$plus((GenTraversableOnce)tblPropertyUpdates.toMap(Predef$.MODULE$.$conforms()));
                String x$2 = newestMetadata.copy$default$1();
                String x$3 = newestMetadata.copy$default$2();
                String x$4 = newestMetadata.copy$default$3();
                Format x$5 = newestMetadata.copy$default$4();
                String x$6 = newestMetadata.copy$default$5();
                Seq<String> x$7 = newestMetadata.copy$default$6();
                Option<Object> x$8 = newestMetadata.copy$default$8();
                Metadata tmpNewMetadata = newestMetadata.copy(x$2, x$3, x$4, x$5, x$6, x$7, (Map<String, String>)x$1, x$8);
                if (tblPropertyUpdates.contains((Object)DeltaConfigs$.MODULE$.COLUMN_MAPPING_MODE().key())) {
                    Predef$.MODULE$.assert(isCreatingNewTable, (Function0 & Serializable & scala.Serializable)() -> "we only auto-upgrade Column Mapping on new tables");
                    tmpNewMetadata = DeltaColumnMapping$.MODULE$.assignColumnIdAndPhysicalName(tmpNewMetadata, prevMetadata, false, false);
                    DeltaColumnMapping$.MODULE$.checkColumnIdAndPhysicalNameAssignments(tmpNewMetadata);
                }
                none$ = new Some((Object)tmpNewMetadata);
            } else {
                none$ = None$.MODULE$;
            }
            None$ metadataResult = none$;
            return new Tuple2((Object)protocolResult, (Object)metadataResult);
        }
        throw new MatchError((Object)sp2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$REQUIRED_DELTA_TABLE_PROPERTIES$1(DeltaColumnMappingMode mode) {
        DeltaColumnMappingMode deltaColumnMappingMode = mode;
        NameMapping$ nameMapping$ = NameMapping$.MODULE$;
        if (deltaColumnMappingMode == null) {
            if (nameMapping$ == null) return true;
        } else if (deltaColumnMappingMode.equals(nameMapping$)) return true;
        DeltaColumnMappingMode deltaColumnMappingMode2 = mode;
        IdMapping$ idMapping$ = IdMapping$.MODULE$;
        if (deltaColumnMappingMode2 != null) {
            if (!deltaColumnMappingMode2.equals(idMapping$)) return false;
            return true;
        }
        if (idMapping$ == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$enforceInvariantsAndDependencies$1(DataType f) {
        return f instanceof MapType || f instanceof ArrayType || f instanceof NullType;
    }

    public static final /* synthetic */ void $anonfun$enforceInvariantsAndDependencies$4(Protocol newestProtocol$1, DeletionVectorsTableFeature$ f) {
        if (newestProtocol$1.isFeatureSupported(f)) {
            throw DeltaErrors$.MODULE$.icebergCompatV1IncompatibleTableFeatureException(f);
        }
    }

    private IcebergCompatV1$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
        this.REQUIRED_TABLE_FEATURES = (Seq)new .colon.colon((Object)ColumnMappingTableFeature$.MODULE$, (List)Nil$.MODULE$);
        this.INCOMPATIBLE_TABLE_FEATURES = (Seq)new .colon.colon((Object)DeletionVectorsTableFeature$.MODULE$, (List)Nil$.MODULE$);
        this.REQUIRED_DELTA_TABLE_PROPERTIES = (Seq)new .colon.colon(new RequiredDeltaTableProperty<DeltaColumnMappingMode>(DeltaConfigs$.MODULE$.COLUMN_MAPPING_MODE(), (Function1 & Serializable & scala.Serializable)mode -> BoxesRunTime.boxToBoolean((boolean)IcebergCompatV1$.$anonfun$REQUIRED_DELTA_TABLE_PROPERTIES$1(mode)), NameMapping$.MODULE$.name()), (List)Nil$.MODULE$);
    }
}

