/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import java.io.Serializable;
import java.net.URI;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.delta.DeltaParquetFileFormat;
import org.apache.spark.sql.delta.DeltaParquetFileFormat$;
import org.apache.spark.sql.delta.DeltaUDF$;
import org.apache.spark.sql.delta.RowIndexFilterType;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.commands.DeletionVectorUtils$;
import org.apache.spark.sql.delta.files.TahoeFileIndex;
import org.apache.spark.sql.delta.files.TahoeLogFileIndex;
import org.apache.spark.sql.delta.util.DeltaFileOperations$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class ScanWithDeletionVectors$ {
    public static ScanWithDeletionVectors$ MODULE$;

    static {
        new ScanWithDeletionVectors$();
    }

    public Option<LogicalPlan> unapply(LogicalRelation a) {
        BaseRelation relation;
        LogicalRelation logicalRelation = a;
        if (logicalRelation != null && (relation = logicalRelation.relation()) instanceof HadoopFsRelation) {
            HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)relation;
            FileIndex index = hadoopFsRelation.location();
            FileFormat format = hadoopFsRelation.fileFormat();
            if (index instanceof TahoeFileIndex) {
                TahoeFileIndex tahoeFileIndex = (TahoeFileIndex)index;
                if (format instanceof DeltaParquetFileFormat) {
                    DeltaParquetFileFormat deltaParquetFileFormat = (DeltaParquetFileFormat)format;
                    return this.dvEnabledScanFor(logicalRelation, hadoopFsRelation, deltaParquetFileFormat, tahoeFileIndex);
                }
            }
        }
        return None$.MODULE$;
    }

    public Option<LogicalPlan> dvEnabledScanFor(LogicalRelation scan, HadoopFsRelation hadoopRelation, DeltaParquetFileFormat fileFormat, TahoeFileIndex index) {
        if (!DeletionVectorUtils$.MODULE$.deletionVectorsReadable(index.protocol(), index.metadata())) {
            return None$.MODULE$;
        }
        Predef$.MODULE$.require(!(index instanceof TahoeLogFileIndex), (Function0 & Serializable & scala.Serializable)() -> "Cannot work with a non-pinned table snapshot of the TahoeFileIndex");
        if (!DeletionVectorUtils$.MODULE$.deletionVectorsReadable(index.protocol(), index.metadata())) {
            return None$.MODULE$;
        }
        if (fileFormat.hasDeletionVectorMap()) {
            return None$.MODULE$;
        }
        SparkSession spark = (SparkSession)SparkSession$.MODULE$.getActiveSession().get();
        Broadcast<Map<URI, DeltaParquetFileFormat.DeletionVectorDescriptorWithFilterType>> filePathToDVBroadcastMap = this.createBroadcastDVMap(spark, index);
        if (((MapLike)filePathToDVBroadcastMap.value()).isEmpty()) {
            return None$.MODULE$;
        }
        Seq planOutput = scan.output();
        LogicalRelation newScan = this.createScanWithSkipRowColumn(spark, scan, fileFormat, index, filePathToDVBroadcastMap, hadoopRelation);
        Filter rowIndexFilter = this.createRowIndexFilterNode(newScan);
        return new Some((Object)new Project(planOutput, (LogicalPlan)rowIndexFilter));
    }

    private LogicalRelation createScanWithSkipRowColumn(SparkSession spark, LogicalRelation inputScan, DeltaParquetFileFormat fileFormat, TahoeFileIndex tahoeFileIndex, Broadcast<Map<URI, DeltaParquetFileFormat.DeletionVectorDescriptorWithFilterType>> filePathToDVBroadcastMap, HadoopFsRelation hadoopFsRelation) {
        DeltaParquetFileFormat newFileFormat;
        StructField skipRowField = DeltaParquetFileFormat$.MODULE$.IS_ROW_DELETED_STRUCT_FIELD();
        String x$1 = skipRowField.name();
        DataType x$2 = skipRowField.dataType();
        boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, x$2, x$3, x$4);
        Seq x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, x$2, x$3, x$4);
        Seq newScanOutput = (Seq)inputScan.output().$colon$plus((Object)new AttributeReference(x$1, x$2, x$3, x$4, x$5, x$6), Seq$.MODULE$.canBuildFrom());
        StructType newDataSchema = hadoopFsRelation.dataSchema().add(skipRowField);
        Broadcast hadoopConfBroadcast = spark.sparkContext().broadcast((Object)new SerializableConfiguration(tahoeFileIndex.deltaLog().newDeltaHadoopConf()), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        DeltaParquetFileFormat x$7 = newFileFormat = fileFormat.copyWithDVInfo(tahoeFileIndex.path().toString(), filePathToDVBroadcastMap, (Broadcast<SerializableConfiguration>)hadoopConfBroadcast);
        StructType x$8 = newDataSchema;
        FileIndex x$9 = hadoopFsRelation.copy$default$1();
        StructType x$10 = hadoopFsRelation.copy$default$2();
        Option x$11 = hadoopFsRelation.copy$default$4();
        Map x$12 = hadoopFsRelation.copy$default$6();
        SparkSession x$13 = hadoopFsRelation.sparkSession();
        HadoopFsRelation newRelation = hadoopFsRelation.copy(x$9, x$10, x$8, x$11, (FileFormat)x$7, x$12, x$13);
        return inputScan.copy((BaseRelation)newRelation, newScanOutput, inputScan.copy$default$3(), inputScan.copy$default$4());
    }

    private Filter createRowIndexFilterNode(LogicalRelation newScan) {
        Seq skipRowColumnRefs = (Seq)newScan.output().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ScanWithDeletionVectors$.$anonfun$createRowIndexFilterNode$1(x$1)));
        Predef$.MODULE$.require(skipRowColumnRefs.size() == 1, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Expected only one column with name=").append(DeltaParquetFileFormat$.MODULE$.IS_ROW_DELETED_COLUMN_NAME()).toString());
        AttributeReference skipRowColumnRef = (AttributeReference)skipRowColumnRefs.head();
        UserDefinedFunction keepRow = DeltaUDF$.MODULE$.booleanFromByte((Function1<Object, Object>)(Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ScanWithDeletionVectors$.$anonfun$createRowIndexFilterNode$3(BoxesRunTime.unboxToByte((Object)x$2)))).asNondeterministic();
        Expression filterExp = keepRow.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{new Column((Expression)skipRowColumnRef)})).expr();
        return new Filter(filterExp, (LogicalPlan)newScan);
    }

    private Broadcast<Map<URI, DeltaParquetFileFormat.DeletionVectorDescriptorWithFilterType>> createBroadcastDVMap(SparkSession spark, TahoeFileIndex tahoeFileIndex) {
        Map filterTypes = (Map)tahoeFileIndex.rowIndexFilters().getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
        Seq filesWithDVs = (Seq)tahoeFileIndex.matchingFiles((Seq<Expression>)((Seq)new .colon.colon((Object)Literal$.MODULE$.TrueLiteral(), (List)Nil$.MODULE$)), (Seq<Expression>)((Seq)new .colon.colon((Object)Literal$.MODULE$.TrueLiteral(), (List)Nil$.MODULE$))).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ScanWithDeletionVectors$.$anonfun$createBroadcastDVMap$2(x$3)));
        Map filePathToDVMap = ((TraversableOnce)filesWithDVs.map((Function1 & Serializable & scala.Serializable)addFile -> {
            URI key = DeltaFileOperations$.MODULE$.absolutePath(tahoeFileIndex.path().toString(), addFile.path()).toUri();
            RowIndexFilterType filterType = (RowIndexFilterType)((Object)((Object)filterTypes.getOrElse((Object)addFile.path(), (Function0 & Serializable & scala.Serializable)() -> RowIndexFilterType.IF_CONTAINED)));
            DeltaParquetFileFormat.DeletionVectorDescriptorWithFilterType value = new DeltaParquetFileFormat.DeletionVectorDescriptorWithFilterType(addFile.deletionVector(), filterType);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value);
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return spark.sparkContext().broadcast((Object)filePathToDVMap, ClassTag$.MODULE$.apply(Map.class));
    }

    public static final /* synthetic */ boolean $anonfun$createRowIndexFilterNode$1(AttributeReference x$1) {
        String string = x$1.name();
        String string2 = DeltaParquetFileFormat$.MODULE$.IS_ROW_DELETED_COLUMN_NAME();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$createRowIndexFilterNode$3(byte x$2) {
        return x$2 == 0;
    }

    public static final /* synthetic */ boolean $anonfun$createBroadcastDVMap$2(AddFile x$3) {
        return x$3.deletionVector() != null;
    }

    private ScanWithDeletionVectors$() {
        MODULE$ = this;
    }
}

