/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.IcebergCompatV1$;
import org.apache.spark.sql.delta.IcebergCompatV1TableFeature$;
import org.apache.spark.sql.delta.actions.Format;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.actions.Protocol$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;

public final class UniversalFormat$
implements DeltaLogging {
    public static UniversalFormat$ MODULE$;
    private final String ICEBERG_FORMAT;
    private final Set<String> SUPPORTED_FORMATS;
    private final String ICEBERG_TABLE_TYPE_KEY;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new UniversalFormat$();
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String ICEBERG_FORMAT() {
        return this.ICEBERG_FORMAT;
    }

    public Set<String> SUPPORTED_FORMATS() {
        return this.SUPPORTED_FORMATS;
    }

    public boolean icebergEnabled(Metadata metadata) {
        return ((SeqLike)DeltaConfigs$.MODULE$.UNIVERSAL_FORMAT_ENABLED_FORMATS().fromMetaData(metadata)).contains((Object)this.ICEBERG_FORMAT());
    }

    public boolean icebergEnabled(Map<String, String> properties) {
        return properties.get((Object)DeltaConfigs$.MODULE$.UNIVERSAL_FORMAT_ENABLED_FORMATS().key()).exists((Function1 & Serializable & scala.Serializable)value -> BoxesRunTime.boxToBoolean((boolean)value.contains(UniversalFormat$.MODULE$.ICEBERG_FORMAT())));
    }

    public Tuple2<Option<Protocol>, Option<Metadata>> enforceIcebergInvariantsAndDependencies(Protocol prevProtocol, Metadata prevMetadata, Protocol newestProtocol, Metadata newestMetadata, boolean isCreatingNewTable) {
        boolean bl;
        boolean uniformIcebergWasEnabled = this.icebergEnabled(prevMetadata);
        boolean uniformIcebergIsEnabled = this.icebergEnabled(newestMetadata);
        String tableId = newestMetadata.id();
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(uniformIcebergWasEnabled, uniformIcebergIsEnabled);
        if (sp2 != null) {
            boolean bl2 = sp2._1$mcZ$sp();
            boolean bl3 = sp2._2$mcZ$sp();
            if (!bl2 && !bl3) {
                return new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
            }
        }
        if (sp2 != null) {
            boolean bl4 = sp2._1$mcZ$sp();
            boolean bl5 = sp2._2$mcZ$sp();
            if (bl4 && !bl5) {
                Map newConfiguration;
                if (!IcebergCompatV1$.MODULE$.isEnabled(newestMetadata)) {
                    return new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
                }
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(107).append("[tableId=").append(tableId).append("] Universal Format (Iceberg): This feature is being ").append("disabled. Auto-disabling IcebergCompatV1, too.").toString());
                Map x$12 = newConfiguration = newestMetadata.configuration().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DeltaConfigs$.MODULE$.ICEBERG_COMPAT_V1_ENABLED().key()), (Object)"false")})));
                String x$2 = newestMetadata.copy$default$1();
                String x$3 = newestMetadata.copy$default$2();
                String x$4 = newestMetadata.copy$default$3();
                Format x$5 = newestMetadata.copy$default$4();
                String x$6 = newestMetadata.copy$default$5();
                Seq<String> x$7 = newestMetadata.copy$default$6();
                Option<Object> x$8 = newestMetadata.copy$default$8();
                return new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)newestMetadata.copy(x$2, x$3, x$4, x$5, x$6, x$7, (Map<String, String>)x$12, x$8)));
            }
        }
        if (sp2 != null && (bl = sp2._2$mcZ$sp())) {
            boolean icebergCompatV1WasEnabled = IcebergCompatV1$.MODULE$.isEnabled(prevMetadata);
            boolean icebergCompatV1IsEnabled = IcebergCompatV1$.MODULE$.isEnabled(newestMetadata);
            if (icebergCompatV1IsEnabled) {
                return new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
            }
            if (isCreatingNewTable) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(190).append("[tableId=").append(tableId).append("] Universal Format (Iceberg): Creating a new table ").append("with Universal Format (Iceberg) enabled, but IcebergCompatV1 is not yet enabled. ").append("Auto-supporting and enabling IcebergCompatV1 now.").toString());
                Some protocolResult = new Some((Object)newestProtocol.merge((Seq<Protocol>)Predef$.MODULE$.wrapRefArray((Object[])new Protocol[]{Protocol$.MODULE$.forTableFeature(IcebergCompatV1TableFeature$.MODULE$)})));
                Map x$9 = newestMetadata.configuration().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DeltaConfigs$.MODULE$.ICEBERG_COMPAT_V1_ENABLED().key()), (Object)"true")})));
                String x$10 = newestMetadata.copy$default$1();
                String x$11 = newestMetadata.copy$default$2();
                String x$12 = newestMetadata.copy$default$3();
                Format x$13 = newestMetadata.copy$default$4();
                String x$14 = newestMetadata.copy$default$5();
                Seq<String> x$15 = newestMetadata.copy$default$6();
                Option<Object> x$16 = newestMetadata.copy$default$8();
                Some metadataResult = new Some((Object)newestMetadata.copy(x$10, x$11, x$12, x$13, x$14, x$15, (Map<String, String>)x$9, x$16));
                return new Tuple2((Object)protocolResult, (Object)metadataResult);
            }
            if (icebergCompatV1WasEnabled) {
                Seq remainingSupportedFormats = (Seq)((TraversableLike)DeltaConfigs$.MODULE$.UNIVERSAL_FORMAT_ENABLED_FORMATS().fromMetaData(newestMetadata)).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)UniversalFormat$.$anonfun$enforceIcebergInvariantsAndDependencies$3(x$1)));
                Map newConfiguration = remainingSupportedFormats.isEmpty() ? (Map)newestMetadata.configuration().$minus((Object)DeltaConfigs$.MODULE$.UNIVERSAL_FORMAT_ENABLED_FORMATS().key()) : newestMetadata.configuration().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DeltaConfigs$.MODULE$.UNIVERSAL_FORMAT_ENABLED_FORMATS().key()), (Object)remainingSupportedFormats.mkString(","))})));
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(93).append("[tableId=").append(tableId).append("] IcebergCompatV1 is being disabled. Auto-disabling ").append("Universal Format (Iceberg), too.").toString());
                Map x$17 = newConfiguration;
                String x$18 = newestMetadata.copy$default$1();
                String x$19 = newestMetadata.copy$default$2();
                String x$20 = newestMetadata.copy$default$3();
                Format x$21 = newestMetadata.copy$default$4();
                String x$22 = newestMetadata.copy$default$5();
                Seq<String> x$23 = newestMetadata.copy$default$6();
                Option<Object> x$24 = newestMetadata.copy$default$8();
                return new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)newestMetadata.copy(x$18, x$19, x$20, x$21, x$22, x$23, (Map<String, String>)x$17, x$24)));
            }
            throw DeltaErrors$.MODULE$.uniFormIcebergRequiresIcebergCompatV1();
        }
        throw new MatchError((Object)sp2);
    }

    public String ICEBERG_TABLE_TYPE_KEY() {
        return this.ICEBERG_TABLE_TYPE_KEY;
    }

    public Option<CatalogTable> enforceSupportInCatalog(CatalogTable table, Metadata metadata) {
        boolean bl;
        Option option = table.properties().get((Object)this.ICEBERG_TABLE_TYPE_KEY());
        if (option instanceof Some) {
            Some some = (Some)option;
            String value = (String)some.value();
            bl = value.equalsIgnoreCase(this.ICEBERG_FORMAT());
        } else {
            bl = false;
        }
        boolean icebergInCatalog = bl;
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(this.icebergEnabled(metadata), icebergInCatalog);
        if (sp2 != null) {
            boolean bl2 = sp2._1$mcZ$sp();
            boolean bl3 = sp2._2$mcZ$sp();
            if (bl2 && !bl3) {
                Map x$1 = table.properties().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ICEBERG_TABLE_TYPE_KEY()), (Object)this.ICEBERG_FORMAT()));
                TableIdentifier x$2 = table.copy$default$1();
                CatalogTableType x$3 = table.copy$default$2();
                CatalogStorageFormat x$4 = table.copy$default$3();
                StructType x$5 = table.copy$default$4();
                Option x$6 = table.copy$default$5();
                Seq x$7 = table.copy$default$6();
                Option x$8 = table.copy$default$7();
                String x$9 = table.copy$default$8();
                long x$10 = table.copy$default$9();
                long x$11 = table.copy$default$10();
                String x$12 = table.copy$default$11();
                Option x$13 = table.copy$default$13();
                Option x$14 = table.copy$default$14();
                Option x$15 = table.copy$default$15();
                Seq x$16 = table.copy$default$16();
                boolean x$17 = table.copy$default$17();
                boolean x$18 = table.copy$default$18();
                Map x$19 = table.copy$default$19();
                Option x$20 = table.copy$default$20();
                return new Some((Object)table.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$1, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20));
            }
        }
        if (sp2 != null) {
            boolean bl4 = sp2._1$mcZ$sp();
            boolean bl5 = sp2._2$mcZ$sp();
            if (!bl4 && bl5) {
                Map x$21 = (Map)table.properties().$minus((Object)this.ICEBERG_TABLE_TYPE_KEY());
                TableIdentifier x$22 = table.copy$default$1();
                CatalogTableType x$23 = table.copy$default$2();
                CatalogStorageFormat x$24 = table.copy$default$3();
                StructType x$25 = table.copy$default$4();
                Option x$26 = table.copy$default$5();
                Seq x$27 = table.copy$default$6();
                Option x$28 = table.copy$default$7();
                String x$29 = table.copy$default$8();
                long x$30 = table.copy$default$9();
                long x$31 = table.copy$default$10();
                String x$32 = table.copy$default$11();
                Option x$33 = table.copy$default$13();
                Option x$34 = table.copy$default$14();
                Option x$35 = table.copy$default$15();
                Seq x$36 = table.copy$default$16();
                boolean x$37 = table.copy$default$17();
                boolean x$38 = table.copy$default$18();
                Map x$39 = table.copy$default$19();
                Option x$40 = table.copy$default$20();
                return new Some((Object)table.copy(x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$21, x$33, x$34, x$35, x$36, x$37, x$38, x$39, x$40));
            }
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$enforceIcebergInvariantsAndDependencies$3(String x$1) {
        String string = x$1;
        String string2 = MODULE$.ICEBERG_FORMAT();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private UniversalFormat$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
        this.ICEBERG_FORMAT = "iceberg";
        this.SUPPORTED_FORMATS = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.ICEBERG_FORMAT()}));
        this.ICEBERG_TABLE_TYPE_KEY = "table_type";
    }
}

