/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.catalog;

import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.ResolvedTable;
import org.apache.spark.sql.catalyst.analysis.UnresolvedTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.V1Table;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaTableUtils$;
import org.apache.spark.sql.delta.DeltaTimeTravelSpec;
import org.apache.spark.sql.delta.UnresolvedPathBasedDeltaTable;
import org.apache.spark.sql.delta.catalog.DeltaTableV2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple6;
import scala.collection.immutable.Map;

public final class DeltaTableV2$
implements Serializable {
    public static DeltaTableV2$ MODULE$;

    static {
        new DeltaTableV2$();
    }

    public Option<CatalogTable> $lessinit$greater$default$3() {
        return None$.MODULE$;
    }

    public Option<String> $lessinit$greater$default$4() {
        return None$.MODULE$;
    }

    public Option<DeltaTimeTravelSpec> $lessinit$greater$default$5() {
        return None$.MODULE$;
    }

    public Map<String, String> $lessinit$greater$default$6() {
        return Predef$.MODULE$.Map().empty();
    }

    public DeltaTableV2 apply(SparkSession spark, Path tablePath, Map<String, String> options, String cmd) {
        return this.resolve(spark, new UnresolvedPathBasedDeltaTable(tablePath.toString(), options, cmd), cmd);
    }

    public DeltaTableV2 apply(SparkSession spark, TableIdentifier tableId, String cmd) {
        return this.resolve(spark, (LogicalPlan)new UnresolvedTable(tableId.nameParts(), cmd, (Option)None$.MODULE$), cmd);
    }

    public Option<CatalogTable> apply$default$3() {
        return None$.MODULE$;
    }

    public Option<String> apply$default$4() {
        return None$.MODULE$;
    }

    public Option<DeltaTimeTravelSpec> apply$default$5() {
        return None$.MODULE$;
    }

    public Map<String, String> apply$default$6() {
        return Predef$.MODULE$.Map().empty();
    }

    public DeltaTableV2 resolve(SparkSession spark, LogicalPlan unresolved, String cmd) {
        return this.extractFrom(spark.sessionState().analyzer().ResolveRelations().apply(unresolved), cmd);
    }

    public DeltaTableV2 extractFrom(LogicalPlan plan, String cmd) {
        V1Table v1Table;
        Table t;
        boolean bl = false;
        ResolvedTable resolvedTable = null;
        LogicalPlan logicalPlan = plan;
        if (logicalPlan instanceof ResolvedTable) {
            bl = true;
            resolvedTable = (ResolvedTable)logicalPlan;
            Table d = resolvedTable.table();
            if (d instanceof DeltaTableV2) {
                DeltaTableV2 deltaTableV2 = (DeltaTableV2)d;
                return deltaTableV2;
            }
        }
        if (bl && (t = resolvedTable.table()) instanceof V1Table && DeltaTableUtils$.MODULE$.isDeltaTable((v1Table = (V1Table)t).catalogTable())) {
            return new DeltaTableV2(SparkSession$.MODULE$.active(), new Path(v1Table.v1Table().location()), (Option<CatalogTable>)new Some((Object)v1Table.v1Table()), this.apply$default$4(), this.apply$default$5(), this.apply$default$6());
        }
        throw DeltaErrors$.MODULE$.notADeltaTableException(cmd);
    }

    public DeltaTableV2 apply(SparkSession spark, Path path, Option<CatalogTable> catalogTable, Option<String> tableIdentifier, Option<DeltaTimeTravelSpec> timeTravelOpt, Map<String, String> options) {
        return new DeltaTableV2(spark, path, catalogTable, tableIdentifier, timeTravelOpt, options);
    }

    public Option<Tuple6<SparkSession, Path, Option<CatalogTable>, Option<String>, Option<DeltaTimeTravelSpec>, Map<String, String>>> unapply(DeltaTableV2 x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple6((Object)x$0.spark(), (Object)x$0.path(), x$0.catalogTable(), x$0.tableIdentifier(), x$0.timeTravelOpt(), x$0.options()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private DeltaTableV2$() {
        MODULE$ = this;
    }
}

