/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands;

import java.io.Serializable;
import org.apache.spark.paths.SparkPath$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaParquetFileFormat$;
import org.apache.spark.sql.delta.OptimisticTransaction;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.DeletionVectorDescriptor;
import org.apache.spark.sql.delta.commands.DeletionVectorBitmapGenerator;
import org.apache.spark.sql.delta.commands.DeletionVectorResult;
import org.apache.spark.sql.delta.commands.FileToDvDescriptor;
import org.apache.spark.sql.delta.commands.FileToDvDescriptor$;
import org.apache.spark.sql.delta.util.DeltaFileOperations$;
import org.apache.spark.sql.delta.util.JsonUtils$;
import org.apache.spark.sql.execution.datasources.FileFormat$;
import org.apache.spark.sql.functions$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ManifestFactory$;

public final class DeletionVectorBitmapGenerator$ {
    public static DeletionVectorBitmapGenerator$ MODULE$;

    static {
        new DeletionVectorBitmapGenerator$();
    }

    public final String FILE_NAME_COL() {
        return "filePath";
    }

    public final String FILE_DV_ID_COL() {
        return "deletionVectorId";
    }

    public final String ROW_INDEX_COL() {
        return "rowIndexCol";
    }

    public final String DELETED_ROW_INDEX_BITMAP() {
        return "deletedRowIndexSet";
    }

    public final String DELETED_ROW_INDEX_COUNT() {
        return "deletedRowIndexCount";
    }

    public final String MAX_ROW_INDEX_COL() {
        return "maxRowIndexCol";
    }

    public Seq<DeletionVectorResult> buildDeletionVectors(SparkSession spark, Dataset<Row> target, DeltaLog targetDeltaLog, OptimisticTransaction deltaTxn) {
        DeletionVectorBitmapGenerator.DeletionVectorSet rowIndexSet = new DeletionVectorBitmapGenerator.DeletionVectorSet(spark, target, targetDeltaLog, deltaTxn);
        return rowIndexSet.computeResult();
    }

    public Seq<DeletionVectorResult> buildRowIndexSetsForFilesMatchingCondition(SparkSession sparkSession, OptimisticTransaction txn, boolean tableHasDVs, Dataset<Row> targetDf, Seq<AddFile> candidateFiles, Expression condition) {
        Dataset dataset;
        Dataset matchedRowsDf = targetDf.withColumn("filePath", functions$.MODULE$.col(new StringBuilder(1).append(FileFormat$.MODULE$.METADATA_NAME()).append(".").append(FileFormat$.MODULE$.FILE_PATH()).toString())).filter(new Column(condition)).withColumn("rowIndexCol", functions$.MODULE$.col(DeltaParquetFileFormat$.MODULE$.ROW_INDEX_COLUMN_NAME()));
        if (tableHasDVs) {
            Column joinExpr;
            String basePath = txn.deltaLog().dataPath().toString();
            Seq filePathToDV = (Seq)candidateFiles.map((Function1 & Serializable & scala.Serializable)add -> {
                Option serializedDV = Option$.MODULE$.apply((Object)add.deletionVector()).map((Function1 & Serializable & scala.Serializable)dvd -> JsonUtils$.MODULE$.toJson(dvd, ManifestFactory$.MODULE$.classType(DeletionVectorDescriptor.class)));
                return new FileToDvDescriptor(SparkPath$.MODULE$.fromPath(DeltaFileOperations$.MODULE$.absolutePath(basePath, add.path())).urlEncoded(), (Option<String>)serializedDV);
            }, Seq$.MODULE$.canBuildFrom());
            Dataset filePathToDVDf = sparkSession.createDataset(filePathToDV, FileToDvDescriptor$.MODULE$.encoder());
            Dataset joinedDf = matchedRowsDf.join(filePathToDVDf, joinExpr = filePathToDVDf.apply("path").$eq$eq$eq((Object)matchedRowsDf.apply("filePath")));
            Predef$.MODULE$.assert(joinedDf.count() == matchedRowsDf.count(), (Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(273).append("\n           |The joined DataFrame should contain the same number of entries as the original\n           |DataFrame. It is likely that _metadata.file_path is not encoded by Spark as expected.\n           |Joined DataFrame count: ").append(joinedDf.count()).append("\n           |matchedRowsDf count: ").append(matchedRowsDf.count()).append("\n           |").toString())).stripMargin());
            dataset = joinedDf;
        } else {
            dataset = matchedRowsDf.withColumn("deletionVectorId", functions$.MODULE$.lit(null));
        }
        Dataset df = dataset;
        return this.buildDeletionVectors(sparkSession, (Dataset<Row>)df, txn.deltaLog(), txn);
    }

    private DeletionVectorBitmapGenerator$() {
        MODULE$ = this;
    }
}

