/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.actions.DeletionVectorDescriptor;
import org.apache.spark.sql.delta.actions.DeletionVectorDescriptor$;
import org.apache.spark.sql.delta.commands.DeletionVectorData;
import org.apache.spark.sql.delta.commands.DeletionVectorResult;
import org.apache.spark.sql.delta.commands.DeletionVectorResult$;
import org.apache.spark.sql.delta.commands.DeletionVectorWriter;
import org.apache.spark.sql.delta.deletionvectors.RoaringBitmapArray$;
import org.apache.spark.sql.delta.deletionvectors.RoaringBitmapArrayFormat$;
import org.apache.spark.sql.delta.deletionvectors.StoredBitmap$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.storage.dv.DeletionVectorStore;
import org.apache.spark.sql.delta.storage.dv.DeletionVectorStore$;
import org.apache.spark.sql.delta.storage.dv.DeletionVectorStoreUtils;
import org.apache.spark.sql.delta.util.BinPackingIterator;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.delta.util.PathWithFileSystem;
import org.apache.spark.sql.delta.util.Utils$;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.generic.Sizing;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class DeletionVectorWriter$
implements DeltaLogging {
    public static DeletionVectorWriter$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new DeletionVectorWriter$();
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public <InputT extends Sizing, OutputT> Function1<Iterator<InputT>, Iterator<OutputT>> createDeletionVectorMapper(SparkSession sparkSession, Configuration hadoopConf, Path table, int prefixLength, Function2<DeletionVectorWriter.DeletionVectorMapperContext, InputT, OutputT> callbackFn) {
        Broadcast broadcastHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        String tablePathString = DeletionVectorStore$.MODULE$.pathToString(table);
        long packingTargetSize = BoxesRunTime.unboxToLong((Object)sparkSession.conf().get(DeltaSQLConf$.MODULE$.DELETION_VECTOR_PACKING_TARGET_SIZE()));
        return (Function1 & Serializable & scala.Serializable)rowIterator -> {
            DeletionVectorStore dvStore = DeletionVectorStore$.MODULE$.createInstance(((SerializableConfiguration)broadcastHadoopConf.value()).value());
            Path tablePath = DeletionVectorStore$.MODULE$.stringToPath(tablePathString);
            PathWithFileSystem tablePathWithFS = dvStore.pathWithFileSystem(tablePath);
            Function1 & Serializable & scala.Serializable perBinFunction = (Function1 & Serializable & scala.Serializable)rows -> {
                String prefix = Utils$.MODULE$.getRandomPrefix(prefixLength);
                Tuple2<DeletionVectorStoreUtils.Writer, UUID> tuple2 = MODULE$.createWriter(dvStore, tablePathWithFS, prefix);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                DeletionVectorStoreUtils.Writer writer2 = (DeletionVectorStoreUtils.Writer)tuple2._1();
                UUID fileId = (UUID)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)writer2, (Object)fileId);
                DeletionVectorStoreUtils.Writer writer3 = (DeletionVectorStoreUtils.Writer)tuple22._1();
                UUID fileId2 = (UUID)tuple22._2();
                DeletionVectorWriter.DeletionVectorMapperContext ctx = new DeletionVectorWriter.DeletionVectorMapperContext(dvStore, writer3, tablePath, fileId2, prefix);
                Seq result = (Seq)org.apache.spark.util.Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> writer3, (Function1 & Serializable & scala.Serializable)writer -> (Seq)rows.map((Function1 & Serializable & scala.Serializable)r -> callbackFn.apply((Object)ctx, r), Seq$.MODULE$.canBuildFrom()));
                return result;
            };
            BinPackingIterator binPackedRowIterator = new BinPackingIterator(rowIterator, packingTargetSize);
            return binPackedRowIterator.flatMap(perBinFunction);
        };
    }

    public Tuple2<DeletionVectorStoreUtils.Writer, UUID> createWriter(DeletionVectorStore dvStore, PathWithFileSystem tablePath, String prefix) {
        UUID fileId = UUID.randomUUID();
        DeletionVectorStoreUtils.Writer writer = dvStore.createWriter(dvStore.generateFileNameInTable(tablePath, fileId, prefix));
        return new Tuple2((Object)writer, (Object)fileId);
    }

    public String createWriter$default$3() {
        return "";
    }

    public DeletionVectorDescriptor storeSerializedBitmap(DeletionVectorWriter.DeletionVectorMapperContext ctx, byte[] bitmapData, long cardinality) {
        if (cardinality == 0L) {
            return DeletionVectorDescriptor$.MODULE$.EMPTY();
        }
        DeletionVectorStoreUtils.DVRangeDescriptor dvRange = ctx.writer().write(bitmapData);
        return DeletionVectorDescriptor$.MODULE$.onDiskWithRelativePath(ctx.fileId(), ctx.prefix(), bitmapData.length, cardinality, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)dvRange.offset())), DeletionVectorDescriptor$.MODULE$.onDiskWithRelativePath$default$6());
    }

    public Function1<Iterator<DeletionVectorData>, Iterator<DeletionVectorResult>> createMapperToStoreDeletionVectors(SparkSession sparkSession, Configuration hadoopConf, Path table, int prefixLength) {
        return this.createDeletionVectorMapper(sparkSession, hadoopConf, table, prefixLength, (Function2 & Serializable & scala.Serializable)(ctx, row) -> MODULE$.storeBitmapAndGenerateResult((DeletionVectorWriter.DeletionVectorMapperContext)ctx, (DeletionVectorData)row));
    }

    /*
     * Unable to fully structure code
     */
    public DeletionVectorResult storeBitmapAndGenerateResult(DeletionVectorWriter.DeletionVectorMapperContext ctx, DeletionVectorData row) {
        fileDvDescriptor = row.deletionVectorId().map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$storeBitmapAndGenerateResult$1(java.lang.String ), (Ljava/lang/String;)Lorg/apache/spark/sql/delta/actions/DeletionVectorDescriptor;)());
        var6_4 = false;
        var7_5 = null;
        var8_6 = fileDvDescriptor;
        if (!(var8_6 instanceof Some)) ** GOTO lbl-1000
        var6_4 = true;
        var7_5 = (Some)var8_6;
        existingDvDescriptor = (DeletionVectorDescriptor)var7_5.value();
        if (row.deletedRowIndexCount() > 0L) {
            existingBitmap = StoredBitmap$.MODULE$.create(existingDvDescriptor, ctx.tablePath()).load(ctx.dvStore());
            newBitmap = RoaringBitmapArray$.MODULE$.readFrom(row.deletedRowIndexSet());
            existingBitmap.merge(newBitmap);
            v0 = this.storeSerializedBitmap(ctx, existingBitmap.serializeAsByteArray((Enumeration.Value)RoaringBitmapArrayFormat$.MODULE$.Portable()), existingBitmap.cardinality());
        } else if (var6_4) {
            v0 = existingDvDescriptor = (DeletionVectorDescriptor)var7_5.value();
        } else if (None$.MODULE$.equals(var8_6)) {
            v0 = this.storeSerializedBitmap(ctx, row.deletedRowIndexSet(), row.deletedRowIndexCount());
        } else {
            throw new MatchError((Object)var8_6);
        }
        finalDvDescriptor = v0;
        return DeletionVectorResult$.MODULE$.fromDeletionVectorData(row, finalDvDescriptor);
    }

    public static final /* synthetic */ DeletionVectorDescriptor $anonfun$storeBitmapAndGenerateResult$1(String x$14) {
        return DeletionVectorDescriptor$.MODULE$.fromJson(x$14);
    }

    private DeletionVectorWriter$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
    }
}

