/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import java.util.ConcurrentModificationException;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaOperations;
import org.apache.spark.sql.delta.DeltaOperations$Reorg$;
import org.apache.spark.sql.delta.DeltaOptions;
import org.apache.spark.sql.delta.OptimisticTransaction;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.DeletionVectorDescriptor;
import org.apache.spark.sql.delta.actions.FileAction;
import org.apache.spark.sql.delta.actions.RemoveFile;
import org.apache.spark.sql.delta.actions.SetTransaction;
import org.apache.spark.sql.delta.catalog.DeltaTableV2;
import org.apache.spark.sql.delta.commands.DeltaCommand;
import org.apache.spark.sql.delta.commands.DeltaOptimizeContext;
import org.apache.spark.sql.delta.commands.optimize.DeletionVectorStats;
import org.apache.spark.sql.delta.commands.optimize.FileSizeStatsWithHistogram;
import org.apache.spark.sql.delta.commands.optimize.FileSizeStatsWithHistogram$;
import org.apache.spark.sql.delta.commands.optimize.OptimizeStats;
import org.apache.spark.sql.delta.commands.optimize.OptimizeStats$;
import org.apache.spark.sql.delta.commands.optimize.ZOrderFileStats;
import org.apache.spark.sql.delta.commands.optimize.ZOrderStats;
import org.apache.spark.sql.delta.commands.optimize.ZOrderStats$;
import org.apache.spark.sql.delta.files.SQLMetricsReporting;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.skipping.MultiDimClustering$;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.metric.SQLMetrics$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SystemClock;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005mg\u0001\u0002\n\u0014\u0001\u0001B\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\ts\u0001\u0011\t\u0011)A\u0005u!Aa\b\u0001B\u0001B\u0003%q\b\u0003\u0005T\u0001\t\u0005\t\u0015!\u0003U\u0011!i\u0006A!A!\u0002\u0013q\u0006\"B1\u0001\t\u0003\u0011\u0007bB5\u0001\u0005\u0004%IA\u001b\u0005\u0007]\u0002\u0001\u000b\u0011B6\t\u000f=\u0004!\u0019!C\u0005a\"1A\u000f\u0001Q\u0001\nEDQ!\u001e\u0001\u0005\u0002YDQa\u001f\u0001\u0005\nqDq!!\u0007\u0001\t\u0013\tY\u0002C\u0004\u00024\u0001!I!!\u000e\t\u000f\u00055\u0003\u0001\"\u0003\u0002P!9\u00111\u0016\u0001\u0005\n\u00055\u0006bBAX\u0001\u0011%\u0011\u0011\u0017\u0002\u0011\u001fB$\u0018.\\5{K\u0016CXmY;u_JT!\u0001F\u000b\u0002\u0011\r|W.\\1oINT!AF\f\u0002\u000b\u0011,G\u000e^1\u000b\u0005aI\u0012aA:rY*\u0011!dG\u0001\u0006gB\f'o\u001b\u0006\u00039u\ta!\u00199bG\",'\"\u0001\u0010\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001\tseK\u0019\u0011\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\r\u0005s\u0017PU3g!\tA\u0013&D\u0001\u0014\u0013\tQ3C\u0001\u0007EK2$\u0018mQ8n[\u0006tG\r\u0005\u0002-_5\tQF\u0003\u0002/+\u0005)a-\u001b7fg&\u0011\u0001'\f\u0002\u0014'FcU*\u001a;sS\u000e\u001c(+\u001a9peRLgn\u001a\t\u0003EIJ!aM\u0012\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005Y:T\"A\f\n\u0005a:\"\u0001D*qCJ\\7+Z:tS>t\u0017a\u0001;y]B\u00111\bP\u0007\u0002+%\u0011Q(\u0006\u0002\u0016\u001fB$\u0018.\\5ti&\u001cGK]1og\u0006\u001cG/[8o\u0003I\u0001\u0018M\u001d;ji&|g\u000e\u0015:fI&\u001c\u0017\r^3\u0011\u0007\u0001C5J\u0004\u0002B\r:\u0011!)R\u0007\u0002\u0007*\u0011AiH\u0001\u0007yI|w\u000e\u001e \n\u0003\u0011J!aR\u0012\u0002\u000fA\f7m[1hK&\u0011\u0011J\u0013\u0002\u0004'\u0016\f(BA$$!\ta\u0015+D\u0001N\u0015\tqu*A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001)\u0018\u0003!\u0019\u0017\r^1msN$\u0018B\u0001*N\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0010u>\u0013H-\u001a:Cs\u000e{G.^7ogB\u0019\u0001\tS+\u0011\u0005YSfBA,Y!\t\u00115%\u0003\u0002ZG\u00051\u0001K]3eK\u001aL!a\u0017/\u0003\rM#(/\u001b8h\u0015\tI6%A\bpaRLW.\u001b>f\u0007>tG/\u001a=u!\tAs,\u0003\u0002a'\t!B)\u001a7uC>\u0003H/[7ju\u0016\u001cuN\u001c;fqR\fa\u0001P5oSRtDCB2eK\u001a<\u0007\u000e\u0005\u0002)\u0001!)AG\u0002a\u0001k!)\u0011H\u0002a\u0001u!)aH\u0002a\u0001\u007f!)1K\u0002a\u0001)\")QL\u0002a\u0001=\u0006\u0011r\u000e]3sCRLwN\u001c+j[\u0016\u001cH/Y7q+\u0005Y\u0007C\u0001\u0012m\u0013\ti7E\u0001\u0003M_:<\u0017aE8qKJ\fG/[8o)&lWm\u001d;b[B\u0004\u0013\u0001F5t\u001bVdG/\u001b#j[\u000ecWo\u001d;fe&tw-F\u0001r!\t\u0011#/\u0003\u0002tG\t9!i\\8mK\u0006t\u0017!F5t\u001bVdG/\u001b#j[\u000ecWo\u001d;fe&tw\rI\u0001\t_B$\u0018.\\5{KR\tq\u000fE\u0002A\u0011b\u0004\"AN=\n\u0005i<\"a\u0001*po\u00061\u0002O];oK\u000e\u000bg\u000eZ5eCR,g)\u001b7f\u0019&\u001cH\u000fF\u0004~\u0003\u0013\ti!a\u0006\u0011\u0007\u0001Ce\u0010E\u0002\u0000\u0003\u000bi!!!\u0001\u000b\u0007\u0005\rQ#A\u0004bGRLwN\\:\n\t\u0005\u001d\u0011\u0011\u0001\u0002\b\u0003\u0012$g)\u001b7f\u0011\u0019\tY\u0001\u0004a\u0001W\u0006YQ.\u001b8GS2,7+\u001b>f\u0011\u001d\ty\u0001\u0004a\u0001\u0003#\t1#\\1y\t\u0016dW\r^3e%><8OU1uS>\u00042AIA\n\u0013\r\t)b\t\u0002\u0007\t>,(\r\\3\t\u000b9b\u0001\u0019A?\u0002%\u001d\u0014x.\u001e9GS2,7/\u00138u_\nKgn\u001d\u000b\u0007\u0003;\tY#a\f\u0011\t\u0001C\u0015q\u0004\t\u0007E\u0005\u0005\u0012QE?\n\u0007\u0005\r2E\u0001\u0004UkBdWM\r\t\u0006-\u0006\u001dR+V\u0005\u0004\u0003Sa&aA'ba\"9\u0011QF\u0007A\u0002\u0005u\u0011a\u00059beRLG/[8ogR{7i\\7qC\u000e$\bBBA\u0019\u001b\u0001\u00071.A\tnCb$\u0016M]4fi\u001aKG.Z*ju\u0016\f\u0011C];o\u001fB$\u0018.\\5{K\nKgNS8c))\t9$a\u0010\u0002B\u0005\u0015\u0013\u0011\n\t\u0005\u0001\"\u000bI\u0004E\u0002\u0000\u0003wIA!!\u0010\u0002\u0002\tQa)\u001b7f\u0003\u000e$\u0018n\u001c8\t\u000ber\u0001\u0019\u0001\u001e\t\u000f\u0005\rc\u00021\u0001\u0002&\u0005I\u0001/\u0019:uSRLwN\u001c\u0005\u0007\u0003\u000fr\u0001\u0019A?\u0002\u0007\tLg\u000e\u0003\u0004\u0002L9\u0001\ra[\u0001\f[\u0006Dh)\u001b7f'&TX-\u0001\bd_6l\u0017\u000e^!oIJ+GO]=\u0015\u0015\u0005E\u00131MA3\u0003\u0017\u000b)\n\u0006\u0003\u0002T\u0005e\u0003c\u0001\u0012\u0002V%\u0019\u0011qK\u0012\u0003\tUs\u0017\u000e\u001e\u0005\b\u00037z\u0001\u0019AA/\u0003\u00051\u0007#\u0002\u0012\u0002`i\n\u0018bAA1G\tIa)\u001e8di&|g.\r\u0005\u0006s=\u0001\rA\u000f\u0005\b\u0003Oz\u0001\u0019AA5\u0003Ey\u0007\u000f^5nSj,w\n]3sCRLwN\u001c\t\u0005\u0003W\n)I\u0004\u0003\u0002n\u0005\u0005e\u0002BA8\u0003\u007frA!!\u001d\u0002~9!\u00111OA>\u001d\u0011\t)(!\u001f\u000f\u0007\t\u000b9(C\u0001\u001f\u0013\taR$\u0003\u0002\u001b7%\u0011\u0001$G\u0005\u0003-]I1!a!\u0016\u0003=!U\r\u001c;b\u001fB,'/\u0019;j_:\u001c\u0018\u0002BAD\u0003\u0013\u0013\u0011b\u00149fe\u0006$\u0018n\u001c8\u000b\u0007\u0005\rU\u0003C\u0004\u0002\u0004=\u0001\r!!$\u0011\t\u0001C\u0015q\u0012\t\u0004\u007f\u0006E\u0015\u0002BAJ\u0003\u0003\u0011a!Q2uS>t\u0007bBAL\u001f\u0001\u0007\u0011\u0011T\u0001\b[\u0016$(/[2t!\u00191\u0016qE+\u0002\u001cB!\u0011QTAT\u001b\t\tyJ\u0003\u0003\u0002\"\u0006\r\u0016AB7fiJL7MC\u0002\u0002&^\t\u0011\"\u001a=fGV$\u0018n\u001c8\n\t\u0005%\u0016q\u0014\u0002\n'FcU*\u001a;sS\u000e\fAbZ3u\u001fB,'/\u0019;j_:$\"!!\u001b\u0002\u001b\r\u0014X-\u0019;f\u001b\u0016$(/[2t))\tI*a-\u0002@\u0006\r\u0017q\u001a\u0005\b\u0003k\u000b\u0002\u0019AA\\\u00031\u0019\b/\u0019:l\u0007>tG/\u001a=u!\u0011\tI,a/\u000e\u0003eI1!!0\u001a\u00051\u0019\u0006/\u0019:l\u0007>tG/\u001a=u\u0011\u0019\t\t-\u0005a\u0001{\u0006Q\u0011\r\u001a3fI\u001aKG.Z:\t\u000f\u0005\u0015\u0017\u00031\u0001\u0002H\u0006a!/Z7pm\u0016$g)\u001b7fgB!\u0001\tSAe!\ry\u00181Z\u0005\u0005\u0003\u001b\f\tA\u0001\u0006SK6|g/\u001a$jY\u0016Dq!!5\u0012\u0001\u0004\t\u0019.\u0001\u0006sK6|g/\u001a3E-N\u0004B\u0001\u0011%\u0002VB\u0019q0a6\n\t\u0005e\u0017\u0011\u0001\u0002\u0019\t\u0016dW\r^5p]Z+7\r^8s\t\u0016\u001c8M]5qi>\u0014\b")
public class OptimizeExecutor
implements DeltaCommand,
SQLMetricsReporting,
scala.Serializable {
    private final SparkSession sparkSession;
    private final OptimisticTransaction txn;
    private final Seq<Expression> partitionPredicate;
    private final Seq<String> zOrderByColumns;
    private final DeltaOptimizeContext optimizeContext;
    private final long operationTimestamp;
    private final boolean isMultiDimClustering;
    private Map<String, SQLMetric> org$apache$spark$sql$delta$files$SQLMetricsReporting$$operationSQLMetrics;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public void registerSQLMetrics(SparkSession spark, Map<String, SQLMetric> metrics) {
        SQLMetricsReporting.registerSQLMetrics$(this, spark, metrics);
    }

    @Override
    public Map<String, String> getMetricsForOperation(DeltaOperations.Operation operation) {
        return SQLMetricsReporting.getMetricsForOperation$(this, operation);
    }

    @Override
    public Option<SQLMetric> getMetric(String name) {
        return SQLMetricsReporting.getMetric$(this, name);
    }

    @Override
    public Seq<Expression> parsePredicates(SparkSession spark, String predicate) {
        return DeltaCommand.parsePredicates$(this, spark, predicate);
    }

    @Override
    public void verifyPartitionPredicates(SparkSession spark, Seq<String> partitionColumns, Seq<Expression> predicates) {
        DeltaCommand.verifyPartitionPredicates$(this, spark, partitionColumns, predicates);
    }

    @Override
    public Map<String, AddFile> generateCandidateFileMap(Path basePath, Seq<AddFile> candidateFiles) {
        return DeltaCommand.generateCandidateFileMap$(this, basePath, candidateFiles);
    }

    @Override
    public Seq<RemoveFile> removeFilesFromPaths(DeltaLog deltaLog, Map<String, AddFile> nameToAddFileMap, Seq<String> filesToRewrite, long operationTimestamp) {
        return DeltaCommand.removeFilesFromPaths$(this, deltaLog, nameToAddFileMap, filesToRewrite, operationTimestamp);
    }

    @Override
    public HadoopFsRelation buildBaseRelation(SparkSession spark, OptimisticTransaction txn, String actionType, Path rootPath, Seq<String> inputLeafFiles, Map<String, AddFile> nameToAddFileMap) {
        return DeltaCommand.buildBaseRelation$(this, spark, txn, actionType, rootPath, inputLeafFiles, nameToAddFileMap);
    }

    @Override
    public AddFile getTouchedFile(Path basePath, String filePath, Map<String, AddFile> nameToAddFileMap) {
        return DeltaCommand.getTouchedFile$(this, basePath, filePath, nameToAddFileMap);
    }

    @Override
    public LogicalPlan resolveIdentifier(Analyzer analyzer, TableIdentifier identifier) {
        return DeltaCommand.resolveIdentifier$(this, analyzer, identifier);
    }

    @Override
    public boolean isCatalogTable(Analyzer analyzer, TableIdentifier tableIdent) {
        return DeltaCommand.isCatalogTable$(this, analyzer, tableIdent);
    }

    @Override
    public boolean isPathIdentifier(TableIdentifier tableIdent) {
        return DeltaCommand.isPathIdentifier$(this, tableIdent);
    }

    @Override
    public DeltaLog getDeltaLog(SparkSession spark, Option<String> path, Option<TableIdentifier> tableIdentifier, String operationName, Map<String, String> hadoopConf) {
        return DeltaCommand.getDeltaLog$(this, spark, path, tableIdentifier, operationName, hadoopConf);
    }

    @Override
    public Map<String, String> getDeltaLog$default$5() {
        return DeltaCommand.getDeltaLog$default$5$(this);
    }

    @Override
    public void sendDriverMetrics(SparkSession spark, Map<String, SQLMetric> metrics) {
        DeltaCommand.sendDriverMetrics$(this, spark, metrics);
    }

    @Override
    public DeltaTableV2 getDeltaTable(LogicalPlan target, String cmd) {
        return DeltaCommand.getDeltaTable$(this, target, cmd);
    }

    @Override
    public Option<CatalogTable> getTableCatalogTable(LogicalPlan target, String cmd) {
        return DeltaCommand.getTableCatalogTable$(this, target, cmd);
    }

    @Override
    public Tuple2<Option<TableIdentifier>, Option<String>> getDeltaTablePathOrIdentifier(LogicalPlan target, String cmd) {
        return DeltaCommand.getDeltaTablePathOrIdentifier$(this, target, cmd);
    }

    @Override
    public Tuple2<Option<TableIdentifier>, Option<String>> getTablePathOrIdentifier(LogicalPlan target, String cmd) {
        return DeltaCommand.getTablePathOrIdentifier$(this, target, cmd);
    }

    @Override
    public boolean hasBeenExecuted(OptimisticTransaction txn, SparkSession sparkSession, Option<DeltaOptions> options) {
        return DeltaCommand.hasBeenExecuted$(this, txn, sparkSession, options);
    }

    @Override
    public Option<DeltaOptions> hasBeenExecuted$default$3() {
        return DeltaCommand.hasBeenExecuted$default$3$(this);
    }

    @Override
    public Option<SetTransaction> createSetTransaction(SparkSession sparkSession, DeltaLog deltaLog, Option<DeltaOptions> options) {
        return DeltaCommand.createSetTransaction$(this, sparkSession, deltaLog, options);
    }

    @Override
    public Option<DeltaOptions> createSetTransaction$default$3() {
        return DeltaCommand.createSetTransaction$default$3$(this);
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public Map<String, SQLMetric> org$apache$spark$sql$delta$files$SQLMetricsReporting$$operationSQLMetrics() {
        return this.org$apache$spark$sql$delta$files$SQLMetricsReporting$$operationSQLMetrics;
    }

    @Override
    public void org$apache$spark$sql$delta$files$SQLMetricsReporting$$operationSQLMetrics_$eq(Map<String, SQLMetric> x$1) {
        this.org$apache$spark$sql$delta$files$SQLMetricsReporting$$operationSQLMetrics = x$1;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private long operationTimestamp() {
        return this.operationTimestamp;
    }

    private boolean isMultiDimClustering() {
        return this.isMultiDimClustering;
    }

    public Seq<Row> optimize() {
        Seq seq;
        Object object = new Object();
        try {
            seq = (Seq)this.recordDeltaOperation(this.txn.deltaLog(), "delta.optimize", this.recordDeltaOperation$default$3(), (Function0 & Serializable & scala.Serializable)() -> {
                long minFileSize = BoxesRunTime.unboxToLong((Object)$this.optimizeContext.minFileSize().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToLong((Object)$this.sparkSession.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_OPTIMIZE_MIN_FILE_SIZE()))));
                long maxFileSize = BoxesRunTime.unboxToLong((Object)$this.sparkSession.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_OPTIMIZE_MAX_FILE_SIZE()));
                double maxDeletedRowsRatio = BoxesRunTime.unboxToDouble((Object)$this.optimizeContext.maxDeletedRowsRatio().getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToDouble((Object)$this.sparkSession.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_OPTIMIZE_MAX_DELETED_ROWS_RATIO()))));
                Seq<AddFile> candidateFiles = $this.txn.filterFiles($this.partitionPredicate, true);
                StructType partitionSchema = $this.txn.metadata().partitionSchema();
                Seq<AddFile> filesToProcess = this.pruneCandidateFileList(minFileSize, maxDeletedRowsRatio, candidateFiles);
                Seq partitionsToCompact = filesToProcess.groupBy((Function1 & Serializable & scala.Serializable)x$4 -> x$4.partitionValues()).toSeq();
                Seq<Tuple2<Map<String, String>, Seq<AddFile>>> jobs = this.groupFilesIntoBins((Seq<Tuple2<Map<String, String>, Seq<AddFile>>>)partitionsToCompact, maxFileSize);
                int maxThreads = BoxesRunTime.unboxToInt((Object)$this.sparkSession.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_OPTIMIZE_MAX_THREADS()));
                Seq updates = (Seq)ThreadUtils$.MODULE$.parmap(jobs, "OptimizeJob", maxThreads, (Function1 & Serializable & scala.Serializable)partitionBinGroup -> this.runOptimizeBinJob($this.txn, (Map<String, String>)((Map)partitionBinGroup._1()), (Seq<AddFile>)((Seq)partitionBinGroup._2()), maxFileSize)).flatten((Function1)Predef$.MODULE$.$conforms());
                Seq addedFiles = (Seq)updates.collect((PartialFunction)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends FileAction, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        if (A1 instanceof AddFile) {
                            AddFile addFile = (AddFile)A1;
                            return (B1)addFile;
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(FileAction x1) {
                        FileAction fileAction = x1;
                        return fileAction instanceof AddFile;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Seq removedFiles = (Seq)updates.collect((PartialFunction)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends FileAction, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        A1 A1 = x2;
                        if (A1 instanceof RemoveFile) {
                            RemoveFile removeFile = (RemoveFile)A1;
                            return (B1)removeFile;
                        }
                        return (B1)function1.apply(x2);
                    }

                    public final boolean isDefinedAt(FileAction x2) {
                        FileAction fileAction = x2;
                        return fileAction instanceof RemoveFile;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Seq removedDVs = ((SeqLike)((TraversableLike)filesToProcess.filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)OptimizeExecutor.$anonfun$optimize$6(x$5)))).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.deletionVector(), Seq$.MODULE$.canBuildFrom())).toSeq();
                if (addedFiles.size() > 0) {
                    Map<String, SQLMetric> metrics = this.createMetrics($this.sparkSession.sparkContext(), (Seq<AddFile>)addedFiles, (Seq<RemoveFile>)removedFiles, (Seq<DeletionVectorDescriptor>)removedDVs);
                    this.commitAndRetry($this.txn, this.getOperation(), (Seq<Action>)updates, metrics, (Function1<OptimisticTransaction, Object>)(Function1 & Serializable & scala.Serializable)newTxn -> BoxesRunTime.boxToBoolean((boolean)OptimizeExecutor.$anonfun$optimize$8(this, candidateFiles, partitionSchema, newTxn)));
                }
                OptimizeStats optimizeStats = new OptimizeStats(OptimizeStats$.MODULE$.apply$default$1(), OptimizeStats$.MODULE$.apply$default$2(), OptimizeStats$.MODULE$.apply$default$3(), OptimizeStats$.MODULE$.apply$default$4(), OptimizeStats$.MODULE$.apply$default$5(), OptimizeStats$.MODULE$.apply$default$6(), OptimizeStats$.MODULE$.apply$default$7(), OptimizeStats$.MODULE$.apply$default$8(), OptimizeStats$.MODULE$.apply$default$9(), OptimizeStats$.MODULE$.apply$default$10(), OptimizeStats$.MODULE$.apply$default$11(), OptimizeStats$.MODULE$.apply$default$12(), OptimizeStats$.MODULE$.apply$default$13(), OptimizeStats$.MODULE$.apply$default$14(), OptimizeStats$.MODULE$.apply$default$15(), OptimizeStats$.MODULE$.apply$default$16(), OptimizeStats$.MODULE$.apply$default$17(), OptimizeStats$.MODULE$.apply$default$18());
                optimizeStats.addedFilesSizeStats().merge((Seq<FileAction>)addedFiles);
                optimizeStats.removedFilesSizeStats().merge((Seq<FileAction>)removedFiles);
                optimizeStats.numPartitionsOptimized_$eq(((SeqLike)((SeqLike)jobs.map((Function1 & Serializable & scala.Serializable)j -> (Map)j._1(), Seq$.MODULE$.canBuildFrom())).distinct()).size());
                optimizeStats.numBatches_$eq(jobs.size());
                optimizeStats.totalConsideredFiles_$eq(candidateFiles.size());
                optimizeStats.totalFilesSkipped_$eq(optimizeStats.totalConsideredFiles() - (long)removedFiles.size());
                optimizeStats.totalClusterParallelism_$eq($this.sparkSession.sparkContext().defaultParallelism());
                int numTableColumns = $this.txn.snapshot().metadata().schema().size();
                optimizeStats.numTableColumns_$eq(numTableColumns);
                optimizeStats.numTableColumnsWithStats_$eq(RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt((Object)DeltaConfigs$.MODULE$.DATA_SKIPPING_NUM_INDEXED_COLS().fromMetaData($this.txn.snapshot().metadata()))), numTableColumns));
                if (removedDVs.size() > 0) {
                    optimizeStats.deletionVectorStats_$eq((Option<DeletionVectorStats>)new Some((Object)new DeletionVectorStats(removedDVs.size(), BoxesRunTime.unboxToLong((Object)((TraversableOnce)removedDVs.map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.cardinality()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)))));
                }
                if (this.isMultiDimClustering()) {
                    ZOrderFileStats inputFileStats = new ZOrderFileStats(removedFiles.size(), BoxesRunTime.unboxToLong((Object)((TraversableOnce)removedFiles.map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)OptimizeExecutor.$anonfun$optimize$14(x$10)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
                    optimizeStats.zOrderStats_$eq((Option<ZOrderStats>)new Some((Object)new ZOrderStats("all", new ZOrderFileStats(0L, 0L), inputFileStats, 0L, inputFileStats, optimizeStats.numPartitionsOptimized(), ZOrderStats$.MODULE$.apply$default$7())));
                }
                throw new NonLocalReturnControl(object, (Object)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.txn.deltaLog().dataPath().toString(), optimizeStats.toOptimizeMetrics()})), (List)Nil$.MODULE$));
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                seq = (Seq)ex.value();
            }
            throw ex;
        }
        return seq;
    }

    private Seq<AddFile> pruneCandidateFileList(long minFileSize, double maxDeletedRowsRatio, Seq<AddFile> files) {
        if (this.isMultiDimClustering()) {
            return files;
        }
        return (Seq)files.filter((Function1 & Serializable & scala.Serializable)addFile -> BoxesRunTime.boxToBoolean((boolean)OptimizeExecutor.$anonfun$pruneCandidateFileList$2(minFileSize, maxDeletedRowsRatio, addFile)));
    }

    private Seq<Tuple2<Map<String, String>, Seq<AddFile>>> groupFilesIntoBins(Seq<Tuple2<Map<String, String>, Seq<AddFile>>> partitionsToCompact, long maxTargetFileSize) {
        return (Seq)partitionsToCompact.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Map partition = (Map)tuple2._1();
                Seq files = (Seq)tuple2._2();
                ArrayBuffer bins = new ArrayBuffer();
                ArrayBuffer currentBin = new ArrayBuffer();
                LongRef currentBinSize = LongRef.create((long)0L);
                ((IterableLike)files.sortBy((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)x$11.size()), (Ordering)Ordering.Long$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)file -> {
                    OptimizeExecutor.$anonfun$groupFilesIntoBins$3(this, currentBinSize, maxTargetFileSize, bins, currentBin, file);
                    return BoxedUnit.UNIT;
                });
                Object object = currentBin.nonEmpty() ? bins.$plus$eq((Object)currentBin.toVector()) : BoxedUnit.UNIT;
                return (ArrayBuffer)((TraversableLike)bins.filter((Function1 & Serializable & scala.Serializable)bin -> BoxesRunTime.boxToBoolean((boolean)OptimizeExecutor.$anonfun$groupFilesIntoBins$4(this, bin)))).map((Function1 & Serializable & scala.Serializable)b -> new Tuple2((Object)partition, b), ArrayBuffer$.MODULE$.canBuildFrom());
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Seq<FileAction> runOptimizeBinJob(OptimisticTransaction txn, Map<String, String> partition, Seq<AddFile> bin, long maxFileSize) {
        Object object;
        Path baseTablePath = txn.deltaLog().dataPath();
        Snapshot x$1 = txn.snapshot();
        Seq<AddFile> x$2 = bin;
        Some x$3 = new Some((Object)"Optimize");
        boolean x$4 = txn.deltaLog().createDataFrame$default$3();
        Dataset<Row> input = txn.deltaLog().createDataFrame(x$1, x$2, x$4, (Option<String>)x$3);
        if (this.isMultiDimClustering()) {
            long totalSize = BoxesRunTime.unboxToLong((Object)((TraversableOnce)bin.map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.size()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            int approxNumFiles = (int)Math.max(1L, totalSize / maxFileSize);
            object = MultiDimClustering$.MODULE$.cluster(input, approxNumFiles, this.zOrderByColumns);
        } else {
            boolean useRepartition = BoxesRunTime.unboxToBoolean((Object)this.sparkSession.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_OPTIMIZE_REPARTITION_ENABLED()));
            object = useRepartition ? input.repartition(1) : input.coalesce(1);
        }
        Dataset<Row> repartitionDF = object;
        String partitionDesc = ((TraversableOnce)partition.toSeq().map((Function1 & Serializable & scala.Serializable)entry -> new StringBuilder(1).append((String)entry._1()).append("=").append(entry._2()).toString(), Seq$.MODULE$.canBuildFrom())).mkString(",");
        String partitionName = partition.isEmpty() ? "" : new StringBuilder(16).append(" in partition (").append(partitionDesc).append(")").toString();
        String description = new StringBuilder(22).append(baseTablePath).append("<br/>Optimizing ").append(bin.size()).append(" files").append(partitionName).toString();
        this.sparkSession.sparkContext().setJobGroup(this.sparkSession.sparkContext().getLocalProperty(SparkContext$.MODULE$.SPARK_JOB_GROUP_ID()), description, this.sparkSession.sparkContext().setJobGroup$default$3());
        Seq addFiles = (Seq)txn.writeFiles(repartitionDF).collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends FileAction, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof AddFile) {
                    AddFile addFile = (AddFile)A1;
                    boolean x$1 = false;
                    String x$2 = addFile.copy$default$1();
                    Map<String, String> x$3 = addFile.copy$default$2();
                    long x$4 = addFile.copy$default$3();
                    long x$5 = addFile.copy$default$4();
                    String x$6 = addFile.copy$default$6();
                    Map<String, String> x$7 = addFile.copy$default$7();
                    DeletionVectorDescriptor x$8 = addFile.copy$default$8();
                    Option<Object> x$9 = addFile.copy$default$9();
                    Option<Object> x$10 = addFile.copy$default$10();
                    return (B1)addFile.copy(x$2, x$3, x$4, x$5, x$1, x$6, x$7, x$8, x$9, x$10);
                }
                throw new IllegalStateException(new StringBuilder(82).append("Unexpected action ").append(A1).append(" with type ").append(A1.getClass()).append(". File compaction job output").append("should only have AddFiles").toString());
            }

            public final boolean isDefinedAt(FileAction x1) {
                FileAction fileAction = x1;
                if (fileAction instanceof AddFile) {
                    return true;
                }
                return true;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq removeFiles = (Seq)bin.map((Function1 & Serializable & scala.Serializable)f -> f.removeWithTimestamp(this.operationTimestamp(), false), Seq$.MODULE$.canBuildFrom());
        Seq updates = (Seq)addFiles.$plus$plus((GenTraversableOnce)removeFiles, Seq$.MODULE$.canBuildFrom());
        return updates;
    }

    private void commitAndRetry(OptimisticTransaction txn, DeltaOperations.Operation optimizeOperation, Seq<Action> actions, Map<String, SQLMetric> metrics, Function1<OptimisticTransaction, Object> f) {
        while (true) {
            try {
                txn.registerSQLMetrics(this.sparkSession, metrics);
                txn.commit(actions, optimizeOperation);
            }
            catch (ConcurrentModificationException e) {
                OptimisticTransaction newTxn = txn.deltaLog().startTransaction(txn.catalogTable(), txn.deltaLog().startTransaction$default$2());
                if (BoxesRunTime.unboxToBoolean((Object)f.apply((Object)newTxn))) {
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Retrying commit after checking for semantic conflicts with concurrent updates.");
                    txn = newTxn;
                    continue;
                }
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Semantic conflicts detected. Aborting operation.");
                throw e;
            }
            break;
        }
    }

    private DeltaOperations.Operation getOperation() {
        if (this.optimizeContext.isPurge()) {
            return new DeltaOperations.Reorg(this.partitionPredicate, DeltaOperations$Reorg$.MODULE$.apply$default$2());
        }
        return new DeltaOperations.Optimize(this.partitionPredicate, this.zOrderByColumns);
    }

    private Map<String, SQLMetric> createMetrics(SparkContext sparkContext, Seq<AddFile> addedFiles, Seq<RemoveFile> removedFiles, Seq<DeletionVectorDescriptor> removedDVs) {
        Tuple2 tuple2 = (Tuple2)((TraversableOnce)removedDVs.map((Function1 & Serializable & scala.Serializable)dv -> new Tuple2.mcJJ.sp(dv.cardinality(), (long)dv.sizeInBytes()), Seq$.MODULE$.canBuildFrom())).reduceLeftOption((Function2 & Serializable & scala.Serializable)(dv1, dv2) -> new Tuple2.mcJJ.sp(dv1._1$mcJ$sp() + dv2._1$mcJ$sp(), dv1._2$mcJ$sp() + dv2._2$mcJ$sp())).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Tuple2.mcJJ.sp(0L, 0L));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long deletionVectorRowsRemoved = tuple2._1$mcJ$sp();
        long deletionVectorBytesRemoved = tuple2._2$mcJ$sp();
        Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(deletionVectorRowsRemoved, deletionVectorBytesRemoved);
        long deletionVectorRowsRemoved2 = sp2._1$mcJ$sp();
        long deletionVectorBytesRemoved2 = sp2._2$mcJ$sp();
        Map dvMetrics = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numDeletionVectorsRemoved"), (Object)OptimizeExecutor.setAndReturnMetric$1("total number of deletion vectors removed", removedDVs.size(), sparkContext)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numDeletionVectorRowsRemoved"), (Object)OptimizeExecutor.setAndReturnMetric$1("total number of deletion vector rows removed", deletionVectorRowsRemoved2, sparkContext)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numDeletionVectorBytesRemoved"), (Object)OptimizeExecutor.setAndReturnMetric$1("total number of bytes of removed deletion vectors", deletionVectorBytesRemoved2, sparkContext))}));
        Option<FileSizeStatsWithHistogram> sizeStats = FileSizeStatsWithHistogram$.MODULE$.create((Seq<Object>)((Seq)((SeqLike)addedFiles.map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToLong((long)x$14.size()), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Long$.MODULE$)));
        return ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"minFileSize"), (Object)OptimizeExecutor.setAndReturnMetric$1("minimum file size", ((FileSizeStatsWithHistogram)sizeStats.get()).min(), sparkContext)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"p25FileSize"), (Object)OptimizeExecutor.setAndReturnMetric$1("25th percentile file size", ((FileSizeStatsWithHistogram)sizeStats.get()).p25(), sparkContext)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"p50FileSize"), (Object)OptimizeExecutor.setAndReturnMetric$1("50th percentile file size", ((FileSizeStatsWithHistogram)sizeStats.get()).p50(), sparkContext)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"p75FileSize"), (Object)OptimizeExecutor.setAndReturnMetric$1("75th percentile file size", ((FileSizeStatsWithHistogram)sizeStats.get()).p75(), sparkContext)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxFileSize"), (Object)OptimizeExecutor.setAndReturnMetric$1("maximum file size", ((FileSizeStatsWithHistogram)sizeStats.get()).max(), sparkContext)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numAddedFiles"), (Object)OptimizeExecutor.setAndReturnMetric$1("total number of files added.", addedFiles.size(), sparkContext)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numRemovedFiles"), (Object)OptimizeExecutor.setAndReturnMetric$1("total number of files removed.", removedFiles.size(), sparkContext)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numAddedBytes"), (Object)OptimizeExecutor.setAndReturnMetric$1("total number of bytes added", OptimizeExecutor.totalSize$1(addedFiles), sparkContext)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numRemovedBytes"), (Object)OptimizeExecutor.setAndReturnMetric$1("total number of bytes removed", OptimizeExecutor.totalSize$1(removedFiles), sparkContext))}))).$plus$plus((GenTraversableOnce)dvMetrics);
    }

    public static final /* synthetic */ boolean $anonfun$optimize$6(AddFile x$5) {
        return x$5.deletionVector() != null;
    }

    public static final /* synthetic */ boolean $anonfun$optimize$8(OptimizeExecutor $this, Seq candidateFiles$1, StructType partitionSchema$1, OptimisticTransaction newTxn) {
        Set candidateSetNew;
        StructType newPartitionSchema = newTxn.metadata().partitionSchema();
        Set candidateSetOld = ((TraversableOnce)candidateFiles$1.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.path(), Seq$.MODULE$.canBuildFrom())).toSet();
        if (candidateSetOld.subsetOf((GenSet)(candidateSetNew = ((TraversableOnce)newTxn.filterFiles($this.partitionPredicate, newTxn.filterFiles$default$2()).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.path(), Seq$.MODULE$.canBuildFrom())).toSet()))) {
            StructType structType = partitionSchema$1;
            StructType structType2 = newPartitionSchema;
            if (!(structType != null ? !structType.equals(structType2) : structType2 != null)) {
                return true;
            }
        }
        Set deleted = (Set)candidateSetOld.$minus$minus((GenTraversableOnce)candidateSetNew);
        $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(86).append("The following compacted files were delete ").append("during checkpoint ").append(deleted.mkString(",")).append(". Aborting the compaction.").toString());
        return false;
    }

    public static final /* synthetic */ long $anonfun$optimize$14(RemoveFile x$10) {
        return BoxesRunTime.unboxToLong((Object)x$10.size().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
    }

    private static final boolean shouldCompactBecauseOfDeletedRows$1(AddFile file, double maxDeletedRowsRatio$1) {
        return file.deletionVector() != null && file.numPhysicalRecords().isEmpty() || BoxesRunTime.unboxToDouble((Object)file.deletedToPhysicalRecordsRatio().getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0)) > maxDeletedRowsRatio$1;
    }

    public static final /* synthetic */ boolean $anonfun$pruneCandidateFileList$2(long minFileSize$1, double maxDeletedRowsRatio$1, AddFile addFile) {
        return addFile.size() < minFileSize$1 || OptimizeExecutor.shouldCompactBecauseOfDeletedRows$1(addFile, maxDeletedRowsRatio$1);
    }

    public static final /* synthetic */ void $anonfun$groupFilesIntoBins$3(OptimizeExecutor $this, LongRef currentBinSize$1, long maxTargetFileSize$1, ArrayBuffer bins$1, ArrayBuffer currentBin$1, AddFile file) {
        if (file.size() + currentBinSize$1.elem > maxTargetFileSize$1 && !$this.isMultiDimClustering()) {
            bins$1.$plus$eq((Object)currentBin$1.toVector());
            currentBin$1.clear();
            currentBin$1.$plus$eq((Object)file);
            currentBinSize$1.elem = file.size();
            return;
        }
        currentBin$1.$plus$eq((Object)file);
        currentBinSize$1.elem += file.size();
    }

    public static final /* synthetic */ boolean $anonfun$groupFilesIntoBins$4(OptimizeExecutor $this, Seq bin) {
        return bin.size() > 1 || bin.size() == 1 && ((AddFile)bin.apply(0)).deletionVector() != null || $this.isMultiDimClustering();
    }

    private static final SQLMetric setAndReturnMetric$1(String description, long value, SparkContext sparkContext$1) {
        SQLMetric metric = SQLMetrics$.MODULE$.createMetric(sparkContext$1, description);
        metric.set(value);
        return metric;
    }

    public static final /* synthetic */ void $anonfun$createMetrics$1(LongRef totalSize$2, FileAction file) {
        long l;
        FileAction fileAction = file;
        if (fileAction instanceof AddFile) {
            AddFile addFile = (AddFile)fileAction;
            l = addFile.size();
        } else if (fileAction instanceof RemoveFile) {
            RemoveFile removeFile = (RemoveFile)fileAction;
            l = BoxesRunTime.unboxToLong((Object)removeFile.size().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        } else {
            throw new IllegalArgumentException(new StringBuilder(25).append("Unknown FileAction type: ").append(fileAction.getClass()).toString());
        }
        long fileSize = l;
        totalSize$2.elem += fileSize;
    }

    private static final long totalSize$1(Seq actions) {
        LongRef totalSize = LongRef.create((long)0L);
        actions.foreach((Function1 & Serializable & scala.Serializable)file -> {
            OptimizeExecutor.$anonfun$createMetrics$1(totalSize, file);
            return BoxedUnit.UNIT;
        });
        return totalSize.elem;
    }

    public OptimizeExecutor(SparkSession sparkSession, OptimisticTransaction txn, Seq<Expression> partitionPredicate, Seq<String> zOrderByColumns, DeltaOptimizeContext optimizeContext) {
        this.sparkSession = sparkSession;
        this.txn = txn;
        this.partitionPredicate = partitionPredicate;
        this.zOrderByColumns = zOrderByColumns;
        this.optimizeContext = optimizeContext;
        Logging.$init$((Logging)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
        DeltaCommand.$init$(this);
        SQLMetricsReporting.$init$(this);
        this.operationTimestamp = new SystemClock().getTimeMillis();
        this.isMultiDimClustering = zOrderByColumns.nonEmpty();
    }
}

