/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands.convert;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.hadoop.Footer;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.SerializableFileStatus;
import org.apache.spark.sql.delta.SerializableFileStatus$;
import org.apache.spark.sql.delta.commands.convert.ConvertTargetFile;
import org.apache.spark.sql.delta.commands.convert.ConvertTargetFileManifest;
import org.apache.spark.sql.delta.commands.convert.ConvertUtils$;
import org.apache.spark.sql.delta.commands.convert.ParquetSchemaFetchConfig;
import org.apache.spark.sql.delta.implicits.package$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.util.DeltaFileOperations$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter$;
import org.apache.spark.sql.execution.streaming.MetadataLogFileIndex;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005%a\u0001\u0002\b\u0010\u0001yA\u0001\u0002\u0007\u0001\u0003\u0002\u0003\u0006I!\r\u0005\tk\u0001\u0011)\u0019!C!m!AA\t\u0001B\u0001B\u0003%q\u0007\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003G\u0011!a\u0005A!A!\u0002\u0013i\u0005\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011B)\t\u000b]\u0003A\u0011\u0001-\t\u000f}\u0003!\u0019!C\u0001A\"1\u0011\u000e\u0001Q\u0001\n\u0005DQA\u001b\u0001\u0005\u0012-D\u0001b\u001d\u0001\t\u0006\u0004%\t\u0005\u001e\u0005\ts\u0002A)\u0019!C!u\"1q\u0010\u0001C!\u0003\u0003\u0011q#T3uC\u0012\fG/\u0019'pO\u001aKG.Z'b]&4Wm\u001d;\u000b\u0005A\t\u0012aB2p]Z,'\u000f\u001e\u0006\u0003%M\t\u0001bY8n[\u0006tGm\u001d\u0006\u0003)U\tQ\u0001Z3mi\u0006T!AF\f\u0002\u0007M\fHN\u0003\u0002\u00193\u0005)1\u000f]1sW*\u0011!dG\u0001\u0007CB\f7\r[3\u000b\u0003q\t1a\u001c:h\u0007\u0001\u0019B\u0001A\u0010(WA\u0011\u0001%J\u0007\u0002C)\u0011!eI\u0001\u0005Y\u0006twMC\u0001%\u0003\u0011Q\u0017M^1\n\u0005\u0019\n#AB(cU\u0016\u001cG\u000f\u0005\u0002)S5\tq\"\u0003\u0002+\u001f\tI2i\u001c8wKJ$H+\u0019:hKR4\u0015\u000e\\3NC:Lg-Z:u!\tas&D\u0001.\u0015\tq3#\u0001\u0005nKR,'/\u001b8h\u0013\t\u0001TF\u0001\u0007EK2$\u0018\rT8hO&tw\r\u0005\u00023g5\tQ#\u0003\u00025+\ta1\u000b]1sWN+7o]5p]\u0006A!-Y:f!\u0006$\b.F\u00018!\tA\u0014I\u0004\u0002:\u007fA\u0011!(P\u0007\u0002w)\u0011A(H\u0001\u0007yI|w\u000e\u001e \u000b\u0003y\nQa]2bY\u0006L!\u0001Q\u001f\u0002\rA\u0013X\rZ3g\u0013\t\u00115I\u0001\u0004TiJLgn\u001a\u0006\u0003\u0001v\n\u0011BY1tKB\u000bG\u000f\u001b\u0011\u0002\u001fA\f'\u000f^5uS>t7k\u00195f[\u0006\u0004\"a\u0012&\u000e\u0003!S!!S\u000b\u0002\u000bQL\b/Z:\n\u0005-C%AC*ueV\u001cG\u000fV=qK\u0006A\u0002/\u0019:rk\u0016$8k\u00195f[\u00064U\r^2i\u0007>tg-[4\u0011\u0005!r\u0015BA(\u0010\u0005a\u0001\u0016M]9vKR\u001c6\r[3nC\u001a+Go\u00195D_:4\u0017nZ\u0001\u0011g\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\"p]\u001a\u0004\"AU+\u000e\u0003MS!\u0001V\f\u0002\tU$\u0018\u000e\\\u0005\u0003-N\u0013\u0011dU3sS\u0006d\u0017N_1cY\u0016\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u00061A(\u001b8jiz\"b!\u0017.\\9vs\u0006C\u0001\u0015\u0001\u0011\u0015Ar\u00011\u00012\u0011\u0015)t\u00011\u00018\u0011\u0015)u\u00011\u0001G\u0011\u0015au\u00011\u0001N\u0011\u0015\u0001v\u00011\u0001R\u0003\u0015Ig\u000eZ3y+\u0005\t\u0007C\u00012h\u001b\u0005\u0019'B\u00013f\u0003%\u0019HO]3b[&twM\u0003\u0002g+\u0005IQ\r_3dkRLwN\\\u0005\u0003Q\u000e\u0014A#T3uC\u0012\fG/\u0019'pO\u001aKG.Z%oI\u0016D\u0018AB5oI\u0016D\b%\u0001\u0004e_2K7\u000f\u001e\u000b\u0002YB\u0019!'\\8\n\u00059,\"a\u0002#bi\u0006\u001cX\r\u001e\t\u0003aFl\u0011aE\u0005\u0003eN\u0011acU3sS\u0006d\u0017N_1cY\u00164\u0015\u000e\\3Ti\u0006$Xo]\u0001\tC2dg)\u001b7fgV\tQ\u000fE\u00023[Z\u0004\"\u0001K<\n\u0005a|!!E\"p]Z,'\u000f\u001e+be\u001e,GOR5mK\u0006i\u0001/\u0019:rk\u0016$8k\u00195f[\u0006,\u0012a\u001f\t\u0004yv4U\"A\u001f\n\u0005yl$AB(qi&|g.A\u0003dY>\u001cX\r\u0006\u0002\u0002\u0004A\u0019A0!\u0002\n\u0007\u0005\u001dQH\u0001\u0003V]&$\b")
public class MetadataLogFileManifest
implements ConvertTargetFileManifest,
DeltaLogging {
    private Dataset<ConvertTargetFile> allFiles;
    private Option<StructType> parquetSchema;
    private final SparkSession spark;
    private final String basePath;
    private final StructType partitionSchema;
    private final ParquetSchemaFetchConfig parquetSchemaFetchConfig;
    private final SerializableConfiguration serializableConf;
    private final MetadataLogFileIndex index;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public Iterator<ConvertTargetFile> getFiles() {
        return ConvertTargetFileManifest.getFiles$(this);
    }

    @Override
    public long numFiles() {
        return ConvertTargetFileManifest.numFiles$(this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String basePath() {
        return this.basePath;
    }

    public MetadataLogFileIndex index() {
        return this.index;
    }

    public Dataset<SerializableFileStatus> doList() {
        RDD qual$1 = this.spark.sparkContext().parallelize(this.index().allFiles(), this.spark.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(FileStatus.class));
        Function1 & Serializable & scala.Serializable x$1 = (Function1 & Serializable & scala.Serializable)x$5 -> x$5.map((Function1 & Serializable & scala.Serializable)status -> SerializableFileStatus$.MODULE$.fromStatus((FileStatus)status));
        boolean x$2 = qual$1.mapPartitions$default$2();
        RDD rdd = qual$1.mapPartitions((Function1)x$1, x$2, ClassTag$.MODULE$.apply(SerializableFileStatus.class));
        return this.spark.createDataset(rdd, package$.MODULE$.serializableFileStatusEncoder());
    }

    private Dataset<ConvertTargetFile> allFiles$lzycompute() {
        MetadataLogFileManifest metadataLogFileManifest = this;
        synchronized (metadataLogFileManifest) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Broadcast conf = this.spark.sparkContext().broadcast((Object)this.serializableConf, ClassTag$.MODULE$.apply(SerializableConfiguration.class));
                ParquetSchemaFetchConfig fetchConfig = this.parquetSchemaFetchConfig;
                Dataset files = this.doList().mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
                    Seq fileStatuses = iter.toSeq();
                    Map pathToStatusMapping = ((TraversableOnce)fileStatuses.map((Function1 & Serializable & scala.Serializable)fileStatus -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fileStatus.path()), fileStatus), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                    Seq<Footer> footerSeq = DeltaFileOperations$.MODULE$.readParquetFootersInParallel(((SerializableConfiguration)conf.value()).value(), (Seq<FileStatus>)((Seq)fileStatuses.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.toFileStatus(), Seq$.MODULE$.canBuildFrom())), fetchConfig.ignoreCorruptFiles());
                    ParquetToSparkSchemaConverter schemaConverter = new ParquetToSparkSchemaConverter(fetchConfig.assumeBinaryIsString(), fetchConfig.assumeInt96IsTimestamp(), ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$3(), ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$4(), ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$5());
                    return ((IterableLike)footerSeq.map((Function1 & Serializable & scala.Serializable)footer -> {
                        SerializableFileStatus fileStatus = (SerializableFileStatus)pathToStatusMapping.apply((Object)footer.getFile().toString());
                        StructType schema = ParquetFileFormat$.MODULE$.readSchemaFromFooter(footer, schemaConverter);
                        return new ConvertTargetFile(fileStatus, (Option<Map<String, String>>)None$.MODULE$, (Option<String>)new Some((Object)schema.toDDL()));
                    }, Seq$.MODULE$.canBuildFrom())).toIterator();
                }, package$.MODULE$.convertTargetFileEncoder());
                files.cache();
                this.allFiles = files;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.allFiles;
    }

    @Override
    public Dataset<ConvertTargetFile> allFiles() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.allFiles$lzycompute();
        }
        return this.allFiles;
    }

    private Option<StructType> parquetSchema$lzycompute() {
        MetadataLogFileManifest metadataLogFileManifest = this;
        synchronized (metadataLogFileManifest) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.parquetSchema = (Option)this.recordDeltaOperationForTablePath(this.basePath(), "delta.convert.schemaInference", this.recordDeltaOperationForTablePath$default$3(), (Function0 & Serializable & scala.Serializable)() -> new Some((Object)ConvertUtils$.MODULE$.mergeSchemasInParallel($this.spark, $this.partitionSchema, this.allFiles())));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.parquetSchema;
    }

    @Override
    public Option<StructType> parquetSchema() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.parquetSchema$lzycompute();
        }
        return this.parquetSchema;
    }

    @Override
    public void close() {
        this.allFiles().unpersist();
    }

    public MetadataLogFileManifest(SparkSession spark, String basePath, StructType partitionSchema, ParquetSchemaFetchConfig parquetSchemaFetchConfig, SerializableConfiguration serializableConf) {
        this.spark = spark;
        this.basePath = basePath;
        this.partitionSchema = partitionSchema;
        this.parquetSchemaFetchConfig = parquetSchemaFetchConfig;
        this.serializableConf = serializableConf;
        ConvertTargetFileManifest.$init$(this);
        Logging.$init$((Logging)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
        this.index = new MetadataLogFileIndex(spark, new Path(basePath), Predef$.MODULE$.Map().empty(), (Option)None$.MODULE$);
    }
}

