/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.files;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaLog$;
import org.apache.spark.sql.delta.DeltaTableUtils$;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.actions.SingleAction$;
import org.apache.spark.sql.delta.implicits.package$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.sources.IndexedFile;
import org.apache.spark.sql.delta.stats.DataSkippingReader$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.delta.util.StateCache;
import org.apache.spark.sql.functions$;
import org.apache.spark.storage.StorageLevel;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=b\u0001B\n\u0015\u0001\u0005B\u0001b\u0007\u0001\u0003\u0006\u0004%\tA\f\u0005\tg\u0001\u0011\t\u0011)A\u0005_!AA\u0007\u0001BC\u0002\u0013\u0005Q\u0007\u0003\u0005;\u0001\t\u0005\t\u0015!\u00037\u0011!Y\u0004A!b\u0001\n\u0003a\u0004\u0002C)\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\t\u000bI\u0003A\u0011A*\t\u000fe\u0003!\u0019!C\t5\"1a\f\u0001Q\u0001\nmCqa\u0018\u0001C\u0002\u0013E\u0001\r\u0003\u0004j\u0001\u0001\u0006I!\u0019\u0005\u000bU\u0002\u0001\n\u0011cb!\n\u0013Y\u0007\u0002\u0003;\u0001\u0011\u000b\u0007I\u0011C;\t\u0011Y\u0004\u0001R1A\u0005\u0012UDaa\u001e\u0001\u0005\u0002YA\bBCA\u0003\u0001!\u0015\r\u0011\"\u0003\u0002\b!9\u0011\u0011\u0003\u0001\u0005\u0002\u0005M\u0001bBA\u000e\u0001\u0011\u0005\u0011Q\u0004\u0002\u0014\t\u0016dG/Y*pkJ\u001cWm\u00158baNDw\u000e\u001e\u0006\u0003+Y\tQAZ5mKNT!a\u0006\r\u0002\u000b\u0011,G\u000e^1\u000b\u0005eQ\u0012aA:rY*\u00111\u0004H\u0001\u0006gB\f'o\u001b\u0006\u0003;y\ta!\u00199bG\",'\"A\u0010\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0011\u0003\u0006\u0005\u0002$M5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9CE\u0001\u0004B]f\u0014VM\u001a\t\u0003S1j\u0011A\u000b\u0006\u0003WY\tA!\u001e;jY&\u0011QF\u000b\u0002\u000b'R\fG/Z\"bG\",W#A\u0018\u0011\u0005A\nT\"\u0001\r\n\u0005IB\"\u0001D*qCJ\\7+Z:tS>t\u0017AB:qCJ\\\u0007%\u0001\u0005t]\u0006\u00048\u000f[8u+\u00051\u0004CA\u001c9\u001b\u00051\u0012BA\u001d\u0017\u0005!\u0019f.\u00199tQ>$\u0018!C:oCB\u001c\bn\u001c;!\u0003\u001d1\u0017\u000e\u001c;feN,\u0012!\u0010\t\u0004}\u0019KeBA E\u001d\t\u00015)D\u0001B\u0015\t\u0011\u0005%\u0001\u0004=e>|GOP\u0005\u0002K%\u0011Q\tJ\u0001\ba\u0006\u001c7.Y4f\u0013\t9\u0005JA\u0002TKFT!!\u0012\u0013\u0011\u0005){U\"A&\u000b\u00051k\u0015aC3yaJ,7o]5p]NT!A\u0014\r\u0002\u0011\r\fG/\u00197zgRL!\u0001U&\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0005gS2$XM]:!\u0003\u0019a\u0014N\\5u}Q!AKV,Y!\t)\u0006!D\u0001\u0015\u0011\u0015Yr\u00011\u00010\u0011\u0015!t\u00011\u00017\u0011\u0015Yt\u00011\u0001>\u0003\u001d1XM]:j_:,\u0012a\u0017\t\u0003GqK!!\u0018\u0013\u0003\t1{gnZ\u0001\tm\u0016\u00148/[8oA\u0005!\u0001/\u0019;i+\u0005\t\u0007C\u00012h\u001b\u0005\u0019'B\u00013f\u0003\t17O\u0003\u0002g9\u00051\u0001.\u00193p_BL!\u0001[2\u0003\tA\u000bG\u000f[\u0001\u0006a\u0006$\b\u000eI\u0001\u0004q\u0012\u0012T#\u00017\u0011\t\rjwn\\\u0005\u0003]\u0012\u0012a\u0001V;qY\u0016\u0014\u0004c\u00019t\u00136\t\u0011O\u0003\u0002sI\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u001d\u000b\u0018\u0001\u00059beRLG/[8o\r&dG/\u001a:t+\u0005y\u0017a\u00033bi\u00064\u0015\u000e\u001c;feN\fQBZ5mi\u0016\u0014X\r\u001a$jY\u0016\u001cX#A=\u0011\u0007ARH0\u0003\u0002|1\t9A)\u0019;bg\u0016$\bcA?\u0002\u00025\taP\u0003\u0002\u0000-\u000591o\\;sG\u0016\u001c\u0018bAA\u0002}\nY\u0011J\u001c3fq\u0016$g)\u001b7f\u0003-\u0019\u0017m\u00195fIN#\u0018\r^3\u0016\u0005\u0005%\u0001#BA\u0006\u0003\u001baX\"\u0001\u0001\n\u0007\u0005=AF\u0001\u0005DC\u000eDW\r\u001a#T\u0003!IG/\u001a:bi>\u0014HCAA\u000b!\u0011q\u0014q\u0003?\n\u0007\u0005e\u0001J\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003\u0015\u0019Gn\\:f)\u0011\ty\"!\n\u0011\u0007\r\n\t#C\u0002\u0002$\u0011\u0012A!\u00168ji\"9\u0011q\u0005\nA\u0002\u0005%\u0012!E;oa\u0016\u00148/[:u':\f\u0007o\u001d5piB\u00191%a\u000b\n\u0007\u00055BEA\u0004C_>dW-\u00198")
public class DeltaSourceSnapshot
implements StateCache {
    private Tuple2<Seq<Expression>, Seq<Expression>> x$2;
    private Seq<Expression> partitionFilters;
    private Seq<Expression> dataFilters;
    private StateCache.CachedDS<IndexedFile> cachedState;
    private final SparkSession spark;
    private final Snapshot snapshot;
    private final Seq<Expression> filters;
    private final long version;
    private final Path path;
    private boolean org$apache$spark$sql$delta$util$StateCache$$_isCached;
    private final ArrayBuffer<RDD<?>> org$apache$spark$sql$delta$util$StateCache$$cached;
    private final StorageLevel org$apache$spark$sql$delta$util$StateCache$$storageLevel;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    @Override
    public boolean isCached() {
        return StateCache.isCached$(this);
    }

    @Override
    public <A> StateCache.CachedDS<A> cacheDS(Dataset<A> ds, String name) {
        return StateCache.cacheDS$(this, ds, name);
    }

    @Override
    public void uncache() {
        StateCache.uncache$(this);
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public boolean org$apache$spark$sql$delta$util$StateCache$$_isCached() {
        return this.org$apache$spark$sql$delta$util$StateCache$$_isCached;
    }

    @Override
    public void org$apache$spark$sql$delta$util$StateCache$$_isCached_$eq(boolean x$1) {
        this.org$apache$spark$sql$delta$util$StateCache$$_isCached = x$1;
    }

    @Override
    public ArrayBuffer<RDD<?>> org$apache$spark$sql$delta$util$StateCache$$cached() {
        return this.org$apache$spark$sql$delta$util$StateCache$$cached;
    }

    @Override
    public StorageLevel org$apache$spark$sql$delta$util$StateCache$$storageLevel() {
        return this.org$apache$spark$sql$delta$util$StateCache$$storageLevel;
    }

    @Override
    public final void org$apache$spark$sql$delta$util$StateCache$_setter_$org$apache$spark$sql$delta$util$StateCache$$cached_$eq(ArrayBuffer<RDD<?>> x$1) {
        this.org$apache$spark$sql$delta$util$StateCache$$cached = x$1;
    }

    @Override
    public final void org$apache$spark$sql$delta$util$StateCache$_setter_$org$apache$spark$sql$delta$util$StateCache$$storageLevel_$eq(StorageLevel x$1) {
        this.org$apache$spark$sql$delta$util$StateCache$$storageLevel = x$1;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    public Snapshot snapshot() {
        return this.snapshot;
    }

    public Seq<Expression> filters() {
        return this.filters;
    }

    public long version() {
        return this.version;
    }

    public Path path() {
        return this.path;
    }

    private Tuple2<Seq<Expression>, Seq<Expression>> x$2$lzycompute() {
        DeltaSourceSnapshot deltaSourceSnapshot = this;
        synchronized (deltaSourceSnapshot) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Seq<String> partitionCols = this.snapshot().metadata().partitionColumns();
                Tuple2 tuple2 = this.filters().partition((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)DeltaTableUtils$.MODULE$.isPredicatePartitionColumnsOnly(e, (Seq<String>)partitionCols, this.spark())));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Seq part = (Seq)tuple2._1();
                Seq data = (Seq)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)part, (Object)data);
                Seq part2 = (Seq)tuple22._1();
                Seq data2 = (Seq)tuple22._2();
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Classified filters: partition: ").append(part2).append(", data: ").append(data2).toString());
                Tuple2 tuple23 = new Tuple2((Object)part2, (Object)data2);
                if (tuple23 == null) {
                    throw new MatchError((Object)tuple23);
                }
                Seq partitionFilters = (Seq)tuple23._1();
                Seq dataFilters = (Seq)tuple23._2();
                this.x$2 = new Tuple2((Object)partitionFilters, (Object)dataFilters);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.x$2;
    }

    private /* synthetic */ Tuple2 x$2() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.x$2$lzycompute();
        }
        return this.x$2;
    }

    private Seq<Expression> partitionFilters$lzycompute() {
        DeltaSourceSnapshot deltaSourceSnapshot = this;
        synchronized (deltaSourceSnapshot) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.partitionFilters = (Seq)this.x$2()._1();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.partitionFilters;
    }

    public Seq<Expression> partitionFilters() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.partitionFilters$lzycompute();
        }
        return this.partitionFilters;
    }

    private Seq<Expression> dataFilters$lzycompute() {
        DeltaSourceSnapshot deltaSourceSnapshot = this;
        synchronized (deltaSourceSnapshot) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.dataFilters = (Seq)this.x$2()._2();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.dataFilters;
    }

    public Seq<Expression> dataFilters() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.dataFilters$lzycompute();
        }
        return this.dataFilters;
    }

    public Dataset<IndexedFile> filteredFiles() {
        Dataset initialFiles = this.spark().implicits().rddToDatasetHolder(this.snapshot().allFiles().repartitionByRange(this.snapshot().getNumPartitions(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("modificationTime"), functions$.MODULE$.col("path")})).sort("modificationTime", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"path"})).rdd().zipWithIndex(), package$.MODULE$.addFileWithIndexEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"add", "index"})).withColumn("add", functions$.MODULE$.col("add").withField("stats", DataSkippingReader$.MODULE$.nullStringLiteral())).withColumn("remove", SingleAction$.MODULE$.nullLitForRemoveFile()).withColumn("cdc", SingleAction$.MODULE$.nullLitForAddCDCFile()).withColumn("version", functions$.MODULE$.lit((Object)BoxesRunTime.boxToLong((long)this.version()))).withColumn("isLast", functions$.MODULE$.lit((Object)BoxesRunTime.boxToBoolean((boolean)false))).withColumn("shouldSkip", functions$.MODULE$.lit((Object)BoxesRunTime.boxToBoolean((boolean)false)));
        return DeltaLog$.MODULE$.filterFileList(this.snapshot().metadata().partitionSchema(), (Dataset<Row>)initialFiles, this.partitionFilters(), (Seq<String>)((Seq)new .colon.colon((Object)"add", (List)Nil$.MODULE$)), DeltaLog$.MODULE$.filterFileList$default$5()).as(package$.MODULE$.indexedFileEncoder());
    }

    private StateCache.CachedDS<IndexedFile> cachedState$lzycompute() {
        DeltaSourceSnapshot deltaSourceSnapshot = this;
        synchronized (deltaSourceSnapshot) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.cachedState = this.cacheDS(this.filteredFiles(), new StringBuilder(26).append("Delta Source Snapshot #").append(this.version()).append(" - ").append(this.snapshot().redactedPath()).toString());
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.cachedState;
    }

    private StateCache.CachedDS<IndexedFile> cachedState() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.cachedState$lzycompute();
        }
        return this.cachedState;
    }

    public Iterator<IndexedFile> iterator() {
        return (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(this.cachedState().getDS().toLocalIterator()).asScala();
    }

    public void close(boolean unpersistSnapshot) {
        this.uncache();
        if (unpersistSnapshot) {
            this.snapshot().uncache();
            return;
        }
    }

    public DeltaSourceSnapshot(SparkSession spark, Snapshot snapshot, Seq<Expression> filters) {
        this.spark = spark;
        this.snapshot = snapshot;
        this.filters = filters;
        Logging.$init$((Logging)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
        StateCache.$init$(this);
        this.version = snapshot.version();
        this.path = snapshot.path();
    }
}

