/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.schema;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute$;
import org.apache.spark.sql.catalyst.analysis.package$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.delta.DeltaAnalysisException;
import org.apache.spark.sql.delta.DeltaAnalysisException$;
import org.apache.spark.sql.delta.DeltaColumnMappingMode;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.GeneratedColumn$;
import org.apache.spark.sql.delta.NoMapping$;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.commands.cdc.CDCReader$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.schema.SchemaMergingUtils$;
import org.apache.spark.sql.delta.schema.UnsupportedDataTypeInfo;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.sources.DeltaSourceUtils$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampNTZType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.NonLocalReturnControl;
import scala.util.control.NonFatal$;

public final class SchemaUtils$
implements DeltaLogging {
    public static SchemaUtils$ MODULE$;
    private final Function2<String, String, Object> DELTA_COL_RESOLVER;
    private final int ARRAY_ELEMENT_INDEX;
    private final int MAP_KEY_INDEX;
    private final int MAP_VALUE_INDEX;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new SchemaUtils$();
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Function2<String, String, Object> DELTA_COL_RESOLVER() {
        return this.DELTA_COL_RESOLVER;
    }

    private int ARRAY_ELEMENT_INDEX() {
        return this.ARRAY_ELEMENT_INDEX;
    }

    private int MAP_KEY_INDEX() {
        return this.MAP_KEY_INDEX;
    }

    private int MAP_VALUE_INDEX() {
        return this.MAP_VALUE_INDEX;
    }

    public Seq<Tuple2<Seq<String>, StructField>> filterRecursively(StructType schema, boolean checkComplexTypes, Function1<StructField, Object> f) {
        return this.recurseIntoComplexTypes$1((DataType)schema, (Seq)Nil$.MODULE$, f, checkComplexTypes);
    }

    public boolean typeExistsRecursively(DataType dt, Function1<DataType, Object> f) {
        DataType dataType;
        block4: {
            while (true) {
                if ((dataType = dt) instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    return BoxesRunTime.unboxToBoolean((Object)f.apply((Object)structType)) || new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.fields())).exists((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.MODULE$.typeExistsRecursively(field.dataType(), (Function1<DataType, Object>)f)));
                }
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    if (!BoxesRunTime.unboxToBoolean((Object)f.apply((Object)arrayType))) {
                        dt = arrayType.elementType();
                        continue;
                    }
                    return true;
                }
                if (!(dataType instanceof MapType)) break block4;
                MapType mapType = (MapType)dataType;
                if (BoxesRunTime.unboxToBoolean((Object)f.apply((Object)mapType)) || this.typeExistsRecursively(mapType.keyType(), f)) break;
                dt = mapType.valueType();
            }
            return true;
        }
        return BoxesRunTime.unboxToBoolean((Object)f.apply((Object)dataType));
    }

    public DataType typeAsNullable(DataType dt) {
        DataType s2;
        DataType s1;
        boolean bl = false;
        ArrayType arrayType = null;
        boolean bl2 = false;
        MapType mapType = null;
        DataType dataType = dt;
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            return structType.asNullable();
        }
        if (dataType instanceof ArrayType) {
            bl = true;
            arrayType = (ArrayType)dataType;
            DataType s = arrayType.elementType();
            if (s instanceof StructType) {
                StructType structType = (StructType)s;
                return arrayType.copy((DataType)structType.asNullable(), true);
            }
        }
        if (bl) {
            boolean x$1 = true;
            DataType x$2 = arrayType.copy$default$1();
            return arrayType.copy(x$2, x$1);
        }
        if (dataType instanceof MapType) {
            bl2 = true;
            mapType = (MapType)dataType;
            DataType s12 = mapType.keyType();
            DataType s22 = mapType.valueType();
            if (s12 instanceof StructType) {
                StructType structType = (StructType)s12;
                if (s22 instanceof StructType) {
                    StructType structType2 = (StructType)s22;
                    return mapType.copy((DataType)structType.asNullable(), (DataType)structType2.asNullable(), true);
                }
            }
        }
        if (bl2 && (s1 = mapType.keyType()) instanceof StructType) {
            StructType structType = (StructType)s1;
            StructType x$3 = structType.asNullable();
            boolean x$4 = true;
            DataType x$5 = mapType.copy$default$2();
            return mapType.copy((DataType)x$3, x$5, x$4);
        }
        if (bl2 && (s2 = mapType.valueType()) instanceof StructType) {
            StructType structType = (StructType)s2;
            StructType x$6 = structType.asNullable();
            boolean x$7 = true;
            DataType x$8 = mapType.copy$default$1();
            return mapType.copy(x$8, (DataType)x$6, x$7);
        }
        return dataType;
    }

    public Dataset<Row> dropNullTypeColumns(Dataset<Row> df) {
        StructType schema = df.schema();
        if (!this.typeExistsRecursively((DataType)schema, (Function1<DataType, Object>)(Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$dropNullTypeColumns$1(x$1)))) {
            return df;
        }
        Seq selectExprs = (Seq)schema.flatMap((Function1 & Serializable & scala.Serializable)f -> {
            if (f.dataType() instanceof NullType) {
                return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return Option$.MODULE$.option2Iterable((Option)new Some((Object)this.generateSelectExpr$1((StructField)f, (Seq)Nil$.MODULE$)));
        }, Seq$.MODULE$.canBuildFrom());
        return df.select(selectExprs);
    }

    public StructType dropNullTypeColumns(StructType schema) {
        return StructType$.MODULE$.apply(SchemaUtils$.recurseAndRemove$1(schema));
    }

    public Option<String> findNullTypeColumn(StructType schema) {
        if (this.typeExistsRecursively((DataType)schema, (Function1<DataType, Object>)(Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$findNullTypeColumn$2(x$4)))) {
            return SchemaUtils$.findNullTypeColumnRec$1(schema, (Seq)Nil$.MODULE$);
        }
        return None$.MODULE$;
    }

    public Dataset<Row> normalizeColumnNames(StructType baseSchema, Dataset<?> data) {
        scala.collection.immutable.Set tableFields;
        StructType dataSchema = data.schema();
        scala.collection.immutable.Set dataFields = SchemaMergingUtils$.MODULE$.explodeNestedFieldNames(dataSchema).toSet();
        if (dataFields.subsetOf((GenSet)(tableFields = SchemaMergingUtils$.MODULE$.explodeNestedFieldNames(baseSchema).toSet()))) {
            return data.toDF();
        }
        scala.collection.immutable.Set nonCdcFields = (scala.collection.immutable.Set)dataFields.filterNot((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$normalizeColumnNames$1(f)));
        if (nonCdcFields.subsetOf((GenSet)tableFields)) {
            return data.toDF();
        }
        scala.collection.immutable.Set topLevelDataFields = (scala.collection.immutable.Set)dataFields.map((Function1 & Serializable & scala.Serializable)x$5 -> (String)UnresolvedAttribute$.MODULE$.parseAttributeName(x$5).head(), scala.collection.immutable.Set$.MODULE$.canBuildFrom());
        if (topLevelDataFields.subsetOf((GenSet)tableFields)) {
            scala.collection.immutable.Set columnsThatNeedRenaming = (scala.collection.immutable.Set)dataFields.$minus$minus((GenTraversableOnce)tableFields);
            throw DeltaErrors$.MODULE$.nestedFieldsNeedRename((scala.collection.immutable.Set<String>)columnsThatNeedRenaming, baseSchema);
        }
        Map<String, StructField> baseFields = SchemaMergingUtils$.MODULE$.toFieldMap((Seq<StructField>)baseSchema, SchemaMergingUtils$.MODULE$.toFieldMap$default$2());
        Seq aliasExpressions = (Seq)dataSchema.map((Function1 & Serializable & scala.Serializable)field -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:722)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }, Seq$.MODULE$.canBuildFrom());
        return data.select(aliasExpressions);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isPartitionCompatible(Seq<String> newPartitionColumns, Seq<String> oldPartitionColumns) {
        if (newPartitionColumns.isEmpty()) {
            if (oldPartitionColumns.isEmpty()) return true;
        }
        Seq<String> seq = newPartitionColumns;
        Seq<String> seq2 = oldPartitionColumns;
        if (seq != null) {
            if (!seq.equals(seq2)) return false;
            return true;
        }
        if (seq2 == null) return true;
        return false;
    }

    public Seq<String> isPartitionCompatible$default$1() {
        return (Seq)Nil$.MODULE$;
    }

    public Seq<String> isPartitionCompatible$default$2() {
        return (Seq)Nil$.MODULE$;
    }

    public boolean isReadCompatible(StructType existingSchema, StructType readSchema, boolean forbidTightenNullability, boolean allowMissingColumns, Seq<String> newPartitionColumns, Seq<String> oldPartitionColumns) {
        return this.isStructReadCompatible$1(existingSchema, readSchema, allowMissingColumns, newPartitionColumns, oldPartitionColumns, forbidTightenNullability);
    }

    public boolean isReadCompatible$default$3() {
        return false;
    }

    public boolean isReadCompatible$default$4() {
        return false;
    }

    public Seq<String> isReadCompatible$default$5() {
        return (Seq)Nil$.MODULE$;
    }

    public Seq<String> isReadCompatible$default$6() {
        return (Seq)Nil$.MODULE$;
    }

    public Seq<String> reportDifferences(StructType existingSchema, StructType specifiedSchema) {
        return SchemaUtils$.structDifference$1(existingSchema, CharVarcharUtils$.MODULE$.replaceCharVarcharWithStringInSchema(specifiedSchema), "");
    }

    public Option<StructField> findNestedFieldIgnoreCase(StructType schema, Seq<String> fieldNames, boolean includeCollections) {
        return this.findRecursively$1((DataType)schema, fieldNames, includeCollections);
    }

    public boolean findNestedFieldIgnoreCase$default$3() {
        return false;
    }

    public Seq<Object> findColumnPosition(Seq<String> column, StructType schema, Function2<String, String, Object> resolver) {
        Seq seq;
        try {
            seq = this.findRecursively$2(column, (DataType)schema, SchemaUtils$.findRecursively$default$3$1(), resolver, schema);
        }
        catch (AnalysisException e) {
            throw new AnalysisException(new StringBuilder(2).append(e.getMessage()).append(":\n").append(schema.treeString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
        }
        return seq;
    }

    public Function2<String, String, Object> findColumnPosition$default$3() {
        return this.DELTA_COL_RESOLVER();
    }

    public StructField getNestedFieldFromPosition(StructField parent, Seq<Object> position) {
        DataType dataType;
        int fieldPos;
        while (true) {
            if (position.isEmpty()) {
                return parent;
            }
            fieldPos = BoxesRunTime.unboxToInt((Object)position.head());
            boolean bl = false;
            MapType mapType = null;
            dataType = parent.dataType();
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                if (fieldPos >= 0 && fieldPos < structType.size()) {
                    position = (Seq)position.tail();
                    parent = structType.apply(fieldPos);
                    continue;
                }
            }
            if (dataType instanceof MapType) {
                bl = true;
                mapType = (MapType)dataType;
                if (fieldPos == this.MAP_KEY_INDEX()) {
                    position = (Seq)position.tail();
                    parent = new StructField("key", mapType.keyType(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                    continue;
                }
            }
            if (bl && fieldPos == this.MAP_VALUE_INDEX()) {
                position = (Seq)position.tail();
                parent = new StructField("value", mapType.valueType(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                continue;
            }
            if (!(dataType instanceof ArrayType)) break;
            ArrayType arrayType = (ArrayType)dataType;
            if (fieldPos != this.ARRAY_ELEMENT_INDEX()) break;
            position = (Seq)position.tail();
            parent = new StructField("element", arrayType.elementType(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        }
        if (dataType instanceof StructType ? true : (dataType instanceof ArrayType ? true : dataType instanceof MapType)) {
            throw new IllegalArgumentException(new StringBuilder(27).append("Invalid child position ").append(fieldPos).append(" in ").append(parent.dataType()).toString());
        }
        throw new IllegalArgumentException(new StringBuilder(38).append("Invalid indexing into non-nested type ").append(dataType).toString());
    }

    public DataType getNestedTypeFromPosition(StructType schema, Seq<Object> position) {
        return this.getNestedFieldFromPosition(new StructField("schema", (DataType)schema, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), position).dataType();
    }

    public String prettyFieldName(Seq<String> columnPath) {
        return new UnresolvedAttribute(columnPath).name();
    }

    public StructType addColumn(StructType schema, StructField column, Seq<Object> position) {
        Predef$.MODULE$.require(position.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Don't know where to add the column ").append(column).toString());
        int slicePosition = BoxesRunTime.unboxToInt((Object)position.head());
        if (slicePosition < 0) {
            throw DeltaErrors$.MODULE$.addColumnAtIndexLessThanZeroException(Integer.toString(slicePosition), column.toString());
        }
        int length = schema.length();
        if (slicePosition > length) {
            throw DeltaErrors$.MODULE$.indexLargerThanStruct(slicePosition, column, length);
        }
        if (slicePosition == length) {
            if (position.length() > 1) {
                throw DeltaErrors$.MODULE$.addColumnStructNotFoundException(Integer.toString(slicePosition));
            }
            return StructType$.MODULE$.apply((Seq)schema.$colon$plus((Object)column, Seq$.MODULE$.canBuildFrom()));
        }
        Tuple2 tuple2 = schema.splitAt(slicePosition);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq pre = (Seq)tuple2._1();
        Seq post = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)pre, (Object)post);
        Seq pre2 = (Seq)tuple22._1();
        Seq post2 = (Seq)tuple22._2();
        if (position.length() > 1) {
            StructField field = (StructField)post2.head();
            if (!column.nullable() && field.nullable()) {
                throw DeltaErrors$.MODULE$.nullableParentWithNotNullNestedField();
            }
            DataType x$1 = this.addColumnInChild$1(field.dataType(), column, (Seq)position.tail());
            String x$2 = field.copy$default$1();
            boolean x$3 = field.copy$default$3();
            Metadata x$4 = field.copy$default$4();
            StructField mid = field.copy(x$2, x$1, x$3, x$4);
            return StructType$.MODULE$.apply((Seq)((TraversableLike)pre2.$plus$plus((GenTraversableOnce)new .colon.colon((Object)mid, (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)post2.tail(), Seq$.MODULE$.canBuildFrom()));
        }
        return StructType$.MODULE$.apply((Seq)((TraversableLike)pre2.$plus$plus((GenTraversableOnce)new .colon.colon((Object)column, (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)post2, Seq$.MODULE$.canBuildFrom()));
    }

    public Tuple2<StructType, StructField> dropColumn(StructType schema, Seq<Object> position) {
        Predef$.MODULE$.require(position.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Don't know where to drop the column");
        int slicePosition = BoxesRunTime.unboxToInt((Object)position.head());
        if (slicePosition < 0) {
            throw DeltaErrors$.MODULE$.dropColumnAtIndexLessThanZeroException(slicePosition);
        }
        int length = schema.length();
        if (slicePosition >= length) {
            throw DeltaErrors$.MODULE$.indexLargerOrEqualThanStruct(slicePosition, length);
        }
        Tuple2 tuple2 = schema.splitAt(slicePosition);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq pre = (Seq)tuple2._1();
        Seq post = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)pre, (Object)post);
        Seq pre2 = (Seq)tuple22._1();
        Seq post2 = (Seq)tuple22._2();
        StructField field = (StructField)post2.head();
        if (position.length() > 1) {
            Tuple2 tuple23 = this.dropColumnInChild$1(field.dataType(), (Seq)position.tail());
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            DataType newType = (DataType)tuple23._1();
            StructField droppedColumn = (StructField)tuple23._2();
            Tuple2 tuple24 = new Tuple2((Object)newType, (Object)droppedColumn);
            DataType newType2 = (DataType)tuple24._1();
            StructField droppedColumn2 = (StructField)tuple24._2();
            DataType x$1 = newType2;
            String x$2 = field.copy$default$1();
            boolean x$3 = field.copy$default$3();
            Metadata x$4 = field.copy$default$4();
            StructField mid = field.copy(x$2, x$1, x$3, x$4);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StructType$.MODULE$.apply((Seq)((TraversableLike)pre2.$plus$plus((GenTraversableOnce)new .colon.colon((Object)mid, (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)post2.tail(), Seq$.MODULE$.canBuildFrom()))), (Object)droppedColumn2);
        }
        if (length == 1) {
            throw new AnalysisException(new StringBuilder(59).append("Cannot drop column from a struct type with a single field: ").append(schema).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
        }
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StructType$.MODULE$.apply((Seq)pre2.$plus$plus((GenTraversableOnce)post2.tail(), Seq$.MODULE$.canBuildFrom()))), (Object)field);
    }

    public Option<String> canChangeDataType(DataType from, DataType to, Function2<String, String, Object> resolver, DeltaColumnMappingMode columnMappingMode, Seq<String> columnPath, boolean failOnAmbiguousChanges) {
        Some some;
        try {
            this.check$1(from, to, columnPath, resolver, failOnAmbiguousChanges, columnMappingMode);
            some = None$.MODULE$;
        }
        catch (AnalysisException e) {
            some = new Some((Object)e.message());
        }
        return some;
    }

    public Seq<String> canChangeDataType$default$5() {
        return Nil$.MODULE$;
    }

    public boolean canChangeDataType$default$6() {
        return false;
    }

    public DataType changeDataType(DataType from, DataType to, Function2<String, String, Object> resolver) {
        Tuple2 tuple2 = new Tuple2((Object)from, (Object)to);
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType2 = (DataType)tuple2._2();
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType fromElement = arrayType.elementType();
                boolean fn = arrayType.containsNull();
                if (dataType2 instanceof ArrayType) {
                    ArrayType arrayType2 = (ArrayType)dataType2;
                    DataType toElement = arrayType2.elementType();
                    return new ArrayType(this.changeDataType(fromElement, toElement, resolver), fn);
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType3 = (DataType)tuple2._2();
            if (dataType instanceof MapType) {
                MapType mapType = (MapType)dataType;
                DataType fromKey = mapType.keyType();
                DataType fromValue = mapType.valueType();
                boolean fn = mapType.valueContainsNull();
                if (dataType3 instanceof MapType) {
                    MapType mapType2 = (MapType)dataType3;
                    DataType toKey = mapType2.keyType();
                    DataType toValue = mapType2.valueType();
                    return new MapType(this.changeDataType(fromKey, toKey, resolver), this.changeDataType(fromValue, toValue, resolver), fn);
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType4 = (DataType)tuple2._2();
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                StructField[] fromFields = structType.fields();
                if (dataType4 instanceof StructType) {
                    StructType structType2 = (StructType)dataType4;
                    StructField[] toFields = structType2.fields();
                    return new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])toFields)).map((Function1 & Serializable & scala.Serializable)toField -> (StructField)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fromFields)).find((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$changeDataType$2(resolver, toField, field))).map((Function1 & Serializable & scala.Serializable)fromField -> {
                        StructField qual$1 = (StructField)toField.getComment().map((Function1 & Serializable & scala.Serializable)comment -> fromField.withComment(comment)).getOrElse((Function0 & Serializable & scala.Serializable)() -> fromField);
                        DataType x$1 = MODULE$.changeDataType(fromField.dataType(), toField.dataType(), resolver);
                        boolean x$2 = toField.nullable();
                        String x$3 = qual$1.copy$default$1();
                        Metadata x$4 = qual$1.copy$default$4();
                        return qual$1.copy(x$3, x$1, x$2, x$4);
                    }).getOrElse((Function0 & Serializable & scala.Serializable)() -> toField), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
                }
            }
        }
        if (tuple2 != null) {
            DataType toDataType = (DataType)tuple2._2();
            return toDataType;
        }
        throw new MatchError((Object)tuple2);
    }

    public StructType transformColumnsStructs(StructType schema, Option<String> colName, Function3<Seq<String>, StructType, Function2<String, String, Object>, Seq<StructField>> tf) {
        return (StructType)this.transform$1((Seq)Nil$.MODULE$, (DataType)schema, colName, tf);
    }

    public <E> StructType transformColumns(StructType schema, Seq<Tuple2<Seq<String>, E>> input, Function3<Seq<String>, StructField, Seq<Tuple2<Seq<String>, E>>, StructField> tf) {
        Map inputLookup = input.groupBy((Function1 & Serializable & scala.Serializable)x$22 -> (Seq)((TraversableLike)x$22._1()).map((Function1 & Serializable & scala.Serializable)x$23 -> x$23.toLowerCase(), Seq$.MODULE$.canBuildFrom()));
        return SchemaMergingUtils$.MODULE$.transformColumns(schema, (Function3<Seq<String>, StructField, Function2<String, String, Object>, StructField>)(Function3 & Serializable & scala.Serializable)(path, field, resolver) -> {
            Seq fullPath = (Seq)path.$colon$plus((Object)field.name(), Seq$.MODULE$.canBuildFrom());
            Seq normalizedFullPath = (Seq)fullPath.map((Function1 & Serializable & scala.Serializable)x$24 -> x$24.toLowerCase(), Seq$.MODULE$.canBuildFrom());
            Seq matches = (Seq)Option$.MODULE$.option2Iterable(inputLookup.get((Object)normalizedFullPath)).toSeq().flatMap((Function1 & Serializable & scala.Serializable)x$25 -> (Seq)x$25.filter((Function1 & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$transformColumns$6(fullPath, resolver, x$26))), Seq$.MODULE$.canBuildFrom());
            if (matches.nonEmpty()) {
                return (StructField)tf.apply(path, field, (Object)matches);
            }
            return field;
        });
    }

    public Option<String> transformColumnsStructs$default$2() {
        return None$.MODULE$;
    }

    public void checkSchemaFieldNames(StructType schema, DeltaColumnMappingMode columnMappingMode) {
        DeltaColumnMappingMode deltaColumnMappingMode = columnMappingMode;
        NoMapping$ noMapping$ = NoMapping$.MODULE$;
        if (deltaColumnMappingMode == null ? noMapping$ != null : !deltaColumnMappingMode.equals(noMapping$)) {
            return;
        }
        try {
            this.checkFieldNames(SchemaMergingUtils$.MODULE$.explodeNestedFieldNames(schema));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw DeltaErrors$.MODULE$.foundInvalidCharsInColumnNames(e);
            }
            throw throwable;
        }
    }

    public void checkFieldNames(Seq<String> names) {
        names.foreach((Function1 & Serializable & scala.Serializable)name -> {
            SchemaUtils$.$anonfun$checkFieldNames$1(name);
            return BoxedUnit.UNIT;
        });
        names.find((Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)x$27.contains("\n"))).foreach((Function1 & Serializable & scala.Serializable)col -> {
            throw DeltaErrors$.MODULE$.invalidColumnName((String)col);
        });
    }

    public StructType removeUnenforceableNotNullConstraints(StructType schema, SQLConf conf) {
        boolean allowUnenforceableNotNulls = BoxesRunTime.unboxToBoolean((Object)conf.getConf(DeltaSQLConf$.MODULE$.ALLOW_UNENFORCED_NOT_NULL_CONSTRAINTS()));
        return SchemaMergingUtils$.MODULE$.transformColumns(schema, (Function3<Seq<String>, StructField, Function2<String, String, Object>, StructField>)(Function3 & Serializable & scala.Serializable)(path, f, r) -> this.checkField$1((Seq)path, (StructField)f, (Function2)r, allowUnenforceableNotNulls));
    }

    public Column fieldToColumn(StructField field) {
        return new Column((Expression)UnresolvedAttribute$.MODULE$.quoted(field.name()));
    }

    public Column fieldNameToColumn(String field) {
        return functions$.MODULE$.col(this.quoteIdentifier(field));
    }

    public String quoteIdentifier(String part) {
        return new StringBuilder(2).append("`").append(part.replace("`", "``")).append("`").toString();
    }

    public boolean containsDependentExpression(SparkSession spark, Seq<String> columnToChange, String exprString, Function2<String, String, Object> resolver) {
        boolean bl;
        Object object = new Object();
        try {
            Expression expression = spark.sessionState().sqlParser().parseExpression(exprString);
            expression.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                SchemaUtils$.$anonfun$containsDependentExpression$1(columnToChange, resolver, object, x0$1);
                return BoxedUnit.UNIT;
            });
            bl = false;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    public Seq<UnsupportedDataTypeInfo> findUnsupportedDataTypes(StructType schema) {
        ArrayBuffer unsupportedDataTypes = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.findUnsupportedDataTypesRecursively((ArrayBuffer<UnsupportedDataTypeInfo>)unsupportedDataTypes, (DataType)schema, this.findUnsupportedDataTypesRecursively$default$3());
        return unsupportedDataTypes.toSeq();
    }

    public boolean checkForTimestampNTZColumnsRecursively(StructType schema) {
        return this.typeExistsRecursively((DataType)schema, (Function1<DataType, Object>)(Function1 & Serializable & scala.Serializable)x$28 -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$checkForTimestampNTZColumnsRecursively$1(x$28)));
    }

    private void findUnsupportedDataTypesRecursively(ArrayBuffer<UnsupportedDataTypeInfo> unsupportedDataTypes, DataType dataType, Seq<String> columnPath) {
        block22: {
            DataType dataType2;
            while (true) {
                if (NullType$.MODULE$.equals(dataType2 = dataType)) {
                    break block22;
                }
                if (BooleanType$.MODULE$.equals(dataType2)) {
                    break block22;
                }
                if (ByteType$.MODULE$.equals(dataType2)) {
                    break block22;
                }
                if (ShortType$.MODULE$.equals(dataType2)) {
                    break block22;
                }
                if (IntegerType$.MODULE$.equals(dataType2)) {
                    break block22;
                }
                if (dataType2 instanceof YearMonthIntervalType) {
                    YearMonthIntervalType yearMonthIntervalType = (YearMonthIntervalType)dataType2;
                    Predef$.MODULE$.assert(columnPath.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "'columnPath' must not be empty");
                    unsupportedDataTypes.$plus$eq((Object)new UnsupportedDataTypeInfo(this.prettyFieldName(columnPath), (DataType)yearMonthIntervalType));
                    break block22;
                }
                if (LongType$.MODULE$.equals(dataType2)) {
                    break block22;
                }
                if (dataType2 instanceof DayTimeIntervalType) {
                    DayTimeIntervalType dayTimeIntervalType = (DayTimeIntervalType)dataType2;
                    Predef$.MODULE$.assert(columnPath.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "'columnPath' must not be empty");
                    unsupportedDataTypes.$plus$eq((Object)new UnsupportedDataTypeInfo(this.prettyFieldName(columnPath), (DataType)dayTimeIntervalType));
                    break block22;
                }
                if (FloatType$.MODULE$.equals(dataType2)) {
                    break block22;
                }
                if (DoubleType$.MODULE$.equals(dataType2)) {
                    break block22;
                }
                if (StringType$.MODULE$.equals(dataType2)) {
                    break block22;
                }
                if (DateType$.MODULE$.equals(dataType2)) {
                    break block22;
                }
                if (TimestampType$.MODULE$.equals(dataType2)) {
                    break block22;
                }
                if (TimestampNTZType$.MODULE$.equals(dataType2)) {
                    break block22;
                }
                if (BinaryType$.MODULE$.equals(dataType2)) {
                    break block22;
                }
                if (dataType2 instanceof DecimalType) {
                    break block22;
                }
                if (dataType2 instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType2;
                    Predef$.MODULE$.assert(columnPath.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "'columnPath' must not be empty");
                    columnPath = (Seq)((SeqLike)columnPath.dropRight(1)).$colon$plus((Object)new StringBuilder(2).append((String)columnPath.last()).append("[]").toString(), Seq$.MODULE$.canBuildFrom());
                    dataType = arrayType.elementType();
                    continue;
                }
                if (dataType2 instanceof MapType) {
                    MapType mapType = (MapType)dataType2;
                    Predef$.MODULE$.assert(columnPath.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "'columnPath' must not be empty");
                    this.findUnsupportedDataTypesRecursively(unsupportedDataTypes, mapType.keyType(), (Seq<String>)((Seq)((SeqLike)columnPath.dropRight(1)).$colon$plus((Object)new StringBuilder(5).append((String)columnPath.last()).append("[key]").toString(), Seq$.MODULE$.canBuildFrom())));
                    columnPath = (Seq)((SeqLike)columnPath.dropRight(1)).$colon$plus((Object)new StringBuilder(7).append((String)columnPath.last()).append("[value]").toString(), Seq$.MODULE$.canBuildFrom());
                    dataType = mapType.valueType();
                    continue;
                }
                if (dataType2 instanceof StructType) {
                    StructType structType = (StructType)dataType2;
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.fields())).foreach((Function1 & Serializable & scala.Serializable)f -> {
                        SchemaUtils$.MODULE$.findUnsupportedDataTypesRecursively((ArrayBuffer<UnsupportedDataTypeInfo>)unsupportedDataTypes, f.dataType(), (Seq<String>)((Seq)columnPath.$colon$plus((Object)f.name(), Seq$.MODULE$.canBuildFrom())));
                        return BoxedUnit.UNIT;
                    });
                    break block22;
                }
                if (!(dataType2 instanceof UserDefinedType)) break;
                UserDefinedType userDefinedType = (UserDefinedType)dataType2;
                dataType = userDefinedType.sqlType();
            }
            if (dataType2 != null) {
                DataType dataType3 = dataType2;
                Predef$.MODULE$.assert(columnPath.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "'columnPath' must not be empty");
                unsupportedDataTypes.$plus$eq((Object)new UnsupportedDataTypeInfo(this.prettyFieldName(columnPath), dataType3));
            } else {
                throw new MatchError((Object)dataType2);
            }
        }
    }

    private Seq<String> findUnsupportedDataTypesRecursively$default$3() {
        return Nil$.MODULE$;
    }

    public Seq<StructField> findDependentGeneratedColumns(SparkSession sparkSession, Seq<String> targetColumn, Protocol protocol, StructType schema) {
        if (GeneratedColumn$.MODULE$.satisfyGeneratedColumnProtocol(protocol) && GeneratedColumn$.MODULE$.hasGeneratedColumns(schema)) {
            ArrayBuffer dependentGenCols = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            SchemaMergingUtils$.MODULE$.transformColumns(schema, (Function3<Seq<String>, StructField, Function2<String, String, Object>, StructField>)(Function3 & Serializable & scala.Serializable)(x$29, field, x$30) -> {
                GeneratedColumn$.MODULE$.getGenerationExpressionStr(field.metadata()).foreach((Function1 & Serializable & scala.Serializable)exprStr -> {
                    boolean needsToChangeExpr = MODULE$.containsDependentExpression(sparkSession, targetColumn, (String)exprStr, (Function2<String, String, Object>)sparkSession.sessionState().conf().resolver());
                    if (needsToChangeExpr) {
                        return dependentGenCols.$plus$eq(field);
                    }
                    return BoxedUnit.UNIT;
                });
                return field;
            });
            return dependentGenCols.toList();
        }
        return (Seq)Nil$.MODULE$;
    }

    public Seq<DataType> findUndefinedTypes(DataType dt) {
        DataType dataType;
        while (true) {
            if (NullType$.MODULE$.equals(dataType = dt)) {
                return Nil$.MODULE$;
            }
            if (BooleanType$.MODULE$.equals(dataType)) {
                return Nil$.MODULE$;
            }
            if (ByteType$.MODULE$.equals(dataType) ? true : (ShortType$.MODULE$.equals(dataType) ? true : (IntegerType$.MODULE$.equals(dataType) ? true : LongType$.MODULE$.equals(dataType)))) {
                return Nil$.MODULE$;
            }
            if (FloatType$.MODULE$.equals(dataType) ? true : (DoubleType$.MODULE$.equals(dataType) ? true : dataType instanceof DecimalType)) {
                return Nil$.MODULE$;
            }
            if (StringType$.MODULE$.equals(dataType) ? true : BinaryType$.MODULE$.equals(dataType)) {
                return Nil$.MODULE$;
            }
            if (DateType$.MODULE$.equals(dataType) ? true : TimestampType$.MODULE$.equals(dataType)) {
                return Nil$.MODULE$;
            }
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.fields())).flatMap((Function1 & Serializable & scala.Serializable)f -> MODULE$.findUndefinedTypes(f.dataType()), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
            }
            if (!(dataType instanceof ArrayType)) break;
            ArrayType arrayType = (ArrayType)dataType;
            dt = arrayType.elementType();
        }
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            return (Seq)this.findUndefinedTypes(mapType.keyType()).$plus$plus(this.findUndefinedTypes(mapType.valueType()), Seq$.MODULE$.canBuildFrom());
        }
        return (Seq)new .colon.colon((Object)dataType, (List)Nil$.MODULE$);
    }

    public void recordUndefinedTypes(DeltaLog deltaLog, StructType schema) {
        try {
            ((TraversableOnce)this.findUndefinedTypes((DataType)schema).map((Function1 & Serializable & scala.Serializable)x$31 -> x$31.getClass().getName(), Seq$.MODULE$.canBuildFrom())).toSet().foreach((Function1 & Serializable & scala.Serializable)className -> {
                SchemaUtils$.$anonfun$recordUndefinedTypes$2(deltaLog, className);
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Failed to log undefined types for table ").append(deltaLog.logPath()).toString(), e);
            }
            throw throwable;
        }
    }

    private final Seq recurseIntoComplexTypes$1(DataType complexType, Seq columnStack, Function1 f$1, boolean checkComplexTypes$1) {
        DataType dataType;
        while (true) {
            if ((dataType = complexType) instanceof StructType) {
                StructType structType = (StructType)dataType;
                return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.fields())).flatMap((Function1 & Serializable & scala.Serializable)sf -> {
                    Nil$ includeLevel = BoxesRunTime.unboxToBoolean((Object)f$1.apply(sf)) ? (Seq)new .colon.colon((Object)new Tuple2((Object)columnStack, sf), (List)Nil$.MODULE$) : Nil$.MODULE$;
                    return (Seq)includeLevel.$plus$plus((GenTraversableOnce)this.recurseIntoComplexTypes$1(sf.dataType(), (Seq)columnStack.$colon$plus((Object)sf.name(), Seq$.MODULE$.canBuildFrom()), f$1, checkComplexTypes$1), Seq$.MODULE$.canBuildFrom());
                }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
            }
            if (!(dataType instanceof ArrayType)) break;
            ArrayType arrayType = (ArrayType)dataType;
            if (!checkComplexTypes$1) break;
            columnStack = (Seq)columnStack.$colon$plus((Object)"element", Seq$.MODULE$.canBuildFrom());
            complexType = arrayType.elementType();
        }
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            if (checkComplexTypes$1) {
                return (Seq)this.recurseIntoComplexTypes$1(mapType.keyType(), (Seq)columnStack.$colon$plus((Object)"key", Seq$.MODULE$.canBuildFrom()), f$1, checkComplexTypes$1).$plus$plus((GenTraversableOnce)this.recurseIntoComplexTypes$1(mapType.valueType(), (Seq)columnStack.$colon$plus((Object)"value", Seq$.MODULE$.canBuildFrom()), f$1, checkComplexTypes$1), Seq$.MODULE$.canBuildFrom());
            }
        }
        return Nil$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$dropNullTypeColumns$1(DataType x$1) {
        return x$1 instanceof NullType;
    }

    public static final /* synthetic */ boolean $anonfun$dropNullTypeColumns$3(DataType x$2) {
        return x$2 instanceof NullType;
    }

    public static final /* synthetic */ boolean $anonfun$dropNullTypeColumns$4(DataType x$3) {
        return x$3 instanceof NullType;
    }

    private final Column generateSelectExpr$1(StructField sf, Seq nameStack) {
        MapType mapType;
        ArrayType arrayType;
        DataType dataType = sf.dataType();
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            Column[] nested = (Column[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.fields())).flatMap((Function1 & Serializable & scala.Serializable)f -> {
                if (f.dataType() instanceof NullType) {
                    return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                return Option$.MODULE$.option2Iterable((Option)new Some((Object)this.generateSelectExpr$1((StructField)f, (Seq)nameStack.$colon$plus((Object)sf.name(), Seq$.MODULE$.canBuildFrom()))));
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
            return functions$.MODULE$.struct((Seq)Predef$.MODULE$.wrapRefArray((Object[])nested)).alias(sf.name());
        }
        if (dataType instanceof ArrayType && this.typeExistsRecursively((DataType)(arrayType = (ArrayType)dataType), (Function1<DataType, Object>)(Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$dropNullTypeColumns$3(x$2)))) {
            String colName = new UnresolvedAttribute((Seq)nameStack.$colon$plus((Object)sf.name(), Seq$.MODULE$.canBuildFrom())).name();
            throw new DeltaAnalysisException("DELTA_COMPLEX_TYPE_COLUMN_CONTAINS_NULL_TYPE", (String[])((Object[])new String[]{colName, "ArrayType"}), DeltaAnalysisException$.MODULE$.$lessinit$greater$default$3(), DeltaAnalysisException$.MODULE$.$lessinit$greater$default$4());
        }
        if (dataType instanceof MapType && this.typeExistsRecursively((DataType)(mapType = (MapType)dataType), (Function1<DataType, Object>)(Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$dropNullTypeColumns$4(x$3)))) {
            String colName = new UnresolvedAttribute((Seq)nameStack.$colon$plus((Object)sf.name(), Seq$.MODULE$.canBuildFrom())).name();
            throw new DeltaAnalysisException("DELTA_COMPLEX_TYPE_COLUMN_CONTAINS_NULL_TYPE", (String[])((Object[])new String[]{colName, "NullType"}), DeltaAnalysisException$.MODULE$.$lessinit$greater$default$3(), DeltaAnalysisException$.MODULE$.$lessinit$greater$default$4());
        }
        String colName = new UnresolvedAttribute((Seq)nameStack.$colon$plus((Object)sf.name(), Seq$.MODULE$.canBuildFrom())).name();
        return functions$.MODULE$.col(colName).alias(sf.name());
    }

    private static final Seq recurseAndRemove$1(StructType struct) {
        return (Seq)struct.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DataType n;
            DataType s;
            StructField structField = x0$1;
            if (structField != null && (s = structField.dataType()) instanceof StructType) {
                StructType structType = (StructType)s;
                StructType x$1 = StructType$.MODULE$.apply(SchemaUtils$.recurseAndRemove$1(structType));
                String x$2 = structField.copy$default$1();
                boolean x$3 = structField.copy$default$3();
                Metadata x$4 = structField.copy$default$4();
                return Option$.MODULE$.option2Iterable((Option)new Some((Object)structField.copy(x$2, (DataType)x$1, x$3, x$4)));
            }
            if (structField != null && (n = structField.dataType()) instanceof NullType) {
                return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return Option$.MODULE$.option2Iterable((Option)new Some((Object)structField));
        }, Seq$.MODULE$.canBuildFrom());
    }

    private static final Option findNullTypeColumnRec$1(StructType s, Seq nameStack) {
        Seq nullFields = (Seq)s.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            StructField structField = x0$1;
            if (structField != null) {
                String name = structField.name();
                DataType n = structField.dataType();
                if (n instanceof NullType) {
                    return Option$.MODULE$.option2Iterable((Option)new Some((Object)((TraversableOnce)nameStack.$colon$plus((Object)name, Seq$.MODULE$.canBuildFrom())).mkString(".")));
                }
            }
            if (structField != null) {
                String name = structField.name();
                DataType s = structField.dataType();
                if (s instanceof StructType) {
                    StructType structType = (StructType)s;
                    return Option$.MODULE$.option2Iterable(SchemaUtils$.findNullTypeColumnRec$1(structType, (Seq)nameStack.$colon$plus((Object)name, Seq$.MODULE$.canBuildFrom())));
                }
            }
            return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
        }, Seq$.MODULE$.canBuildFrom());
        return nullFields.headOption();
    }

    public static final /* synthetic */ boolean $anonfun$findNullTypeColumn$2(DataType x$4) {
        return x$4 instanceof NullType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$normalizeColumnNames$1(String f) {
        String string = f;
        String string2 = CDCReader$.MODULE$.CDC_PARTITION_COL();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = f;
        String string4 = CDCReader$.MODULE$.CDC_TYPE_COLUMN_NAME();
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    private static final boolean isNullabilityCompatible$1(boolean existingNullable, boolean readNullable, boolean forbidTightenNullability$1) {
        if (forbidTightenNullability$1) {
            return readNullable || !existingNullable;
        }
        return existingNullable || !readNullable;
    }

    private final boolean isDatatypeReadCompatible$1(DataType existing, DataType newtype, boolean forbidTightenNullability$1) {
        Tuple2 tuple2;
        block9: {
            while (true) {
                if ((tuple2 = new Tuple2((Object)existing, (Object)newtype)) != null) {
                    DataType e = (DataType)tuple2._1();
                    DataType n = (DataType)tuple2._2();
                    if (e instanceof StructType) {
                        StructType structType = (StructType)e;
                        if (n instanceof StructType) {
                            StructType structType2 = (StructType)n;
                            return this.isReadCompatible(structType, structType2, forbidTightenNullability$1, this.isReadCompatible$default$4(), this.isReadCompatible$default$5(), this.isReadCompatible$default$6());
                        }
                    }
                }
                if (tuple2 != null) {
                    DataType e = (DataType)tuple2._1();
                    DataType n = (DataType)tuple2._2();
                    if (e instanceof ArrayType) {
                        ArrayType arrayType = (ArrayType)e;
                        if (n instanceof ArrayType) {
                            ArrayType arrayType2 = (ArrayType)n;
                            if (SchemaUtils$.isNullabilityCompatible$1(arrayType.containsNull(), arrayType2.containsNull(), forbidTightenNullability$1)) {
                                newtype = arrayType2.elementType();
                                existing = arrayType.elementType();
                                continue;
                            }
                            return false;
                        }
                    }
                }
                if (tuple2 == null) break block9;
                DataType e = (DataType)tuple2._1();
                DataType n = (DataType)tuple2._2();
                if (!(e instanceof MapType)) break block9;
                MapType mapType = (MapType)e;
                if (!(n instanceof MapType)) break block9;
                MapType mapType2 = (MapType)n;
                if (!SchemaUtils$.isNullabilityCompatible$1(mapType.valueContainsNull(), mapType2.valueContainsNull(), forbidTightenNullability$1) || !this.isDatatypeReadCompatible$1(mapType.keyType(), mapType2.keyType(), forbidTightenNullability$1)) break;
                newtype = mapType2.valueType();
                existing = mapType.valueType();
            }
            return false;
        }
        if (tuple2 != null) {
            DataType a = (DataType)tuple2._1();
            DataType b = (DataType)tuple2._2();
            DataType dataType = a;
            DataType dataType2 = b;
            return !(dataType != null ? !dataType.equals(dataType2) : dataType2 != null);
        }
        throw new MatchError((Object)tuple2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$isReadCompatible$6(SchemaUtils$ $this, StructField newField$1, boolean forbidTightenNullability$1, StructField existingField) {
        String string = existingField.name();
        String string2 = newField$1.name();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (!SchemaUtils$.isNullabilityCompatible$1(existingField.nullable(), newField$1.nullable(), forbidTightenNullability$1)) return false;
        if (!$this.isDatatypeReadCompatible$1(existingField.dataType(), newField$1.dataType(), forbidTightenNullability$1)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$isReadCompatible$5(SchemaUtils$ $this, Map existingFields$1, boolean forbidTightenNullability$1, StructField newField) {
        return existingFields$1.get((Object)newField.name()).forall((Function1 & Serializable & scala.Serializable)existingField -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$isReadCompatible$6($this, newField, forbidTightenNullability$1, existingField)));
    }

    private final boolean isStructReadCompatible$1(StructType existing, StructType newtype, boolean allowMissingColumns$1, Seq newPartitionColumns$1, Seq oldPartitionColumns$1, boolean forbidTightenNullability$1) {
        Map<String, StructField> existingFields = SchemaMergingUtils$.MODULE$.toFieldMap((Seq<StructField>)existing, SchemaMergingUtils$.MODULE$.toFieldMap$default$2());
        scala.collection.immutable.Set existingFieldNames = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])existing.fieldNames())).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.toLowerCase(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSet();
        Predef$.MODULE$.assert(existingFieldNames.size() == existing.length(), (Function0 & Serializable & scala.Serializable)() -> "Delta tables don't allow field names that only differ by case");
        scala.collection.immutable.Set newFields = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newtype.fieldNames())).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.toLowerCase(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSet();
        Predef$.MODULE$.assert(newFields.size() == newtype.length(), (Function0 & Serializable & scala.Serializable)() -> "Delta tables don't allow field names that only differ by case");
        if (!(allowMissingColumns$1 || existingFieldNames.subsetOf((GenSet)newFields) && this.isPartitionCompatible((Seq<String>)newPartitionColumns$1, (Seq<String>)oldPartitionColumns$1))) {
            return false;
        }
        return newtype.forall((Function1 & Serializable & scala.Serializable)newField -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$isReadCompatible$5(this, existingFields, forbidTightenNullability$1, newField)));
    }

    private static final String canOrNot$1(boolean can) {
        if (can) {
            return "can";
        }
        return "can not";
    }

    private static final String isOrNon$1(boolean b) {
        if (b) {
            return "";
        }
        return "non-";
    }

    private static final String missingFieldsMessage$1(scala.collection.immutable.Set fields) {
        return new StringBuilder(38).append("Specified schema is missing field(s): ").append(fields.mkString(", ")).toString();
    }

    private static final String additionalFieldsMessage$1(scala.collection.immutable.Set fields) {
        return new StringBuilder(42).append("Specified schema has additional field(s): ").append(fields.mkString(", ")).toString();
    }

    private static final String fieldNullabilityMessage$1(String field, boolean specified, boolean existing) {
        return new StringBuilder(71).append("Field ").append(field).append(" is ").append(SchemaUtils$.isOrNon$1(specified)).append("nullable in specified ").append("schema but ").append(SchemaUtils$.isOrNon$1(existing)).append("nullable in existing schema.").toString();
    }

    private static final String arrayNullabilityMessage$1(String field, boolean specified, boolean existing) {
        return new StringBuilder(70).append("Array field ").append(field).append(" ").append(SchemaUtils$.canOrNot$1(specified)).append(" contain null in specified schema ").append("but ").append(SchemaUtils$.canOrNot$1(existing)).append(" in existing schema").toString();
    }

    private static final String valueNullabilityMessage$1(String field, boolean specified, boolean existing) {
        return new StringBuilder(75).append("Map field ").append(field).append(" ").append(SchemaUtils$.canOrNot$1(specified)).append(" contain null values in specified schema ").append("but ").append(SchemaUtils$.canOrNot$1(existing)).append(" in existing schema").toString();
    }

    private static final Metadata removeGenerationExpressionMetadata$1(Metadata metadata) {
        return new MetadataBuilder().withMetadata(metadata).remove(DeltaSourceUtils$.MODULE$.GENERATION_EXPRESSION_METADATA_KEY()).build();
    }

    private static final String metadataDifferentMessage$1(String field, Metadata specified, Metadata existing) {
        String metadataDiffMessage;
        block2: {
            Option<String> specifiedGenerationExpr = GeneratedColumn$.MODULE$.getGenerationExpressionStr(specified);
            Option<String> existingGenerationExpr = GeneratedColumn$.MODULE$.getGenerationExpressionStr(existing);
            metadataDiffMessage = "";
            Option<String> option = specifiedGenerationExpr;
            Option<String> option2 = existingGenerationExpr;
            if (option == null ? option2 != null : !option.equals(option2)) {
                metadataDiffMessage = new StringBuilder(0).append(metadataDiffMessage).append(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(129).append("Specified generation expression for field ").append(field).append(" is different from existing schema:\n             |Specified: ").append(specifiedGenerationExpr.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("\n             |Existing:  ").append(existingGenerationExpr.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString())).stripMargin()).toString();
            }
            Metadata specifiedMetadataWithoutGenerationExpr = SchemaUtils$.removeGenerationExpressionMetadata$1(specified);
            Metadata existingMetadataWithoutGenerationExpr = SchemaUtils$.removeGenerationExpressionMetadata$1(existing);
            Metadata metadata = specifiedMetadataWithoutGenerationExpr;
            Metadata metadata2 = existingMetadataWithoutGenerationExpr;
            if (!(metadata == null ? metadata2 != null : !metadata.equals(metadata2))) break block2;
            if (new StringOps(Predef$.MODULE$.augmentString(metadataDiffMessage)).nonEmpty()) {
                metadataDiffMessage = new StringBuilder(1).append(metadataDiffMessage).append("\n").toString();
            }
            metadataDiffMessage = new StringBuilder(0).append(metadataDiffMessage).append(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(116).append("Specified metadata for field ").append(field).append(" is different from existing schema:\n             |Specified: ").append(specifiedMetadataWithoutGenerationExpr).append("\n             |Existing:  ").append(existingMetadataWithoutGenerationExpr).toString())).stripMargin()).toString();
        }
        return metadataDiffMessage;
    }

    private static final String typeDifferenceMessage$1(String field, DataType specified, DataType existing) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(98).append("Specified type for ").append(field).append(" is different from existing schema:\n         |Specified: ").append(specified.typeName()).append("\n         |Existing:  ").append(existing.typeName()).toString())).stripMargin();
    }

    private static final Seq structDifference$1(StructType existing, StructType specified, String prefix) {
        scala.collection.immutable.Set specifiedFieldNames;
        scala.collection.immutable.Set existingFieldNames = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])existing.fieldNames())).toSet();
        scala.collection.immutable.Set missingFields = (scala.collection.immutable.Set)existingFieldNames.diff((GenSet)(specifiedFieldNames = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])specified.fieldNames())).toSet()));
        Nil$ missingFieldsDiffs = missingFields.isEmpty() ? Nil$.MODULE$ : (Seq)new .colon.colon((Object)SchemaUtils$.missingFieldsMessage$1((scala.collection.immutable.Set)missingFields.map((Function1 & Serializable & scala.Serializable)x$8 -> new StringBuilder(0).append(prefix).append((String)x$8).toString(), scala.collection.immutable.Set$.MODULE$.canBuildFrom())), (List)Nil$.MODULE$);
        scala.collection.immutable.Set extraFields = (scala.collection.immutable.Set)specifiedFieldNames.diff((GenSet)existingFieldNames);
        Nil$ extraFieldsDiffs = extraFields.isEmpty() ? Nil$.MODULE$ : (Seq)new .colon.colon((Object)SchemaUtils$.additionalFieldsMessage$1((scala.collection.immutable.Set)extraFields.map((Function1 & Serializable & scala.Serializable)x$9 -> new StringBuilder(0).append(prefix).append((String)x$9).toString(), scala.collection.immutable.Set$.MODULE$.canBuildFrom())), (List)Nil$.MODULE$);
        Map<String, StructField> existingFields = SchemaMergingUtils$.MODULE$.toFieldMap((Seq<StructField>)existing, SchemaMergingUtils$.MODULE$.toFieldMap$default$2());
        Map<String, StructField> specifiedFields = SchemaMergingUtils$.MODULE$.toFieldMap((Seq<StructField>)specified, SchemaMergingUtils$.MODULE$.toFieldMap$default$2());
        scala.collection.immutable.Set fieldsDiffs = (scala.collection.immutable.Set)((TraversableLike)existingFieldNames.intersect((GenSet)specifiedFieldNames)).flatMap((Function1 & Serializable & scala.Serializable)name -> SchemaUtils$.fieldDifference$1((StructField)existingFields.apply(name), (StructField)specifiedFields.apply(name), prefix), scala.collection.immutable.Set$.MODULE$.canBuildFrom());
        return (Seq)((TraversableLike)missingFieldsDiffs.$plus$plus((GenTraversableOnce)extraFieldsDiffs, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)fieldsDiffs, Seq$.MODULE$.canBuildFrom());
    }

    private static final Seq fieldDifference$1(StructField existing, StructField specified, String prefix) {
        String name = new StringBuilder(0).append(prefix).append(existing.name()).toString();
        Nil$ nullabilityDiffs = existing.nullable() == specified.nullable() ? Nil$.MODULE$ : (Seq)new .colon.colon((Object)SchemaUtils$.fieldNullabilityMessage$1(String.valueOf(name), specified.nullable(), existing.nullable()), (List)Nil$.MODULE$);
        Metadata metadata = existing.metadata();
        Metadata metadata2 = specified.metadata();
        Nil$ metadataDiffs = !(metadata != null ? !metadata.equals(metadata2) : metadata2 != null) ? Nil$.MODULE$ : (Seq)new .colon.colon((Object)SchemaUtils$.metadataDifferentMessage$1(String.valueOf(name), specified.metadata(), existing.metadata()), (List)Nil$.MODULE$);
        Seq typeDiffs = SchemaUtils$.typeDifference$1(existing.dataType(), specified.dataType(), name);
        return (Seq)((TraversableLike)nullabilityDiffs.$plus$plus((GenTraversableOnce)metadataDiffs, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)typeDiffs, Seq$.MODULE$.canBuildFrom());
    }

    private static final Seq typeDifference$1(DataType existing, DataType specified, String field) {
        Tuple2 tuple2 = new Tuple2((Object)existing, (Object)specified);
        if (tuple2 != null) {
            DataType e = (DataType)tuple2._1();
            DataType s = (DataType)tuple2._2();
            if (e instanceof StructType) {
                StructType structType = (StructType)e;
                if (s instanceof StructType) {
                    StructType structType2 = (StructType)s;
                    return SchemaUtils$.structDifference$1(structType, structType2, new StringBuilder(1).append(field).append(".").toString());
                }
            }
        }
        if (tuple2 != null) {
            DataType e = (DataType)tuple2._1();
            DataType s = (DataType)tuple2._2();
            if (e instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)e;
                if (s instanceof ArrayType) {
                    ArrayType arrayType2 = (ArrayType)s;
                    return SchemaUtils$.arrayDifference$1(arrayType, arrayType2, new StringBuilder(2).append(field).append("[]").toString());
                }
            }
        }
        if (tuple2 != null) {
            DataType e = (DataType)tuple2._1();
            DataType s = (DataType)tuple2._2();
            if (e instanceof MapType) {
                MapType mapType = (MapType)e;
                if (s instanceof MapType) {
                    MapType mapType2 = (MapType)s;
                    return SchemaUtils$.mapDifference$1(mapType, mapType2, String.valueOf(field));
                }
            }
        }
        if (tuple2 != null) {
            DataType e = (DataType)tuple2._1();
            DataType s = (DataType)tuple2._2();
            DataType dataType = e;
            DataType dataType2 = s;
            if (dataType == null ? dataType2 != null : !dataType.equals(dataType2)) {
                return (Seq)new .colon.colon((Object)SchemaUtils$.typeDifferenceMessage$1(field, s, e), (List)Nil$.MODULE$);
            }
        }
        return Nil$.MODULE$;
    }

    private static final Seq arrayDifference$1(ArrayType existing, ArrayType specified, String field) {
        Seq elementDiffs = SchemaUtils$.typeDifference$1(existing.elementType(), specified.elementType(), field);
        Nil$ nullabilityDiffs = existing.containsNull() == specified.containsNull() ? Nil$.MODULE$ : (Seq)new .colon.colon((Object)SchemaUtils$.arrayNullabilityMessage$1(field, specified.containsNull(), existing.containsNull()), (List)Nil$.MODULE$);
        return (Seq)elementDiffs.$plus$plus((GenTraversableOnce)nullabilityDiffs, Seq$.MODULE$.canBuildFrom());
    }

    private static final Seq mapDifference$1(MapType existing, MapType specified, String field) {
        Seq keyDiffs = SchemaUtils$.typeDifference$1(existing.keyType(), specified.keyType(), new StringBuilder(5).append(field).append("[key]").toString());
        Seq valueDiffs = SchemaUtils$.typeDifference$1(existing.valueType(), specified.valueType(), new StringBuilder(7).append(field).append("[value]").toString());
        Nil$ nullabilityDiffs = existing.valueContainsNull() == specified.valueContainsNull() ? Nil$.MODULE$ : (Seq)new .colon.colon((Object)SchemaUtils$.valueNullabilityMessage$1(field, specified.valueContainsNull(), existing.valueContainsNull()), (List)Nil$.MODULE$);
        return (Seq)((TraversableLike)keyDiffs.$plus$plus((GenTraversableOnce)valueDiffs, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)nullabilityDiffs, Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$findNestedFieldIgnoreCase$1(String fieldName$1, StructField x$10) {
        return x$10.name().equalsIgnoreCase(fieldName$1);
    }

    private final Option findRecursively$1(DataType dataType, Seq fieldNames, boolean includeCollections) {
        while (true) {
            boolean bl;
            Tuple3 tuple3;
            if ((tuple3 = new Tuple3((Object)fieldNames, (Object)dataType, (Object)BoxesRunTime.boxToBoolean((boolean)includeCollections))) != null) {
                Seq seq = (Seq)tuple3._1();
                DataType struct = (DataType)tuple3._2();
                Some some = Seq$.MODULE$.unapplySeq(seq);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) >= 0) {
                    String fieldName = (String)((SeqLike)some.get()).apply(0);
                    Seq names = (Seq)((IterableLike)some.get()).drop(1);
                    if (struct instanceof StructType) {
                        StructType structType = (StructType)struct;
                        Option field = structType.find((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$findNestedFieldIgnoreCase$1(fieldName, x$10)));
                        if (names.isEmpty() || field.isEmpty()) {
                            return field;
                        }
                        fieldNames = names;
                        dataType = ((StructField)field.get()).dataType();
                        continue;
                    }
                }
            }
            if (tuple3 != null && !(bl = BoxesRunTime.unboxToBoolean((Object)tuple3._3()))) {
                return None$.MODULE$;
            }
            if (tuple3 != null) {
                String string;
                Seq seq = (Seq)tuple3._1();
                DataType dataType2 = (DataType)tuple3._2();
                boolean bl2 = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
                Some some = Seq$.MODULE$.unapplySeq(seq);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0 && "key".equals(string = (String)((SeqLike)some.get()).apply(0)) && dataType2 instanceof MapType) {
                    MapType mapType = (MapType)dataType2;
                    DataType keyType = mapType.keyType();
                    if (bl2) {
                        return new Some((Object)new StructField("key", keyType, false, StructField$.MODULE$.apply$default$4()));
                    }
                }
            }
            if (tuple3 != null) {
                Seq seq = (Seq)tuple3._1();
                DataType dataType3 = (DataType)tuple3._2();
                boolean bl3 = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
                Some some = Seq$.MODULE$.unapplySeq(seq);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) >= 0) {
                    String string = (String)((SeqLike)some.get()).apply(0);
                    Seq names = (Seq)((IterableLike)some.get()).drop(1);
                    if ("key".equals(string) && dataType3 instanceof MapType) {
                        MapType mapType = (MapType)dataType3;
                        DataType keyType = mapType.keyType();
                        if (bl3) {
                            fieldNames = names;
                            dataType = keyType;
                            continue;
                        }
                    }
                }
            }
            if (tuple3 != null) {
                String string;
                Seq seq = (Seq)tuple3._1();
                DataType dataType4 = (DataType)tuple3._2();
                boolean bl4 = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
                Some some = Seq$.MODULE$.unapplySeq(seq);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0 && "value".equals(string = (String)((SeqLike)some.get()).apply(0)) && dataType4 instanceof MapType) {
                    MapType mapType = (MapType)dataType4;
                    DataType valueType = mapType.valueType();
                    boolean isNullable = mapType.valueContainsNull();
                    if (bl4) {
                        return new Some((Object)new StructField("value", valueType, isNullable, StructField$.MODULE$.apply$default$4()));
                    }
                }
            }
            if (tuple3 != null) {
                Seq seq = (Seq)tuple3._1();
                DataType dataType5 = (DataType)tuple3._2();
                boolean bl5 = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
                Some some = Seq$.MODULE$.unapplySeq(seq);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) >= 0) {
                    String string = (String)((SeqLike)some.get()).apply(0);
                    Seq names = (Seq)((IterableLike)some.get()).drop(1);
                    if ("value".equals(string) && dataType5 instanceof MapType) {
                        MapType mapType = (MapType)dataType5;
                        DataType valueType = mapType.valueType();
                        if (bl5) {
                            fieldNames = names;
                            dataType = valueType;
                            continue;
                        }
                    }
                }
            }
            if (tuple3 != null) {
                String string;
                Seq seq = (Seq)tuple3._1();
                DataType dataType6 = (DataType)tuple3._2();
                boolean bl6 = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
                Some some = Seq$.MODULE$.unapplySeq(seq);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0 && "element".equals(string = (String)((SeqLike)some.get()).apply(0)) && dataType6 instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType6;
                    DataType elementType = arrayType.elementType();
                    boolean isNullable = arrayType.containsNull();
                    if (bl6) {
                        return new Some((Object)new StructField("element", elementType, isNullable, StructField$.MODULE$.apply$default$4()));
                    }
                }
            }
            if (tuple3 == null) break;
            Seq seq = (Seq)tuple3._1();
            DataType dataType7 = (DataType)tuple3._2();
            boolean bl7 = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(1) < 0) break;
            String string = (String)((SeqLike)some.get()).apply(0);
            Seq names = (Seq)((IterableLike)some.get()).drop(1);
            if (!"element".equals(string) || !(dataType7 instanceof ArrayType)) break;
            ArrayType arrayType = (ArrayType)dataType7;
            DataType elementType = arrayType.elementType();
            if (!bl7) break;
            fieldNames = names;
            dataType = elementType;
        }
        return None$.MODULE$;
    }

    private static final /* synthetic */ String columnPath$lzycompute$1(LazyRef columnPath$lzy$1, Seq currentPathWithNestedField$1) {
        String string;
        LazyRef lazyRef = columnPath$lzy$1;
        synchronized (lazyRef) {
            string = columnPath$lzy$1.initialized() ? (String)columnPath$lzy$1.value() : (String)columnPath$lzy$1.initialize((Object)new UnresolvedAttribute(currentPathWithNestedField$1).name());
        }
        return string;
    }

    private static final String columnPath$1(LazyRef columnPath$lzy$1, Seq currentPathWithNestedField$1) {
        if (columnPath$lzy$1.initialized()) {
            return (String)columnPath$lzy$1.value();
        }
        return SchemaUtils$.columnPath$lzycompute$1(columnPath$lzy$1, currentPathWithNestedField$1);
    }

    public static final /* synthetic */ boolean $anonfun$findColumnPosition$1(Function2 resolver$1, String currentFieldName$1, StructField f) {
        return BoxesRunTime.unboxToBoolean((Object)resolver$1.apply((Object)f.name(), (Object)currentFieldName$1));
    }

    private final Seq findRecursively$2(Seq searchPath, DataType currentType, Seq currentPath, Function2 resolver$1, StructType schema$1) {
        DataType struct;
        if (searchPath.isEmpty()) {
            return Nil$.MODULE$;
        }
        String currentFieldName = (String)searchPath.head();
        Seq currentPathWithNestedField = (Seq)currentPath.$colon$plus((Object)currentFieldName, Seq$.MODULE$.canBuildFrom());
        Tuple2 tuple2 = new Tuple2((Object)currentType, (Object)currentFieldName);
        if (tuple2 != null && (struct = (DataType)tuple2._1()) instanceof StructType) {
            StructType structType = (StructType)struct;
            LazyRef columnPath$lzy = new LazyRef();
            int pos = structType.indexWhere((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$findColumnPosition$1(resolver$1, currentFieldName, f)));
            if (pos == -1) {
                throw DeltaErrors$.MODULE$.columnNotInSchemaException(SchemaUtils$.columnPath$1(columnPath$lzy, currentPathWithNestedField), schema$1);
            }
            Seq childPosition = this.findRecursively$2((Seq)searchPath.tail(), structType.apply(pos).dataType(), currentPathWithNestedField, resolver$1, schema$1);
            int n = pos;
            return (Seq)childPosition.$plus$colon((Object)BoxesRunTime.boxToInteger((int)n), Seq$.MODULE$.canBuildFrom());
        }
        if (tuple2 != null) {
            DataType map = (DataType)tuple2._1();
            String string = (String)tuple2._2();
            if (map instanceof MapType) {
                MapType mapType = (MapType)map;
                if ("key".equals(string)) {
                    Seq childPosition = this.findRecursively$2((Seq)searchPath.tail(), mapType.keyType(), currentPathWithNestedField, resolver$1, schema$1);
                    int n = this.MAP_KEY_INDEX();
                    return (Seq)childPosition.$plus$colon((Object)BoxesRunTime.boxToInteger((int)n), Seq$.MODULE$.canBuildFrom());
                }
            }
        }
        if (tuple2 != null) {
            DataType map = (DataType)tuple2._1();
            String string = (String)tuple2._2();
            if (map instanceof MapType) {
                MapType mapType = (MapType)map;
                if ("value".equals(string)) {
                    Seq childPosition = this.findRecursively$2((Seq)searchPath.tail(), mapType.valueType(), currentPathWithNestedField, resolver$1, schema$1);
                    int n = this.MAP_VALUE_INDEX();
                    return (Seq)childPosition.$plus$colon((Object)BoxesRunTime.boxToInteger((int)n), Seq$.MODULE$.canBuildFrom());
                }
            }
        }
        if (tuple2 != null && tuple2._1() instanceof MapType) {
            throw DeltaErrors$.MODULE$.foundMapTypeColumnException(this.prettyFieldName((Seq<String>)((Seq)currentPath.$colon$plus((Object)"key", Seq$.MODULE$.canBuildFrom()))), this.prettyFieldName((Seq<String>)((Seq)currentPath.$colon$plus((Object)"value", Seq$.MODULE$.canBuildFrom()))));
        }
        if (tuple2 != null) {
            DataType array = (DataType)tuple2._1();
            String string = (String)tuple2._2();
            if (array instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)array;
                if ("element".equals(string)) {
                    Seq childPosition = this.findRecursively$2((Seq)searchPath.tail(), arrayType.elementType(), currentPathWithNestedField, resolver$1, schema$1);
                    int n = this.ARRAY_ELEMENT_INDEX();
                    return (Seq)childPosition.$plus$colon((Object)BoxesRunTime.boxToInteger((int)n), Seq$.MODULE$.canBuildFrom());
                }
            }
        }
        if (tuple2 != null && tuple2._1() instanceof ArrayType) {
            throw DeltaErrors$.MODULE$.incorrectArrayAccessByName(this.prettyFieldName((Seq<String>)((Seq)currentPath.$colon$plus((Object)"element", Seq$.MODULE$.canBuildFrom()))), this.prettyFieldName((Seq<String>)currentPath));
        }
        throw DeltaErrors$.MODULE$.columnPathNotNested(currentFieldName, currentType, (Seq<String>)currentPath);
    }

    private static final Seq findRecursively$default$3$1() {
        return Nil$.MODULE$;
    }

    private final DataType addColumnInChild$1(DataType parent, StructField column, Seq position) {
        Predef$.MODULE$.require(position.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Don't know where to add the column ").append(column).toString());
        boolean bl = false;
        MapType mapType = null;
        boolean bl2 = false;
        ArrayType arrayType = null;
        DataType dataType = parent;
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            return this.addColumn(structType, column, (Seq<Object>)position);
        }
        if (dataType instanceof MapType) {
            bl = true;
            mapType = (MapType)dataType;
            if (BoxesRunTime.unboxToInt((Object)position.head()) == this.MAP_KEY_INDEX()) {
                return mapType.copy(this.addColumnInChild$1(mapType.keyType(), column, (Seq)position.tail()), mapType.copy$default$2(), mapType.copy$default$3());
            }
        }
        if (bl && BoxesRunTime.unboxToInt((Object)position.head()) == this.MAP_VALUE_INDEX()) {
            DataType x$1 = this.addColumnInChild$1(mapType.valueType(), column, (Seq)position.tail());
            DataType x$2 = mapType.copy$default$1();
            boolean x$3 = mapType.copy$default$3();
            return mapType.copy(x$2, x$1, x$3);
        }
        if (dataType instanceof ArrayType) {
            bl2 = true;
            arrayType = (ArrayType)dataType;
            if (BoxesRunTime.unboxToInt((Object)position.head()) == this.ARRAY_ELEMENT_INDEX()) {
                return arrayType.copy(this.addColumnInChild$1(arrayType.elementType(), column, (Seq)position.tail()), arrayType.copy$default$2());
            }
        }
        if (bl2) {
            throw DeltaErrors$.MODULE$.incorrectArrayAccess();
        }
        throw DeltaErrors$.MODULE$.addColumnParentNotStructException(column, dataType);
    }

    private final Tuple2 dropColumnInChild$1(DataType parent, Seq position) {
        Predef$.MODULE$.require(position.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Don't know where to drop the column");
        boolean bl = false;
        MapType mapType = null;
        boolean bl2 = false;
        ArrayType arrayType = null;
        DataType dataType = parent;
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            return this.dropColumn(structType, (Seq<Object>)position);
        }
        if (dataType instanceof MapType) {
            bl = true;
            mapType = (MapType)dataType;
            if (BoxesRunTime.unboxToInt((Object)position.head()) == this.MAP_KEY_INDEX()) {
                Tuple2 tuple2 = this.dropColumnInChild$1(mapType.keyType(), (Seq)position.tail());
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                DataType newKeyType = (DataType)tuple2._1();
                StructField droppedColumn = (StructField)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)newKeyType, (Object)droppedColumn);
                DataType newKeyType2 = (DataType)tuple22._1();
                StructField droppedColumn2 = (StructField)tuple22._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)mapType.copy(newKeyType2, mapType.copy$default$2(), mapType.copy$default$3())), (Object)droppedColumn2);
            }
        }
        if (bl && BoxesRunTime.unboxToInt((Object)position.head()) == this.MAP_VALUE_INDEX()) {
            Tuple2 tuple2 = this.dropColumnInChild$1(mapType.valueType(), (Seq)position.tail());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            DataType newValueType = (DataType)tuple2._1();
            StructField droppedColumn = (StructField)tuple2._2();
            Tuple2 tuple23 = new Tuple2((Object)newValueType, (Object)droppedColumn);
            DataType newValueType2 = (DataType)tuple23._1();
            StructField droppedColumn3 = (StructField)tuple23._2();
            DataType x$1 = newValueType2;
            DataType x$2 = mapType.copy$default$1();
            boolean x$3 = mapType.copy$default$3();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)mapType.copy(x$2, x$1, x$3)), (Object)droppedColumn3);
        }
        if (dataType instanceof ArrayType) {
            bl2 = true;
            arrayType = (ArrayType)dataType;
            if (BoxesRunTime.unboxToInt((Object)position.head()) == this.ARRAY_ELEMENT_INDEX()) {
                Tuple2 tuple2 = this.dropColumnInChild$1(arrayType.elementType(), (Seq)position.tail());
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                DataType newElementType = (DataType)tuple2._1();
                StructField droppedColumn = (StructField)tuple2._2();
                Tuple2 tuple24 = new Tuple2((Object)newElementType, (Object)droppedColumn);
                DataType newElementType2 = (DataType)tuple24._1();
                StructField droppedColumn4 = (StructField)tuple24._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)arrayType.copy(newElementType2, arrayType.copy$default$2())), (Object)droppedColumn4);
            }
        }
        if (bl2) {
            throw DeltaErrors$.MODULE$.incorrectArrayAccess();
        }
        throw DeltaErrors$.MODULE$.dropNestedColumnsFromNonStructTypeException(dataType);
    }

    private static final void verify$1(boolean cond, Function0 err) {
        if (!cond) {
            throw DeltaErrors$.MODULE$.cannotChangeDataType((String)err.apply());
        }
    }

    private static final void verifyNullability$1(boolean fn, boolean tn, Seq columnPath) {
        SchemaUtils$.verify$1(tn || !fn, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("tightening nullability of ").append(new UnresolvedAttribute(columnPath).name()).toString());
    }

    public static final /* synthetic */ boolean $anonfun$canChangeDataType$3(Function2 resolver$2, StructField toField$1, StructField field) {
        return BoxesRunTime.unboxToBoolean((Object)resolver$2.apply((Object)field.name(), (Object)toField$1.name()));
    }

    public static final /* synthetic */ void $anonfun$canChangeDataType$2(SchemaUtils$ $this, StructField[] fromFields$1, Function2 resolver$2, Set remainingFields$1, Seq columnPath$3, BooleanRef addingColumns$1, boolean failOnAmbiguousChanges$1, DeltaColumnMappingMode columnMappingMode$1, StructField toField) {
        Option option = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fromFields$1)).find((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$canChangeDataType$3(resolver$2, toField, field)));
        if (option instanceof Some) {
            Some some = (Some)option;
            StructField fromField = (StructField)some.value();
            remainingFields$1.$minus$eq((Object)fromField);
            Seq newPath = (Seq)columnPath$3.$colon$plus((Object)fromField.name(), Seq$.MODULE$.canBuildFrom());
            SchemaUtils$.verifyNullability$1(fromField.nullable(), toField.nullable(), newPath);
            $this.check$1(fromField.dataType(), toField.dataType(), newPath, resolver$2, failOnAmbiguousChanges$1, columnMappingMode$1);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            addingColumns$1.elem = true;
            SchemaUtils$.verify$1(toField.nullable(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("adding non-nullable column ").append(new UnresolvedAttribute((Seq)columnPath$3.$colon$plus((Object)toField.name(), Seq$.MODULE$.canBuildFrom())).name()).toString());
            return;
        }
        throw new MatchError((Object)option);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void check$1(DataType fromDt, DataType toDt, Seq columnPath, Function2 resolver$2, boolean failOnAmbiguousChanges$1, DeltaColumnMappingMode columnMappingMode$1) {
        Tuple2 tuple2;
        while (true) {
            if ((tuple2 = new Tuple2((Object)fromDt, (Object)toDt)) != null) {
                DataType dataType = (DataType)tuple2._1();
                DataType dataType2 = (DataType)tuple2._2();
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    DataType fromElement = arrayType.elementType();
                    boolean fn = arrayType.containsNull();
                    if (dataType2 instanceof ArrayType) {
                        ArrayType arrayType2 = (ArrayType)dataType2;
                        DataType toElement = arrayType2.elementType();
                        boolean tn = arrayType2.containsNull();
                        SchemaUtils$.verifyNullability$1(fn, tn, columnPath);
                        columnPath = (Seq)columnPath.$colon$plus((Object)"element", Seq$.MODULE$.canBuildFrom());
                        toDt = toElement;
                        fromDt = fromElement;
                        continue;
                    }
                }
            }
            if (tuple2 == null) break;
            DataType dataType = (DataType)tuple2._1();
            DataType dataType3 = (DataType)tuple2._2();
            if (!(dataType instanceof MapType)) break;
            MapType mapType = (MapType)dataType;
            DataType fromKey = mapType.keyType();
            DataType fromValue = mapType.valueType();
            boolean fn = mapType.valueContainsNull();
            if (!(dataType3 instanceof MapType)) break;
            MapType mapType2 = (MapType)dataType3;
            DataType toKey = mapType2.keyType();
            DataType toValue = mapType2.valueType();
            boolean tn = mapType2.valueContainsNull();
            SchemaUtils$.verifyNullability$1(fn, tn, columnPath);
            this.check$1(fromKey, toKey, (Seq)columnPath.$colon$plus((Object)"key", Seq$.MODULE$.canBuildFrom()), resolver$2, failOnAmbiguousChanges$1, columnMappingMode$1);
            columnPath = (Seq)columnPath.$colon$plus((Object)"value", Seq$.MODULE$.canBuildFrom());
            toDt = toValue;
            fromDt = fromValue;
        }
        if (tuple2 != null) {
            DataType f = (DataType)tuple2._1();
            DataType t = (DataType)tuple2._2();
            if (f instanceof StructType) {
                StructType structType = (StructType)f;
                StructField[] fromFields = structType.fields();
                if (t instanceof StructType) {
                    StructType structType2 = (StructType)t;
                    StructField[] toFields = structType2.fields();
                    Set remainingFields = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
                    remainingFields.$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fromFields)));
                    BooleanRef addingColumns = BooleanRef.create((boolean)false);
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])toFields)).foreach((Function1 & Serializable & scala.Serializable)toField -> {
                        SchemaUtils$.$anonfun$canChangeDataType$2(this, fromFields, resolver$2, remainingFields, columnPath, addingColumns, failOnAmbiguousChanges$1, columnMappingMode$1, toField);
                        return BoxedUnit.UNIT;
                    });
                    String columnName = new UnresolvedAttribute(columnPath).name();
                    if (failOnAmbiguousChanges$1 && remainingFields.nonEmpty() && addingColumns.elem) {
                        throw DeltaErrors$.MODULE$.ambiguousDataTypeChange(columnName, structType, structType2);
                    }
                    DeltaColumnMappingMode deltaColumnMappingMode = columnMappingMode$1;
                    NoMapping$ noMapping$ = NoMapping$.MODULE$;
                    if (deltaColumnMappingMode == null) {
                        if (noMapping$ != null) {
                            return;
                        }
                    } else if (!deltaColumnMappingMode.equals(noMapping$)) return;
                    SchemaUtils$.verify$1(remainingFields.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("dropping column(s) [").append(((TraversableOnce)remainingFields.map((Function1 & Serializable & scala.Serializable)x$21 -> x$21.name(), Set$.MODULE$.canBuildFrom())).mkString(", ")).append("]").append((Object)(columnPath.nonEmpty() ? new StringBuilder(6).append(" from ").append(columnName).toString() : "")).toString());
                    return;
                }
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        DataType fromDataType = (DataType)tuple2._1();
        DataType toDataType = (DataType)tuple2._2();
        DataType dataType = fromDataType;
        DataType dataType4 = toDataType;
        SchemaUtils$.verify$1(!(dataType != null ? !dataType.equals(dataType4) : dataType4 != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("changing data type of ").append(new UnresolvedAttribute(columnPath).name()).append(" ").append("from ").append(fromDataType).append(" to ").append(toDataType).toString());
    }

    public static final /* synthetic */ boolean $anonfun$changeDataType$2(Function2 resolver$3, StructField toField$2, StructField field) {
        return BoxesRunTime.unboxToBoolean((Object)resolver$3.apply((Object)field.name(), (Object)toField$2.name()));
    }

    private final DataType transform$1(Seq path, DataType dt, Option colName$1, Function3 tf$1) {
        DataType dataType;
        DataType dataType2 = dt;
        if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            StructField[] fields = structType.fields();
            Seq newFields = colName$1.isEmpty() || new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).exists((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)colName$1.contains((Object)f.name()))) ? (Seq)tf$1.apply((Object)path, (Object)structType, this.DELTA_COL_RESOLVER()) : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).toSeq();
            dataType = StructType$.MODULE$.apply((Seq)newFields.map((Function1 & Serializable & scala.Serializable)field -> {
                DataType x$1 = this.transform$1((Seq)path.$colon$plus((Object)field.name(), Seq$.MODULE$.canBuildFrom()), field.dataType(), colName$1, tf$1);
                String x$2 = field.copy$default$1();
                boolean x$3 = field.copy$default$3();
                Metadata x$4 = field.copy$default$4();
                return field.copy(x$2, x$1, x$3, x$4);
            }, Seq$.MODULE$.canBuildFrom()));
        } else if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            boolean containsNull = arrayType.containsNull();
            dataType = new ArrayType(this.transform$1((Seq)path.$colon$plus((Object)"element", Seq$.MODULE$.canBuildFrom()), elementType, colName$1, tf$1), containsNull);
        } else if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            boolean valueContainsNull = mapType.valueContainsNull();
            dataType = new MapType(this.transform$1((Seq)path.$colon$plus((Object)"key", Seq$.MODULE$.canBuildFrom()), keyType, colName$1, tf$1), this.transform$1((Seq)path.$colon$plus((Object)"value", Seq$.MODULE$.canBuildFrom()), valueType, colName$1, tf$1), valueContainsNull);
        } else {
            dataType = dataType2;
        }
        DataType newDt = dataType;
        return newDt;
    }

    public static final /* synthetic */ boolean $anonfun$transformColumns$6(Seq fullPath$1, Function2 resolver$4, Tuple2 x$26) {
        return ((IterableLike)((IterableLike)x$26._1()).zip((GenIterable)fullPath$1, Seq$.MODULE$.canBuildFrom())).forall(resolver$4.tupled());
    }

    public static final /* synthetic */ void $anonfun$checkFieldNames$1(String name) {
        if (name.matches(".*[ ,;{}()\n\t=].*")) {
            throw QueryCompilationErrors$.MODULE$.invalidColumnNameAsPathError("delta", name);
        }
    }

    private final StructField checkField$1(Seq path, StructField f, Function2 r, boolean allowUnenforceableNotNulls$1) {
        StructField structField = f;
        if (structField != null) {
            String name = structField.name();
            DataType dataType = structField.dataType();
            boolean nullable = structField.nullable();
            Metadata metadata = structField.metadata();
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType elementType = arrayType.elementType();
                boolean containsNull = arrayType.containsNull();
                DataType nullableElementType = this.typeAsNullable(elementType);
                DataType dataType2 = elementType;
                DataType dataType3 = nullableElementType;
                if ((dataType2 == null ? dataType3 != null : !dataType2.equals(dataType3)) && !allowUnenforceableNotNulls$1) {
                    throw DeltaErrors$.MODULE$.nestedNotNullConstraint(this.prettyFieldName((Seq<String>)((Seq)path.$colon$plus((Object)f.name(), Seq$.MODULE$.canBuildFrom()))), elementType, "element");
                }
                return new StructField(name, (DataType)new ArrayType(nullableElementType, containsNull), nullable, metadata);
            }
        }
        if (structField != null) {
            String name = structField.name();
            DataType dataType = structField.dataType();
            boolean nullable = structField.nullable();
            Metadata metadata = structField.metadata();
            if (dataType instanceof MapType) {
                MapType mapType = (MapType)dataType;
                DataType keyType = mapType.keyType();
                DataType valueType = mapType.valueType();
                boolean containsNull = mapType.valueContainsNull();
                DataType nullableKeyType = this.typeAsNullable(keyType);
                DataType nullableValueType = this.typeAsNullable(valueType);
                DataType dataType4 = keyType;
                DataType dataType5 = nullableKeyType;
                if ((dataType4 == null ? dataType5 != null : !dataType4.equals(dataType5)) && !allowUnenforceableNotNulls$1) {
                    throw DeltaErrors$.MODULE$.nestedNotNullConstraint(this.prettyFieldName((Seq<String>)((Seq)path.$colon$plus((Object)structField.name(), Seq$.MODULE$.canBuildFrom()))), keyType, "key");
                }
                DataType dataType6 = valueType;
                DataType dataType7 = nullableValueType;
                if ((dataType6 == null ? dataType7 != null : !dataType6.equals(dataType7)) && !allowUnenforceableNotNulls$1) {
                    throw DeltaErrors$.MODULE$.nestedNotNullConstraint(this.prettyFieldName((Seq<String>)((Seq)path.$colon$plus((Object)structField.name(), Seq$.MODULE$.canBuildFrom()))), valueType, "value");
                }
                return new StructField(name, (DataType)new MapType(nullableKeyType, nullableValueType, containsNull), nullable, metadata);
            }
        }
        if (structField != null) {
            StructField structField2 = structField;
            return structField2;
        }
        throw new MatchError((Object)structField);
    }

    public static final /* synthetic */ boolean $anonfun$containsDependentExpression$2(Function2 resolver$5, Tuple2 pair) {
        return BoxesRunTime.unboxToBoolean((Object)resolver$5.apply(pair._1(), pair._2()));
    }

    public static final /* synthetic */ void $anonfun$containsDependentExpression$1(Seq columnToChange$1, Function2 resolver$5, Object nonLocalReturnKey1$1, Expression x0$1) {
        Expression expression = x0$1;
        if (expression instanceof UnresolvedAttribute) {
            boolean prefixMatched;
            UnresolvedAttribute unresolvedAttribute = (UnresolvedAttribute)expression;
            boolean bl = prefixMatched = columnToChange$1.size() <= unresolvedAttribute.nameParts().size() && ((IterableLike)unresolvedAttribute.nameParts().zip((GenIterable)columnToChange$1, Seq$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)pair -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.$anonfun$containsDependentExpression$2(resolver$5, pair)));
            if (prefixMatched) {
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
            }
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$checkForTimestampNTZColumnsRecursively$1(DataType x$28) {
        return x$28 instanceof TimestampNTZType;
    }

    public static final /* synthetic */ void $anonfun$recordUndefinedTypes$2(DeltaLog deltaLog$1, String className) {
        DeltaLog x$1 = deltaLog$1;
        String x$2 = "delta.undefined.type";
        Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"className"), (Object)className)}));
        Map<TagDefinition, String> x$4 = MODULE$.recordDeltaEvent$default$3();
        Option<Path> x$5 = MODULE$.recordDeltaEvent$default$5();
        MODULE$.recordDeltaEvent(x$1, x$2, x$4, x$3, x$5);
    }

    private SchemaUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
        this.DELTA_COL_RESOLVER = package$.MODULE$.caseInsensitiveResolution();
        this.ARRAY_ELEMENT_INDEX = 0;
        this.MAP_KEY_INDEX = 0;
        this.MAP_VALUE_INDEX = 1;
    }
}

