/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.sources;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.SubqueryAlias;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog$;
import org.apache.spark.sql.delta.DeltaOptions$;
import org.apache.spark.sql.delta.DeltaTable$;
import org.apache.spark.sql.delta.DeltaTableUtils$;
import org.apache.spark.sql.delta.DeltaTimeTravelSpec;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.files.TahoeFileIndex;
import org.apache.spark.sql.delta.sources.DeltaDataSource;
import org.apache.spark.sql.delta.util.PartitionUtils$;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.streaming.StreamingRelation;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.json4s.Formats;
import org.json4s.NoTypeHints$;
import org.json4s.TypeHints;
import org.json4s.jackson.Serialization$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class DeltaDataSource$
implements DatabricksLogging {
    public static DeltaDataSource$ MODULE$;
    private final Formats formats;

    static {
        new DeltaDataSource$();
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, scala.collection.immutable.Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, scala.collection.immutable.Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, scala.collection.immutable.Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, scala.collection.immutable.Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, scala.collection.immutable.Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    private Formats formats() {
        return this.formats;
    }

    public final String TIME_TRAVEL_SOURCE_KEY() {
        return "__time_travel_source__";
    }

    public final String TIME_TRAVEL_TIMESTAMP_KEY() {
        return "timestampAsOf";
    }

    public final String TIME_TRAVEL_VERSION_KEY() {
        return "versionAsOf";
    }

    public final String CDC_START_VERSION_KEY() {
        return "startingVersion";
    }

    public final String CDC_START_TIMESTAMP_KEY() {
        return "startingTimestamp";
    }

    public final String CDC_END_VERSION_KEY() {
        return "endingVersion";
    }

    public final String CDC_END_TIMESTAMP_KEY() {
        return "endingTimestamp";
    }

    public final String CDC_ENABLED_KEY() {
        return "readChangeFeed";
    }

    public final String CDC_ENABLED_KEY_LEGACY() {
        return "readChangeData";
    }

    public String encodePartitioningColumns(Seq<String> columns) {
        return Serialization$.MODULE$.write(columns, this.formats());
    }

    public Seq<String> decodePartitioningColumns(String str) {
        return (Seq)Serialization$.MODULE$.read(str, this.formats(), ManifestFactory$.MODULE$.classType(Seq.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
    }

    public Option<String> extractDeltaPath(Dataset<?> dataset) {
        LogicalRelation logicalRelation;
        Option<TahoeFileIndex> option;
        SubqueryAlias subqueryAlias;
        LogicalPlan logicalPlan;
        LogicalRelation logicalRelation2;
        Option<TahoeFileIndex> option2;
        if (dataset.isStreaming()) {
            LogicalPlan logicalPlan2 = dataset.queryExecution().logical();
            if (logicalPlan2 instanceof StreamingRelation) {
                StreamingRelation streamingRelation = (StreamingRelation)logicalPlan2;
                Class clazz = streamingRelation.dataSource().providingClass();
                Class<DeltaDataSource> clazz2 = DeltaDataSource.class;
                if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
                    return CaseInsensitiveMap$.MODULE$.apply(streamingRelation.dataSource().options()).get("path");
                }
                return None$.MODULE$;
            }
            return None$.MODULE$;
        }
        LogicalPlan logicalPlan3 = dataset.queryExecution().analyzed();
        if (logicalPlan3 instanceof LogicalRelation && !(option2 = DeltaTable$.MODULE$.unapply(logicalRelation2 = (LogicalRelation)logicalPlan3)).isEmpty()) {
            TahoeFileIndex tahoeFileIndex = (TahoeFileIndex)option2.get();
            return new Some((Object)tahoeFileIndex.path().toString());
        }
        if (logicalPlan3 instanceof SubqueryAlias && (logicalPlan = (subqueryAlias = (SubqueryAlias)logicalPlan3).child()) instanceof LogicalRelation && !(option = DeltaTable$.MODULE$.unapply(logicalRelation = (LogicalRelation)logicalPlan)).isEmpty()) {
            TahoeFileIndex tahoeFileIndex = (TahoeFileIndex)option.get();
            return new Some((Object)tahoeFileIndex.path().toString());
        }
        return None$.MODULE$;
    }

    public Tuple3<Path, Seq<Tuple2<String, String>>, Option<DeltaTimeTravelSpec>> parsePathIdentifier(SparkSession spark, String userPath, scala.collection.immutable.Map<String, String> options) {
        Seq<Tuple2<String, String>> seq;
        Path rootPath;
        Tuple2<String, Option<DeltaTimeTravelSpec>> tuple2 = DeltaTableUtils$.MODULE$.extractIfPathContainsTimeTravel(spark, userPath, options);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String path = (String)tuple2._1();
        Option timeTravelByPath = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)path, (Object)timeTravelByPath);
        String path2 = (String)tuple22._1();
        Option timeTravelByPath2 = (Option)tuple22._2();
        Path hadoopPath = new Path(path2);
        Path path3 = rootPath = (Path)DeltaTableUtils$.MODULE$.findDeltaTableRoot(spark, hadoopPath, options).getOrElse((Function0 & Serializable & scala.Serializable)() -> hadoopPath);
        Path path4 = hadoopPath;
        if (path3 == null ? path4 != null : !path3.equals(path4)) {
            this.logConsole(new StringOps(Predef$.MODULE$.augmentString("\n          |WARNING: loading partitions directly with delta is not recommended.\n          |If you are trying to read a specific partition, use a where predicate.\n          |\n          |CORRECT: spark.read.format(\"delta\").load(\"/data\").where(\"part=1\")\n          |INCORRECT: spark.read.format(\"delta\").load(\"/data/part=1\")\n        ")).stripMargin());
            String fragment = hadoopPath.toString().substring(rootPath.toString().length() + 1);
            try {
                seq = PartitionUtils$.MODULE$.parsePathFragmentAsSeq(fragment);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw DeltaErrors$.MODULE$.partitionPathParseException(fragment);
            }
        } else {
            seq = Nil$.MODULE$;
        }
        Seq<Tuple2<String, String>> partitionFilters = seq;
        return new Tuple3((Object)rootPath, (Object)partitionFilters, (Object)timeTravelByPath2);
    }

    public Seq<Expression> verifyAndCreatePartitionFilters(String userPath, Snapshot snapshot, Seq<Tuple2<String, String>> partitionFilters) {
        if (partitionFilters.nonEmpty()) {
            Metadata metadata = snapshot.metadata();
            Seq badColumns = (Seq)((TraversableLike)partitionFilters.map((Function1 & Serializable & scala.Serializable)x$8 -> (String)x$8._1(), Seq$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)DeltaDataSource$.$anonfun$verifyAndCreatePartitionFilters$2(metadata, elem)));
            if (badColumns.nonEmpty()) {
                String fragment = ((TraversableOnce)partitionFilters.map((Function1 & Serializable & scala.Serializable)f -> new StringBuilder(1).append(f._1()).append("=").append(f._2()).toString(), Seq$.MODULE$.canBuildFrom())).mkString("/");
                throw DeltaErrors$.MODULE$.partitionPathInvolvesNonPartitionColumnException((Seq<String>)badColumns, fragment);
            }
            Seq filters = (Seq)partitionFilters.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    return new EqualTo((Expression)new UnresolvedAttribute((Seq)new .colon.colon((Object)key, (List)Nil$.MODULE$)), (Expression)Literal$.MODULE$.apply((Object)value));
                }
                throw new MatchError((Object)tuple2);
            }, Seq$.MODULE$.canBuildFrom());
            Dataset<Row> files = DeltaLog$.MODULE$.filterFileList(metadata.partitionSchema(), (Dataset<Row>)snapshot.allFiles().toDF(), (Seq<Expression>)filters, DeltaLog$.MODULE$.filterFileList$default$4(), DeltaLog$.MODULE$.filterFileList$default$5());
            if (files.count() == 0L) {
                throw DeltaErrors$.MODULE$.pathNotExistsException(userPath);
            }
            return filters;
        }
        return Nil$.MODULE$;
    }

    public Option<DeltaTimeTravelSpec> getTimeTravelVersion(scala.collection.immutable.Map<String, String> parameters) {
        CaseInsensitiveMap caseInsensitive = CaseInsensitiveMap$.MODULE$.apply(parameters);
        Option tsOpt = caseInsensitive.get("timestampAsOf");
        Option versionOpt = caseInsensitive.get("versionAsOf");
        Option sourceOpt = caseInsensitive.get("__time_travel_source__");
        if (tsOpt.isDefined() && versionOpt.isDefined()) {
            throw DeltaErrors$.MODULE$.provideOneOfInTimeTravel();
        }
        if (tsOpt.isDefined()) {
            return new Some((Object)new DeltaTimeTravelSpec((Option<Expression>)new Some((Object)Literal$.MODULE$.apply(tsOpt.get())), (Option<Object>)None$.MODULE$, (Option<String>)sourceOpt.orElse((Function0 & Serializable & scala.Serializable)() -> new Some((Object)"dfReader"))));
        }
        if (versionOpt.isDefined()) {
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString((String)versionOpt.get())).toLong());
            if (!(try_ instanceof Success)) {
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable t = failure.exception();
                    throw DeltaErrors$.MODULE$.timeTravelInvalidBeginValue("versionAsOf", t);
                }
                throw new MatchError((Object)try_);
            }
            Success success = (Success)try_;
            long v = BoxesRunTime.unboxToLong((Object)success.value());
            long version = v;
            return new Some((Object)new DeltaTimeTravelSpec((Option<Expression>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)version)), (Option<String>)sourceOpt.orElse((Function0 & Serializable & scala.Serializable)() -> new Some((Object)"dfReader"))));
        }
        return None$.MODULE$;
    }

    public Option<String> extractSchemaTrackingLocationConfig(SparkSession spark, scala.collection.immutable.Map<String, String> parameters) {
        CaseInsensitiveStringMap options = new CaseInsensitiveStringMap((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(parameters).asJava());
        return Option$.MODULE$.apply((Object)options.get((Object)DeltaOptions$.MODULE$.SCHEMA_TRACKING_LOCATION())).orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)options.get((Object)DeltaOptions$.MODULE$.SCHEMA_TRACKING_LOCATION_ALIAS())));
    }

    public static final /* synthetic */ boolean $anonfun$verifyAndCreatePartitionFilters$2(Metadata metadata$1, Object elem) {
        return metadata$1.partitionColumns().contains(elem);
    }

    private DeltaDataSource$() {
        MODULE$ = this;
        DatabricksLogging.$init$(this);
        this.formats = Serialization$.MODULE$.formats((TypeHints)NoTypeHints$.MODULE$);
    }
}

