/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.sources;

import java.io.Serializable;
import java.sql.Timestamp;
import org.apache.hadoop.fs.FileStatus;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaHistoryManager;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaOptions;
import org.apache.spark.sql.delta.SnapshotDescriptor;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.Action$;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.sources.DeltaSource;
import org.apache.spark.sql.delta.sources.DeltaSourceMetadataTrackingLog;
import org.apache.spark.sql.delta.storage.ClosableIterator;
import org.apache.spark.sql.delta.storage.ClosableIterator$;
import org.apache.spark.sql.delta.storage.ClosableIterator$ClosableWrapper$;
import org.apache.spark.sql.delta.storage.ClosableIterator$IteratorCloseOps$;
import org.apache.spark.sql.delta.util.DateTimeUtils$;
import org.apache.spark.sql.delta.util.TimestampFormatter;
import org.apache.spark.sql.delta.util.TimestampFormatter$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Some;
import scala.Tuple2;
import scala.Tuple7;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.Nothing$;

public final class DeltaSource$
implements scala.Serializable {
    public static DeltaSource$ MODULE$;

    static {
        new DeltaSource$();
    }

    public Option<DeltaSourceMetadataTrackingLog> $lessinit$greater$default$6() {
        return None$.MODULE$;
    }

    public Seq<Expression> $lessinit$greater$default$7() {
        return Nil$.MODULE$;
    }

    public long getStartingVersionFromTimestamp(SparkSession spark, DeltaLog deltaLog, Timestamp timestamp, boolean canExceedLatest) {
        String tz = spark.sessionState().conf().sessionLocalTimeZone();
        DeltaHistoryManager.Commit commit = deltaLog.history().getActiveCommitAtTime(timestamp, true, false, true);
        if (commit.timestamp() >= timestamp.getTime()) {
            return commit.version();
        }
        if (commit.version() + 1L <= deltaLog.unsafeVolatileSnapshot().version() || canExceedLatest) {
            return commit.version() + 1L;
        }
        Timestamp commitTs = new Timestamp(commit.timestamp());
        TimestampFormatter timestampFormatter = TimestampFormatter$.MODULE$.apply(DateTimeUtils$.MODULE$.getTimeZone(tz));
        String tsString = DateTimeUtils$.MODULE$.timestampToString(timestampFormatter, DateTimeUtils$.MODULE$.fromJavaTimestamp(commitTs));
        throw DeltaErrors$.MODULE$.timestampGreaterThanLatestCommit(timestamp, commitTs, tsString);
    }

    public boolean getStartingVersionFromTimestamp$default$4() {
        return false;
    }

    public ClosableIterator<Action> createRewindableActionIterator(SparkSession spark, DeltaLog deltaLog, FileStatus fileStatus) {
        LazyRef actions$lzy = new LazyRef();
        long threshold = BoxesRunTime.unboxToLong((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.LOG_SIZE_IN_MEMORY_THRESHOLD()));
        boolean shouldLoadIntoMemory = fileStatus.getLen() < threshold;
        return new ClosableIterator<Action>(shouldLoadIntoMemory, deltaLog, fileStatus, actions$lzy){
            private ClosableIterator<Action> delegatedIterator;
            private final boolean shouldLoadIntoMemory$1;
            private final DeltaLog deltaLog$1;
            private final FileStatus fileStatus$1;
            private final LazyRef actions$lzy$1;

            public <R> R processAndClose(Function1<Iterator<Action>, R> f) {
                return (R)ClosableIterator.processAndClose$(this, f);
            }

            public Iterator<Action> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.isTraversableAgain$((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public Iterator<Action> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<Action> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<Action> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<Action> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<Action, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.$plus$plus$((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<Action, GenTraversableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public Iterator<Action> filter(Function1<Action, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<Action, B, Object> p) {
                return Iterator.corresponds$((Iterator)this, that, p);
            }

            public Iterator<Action> withFilter(Function1<Action, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public Iterator<Action> filterNot(Function1<Action, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<Action, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, Action, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<Action, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public Iterator<Action> takeWhile(Function1<Action, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<Action>, Iterator<Action>> partition(Function1<Action, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public Tuple2<Iterator<Action>, Iterator<Action>> span(Function1<Action, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<Action> dropWhile(Function1<Action, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<Action, B>> zip(Iterator<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<Action, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<Action, U> f) {
                Iterator.foreach$((Iterator)this, f);
            }

            public boolean forall(Function1<Action, Object> p) {
                return Iterator.forall$((Iterator)this, p);
            }

            public boolean exists(Function1<Action, Object> p) {
                return Iterator.exists$((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public Option<Action> find(Function1<Action, Object> p) {
                return Iterator.find$((Iterator)this, p);
            }

            public int indexWhere(Function1<Action, Object> p) {
                return Iterator.indexWhere$((Iterator)this, p);
            }

            public int indexWhere(Function1<Action, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public BufferedIterator<Action> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public int length() {
                return Iterator.length$((Iterator)this);
            }

            public Tuple2<Iterator<Action>, Iterator<Action>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Traversable<Action> toTraversable() {
                return Iterator.toTraversable$((Iterator)this);
            }

            public Iterator<Action> toIterator() {
                return Iterator.toIterator$((Iterator)this);
            }

            public Stream<Action> toStream() {
                return Iterator.toStream$((Iterator)this);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public List<Action> reversed() {
                return TraversableOnce.reversed$((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.size$((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.nonEmpty$((TraversableOnce)this);
            }

            public int count(Function1<Action, Object> p) {
                return TraversableOnce.count$((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<Action, B> pf) {
                return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, Action, B> op) {
                return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<Action, B, B> op) {
                return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, Action, B> op) {
                return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<Action, B, B> op) {
                return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, Action, B> op) {
                return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<Action, B, B> op) {
                return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, Action, B> op) {
                return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<Action, B, B> op) {
                return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.reduceOption$((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, Action, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.sum$((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.product$((TraversableOnce)this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
            }

            public List<Action> toList() {
                return TraversableOnce.toList$((TraversableOnce)this);
            }

            public Iterable<Action> toIterable() {
                return TraversableOnce.toIterable$((TraversableOnce)this);
            }

            public Seq<Action> toSeq() {
                return TraversableOnce.toSeq$((TraversableOnce)this);
            }

            public IndexedSeq<Action> toIndexedSeq() {
                return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.toBuffer$((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.toSet$((TraversableOnce)this);
            }

            public Vector<Action> toVector() {
                return TraversableOnce.toVector$((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, Action, Col> cbf) {
                return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
            }

            public <T, U> Map<T, U> toMap(Predef.$less$colon$less<Action, Tuple2<T, U>> ev) {
                return TraversableOnce.toMap$((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.mkString$((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
            }

            public int sizeHintIfCheap() {
                return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
            }

            private ClosableIterator<Action> delegatedIterator() {
                return this.delegatedIterator;
            }

            private void delegatedIterator_$eq(ClosableIterator<Action> x$1) {
                this.delegatedIterator = x$1;
            }

            public boolean hasNext() {
                return this.delegatedIterator().hasNext();
            }

            public Action next() {
                return (Action)this.delegatedIterator().next();
            }

            public void close() {
                this.delegatedIterator().close();
            }

            public void rewind() {
                this.delegatedIterator_$eq(DeltaSource$.org$apache$spark$sql$delta$sources$DeltaSource$$createClosableIterator$1(this.shouldLoadIntoMemory$1, this.deltaLog$1, this.fileStatus$1, this.actions$lzy$1));
            }
            {
                this.shouldLoadIntoMemory$1 = shouldLoadIntoMemory$1;
                this.deltaLog$1 = deltaLog$1;
                this.fileStatus$1 = fileStatus$1;
                this.actions$lzy$1 = actions$lzy$1;
                GenTraversableOnce.$init$((GenTraversableOnce)this);
                TraversableOnce.$init$((TraversableOnce)this);
                Iterator.$init$((Iterator)this);
                ClosableIterator.$init$(this);
                this.delegatedIterator = DeltaSource$.org$apache$spark$sql$delta$sources$DeltaSource$$createClosableIterator$1(shouldLoadIntoMemory$1, deltaLog$1, fileStatus$1, actions$lzy$1);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public <T> Option<T> iteratorLast(ClosableIterator<T> iter) {
        void v0;
        try {
            void var2_2;
            None$ last = None$.MODULE$;
            while (iter.hasNext()) {
                last = new Some(iter.next());
            }
            v0 = var2_2;
        }
        finally {
            iter.close();
        }
        return v0;
    }

    public DeltaSource apply(SparkSession spark, DeltaLog deltaLog, DeltaOptions options, SnapshotDescriptor snapshotAtSourceInit, String metadataPath, Option<DeltaSourceMetadataTrackingLog> metadataTrackingLog, Seq<Expression> filters) {
        return new DeltaSource(spark, deltaLog, options, snapshotAtSourceInit, metadataPath, metadataTrackingLog, filters);
    }

    public Option<DeltaSourceMetadataTrackingLog> apply$default$6() {
        return None$.MODULE$;
    }

    public Seq<Expression> apply$default$7() {
        return Nil$.MODULE$;
    }

    public Option<Tuple7<SparkSession, DeltaLog, DeltaOptions, SnapshotDescriptor, String, Option<DeltaSourceMetadataTrackingLog>, Seq<Expression>>> unapply(DeltaSource x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple7((Object)x$0.spark(), (Object)x$0.deltaLog(), (Object)x$0.options(), (Object)x$0.snapshotAtSourceInit(), (Object)x$0.metadataPath(), x$0.metadataTrackingLog(), x$0.filters()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final /* synthetic */ Seq actions$lzycompute$1(LazyRef actions$lzy$1, DeltaLog deltaLog$1, FileStatus fileStatus$1) {
        Seq seq;
        LazyRef lazyRef = actions$lzy$1;
        synchronized (lazyRef) {
            seq = actions$lzy$1.initialized() ? (Seq)actions$lzy$1.value() : (Seq)actions$lzy$1.initialize(deltaLog$1.store().read(fileStatus$1, deltaLog$1.newDeltaHadoopConf()).map((Function1 & Serializable & scala.Serializable)json -> Action$.MODULE$.fromJson((String)json), Seq$.MODULE$.canBuildFrom()));
        }
        return seq;
    }

    private static final Seq actions$1(LazyRef actions$lzy$1, DeltaLog deltaLog$1, FileStatus fileStatus$1) {
        if (actions$lzy$1.initialized()) {
            return (Seq)actions$lzy$1.value();
        }
        return DeltaSource$.actions$lzycompute$1(actions$lzy$1, deltaLog$1, fileStatus$1);
    }

    public static final ClosableIterator org$apache$spark$sql$delta$sources$DeltaSource$$createClosableIterator$1(boolean shouldLoadIntoMemory$1, DeltaLog deltaLog$1, FileStatus fileStatus$1, LazyRef actions$lzy$1) {
        if (shouldLoadIntoMemory$1) {
            return ClosableIterator$ClosableWrapper$.MODULE$.toClosable$extension(ClosableIterator$.MODULE$.ClosableWrapper(DeltaSource$.actions$1(actions$lzy$1, deltaLog$1, fileStatus$1).toIterator()));
        }
        return ClosableIterator$IteratorCloseOps$.MODULE$.withClose$extension(ClosableIterator$.MODULE$.IteratorCloseOps(deltaLog$1.store().readAsIterator(fileStatus$1, deltaLog$1.newDeltaHadoopConf())), (Function1 & Serializable & scala.Serializable)x$24 -> x$24.map((Function1 & Serializable & scala.Serializable)json -> Action$.MODULE$.fromJson((String)json)));
    }

    private DeltaSource$() {
        MODULE$ = this;
    }
}

