/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.stats;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.delta.DeltaColumnMappingMode;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.DeletionVectorDescriptor;
import org.apache.spark.sql.delta.implicits.package$;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.stats.DeltaStatistics$;
import org.apache.spark.sql.delta.stats.StatsCollector;
import org.apache.spark.sql.delta.stats.StatsCollector$;
import org.apache.spark.sql.delta.util.DeltaFileOperations$;
import org.apache.spark.sql.delta.util.JsonUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;

public final class StatsCollectionUtils$
implements Logging {
    public static StatsCollectionUtils$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new StatsCollectionUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Dataset<AddFile> computeStats(SparkSession spark, Configuration conf, Path dataPath, Dataset<AddFile> addFiles, DeltaColumnMappingMode columnMappingMode, StructType dataSchema, StructType statsSchema, boolean ignoreMissingStats, boolean setBoundsToWide) {
        String parquetRebaseMode = (String)spark.sessionState().conf().getConf(SQLConf$.MODULE$.PARQUET_REBASE_MODE_IN_READ());
        int stringTruncateLength = BoxesRunTime.unboxToInt((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DATA_SKIPPING_STRING_PREFIX_LENGTH()));
        StatsCollector statsCollector = StatsCollector$.MODULE$.apply(columnMappingMode, dataSchema, statsSchema, parquetRebaseMode, ignoreMissingStats, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)stringTruncateLength)));
        SerializableConfiguration serializableConf = new SerializableConfiguration(conf);
        Broadcast broadcastConf = spark.sparkContext().broadcast((Object)serializableConf, ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        String dataRootDir = dataPath.toString();
        return addFiles.mapPartitions((Function1 & Serializable & scala.Serializable)addFileIter -> {
            FileSystem defaultFileSystem = new Path(dataRootDir).getFileSystem(((SerializableConfiguration)broadcastConf.value()).value());
            return addFileIter.map((Function1 & Serializable & scala.Serializable)addFile -> MODULE$.computeStatsForFile((AddFile)addFile, dataRootDir, defaultFileSystem, (SerializableConfiguration)broadcastConf.value(), setBoundsToWide, statsCollector));
        }, package$.MODULE$.addFileEncoder());
    }

    public boolean computeStats$default$8() {
        return true;
    }

    public boolean computeStats$default$9() {
        return false;
    }

    private AddFile computeStatsForFile(AddFile addFile, String dataRootDir, FileSystem defaultFileSystem, SerializableConfiguration config, boolean setBoundsToWide, StatsCollector statsCollector) {
        Path path = DeltaFileOperations$.MODULE$.absolutePath(dataRootDir, addFile.path());
        FileStatus fileStatus = path.toString().startsWith(dataRootDir) ? defaultFileSystem.getFileStatus(path) : path.getFileSystem(config.value()).getFileStatus(path);
        Tuple2<Map<String, Object>, StatsCollector.StatsCollectionMetrics> tuple2 = statsCollector.collect(ParquetFileReader.readFooter((Configuration)config.value(), (FileStatus)fileStatus));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Map stats = (Map)tuple2._1();
        StatsCollector.StatsCollectionMetrics metric = (StatsCollector.StatsCollectionMetrics)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)stats, (Object)metric);
        Map stats2 = (Map)tuple22._1();
        StatsCollector.StatsCollectionMetrics metric2 = (StatsCollector.StatsCollectionMetrics)tuple22._2();
        if (metric2.totalMissingFields() > 0L || metric2.numMissingTypes() > 0L) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("StatsCollection of file `").append(path).append("` misses fields/types: ").append(JsonUtils$.MODULE$.toJson(metric2, ManifestFactory$.MODULE$.classType(ManifestFactory$.MODULE$.singleType((Object)statsCollector), StatsCollector.StatsCollectionMetrics.class, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))).toString());
        }
        boolean hasDeletionVector = addFile.deletionVector() != null && !addFile.deletionVector().isEmpty();
        Map statsWithTightBoundsCol = stats2.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DeltaStatistics$.MODULE$.TIGHT_BOUNDS()), (Object)BoxesRunTime.boxToBoolean((!setBoundsToWide && !hasDeletionVector ? 1 : 0) != 0)));
        String x$1 = JsonUtils$.MODULE$.toJson(statsWithTightBoundsCol, ManifestFactory$.MODULE$.classType(Map.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.Any()})));
        String x$2 = addFile.copy$default$1();
        Map<String, String> x$3 = addFile.copy$default$2();
        long x$4 = addFile.copy$default$3();
        long x$5 = addFile.copy$default$4();
        boolean x$6 = addFile.copy$default$5();
        Map<String, String> x$7 = addFile.copy$default$7();
        DeletionVectorDescriptor x$8 = addFile.copy$default$8();
        Option<Object> x$9 = addFile.copy$default$9();
        Option<Object> x$10 = addFile.copy$default$10();
        return addFile.copy(x$2, x$3, x$4, x$5, x$6, x$1, x$7, x$8, x$9, x$10);
    }

    private StatsCollectionUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

