/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import io.delta.exceptions.ConcurrentTransactionException;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionSet$;
import org.apache.spark.sql.delta.CurrentTransactionInfo;
import org.apache.spark.sql.delta.DeltaColumnMapping$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaLog$;
import org.apache.spark.sql.delta.DeltaTableReadPredicate;
import org.apache.spark.sql.delta.DeltaTableReadPredicate$;
import org.apache.spark.sql.delta.DomainMetadataUtils$;
import org.apache.spark.sql.delta.IsolationLevel;
import org.apache.spark.sql.delta.RowId;
import org.apache.spark.sql.delta.RowId$;
import org.apache.spark.sql.delta.RowId$RowTrackingMetadataDomain$;
import org.apache.spark.sql.delta.RowTracking$;
import org.apache.spark.sql.delta.Serializable$;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.SnapshotIsolation$;
import org.apache.spark.sql.delta.WinningCommitSummary;
import org.apache.spark.sql.delta.WriteSerializable$;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.Action$;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.CommitInfo;
import org.apache.spark.sql.delta.actions.DeletionVectorDescriptor;
import org.apache.spark.sql.delta.actions.DomainMetadata;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.actions.RemoveFile;
import org.apache.spark.sql.delta.actions.SetTransaction;
import org.apache.spark.sql.delta.implicits.package$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.delta.util.FileNames$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005-e!B\u0011#\u0001\tb\u0003\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u0011y\u0002!\u0011!Q\u0001\n}B\u0001b\u0011\u0001\u0003\u0002\u0003\u0006I\u0001\u0012\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005\u0011\")1\n\u0001C\u0001\u0019\"9!\u000b\u0001b\u0001\n#\u0019\u0006B\u0002+\u0001A\u0003%A\tC\u0004V\u0001\t\u0007I\u0011\u0003,\t\r)\u0004\u0001\u0015!\u0003X\u0011\u001dY\u0007A1A\u0005\u00121Da\u0001\u001d\u0001!\u0002\u0013i\u0007bB9\u0001\u0001\u0004%\tB\u001d\u0005\bg\u0002\u0001\r\u0011\"\u0005u\u0011\u0019Q\b\u0001)Q\u0005\u007f!91\u0010\u0001b\u0001\n#a\bbBA\u0001\u0001\u0001\u0006I! \u0005\b\u0003\u0007\u0001A\u0011AA\u0003\u0011\u001d\t9\u0001\u0001C\t\u0003\u0013Aq!a\u0003\u0001\t#\ti\u0001C\u0004\u0002\u0010\u0001!\t\"!\u0004\t\u000f\u0005E\u0001\u0001\"\u0005\u0002\u0014!9\u0011Q\b\u0001\u0005\u0012\u00055\u0001bBA \u0001\u0011E\u0011Q\u0002\u0005\b\u0003\u0003\u0002A\u0011CA\u0007\u0011\u001d\t\u0019\u0005\u0001C\t\u0003\u001bAq!!\u0012\u0001\t\u0013\ti\u0001C\u0004\u0002H\u0001!I!!\u0004\t\u000f\u0005%\u0003\u0001\"\u0003\u0002\u000e!9\u00111\n\u0001\u0005\u0012\u00055\u0003bBA-\u0001\u0011E\u00111\f\u0005\b\u0003\u000b\u0003A\u0011CA\u0007\u0011)\t9\t\u0001EC\u0002\u0013E\u0011\u0011\u0012\u0002\u0010\u0007>tg\r\\5di\u000eCWmY6fe*\u00111\u0005J\u0001\u0006I\u0016dG/\u0019\u0006\u0003K\u0019\n1a]9m\u0015\t9\u0003&A\u0003ta\u0006\u00148N\u0003\u0002*U\u00051\u0011\r]1dQ\u0016T\u0011aK\u0001\u0004_J<7c\u0001\u0001.gA\u0011a&M\u0007\u0002_)\t\u0001'A\u0003tG\u0006d\u0017-\u0003\u00023_\t1\u0011I\\=SK\u001a\u0004\"\u0001N\u001c\u000e\u0003UR!A\u000e\u0012\u0002\u00115,G/\u001a:j]\u001eL!\u0001O\u001b\u0003\u0019\u0011+G\u000e^1M_\u001e<\u0017N\\4\u0004\u0001A\u00111\bP\u0007\u0002I%\u0011Q\b\n\u0002\r'B\f'o[*fgNLwN\\\u0001\u001eS:LG/[1m\u0007V\u0014(/\u001a8u)J\fgn]1di&|g.\u00138g_B\u0011\u0001)Q\u0007\u0002E%\u0011!I\t\u0002\u0017\u0007V\u0014(/\u001a8u)J\fgn]1di&|g.\u00138g_\u0006!r/\u001b8oS:<7i\\7nSR4VM]:j_:\u0004\"AL#\n\u0005\u0019{#\u0001\u0002'p]\u001e\fa\"[:pY\u0006$\u0018n\u001c8MKZ,G\u000e\u0005\u0002A\u0013&\u0011!J\t\u0002\u000f\u0013N|G.\u0019;j_:dUM^3m\u0003\u0019a\u0014N\\5u}Q)QJT(Q#B\u0011\u0001\t\u0001\u0005\u0006O\u0015\u0001\rA\u000f\u0005\u0006}\u0015\u0001\ra\u0010\u0005\u0006\u0007\u0016\u0001\r\u0001\u0012\u0005\u0006\u000f\u0016\u0001\r\u0001S\u0001\fgR\f'\u000f\u001e+j[\u0016l5/F\u0001E\u00031\u0019H/\u0019:u)&lW-T:!\u0003-!\u0018.\\5oON#\u0018\r^:\u0016\u0003]\u0003B\u0001W/`\t6\t\u0011L\u0003\u0002[7\u00069Q.\u001e;bE2,'B\u0001/0\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003=f\u0013q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0002aO:\u0011\u0011-\u001a\t\u0003E>j\u0011a\u0019\u0006\u0003If\na\u0001\u0010:p_Rt\u0014B\u000140\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001.\u001b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0019|\u0013\u0001\u0004;j[&twm\u0015;biN\u0004\u0013\u0001\u00033fYR\fGj\\4\u0016\u00035\u0004\"\u0001\u00118\n\u0005=\u0014#\u0001\u0003#fYR\fGj\\4\u0002\u0013\u0011,G\u000e^1M_\u001e\u0004\u0013AF2veJ,g\u000e\u001e+sC:\u001c\u0018m\u0019;j_:LeNZ8\u0016\u0003}\n!dY;se\u0016tG\u000f\u0016:b]N\f7\r^5p]&sgm\\0%KF$\"!\u001e=\u0011\u000592\u0018BA<0\u0005\u0011)f.\u001b;\t\u000fel\u0011\u0011!a\u0001\u007f\u0005\u0019\u0001\u0010J\u0019\u0002/\r,(O]3oiR\u0013\u0018M\\:bGRLwN\\%oM>\u0004\u0013\u0001F<j]:LgnZ\"p[6LGoU;n[\u0006\u0014\u00180F\u0001~!\t\u0001e0\u0003\u0002\u0000E\t!r+\u001b8oS:<7i\\7nSR\u001cV/\\7bef\fQc^5o]&twmQ8n[&$8+^7nCJL\b%\u0001\bdQ\u0016\u001c7nQ8oM2L7\r^:\u0015\u0003}\n!d\u0019:fCR,w+\u001b8oS:<7i\\7nSR\u001cV/\\7bef$\u0012!`\u0001\u001bG\",7m\u001b)s_R|7m\u001c7D_6\u0004\u0018\r^5cS2LG/\u001f\u000b\u0002k\u000612\r[3dW:{W*\u001a;bI\u0006$\u0018-\u00169eCR,7/A\u0014hKR4\u0015N]:u\r&dW-T1uG\"Lgn\u001a)beRLG/[8o!J,G-[2bi\u0016\u001cH\u0003BA\u000b\u0003O\u0001RALA\f\u00037I1!!\u00070\u0005\u0019y\u0005\u000f^5p]B!\u0011QDA\u0012\u001b\t\tyBC\u0002\u0002\"\t\nq!Y2uS>t7/\u0003\u0003\u0002&\u0005}!aB!eI\u001aKG.\u001a\u0005\b\u0003S)\u0002\u0019AA\u0016\u0003\u00151\u0017\u000e\\3t!\u0019\ti#a\u000e\u0002\u001c9!\u0011qFA\u001a\u001d\r\u0011\u0017\u0011G\u0005\u0002a%\u0019\u0011QG\u0018\u0002\u000fA\f7m[1hK&!\u0011\u0011HA\u001e\u0005\r\u0019V-\u001d\u0006\u0004\u0003ky\u0013\u0001N2iK\u000e\\gi\u001c:BI\u0012,GMR5mKN$\u0006.\u0019;TQ>,H\u000e\u001a%bm\u0016\u0014U-\u001a8SK\u0006$')_\"veJ,g\u000e\u001e+y]\u0006q3\r[3dW\u001a{'\u000fR3mKR,GMR5mKN\fu-Y5ogR\u001cUO\u001d:f]R$\u0006P\u001c*fC\u00124\u0015\u000e\\3t\u0003E\u001a\u0007.Z2l\r>\u0014H)\u001a7fi\u0016$g)\u001b7fg\u0006;\u0017-\u001b8ti\u000e+(O]3oiRCh\u000eR3mKR,GMR5mKN\fqh\u00195fG.4uN]+qI\u0006$X\rZ!qa2L7-\u0019;j_:$&/\u00198tC\u000e$\u0018n\u001c8JIN$\u0006.\u0019;DkJ\u0014XM\u001c;Uq:$U\r]3oIN|e.A\u000fdQ\u0016\u001c7.\u00134E_6\f\u0017N\\'fi\u0006$\u0017\r^1D_:4G.[2u\u0003e\u0011X-Y:tS\u001etwJ^3sY\u0006\u0004\b/\u001b8h%><\u0018\nZ:\u00023I,\u0017m]:jO:\u0014vn^\"p[6LGOV3sg&|gn]\u0001\u001aO\u0016$\bK]3uif\u0004\u0016M\u001d;ji&|g.T3tg\u0006<W\rF\u0002`\u0003\u001fBq!!\u0015\u001e\u0001\u0004\t\u0019&A\bqCJ$\u0018\u000e^5p]Z\u000bG.^3t!\u0015\u0001\u0017QK0`\u0013\r\t9&\u001b\u0002\u0004\u001b\u0006\u0004\u0018A\u0003:fG>\u0014H\rV5nKV!\u0011QLA3)\u0011\ty&!!\u0015\t\u0005\u0005\u0014q\u000f\t\u0005\u0003G\n)\u0007\u0004\u0001\u0005\u000f\u0005\u001ddD1\u0001\u0002j\t\tA+\u0005\u0003\u0002l\u0005E\u0004c\u0001\u0018\u0002n%\u0019\u0011qN\u0018\u0003\u000f9{G\u000f[5oOB\u0019a&a\u001d\n\u0007\u0005UtFA\u0002B]fD\u0001\"!\u001f\u001f\t\u0003\u0007\u00111P\u0001\u0002MB)a&! \u0002b%\u0019\u0011qP\u0018\u0003\u0011q\u0012\u0017P\\1nKzBa!a!\u001f\u0001\u0004y\u0016!\u00029iCN,\u0017A\u00037pO6+GO]5dg\u0006IAn\\4Qe\u00164\u0017\u000e_\u000b\u0002?\u0002")
public class ConflictChecker
implements DeltaLogging {
    private String logPrefix;
    private final SparkSession spark;
    private final CurrentTransactionInfo initialCurrentTransactionInfo;
    private final long winningCommitVersion;
    private final IsolationLevel isolationLevel;
    private final long startTimeMs;
    private final HashMap<String, Object> timingStats;
    private final DeltaLog deltaLog;
    private CurrentTransactionInfo currentTransactionInfo;
    private final WinningCommitSummary winningCommitSummary;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public long startTimeMs() {
        return this.startTimeMs;
    }

    public HashMap<String, Object> timingStats() {
        return this.timingStats;
    }

    public DeltaLog deltaLog() {
        return this.deltaLog;
    }

    public CurrentTransactionInfo currentTransactionInfo() {
        return this.currentTransactionInfo;
    }

    public void currentTransactionInfo_$eq(CurrentTransactionInfo x$1) {
        this.currentTransactionInfo = x$1;
    }

    public WinningCommitSummary winningCommitSummary() {
        return this.winningCommitSummary;
    }

    public CurrentTransactionInfo checkConflicts() {
        this.checkProtocolCompatibility();
        this.checkNoMetadataUpdates();
        this.checkForAddedFilesThatShouldHaveBeenReadByCurrentTxn();
        this.checkForDeletedFilesAgainstCurrentTxnReadFiles();
        this.checkForDeletedFilesAgainstCurrentTxnDeletedFiles();
        this.checkForUpdatedApplicationTransactionIdsThatCurrentTxnDependsOn();
        this.reassignOverlappingRowIds();
        this.reassignRowCommitVersions();
        this.checkIfDomainMetadataConflict();
        this.logMetrics();
        return this.currentTransactionInfo();
    }

    public WinningCommitSummary createWinningCommitSummary() {
        return (WinningCommitSummary)this.recordTime("initialize-old-commit", (Function0 & Serializable & scala.Serializable)() -> {
            Seq winningCommitActions = (Seq)this.deltaLog().store().read(FileNames$.MODULE$.deltaFile(this.deltaLog().logPath(), $this.winningCommitVersion), this.deltaLog().newDeltaHadoopConf()).map((Function1 & Serializable & scala.Serializable)json -> Action$.MODULE$.fromJson((String)json), Seq$.MODULE$.canBuildFrom());
            return new WinningCommitSummary((Seq<Action>)winningCommitActions, $this.winningCommitVersion);
        });
    }

    public void checkProtocolCompatibility() {
        if (this.winningCommitSummary().protocol().nonEmpty()) {
            this.winningCommitSummary().protocol().foreach((Function1 & Serializable & scala.Serializable)p -> {
                ConflictChecker.$anonfun$checkProtocolCompatibility$1(this, p);
                return BoxedUnit.UNIT;
            });
            if (this.currentTransactionInfo().actions().exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ConflictChecker.$anonfun$checkProtocolCompatibility$2(x$4)))) {
                throw DeltaErrors$.MODULE$.protocolChangedException(this.winningCommitSummary().commitInfo());
            }
        }
    }

    public void checkNoMetadataUpdates() {
        if (this.winningCommitSummary().metadataUpdates().nonEmpty()) {
            throw DeltaErrors$.MODULE$.metadataChangedException(this.winningCommitSummary().commitInfo());
        }
    }

    public Option<AddFile> getFirstFileMatchingPartitionPredicates(Seq<AddFile> files) {
        Dataset<Row> filesDf = package$.MODULE$.RichAddFileSeq(files).toDF(this.spark);
        Tuple2 tuple2 = this.currentTransactionInfo().readPredicates().partition((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.shouldRewriteFilter()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq rewrites = (Seq)tuple2._1();
        Seq nonRewrites = (Seq)tuple2._2();
        Set canonicalRewrites = (Set)ExpressionSet$.MODULE$.apply((TraversableOnce)rewrites.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.partitionPredicate(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)e -> new DeltaTableReadPredicate((Seq<Expression>)((Seq)new .colon.colon(e, (List)Nil$.MODULE$)), DeltaTableReadPredicate$.MODULE$.apply$default$2(), DeltaTableReadPredicate$.MODULE$.apply$default$3()), Set$.MODULE$.canBuildFrom());
        Set canonicalNonRewrites = (Set)ExpressionSet$.MODULE$.apply((TraversableOnce)nonRewrites.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.partitionPredicate(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)e -> {
            Seq x$1 = (Seq)new .colon.colon(e, (List)Nil$.MODULE$);
            boolean x$2 = false;
            Seq<Expression> x$3 = DeltaTableReadPredicate$.MODULE$.apply$default$2();
            return new DeltaTableReadPredicate((Seq<Expression>)x$1, x$3, x$2);
        }, Set$.MODULE$.canBuildFrom());
        Set set = canonicalRewrites.$plus$plus((GenTraversableOnce)canonicalNonRewrites);
        Set canonicalPredicates = set;
        AddFile[] filesMatchingPartitionPredicates = (AddFile[])canonicalPredicates.iterator().flatMap((Function1 & Serializable & scala.Serializable)readPredicate -> {
            StructType x$4 = this.currentTransactionInfo().partitionSchemaAtReadTime();
            Dataset x$5 = filesDf;
            Seq<Expression> x$6 = readPredicate.partitionPredicates();
            boolean x$7 = readPredicate.shouldRewriteFilter();
            Seq<String> x$8 = DeltaLog$.MODULE$.filterFileList$default$4();
            return Option$.MODULE$.option2Iterable(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])DeltaLog$.MODULE$.filterFileList(x$4, (Dataset<Row>)x$5, x$6, x$8, x$7).as(package$.MODULE$.addFileEncoder()).head(1))).headOption());
        }).take(1).toArray(ClassTag$.MODULE$.apply(AddFile.class));
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filesMatchingPartitionPredicates)).headOption();
    }

    public void checkForAddedFilesThatShouldHaveBeenReadByCurrentTxn() {
        this.recordTime("checked-appends", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq seq;
            IsolationLevel isolationLevel = $this.isolationLevel;
            if (WriteSerializable$.MODULE$.equals(isolationLevel) && !this.currentTransactionInfo().metadataChanged()) {
                seq = this.winningCommitSummary().changedDataAddedFiles();
            } else {
                boolean bl = Serializable$.MODULE$.equals(isolationLevel) ? true : WriteSerializable$.MODULE$.equals(isolationLevel);
                if (bl) {
                    seq = (Seq)this.winningCommitSummary().changedDataAddedFiles().$plus$plus(this.winningCommitSummary().blindAppendAddedFiles(), Seq$.MODULE$.canBuildFrom());
                } else if (SnapshotIsolation$.MODULE$.equals(isolationLevel)) {
                    seq = (Seq)Nil$.MODULE$;
                } else {
                    throw new MatchError((Object)isolationLevel);
                }
            }
            Seq addedFilesToCheckForConflicts = seq;
            Option<AddFile> fileMatchingPartitionReadPredicates = this.getFirstFileMatchingPartitionPredicates(addedFilesToCheckForConflicts);
            if (fileMatchingPartitionReadPredicates.nonEmpty()) {
                IsolationLevel isolationLevel2 = $this.isolationLevel;
                WriteSerializable$ writeSerializable$ = WriteSerializable$.MODULE$;
                boolean isWriteSerializable = !(isolationLevel2 != null ? !isolationLevel2.equals(writeSerializable$) : writeSerializable$ != null);
                None$ retryMsg = isWriteSerializable && this.winningCommitSummary().onlyAddFiles() && this.winningCommitSummary().isBlindAppendOption().isEmpty() ? new Some((Object)"Upgrading all your concurrent writers to use the latest Delta Lake may avoid this error. Please upgrade and then retry this operation again.") : None$.MODULE$;
                throw DeltaErrors$.MODULE$.concurrentAppendException(this.winningCommitSummary().commitInfo(), this.getPrettyPartitionMessage(((AddFile)fileMatchingPartitionReadPredicates.get()).partitionValues()), (Option<String>)retryMsg);
            }
        });
    }

    public void checkForDeletedFilesAgainstCurrentTxnReadFiles() {
        this.recordTime("checked-deletes", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Map readFilePaths = ((TraversableOnce)this.currentTransactionInfo().readFiles().map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.path()), f.partitionValues()), scala.collection.immutable.Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            Option deleteReadOverlap = this.winningCommitSummary().removedFiles().find((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)readFilePaths.contains((Object)r.path())));
            if (deleteReadOverlap.nonEmpty()) {
                String filePath = ((RemoveFile)deleteReadOverlap.get()).path();
                String partition = this.getPrettyPartitionMessage((Map<String, String>)((Map)readFilePaths.apply((Object)filePath)));
                throw DeltaErrors$.MODULE$.concurrentDeleteReadException(this.winningCommitSummary().commitInfo(), new StringBuilder(4).append(filePath).append(" in ").append(partition).toString());
            }
            if (this.winningCommitSummary().removedFiles().nonEmpty() && this.currentTransactionInfo().readWholeTable()) {
                String filePath = ((RemoveFile)this.winningCommitSummary().removedFiles().head()).path();
                throw DeltaErrors$.MODULE$.concurrentDeleteReadException(this.winningCommitSummary().commitInfo(), String.valueOf(filePath));
            }
        });
    }

    public void checkForDeletedFilesAgainstCurrentTxnDeletedFiles() {
        this.recordTime("checked-2x-deletes", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            scala.collection.immutable.Set txnDeletes = ((TraversableOnce)((TraversableLike)this.currentTransactionInfo().actions().collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends Action, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof RemoveFile) {
                        RemoveFile removeFile = (RemoveFile)A1;
                        object = removeFile;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Action x1) {
                    Action action = x1;
                    boolean bl = action instanceof RemoveFile;
                    return bl;
                }
            }, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.path(), Seq$.MODULE$.canBuildFrom())).toSet();
            scala.collection.immutable.Set deleteOverlap = (scala.collection.immutable.Set)((TraversableOnce)this.winningCommitSummary().removedFiles().map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.path(), Seq$.MODULE$.canBuildFrom())).toSet().intersect((GenSet)txnDeletes);
            if (deleteOverlap.nonEmpty()) {
                throw DeltaErrors$.MODULE$.concurrentDeleteDeleteException(this.winningCommitSummary().commitInfo(), (String)deleteOverlap.head());
            }
        });
    }

    public void checkForUpdatedApplicationTransactionIdsThatCurrentTxnDependsOn() {
        if (this.winningCommitSummary().appLevelTransactions().exists((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ConflictChecker.$anonfun$checkForUpdatedApplicationTransactionIdsThatCurrentTxnDependsOn$1(this, x$10)))) {
            throw DeltaErrors$.MODULE$.concurrentTransactionException(this.winningCommitSummary().commitInfo());
        }
    }

    private void checkIfDomainMetadataConflict() {
        if (!DomainMetadataUtils$.MODULE$.domainMetadataSupported(this.currentTransactionInfo().protocol())) {
            return;
        }
        Map<String, DomainMetadata> winningDomainMetadataMap = DomainMetadataUtils$.MODULE$.extractDomainMetadatasMap(this.winningCommitSummary().actions());
        Buffer mergedDomainMetadata = (Buffer)Buffer$.MODULE$.empty();
        Seq updatedActions = (Seq)this.currentTransactionInfo().actions().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Action action;
            Action action2 = x0$1;
            if (action2 instanceof DomainMetadata) {
                DomainMetadata domainMetadata = (DomainMetadata)action2;
                DomainMetadata mergedAction = ConflictChecker.resolveConflict$1(domainMetadata, winningDomainMetadataMap);
                mergedDomainMetadata.$plus$eq((Object)mergedAction);
                action = mergedAction;
            } else {
                action = action2;
            }
            return action;
        }, Seq$.MODULE$.canBuildFrom());
        CurrentTransactionInfo qual$1 = this.currentTransactionInfo();
        Seq x$1 = mergedDomainMetadata.toSeq();
        Seq x$2 = updatedActions;
        String x$3 = qual$1.copy$default$1();
        Seq<DeltaTableReadPredicate> x$4 = qual$1.copy$default$2();
        scala.collection.immutable.Set<AddFile> x$5 = qual$1.copy$default$3();
        boolean x$6 = qual$1.copy$default$4();
        scala.collection.immutable.Set<String> x$7 = qual$1.copy$default$5();
        Metadata x$8 = qual$1.copy$default$6();
        Protocol x$9 = qual$1.copy$default$7();
        Snapshot x$10 = qual$1.copy$default$9();
        Option<CommitInfo> x$11 = qual$1.copy$default$10();
        long x$12 = qual$1.copy$default$11();
        this.currentTransactionInfo_$eq(qual$1.copy(x$3, x$4, x$5, x$6, x$7, x$8, x$9, (Seq<Action>)x$2, x$10, x$11, x$12, (Seq<DomainMetadata>)x$1));
    }

    private void reassignOverlappingRowIds() {
        if (!RowId$.MODULE$.isSupported(this.currentTransactionInfo().protocol())) {
            return;
        }
        long readHighWaterMark = this.currentTransactionInfo().readRowIdHighWatermark();
        long winningHighWaterMark = BoxesRunTime.unboxToLong((Object)this.winningCommitSummary().actions().collectFirst((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Action, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                Option<RowId.RowTrackingMetadataDomain> option = RowId$RowTrackingMetadataDomain$.MODULE$.unapply(A1);
                if (!option.isEmpty()) {
                    RowId.RowTrackingMetadataDomain domain = (RowId.RowTrackingMetadataDomain)option.get();
                    object = BoxesRunTime.boxToLong((long)domain.rowIdHighWaterMark());
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Action x1) {
                Action action = x1;
                Option<RowId.RowTrackingMetadataDomain> option = RowId$RowTrackingMetadataDomain$.MODULE$.unapply(action);
                boolean bl = !option.isEmpty();
                return bl;
            }
        }).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> readHighWaterMark));
        LongRef highWaterMark = LongRef.create((long)winningHighWaterMark);
        Seq actionsWithReassignedRowIds = (Seq)this.currentTransactionInfo().actions().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Iterable iterable;
            AddFile addFile;
            Action action = x0$1;
            if (action instanceof AddFile && !(addFile = (AddFile)action).baseRowId().exists((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$11 -> x$11 <= readHighWaterMark)) {
                long newBaseRowId = highWaterMark$1.elem + 1L;
                highWaterMark$1.elem += BoxesRunTime.unboxToLong((Object)addFile.numPhysicalRecords().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw DeltaErrors$.MODULE$.rowIdAssignmentWithoutStats();
                }));
                Some x$1 = new Some((Object)BoxesRunTime.boxToLong((long)newBaseRowId));
                String x$2 = addFile.copy$default$1();
                Map<String, String> x$3 = addFile.copy$default$2();
                long x$4 = addFile.copy$default$3();
                long x$5 = addFile.copy$default$4();
                boolean x$6 = addFile.copy$default$5();
                String x$7 = addFile.copy$default$6();
                Map<String, String> x$8 = addFile.copy$default$7();
                DeletionVectorDescriptor x$9 = addFile.copy$default$8();
                Option<Object> x$10 = addFile.copy$default$10();
                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)addFile.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, (Option<Object>)x$1, x$10)));
            } else {
                DomainMetadata domainMetadata;
                iterable = action instanceof DomainMetadata && RowId$RowTrackingMetadataDomain$.MODULE$.isRowTrackingDomain(domainMetadata = (DomainMetadata)action) ? Option$.MODULE$.option2Iterable((Option)None$.MODULE$) : Option$.MODULE$.option2Iterable((Option)new Some((Object)action));
            }
            return iterable;
        }, Seq$.MODULE$.canBuildFrom());
        CurrentTransactionInfo qual$1 = this.currentTransactionInfo();
        DomainMetadata domainMetadata = new RowId.RowTrackingMetadataDomain(highWaterMark.elem).toDomainMetadata(ManifestFactory$.MODULE$.Nothing());
        Seq x$11 = (Seq)actionsWithReassignedRowIds.$plus$colon((Object)domainMetadata, Seq$.MODULE$.canBuildFrom());
        long x$12 = winningHighWaterMark;
        String x$13 = qual$1.copy$default$1();
        Seq<DeltaTableReadPredicate> x$14 = qual$1.copy$default$2();
        scala.collection.immutable.Set<AddFile> x$15 = qual$1.copy$default$3();
        boolean x$16 = qual$1.copy$default$4();
        scala.collection.immutable.Set<String> x$17 = qual$1.copy$default$5();
        Metadata x$18 = qual$1.copy$default$6();
        Protocol x$19 = qual$1.copy$default$7();
        Snapshot x$20 = qual$1.copy$default$9();
        Option<CommitInfo> x$21 = qual$1.copy$default$10();
        Seq<DomainMetadata> x$22 = qual$1.copy$default$12();
        this.currentTransactionInfo_$eq(qual$1.copy(x$13, x$14, x$15, x$16, x$17, x$18, x$19, (Seq<Action>)x$11, x$20, x$21, x$12, x$22));
    }

    private void reassignRowCommitVersions() {
        if (!RowTracking$.MODULE$.isSupported(this.currentTransactionInfo().protocol())) {
            return;
        }
        Seq newActions = (Seq)this.currentTransactionInfo().actions().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            boolean bl = false;
            AddFile addFile = null;
            Action action = x0$1;
            if (action instanceof AddFile) {
                bl = true;
                addFile = (AddFile)action;
                if (addFile.defaultRowCommitVersion().contains((Object)BoxesRunTime.boxToLong((long)$this.winningCommitVersion))) {
                    Some x$1 = new Some((Object)BoxesRunTime.boxToLong((long)($this.winningCommitVersion + 1L)));
                    String x$2 = addFile.copy$default$1();
                    Map<String, String> x$3 = addFile.copy$default$2();
                    long x$4 = addFile.copy$default$3();
                    long x$5 = addFile.copy$default$4();
                    boolean x$6 = addFile.copy$default$5();
                    String x$7 = addFile.copy$default$6();
                    Map<String, String> x$8 = addFile.copy$default$7();
                    DeletionVectorDescriptor x$9 = addFile.copy$default$8();
                    Option<Object> x$10 = addFile.copy$default$9();
                    return addFile.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, (Option<Object>)x$1);
                }
            }
            if (!bl) return action;
            if (!addFile.defaultRowCommitVersion().isEmpty()) return action;
            Some x$11 = new Some((Object)BoxesRunTime.boxToLong((long)($this.winningCommitVersion + 1L)));
            String x$12 = addFile.copy$default$1();
            Map<String, String> x$13 = addFile.copy$default$2();
            long x$14 = addFile.copy$default$3();
            long x$15 = addFile.copy$default$4();
            boolean x$16 = addFile.copy$default$5();
            String x$17 = addFile.copy$default$6();
            Map<String, String> x$18 = addFile.copy$default$7();
            DeletionVectorDescriptor x$19 = addFile.copy$default$8();
            Option<Object> x$20 = addFile.copy$default$9();
            return addFile.copy(x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, (Option<Object>)x$11);
        }, Seq$.MODULE$.canBuildFrom());
        CurrentTransactionInfo qual$1 = this.currentTransactionInfo();
        Seq x$21 = newActions;
        String x$22 = qual$1.copy$default$1();
        Seq<DeltaTableReadPredicate> x$23 = qual$1.copy$default$2();
        scala.collection.immutable.Set<AddFile> x$24 = qual$1.copy$default$3();
        boolean x$25 = qual$1.copy$default$4();
        scala.collection.immutable.Set<String> x$26 = qual$1.copy$default$5();
        Metadata x$27 = qual$1.copy$default$6();
        Protocol x$28 = qual$1.copy$default$7();
        Snapshot x$29 = qual$1.copy$default$9();
        Option<CommitInfo> x$30 = qual$1.copy$default$10();
        long x$31 = qual$1.copy$default$11();
        Seq<DomainMetadata> x$32 = qual$1.copy$default$12();
        this.currentTransactionInfo_$eq(qual$1.copy(x$22, x$23, x$24, x$25, x$26, x$27, x$28, (Seq<Action>)x$21, x$29, x$30, x$31, x$32));
    }

    public String getPrettyPartitionMessage(Map<String, String> partitionValues) {
        String string;
        StructType partitionColumns = this.currentTransactionInfo().partitionSchemaAtReadTime();
        if (partitionColumns.isEmpty()) {
            string = "the root of the table";
        } else {
            String partition = ((TraversableOnce)partitionColumns.map((Function1 & Serializable & scala.Serializable)field -> new StringBuilder(1).append(field.name()).append("=").append(partitionValues.apply((Object)DeltaColumnMapping$.MODULE$.getPhysicalName((StructField)field))).toString(), Seq$.MODULE$.canBuildFrom())).mkString("[", ", ", "]");
            string = new StringBuilder(10).append("partition ").append(partition).toString();
        }
        return string;
    }

    public <T> T recordTime(String phase, Function0<T> f) {
        long startTimeNs = System.nanoTime();
        Object ret = f.apply();
        long timeTakenMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimeNs);
        this.timingStats().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)phase), (Object)BoxesRunTime.boxToLong((long)timeTakenMs)));
        return (T)ret;
    }

    public void logMetrics() {
        long totalTimeTakenMs = System.currentTimeMillis() - this.startTimeMs();
        String timingStr = ((TraversableOnce)((TraversableLike)this.timingStats().keys().toSeq().sorted((Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable & scala.Serializable)k -> new StringBuilder(1).append((String)k).append("=").append(this.timingStats().apply(k)).toString(), Seq$.MODULE$.canBuildFrom())).mkString(",");
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("[").append(this.logPrefix()).append("] Timing stats against ").append($this.winningCommitVersion).append(" ").append("[").append(timingStr).append(", totalTimeTakenMs: ").append(totalTimeTakenMs).append("]").toString());
    }

    private String logPrefix$lzycompute() {
        ConflictChecker conflictChecker = this;
        synchronized (conflictChecker) {
            if (!this.bitmap$0) {
                this.logPrefix = new StringBuilder(18).append("[tableId=").append(ConflictChecker.truncate$1(this.initialCurrentTransactionInfo.readSnapshot().metadata().id())).append(",").append("txnId=").append(ConflictChecker.truncate$1(this.initialCurrentTransactionInfo.txnId())).append("] ").toString();
                this.bitmap$0 = true;
            }
        }
        return this.logPrefix;
    }

    public String logPrefix() {
        return !this.bitmap$0 ? this.logPrefix$lzycompute() : this.logPrefix;
    }

    public static final /* synthetic */ void $anonfun$checkProtocolCompatibility$1(ConflictChecker $this, Protocol p) {
        $this.deltaLog().protocolRead(p);
        $this.deltaLog().protocolWrite(p);
        CurrentTransactionInfo qual$1 = $this.currentTransactionInfo();
        Protocol x$1 = p;
        String x$2 = qual$1.copy$default$1();
        Seq<DeltaTableReadPredicate> x$3 = qual$1.copy$default$2();
        scala.collection.immutable.Set<AddFile> x$4 = qual$1.copy$default$3();
        boolean x$5 = qual$1.copy$default$4();
        scala.collection.immutable.Set<String> x$6 = qual$1.copy$default$5();
        Metadata x$7 = qual$1.copy$default$6();
        Seq<Action> x$8 = qual$1.copy$default$8();
        Snapshot x$9 = qual$1.copy$default$9();
        Option<CommitInfo> x$10 = qual$1.copy$default$10();
        long x$11 = qual$1.copy$default$11();
        Seq<DomainMetadata> x$12 = qual$1.copy$default$12();
        $this.currentTransactionInfo_$eq(qual$1.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$1, x$8, x$9, x$10, x$11, x$12));
    }

    public static final /* synthetic */ boolean $anonfun$checkProtocolCompatibility$2(Action x$4) {
        return x$4 instanceof Protocol;
    }

    public static final /* synthetic */ boolean $anonfun$checkForUpdatedApplicationTransactionIdsThatCurrentTxnDependsOn$1(ConflictChecker $this, SetTransaction x$10) {
        return $this.currentTransactionInfo().isConflict(x$10);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final DomainMetadata resolveConflict$1(DomainMetadata domainMetadataFromCurrentTransaction, Map winningDomainMetadataMap$1) {
        DomainMetadata domain;
        Tuple2 tuple2 = new Tuple2((Object)domainMetadataFromCurrentTransaction, (Object)winningDomainMetadataMap$1.get((Object)domainMetadataFromCurrentTransaction.domain()));
        if (tuple2 != null) {
            DomainMetadata domain2 = (DomainMetadata)tuple2._1();
            Option option = (Option)tuple2._2();
            if (None$.MODULE$.equals(option)) {
                return domain2;
            }
        }
        if (tuple2 != null && RowId$RowTrackingMetadataDomain$.MODULE$.isRowTrackingDomain(domain = (DomainMetadata)tuple2._1())) {
            return domain;
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Option option = (Option)tuple2._2();
        if (!(option instanceof Some)) throw new MatchError((Object)tuple2);
        throw new ConcurrentTransactionException(new StringBuilder(40).append("A conflicting metadata domain ").append(domainMetadataFromCurrentTransaction.domain()).append(" is ").append("added.").toString());
    }

    private static final String truncate$1(String uuid) {
        return (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])uuid.split("-"))).head();
    }

    public ConflictChecker(SparkSession spark, CurrentTransactionInfo initialCurrentTransactionInfo, long winningCommitVersion, IsolationLevel isolationLevel) {
        this.spark = spark;
        this.initialCurrentTransactionInfo = initialCurrentTransactionInfo;
        this.winningCommitVersion = winningCommitVersion;
        this.isolationLevel = isolationLevel;
        Logging.$init$((Logging)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
        this.startTimeMs = System.currentTimeMillis();
        this.timingStats = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.deltaLog = initialCurrentTransactionInfo.readSnapshot().deltaLog();
        this.currentTransactionInfo = initialCurrentTransactionInfo;
        this.winningCommitSummary = this.createWinningCommitSummary();
    }
}

