/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.FunctionIdentifier$;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistryBase$;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionInfo;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.delta.CDCNameBased;
import org.apache.spark.sql.delta.CDCPathBased;
import org.apache.spark.sql.delta.DeltaAnalysisException;
import org.apache.spark.sql.delta.DeltaAnalysisException$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaTimeTravelSpec;
import org.apache.spark.sql.delta.catalog.DeltaTableV2;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;

public final class DeltaTableValueFunctions$ {
    public static DeltaTableValueFunctions$ MODULE$;
    private final String CDC_NAME_BASED;
    private final String CDC_PATH_BASED;
    private final Seq<String> supportedFnNames;

    static {
        new DeltaTableValueFunctions$();
    }

    public String CDC_NAME_BASED() {
        return this.CDC_NAME_BASED;
    }

    public String CDC_PATH_BASED() {
        return this.CDC_PATH_BASED;
    }

    public Seq<String> supportedFnNames() {
        return this.supportedFnNames;
    }

    public Tuple3<FunctionIdentifier, ExpressionInfo, Function1<Seq<Expression>, LogicalPlan>> getTableValueFunctionInjection(String fnName) {
        Tuple2 tuple2;
        String string = fnName;
        String string2 = this.CDC_NAME_BASED();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            tuple2 = FunctionRegistryBase$.MODULE$.build(fnName, (Option)None$.MODULE$, ClassTag$.MODULE$.apply(CDCNameBased.class));
        } else {
            String string4 = this.CDC_PATH_BASED();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                tuple2 = FunctionRegistryBase$.MODULE$.build(fnName, (Option)None$.MODULE$, ClassTag$.MODULE$.apply(CDCPathBased.class));
            } else {
                throw DeltaErrors$.MODULE$.invalidTableValueFunction(fnName);
            }
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        ExpressionInfo info = (ExpressionInfo)tuple22._1();
        Function1 builder = (Function1)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)info, (Object)builder);
        Tuple2 tuple24 = tuple23;
        ExpressionInfo info2 = (ExpressionInfo)tuple24._1();
        Function1 builder2 = (Function1)tuple24._2();
        FunctionIdentifier ident = FunctionIdentifier$.MODULE$.apply(fnName);
        return new Tuple3((Object)ident, (Object)info2, (Object)builder2);
    }

    public LogicalPlan resolveChangesTableValueFunctions(SparkSession session, String fnName, Seq<Expression> args) {
        DeltaTableV2 deltaTableV2;
        block11: {
            block12: {
                scala.collection.immutable.Map options;
                Expression tableNameExpr;
                block14: {
                    block13: {
                        block8: {
                            block10: {
                                block9: {
                                    if (args.size() < 2) {
                                        throw new DeltaAnalysisException("INCORRECT_NUMBER_OF_ARGUMENTS", (String[])((Object[])new String[]{"not enough args", fnName, "2", "3"}), DeltaAnalysisException$.MODULE$.$lessinit$greater$default$3(), DeltaAnalysisException$.MODULE$.$lessinit$greater$default$4());
                                    }
                                    if (args.size() > 3) {
                                        throw new DeltaAnalysisException("INCORRECT_NUMBER_OF_ARGUMENTS", (String[])((Object[])new String[]{"too many args", fnName, "2", "3"}), DeltaAnalysisException$.MODULE$.$lessinit$greater$default$3(), DeltaAnalysisException$.MODULE$.$lessinit$greater$default$4());
                                    }
                                    tableNameExpr = (Expression)args.head();
                                    Tuple2 startingOption = DeltaTableValueFunctions$.toDeltaOption$1("starting", (Expression)args.apply(1));
                                    Option endingOption = ((TraversableLike)args.drop(2)).headOption().map((Function1 & Serializable & scala.Serializable)x$2 -> DeltaTableValueFunctions$.toDeltaOption$1("ending", x$2));
                                    options = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"readChangeFeed"), (Object)"true"), startingOption}))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(endingOption));
                                    String string = fnName.toLowerCase(Locale.ROOT);
                                    String string2 = this.CDC_NAME_BASED();
                                    if (string != null ? !string.equals(string2) : string2 != null) break block8;
                                    Expression expression = tableNameExpr;
                                    if (!(expression instanceof Literal)) break block9;
                                    Literal literal = (Literal)expression;
                                    DataType dataType = literal.dataType();
                                    StringType$ stringType$ = StringType$.MODULE$;
                                    if (!(dataType != null ? !dataType.equals(stringType$) : stringType$ != null)) break block10;
                                }
                                throw DeltaErrors$.MODULE$.unsupportedExpression("table name", tableNameExpr.dataType(), (Seq<String>)((Seq)new .colon.colon((Object)"Literal of type StringType", (List)Nil$.MODULE$)));
                            }
                            TableIdentifier tableIdentifier = session.sessionState().sqlParser().parseTableIdentifier(tableNameExpr.eval(tableNameExpr.eval$default$1()).toString());
                            TableIdentifier tableId = tableIdentifier;
                            CatalogTable catalogTable = session.sessionState().catalog().getTableMetadata(tableId);
                            deltaTableV2 = new DeltaTableV2(session, new Path(catalogTable.location()), (Option<CatalogTable>)new Some((Object)catalogTable), (Option<String>)new Some((Object)tableId.unquotedString()), (Option<DeltaTimeTravelSpec>)None$.MODULE$, (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), new CaseInsensitiveStringMap((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)options).asJava()));
                            break block11;
                        }
                        String string = fnName.toLowerCase(Locale.ROOT);
                        String string3 = this.CDC_PATH_BASED();
                        if (string != null ? !string.equals(string3) : string3 != null) break block12;
                        Expression expression = tableNameExpr;
                        if (!(expression instanceof Literal)) break block13;
                        DataType dataType = tableNameExpr.dataType();
                        StringType$ stringType$ = StringType$.MODULE$;
                        if (!(dataType != null ? !dataType.equals(stringType$) : stringType$ != null)) break block14;
                    }
                    throw DeltaErrors$.MODULE$.unsupportedExpression("table path", tableNameExpr.dataType(), (Seq<String>)((Seq)new .colon.colon((Object)"StringType", (List)Nil$.MODULE$)));
                }
                String string = tableNameExpr.eval(tableNameExpr.eval$default$1()).toString();
                String path = string;
                deltaTableV2 = new DeltaTableV2(session, new Path(path), (Option<CatalogTable>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<DeltaTimeTravelSpec>)None$.MODULE$, (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), new CaseInsensitiveStringMap((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)options).asJava()));
                break block11;
            }
            throw DeltaErrors$.MODULE$.invalidTableValueFunction(fnName);
        }
        DeltaTableV2 table = deltaTableV2;
        BaseRelation relation = table.toBaseRelation();
        return new LogicalRelation(relation, relation.schema().toAttributes(), table.catalogTable().map((Function1 & Serializable & scala.Serializable)x$3 -> {
            None$ x$1 = None$.MODULE$;
            TableIdentifier x$2 = x$3.copy$default$1();
            CatalogTableType x$32 = x$3.copy$default$2();
            CatalogStorageFormat x$4 = x$3.copy$default$3();
            StructType x$5 = x$3.copy$default$4();
            Option x$6 = x$3.copy$default$5();
            Seq x$7 = x$3.copy$default$6();
            Option x$8 = x$3.copy$default$7();
            String x$9 = x$3.copy$default$8();
            long x$10 = x$3.copy$default$9();
            long x$11 = x$3.copy$default$10();
            String x$12 = x$3.copy$default$11();
            scala.collection.immutable.Map x$13 = x$3.copy$default$12();
            Option x$14 = x$3.copy$default$14();
            Option x$15 = x$3.copy$default$15();
            Seq x$16 = x$3.copy$default$16();
            boolean x$17 = x$3.copy$default$17();
            boolean x$18 = x$3.copy$default$18();
            scala.collection.immutable.Map x$19 = x$3.copy$default$19();
            Option x$20 = x$3.copy$default$20();
            return x$3.copy(x$2, x$32, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, (Option)x$1, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        }), false);
    }

    private static final Tuple2 toDeltaOption$1(String keyPrefix, Expression value) {
        Tuple2 tuple2;
        DataType dataType = value.dataType();
        boolean bl = dataType instanceof IntegerType ? true : LongType$.MODULE$.equals(dataType);
        if (bl) {
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(7).append(keyPrefix).append("Version").toString()), (Object)value.eval(value.eval$default$1()).toString());
        } else if (dataType instanceof StringType) {
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(9).append(keyPrefix).append("Timestamp").toString()), (Object)value.eval(value.eval$default$1()).toString());
        } else if (dataType instanceof TimestampType) {
            String time = value.eval(value.eval$default$1()).toString();
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(9).append(keyPrefix).append("Timestamp").toString()), (Object)fmt.format(new Date(new StringOps(Predef$.MODULE$.augmentString(time)).toLong() / 1000L)));
        } else {
            throw DeltaErrors$.MODULE$.unsupportedExpression(new StringBuilder(7).append(keyPrefix).append(" option").toString(), value.dataType(), (Seq<String>)((Seq)new .colon.colon((Object)"IntegerType", (List)new .colon.colon((Object)"LongType", (List)new .colon.colon((Object)"StringType", (List)new .colon.colon((Object)"TimestampType", (List)Nil$.MODULE$))))));
        }
        return tuple2;
    }

    private DeltaTableValueFunctions$() {
        MODULE$ = this;
        this.CDC_NAME_BASED = "table_changes";
        this.CDC_PATH_BASED = "table_changes_by_path";
        this.supportedFnNames = (Seq)new .colon.colon((Object)this.CDC_NAME_BASED(), (List)new .colon.colon((Object)this.CDC_PATH_BASED(), (List)Nil$.MODULE$));
    }
}

