/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.delta.LastCheckpointInfo;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.FileNames$;
import org.apache.spark.sql.delta.util.JsonUtils$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple7;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar;

public final class LastCheckpointInfo$
implements scala.Serializable {
    public static LastCheckpointInfo$ MODULE$;
    private final String STORED_CHECKSUM_KEY;
    private final Set<Object> isUnreservedOctet;

    static {
        new LastCheckpointInfo$();
    }

    public Option<String> $lessinit$greater$default$7() {
        return None$.MODULE$;
    }

    public String STORED_CHECKSUM_KEY() {
        return this.STORED_CHECKSUM_KEY;
    }

    public boolean checksumEnabled(SparkSession spark) {
        return BoxesRunTime.unboxToBoolean((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.LAST_CHECKPOINT_CHECKSUM_ENABLED()));
    }

    public String serializeToJson(LastCheckpointInfo lastCheckpointInfo, boolean addChecksum, boolean suppressOptionalFields) {
        if (suppressOptionalFields) {
            return JsonUtils$.MODULE$.toJson(new LastCheckpointInfo(lastCheckpointInfo.version(), lastCheckpointInfo.size(), lastCheckpointInfo.parts(), (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<StructType>)None$.MODULE$, this.apply$default$7()), ManifestFactory$.MODULE$.classType(LastCheckpointInfo.class));
        }
        None$ x$1 = None$.MODULE$;
        long x$2 = lastCheckpointInfo.copy$default$1();
        long x$3 = lastCheckpointInfo.copy$default$2();
        Option<Object> x$4 = lastCheckpointInfo.copy$default$3();
        Option<Object> x$5 = lastCheckpointInfo.copy$default$4();
        Option<Object> x$6 = lastCheckpointInfo.copy$default$5();
        Option<StructType> x$7 = lastCheckpointInfo.copy$default$6();
        String jsonStr = JsonUtils$.MODULE$.toJson(lastCheckpointInfo.copy(x$2, x$3, x$4, x$5, x$6, x$7, (Option<String>)x$1), ManifestFactory$.MODULE$.classType(LastCheckpointInfo.class));
        if (!addChecksum) {
            return jsonStr;
        }
        ObjectNode rootNode = (ObjectNode)JsonUtils$.MODULE$.mapper().readValue(jsonStr, ObjectNode.class);
        String checksum = this.treeNodeToChecksum((JsonNode)rootNode);
        return rootNode.put(this.STORED_CHECKSUM_KEY(), checksum).toString();
    }

    public boolean serializeToJson$default$3() {
        return false;
    }

    public LastCheckpointInfo deserializeFromJson(String jsonStr, boolean validate) {
        block1: {
            if (!validate) break block1;
            Tuple2<Option<String>, String> tuple2 = this.getChecksums(jsonStr);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Option storedChecksumOpt = (Option)tuple2._1();
            String actualChecksum = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)storedChecksumOpt, (Object)actualChecksum);
            Tuple2 tuple23 = tuple22;
            Option storedChecksumOpt2 = (Option)tuple23._1();
            String actualChecksum2 = (String)tuple23._2();
            storedChecksumOpt2.filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)LastCheckpointInfo$.$anonfun$deserializeFromJson$1(actualChecksum2, x$2))).foreach((Function1 & Serializable & scala.Serializable)storedChecksum -> {
                throw new IllegalStateException(new StringBuilder(71).append("Checksum validation failed for json: ").append(jsonStr).append(",\n").append("storedChecksum:").append((String)storedChecksum).append(", actualChecksum:").append(actualChecksum2).toString());
            });
        }
        return (LastCheckpointInfo)JsonUtils$.MODULE$.fromJson(jsonStr, ManifestFactory$.MODULE$.classType(LastCheckpointInfo.class));
    }

    public Tuple2<Option<String>, String> getChecksums(String jsonStr) {
        ObjectReader reader = JsonUtils$.MODULE$.mapper().reader().withFeatures(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY});
        JsonNode rootNode = reader.readTree(jsonStr);
        None$ storedChecksum = rootNode.has(this.STORED_CHECKSUM_KEY()) ? new Some((Object)rootNode.get(this.STORED_CHECKSUM_KEY()).asText()) : None$.MODULE$;
        String actualChecksum = this.treeNodeToChecksum(rootNode);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)storedChecksum), (Object)actualChecksum);
    }

    public String treeNodeToChecksum(JsonNode treeNode) {
        ArrayBuffer jsonEntriesBuffer = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        this.traverseJsonNode$1(treeNode, (ArrayBuffer)ArrayBuffer$.MODULE$.empty(), jsonEntriesBuffer);
        String normalizedJsonKeyValues = ((TraversableOnce)((SeqLike)((TraversableLike)jsonEntriesBuffer.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LastCheckpointInfo$.$anonfun$treeNodeToChecksum$3(x0$1)))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            String string = new StringBuilder(1).append(k).append("=").append(v).toString();
            return string;
        }, ArrayBuffer$.MODULE$.canBuildFrom())).sortBy((Function1 & Serializable & scala.Serializable)x$3 -> new StringOps(Predef$.MODULE$.augmentString(x$3)).toSeq(), Ordering.Implicits$.MODULE$.seqDerivedOrdering((Ordering)Ordering.Char$.MODULE$))).mkString(",");
        return DigestUtils.md5Hex((String)normalizedJsonKeyValues);
    }

    private Set<Object> isUnreservedOctet() {
        return this.isUnreservedOctet;
    }

    private String encodeString(String str) {
        String result = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(str.getBytes(StandardCharsets.UTF_8))).map((Function1 & Serializable & scala.Serializable)x0$1 -> LastCheckpointInfo$.$anonfun$encodeString$1(BoxesRunTime.unboxToByte((Object)x0$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString();
        return new StringBuilder(2).append("\"").append(result).append("\"").toString();
    }

    public LastCheckpointInfo fromFiles(Seq<FileStatus> files) {
        Predef$.MODULE$.assert(files.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "files should be non empty to construct LastCheckpointInfo");
        return new LastCheckpointInfo(FileNames$.MODULE$.checkpointVersion((FileStatus)files.head()), -1L, FileNames$.MODULE$.numCheckpointParts(((FileStatus)files.head()).getPath()), (Option<Object>)new Some(((TraversableOnce)files.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.getLen()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), (Option<Object>)None$.MODULE$, (Option<StructType>)None$.MODULE$, this.apply$default$7());
    }

    public LastCheckpointInfo apply(long version, long size, Option<Object> parts, Option<Object> sizeInBytes, Option<Object> numOfAddFiles, Option<StructType> checkpointSchema, Option<String> checksum) {
        return new LastCheckpointInfo(version, size, parts, sizeInBytes, numOfAddFiles, checkpointSchema, checksum);
    }

    public Option<String> apply$default$7() {
        return None$.MODULE$;
    }

    public Option<Tuple7<Object, Object, Option<Object>, Option<Object>, Option<Object>, Option<StructType>, Option<String>>> unapply(LastCheckpointInfo x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple7((Object)BoxesRunTime.boxToLong((long)x$0.version()), (Object)BoxesRunTime.boxToLong((long)x$0.size()), x$0.parts(), x$0.sizeInBytes(), x$0.numOfAddFiles(), x$0.checkpointSchema(), x$0.checksum()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$deserializeFromJson$1(String actualChecksum$1, String x$2) {
        String string = x$2;
        String string2 = actualChecksum$1;
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$treeNodeToChecksum$1(LastCheckpointInfo$ $this, ArrayBuffer prefix$1, ArrayBuffer jsonEntriesBuffer$1, Map.Entry entry) {
        prefix$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{MODULE$.encodeString((String)entry.getKey())}));
        $this.traverseJsonNode$1((JsonNode)entry.getValue(), prefix$1, jsonEntriesBuffer$1);
        prefix$1.trimEnd(1);
    }

    public static final /* synthetic */ void $anonfun$treeNodeToChecksum$2(LastCheckpointInfo$ $this, ArrayBuffer prefix$1, ArrayBuffer jsonEntriesBuffer$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        JsonNode jsonNode = (JsonNode)tuple2._1();
        int index = tuple2._2$mcI$sp();
        prefix$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{Integer.toString(index)}));
        $this.traverseJsonNode$1(jsonNode, prefix$1, jsonEntriesBuffer$1);
        prefix$1.trimEnd(1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final void traverseJsonNode$1(JsonNode currentNode, ArrayBuffer prefix, ArrayBuffer jsonEntriesBuffer$1) {
        if (currentNode.isObject()) {
            ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(currentNode.fields()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> {
                LastCheckpointInfo$.$anonfun$treeNodeToChecksum$1(this, prefix, jsonEntriesBuffer$1, entry);
                return BoxedUnit.UNIT;
            });
        } else if (currentNode.isArray()) {
            ((IterableLike)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)currentNode).asScala()).zipWithIndex(Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                LastCheckpointInfo$.$anonfun$treeNodeToChecksum$2(this, prefix, jsonEntriesBuffer$1, x0$1);
                return BoxedUnit.UNIT;
            });
        } else {
            String nodeValue = currentNode.asText();
            if (currentNode.isTextual()) {
                nodeValue = this.encodeString(nodeValue);
            }
            jsonEntriesBuffer$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)prefix.mkString("+")), (Object)nodeValue)}));
        }
    }

    public static final /* synthetic */ boolean $anonfun$treeNodeToChecksum$3(Tuple2 x0$1) {
        String k;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String string = k = (String)tuple2._1();
        String string2 = new StringBuilder(2).append("\"").append(MODULE$.STORED_CHECKSUM_KEY()).append("\"").toString();
        boolean bl = string == null ? string2 != null : !string.equals(string2);
        return bl;
    }

    public static final /* synthetic */ byte $anonfun$isUnreservedOctet$1(char x$4) {
        return (byte)x$4;
    }

    public static final /* synthetic */ String $anonfun$encodeString$1(byte x0$1) {
        String string;
        byte by = x0$1;
        switch (by) {
            default: 
        }
        if (MODULE$.isUnreservedOctet().apply((Object)BoxesRunTime.boxToByte((byte)by))) {
            string = Character.toString((char)by);
        } else {
            int c;
            int arg$macro$1 = c = by & 0xFF;
            string = new StringOps("%%%02X").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$1)}));
        }
        return string;
    }

    private LastCheckpointInfo$() {
        MODULE$ = this;
        this.STORED_CHECKSUM_KEY = "checksum";
        this.isUnreservedOctet = (Set)Predef$.MODULE$.Set().empty().$plus$plus((GenTraversableOnce)new RichChar(Predef$.MODULE$.charWrapper('a')).to((Object)BoxesRunTime.boxToCharacter((char)'z'))).$plus$plus((GenTraversableOnce)new RichChar(Predef$.MODULE$.charWrapper('A')).to((Object)BoxesRunTime.boxToCharacter((char)'Z'))).$plus$plus((GenTraversableOnce)new RichChar(Predef$.MODULE$.charWrapper('0')).to((Object)BoxesRunTime.boxToCharacter((char)'9'))).$plus$plus((GenTraversableOnce)new StringOps(Predef$.MODULE$.augmentString("-._~"))).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToByte((byte)LastCheckpointInfo$.$anonfun$isUnreservedOctet$1(BoxesRunTime.unboxToChar((Object)x$4))), Set$.MODULE$.canBuildFrom());
    }
}

