/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.actions;

import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaTablePropertyValidationFailedException;
import org.apache.spark.sql.delta.DeltaTablePropertyValidationFailedSubClass$ExistingDeletionVectorsWithIncrementalManifestGeneration$;
import org.apache.spark.sql.delta.DeltaTablePropertyValidationFailedSubClass$PersistentDeletionVectorsInNonParquetTable$;
import org.apache.spark.sql.delta.DeltaTablePropertyValidationFailedSubClass$PersistentDeletionVectorsWithIncrementalManifestGeneration$;
import org.apache.spark.sql.delta.FeatureAutomaticallyEnabledByMetadata;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.TableFeature;
import org.apache.spark.sql.delta.TableFeature$;
import org.apache.spark.sql.delta.actions.Action$;
import org.apache.spark.sql.delta.actions.Format;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.Metadata$;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.actions.TableFeatureProtocolUtils$;
import org.apache.spark.sql.delta.commands.DeletionVectorUtils$;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.internal.SQLConf;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

public final class Protocol$
implements scala.Serializable {
    public static Protocol$ MODULE$;
    private final String MIN_READER_VERSION_PROP;
    private final String MIN_WRITER_VERSION_PROP;

    static {
        new Protocol$();
    }

    public String MIN_READER_VERSION_PROP() {
        return this.MIN_READER_VERSION_PROP;
    }

    public String MIN_WRITER_VERSION_PROP() {
        return this.MIN_WRITER_VERSION_PROP;
    }

    public Protocol apply(int minReaderVersion, int minWriterVersion) {
        return new Protocol(minReaderVersion, minWriterVersion, (Option<Set<String>>)(TableFeatureProtocolUtils$.MODULE$.supportsReaderFeatures(minReaderVersion) ? new Some((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)) : None$.MODULE$), (Option<Set<String>>)(TableFeatureProtocolUtils$.MODULE$.supportsWriterFeatures(minWriterVersion) ? new Some((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)) : None$.MODULE$));
    }

    public int apply$default$1() {
        return Action$.MODULE$.readerVersion();
    }

    public int apply$default$2() {
        return Action$.MODULE$.writerVersion();
    }

    public Protocol forTableFeature(TableFeature tf) {
        Some writerFeatures = new Some((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tf.name()})));
        Some readerFeatures = tf.isReaderWriterFeature() ? writerFeatures : None$.MODULE$;
        int minReaderVersion = readerFeatures.isDefined() ? TableFeatureProtocolUtils$.MODULE$.TABLE_FEATURES_MIN_READER_VERSION() : 1;
        int minWriterVersion = TableFeatureProtocolUtils$.MODULE$.TABLE_FEATURES_MIN_WRITER_VERSION();
        return new Protocol(minReaderVersion, minWriterVersion, (Option<Set<String>>)readerFeatures, (Option<Set<String>>)writerFeatures);
    }

    public Protocol forNewTable(SparkSession spark, Option<Metadata> metadataOpt) {
        Option<Object> x$8;
        Seq<String> x$7;
        String x$6;
        Format x$52;
        String x$4;
        String x$3;
        Metadata metadata;
        SQLConf conf = spark.sessionState().conf();
        boolean ignoreProtocolDefaults = DeltaConfigs$.MODULE$.ignoreProtocolDefaultsIsSet(conf, (Map<String, String>)((Map)metadataOpt.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.configuration()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty())));
        Map defaultGlobalConf = ignoreProtocolDefaults ? (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.MIN_READER_VERSION_PROP()), (Object)Integer.toString(1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.MIN_WRITER_VERSION_PROP()), (Object)Integer.toString(1))})) : (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.MIN_READER_VERSION_PROP()), (Object)conf.getConf(DeltaSQLConf$.MODULE$.DELTA_PROTOCOL_DEFAULT_READER_VERSION()).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.MIN_WRITER_VERSION_PROP()), (Object)conf.getConf(DeltaSQLConf$.MODULE$.DELTA_PROTOCOL_DEFAULT_WRITER_VERSION()).toString())}));
        Map overrideGlobalConf = (Map)DeltaConfigs$.MODULE$.mergeGlobalConfigs(spark.sessionState().conf(), (Map<String, String>)Predef$.MODULE$.Map().empty(), (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)ignoreProtocolDefaults))).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Protocol$.$anonfun$forNewTable$3(x0$1)));
        Metadata qual$1 = metadata = (Metadata)metadataOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> new Metadata(Metadata$.MODULE$.apply$default$1(), Metadata$.MODULE$.apply$default$2(), Metadata$.MODULE$.apply$default$3(), Metadata$.MODULE$.apply$default$4(), Metadata$.MODULE$.apply$default$5(), Metadata$.MODULE$.apply$default$6(), Metadata$.MODULE$.apply$default$7(), Metadata$.MODULE$.apply$default$8()));
        Map x$1 = defaultGlobalConf.$plus$plus((GenTraversableOnce)overrideGlobalConf).$plus$plus(metadata.configuration());
        String x$2 = qual$1.copy$default$1();
        metadata = qual$1.copy(x$2, x$3 = qual$1.copy$default$2(), x$4 = qual$1.copy$default$3(), x$52 = qual$1.copy$default$4(), x$6 = qual$1.copy$default$5(), x$7 = qual$1.copy$default$6(), (Map<String, String>)x$1, x$8 = qual$1.copy$default$8());
        Tuple3<Object, Object, Set<TableFeature>> tuple3 = this.minProtocolComponentsFromMetadata(spark, metadata);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        int readerVersion = BoxesRunTime.unboxToInt((Object)tuple3._1());
        int writerVersion = BoxesRunTime.unboxToInt((Object)tuple3._2());
        Set enabledFeatures = (Set)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)readerVersion), (Object)BoxesRunTime.boxToInteger((int)writerVersion), (Object)enabledFeatures);
        Tuple3 tuple33 = tuple32;
        int readerVersion2 = BoxesRunTime.unboxToInt((Object)tuple33._1());
        int writerVersion2 = BoxesRunTime.unboxToInt((Object)tuple33._2());
        Set enabledFeatures2 = (Set)tuple33._3();
        return this.apply(readerVersion2, writerVersion2).withFeatures((Iterable<TableFeature>)enabledFeatures2);
    }

    private Set<TableFeature> getDependencyClosure(Set<TableFeature> features) {
        while (true) {
            Set requiredFeatures = (Set)features.$plus$plus((GenTraversableOnce)features.flatMap((Function1 & Serializable & scala.Serializable)x$7 -> x$7.requiredFeatures(), Set$.MODULE$.canBuildFrom()));
            Set set = features;
            Set set2 = requiredFeatures;
            if (set == null) {
                if (set2 == null) break;
            } else if (set.equals(set2)) break;
            features = requiredFeatures;
        }
        return features;
    }

    public Set<TableFeature> extractAutomaticallyEnabledFeatures(SparkSession spark, Metadata metadata, Option<Protocol> protocol) {
        Set protocolEnabledFeatures = (Set)((TraversableLike)protocol.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.writerFeatureNames()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty())).flatMap((Function1 & Serializable & scala.Serializable)featureName -> Option$.MODULE$.option2Iterable(TableFeature$.MODULE$.featureNameToFeature((String)featureName)), Set$.MODULE$.canBuildFrom());
        Set metadataEnabledFeatures = ((TraversableOnce)TableFeature$.MODULE$.allSupportedFeaturesMap().values().collect((PartialFunction)new scala.Serializable(metadata, spark){
            public static final long serialVersionUID = 0L;
            private final Metadata metadata$1;
            private final SparkSession spark$1;

            public final <A1 extends TableFeature, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1;
                A1 A12 = x1;
                Object object = A12 instanceof FeatureAutomaticallyEnabledByMetadata && ((FeatureAutomaticallyEnabledByMetadata)((Object)(A1 = A12))).metadataRequiresFeatureToBeEnabled(this.metadata$1, this.spark$1) ? A1 : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(TableFeature x1) {
                TableFeature tableFeature;
                TableFeature tableFeature2 = x1;
                boolean bl = tableFeature2 instanceof FeatureAutomaticallyEnabledByMetadata && ((FeatureAutomaticallyEnabledByMetadata)((Object)(tableFeature = tableFeature2))).metadataRequiresFeatureToBeEnabled(this.metadata$1, this.spark$1);
                return bl;
            }
            {
                this.metadata$1 = metadata$1;
                this.spark$1 = spark$1;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
        return this.getDependencyClosure((Set<TableFeature>)((Set)protocolEnabledFeatures.$plus$plus((GenTraversableOnce)metadataEnabledFeatures)));
    }

    public Option<Protocol> extractAutomaticallyEnabledFeatures$default$3() {
        return None$.MODULE$;
    }

    public Tuple3<Object, Object, Set<TableFeature>> minProtocolComponentsFromMetadata(SparkSession spark, Metadata metadata) {
        Tuple2.mcII.sp sp2;
        Map<String, String> tableConf = metadata.configuration();
        Set<TableFeature> tablePropEnabledFeatures = TableFeatureProtocolUtils$.MODULE$.getSupportedFeaturesFromTableConfigs(tableConf);
        Set<TableFeature> metaEnabledFeatures = this.extractAutomaticallyEnabledFeatures(spark, metadata, (Option<Protocol>)new Some((Object)this.apply(this.apply$default$1(), this.apply$default$2()).withFeatures((Iterable<TableFeature>)tablePropEnabledFeatures)));
        Set allEnabledFeatures = (Set)tablePropEnabledFeatures.$plus$plus(metaEnabledFeatures);
        Tuple2.mcII.sp sp3 = tablePropEnabledFeatures.exists((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.isReaderWriterFeature())) ? new Tuple2.mcII.sp(TableFeatureProtocolUtils$.MODULE$.TABLE_FEATURES_MIN_READER_VERSION(), TableFeatureProtocolUtils$.MODULE$.TABLE_FEATURES_MIN_WRITER_VERSION()) : (tablePropEnabledFeatures.nonEmpty() ? new Tuple2.mcII.sp(0, TableFeatureProtocolUtils$.MODULE$.TABLE_FEATURES_MIN_WRITER_VERSION()) : (metaEnabledFeatures.forall((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.isLegacyFeature())) ? new Tuple2.mcII.sp(0, 0) : (sp2 = metaEnabledFeatures.exists((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)Protocol$.$anonfun$minProtocolComponentsFromMetadata$3(f))) ? new Tuple2.mcII.sp(TableFeatureProtocolUtils$.MODULE$.TABLE_FEATURES_MIN_READER_VERSION(), TableFeatureProtocolUtils$.MODULE$.TABLE_FEATURES_MIN_WRITER_VERSION()) : new Tuple2.mcII.sp(0, TableFeatureProtocolUtils$.MODULE$.TABLE_FEATURES_MIN_WRITER_VERSION()))));
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        int readerVersionFromFeatures = sp2._1$mcI$sp();
        int writerVersionFromFeatures = sp2._2$mcI$sp();
        Tuple2.mcII.sp sp4 = new Tuple2.mcII.sp(readerVersionFromFeatures, writerVersionFromFeatures);
        Tuple2.mcII.sp sp5 = sp4;
        IntRef readerVersionFromFeatures2 = IntRef.create((int)sp5._1$mcI$sp());
        IntRef writerVersionFromFeatures2 = IntRef.create((int)sp5._2$mcI$sp());
        allEnabledFeatures.foreach((Function1 & Serializable & scala.Serializable)feature -> {
            Protocol$.$anonfun$minProtocolComponentsFromMetadata$4(readerVersionFromFeatures2, writerVersionFromFeatures2, feature);
            return BoxedUnit.UNIT;
        });
        Tuple2<Option<Object>, Option<Object>> tuple2 = this.getProtocolVersionsFromTableConf(tableConf);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option readerVersionFromTableConfOpt = (Option)tuple2._1();
        Option writerVersionFromTableConfOpt = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)readerVersionFromTableConfOpt, (Object)writerVersionFromTableConfOpt);
        Tuple2 tuple23 = tuple22;
        Option readerVersionFromTableConfOpt2 = (Option)tuple23._1();
        Option writerVersionFromTableConfOpt2 = (Option)tuple23._2();
        int finalReaderVersion = BoxesRunTime.unboxToInt((Object)((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, readerVersionFromFeatures2.elem, BoxesRunTime.unboxToInt((Object)readerVersionFromTableConfOpt2.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0))}))).max((Ordering)Ordering.Int$.MODULE$));
        int finalWriterVersion = BoxesRunTime.unboxToInt((Object)((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, writerVersionFromFeatures2.elem, BoxesRunTime.unboxToInt((Object)writerVersionFromTableConfOpt2.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0))}))).max((Ordering)Ordering.Int$.MODULE$));
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)finalReaderVersion), (Object)BoxesRunTime.boxToInteger((int)finalWriterVersion), (Object)allEnabledFeatures);
    }

    public Tuple3<Object, Object, Set<TableFeature>> minProtocolComponentsFromAutomaticallyEnabledFeatures(SparkSession spark, Metadata metadata) {
        Set<TableFeature> enabledFeatures = this.extractAutomaticallyEnabledFeatures(spark, metadata, this.extractAutomaticallyEnabledFeatures$default$3());
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(0, 0);
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        int readerVersion = sp2._1$mcI$sp();
        int writerVersion = sp2._2$mcI$sp();
        Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(readerVersion, writerVersion);
        Tuple2.mcII.sp sp4 = sp3;
        IntRef readerVersion2 = IntRef.create((int)sp4._1$mcI$sp());
        IntRef writerVersion2 = IntRef.create((int)sp4._2$mcI$sp());
        enabledFeatures.foreach((Function1 & Serializable & scala.Serializable)feature -> {
            Protocol$.$anonfun$minProtocolComponentsFromAutomaticallyEnabledFeatures$1(readerVersion2, writerVersion2, feature);
            return BoxedUnit.UNIT;
        });
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)readerVersion2.elem), (Object)BoxesRunTime.boxToInteger((int)writerVersion2.elem), enabledFeatures);
    }

    private int tryCastProtocolVersionToInt(String key, String value) {
        int n;
        try {
            n = new StringOps(Predef$.MODULE$.augmentString(value)).toInt();
        }
        catch (NumberFormatException numberFormatException) {
            throw DeltaErrors$.MODULE$.protocolPropNotIntException(key, value);
        }
        return n;
    }

    public Option<Object> getReaderVersionFromTableConf(Map<String, String> conf) {
        return conf.get((Object)this.MIN_READER_VERSION_PROP()).map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToInteger((int)Protocol$.MODULE$.tryCastProtocolVersionToInt(Protocol$.MODULE$.MIN_READER_VERSION_PROP(), x$14)));
    }

    public Option<Object> getWriterVersionFromTableConf(Map<String, String> conf) {
        return conf.get((Object)this.MIN_WRITER_VERSION_PROP()).map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToInteger((int)Protocol$.MODULE$.tryCastProtocolVersionToInt(Protocol$.MODULE$.MIN_WRITER_VERSION_PROP(), x$15)));
    }

    public Tuple2<Option<Object>, Option<Object>> getProtocolVersionsFromTableConf(Map<String, String> conf) {
        return new Tuple2(this.getReaderVersionFromTableConf(conf), this.getWriterVersionFromTableConf(conf));
    }

    private void assertMetadataContainsNoProtocolProps(Metadata metadata) {
        Predef$.MODULE$.assert(!metadata.configuration().contains((Object)this.MIN_READER_VERSION_PROP()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Should not have the ").append("protocol version (").append(MODULE$.MIN_READER_VERSION_PROP()).append(") as part of table properties").toString());
        Predef$.MODULE$.assert(!metadata.configuration().contains((Object)this.MIN_WRITER_VERSION_PROP()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Should not have the ").append("protocol version (").append(MODULE$.MIN_WRITER_VERSION_PROP()).append(") as part of table properties").toString());
        Predef$.MODULE$.assert(!metadata.configuration().keys().exists((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)x$16.startsWith(TableFeatureProtocolUtils$.MODULE$.FEATURE_PROP_PREFIX()))), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Should not have ").append("table features (starts with '").append(TableFeatureProtocolUtils$.MODULE$.FEATURE_PROP_PREFIX()).append("') as part of table properties").toString());
        Predef$.MODULE$.assert(!metadata.configuration().contains((Object)DeltaConfigs$.MODULE$.CREATE_TABLE_IGNORE_PROTOCOL_DEFAULTS().key()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Should not have the table property ").append(DeltaConfigs$.MODULE$.CREATE_TABLE_IGNORE_PROTOCOL_DEFAULTS().key()).append(" stored in table metadata").toString());
    }

    public Option<Protocol> upgradeProtocolFromMetadataForExistingTable(SparkSession spark, Metadata metadata, Protocol current) {
        None$ none$;
        this.assertMetadataContainsNoProtocolProps(metadata);
        Tuple3<Object, Object, Set<TableFeature>> tuple3 = this.minProtocolComponentsFromAutomaticallyEnabledFeatures(spark, metadata);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        int readerVersion = BoxesRunTime.unboxToInt((Object)tuple3._1());
        int writerVersion = BoxesRunTime.unboxToInt((Object)tuple3._2());
        Set minRequiredFeatures = (Set)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)readerVersion), (Object)BoxesRunTime.boxToInteger((int)writerVersion), (Object)minRequiredFeatures);
        Tuple3 tuple33 = tuple32;
        int readerVersion2 = BoxesRunTime.unboxToInt((Object)tuple33._1());
        int writerVersion2 = BoxesRunTime.unboxToInt((Object)tuple33._2());
        Set minRequiredFeatures2 = (Set)tuple33._3();
        Protocol required = this.apply(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(readerVersion2), current.minReaderVersion()), RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(writerVersion2), current.minWriterVersion())).withFeatures((Iterable<TableFeature>)minRequiredFeatures2);
        if (!required.canUpgradeTo(current)) {
            this.assertMetadataTableFeaturesAutomaticallySupported(current.implicitlyAndExplicitlySupportedFeatures(), required.implicitlyAndExplicitlySupportedFeatures());
            none$ = new Some((Object)required.merge((Seq<Protocol>)Predef$.MODULE$.wrapRefArray((Object[])new Protocol[]{current})));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private void assertMetadataTableFeaturesAutomaticallySupported(Set<TableFeature> currentFeatures, Set<TableFeature> requiredFeatures) {
        Tuple2 tuple2 = ((TraversableLike)requiredFeatures.diff(currentFeatures).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends TableFeature, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1;
                A1 A12 = x1;
                Object object = A12 instanceof FeatureAutomaticallyEnabledByMetadata ? (A1 = A12) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(TableFeature x1) {
                TableFeature tableFeature = x1;
                boolean bl = tableFeature instanceof FeatureAutomaticallyEnabledByMetadata;
                return bl;
            }
        }, Set$.MODULE$.canBuildFrom())).partition((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)Protocol$.$anonfun$assertMetadataTableFeaturesAutomaticallySupported$1(x$18)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Set autoUpdateCapableFeatures = (Set)tuple2._1();
        Set nonAutoUpdateCapableFeatures = (Set)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)autoUpdateCapableFeatures, (Object)nonAutoUpdateCapableFeatures);
        Tuple2 tuple23 = tuple22;
        Set autoUpdateCapableFeatures2 = (Set)tuple23._1();
        Set nonAutoUpdateCapableFeatures2 = (Set)tuple23._2();
        if (nonAutoUpdateCapableFeatures2.nonEmpty()) {
            throw DeltaErrors$.MODULE$.tableFeaturesRequireManualEnablementException((Iterable<TableFeature>)nonAutoUpdateCapableFeatures2, (Iterable<TableFeature>)currentFeatures.$plus$plus((GenTraversableOnce)autoUpdateCapableFeatures2));
        }
    }

    public void assertTablePropertyConstraintsSatisfied(SparkSession spark, Metadata metadata, Snapshot snapshot) {
        String lowerCaseKey;
        String tableName = metadata.name() != null ? metadata.name() : metadata.id();
        Map configs = (Map)metadata.configuration().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k.toLowerCase(Locale.ROOT)), (Object)v);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        boolean dvsEnabled = configs.get((Object)(lowerCaseKey = DeltaConfigs$.MODULE$.ENABLE_DELETION_VECTORS_CREATION().key().toLowerCase(Locale.ROOT))).exists((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)Protocol$.$anonfun$assertTablePropertyConstraintsSatisfied$2(x$20)));
        if (dvsEnabled) {
            String string = metadata.format().provider();
            String string2 = "parquet";
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw new DeltaTablePropertyValidationFailedException(tableName, DeltaTablePropertyValidationFailedSubClass$PersistentDeletionVectorsInNonParquetTable$.MODULE$);
            }
        }
        String lowerCaseKey2 = DeltaConfigs$.MODULE$.SYMLINK_FORMAT_MANIFEST_ENABLED().key().toLowerCase(Locale.ROOT);
        boolean manifestGenerationEnabled = configs.get((Object)lowerCaseKey2).exists((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)Protocol$.$anonfun$assertTablePropertyConstraintsSatisfied$3(x$21)));
        if (dvsEnabled && manifestGenerationEnabled) {
            throw new DeltaTablePropertyValidationFailedException(tableName, DeltaTablePropertyValidationFailedSubClass$PersistentDeletionVectorsWithIncrementalManifestGeneration$.MODULE$);
        }
        if (manifestGenerationEnabled && !DeletionVectorUtils$.MODULE$.isTableDVFree(spark, snapshot)) {
            throw new DeltaTablePropertyValidationFailedException(tableName, DeltaTablePropertyValidationFailedSubClass$ExistingDeletionVectorsWithIncrementalManifestGeneration$.MODULE$);
        }
    }

    public Protocol apply(int minReaderVersion, int minWriterVersion, Option<Set<String>> readerFeatures, Option<Set<String>> writerFeatures) {
        return new Protocol(minReaderVersion, minWriterVersion, readerFeatures, writerFeatures);
    }

    public Option<Tuple4<Object, Object, Option<Set<String>>, Option<Set<String>>>> unapply(Protocol x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)x$0.minReaderVersion()), (Object)BoxesRunTime.boxToInteger((int)x$0.minWriterVersion()), x$0.readerFeatures(), x$0.writerFeatures()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$forNewTable$3(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        boolean bl = TableFeatureProtocolUtils$.MODULE$.isTableProtocolProperty(k);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$minProtocolComponentsFromMetadata$3(TableFeature f) {
        return !f.isLegacyFeature() && f.isReaderWriterFeature();
    }

    public static final /* synthetic */ void $anonfun$minProtocolComponentsFromMetadata$4(IntRef readerVersionFromFeatures$1, IntRef writerVersionFromFeatures$1, TableFeature feature) {
        readerVersionFromFeatures$1.elem = package$.MODULE$.max(readerVersionFromFeatures$1.elem, feature.minReaderVersion());
        writerVersionFromFeatures$1.elem = package$.MODULE$.max(writerVersionFromFeatures$1.elem, feature.minWriterVersion());
    }

    public static final /* synthetic */ void $anonfun$minProtocolComponentsFromAutomaticallyEnabledFeatures$1(IntRef readerVersion$1, IntRef writerVersion$1, TableFeature feature) {
        readerVersion$1.elem = package$.MODULE$.max(readerVersion$1.elem, feature.minReaderVersion());
        writerVersion$1.elem = package$.MODULE$.max(writerVersion$1.elem, feature.minWriterVersion());
    }

    public static final /* synthetic */ boolean $anonfun$assertMetadataTableFeaturesAutomaticallySupported$1(TableFeature x$18) {
        return ((FeatureAutomaticallyEnabledByMetadata)((Object)x$18)).automaticallyUpdateProtocolOfExistingTables();
    }

    public static final /* synthetic */ boolean $anonfun$assertTablePropertyConstraintsSatisfied$2(String x$20) {
        return new StringOps(Predef$.MODULE$.augmentString(x$20)).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$assertTablePropertyConstraintsSatisfied$3(String x$21) {
        return new StringOps(Predef$.MODULE$.augmentString(x$21)).toBoolean();
    }

    private Protocol$() {
        MODULE$ = this;
        this.MIN_READER_VERSION_PROP = "delta.minReaderVersion";
        this.MIN_WRITER_VERSION_PROP = "delta.minWriterVersion";
    }
}

