/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands;

import java.io.Serializable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.OptimisticTransaction;
import org.apache.spark.sql.delta.commands.UpdateCommand;
import org.apache.spark.sql.delta.commands.cdc.CDCReader$;
import org.apache.spark.sql.delta.files.TahoeFileIndex;
import org.apache.spark.sql.functions$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.runtime.BoxesRunTime;

public final class UpdateCommand$
implements scala.Serializable {
    public static UpdateCommand$ MODULE$;
    private final String FILE_NAME_COLUMN;
    private final String CONDITION_COLUMN_NAME;
    private final String FINDING_TOUCHED_FILES_MSG;

    static {
        new UpdateCommand$();
    }

    public String FILE_NAME_COLUMN() {
        return this.FILE_NAME_COLUMN;
    }

    public String CONDITION_COLUMN_NAME() {
        return this.CONDITION_COLUMN_NAME;
    }

    public String FINDING_TOUCHED_FILES_MSG() {
        return this.FINDING_TOUCHED_FILES_MSG;
    }

    public String rewritingFilesMsg(long numFilesToRewrite) {
        return new StringBuilder(37).append("Rewriting ").append(numFilesToRewrite).append(" files for UPDATE operation").toString();
    }

    public boolean shouldOutputCdc(OptimisticTransaction txn) {
        return BoxesRunTime.unboxToBoolean((Object)DeltaConfigs$.MODULE$.CHANGE_DATA_FEED().fromMetaData(txn.metadata()));
    }

    public Dataset<Row> withUpdatedColumns(Seq<Attribute> originalExpressions, Seq<Expression> updateExpressions, Expression condition, Dataset<Row> dfWithEvaluatedCondition, boolean shouldOutputCdc) {
        Dataset dataset;
        if (shouldOutputCdc) {
            Seq namedUpdateCols = (Seq)((TraversableLike)updateExpressions.zip(originalExpressions, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Expression expr = (Expression)tuple2._1();
                Attribute targetCol = (Attribute)tuple2._2();
                Column column = new Column(expr).as(targetCol.name(), targetCol.metadata());
                return column;
            }, Seq$.MODULE$.canBuildFrom());
            Seq preimageCols = (Seq)((SeqLike)originalExpressions.map((Function1 & Serializable & scala.Serializable)x$11 -> new Column((Expression)x$11), Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)functions$.MODULE$.lit((Object)CDCReader$.MODULE$.CDC_TYPE_UPDATE_PREIMAGE()).as(CDCReader$.MODULE$.CDC_TYPE_COLUMN_NAME()), Seq$.MODULE$.canBuildFrom());
            Seq postimageCols = (Seq)namedUpdateCols.$colon$plus((Object)functions$.MODULE$.lit((Object)CDCReader$.MODULE$.CDC_TYPE_UPDATE_POSTIMAGE()).as(CDCReader$.MODULE$.CDC_TYPE_COLUMN_NAME()), Seq$.MODULE$.canBuildFrom());
            Column notCdcCol = new Column((Expression)CDCReader$.MODULE$.CDC_TYPE_NOT_CDC()).as(CDCReader$.MODULE$.CDC_TYPE_COLUMN_NAME());
            Seq updatedDataCols = (Seq)namedUpdateCols.$colon$plus((Object)notCdcCol, Seq$.MODULE$.canBuildFrom());
            Seq noopRewriteCols = (Seq)((SeqLike)originalExpressions.map((Function1 & Serializable & scala.Serializable)x$12 -> new Column((Expression)x$12), Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)notCdcCol, Seq$.MODULE$.canBuildFrom());
            Expression packedUpdates = functions$.MODULE$.array((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.struct(preimageCols), functions$.MODULE$.struct(postimageCols), functions$.MODULE$.struct(updatedDataCols)})).expr();
            Expression expression = condition;
            Literal literal = Literal$.MODULE$.TrueLiteral();
            Expression packedData = !(expression != null ? !expression.equals(literal) : literal != null) ? packedUpdates : new If((Expression)UnresolvedAttribute$.MODULE$.apply(this.CONDITION_COLUMN_NAME()), packedUpdates, functions$.MODULE$.array((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.struct(noopRewriteCols)})).expr());
            Seq finalColumns = (Seq)((TraversableLike)originalExpressions.$colon$plus((Object)UnresolvedAttribute$.MODULE$.apply(CDCReader$.MODULE$.CDC_TYPE_COLUMN_NAME()), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)a -> functions$.MODULE$.col(new StringBuilder(13).append("packedData.`").append(a.name()).append("`").toString()).as(a.name(), a.metadata()), Seq$.MODULE$.canBuildFrom());
            dataset = dfWithEvaluatedCondition.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.explode(new Column(packedData)).as("packedData")})).select(finalColumns);
        } else {
            Seq finalCols = (Seq)((TraversableLike)updateExpressions.zip(originalExpressions, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Expression update = (Expression)tuple2._1();
                Attribute original = (Attribute)tuple2._2();
                Expression expression = condition;
                Literal literal = Literal$.MODULE$.TrueLiteral();
                Expression updated = !(expression != null ? !expression.equals(literal) : literal != null) ? update : new If((Expression)UnresolvedAttribute$.MODULE$.apply(MODULE$.CONDITION_COLUMN_NAME()), update, (Expression)original);
                Column column = new Column(updated).as(original.name(), original.metadata());
                return column;
            }, Seq$.MODULE$.canBuildFrom());
            dataset = dfWithEvaluatedCondition.select(finalCols);
        }
        Dataset resultDf = dataset;
        return resultDf.drop(this.CONDITION_COLUMN_NAME());
    }

    public UpdateCommand apply(TahoeFileIndex tahoeFileIndex, LogicalPlan target, Seq<Expression> updateExpressions, Option<Expression> condition) {
        return new UpdateCommand(tahoeFileIndex, target, updateExpressions, condition);
    }

    public Option<Tuple4<TahoeFileIndex, LogicalPlan, Seq<Expression>, Option<Expression>>> unapply(UpdateCommand x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple4((Object)x$0.tahoeFileIndex(), (Object)x$0.target(), x$0.updateExpressions(), x$0.condition()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private UpdateCommand$() {
        MODULE$ = this;
        this.FILE_NAME_COLUMN = "_input_file_name_";
        this.CONDITION_COLUMN_NAME = "__condition__";
        this.FINDING_TOUCHED_FILES_MSG = "Finding files to rewrite for UPDATE operation";
    }
}

