/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands;

import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaOperations;
import org.apache.spark.sql.delta.OptimisticTransaction;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.DeletionVectorDescriptor;
import org.apache.spark.sql.delta.actions.FileAction;
import org.apache.spark.sql.delta.actions.RemoveFile;
import org.apache.spark.sql.delta.commands.DeltaCommand;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.storage.LogStore;
import org.apache.spark.sql.delta.util.DeltaFileOperations$;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.metric.SQLMetrics$;
import org.apache.spark.util.SerializableConfiguration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ega\u0002\t\u0012!\u0003\r\tA\b\u0005\u0006S\u0001!\tA\u000b\u0005\b]\u0001\u0011\r\u0011\"\u00030\u0011\u0015q\u0004\u0001\"\u0003@\u0011\u0015\u0001\u0007\u0001\"\u0005b\u0011\u001d\t\t\u0001\u0001C\t\u0003\u0007A\u0011\"a\u0005\u0001#\u0003%\t\"!\u0006\t\u0013\u0005-\u0002!%A\u0005\u0012\u0005U\u0001bBA\u0017\u0001\u0011E\u0011q\u0006\u0005\b\u0003\u0007\u0002A\u0011CA#\u0011\u001d\t\u0019\u0007\u0001C\t\u0003KBq!a&\u0001\t#\tI\nC\u0004\u0002\u001e\u0002!\t\"a(\t\u000f\u0005\r\u0006\u0001\"\u0005\u0002&\"9\u0011\u0011\u0019\u0001\u0005\u0012\u0005\r\u0007bBAi\u0001\u0011E\u00111\u001b\u0002\u0012-\u0006\u001cW/^7D_6l\u0017M\u001c3J[Bd'B\u0001\n\u0014\u0003!\u0019w.\\7b]\u0012\u001c(B\u0001\u000b\u0016\u0003\u0015!W\r\u001c;b\u0015\t1r#A\u0002tc2T!\u0001G\r\u0002\u000bM\u0004\u0018M]6\u000b\u0005iY\u0012AB1qC\u000eDWMC\u0001\u001d\u0003\ry'oZ\u0002\u0001'\r\u0001q$\n\t\u0003A\rj\u0011!\t\u0006\u0002E\u0005)1oY1mC&\u0011A%\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0019:S\"A\t\n\u0005!\n\"\u0001\u0004#fYR\f7i\\7nC:$\u0017A\u0002\u0013j]&$H\u0005F\u0001,!\t\u0001C&\u0003\u0002.C\t!QK\\5u\u0003U\u0019X\u000f\u001d9peR,GMR:G_JdunZ4j]\u001e,\u0012\u0001\r\t\u0004cQ2T\"\u0001\u001a\u000b\u0005M\n\u0013AC2pY2,7\r^5p]&\u0011QG\r\u0002\u0004'\u0016\f\bCA\u001c=\u001b\u0005A$BA\u001d;\u0003\u0011a\u0017M\\4\u000b\u0003m\nAA[1wC&\u0011Q\b\u000f\u0002\u0007'R\u0014\u0018N\\4\u0002\u001fMDw.\u001e7e\u0019><g+Y2vk6$R\u0001Q\"I\u001db\u0003\"\u0001I!\n\u0005\t\u000b#a\u0002\"p_2,\u0017M\u001c\u0005\u00061\r\u0001\r\u0001\u0012\t\u0003\u000b\u001ak\u0011!F\u0005\u0003\u000fV\u0011Ab\u00159be.\u001cVm]:j_:DQ!S\u0002A\u0002)\u000b\u0001\u0002Z3mi\u0006dun\u001a\t\u0003\u00172k\u0011aE\u0005\u0003\u001bN\u0011\u0001\u0002R3mi\u0006dun\u001a\u0005\u0006\u001f\u000e\u0001\r\u0001U\u0001\u000bQ\u0006$wn\u001c9D_:4\u0007CA)W\u001b\u0005\u0011&BA*U\u0003\u0011\u0019wN\u001c4\u000b\u0005UK\u0012A\u00025bI>|\u0007/\u0003\u0002X%\ni1i\u001c8gS\u001e,(/\u0019;j_:DQ!W\u0002A\u0002i\u000bA\u0001]1uQB\u00111LX\u0007\u00029*\u0011Q\fV\u0001\u0003MNL!a\u0018/\u0003\tA\u000bG\u000f[\u0001\u000fY><g+Y2vk6\u001cF/\u0019:u)!Y#m\u00193fift\b\"\u0002\r\u0005\u0001\u0004!\u0005\"B%\u0005\u0001\u0004Q\u0005\"B-\u0005\u0001\u0004Q\u0006\"\u00024\u0005\u0001\u00049\u0017\u0001\u00023jM\u001a\u00042!\u00125k\u0013\tIWCA\u0004ECR\f7/\u001a;\u0011\u0005-\u0014hB\u00017q!\ti\u0017%D\u0001o\u0015\tyW$\u0001\u0004=e>|GOP\u0005\u0003c\u0006\na\u0001\u0015:fI\u00164\u0017BA\u001ft\u0015\t\t\u0018\u0005C\u0003v\t\u0001\u0007a/\u0001\ntSj,wJ\u001a#bi\u0006$v\u000eR3mKR,\u0007C\u0001\u0011x\u0013\tA\u0018E\u0001\u0003M_:<\u0007\"\u0002>\u0005\u0001\u0004Y\u0018\u0001G:qK\u000eLg-[3e%\u0016$XM\u001c;j_:l\u0015\u000e\u001c7jgB\u0019\u0001\u0005 <\n\u0005u\f#AB(qi&|g\u000eC\u0003\u0000\t\u0001\u0007a/\u0001\feK\u001a\fW\u000f\u001c;SKR,g\u000e^5p]6KG\u000e\\5t\u00031awn\u001a,bGV,X.\u00128e)-Y\u0013QAA\u0004\u0003\u0013\tY!a\u0004\t\u000b%+\u0001\u0019\u0001&\t\u000ba)\u0001\u0019\u0001#\t\u000be+\u0001\u0019\u0001.\t\u0011\u00055Q\u0001%AA\u0002m\fABZ5mKN$U\r\\3uK\u0012D\u0001\"!\u0005\u0006!\u0003\u0005\ra_\u0001\nI&\u00148i\\;oiN\fa\u0003\\8h-\u0006\u001cW/^7F]\u0012$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003/Q3a_A\rW\t\tY\u0002\u0005\u0003\u0002\u001e\u0005\u001dRBAA\u0010\u0015\u0011\t\t#a\t\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0013C\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005%\u0012q\u0004\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017A\u00067pOZ\u000b7-^;n\u000b:$G\u0005Z3gCVdG\u000fJ\u001b\u0002\u0015I,G.\u0019;jm&TX\rF\u0005k\u0003c\t\u0019$a\u000f\u0002@!)\u0011\f\u0003a\u00015\"1Q\f\u0003a\u0001\u0003k\u00012aWA\u001c\u0013\r\tI\u0004\u0018\u0002\u000b\r&dWmU=ti\u0016l\u0007BBA\u001f\u0011\u0001\u0007!,A\u0007sKN,'O^8je\n\u000b7/\u001a\u0005\u0007\u0003\u0003B\u0001\u0019\u0001!\u0002\u000b%\u001cH)\u001b:\u0002\u001b\u001d,G/\u00117m'V\u0014G-\u001b:t)!\t9%!\u0017\u0002^\u0005\u0005\u0004#BA%\u0003'Rg\u0002BA&\u0003\u001fr1!\\A'\u0013\u0005\u0011\u0013bAA)C\u00059\u0001/Y2lC\u001e,\u0017\u0002BA+\u0003/\u0012\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0004\u0003#\n\u0003BBA.\u0013\u0001\u0007!.\u0001\u0003cCN,\u0007BBA0\u0013\u0001\u0007!.\u0001\u0003gS2,\u0007BB/\n\u0001\u0004\t)$\u0001\u0004eK2,G/\u001a\u000b\u000em\u0006\u001d\u0014\u0011NA6\u0003_\nI)!$\t\u000b\u0019T\u0001\u0019A4\t\u000baQ\u0001\u0019\u0001#\t\r\u00055$\u00021\u0001k\u0003!\u0011\u0017m]3QCRD\u0007BB(\u000b\u0001\u0004\t\t\b\u0005\u0004\u0002t\u0005e\u0014QP\u0007\u0003\u0003kR1!a\u001e\u0018\u0003%\u0011'o\\1eG\u0006\u001cH/\u0003\u0003\u0002|\u0005U$!\u0003\"s_\u0006$7-Y:u!\u0011\ty(!\"\u000e\u0005\u0005\u0005%bAAB/\u0005!Q\u000f^5m\u0013\u0011\t9)!!\u00033M+'/[1mSj\f'\r\\3D_:4\u0017nZ;sCRLwN\u001c\u0005\u0007\u0003\u0017S\u0001\u0019\u0001!\u0002\u0011A\f'/\u00197mK2Dq!a$\u000b\u0001\u0004\t\t*\u0001\nqCJ\fG\u000e\\3m!\u0006\u0014H/\u001b;j_:\u001c\bc\u0001\u0011\u0002\u0014&\u0019\u0011QS\u0011\u0003\u0007%sG/\u0001\u0007tiJLgn\u001a+p!\u0006$\b\u000eF\u0002[\u00037CQ!W\u0006A\u0002)\fA\u0002]1uQR{7\u000b\u001e:j]\u001e$2A[AQ\u0011\u0015IF\u00021\u0001[\u0003U9W\r^!di&|gNU3mCRLg/\u001a)bi\"$\"\"a*\u0002*\u0006e\u00161XA_!\r\u0001CP\u001b\u0005\b\u0003Wk\u0001\u0019AAW\u0003\u0019\t7\r^5p]B!\u0011qVA[\u001b\t\t\tLC\u0002\u00024N\tq!Y2uS>t7/\u0003\u0003\u00028\u0006E&A\u0003$jY\u0016\f5\r^5p]\"1Q,\u0004a\u0001\u0003kAa!!\u001c\u000e\u0001\u0004Q\u0006BBA`\u001b\u0001\u0007\u0001)A\u000bsK2\fG/\u001b<ju\u0016LuM\\8sK\u0016\u0013(o\u001c:\u0002?\u001d,GOV1mS\u0012\u0014V\r\\1uSZ,\u0007+\u0019;ig\u0006sGmU;cI&\u00148\u000f\u0006\u0006\u0002F\u0006%\u00171ZAg\u0003\u001f\u0004R!!\u0013\u0002H*L1!NA,\u0011\u001d\tYK\u0004a\u0001\u0003[Ca!\u0018\bA\u0002\u0005U\u0002BBA7\u001d\u0001\u0007!\f\u0003\u0004\u0002@:\u0001\r\u0001Q\u0001\u001eO\u0016$H)\u001a7fi&|gNV3di>\u0014(+\u001a7bi&4X\rU1uQR!\u0011Q[Al!\r\u0001CP\u0017\u0005\b\u0003W{\u0001\u0019AAW\u0001")
public interface VacuumCommandImpl
extends DeltaCommand {
    public void org$apache$spark$sql$delta$commands$VacuumCommandImpl$_setter_$org$apache$spark$sql$delta$commands$VacuumCommandImpl$$supportedFsForLogging_$eq(Seq<String> var1);

    public Seq<String> org$apache$spark$sql$delta$commands$VacuumCommandImpl$$supportedFsForLogging();

    private boolean shouldLogVacuum(SparkSession spark, DeltaLog deltaLog, Configuration hadoopConf, Path path) {
        boolean bl;
        Option logVacuumConf = spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_VACUUM_LOGGING_ENABLED());
        if (logVacuumConf.nonEmpty()) {
            return BoxesRunTime.unboxToBoolean((Object)logVacuumConf.get());
        }
        LogStore logStore = deltaLog.store();
        try {
            URI rawResolvedUri = logStore.resolvePathOnPhysicalStorage(path, hadoopConf).toUri();
            String scheme = rawResolvedUri.getScheme();
            bl = this.org$apache$spark$sql$delta$commands$VacuumCommandImpl$$supportedFsForLogging().contains((Object)scheme);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.logWarning((Function0 & Serializable & scala.Serializable)() -> "Vacuum event logging not enabled on this file system because we cannot detect your cloud storage type.");
            bl = false;
        }
        return bl;
    }

    public static /* synthetic */ void logVacuumStart$(VacuumCommandImpl $this, SparkSession spark, DeltaLog deltaLog, Path path, Dataset diff, long sizeOfDataToDelete, Option specifiedRetentionMillis, long defaultRetentionMillis) {
        $this.logVacuumStart(spark, deltaLog, path, (Dataset<String>)diff, sizeOfDataToDelete, (Option<Object>)specifiedRetentionMillis, defaultRetentionMillis);
    }

    default public void logVacuumStart(SparkSession spark, DeltaLog deltaLog, Path path, Dataset<String> diff, long sizeOfDataToDelete, Option<Object> specifiedRetentionMillis, long defaultRetentionMillis) {
        block0: {
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(99).append("Deleting untracked files and empty directories in ").append(path).append(". The amount of data to be ").append("deleted is ").append(sizeOfDataToDelete).append(" (in bytes)").toString());
            if (!this.shouldLogVacuum(spark, deltaLog, deltaLog.newDeltaHadoopConf(), path)) break block0;
            boolean checkEnabled = BoxesRunTime.unboxToBoolean((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_VACUUM_RETENTION_CHECK_ENABLED()));
            OptimisticTransaction txn = deltaLog.startTransaction();
            Map metrics = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numFilesToDelete"), (Object)SQLMetrics$.MODULE$.createMetric(spark.sparkContext(), "number of files to deleted")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sizeOfDataToDelete"), (Object)SQLMetrics$.MODULE$.createMetric(spark.sparkContext(), "The total amount of data to be deleted in bytes"))}));
            ((SQLMetric)metrics.apply((Object)"numFilesToDelete")).set(diff.count());
            ((SQLMetric)metrics.apply((Object)"sizeOfDataToDelete")).set(sizeOfDataToDelete);
            txn.registerSQLMetrics(spark, (Map<String, SQLMetric>)metrics);
            txn.commit((Seq<Action>)((Seq)Nil$.MODULE$), new DeltaOperations.VacuumStart(checkEnabled, specifiedRetentionMillis, defaultRetentionMillis));
        }
    }

    public static /* synthetic */ void logVacuumEnd$(VacuumCommandImpl $this, DeltaLog deltaLog, SparkSession spark, Path path, Option filesDeleted, Option dirCounts) {
        $this.logVacuumEnd(deltaLog, spark, path, (Option<Object>)filesDeleted, (Option<Object>)dirCounts);
    }

    default public void logVacuumEnd(DeltaLog deltaLog, SparkSession spark, Path path, Option<Object> filesDeleted, Option<Object> dirCounts) {
        block3: {
            Object object;
            if (this.shouldLogVacuum(spark, deltaLog, deltaLog.newDeltaHadoopConf(), path)) {
                String status;
                OptimisticTransaction txn = deltaLog.startTransaction();
                String string = status = filesDeleted.isEmpty() && dirCounts.isEmpty() ? "FAILED" : "COMPLETED";
                if (filesDeleted.nonEmpty() && dirCounts.nonEmpty()) {
                    Map metrics = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numDeletedFiles"), (Object)SQLMetrics$.MODULE$.createMetric(spark.sparkContext(), "number of files deleted.")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numVacuumedDirectories"), (Object)SQLMetrics$.MODULE$.createMetric(spark.sparkContext(), "num of directories vacuumed.")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"status"), (Object)SQLMetrics$.MODULE$.createMetric(spark.sparkContext(), "status of vacuum"))}));
                    ((SQLMetric)metrics.apply((Object)"numDeletedFiles")).set(BoxesRunTime.unboxToLong((Object)filesDeleted.get()));
                    ((SQLMetric)metrics.apply((Object)"numVacuumedDirectories")).set(BoxesRunTime.unboxToLong((Object)dirCounts.get()));
                    txn.registerSQLMetrics(spark, (Map<String, SQLMetric>)metrics);
                }
                object = BoxesRunTime.boxToLong((long)txn.commit((Seq<Action>)((Seq)Nil$.MODULE$), new DeltaOperations.VacuumEnd(status)));
            } else {
                object = BoxedUnit.UNIT;
            }
            if (!filesDeleted.nonEmpty()) break block3;
            this.logConsole(new StringBuilder(58).append("Deleted ").append(filesDeleted.get()).append(" files and directories in a total ").append("of ").append(dirCounts.get()).append(" directories.").toString());
        }
    }

    public static /* synthetic */ Option logVacuumEnd$default$4$(VacuumCommandImpl $this) {
        return $this.logVacuumEnd$default$4();
    }

    default public Option<Object> logVacuumEnd$default$4() {
        return None$.MODULE$;
    }

    public static /* synthetic */ Option logVacuumEnd$default$5$(VacuumCommandImpl $this) {
        return $this.logVacuumEnd$default$5();
    }

    default public Option<Object> logVacuumEnd$default$5() {
        return None$.MODULE$;
    }

    public static /* synthetic */ String relativize$(VacuumCommandImpl $this, Path path, FileSystem fs, Path reservoirBase, boolean isDir) {
        return $this.relativize(path, fs, reservoirBase, isDir);
    }

    default public String relativize(Path path, FileSystem fs, Path reservoirBase, boolean isDir) {
        return this.pathToString(DeltaFileOperations$.MODULE$.tryRelativizePath(fs, reservoirBase, path, DeltaFileOperations$.MODULE$.tryRelativizePath$default$4()));
    }

    public static /* synthetic */ Iterator getAllSubdirs$(VacuumCommandImpl $this, String base, String file, FileSystem fs) {
        return $this.getAllSubdirs(base, file, fs);
    }

    default public Iterator<String> getAllSubdirs(String base, String file, FileSystem fs) {
        return (Iterator)DeltaFileOperations$.MODULE$.getAllSubDirectories(base, file)._1();
    }

    public static /* synthetic */ long delete$(VacuumCommandImpl $this, Dataset diff, SparkSession spark, String basePath, Broadcast hadoopConf, boolean parallel, int parallelPartitions) {
        return $this.delete((Dataset<String>)diff, spark, basePath, (Broadcast<SerializableConfiguration>)hadoopConf, parallel, parallelPartitions);
    }

    default public long delete(Dataset<String> diff, SparkSession spark, String basePath, Broadcast<SerializableConfiguration> hadoopConf, boolean parallel, int parallelPartitions) {
        long l;
        if (parallel) {
            l = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])diff.repartition(parallelPartitions).mapPartitions((Function1 & Serializable & scala.Serializable)files -> {
                FileSystem fs = new Path(basePath).getFileSystem(((SerializableConfiguration)hadoopConf.value()).value());
                int filesDeletedPerPartition = files.map((Function1 & Serializable & scala.Serializable)p -> this.stringToPath((String)p)).count((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)DeltaFileOperations$.MODULE$.tryDeleteNonRecursive(fs, f, DeltaFileOperations$.MODULE$.tryDeleteNonRecursive$default$3())));
                return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{filesDeletedPerPartition}));
            }, org.apache.spark.sql.delta.implicits.package$.MODULE$.intEncoder()).collect())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        } else {
            FileSystem fs = new Path(basePath).getFileSystem(((SerializableConfiguration)hadoopConf.value()).value());
            Iterator fileResultSet = (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(diff.toLocalIterator()).asScala();
            l = fileResultSet.map((Function1 & Serializable & scala.Serializable)p -> this.stringToPath((String)p)).count((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)DeltaFileOperations$.MODULE$.tryDeleteNonRecursive(fs, f, DeltaFileOperations$.MODULE$.tryDeleteNonRecursive$default$3())));
        }
        return l;
    }

    public static /* synthetic */ Path stringToPath$(VacuumCommandImpl $this, String path) {
        return $this.stringToPath(path);
    }

    default public Path stringToPath(String path) {
        return new Path(new URI(path));
    }

    public static /* synthetic */ String pathToString$(VacuumCommandImpl $this, Path path) {
        return $this.pathToString(path);
    }

    default public String pathToString(Path path) {
        return path.toUri().toString();
    }

    public static /* synthetic */ Option getActionRelativePath$(VacuumCommandImpl $this, FileAction action, FileSystem fs, Path basePath, boolean relativizeIgnoreError) {
        return $this.getActionRelativePath(action, fs, basePath, relativizeIgnoreError);
    }

    default public Option<String> getActionRelativePath(FileAction action, FileSystem fs, Path basePath, boolean relativizeIgnoreError) {
        Path maybeRelative;
        Path filePath = this.stringToPath(action.path());
        return filePath.isAbsolute() ? ((maybeRelative = DeltaFileOperations$.MODULE$.tryRelativizePath(fs, basePath, filePath, relativizeIgnoreError)).isAbsolute() ? None$.MODULE$ : new Some((Object)this.pathToString(maybeRelative))) : new Some((Object)this.pathToString(filePath));
    }

    public static /* synthetic */ Seq getValidRelativePathsAndSubdirs$(VacuumCommandImpl $this, FileAction action, FileSystem fs, Path basePath, boolean relativizeIgnoreError) {
        return $this.getValidRelativePathsAndSubdirs(action, fs, basePath, relativizeIgnoreError);
    }

    default public Seq<String> getValidRelativePathsAndSubdirs(FileAction action, FileSystem fs, Path basePath, boolean relativizeIgnoreError) {
        Seq paths = (Seq)this.getActionRelativePath(action, fs, basePath, relativizeIgnoreError).map((Function1 & Serializable & scala.Serializable)relativePath -> (Seq)((TraversableLike)new .colon.colon(relativePath, (List)Nil$.MODULE$)).$plus$plus(this.getAllSubdirs("/", (String)relativePath, fs), Seq$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
        Option deletionVectorPath = this.getDeletionVectorRelativePath(action).map((Function1 & Serializable & scala.Serializable)path -> this.pathToString((Path)path));
        return (Seq)paths.$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(deletionVectorPath).toSeq(), Seq$.MODULE$.canBuildFrom());
    }

    public static /* synthetic */ Option getDeletionVectorRelativePath$(VacuumCommandImpl $this, FileAction action) {
        return $this.getDeletionVectorRelativePath(action);
    }

    default public Option<Path> getDeletionVectorRelativePath(FileAction action) {
        None$ none$;
        Some some;
        DeletionVectorDescriptor dv;
        RemoveFile removeFile;
        AddFile addFile;
        FileAction fileAction = action;
        Object object = fileAction instanceof AddFile && (addFile = (AddFile)fileAction).deletionVector() != null ? new Some((Object)addFile.deletionVector()) : (fileAction instanceof RemoveFile && (removeFile = (RemoveFile)fileAction).deletionVector() != null ? new Some((Object)removeFile.deletionVector()) : None$.MODULE$);
        None$ dv2 = object;
        None$ none$2 = dv2;
        if (none$2 instanceof Some && (dv = (DeletionVectorDescriptor)(some = (Some)none$2).value()).isOnDisk()) {
            Some some2;
            if (dv.isRelative()) {
                some2 = new Some((Object)dv.absolutePath(new Path(".")));
            } else {
                Predef$.MODULE$.assert(dv.isAbsolute());
                some2 = None$.MODULE$;
            }
            none$ = some2;
        } else if (None$.MODULE$.equals(none$2)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError((Object)none$2);
        }
        return none$;
    }

    public static void $init$(VacuumCommandImpl $this) {
        $this.org$apache$spark$sql$delta$commands$VacuumCommandImpl$_setter_$org$apache$spark$sql$delta$commands$VacuumCommandImpl$$supportedFsForLogging_$eq((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"wasbs", "wasbss", "abfs", "abfss", "adl", "gs", "file", "hdfs"}))));
    }
}

