/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands.cdc;

import java.io.Serializable;
import java.sql.Timestamp;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.delta.BatchCDFSchemaLegacy$;
import org.apache.spark.sql.delta.ChangeDataFeedTableFeature$;
import org.apache.spark.sql.delta.DeltaBatchCDFSchemaMode;
import org.apache.spark.sql.delta.DeltaBatchCDFSchemaMode$;
import org.apache.spark.sql.delta.DeltaColumnMapping$;
import org.apache.spark.sql.delta.DeltaColumnMappingMode;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaHistoryManager;
import org.apache.spark.sql.delta.DeltaHistoryManager$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaOperations$;
import org.apache.spark.sql.delta.DeltaParquetFileFormat;
import org.apache.spark.sql.delta.DeltaParquetFileFormat$;
import org.apache.spark.sql.delta.DeltaTableUtils$;
import org.apache.spark.sql.delta.DeltaTimeTravelSpec;
import org.apache.spark.sql.delta.NoMapping$;
import org.apache.spark.sql.delta.RowIndexFilterType;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.SnapshotDescriptor;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.AddCDCFile;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.CommitInfo;
import org.apache.spark.sql.delta.actions.DeletionVectorDescriptor;
import org.apache.spark.sql.delta.actions.DeletionVectorDescriptor$;
import org.apache.spark.sql.delta.actions.FileAction;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.RemoveFile;
import org.apache.spark.sql.delta.commands.cdc.CDCReader;
import org.apache.spark.sql.delta.commands.cdc.CDCReader$;
import org.apache.spark.sql.delta.commands.cdc.CDCReaderImpl$CDCVersionDiffInfo$;
import org.apache.spark.sql.delta.commands.cdc.CDCReaderImpl$ResolvedCDFVersion$;
import org.apache.spark.sql.delta.deletionvectors.RoaringBitmapArray;
import org.apache.spark.sql.delta.deletionvectors.RoaringBitmapArrayFormat$;
import org.apache.spark.sql.delta.files.CdcAddFileIndex;
import org.apache.spark.sql.delta.files.CdcAddFileIndex$;
import org.apache.spark.sql.delta.files.TahoeChangeFileIndex;
import org.apache.spark.sql.delta.files.TahoeFileIndexWithSnapshotDescriptor;
import org.apache.spark.sql.delta.files.TahoeRemoveFileIndex;
import org.apache.spark.sql.delta.files.TahoeRemoveFileIndex$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.schema.SchemaUtils$;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.sources.DeltaSource$;
import org.apache.spark.sql.delta.storage.dv.DeletionVectorStore;
import org.apache.spark.sql.delta.storage.dv.DeletionVectorStore$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.sql.util.ScalaExtensions$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.BufferLike;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0011\u0015caB%K!\u0003\r\t!\u0017\u0005\u0006M\u0002!\ta\u001a\u0005\u0006W\u0002!I\u0001\u001c\u0005\b\u0003[\u0004A\u0011AAx\u0011\u001d\u0011\u0019\u0001\u0001C\u0001\u0005\u000bAqA!\t\u0001\t\u0003\u0011\u0019\u0003C\u0004\u00036\u0001!\tAa\u000e\t\u0013\t5\u0007!%A\u0005\u0002\t=\u0007\"\u0003Bj\u0001E\u0005I\u0011\u0001Bh\u0011\u001d\u0011)\u000e\u0001C\t\u0005/Dqaa\u0006\u0001\t\u0003\u0019I\u0002C\u0004\u0004@\u0001!\ta!\u0011\t\u000f\r5\u0003\u0001\"\u0001\u0004P!I1q\f\u0001\u0012\u0002\u0013\u00051\u0011\r\u0005\n\u0007K\u0002\u0011\u0013!C\u0001\u0005\u001fDqaa\u001a\u0001\t#\u0019I\u0007C\u0005\u0004\u0000\u0001\t\n\u0011\"\u0005\u0003P\"91\u0011\u0011\u0001\u0005\u0002\r\r\u0005bBBK\u0001\u0011\u00051q\u0013\u0005\b\u00077\u0003A\u0011ABO\u0011\u001d\u0019Y\u000b\u0001C\u0005\u0007[Cqa!6\u0001\t\u0013\u00199\u000eC\u0004\u0004d\u0002!Ia!:\u0007\r\tm\u0002\u0001\u0011B\u001f\u0011)\u0011yd\u0006BK\u0002\u0013\u0005!\u0011\t\u0005\u000b\u0005C:\"\u0011#Q\u0001\n\t\r\u0003\"\u0003B2/\tU\r\u0011\"\u0001|\u0011%\u0011)g\u0006B\tB\u0003%A\u0010C\u0005\u0003h]\u0011)\u001a!C\u0001w\"I!\u0011N\f\u0003\u0012\u0003\u0006I\u0001 \u0005\b\u0003/9B\u0011\u0001B6\u0011%\tIcFA\u0001\n\u0003\u0011\u0019\bC\u0005\u00022]\t\n\u0011\"\u0001\u0003|!I\u0011\u0011J\f\u0012\u0002\u0013\u0005\u00111\u0007\u0005\n\u0005\u007f:\u0012\u0013!C\u0001\u0003gA\u0011\"a\u0014\u0018\u0003\u0003%\t%!\u0015\t\u0013\u0005}s#!A\u0005\u0002\u0005\u0005\u0004\"CA5/\u0005\u0005I\u0011\u0001BA\u0011%\t9hFA\u0001\n\u0003\nI\bC\u0005\u0002\b^\t\t\u0011\"\u0001\u0003\u0006\"I\u0011QR\f\u0002\u0002\u0013\u0005\u0013q\u0012\u0005\n\u0003#;\u0012\u0011!C!\u0003'C\u0011\"!&\u0018\u0003\u0003%\tE!#\b\u0013\rm\b!!A\t\u0002\ruh!\u0003B\u001e\u0001\u0005\u0005\t\u0012AB\u0000\u0011\u001d\t9\u0002\fC\u0001\t\u001bA\u0011\"!%-\u0003\u0003%)%a%\t\u0013\u0011=A&!A\u0005\u0002\u0012E\u0001\"\u0003C\rY\u0005\u0005I\u0011\u0011C\u000e\r\u0011\u0011\b\u0001R:\t\u0011i\f$Q3A\u0005\u0002mD\u0001b`\u0019\u0003\u0012\u0003\u0006I\u0001 \u0005\u000b\u0003\u0003\t$Q3A\u0005\u0002\u0005\r\u0001BCA\u000bc\tE\t\u0015!\u0003\u0002\u0006!9\u0011qC\u0019\u0005\u0002\u0005e\u0001bBA\u0010c\u0011\u0005\u0011\u0011\u0005\u0005\n\u0003S\t\u0014\u0011!C\u0001\u0003WA\u0011\"!\r2#\u0003%\t!a\r\t\u0013\u0005%\u0013'%A\u0005\u0002\u0005-\u0003\"CA(c\u0005\u0005I\u0011IA)\u0011%\ty&MA\u0001\n\u0003\t\t\u0007C\u0005\u0002jE\n\t\u0011\"\u0001\u0002l!I\u0011qO\u0019\u0002\u0002\u0013\u0005\u0013\u0011\u0010\u0005\n\u0003\u000f\u000b\u0014\u0011!C\u0001\u0003\u0013C\u0011\"!$2\u0003\u0003%\t%a$\t\u0013\u0005E\u0015'!A\u0005B\u0005M\u0005\"CAKc\u0005\u0005I\u0011IAL\u000f%!I\u0003AA\u0001\u0012\u0013!YC\u0002\u0005s\u0001\u0005\u0005\t\u0012\u0002C\u0017\u0011\u001d\t9\u0002\u0012C\u0001\tkA\u0011\"!%E\u0003\u0003%)%a%\t\u0013\u0011=A)!A\u0005\u0002\u0012]\u0002\"\u0003C\r\t\u0006\u0005I\u0011\u0011C\u001f\u00055\u0019Ei\u0011*fC\u0012,'/S7qY*\u00111\nT\u0001\u0004G\u0012\u001c'BA'O\u0003!\u0019w.\\7b]\u0012\u001c(BA(Q\u0003\u0015!W\r\u001c;b\u0015\t\t&+A\u0002tc2T!a\u0015+\u0002\u000bM\u0004\u0018M]6\u000b\u0005U3\u0016AB1qC\u000eDWMC\u0001X\u0003\ry'oZ\u0002\u0001'\r\u0001!\f\u0019\t\u00037zk\u0011\u0001\u0018\u0006\u0002;\u0006)1oY1mC&\u0011q\f\u0018\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0005$W\"\u00012\u000b\u0005\rt\u0015\u0001C7fi\u0016\u0014\u0018N\\4\n\u0005\u0015\u0014'\u0001\u0004#fYR\fGj\\4hS:<\u0017A\u0002\u0013j]&$H\u0005F\u0001i!\tY\u0016.\u0003\u0002k9\n!QK\\5u\u0003A9W\r\u001e,feNLwN\u001c$pe\u000e#5\tF\u0007n\u00037\u000b)+!-\u0002B\u0006E\u0017\u0011\u001e\t\u00047:\u0004\u0018BA8]\u0005\u0019y\u0005\u000f^5p]B\u0011\u0011/M\u0007\u0002\u0001\t\u0011\"+Z:pYZ,Gm\u0011#G-\u0016\u00148/[8o'\u0011\t$\f^<\u0011\u0005m+\u0018B\u0001<]\u0005\u001d\u0001&o\u001c3vGR\u0004\"a\u0017=\n\u0005ed&\u0001D*fe&\fG.\u001b>bE2,\u0017a\u0002<feNLwN\\\u000b\u0002yB\u00111,`\u0005\u0003}r\u0013A\u0001T8oO\u0006Aa/\u001a:tS>t\u0007%A\u0005uS6,7\u000f^1naV\u0011\u0011Q\u0001\t\u00057:\f9\u0001\u0005\u0003\u0002\n\u0005EQBAA\u0006\u0015\r\t\u0016Q\u0002\u0006\u0003\u0003\u001f\tAA[1wC&!\u00111CA\u0006\u0005%!\u0016.\\3ti\u0006l\u0007/\u0001\u0006uS6,7\u000f^1na\u0002\na\u0001P5oSRtD#\u00029\u0002\u001c\u0005u\u0001\"\u0002>7\u0001\u0004a\bbBA\u0001m\u0001\u0007\u0011QA\u0001\u0014e\u0016\u001cx\u000e\u001c<fI\nKH+[7fgR\fW\u000e]\u000b\u0003\u0003G\u00012aWA\u0013\u0013\r\t9\u0003\u0018\u0002\b\u0005>|G.Z1o\u0003\u0011\u0019w\u000e]=\u0015\u000bA\fi#a\f\t\u000fiD\u0004\u0013!a\u0001y\"I\u0011\u0011\u0001\u001d\u0011\u0002\u0003\u0007\u0011QA\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t)DK\u0002}\u0003oY#!!\u000f\u0011\t\u0005m\u0012QI\u0007\u0003\u0003{QA!a\u0010\u0002B\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0007b\u0016AC1o]>$\u0018\r^5p]&!\u0011qIA\u001f\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tiE\u000b\u0003\u0002\u0006\u0005]\u0012!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002TA!\u0011QKA.\u001b\t\t9F\u0003\u0003\u0002Z\u00055\u0011\u0001\u00027b]\u001eLA!!\u0018\u0002X\t11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u0019\u0011\u0007m\u000b)'C\u0002\u0002hq\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u001c\u0002tA\u00191,a\u001c\n\u0007\u0005EDLA\u0002B]fD\u0011\"!\u001e>\u0003\u0003\u0005\r!a\u0019\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tY\b\u0005\u0004\u0002~\u0005\r\u0015QN\u0007\u0003\u0003\u007fR1!!!]\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u000b\u000byH\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\u0012\u0003\u0017C\u0011\"!\u001e@\u0003\u0003\u0005\r!!\u001c\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a\u0019\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u0015\u0002\r\u0015\fX/\u00197t)\u0011\t\u0019#!'\t\u0013\u0005U$)!AA\u0002\u00055\u0004BB*\u0003\u0001\u0004\ti\n\u0005\u0003\u0002 \u0006\u0005V\"\u0001)\n\u0007\u0005\r\u0006K\u0001\u0007Ta\u0006\u00148nU3tg&|g\u000eC\u0004\u0002(\n\u0001\r!!+\u0002\u0011\u0011,G\u000e^1M_\u001e\u0004B!a+\u0002.6\ta*C\u0002\u00020:\u0013\u0001\u0002R3mi\u0006dun\u001a\u0005\b\u0003g\u0013\u0001\u0019AA[\u0003\u0011\u0019wN\u001c4\u0011\t\u0005]\u0016QX\u0007\u0003\u0003sS1!a/Q\u0003!Ig\u000e^3s]\u0006d\u0017\u0002BA`\u0003s\u0013qaU)M\u0007>tg\rC\u0004\u0002D\n\u0001\r!!2\u0002\u000f=\u0004H/[8ogB!\u0011qYAg\u001b\t\tIMC\u0002\u0002LB\u000bA!\u001e;jY&!\u0011qZAe\u0005a\u0019\u0015m]3J]N,gn]5uSZ,7\u000b\u001e:j]\u001el\u0015\r\u001d\u0005\b\u0003'\u0014\u0001\u0019AAk\u0003)1XM]:j_:\\U-\u001f\t\u0005\u0003/\f)O\u0004\u0003\u0002Z\u0006\u0005\bcAAn96\u0011\u0011Q\u001c\u0006\u0004\u0003?D\u0016A\u0002\u001fs_>$h(C\u0002\u0002dr\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA/\u0003OT1!a9]\u0011\u001d\tYO\u0001a\u0001\u0003+\fA\u0002^5nKN$\u0018-\u001c9LKf\f!dZ3u\u0005\u0006$8\r[*dQ\u0016l\u0017-T8eK\u001a{'\u000fV1cY\u0016$b!!=\u0002x\u0006e\b\u0003BAV\u0003gL1!!>O\u0005]!U\r\u001c;b\u0005\u0006$8\r[\"E\rN\u001b\u0007.Z7b\u001b>$W\r\u0003\u0004T\u0007\u0001\u0007\u0011Q\u0014\u0005\b\u0003w\u001c\u0001\u0019AA\u007f\u0003!\u0019h.\u00199tQ>$\b\u0003BAV\u0003\u007fL1A!\u0001O\u0005!\u0019f.\u00199tQ>$\u0018AD4fi\u000e#5IU3mCRLwN\u001c\u000b\r\u0005\u000f\u0011\u0019B!\u0006\u0003\u001a\tu!q\u0004\t\u0005\u0005\u0013\u0011y!\u0004\u0002\u0003\f)\u0019!Q\u0002)\u0002\u000fM|WO]2fg&!!\u0011\u0003B\u0006\u00051\u0011\u0015m]3SK2\fG/[8o\u0011\u0019\u0019F\u00011\u0001\u0002\u001e\"9!q\u0003\u0003A\u0002\u0005u\u0018!D:oCB\u001c\bn\u001c;U_V\u001bX\rC\u0004\u0003\u001c\u0011\u0001\r!a\t\u0002#%\u001cH+[7f)J\fg/\u001a7Rk\u0016\u0014\u0018\u0010C\u0004\u00024\u0012\u0001\r!!.\t\u000f\u0005\rG\u00011\u0001\u0002F\u0006i2\u000f[8vY\u0012\u001c6.\u001b9GS2,\u0017i\u0019;j_:\u001c\u0018J\\\"p[6LG\u000f\u0006\u0003\u0002$\t\u0015\u0002b\u0002B\u0014\u000b\u0001\u0007!\u0011F\u0001\u000bG>lW.\u001b;J]\u001a|\u0007\u0003\u0002B\u0016\u0005ci!A!\f\u000b\u0007\t=b*A\u0004bGRLwN\\:\n\t\tM\"Q\u0006\u0002\u000b\u0007>lW.\u001b;J]\u001a|\u0017aC2iC:<Wm\u001d+p\t\u001a#\u0002C!\u000f\u0003\u000e\n]%1\u0014BP\u0005\u0007\u0014)M!3\u0011\u0005E<\"AE\"E\u0007Z+'o]5p]\u0012KgMZ%oM>\u001cBa\u0006.uo\u0006aa-\u001b7f\u0007\"\fgnZ3EMV\u0011!1\t\t\u0005\u0005\u000b\u0012YF\u0004\u0003\u0003H\t]c\u0002\u0002B%\u0005+rAAa\u0013\u0003T9!!Q\nB)\u001d\u0011\tYNa\u0014\n\u0003]K!!\u0016,\n\u0005M#\u0016BA)S\u0013\r\u0011I\u0006U\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011iFa\u0018\u0003\u0013\u0011\u000bG/\u0019$sC6,'b\u0001B-!\u0006ia-\u001b7f\u0007\"\fgnZ3EM\u0002\n\u0001B\\;n\r&dWm]\u0001\n]Vlg)\u001b7fg\u0002\n\u0001B\\;n\u0005f$Xm]\u0001\n]Vl')\u001f;fg\u0002\"\u0002B!\u000f\u0003n\t=$\u0011\u000f\u0005\b\u0005\u007fq\u0002\u0019\u0001B\"\u0011\u0019\u0011\u0019G\ba\u0001y\"1!q\r\u0010A\u0002q$\u0002B!\u000f\u0003v\t]$\u0011\u0010\u0005\n\u0005\u007fy\u0002\u0013!a\u0001\u0005\u0007B\u0001Ba\u0019 !\u0003\u0005\r\u0001 \u0005\t\u0005Oz\u0002\u0013!a\u0001yV\u0011!Q\u0010\u0016\u0005\u0005\u0007\n9$\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0015\t\u00055$1\u0011\u0005\n\u0003k*\u0013\u0011!a\u0001\u0003G\"B!a\t\u0003\b\"I\u0011QO\u0014\u0002\u0002\u0003\u0007\u0011Q\u000e\u000b\u0005\u0003G\u0011Y\tC\u0005\u0002v)\n\t\u00111\u0001\u0002n!9!q\u0012\u0004A\u0002\tE\u0015A\u0005:fC\u0012\u001c6\r[3nCNs\u0017\r]:i_R\u0004B!a+\u0003\u0014&\u0019!Q\u0013(\u0003%Ms\u0017\r]:i_R$Um]2sSB$xN\u001d\u0005\u0007\u000533\u0001\u0019\u0001?\u0002\u000bM$\u0018M\u001d;\t\r\tue\u00011\u0001}\u0003\r)g\u000e\u001a\u0005\b\u0005C3\u0001\u0019\u0001BR\u0003\u001d\u0019\u0007.\u00198hKN\u0004bA!*\u0003.\nEf\u0002\u0002BT\u0005WsA!a7\u0003*&\tQ,C\u0002\u0003ZqKA!!\"\u00030*\u0019!\u0011\f/\u0011\rm\u0013\u0019\f B\\\u0013\r\u0011)\f\u0018\u0002\u0007)V\u0004H.\u001a\u001a\u0011\r\t\u0015&\u0011\u0018B_\u0013\u0011\u0011YLa,\u0003\u0007M+\u0017\u000f\u0005\u0003\u0003,\t}\u0016\u0002\u0002Ba\u0005[\u0011a!Q2uS>t\u0007BB*\u0007\u0001\u0004\ti\nC\u0005\u0003H\u001a\u0001\n\u00111\u0001\u0002$\u0005Y\u0011n]*ue\u0016\fW.\u001b8h\u0011%\u0011YM\u0002I\u0001\u0002\u0004\t\u0019#A\nvg\u0016\u001cu.\u0019:tK\u001e\u0013\u0018-\u001b8fI\u000e#5)A\u000bdQ\u0006tw-Z:U_\u00123E\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\tE'\u0006BA\u0012\u0003o\tQc\u00195b]\u001e,7\u000fV8E\r\u0012\"WMZ1vYR$s'\u0001\fhKR$U\r\\3uK\u0012\fe\u000eZ!eI\u0016$'k\\<t)9\u0011INa7\u0004\u0002\r=1\u0011CB\n\u0007+\u0001bA!*\u0003:\n\r\u0003b\u0002Bo\u0013\u0001\u0007!q\\\u0001\rC\u0012$g)\u001b7f'B,7m\u001d\t\u0007\u0005K\u0013IL!9\u0011\r\t\r(Q\u001fB~\u001d\u0011\u0011)O!=\u000f\t\t\u001d(q\u001e\b\u0005\u0005S\u0014iO\u0004\u0003\u0003H\t-\u0018BA(Q\u0013\tie*\u0003\u0002L\u0019&\u0019!1\u001f&\u0002\u0013\r#5IU3bI\u0016\u0014\u0018\u0002\u0002B|\u0005s\u00141b\u0011#D\t\u0006$\u0018m\u00159fG*\u0019!1\u001f&\u0011\t\t-\"Q`\u0005\u0005\u0005\u007f\u0014iCA\u0004BI\u00124\u0015\u000e\\3\t\u000f\r\r\u0011\u00021\u0001\u0004\u0006\u0005y!/Z7pm\u00164\u0015\u000e\\3Ta\u0016\u001c7\u000f\u0005\u0004\u0003&\ne6q\u0001\t\u0007\u0005G\u0014)p!\u0003\u0011\t\t-21B\u0005\u0005\u0007\u001b\u0011iC\u0001\u0006SK6|g/\u001a$jY\u0016Dq!a*\n\u0001\u0004\tI\u000bC\u0004\u0002|&\u0001\rA!%\t\u000f\t\u001d\u0017\u00021\u0001\u0002$!11+\u0003a\u0001\u0003;\u000bA\u0004\u001d:pG\u0016\u001c8\u000fR3mKRLwN\u001c,fGR|'/Q2uS>t7\u000f\u0006\t\u0003Z\u000em11FB\u0019\u0007o\u0019Ida\u000f\u0004>!91Q\u0004\u0006A\u0002\r}\u0011aC1eI\u001aKG.Z:NCB\u0004\u0002\"a6\u0004\"\r\u0015\"1`\u0005\u0005\u0007G\t9OA\u0002NCB\u0004BAa9\u0004(%!1\u0011\u0006B}\u0005a1\u0015\u000e\\3QCRDw+\u001b;i)\u0006\u0014G.\u001a,feNLwN\u001c\u0005\b\u0007[Q\u0001\u0019AB\u0018\u00039\u0011X-\\8wK\u001aKG.Z:NCB\u0004\u0002\"a6\u0004\"\r\u00152\u0011\u0002\u0005\b\u0007gQ\u0001\u0019AB\u001b\u0003M1XM]:j_:$vnQ8n[&$\u0018J\u001c4p!\u001d\t9n!\t}\u0005SAq!a*\u000b\u0001\u0004\tI\u000bC\u0004\u0002|*\u0001\rA!%\t\u000f\t\u001d'\u00021\u0001\u0002$!11K\u0003a\u0001\u0003;\u000bacZ3u)&lWm\u001d;b[B\u001c()\u001f,feNLwN\u001c\u000b\u000b\u0007\u0007\u001a)ea\u0012\u0004J\r-\u0003cBAl\u0007Ca\u0018q\u0001\u0005\b\u0003O[\u0001\u0019AAU\u0011\u0019\u0011Ij\u0003a\u0001y\"1!QT\u0006A\u0002qDaaU\u0006A\u0002\u0005u\u0015\u0001E2iC:<Wm\u001d+p\u0005\u0006$8\r\u001b#G)9\u0011\u0019e!\u0015\u0004T\rU3qKB-\u0007;Bq!a*\r\u0001\u0004\tI\u000b\u0003\u0004\u0003\u001a2\u0001\r\u0001 \u0005\u0007\u0005;c\u0001\u0019\u0001?\t\rMc\u0001\u0019AAO\u0011%\u0011y\t\u0004I\u0001\u0002\u0004\u0019Y\u0006\u0005\u0003\\]\u0006u\b\"\u0003Bf\u0019A\u0005\t\u0019AA\u0012\u0003i\u0019\u0007.\u00198hKN$vNQ1uG\"$e\t\n3fM\u0006,H\u000e\u001e\u00136+\t\u0019\u0019G\u000b\u0003\u0004\\\u0005]\u0012AG2iC:<Wm\u001d+p\u0005\u0006$8\r\u001b#GI\u0011,g-Y;mi\u00122\u0014!C:dC:Le\u000eZ3y)!\u0011\u0019ea\u001b\u0004n\ru\u0004BB*\u0010\u0001\u0004\ti\nC\u0004\u0004p=\u0001\ra!\u001d\u0002\u000b%tG-\u001a=\u0011\t\rM4\u0011P\u0007\u0003\u0007kR1aa\u001eO\u0003\u00151\u0017\u000e\\3t\u0013\u0011\u0019Yh!\u001e\u0003IQ\u000b\u0007n\\3GS2,\u0017J\u001c3fq^KG\u000f[*oCB\u001c\bn\u001c;EKN\u001c'/\u001b9u_JD\u0011Ba2\u0010!\u0003\u0005\r!a\t\u0002'M\u001c\u0017M\\%oI\u0016DH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001b\r$7MU3bIN\u001b\u0007.Z7b)\u0011\u0019)i!%\u0011\t\r\u001d5QR\u0007\u0003\u0007\u0013S1aa#Q\u0003\u0015!\u0018\u0010]3t\u0013\u0011\u0019yi!#\u0003\u0015M#(/^2u)f\u0004X\rC\u0004\u0004\u0014F\u0001\ra!\"\u0002\u0017\u0011,G\u000e^1TG\",W.Y\u0001\nSN\u001cEi\u0011*fC\u0012$B!a\t\u0004\u001a\"9\u00111\u0019\nA\u0002\u0005\u0015\u0017aE5t\u0007\u0012\u001bUI\\1cY\u0016$wJ\u001c+bE2,GCBA\u0012\u0007?\u001bI\u000bC\u0004\u0004\"N\u0001\raa)\u0002\u00115,G/\u00193bi\u0006\u0004BAa\u000b\u0004&&!1q\u0015B\u0017\u0005!iU\r^1eCR\f\u0007BB*\u0014\u0001\u0004\ti*A\u0010hK:,'/\u0019;f\r&dW-Q2uS>t7oV5uQ&sG.\u001b8f\tZ$\"ba,\u00048\u000em6qXBj!\u0019\u0011)K!/\u00042B!!1FBZ\u0013\u0011\u0019)L!\f\u0003\u0015\u0019KG.Z!di&|g\u000eC\u0004\u0004:R\u0001\rAa?\u0002\u0007\u0005$G\rC\u0004\u0004>R\u0001\ra!\u0003\u0002\rI,Wn\u001c<f\u0011\u001d\u0019\t\r\u0006a\u0001\u0007\u0007\fq\u0001\u001a<Ti>\u0014X\r\u0005\u0003\u0004F\u000e=WBABd\u0015\u0011\u0019Ima3\u0002\u0005\u00114(bABg\u001d\u000691\u000f^8sC\u001e,\u0017\u0002BBi\u0007\u000f\u00141\u0003R3mKRLwN\u001c,fGR|'o\u0015;pe\u0016Dq!a*\u0015\u0001\u0004\tI+\u0001\u0016gS2,\u0017i\u0019;j_:\u001cHk\\%g\u001d>$8i\u001c8uC&tW\r\u001a*po&sG-\u001a=GS2$XM]:\u0015\t\re7\u0011\u001d\t\t\u0003/\u001c\t#!6\u0004\\B!\u00111VBo\u0013\r\u0019yN\u0014\u0002\u0013%><\u0018J\u001c3fq\u001aKG\u000e^3s)f\u0004X\rC\u0004\u00030U\u0001\raa,\u0002-\u001d,G\u000fR3mKRLwN\u001c,fGR|'o\u001d#jM\u001a$baa:\u0004t\u000e]\b\u0003BBu\u0007_l!aa;\u000b\u0007\r5h*A\beK2,G/[8om\u0016\u001cGo\u001c:t\u0013\u0011\u0019\tpa;\u0003%I{\u0017M]5oO\nKG/\\1q\u0003J\u0014\u0018-\u001f\u0005\b\u0007k4\u0002\u0019ABt\u0003\u0011aWM\u001a;\t\u000f\reh\u00031\u0001\u0004h\u0006)!/[4ii\u0006\u00112\tR\"WKJ\u001c\u0018n\u001c8ES\u001a4\u0017J\u001c4p!\t\tHf\u0005\u0003-\t\u00039\bC\u0003C\u0002\t\u0013\u0011\u0019\u0005 ?\u0003:5\u0011AQ\u0001\u0006\u0004\t\u000fa\u0016a\u0002:v]RLW.Z\u0005\u0005\t\u0017!)AA\tBEN$(/Y2u\rVt7\r^5p]N\"\"a!@\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0011\teB1\u0003C\u000b\t/AqAa\u00100\u0001\u0004\u0011\u0019\u0005\u0003\u0004\u0003d=\u0002\r\u0001 \u0005\u0007\u0005Oz\u0003\u0019\u0001?\u0002\u000fUt\u0017\r\u001d9msR!AQ\u0004C\u0013!\u0011Yf\u000eb\b\u0011\u000fm#\tCa\u0011}y&\u0019A1\u0005/\u0003\rQ+\b\u000f\\34\u0011%!9\u0003MA\u0001\u0002\u0004\u0011I$A\u0002yIA\n!CU3t_24X\rZ\"E\rZ+'o]5p]B\u0011\u0011\u000fR\n\u0005\t\u0012=r\u000f\u0005\u0005\u0005\u0004\u0011EB0!\u0002q\u0013\u0011!\u0019\u0004\"\u0002\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0006\u0002\u0005,Q)\u0001\u000f\"\u000f\u0005<!)!p\u0012a\u0001y\"9\u0011\u0011A$A\u0002\u0005\u0015A\u0003\u0002C \t\u0007\u0002Ba\u00178\u0005BA11La-}\u0003\u000bA\u0001\u0002b\nI\u0003\u0003\u0005\r\u0001\u001d")
public interface CDCReaderImpl
extends DeltaLogging {
    public CDCReaderImpl$CDCVersionDiffInfo$ CDCVersionDiffInfo();

    public CDCReaderImpl$ResolvedCDFVersion$ org$apache$spark$sql$delta$commands$cdc$CDCReaderImpl$$ResolvedCDFVersion();

    private Option<ResolvedCDFVersion> getVersionForCDC(SparkSession spark, DeltaLog deltaLog, SQLConf conf, CaseInsensitiveStringMap options, String versionKey, String timestampKey) {
        Some some;
        if (options.containsKey((Object)versionKey)) {
            some = new Some((Object)new ResolvedCDFVersion(this, new StringOps(Predef$.MODULE$.augmentString(options.get((Object)versionKey))).toLong(), (Option<Timestamp>)None$.MODULE$));
        } else if (options.containsKey((Object)timestampKey)) {
            String ts = options.get((Object)timestampKey);
            DeltaTimeTravelSpec spec = new DeltaTimeTravelSpec((Option<Expression>)new Some((Object)Literal$.MODULE$.apply((Object)ts)), (Option<Object>)None$.MODULE$, (Option<String>)new Some((Object)"cdcReader"));
            Timestamp timestamp = spec.getTimestamp(spark.sessionState().conf());
            boolean allowOutOfRange = BoxesRunTime.unboxToBoolean((Object)conf.getConf(DeltaSQLConf$.MODULE$.DELTA_CDF_ALLOW_OUT_OF_RANGE_TIMESTAMP()));
            String string = timestampKey;
            String string2 = "startingTimestamp";
            long resolvedVersion = !(string != null ? !string.equals(string2) : string2 != null) ? DeltaSource$.MODULE$.getStartingVersionFromTimestamp(spark, deltaLog, timestamp, allowOutOfRange) : DeltaTableUtils$.MODULE$.resolveTimeTravelVersion(conf, deltaLog, spec, allowOutOfRange)._1$mcJ$sp();
            some = new Some((Object)new ResolvedCDFVersion(this, resolvedVersion, (Option<Timestamp>)new Some((Object)timestamp)));
        } else {
            some = None$.MODULE$;
        }
        return some;
    }

    public static /* synthetic */ DeltaBatchCDFSchemaMode getBatchSchemaModeForTable$(CDCReaderImpl $this, SparkSession spark, Snapshot snapshot) {
        return $this.getBatchSchemaModeForTable(spark, snapshot);
    }

    default public DeltaBatchCDFSchemaMode getBatchSchemaModeForTable(SparkSession spark, Snapshot snapshot) {
        DeltaColumnMappingMode deltaColumnMappingMode = snapshot.metadata().columnMappingMode();
        NoMapping$ noMapping$ = NoMapping$.MODULE$;
        return (deltaColumnMappingMode == null ? noMapping$ != null : !deltaColumnMappingMode.equals(noMapping$)) ? DeltaBatchCDFSchemaMode$.MODULE$.apply((String)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_CDF_DEFAULT_SCHEMA_MODE_FOR_COLUMN_MAPPING_TABLE())) : BatchCDFSchemaLegacy$.MODULE$;
    }

    public static /* synthetic */ BaseRelation getCDCRelation$(CDCReaderImpl $this, SparkSession spark, Snapshot snapshotToUse, boolean isTimeTravelQuery, SQLConf conf, CaseInsensitiveStringMap options) {
        return $this.getCDCRelation(spark, snapshotToUse, isTimeTravelQuery, conf, options);
    }

    default public BaseRelation getCDCRelation(SparkSession spark, Snapshot snapshotToUse, boolean isTimeTravelQuery, SQLConf conf, CaseInsensitiveStringMap options) {
        BaseRelation baseRelation;
        Object object = new Object();
        try {
            ResolvedCDFVersion startingVersion = (ResolvedCDFVersion)this.getVersionForCDC(spark, snapshotToUse.deltaLog(), conf, options, "startingVersion", "startingTimestamp").getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw DeltaErrors$.MODULE$.noStartVersionForCDC();
            });
            DeltaBatchCDFSchemaMode schemaMode = this.getBatchSchemaModeForTable(spark, snapshotToUse);
            if (isTimeTravelQuery) {
                DeltaBatchCDFSchemaMode deltaBatchCDFSchemaMode = schemaMode;
                BatchCDFSchemaLegacy$ batchCDFSchemaLegacy$ = BatchCDFSchemaLegacy$.MODULE$;
                if (deltaBatchCDFSchemaMode == null ? batchCDFSchemaLegacy$ != null : !deltaBatchCDFSchemaMode.equals(batchCDFSchemaLegacy$)) {
                    throw DeltaErrors$.MODULE$.illegalDeltaOptionException(DeltaSQLConf$.MODULE$.DELTA_CDF_DEFAULT_SCHEMA_MODE_FOR_COLUMN_MAPPING_TABLE().key(), schemaMode.name(), new StringBuilder(41).append(DeltaSQLConf$.MODULE$.DELTA_CDF_DEFAULT_SCHEMA_MODE_FOR_COLUMN_MAPPING_TABLE().key()).append(" ").append("cannot be used with time travel options.").toString());
                }
            }
            if (startingVersion.version() > snapshotToUse.version()) {
                boolean allowOutOfRange = BoxesRunTime.unboxToBoolean((Object)conf.getConf(DeltaSQLConf$.MODULE$.DELTA_CDF_ALLOW_OUT_OF_RANGE_TIMESTAMP()));
                if (allowOutOfRange) {
                    return CDCReaderImpl.emptyCDFRelation$1(snapshotToUse, schemaMode, spark);
                }
                throw DeltaErrors$.MODULE$.startVersionAfterLatestVersion(startingVersion.version(), snapshotToUse.version());
            }
            Option<ResolvedCDFVersion> endingVersionOpt = this.getVersionForCDC(spark, snapshotToUse.deltaLog(), conf, options, "endingVersion", "endingTimestamp");
            endingVersionOpt.foreach((Function1 & Serializable & scala.Serializable)endingVersion -> {
                CDCReaderImpl.$anonfun$getCDCRelation$2(startingVersion, object, snapshotToUse, schemaMode, spark, endingVersion);
                return BoxedUnit.UNIT;
            });
            if (endingVersionOpt.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CDCReaderImpl.$anonfun$getCDCRelation$3(startingVersion, x$1)))) {
                throw DeltaErrors$.MODULE$.endBeforeStartVersionInCDC(startingVersion.version(), ((ResolvedCDFVersion)endingVersionOpt.get()).version());
            }
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("startingVersion: ").append(startingVersion.version()).append(", ").append("endingVersion: ").append(endingVersionOpt.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.version()))).toString());
            baseRelation = new CDCReader.DeltaCDFRelation(new CDCReader.SnapshotWithSchemaMode(snapshotToUse, schemaMode), spark.sqlContext(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)startingVersion.version())), (Option<Object>)endingVersionOpt.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.version())));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                baseRelation = (BaseRelation)ex.value();
            }
            throw ex;
        }
        return baseRelation;
    }

    public static /* synthetic */ boolean shouldSkipFileActionsInCommit$(CDCReaderImpl $this, CommitInfo commitInfo) {
        return $this.shouldSkipFileActionsInCommit(commitInfo);
    }

    default public boolean shouldSkipFileActionsInCommit(CommitInfo commitInfo) {
        String string = commitInfo.operation();
        String string2 = DeltaOperations$.MODULE$.OP_MERGE();
        boolean isMerge = !(string != null ? !string.equals(string2) : string2 != null);
        scala.collection.immutable.Map metrics = (scala.collection.immutable.Map)commitInfo.operationMetrics().getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
        boolean knownToHaveNoChangedRows = ((IterableLike)new .colon.colon((Object)"numTargetRowsInserted", (List)new .colon.colon((Object)"numTargetRowsUpdated", (List)new .colon.colon((Object)"numTargetRowsDeleted", (List)Nil$.MODULE$)))).forall((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)CDCReaderImpl.$anonfun$shouldSkipFileActionsInCommit$2(metrics, x$4)));
        return isMerge && knownToHaveNoChangedRows;
    }

    public static /* synthetic */ CDCVersionDiffInfo changesToDF$(CDCReaderImpl $this, SnapshotDescriptor readSchemaSnapshot, long start, long end, Iterator changes, SparkSession spark, boolean isStreaming, boolean useCoarseGrainedCDC) {
        return $this.changesToDF(readSchemaSnapshot, start, end, (Iterator<Tuple2<Object, Seq<Action>>>)changes, spark, isStreaming, useCoarseGrainedCDC);
    }

    default public CDCVersionDiffInfo changesToDF(SnapshotDescriptor readSchemaSnapshot, long start, long end, Iterator<Tuple2<Object, Seq<Action>>> changes, SparkSession spark, boolean isStreaming, boolean useCoarseGrainedCDC) {
        Dataset emptyDf;
        DeltaLog deltaLog = readSchemaSnapshot.deltaLog();
        if (end < start) {
            throw DeltaErrors$.MODULE$.endBeforeStartVersionInCDC(start, end);
        }
        scala.collection.immutable.Map<Object, Timestamp> timestampsByVersion = this.getTimestampsByVersion(deltaLog, start, end, spark);
        ListBuffer changeFiles = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ListBuffer addFiles = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ListBuffer removeFiles = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Snapshot startVersionSnapshot = deltaLog.getSnapshotAt(start, deltaLog.getSnapshotAt$default$2());
        if (!useCoarseGrainedCDC && !this.isCDCEnabledOnTable(startVersionSnapshot.metadata(), spark)) {
            throw DeltaErrors$.MODULE$.changeDataNotRecordedException(start, start, end);
        }
        boolean allowUnsafeBatchReadOnIncompatibleSchemaChanges = BoxesRunTime.unboxToBoolean((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_CDF_UNSAFE_BATCH_READ_ON_INCOMPATIBLE_SCHEMA_CHANGES()));
        if (allowUnsafeBatchReadOnIncompatibleSchemaChanges) {
            this.recordDeltaEvent(deltaLog, "delta.unsafe.cdf.readOnColumnMappingSchemaChanges", this.recordDeltaEvent$default$3(), this.recordDeltaEvent$default$4(), this.recordDeltaEvent$default$5());
        }
        boolean shouldCheckSchemaToBlockBatchRead = !isStreaming && !allowUnsafeBatchReadOnIncompatibleSchemaChanges;
        LongRef totalBytes = LongRef.create((long)0L);
        LongRef totalFiles = LongRef.create((long)0L);
        changes.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            CDCReaderImpl.$anonfun$changesToDF$1(this, spark, useCoarseGrainedCDC, start, end, timestampsByVersion, totalFiles, totalBytes, changeFiles, addFiles, removeFiles, shouldCheckSchemaToBlockBatchRead, readSchemaSnapshot, x0$1);
            return BoxedUnit.UNIT;
        });
        CDCReaderImpl.checkBatchCdfReadSchemaIncompatibility$1(startVersionSnapshot.metadata(), startVersionSnapshot.version(), false, shouldCheckSchemaToBlockBatchRead, readSchemaSnapshot, start, end);
        ListBuffer dfs = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        if (changeFiles.nonEmpty()) {
            dfs.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Dataset[]{this.scanIndex(spark, new TahoeChangeFileIndex(spark, (Seq<CDCReader.CDCDataSpec<AddCDCFile>>)changeFiles.toSeq(), deltaLog, deltaLog.dataPath(), readSchemaSnapshot), isStreaming)}));
        }
        Seq<Dataset<Row>> deletedAndAddedRows = this.getDeletedAndAddedRows((Seq<CDCReader.CDCDataSpec<AddFile>>)addFiles.toSeq(), (Seq<CDCReader.CDCDataSpec<RemoveFile>>)removeFiles.toSeq(), deltaLog, readSchemaSnapshot, isStreaming, spark);
        dfs.append(deletedAndAddedRows);
        StructType readSchema = this.cdcReadSchema(readSchemaSnapshot.metadata().schema());
        Dataset dataset = emptyDf = spark.sqlContext().internalCreateDataFrame(spark.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(InternalRow.class)), readSchema, isStreaming);
        return new CDCVersionDiffInfo(this, (Dataset<Row>)((Dataset)((TraversableOnce)dfs.$plus$colon((Object)dataset, ListBuffer$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(df1, df2) -> df1.union(df2))), totalFiles.elem, totalBytes.elem);
    }

    public static /* synthetic */ boolean changesToDF$default$6$(CDCReaderImpl $this) {
        return $this.changesToDF$default$6();
    }

    default public boolean changesToDF$default$6() {
        return false;
    }

    public static /* synthetic */ boolean changesToDF$default$7$(CDCReaderImpl $this) {
        return $this.changesToDF$default$7();
    }

    default public boolean changesToDF$default$7() {
        return false;
    }

    public static /* synthetic */ Seq getDeletedAndAddedRows$(CDCReaderImpl $this, Seq addFileSpecs, Seq removeFileSpecs, DeltaLog deltaLog, SnapshotDescriptor snapshot, boolean isStreaming, SparkSession spark) {
        return $this.getDeletedAndAddedRows((Seq<CDCReader.CDCDataSpec<AddFile>>)addFileSpecs, (Seq<CDCReader.CDCDataSpec<RemoveFile>>)removeFileSpecs, deltaLog, snapshot, isStreaming, spark);
    }

    default public Seq<Dataset<Row>> getDeletedAndAddedRows(Seq<CDCReader.CDCDataSpec<AddFile>> addFileSpecs, Seq<CDCReader.CDCDataSpec<RemoveFile>> removeFileSpecs, DeltaLog deltaLog, SnapshotDescriptor snapshot, boolean isStreaming, SparkSession spark) {
        Map versionToCommitInfo = Map$.MODULE$.empty();
        scala.collection.immutable.Map addFilesMap = ((TraversableOnce)addFileSpecs.flatMap((Function1 & Serializable & scala.Serializable)spec -> {
            ScalaExtensions$.MODULE$.OptionExt(spec.commitInfo()).ifDefined((Function1<CommitInfo, BoxedUnit>)(Function1 & Serializable & scala.Serializable)ci -> {
                versionToCommitInfo.update((Object)BoxesRunTime.boxToLong((long)spec.version()), (Object)ci);
                return BoxedUnit.UNIT;
            });
            return (Seq)spec.actions().map((Function1 & Serializable & scala.Serializable)action -> {
                CDCReader.FilePathWithTableVersion key = new CDCReader.FilePathWithTableVersion(action.path(), spec.commitInfo(), spec.version(), spec.timestamp());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), action);
            }, Seq$.MODULE$.canBuildFrom());
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map removeFilesMap = ((TraversableOnce)removeFileSpecs.flatMap((Function1 & Serializable & scala.Serializable)spec -> {
            ScalaExtensions$.MODULE$.OptionExt(spec.commitInfo()).ifDefined((Function1<CommitInfo, BoxedUnit>)(Function1 & Serializable & scala.Serializable)ci -> {
                versionToCommitInfo.update((Object)BoxesRunTime.boxToLong((long)spec.version()), (Object)ci);
                return BoxedUnit.UNIT;
            });
            return (Seq)spec.actions().map((Function1 & Serializable & scala.Serializable)action -> {
                CDCReader.FilePathWithTableVersion key = new CDCReader.FilePathWithTableVersion(action.path(), spec.commitInfo(), spec.version(), spec.timestamp());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), action);
            }, Seq$.MODULE$.canBuildFrom());
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Map finalAddFiles = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        Map finalRemoveFiles = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        ((IterableLike)addFilesMap.keySet().$minus$minus((GenTraversableOnce)removeFilesMap.keySet())).foreach((Function1 & Serializable & scala.Serializable)addKey -> {
            CDCReaderImpl.$anonfun$getDeletedAndAddedRows$7(finalAddFiles, addFilesMap, addKey);
            return BoxedUnit.UNIT;
        });
        ((IterableLike)removeFilesMap.keySet().$minus$minus((GenTraversableOnce)addFilesMap.keySet())).foreach((Function1 & Serializable & scala.Serializable)removeKey -> {
            CDCReaderImpl.$anonfun$getDeletedAndAddedRows$9(finalRemoveFiles, removeFilesMap, removeKey);
            return BoxedUnit.UNIT;
        });
        ListBuffer dfAddsAndRemoves = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        finalAddFiles.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            CDCReaderImpl.$anonfun$getDeletedAndAddedRows$11(this, versionToCommitInfo, dfAddsAndRemoves, spark, deltaLog, snapshot, isStreaming, x0$1);
            return BoxedUnit.UNIT;
        });
        finalRemoveFiles.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            CDCReaderImpl.$anonfun$getDeletedAndAddedRows$12(this, versionToCommitInfo, dfAddsAndRemoves, spark, deltaLog, snapshot, isStreaming, x0$2);
            return BoxedUnit.UNIT;
        });
        Seq<Dataset<Row>> dfGeneratedDvScanActions = this.processDeletionVectorActions((scala.collection.immutable.Map<CDCReader.FilePathWithTableVersion, AddFile>)addFilesMap, (scala.collection.immutable.Map<CDCReader.FilePathWithTableVersion, RemoveFile>)removeFilesMap, (scala.collection.immutable.Map<Object, CommitInfo>)versionToCommitInfo.toMap(Predef$.MODULE$.$conforms()), deltaLog, snapshot, isStreaming, spark);
        return (Seq)dfAddsAndRemoves.toSeq().$plus$plus(dfGeneratedDvScanActions, Seq$.MODULE$.canBuildFrom());
    }

    public static /* synthetic */ Seq processDeletionVectorActions$(CDCReaderImpl $this, scala.collection.immutable.Map addFilesMap, scala.collection.immutable.Map removeFilesMap, scala.collection.immutable.Map versionToCommitInfo, DeltaLog deltaLog, SnapshotDescriptor snapshot, boolean isStreaming, SparkSession spark) {
        return $this.processDeletionVectorActions((scala.collection.immutable.Map<CDCReader.FilePathWithTableVersion, AddFile>)addFilesMap, (scala.collection.immutable.Map<CDCReader.FilePathWithTableVersion, RemoveFile>)removeFilesMap, (scala.collection.immutable.Map<Object, CommitInfo>)versionToCommitInfo, deltaLog, snapshot, isStreaming, spark);
    }

    default public Seq<Dataset<Row>> processDeletionVectorActions(scala.collection.immutable.Map<CDCReader.FilePathWithTableVersion, AddFile> addFilesMap, scala.collection.immutable.Map<CDCReader.FilePathWithTableVersion, RemoveFile> removeFilesMap, scala.collection.immutable.Map<Object, CommitInfo> versionToCommitInfo, DeltaLog deltaLog, SnapshotDescriptor snapshot, boolean isStreaming, SparkSession spark) {
        Map finalReplaceAddFiles = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        Map finalReplaceRemoveFiles = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        DeletionVectorStore dvStore = DeletionVectorStore$.MODULE$.createInstance(deltaLog.newDeltaHadoopConf());
        ((IterableLike)addFilesMap.keySet().intersect((GenSet)removeFilesMap.keySet())).foreach((Function1 & Serializable & scala.Serializable)key -> {
            CDCReaderImpl.$anonfun$processDeletionVectorActions$1(this, addFilesMap, removeFilesMap, dvStore, deltaLog, finalReplaceAddFiles, finalReplaceRemoveFiles, key);
            return BoxedUnit.UNIT;
        });
        ListBuffer dfs = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        finalReplaceAddFiles.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            CDCReaderImpl.$anonfun$processDeletionVectorActions$5(this, versionToCommitInfo, dfs, spark, deltaLog, snapshot, isStreaming, x0$2);
            return BoxedUnit.UNIT;
        });
        finalReplaceRemoveFiles.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            CDCReaderImpl.$anonfun$processDeletionVectorActions$6(this, versionToCommitInfo, dfs, spark, deltaLog, snapshot, isStreaming, x0$3);
            return BoxedUnit.UNIT;
        });
        return dfs.toSeq();
    }

    public static /* synthetic */ scala.collection.immutable.Map getTimestampsByVersion$(CDCReaderImpl $this, DeltaLog deltaLog, long start, long end, SparkSession spark) {
        return $this.getTimestampsByVersion(deltaLog, start, end, spark);
    }

    default public scala.collection.immutable.Map<Object, Timestamp> getTimestampsByVersion(DeltaLog deltaLog, long start, long end, SparkSession spark) {
        long monotonizationStart = package$.MODULE$.max(start - (long)DeltaHistoryManager$.MODULE$.POTENTIALLY_UNMONOTONIZED_TIMESTAMPS(), 0L);
        DeltaHistoryManager.Commit[] commits = DeltaHistoryManager$.MODULE$.getCommits(deltaLog.store(), deltaLog.logPath(), monotonizationStart, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)(end + 1L))), deltaLog.newDeltaHadoopConf());
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])commits)).map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)f.version())), (Object)new Timestamp(f.timestamp())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
    }

    public static /* synthetic */ Dataset changesToBatchDF$(CDCReaderImpl $this, DeltaLog deltaLog, long start, long end, SparkSession spark, Option readSchemaSnapshot, boolean useCoarseGrainedCDC) {
        return $this.changesToBatchDF(deltaLog, start, end, spark, (Option<Snapshot>)readSchemaSnapshot, useCoarseGrainedCDC);
    }

    default public Dataset<Row> changesToBatchDF(DeltaLog deltaLog, long start, long end, SparkSession spark, Option<Snapshot> readSchemaSnapshot, boolean useCoarseGrainedCDC) {
        Iterator changesWithinRange = deltaLog.getChanges(start, deltaLog.getChanges$default$2()).takeWhile((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)CDCReaderImpl.$anonfun$changesToBatchDF$1(end, x0$1)));
        return this.changesToDF((SnapshotDescriptor)readSchemaSnapshot.getOrElse((Function0 & Serializable & scala.Serializable)() -> deltaLog.unsafeVolatileSnapshot()), start, end, (Iterator<Tuple2<Object, Seq<Action>>>)changesWithinRange, spark, false, useCoarseGrainedCDC).fileChangeDf();
    }

    public static /* synthetic */ Option changesToBatchDF$default$5$(CDCReaderImpl $this) {
        return $this.changesToBatchDF$default$5();
    }

    default public Option<Snapshot> changesToBatchDF$default$5() {
        return None$.MODULE$;
    }

    public static /* synthetic */ boolean changesToBatchDF$default$6$(CDCReaderImpl $this) {
        return $this.changesToBatchDF$default$6();
    }

    default public boolean changesToBatchDF$default$6() {
        return false;
    }

    public static /* synthetic */ Dataset scanIndex$(CDCReaderImpl $this, SparkSession spark, TahoeFileIndexWithSnapshotDescriptor index, boolean isStreaming) {
        return $this.scanIndex(spark, index, isStreaming);
    }

    default public Dataset<Row> scanIndex(SparkSession spark, TahoeFileIndexWithSnapshotDescriptor index, boolean isStreaming) {
        HadoopFsRelation relation = new HadoopFsRelation((FileIndex)index, index.partitionSchema(), this.cdcReadSchema(index.schema()), (Option)None$.MODULE$, (FileFormat)new DeltaParquetFileFormat(index.protocol(), index.metadata(), DeltaParquetFileFormat$.MODULE$.$lessinit$greater$default$3(), DeltaParquetFileFormat$.MODULE$.$lessinit$greater$default$4(), DeltaParquetFileFormat$.MODULE$.$lessinit$greater$default$5(), DeltaParquetFileFormat$.MODULE$.$lessinit$greater$default$6(), DeltaParquetFileFormat$.MODULE$.$lessinit$greater$default$7()), index.deltaLog().options(), spark);
        LogicalRelation plan = LogicalRelation$.MODULE$.apply((BaseRelation)relation, isStreaming);
        return Dataset$.MODULE$.ofRows(spark, (LogicalPlan)plan);
    }

    public static /* synthetic */ boolean scanIndex$default$3$(CDCReaderImpl $this) {
        return $this.scanIndex$default$3();
    }

    default public boolean scanIndex$default$3() {
        return false;
    }

    public static /* synthetic */ StructType cdcReadSchema$(CDCReaderImpl $this, StructType deltaSchema) {
        return $this.cdcReadSchema(deltaSchema);
    }

    default public StructType cdcReadSchema(StructType deltaSchema) {
        return deltaSchema.add(CDCReader$.MODULE$.CDC_TYPE_COLUMN_NAME(), (DataType)StringType$.MODULE$).add(CDCReader$.MODULE$.CDC_COMMIT_VERSION(), (DataType)LongType$.MODULE$).add(CDCReader$.MODULE$.CDC_COMMIT_TIMESTAMP(), (DataType)TimestampType$.MODULE$);
    }

    public static /* synthetic */ boolean isCDCRead$(CDCReaderImpl $this, CaseInsensitiveStringMap options) {
        return $this.isCDCRead(options);
    }

    /*
     * Unable to fully structure code
     */
    default public boolean isCDCRead(CaseInsensitiveStringMap options) {
        if (!options.containsKey((Object)"readChangeFeed")) ** GOTO lbl-1000
        v0 = options.get((Object)"readChangeFeed");
        var3_2 = "true";
        if (!(v0 != null ? v0.equals(var3_2) == false : var3_2 != null)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = cdcEnabled = false;
        }
        if (!options.containsKey((Object)"readChangeData")) ** GOTO lbl-1000
        v2 = options.get((Object)"readChangeData");
        var5_4 = "true";
        if (!(v2 != null ? v2.equals(var5_4) == false : var5_4 != null)) {
            v3 = true;
        } else lbl-1000:
        // 2 sources

        {
            v3 = false;
        }
        cdcLegacyConfEnabled = v3;
        return cdcEnabled != false || cdcLegacyConfEnabled != false;
    }

    public static /* synthetic */ boolean isCDCEnabledOnTable$(CDCReaderImpl $this, Metadata metadata, SparkSession spark) {
        return $this.isCDCEnabledOnTable(metadata, spark);
    }

    default public boolean isCDCEnabledOnTable(Metadata metadata, SparkSession spark) {
        return ChangeDataFeedTableFeature$.MODULE$.metadataRequiresFeatureToBeEnabled(metadata, spark);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Seq<FileAction> generateFileActionsWithInlineDv(AddFile add, RemoveFile remove, DeletionVectorStore dvStore, DeltaLog deltaLog) {
        ListBuffer listBuffer;
        Option removeDvOpt = Option$.MODULE$.apply((Object)remove.deletionVector());
        Option addDvOpt = Option$.MODULE$.apply((Object)add.deletionVector());
        ListBuffer newActions = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Tuple2 tuple2 = new Tuple2((Object)removeDvOpt, (Object)addDvOpt);
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option2)) {
                throw new Exception("Expecting one or both of add and remove contain DV.");
            }
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option3 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && option3 instanceof Some) {
                DeletionVectorDescriptor addDv;
                Some some = (Some)option3;
                DeletionVectorDescriptor x$1 = addDv = (DeletionVectorDescriptor)some.value();
                String x$2 = remove.copy$default$1();
                Option<Object> x$3 = remove.copy$default$2();
                boolean x$4 = remove.copy$default$3();
                Option<Object> x$5 = remove.copy$default$4();
                scala.collection.immutable.Map<String, String> x$6 = remove.copy$default$5();
                Option<Object> x$7 = remove.copy$default$6();
                scala.collection.immutable.Map<String, String> x$8 = remove.copy$default$7();
                Option<Object> x$9 = remove.copy$default$9();
                Option<Object> x$10 = remove.copy$default$10();
                listBuffer = newActions.$plus$eq((Object)remove.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$1, x$9, x$10));
                return newActions.toSeq();
            }
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option4 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                DeletionVectorDescriptor removeDv = (DeletionVectorDescriptor)some.value();
                if (None$.MODULE$.equals(option4)) {
                    DeletionVectorDescriptor x$11 = removeDv;
                    String x$12 = add.copy$default$1();
                    scala.collection.immutable.Map<String, String> x$13 = add.copy$default$2();
                    long x$14 = add.copy$default$3();
                    long x$15 = add.copy$default$4();
                    boolean x$16 = add.copy$default$5();
                    String x$17 = add.copy$default$6();
                    scala.collection.immutable.Map<String, String> x$18 = add.copy$default$7();
                    Option<Object> x$19 = add.copy$default$9();
                    Option<Object> x$20 = add.copy$default$10();
                    listBuffer = newActions.$plus$eq((Object)add.copy(x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$11, x$19, x$20));
                    return newActions.toSeq();
                }
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Option option = (Option)tuple2._1();
        Option option5 = (Option)tuple2._2();
        if (!(option instanceof Some)) throw new MatchError((Object)tuple2);
        Some some = (Some)option;
        DeletionVectorDescriptor removeDv = (DeletionVectorDescriptor)some.value();
        if (!(option5 instanceof Some)) throw new MatchError((Object)tuple2);
        Some some2 = (Some)option5;
        DeletionVectorDescriptor addDv = (DeletionVectorDescriptor)some2.value();
        RoaringBitmapArray removeBitmap = dvStore.read(removeDv, deltaLog.dataPath());
        RoaringBitmapArray addBitmap = dvStore.read(addDv, deltaLog.dataPath());
        RoaringBitmapArray finalRemovedRowsBitmap = this.getDeletionVectorsDiff(addBitmap, removeBitmap);
        RoaringBitmapArray finalReAddedRowsBitmap = this.getDeletionVectorsDiff(removeBitmap, addBitmap);
        DeletionVectorDescriptor finalRemovedRowsDv = DeletionVectorDescriptor$.MODULE$.inlineInLog(finalRemovedRowsBitmap.serializeAsByteArray((Enumeration.Value)RoaringBitmapArrayFormat$.MODULE$.Portable()), finalRemovedRowsBitmap.cardinality());
        DeletionVectorDescriptor finalReAddedRowsDv = DeletionVectorDescriptor$.MODULE$.inlineInLog(finalReAddedRowsBitmap.serializeAsByteArray((Enumeration.Value)RoaringBitmapArrayFormat$.MODULE$.Portable()), finalReAddedRowsBitmap.cardinality());
        DeletionVectorDescriptor x$21 = finalRemovedRowsDv;
        String x$22 = remove.copy$default$1();
        Option<Object> x$23 = remove.copy$default$2();
        boolean x$24 = remove.copy$default$3();
        Option<Object> x$25 = remove.copy$default$4();
        scala.collection.immutable.Map<String, String> x$26 = remove.copy$default$5();
        Option<Object> x$27 = remove.copy$default$6();
        scala.collection.immutable.Map<String, String> x$28 = remove.copy$default$7();
        Option<Object> x$29 = remove.copy$default$9();
        Option<Object> x$30 = remove.copy$default$10();
        newActions.$plus$eq((Object)remove.copy(x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$21, x$29, x$30));
        DeletionVectorDescriptor x$31 = finalReAddedRowsDv;
        String x$32 = add.copy$default$1();
        scala.collection.immutable.Map<String, String> x$33 = add.copy$default$2();
        long x$34 = add.copy$default$3();
        long x$35 = add.copy$default$4();
        boolean x$36 = add.copy$default$5();
        String x$37 = add.copy$default$6();
        scala.collection.immutable.Map<String, String> x$38 = add.copy$default$7();
        Option<Object> x$39 = add.copy$default$9();
        Option<Object> x$40 = add.copy$default$10();
        listBuffer = newActions.$plus$eq((Object)add.copy(x$32, x$33, x$34, x$35, x$36, x$37, x$38, x$31, x$39, x$40));
        return newActions.toSeq();
    }

    private scala.collection.immutable.Map<String, RowIndexFilterType> fileActionsToIfNotContainedRowIndexFilters(Seq<FileAction> actions) {
        return ((TraversableOnce)actions.map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.path()), (Object)RowIndexFilterType.IF_NOT_CONTAINED), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    /*
     * WARNING - void declaration
     */
    private RoaringBitmapArray getDeletionVectorsDiff(RoaringBitmapArray left, RoaringBitmapArray right) {
        void var3_3;
        RoaringBitmapArray leftCopy = left.copy();
        leftCopy.diff(right);
        return var3_3;
    }

    private static CDCReader.DeltaCDFRelation emptyCDFRelation$1(Snapshot snapshotToUse$1, DeltaBatchCDFSchemaMode schemaMode$1, SparkSession spark$1) {
        return new CDCReader.DeltaCDFRelation(null, snapshotToUse$1, schemaMode$1, spark$1){

            public RDD<Row> buildScan(String[] requiredColumns, Filter[] filters) {
                return this.sqlContext().sparkSession().sparkContext().emptyRDD(ClassTag$.MODULE$.apply(Row.class));
            }
        };
    }

    public static /* synthetic */ void $anonfun$getCDCRelation$2(ResolvedCDFVersion startingVersion$1, Object nonLocalReturnKey1$1, Snapshot snapshotToUse$1, DeltaBatchCDFSchemaMode schemaMode$1, SparkSession spark$1, ResolvedCDFVersion endingVersion) {
        if (startingVersion$1.resolvedByTimestamp() && endingVersion.resolvedByTimestamp()) {
            if (((Timestamp)startingVersion$1.timestamp().get()).after((Timestamp)endingVersion.timestamp().get())) {
                throw DeltaErrors$.MODULE$.endBeforeStartVersionInCDC(startingVersion$1.version(), endingVersion.version());
            }
            if (endingVersion.version() == startingVersion$1.version() - 1L) {
                throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)CDCReaderImpl.emptyCDFRelation$1(snapshotToUse$1, schemaMode$1, spark$1));
            }
        }
    }

    public static /* synthetic */ boolean $anonfun$getCDCRelation$3(ResolvedCDFVersion startingVersion$1, ResolvedCDFVersion x$1) {
        return x$1.version() < startingVersion$1.version();
    }

    public static /* synthetic */ boolean $anonfun$shouldSkipFileActionsInCommit$2(scala.collection.immutable.Map metrics$1, String x$4) {
        return metrics$1.get((Object)x$4).contains((Object)"0");
    }

    private static void checkBatchCdfReadSchemaIncompatibility$1(Metadata metadata, long metadataVer, boolean isSchemaChange, boolean shouldCheckSchemaToBlockBatchRead$1, SnapshotDescriptor readSchemaSnapshot$1, long start$1, long end$1) {
        if (shouldCheckSchemaToBlockBatchRead$1) {
            boolean compatible;
            boolean bl = (metadataVer <= readSchemaSnapshot$1.version() ? DeltaColumnMapping$.MODULE$.hasNoColumnMappingSchemaChanges(readSchemaSnapshot$1.metadata(), metadata) : DeltaColumnMapping$.MODULE$.hasNoColumnMappingSchemaChanges(metadata, readSchemaSnapshot$1.metadata())) && (metadataVer <= readSchemaSnapshot$1.version() ? SchemaUtils$.MODULE$.isReadCompatible(metadata.schema(), readSchemaSnapshot$1.schema(), true, SchemaUtils$.MODULE$.isReadCompatible$default$4()) : SchemaUtils$.MODULE$.isReadCompatible(readSchemaSnapshot$1.schema(), metadata.schema(), false, SchemaUtils$.MODULE$.isReadCompatible$default$4())) ? true : (compatible = false);
            if (!compatible) {
                throw DeltaErrors$.MODULE$.blockBatchCdfReadWithIncompatibleSchemaChange(start$1, end$1, readSchemaSnapshot$1.metadata().schema(), readSchemaSnapshot$1.version(), metadataVer, isSchemaChange);
            }
        }
    }

    public static /* synthetic */ boolean $anonfun$changesToDF$2(CDCReaderImpl $this, SparkSession spark$2, Action x0$2) {
        Metadata metadata;
        Action action = x0$2;
        boolean bl = action instanceof Metadata ? !$this.isCDCEnabledOnTable(metadata = (Metadata)action, spark$2) : false;
        return bl;
    }

    public static /* synthetic */ void $anonfun$changesToDF$4(ListBuffer cdcActions$1, LongRef totalFiles$1, LongRef totalBytes$1, ObjectRef commitInfo$1, Action x0$3) {
        Action action = x0$3;
        if (action instanceof AddCDCFile) {
            AddCDCFile addCDCFile = (AddCDCFile)action;
            cdcActions$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AddCDCFile[]{addCDCFile}));
            ++totalFiles$1.elem;
            totalBytes$1.elem += addCDCFile.size();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (action instanceof AddFile) {
            AddFile addFile = (AddFile)action;
            ++totalFiles$1.elem;
            totalBytes$1.elem += addFile.size();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (action instanceof RemoveFile) {
            RemoveFile removeFile = (RemoveFile)action;
            ++totalFiles$1.elem;
            totalBytes$1.elem += BoxesRunTime.unboxToLong((Object)removeFile.size().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (action instanceof CommitInfo) {
            CommitInfo commitInfo = (CommitInfo)action;
            commitInfo$1.elem = new Some((Object)commitInfo);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static /* synthetic */ void $anonfun$changesToDF$1(CDCReaderImpl $this, SparkSession spark$2, boolean useCoarseGrainedCDC$1, long start$1, long end$1, scala.collection.immutable.Map timestampsByVersion$1, LongRef totalFiles$1, LongRef totalBytes$1, ListBuffer changeFiles$1, ListBuffer addFiles$1, ListBuffer removeFiles$1, boolean shouldCheckSchemaToBlockBatchRead$1, SnapshotDescriptor readSchemaSnapshot$1, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            long v = tuple2._1$mcJ$sp();
            Seq actions = (Seq)tuple2._2();
            boolean cdcDisabled = actions.exists((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)CDCReaderImpl.$anonfun$changesToDF$2($this, spark$2, x0$2)));
            if (cdcDisabled && !useCoarseGrainedCDC$1) {
                throw DeltaErrors$.MODULE$.changeDataNotRecordedException(v, start$1, end$1);
            }
            if (v > start$1) {
                ((IterableLike)actions.collect((PartialFunction)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends Action, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 instanceof Metadata) {
                            Metadata metadata = (Metadata)A1;
                            object = metadata;
                        } else {
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Action x1) {
                        Action action = x1;
                        boolean bl = action instanceof Metadata;
                        return bl;
                    }
                }, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)metadata -> {
                    CDCReaderImpl.checkBatchCdfReadSchemaIncompatibility$1(metadata, v, true, shouldCheckSchemaToBlockBatchRead$1, readSchemaSnapshot$1, start$1, end$1);
                    return BoxedUnit.UNIT;
                });
            }
            ListBuffer cdcActions = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            Timestamp ts = (Timestamp)timestampsByVersion$1.get((Object)BoxesRunTime.boxToLong((long)v)).orNull(Predef$.MODULE$.$conforms());
            ObjectRef commitInfo2 = ObjectRef.create((Object)None$.MODULE$);
            actions.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                CDCReaderImpl.$anonfun$changesToDF$4(cdcActions, totalFiles$1, totalBytes$1, commitInfo2, x0$3);
                return BoxedUnit.UNIT;
            });
            if (cdcActions.nonEmpty() && !useCoarseGrainedCDC$1) {
                changeFiles$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CDCReader.CDCDataSpec[]{new CDCReader.CDCDataSpec(v, ts, cdcActions.toSeq(), (Option<CommitInfo>)((Option)commitInfo2.elem))}));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boolean shouldSkipIndexedFile = ((Option)commitInfo2.elem).exists((Function1 & Serializable & scala.Serializable)commitInfo -> BoxesRunTime.boxToBoolean((boolean)CDCReader$.MODULE$.shouldSkipFileActionsInCommit(commitInfo)));
                if (shouldSkipIndexedFile) {
                    addFiles$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CDCReader.CDCDataSpec[]{new CDCReader.CDCDataSpec(v, ts, Nil$.MODULE$, (Option<CommitInfo>)((Option)commitInfo2.elem))}));
                    removeFiles$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CDCReader.CDCDataSpec[]{new CDCReader.CDCDataSpec(v, ts, Nil$.MODULE$, (Option<CommitInfo>)((Option)commitInfo2.elem))}));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    Seq addActions = (Seq)actions.collect((PartialFunction)new scala.Serializable(null){
                        public static final long serialVersionUID = 0L;

                        public final <A1 extends Action, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                            AddFile addFile;
                            A1 A1 = x2;
                            Object object = A1 instanceof AddFile && (addFile = (AddFile)A1).dataChange() ? addFile : function1.apply(x2);
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Action x2) {
                            AddFile addFile;
                            Action action = x2;
                            boolean bl = action instanceof AddFile && (addFile = (AddFile)action).dataChange();
                            return bl;
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    Seq removeActions = (Seq)actions.collect((PartialFunction)new scala.Serializable(null){
                        public static final long serialVersionUID = 0L;

                        public final <A1 extends Action, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                            RemoveFile removeFile;
                            A1 A1 = x3;
                            Object object = A1 instanceof RemoveFile && (removeFile = (RemoveFile)A1).dataChange() ? removeFile : function1.apply(x3);
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Action x3) {
                            RemoveFile removeFile;
                            Action action = x3;
                            boolean bl = action instanceof RemoveFile && (removeFile = (RemoveFile)action).dataChange();
                            return bl;
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    addFiles$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CDCReader.CDCDataSpec[]{new CDCReader.CDCDataSpec(v, ts, addActions, (Option<CommitInfo>)((Option)commitInfo2.elem))}));
                    removeFiles$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CDCReader.CDCDataSpec[]{new CDCReader.CDCDataSpec(v, ts, removeActions, (Option<CommitInfo>)((Option)commitInfo2.elem))}));
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static /* synthetic */ void $anonfun$getDeletedAndAddedRows$7(Map finalAddFiles$1, scala.collection.immutable.Map addFilesMap$1, CDCReader.FilePathWithTableVersion addKey) {
        ((BufferLike)finalAddFiles$1.getOrElseUpdate((Object)new CDCReader.TableVersion(addKey), (Function0 & Serializable & scala.Serializable)() -> (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$))).append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AddFile[]{(AddFile)addFilesMap$1.apply((Object)addKey)}));
    }

    public static /* synthetic */ void $anonfun$getDeletedAndAddedRows$9(Map finalRemoveFiles$1, scala.collection.immutable.Map removeFilesMap$1, CDCReader.FilePathWithTableVersion removeKey) {
        ((BufferLike)finalRemoveFiles$1.getOrElseUpdate((Object)new CDCReader.TableVersion(removeKey), (Function0 & Serializable & scala.Serializable)() -> (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$))).append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RemoveFile[]{(RemoveFile)removeFilesMap$1.apply((Object)removeKey)}));
    }

    public static /* synthetic */ void $anonfun$getDeletedAndAddedRows$11(CDCReaderImpl $this, Map versionToCommitInfo$1, ListBuffer dfAddsAndRemoves$1, SparkSession spark$3, DeltaLog deltaLog$1, SnapshotDescriptor snapshot$1, boolean isStreaming$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        CDCReader.TableVersion tableVersion = (CDCReader.TableVersion)tuple2._1();
        ListBuffer addFiles = (ListBuffer)tuple2._2();
        Option commitInfo = versionToCommitInfo$1.get((Object)BoxesRunTime.boxToLong((long)tableVersion.version()));
        dfAddsAndRemoves$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Dataset[]{$this.scanIndex(spark$3, new CdcAddFileIndex(spark$3, (Seq<CDCReader.CDCDataSpec<AddFile>>)((Seq)new .colon.colon(new CDCReader.CDCDataSpec(tableVersion, addFiles.toSeq(), (Option<CommitInfo>)commitInfo), (List)Nil$.MODULE$)), deltaLog$1, deltaLog$1.dataPath(), snapshot$1, CdcAddFileIndex$.MODULE$.$lessinit$greater$default$6()), isStreaming$1)}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static /* synthetic */ void $anonfun$getDeletedAndAddedRows$12(CDCReaderImpl $this, Map versionToCommitInfo$1, ListBuffer dfAddsAndRemoves$1, SparkSession spark$3, DeltaLog deltaLog$1, SnapshotDescriptor snapshot$1, boolean isStreaming$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        CDCReader.TableVersion tableVersion = (CDCReader.TableVersion)tuple2._1();
        ListBuffer removeFiles = (ListBuffer)tuple2._2();
        Option commitInfo = versionToCommitInfo$1.get((Object)BoxesRunTime.boxToLong((long)tableVersion.version()));
        dfAddsAndRemoves$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Dataset[]{$this.scanIndex(spark$3, new TahoeRemoveFileIndex(spark$3, (Seq<CDCReader.CDCDataSpec<RemoveFile>>)((Seq)new .colon.colon(new CDCReader.CDCDataSpec(tableVersion, removeFiles.toSeq(), (Option<CommitInfo>)commitInfo), (List)Nil$.MODULE$)), deltaLog$1, deltaLog$1.dataPath(), snapshot$1, TahoeRemoveFileIndex$.MODULE$.$lessinit$greater$default$6()), isStreaming$1)}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static /* synthetic */ void $anonfun$processDeletionVectorActions$2(Map finalReplaceAddFiles$1, CDCReader.FilePathWithTableVersion key$1, Map finalReplaceRemoveFiles$1, FileAction x0$1) {
        FileAction fileAction = x0$1;
        if (fileAction instanceof AddFile) {
            AddFile addFile = (AddFile)fileAction;
            ((BufferLike)finalReplaceAddFiles$1.getOrElseUpdate((Object)new CDCReader.TableVersion(key$1), (Function0 & Serializable & scala.Serializable)() -> (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$))).append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AddFile[]{addFile}));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (fileAction instanceof RemoveFile) {
            RemoveFile removeFile = (RemoveFile)fileAction;
            ((BufferLike)finalReplaceRemoveFiles$1.getOrElseUpdate((Object)new CDCReader.TableVersion(key$1), (Function0 & Serializable & scala.Serializable)() -> (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$))).append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RemoveFile[]{removeFile}));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new Exception("Expecting AddFile or RemoveFile.");
        }
    }

    public static /* synthetic */ void $anonfun$processDeletionVectorActions$1(CDCReaderImpl $this, scala.collection.immutable.Map addFilesMap$2, scala.collection.immutable.Map removeFilesMap$2, DeletionVectorStore dvStore$1, DeltaLog deltaLog$2, Map finalReplaceAddFiles$1, Map finalReplaceRemoveFiles$1, CDCReader.FilePathWithTableVersion key) {
        AddFile add = (AddFile)addFilesMap$2.apply((Object)key);
        RemoveFile remove = (RemoveFile)removeFilesMap$2.apply((Object)key);
        Seq<FileAction> generatedActions = $this.generateFileActionsWithInlineDv(add, remove, dvStore$1, deltaLog$2);
        generatedActions.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            CDCReaderImpl.$anonfun$processDeletionVectorActions$2(finalReplaceAddFiles$1, key, finalReplaceRemoveFiles$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ void $anonfun$processDeletionVectorActions$5(CDCReaderImpl $this, scala.collection.immutable.Map versionToCommitInfo$2, ListBuffer dfs$1, SparkSession spark$4, DeltaLog deltaLog$2, SnapshotDescriptor snapshot$2, boolean isStreaming$2, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        CDCReader.TableVersion tableVersion = (CDCReader.TableVersion)tuple2._1();
        ListBuffer addFiles = (ListBuffer)tuple2._2();
        Option commitInfo = versionToCommitInfo$2.get((Object)BoxesRunTime.boxToLong((long)tableVersion.version()));
        dfs$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Dataset[]{$this.scanIndex(spark$4, new CdcAddFileIndex(spark$4, (Seq<CDCReader.CDCDataSpec<AddFile>>)((Seq)new .colon.colon(new CDCReader.CDCDataSpec(tableVersion, addFiles.toSeq(), (Option<CommitInfo>)commitInfo), (List)Nil$.MODULE$)), deltaLog$2, deltaLog$2.dataPath(), snapshot$2, (Option<scala.collection.immutable.Map<String, RowIndexFilterType>>)new Some($this.fileActionsToIfNotContainedRowIndexFilters((Seq<FileAction>)addFiles.toSeq()))), isStreaming$2)}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static /* synthetic */ void $anonfun$processDeletionVectorActions$6(CDCReaderImpl $this, scala.collection.immutable.Map versionToCommitInfo$2, ListBuffer dfs$1, SparkSession spark$4, DeltaLog deltaLog$2, SnapshotDescriptor snapshot$2, boolean isStreaming$2, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        CDCReader.TableVersion tableVersion = (CDCReader.TableVersion)tuple2._1();
        ListBuffer removeFiles = (ListBuffer)tuple2._2();
        Option commitInfo = versionToCommitInfo$2.get((Object)BoxesRunTime.boxToLong((long)tableVersion.version()));
        dfs$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Dataset[]{$this.scanIndex(spark$4, new TahoeRemoveFileIndex(spark$4, (Seq<CDCReader.CDCDataSpec<RemoveFile>>)((Seq)new .colon.colon(new CDCReader.CDCDataSpec(tableVersion, removeFiles.toSeq(), (Option<CommitInfo>)commitInfo), (List)Nil$.MODULE$)), deltaLog$2, deltaLog$2.dataPath(), snapshot$2, (Option<scala.collection.immutable.Map<String, RowIndexFilterType>>)new Some($this.fileActionsToIfNotContainedRowIndexFilters((Seq<FileAction>)removeFiles.toSeq()))), isStreaming$2)}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static /* synthetic */ boolean $anonfun$changesToBatchDF$1(long end$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long version = tuple2._1$mcJ$sp();
        boolean bl = version <= end$2;
        return bl;
    }

    public static void $init$(CDCReaderImpl $this) {
    }

    public class CDCVersionDiffInfo
    implements Product,
    scala.Serializable {
        private final Dataset<Row> fileChangeDf;
        private final long numFiles;
        private final long numBytes;
        public final /* synthetic */ CDCReaderImpl $outer;

        public Dataset<Row> fileChangeDf() {
            return this.fileChangeDf;
        }

        public long numFiles() {
            return this.numFiles;
        }

        public long numBytes() {
            return this.numBytes;
        }

        public CDCVersionDiffInfo copy(Dataset<Row> fileChangeDf, long numFiles, long numBytes) {
            return new CDCVersionDiffInfo(this.org$apache$spark$sql$delta$commands$cdc$CDCReaderImpl$CDCVersionDiffInfo$$$outer(), fileChangeDf, numFiles, numBytes);
        }

        public Dataset<Row> copy$default$1() {
            return this.fileChangeDf();
        }

        public long copy$default$2() {
            return this.numFiles();
        }

        public long copy$default$3() {
            return this.numBytes();
        }

        public String productPrefix() {
            return "CDCVersionDiffInfo";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.fileChangeDf();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToLong((long)this.numFiles());
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToLong((long)this.numBytes());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CDCVersionDiffInfo;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash(this.fileChangeDf()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.numFiles()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.numBytes()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CDCVersionDiffInfo)) return false;
            if (((CDCVersionDiffInfo)object).org$apache$spark$sql$delta$commands$cdc$CDCReaderImpl$CDCVersionDiffInfo$$$outer() != this.org$apache$spark$sql$delta$commands$cdc$CDCReaderImpl$CDCVersionDiffInfo$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            CDCVersionDiffInfo cDCVersionDiffInfo = (CDCVersionDiffInfo)x$1;
            Dataset<Row> dataset = this.fileChangeDf();
            Dataset<Row> dataset2 = cDCVersionDiffInfo.fileChangeDf();
            if (dataset == null) {
                if (dataset2 != null) {
                    return false;
                }
            } else if (!dataset.equals(dataset2)) return false;
            if (this.numFiles() != cDCVersionDiffInfo.numFiles()) return false;
            if (this.numBytes() != cDCVersionDiffInfo.numBytes()) return false;
            if (!cDCVersionDiffInfo.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ CDCReaderImpl org$apache$spark$sql$delta$commands$cdc$CDCReaderImpl$CDCVersionDiffInfo$$$outer() {
            return this.$outer;
        }

        public CDCVersionDiffInfo(CDCReaderImpl $outer, Dataset<Row> fileChangeDf, long numFiles, long numBytes) {
            this.fileChangeDf = fileChangeDf;
            this.numFiles = numFiles;
            this.numBytes = numBytes;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    private class ResolvedCDFVersion
    implements Product,
    scala.Serializable {
        private final long version;
        private final Option<Timestamp> timestamp;
        public final /* synthetic */ CDCReaderImpl $outer;

        public long version() {
            return this.version;
        }

        public Option<Timestamp> timestamp() {
            return this.timestamp;
        }

        public boolean resolvedByTimestamp() {
            return this.timestamp().isDefined();
        }

        public ResolvedCDFVersion copy(long version, Option<Timestamp> timestamp) {
            return new ResolvedCDFVersion(this.org$apache$spark$sql$delta$commands$cdc$CDCReaderImpl$ResolvedCDFVersion$$$outer(), version, timestamp);
        }

        public long copy$default$1() {
            return this.version();
        }

        public Option<Timestamp> copy$default$2() {
            return this.timestamp();
        }

        public String productPrefix() {
            return "ResolvedCDFVersion";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = BoxesRunTime.boxToLong((long)this.version());
                    break;
                }
                case 1: {
                    object = this.timestamp();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ResolvedCDFVersion;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.version()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.timestamp()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ResolvedCDFVersion)) return false;
            if (((ResolvedCDFVersion)object).org$apache$spark$sql$delta$commands$cdc$CDCReaderImpl$ResolvedCDFVersion$$$outer() != this.org$apache$spark$sql$delta$commands$cdc$CDCReaderImpl$ResolvedCDFVersion$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ResolvedCDFVersion resolvedCDFVersion = (ResolvedCDFVersion)x$1;
            if (this.version() != resolvedCDFVersion.version()) return false;
            Option<Timestamp> option = this.timestamp();
            Option<Timestamp> option2 = resolvedCDFVersion.timestamp();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!resolvedCDFVersion.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ CDCReaderImpl org$apache$spark$sql$delta$commands$cdc$CDCReaderImpl$ResolvedCDFVersion$$$outer() {
            return this.$outer;
        }

        public ResolvedCDFVersion(CDCReaderImpl $outer, long version, Option<Timestamp> timestamp) {
            this.version = version;
            this.timestamp = timestamp;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

