/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands.convert;

import java.io.Serializable;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.SerializableFileStatus;
import org.apache.spark.sql.delta.commands.convert.ConvertTargetFile;
import org.apache.spark.sql.delta.commands.convert.ConvertTargetFileManifest;
import org.apache.spark.sql.delta.util.DeltaFileOperations$;
import org.apache.spark.sql.delta.util.PartitionUtils$;
import org.apache.spark.util.SerializableConfiguration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001E4AAC\u0006\u00015!AA\u0003\u0001B\u0001B\u0003%q\u0005\u0003\u0005,\u0001\t\u0015\r\u0011\"\u0011-\u0011!Q\u0004A!A!\u0002\u0013i\u0003\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001f\t\u0011\u0011\u0003!\u0011!Q\u0001\n\u0015CQa\u0013\u0001\u0005\u00021C\u0001B\u0015\u0001\t\u0006\u0004%Ia\u0015\u0005\tI\u0002A)\u0019!C!K\")A\u000e\u0001C![\n\u00192)\u0019;bY><g)\u001b7f\u001b\u0006t\u0017NZ3ti*\u0011A\"D\u0001\bG>tg/\u001a:u\u0015\tqq\"\u0001\u0005d_6l\u0017M\u001c3t\u0015\t\u0001\u0012#A\u0003eK2$\u0018M\u0003\u0002\u0013'\u0005\u00191/\u001d7\u000b\u0005Q)\u0012!B:qCJ\\'B\u0001\f\u0018\u0003\u0019\t\u0007/Y2iK*\t\u0001$A\u0002pe\u001e\u001c\u0001aE\u0002\u00017\r\u0002\"\u0001H\u0011\u000e\u0003uQ!AH\u0010\u0002\t1\fgn\u001a\u0006\u0002A\u0005!!.\u0019<b\u0013\t\u0011SD\u0001\u0004PE*,7\r\u001e\t\u0003I\u0015j\u0011aC\u0005\u0003M-\u0011\u0011dQ8om\u0016\u0014H\u000fV1sO\u0016$h)\u001b7f\u001b\u0006t\u0017NZ3tiB\u0011\u0001&K\u0007\u0002#%\u0011!&\u0005\u0002\r'B\f'o[*fgNLwN\\\u0001\tE\u0006\u001cX\rU1uQV\tQ\u0006\u0005\u0002/o9\u0011q&\u000e\t\u0003aMj\u0011!\r\u0006\u0003ee\ta\u0001\u0010:p_Rt$\"\u0001\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001a\u0014A\u0002)sK\u0012,g-\u0003\u00029s\t11\u000b\u001e:j]\u001eT!AN\u001a\u0002\u0013\t\f7/\u001a)bi\"\u0004\u0013\u0001D2bi\u0006dwn\u001a+bE2,\u0007CA\u001fC\u001b\u0005q$BA A\u0003\u001d\u0019\u0017\r^1m_\u001eT!!Q\t\u0002\u0011\r\fG/\u00197zgRL!a\u0011 \u0003\u0019\r\u000bG/\u00197pOR\u000b'\r\\3\u0002!M,'/[1mSj\f'\r\\3D_:4\u0007C\u0001$J\u001b\u00059%B\u0001%\u0014\u0003\u0011)H/\u001b7\n\u0005);%!G*fe&\fG.\u001b>bE2,7i\u001c8gS\u001e,(/\u0019;j_:\fa\u0001P5oSRtD#B'O\u001fB\u000b\u0006C\u0001\u0013\u0001\u0011\u0015!b\u00011\u0001(\u0011\u0015Yc\u00011\u0001.\u0011\u0015Yd\u00011\u0001=\u0011\u0015!e\u00011\u0001F\u00035\u0001\u0018M\u001d;ji&|g\u000eT5tiV\tA\u000bE\u0002V1jk\u0011A\u0016\u0006\u0003/N\n!bY8mY\u0016\u001cG/[8o\u0013\tIfKA\u0002TKF\u0004Ba\u0017/.=6\t1'\u0003\u0002^g\t1A+\u001e9mKJ\u0002Ba\u00182.[5\t\u0001M\u0003\u0002b-\u0006I\u0011.\\7vi\u0006\u0014G.Z\u0005\u0003G\u0002\u00141!T1q\u0003!\tG\u000e\u001c$jY\u0016\u001cX#\u00014\u0011\u0007!:\u0017.\u0003\u0002i#\t9A)\u0019;bg\u0016$\bC\u0001\u0013k\u0013\tY7BA\tD_:4XM\u001d;UCJ<W\r\u001e$jY\u0016\fQa\u00197pg\u0016$\u0012A\u001c\t\u00037>L!\u0001]\u001a\u0003\tUs\u0017\u000e\u001e")
public class CatalogFileManifest
implements ConvertTargetFileManifest {
    private Seq<Tuple2<String, Map<String, String>>> partitionList;
    private Dataset<ConvertTargetFile> allFiles;
    private final SparkSession spark;
    private final String basePath;
    private final CatalogTable catalogTable;
    private final SerializableConfiguration serializableConf;
    private volatile byte bitmap$0;

    @Override
    public Iterator<ConvertTargetFile> getFiles() {
        return ConvertTargetFileManifest.getFiles$(this);
    }

    @Override
    public String basePath() {
        return this.basePath;
    }

    private Seq<Tuple2<String, Map<String, String>>> partitionList$lzycompute() {
        CatalogFileManifest catalogFileManifest = this;
        synchronized (catalogFileManifest) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Seq seq;
                if (this.catalogTable.partitionSchema().isEmpty()) {
                    seq = (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.basePath()), (Object)Predef$.MODULE$.Map().empty()), (List)Nil$.MODULE$);
                } else {
                    Seq partitions = this.spark.sessionState().catalog().listPartitions(this.catalogTable.identifier(), this.spark.sessionState().catalog().listPartitions$default$2());
                    seq = (Seq)partitions.map((Function1 & Serializable & scala.Serializable)partition -> {
                        String partitionDir = (String)partition.storage().locationUri().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                            String partitionDir = PartitionUtils$.MODULE$.getPathFragment((Map<String, String>)partition.spec(), $this.catalogTable.partitionSchema());
                            return new StringBuilder(1).append(new StringOps(Predef$.MODULE$.augmentString(this.basePath())).stripSuffix("/")).append("/").append(partitionDir).toString();
                        });
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partitionDir), (Object)partition.spec());
                    }, Seq$.MODULE$.canBuildFrom());
                }
                this.partitionList = seq;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.partitionList;
    }

    private Seq<Tuple2<String, Map<String, String>>> partitionList() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.partitionList$lzycompute() : this.partitionList;
    }

    private Dataset<ConvertTargetFile> allFiles$lzycompute() {
        CatalogFileManifest catalogFileManifest = this;
        synchronized (catalogFileManifest) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                if (this.partitionList().isEmpty()) {
                    throw DeltaErrors$.MODULE$.convertToDeltaNoPartitionFound(this.catalogTable.identifier().unquotedString());
                }
                Broadcast conf = this.spark.sparkContext().broadcast((Object)this.serializableConf, ClassTag$.MODULE$.apply(SerializableConfiguration.class));
                int parallelism = this.spark.sessionState().conf().parallelPartitionDiscoveryParallelism();
                RDD qual$1 = this.spark.sparkContext().parallelize(this.partitionList(), this.spark.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
                int x$1 = package$.MODULE$.min(parallelism, this.partitionList().length());
                Ordering x$2 = qual$1.repartition$default$2(x$1);
                RDD qual$2 = qual$1.repartition(x$1, x$2);
                Function1 & Serializable & scala.Serializable x$3 = (Function1 & Serializable & scala.Serializable)partitions -> partitions.flatMap((Function1 & Serializable & scala.Serializable)partition -> DeltaFileOperations$.MODULE$.localListDirs(((SerializableConfiguration)conf.value()).value(), (Seq<String>)((Seq)new .colon.colon((Object)((String)partition._1()), (List)Nil$.MODULE$)), false, DeltaFileOperations$.MODULE$.localListDirs$default$4(), DeltaFileOperations$.MODULE$.localListDirs$default$5()).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)CatalogFileManifest.$anonfun$allFiles$4(x$3))).map((Function1 & Serializable & scala.Serializable)x$4 -> new ConvertTargetFile((SerializableFileStatus)x$4, (Option<Map<String, String>>)new Some(partition._2()))));
                boolean x$4 = qual$2.mapPartitions$default$2();
                RDD rdd = qual$2.mapPartitions((Function1)x$3, x$4, ClassTag$.MODULE$.apply(ConvertTargetFile.class));
                this.allFiles = this.spark.createDataset(rdd, org.apache.spark.sql.delta.implicits.package$.MODULE$.convertTargetFileEncoder()).cache();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.allFiles;
    }

    @Override
    public Dataset<ConvertTargetFile> allFiles() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.allFiles$lzycompute() : this.allFiles;
    }

    @Override
    public void close() {
        this.allFiles().unpersist();
    }

    public static final /* synthetic */ boolean $anonfun$allFiles$4(SerializableFileStatus x$3) {
        return !x$3.isDir();
    }

    public CatalogFileManifest(SparkSession spark, String basePath, CatalogTable catalogTable, SerializableConfiguration serializableConf) {
        this.spark = spark;
        this.basePath = basePath;
        this.catalogTable = catalogTable;
        this.serializableConf = serializableConf;
        ConvertTargetFileManifest.$init$(this);
    }
}

