/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands.convert;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.TimeZone;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.delta.DeltaColumnMapping$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.SerializableFileStatus;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.AddFile$;
import org.apache.spark.sql.delta.commands.convert.ConvertTargetFile;
import org.apache.spark.sql.delta.commands.convert.ConvertTargetTable;
import org.apache.spark.sql.delta.commands.convert.ParquetTable;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.DateFormatter;
import org.apache.spark.sql.delta.util.DateFormatter$;
import org.apache.spark.sql.delta.util.DeltaFileOperations$;
import org.apache.spark.sql.delta.util.PartitionUtils;
import org.apache.spark.sql.delta.util.PartitionUtils$;
import org.apache.spark.sql.delta.util.TimestampFormatter;
import org.apache.spark.sql.delta.util.TimestampFormatter$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mdaB\u0007\u000f!\u0003\r\t!\b\u0005\u0006U\u0001!\ta\u000b\u0005\b_\u0001\u0011\r\u0011\"\u00011\u0011\u001dI\u0004\u00011A\u0005\u0002ABqA\u000f\u0001A\u0002\u0013\u00051\bC\u0004?\u0001\u0001\u0007I\u0011\u0001\u0019\t\u000f}\u0002\u0001\u0019!C\u0001\u0001\")!\t\u0001C\u0001\u0007\")q\u000e\u0001C\u0001a\"1q\u0010\u0001C\u0001\u0003\u0003Aq!!\u0007\u0001\t\u0003\tY\u0002C\u0005\u0002\\\u0001\t\n\u0011\"\u0001\u0002^!9\u00111\u000f\u0001\u0005\u0002\u0005U$\u0001E\"p]Z,'\u000f^+uS2\u001c()Y:f\u0015\ty\u0001#A\u0004d_:4XM\u001d;\u000b\u0005E\u0011\u0012\u0001C2p[6\fg\u000eZ:\u000b\u0005M!\u0012!\u00023fYR\f'BA\u000b\u0017\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003/a\tQa\u001d9be.T!!\u0007\u000e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0012aA8sO\u000e\u00011c\u0001\u0001\u001fIA\u0011qDI\u0007\u0002A)\t\u0011%A\u0003tG\u0006d\u0017-\u0003\u0002$A\t1\u0011I\\=SK\u001a\u0004\"!\n\u0015\u000e\u0003\u0019R!a\n\n\u0002\u00115,G/\u001a:j]\u001eL!!\u000b\u0014\u0003\u0019\u0011+G\u000e^1M_\u001e<\u0017N\\4\u0002\r\u0011Jg.\u001b;%)\u0005a\u0003CA\u0010.\u0013\tq\u0003E\u0001\u0003V]&$\u0018!\u0007;j[\u0016\u001cH/Y7q!\u0006\u0014H/\u001b;j_:\u0004\u0016\r\u001e;fe:,\u0012!\r\t\u0003e]j\u0011a\r\u0006\u0003iU\nA\u0001\\1oO*\ta'\u0001\u0003kCZ\f\u0017B\u0001\u001d4\u0005\u0019\u0019FO]5oO\u0006Q\u0012nY3cKJ<7\u000b]1sWR\u000b'\r\\3DY\u0006\u001c8\u000fU1uQ\u0006q\u0012nY3cKJ<7\u000b]1sWR\u000b'\r\\3DY\u0006\u001c8\u000fU1uQ~#S-\u001d\u000b\u0003YqBq!\u0010\u0003\u0002\u0002\u0003\u0007\u0011'A\u0002yIE\n\u0001$[2fE\u0016\u0014x\rT5c)\u0006\u0014G.Z\"mCN\u001c\b+\u0019;i\u0003qI7-\u001a2fe\u001ed\u0015N\u0019+bE2,7\t\\1tgB\u000bG\u000f[0%KF$\"\u0001L!\t\u000fu2\u0011\u0011!a\u0001c\u0005yq-\u001a;QCJ\fX/\u001a;UC\ndW\rF\u0003E\u00116Kf\r\u0005\u0002F\r6\ta\"\u0003\u0002H\u001d\t\u00112i\u001c8wKJ$H+\u0019:hKR$\u0016M\u00197f\u0011\u00159r\u00011\u0001J!\tQ5*D\u0001\u0015\u0013\taEC\u0001\u0007Ta\u0006\u00148nU3tg&|g\u000eC\u0003O\u000f\u0001\u0007q*A\u0005uCJ<W\r\u001e#jeB\u0011\u0001k\u0016\b\u0003#V\u0003\"A\u0015\u0011\u000e\u0003MS!\u0001\u0016\u000f\u0002\rq\u0012xn\u001c;?\u0013\t1\u0006%\u0001\u0004Qe\u0016$WMZ\u0005\u0003qaS!A\u0016\u0011\t\u000bi;\u0001\u0019A.\u0002\u0019\r\fG/\u00197pOR\u000b'\r\\3\u0011\u0007}af,\u0003\u0002^A\t1q\n\u001d;j_:\u0004\"a\u00183\u000e\u0003\u0001T!!\u00192\u0002\u000f\r\fG/\u00197pO*\u00111\rF\u0001\tG\u0006$\u0018\r\\=ti&\u0011Q\r\u0019\u0002\r\u0007\u0006$\u0018\r\\8h)\u0006\u0014G.\u001a\u0005\u0006O\u001e\u0001\r\u0001[\u0001\u0010a\u0006\u0014H/\u001b;j_:\u001c6\r[3nCB\u0019q\u0004X5\u0011\u0005)lW\"A6\u000b\u00051$\u0012!\u0002;za\u0016\u001c\u0018B\u00018l\u0005)\u0019FO];diRK\b/Z\u0001\u0010O\u0016$\u0018jY3cKJ<G+\u00192mKR)A)\u001d:t{\")q\u0003\u0003a\u0001\u0013\")a\n\u0003a\u0001\u001f\")A\u000f\u0003a\u0001k\u0006Q1\u000f]1sWR\u000b'\r\\3\u0011\u0007}af\u000f\u0005\u0002xw6\t\u0001P\u0003\u0002bs*\u0011!\u0010F\u0001\nG>tg.Z2u_JL!\u0001 =\u0003\u000bQ\u000b'\r\\3\t\u000byD\u0001\u0019\u00015\u0002\u0017Q\f'\r\\3TG\",W.Y\u0001\u0011O\u0016$\u0018+^1mS\u001aLW\r\u001a)bi\"$b!a\u0001\u0002\u0014\u0005U\u0001\u0003BA\u0003\u0003\u001fi!!a\u0002\u000b\t\u0005%\u00111B\u0001\u0003MNT1!!\u0004\u0019\u0003\u0019A\u0017\rZ8pa&!\u0011\u0011CA\u0004\u0005\u0011\u0001\u0016\r\u001e5\t\u000b]I\u0001\u0019A%\t\u000f\u0005]\u0011\u00021\u0001\u0002\u0004\u0005!\u0001/\u0019;i\u00035\u0019'/Z1uK\u0006#GMR5mKRq\u0011QDA\u0015\u0003g\t9$a\u0010\u0002P\u0005E\u0003\u0003BA\u0010\u0003Ki!!!\t\u000b\u0007\u0005\r\"#A\u0004bGRLwN\\:\n\t\u0005\u001d\u0012\u0011\u0005\u0002\b\u0003\u0012$g)\u001b7f\u0011\u001d\tYC\u0003a\u0001\u0003[\t!\u0002^1sO\u0016$h)\u001b7f!\r)\u0015qF\u0005\u0004\u0003cq!!E\"p]Z,'\u000f\u001e+be\u001e,GOR5mK\"9\u0011Q\u0007\u0006A\u0002\u0005\r\u0011\u0001\u00032bg\u0016\u0004\u0016\r\u001e5\t\u000f\u0005%!\u00021\u0001\u0002:A!\u0011QAA\u001e\u0013\u0011\ti$a\u0002\u0003\u0015\u0019KG.Z*zgR,W\u000eC\u0004\u0002B)\u0001\r!a\u0011\u0002\t\r|gN\u001a\t\u0005\u0003\u000b\nY%\u0004\u0002\u0002H)\u0019\u0011\u0011\n\u000b\u0002\u0011%tG/\u001a:oC2LA!!\u0014\u0002H\t91+\u0015'D_:4\u0007\"B4\u000b\u0001\u0004A\u0007\"CA*\u0015A\u0005\t\u0019AA+\u0003=)8/Z!cg>dW\u000f^3QCRD\u0007cA\u0010\u0002X%\u0019\u0011\u0011\f\u0011\u0003\u000f\t{w\u000e\\3b]\u000692M]3bi\u0016\fE\r\u001a$jY\u0016$C-\u001a4bk2$HEN\u000b\u0003\u0003?RC!!\u0016\u0002b-\u0012\u00111\r\t\u0005\u0003K\ny'\u0004\u0002\u0002h)!\u0011\u0011NA6\u0003%)hn\u00195fG.,GMC\u0002\u0002n\u0001\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\t(a\u001a\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\niS\u0012$WM\u001c#je:\u000bW.\u001a$jYR,'\u000f\u0006\u0003\u0002V\u0005]\u0004BBA=\u0019\u0001\u0007q*\u0001\u0005gS2,g*Y7f\u0001")
public interface ConvertUtilsBase
extends DeltaLogging {
    public void org$apache$spark$sql$delta$commands$convert$ConvertUtilsBase$_setter_$timestampPartitionPattern_$eq(String var1);

    public String timestampPartitionPattern();

    public String icebergSparkTableClassPath();

    public void icebergSparkTableClassPath_$eq(String var1);

    public String icebergLibTableClassPath();

    public void icebergLibTableClassPath_$eq(String var1);

    public static /* synthetic */ ConvertTargetTable getParquetTable$(ConvertUtilsBase $this, SparkSession spark, String targetDir, Option catalogTable, Option partitionSchema) {
        return $this.getParquetTable(spark, targetDir, (Option<CatalogTable>)catalogTable, (Option<StructType>)partitionSchema);
    }

    default public ConvertTargetTable getParquetTable(SparkSession spark, String targetDir, Option<CatalogTable> catalogTable, Option<StructType> partitionSchema) {
        String qualifiedDir = this.getQualifiedPath(spark, new Path(targetDir)).toString();
        return new ParquetTable(spark, qualifiedDir, catalogTable, partitionSchema);
    }

    public static /* synthetic */ ConvertTargetTable getIcebergTable$(ConvertUtilsBase $this, SparkSession spark, String targetDir, Option sparkTable, Option tableSchema) {
        return $this.getIcebergTable(spark, targetDir, (Option<Table>)sparkTable, (Option<StructType>)tableSchema);
    }

    default public ConvertTargetTable getIcebergTable(SparkSession spark, String targetDir, Option<Table> sparkTable, Option<StructType> tableSchema) {
        ConvertTargetTable convertTargetTable;
        try {
            Class clazz = Utils$.MODULE$.classForName(this.icebergSparkTableClassPath(), Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3());
            if (sparkTable.isDefined()) {
                Constructor constFromTable = clazz.getConstructor(SparkSession.class, Utils$.MODULE$.classForName(this.icebergLibTableClassPath(), Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3()), Option.class);
                Method method = sparkTable.get().getClass().getMethod("table", new Class[0]);
                convertTargetTable = (ConvertTargetTable)constFromTable.newInstance(spark, method.invoke(sparkTable.get(), new Object[0]), tableSchema);
            } else {
                String baseDir = this.getQualifiedPath(spark, new Path(targetDir)).toString();
                Constructor constFromPath = clazz.getConstructor(SparkSession.class, String.class, Option.class);
                convertTargetTable = (ConvertTargetTable)constFromPath.newInstance(spark, baseDir, tableSchema);
            }
        }
        catch (ClassNotFoundException e) {
            this.logError((Function0 & Serializable & scala.Serializable)() -> "Failed to find Iceberg class", e);
            throw DeltaErrors$.MODULE$.icebergClassMissing(spark.sparkContext().getConf(), e);
        }
        catch (InvocationTargetException e) {
            this.logError((Function0 & Serializable & scala.Serializable)() -> "Got error when creating an Iceberg Converter", e);
            throw ExceptionUtils.getRootCause((Throwable)e);
        }
        return convertTargetTable;
    }

    public static /* synthetic */ Path getQualifiedPath$(ConvertUtilsBase $this, SparkSession spark, Path path) {
        return $this.getQualifiedPath(spark, path);
    }

    default public Path getQualifiedPath(SparkSession spark, Path path) {
        Path qualifiedPath;
        Configuration sessionHadoopConf = spark.sessionState().newHadoopConf();
        FileSystem fs = path.getFileSystem(sessionHadoopConf);
        if (!fs.exists(qualifiedPath = fs.makeQualified(path))) {
            throw DeltaErrors$.MODULE$.directoryNotFoundException(qualifiedPath.toString());
        }
        return qualifiedPath;
    }

    public static /* synthetic */ AddFile createAddFile$(ConvertUtilsBase $this, ConvertTargetFile targetFile, Path basePath, FileSystem fs, SQLConf conf, Option partitionSchema, boolean useAbsolutePath) {
        return $this.createAddFile(targetFile, basePath, fs, conf, (Option<StructType>)partitionSchema, useAbsolutePath);
    }

    default public AddFile createAddFile(ConvertTargetFile targetFile, Path basePath, FileSystem fs, SQLConf conf, Option<StructType> partitionSchema, boolean useAbsolutePath) {
        String string;
        Seq partitionFields = (Seq)partitionSchema.map((Function1 & Serializable & scala.Serializable)x$1 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$1.fields())).toSeq()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
        Seq partitionColNames = (Seq)partitionSchema.map((Function1 & Serializable & scala.Serializable)x$2 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$2.fieldNames())).toSeq()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
        Seq physicalPartitionColNames = (Seq)partitionSchema.map((Function1 & Serializable & scala.Serializable)x$3 -> (Seq)x$3.map((Function1 & Serializable & scala.Serializable)f -> DeltaColumnMapping$.MODULE$.getPhysicalName((StructField)f), Seq$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
        SerializableFileStatus file = targetFile.fileStatus();
        Path path = file.getHadoopPath();
        Map partition = (Map)targetFile.partitionValues().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            Option partitionOpt;
            String pathStr = file.getHadoopPath().toUri().toString();
            DateFormatter dateFormatter = DateFormatter$.MODULE$.apply();
            TimestampFormatter timestampFormatter = TimestampFormatter$.MODULE$.apply(this.timestampPartitionPattern(), TimeZone.getDefault());
            Function2 resolver = conf.resolver();
            Path dir = file.isDir() ? file.getHadoopPath() : file.getHadoopPath().getParent();
            Tuple2<Option<PartitionUtils.PartitionValues>, Option<Path>> tuple2 = PartitionUtils$.MODULE$.parsePartition(dir, false, (Set<Path>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{basePath}))), (Map<String, DataType>)Predef$.MODULE$.Map().empty(), false, TimeZone.getDefault(), dateFormatter, timestampFormatter);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Option option = partitionOpt = (Option)tuple2._1();
            Option partitionOpt2 = option;
            return (Map)partitionOpt2.map((Function1 & Serializable & scala.Serializable)partValues -> {
                if (partitionColNames.size() != partValues.columnNames().size()) {
                    throw DeltaErrors$.MODULE$.unexpectedNumPartitionColumnsFromFileNameException(pathStr, partValues.columnNames(), (Seq<String>)partitionColNames);
                }
                Option tz = Option$.MODULE$.apply((Object)conf.sessionLocalTimeZone());
                if (!BoxesRunTime.unboxToBoolean((Object)conf.getConf(DeltaSQLConf$.MODULE$.DELTA_CONVERT_PARTITION_VALUES_IGNORE_CAST_FAILURE()))) {
                    ((IterableLike)partValues.literals().zip((GenIterable)partitionFields, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        ConvertUtilsBase.$anonfun$createAddFile$10(tz, x0$1);
                        return BoxedUnit.UNIT;
                    });
                }
                Seq values = (Seq)((TraversableLike)partValues.literals().map((Function1 & Serializable & scala.Serializable)l -> {
                    Cast qual$3 = Cast$.MODULE$.apply((Expression)l, (DataType)StringType$.MODULE$, tz, false);
                    InternalRow x$3 = qual$3.eval$default$1();
                    return qual$3.eval(x$3);
                }, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$5 -> (String)Option$.MODULE$.apply(x$5).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.toString()).orNull(Predef$.MODULE$.$conforms()), Seq$.MODULE$.canBuildFrom());
                ((IterableLike)partitionColNames.zip(partValues.columnNames(), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    ConvertUtilsBase.$anonfun$createAddFile$15(resolver, pathStr, x0$2);
                    return BoxedUnit.UNIT;
                });
                return ((TraversableOnce)physicalPartitionColNames.zip((GenIterable)values, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                if (partitionColNames.nonEmpty()) {
                    throw DeltaErrors$.MODULE$.unexpectedNumPartitionColumnsFromFileNameException(pathStr, (Seq<String>)((Seq)Nil$.MODULE$), (Seq<String>)partitionColNames);
                }
                return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            });
        });
        if (!useAbsolutePath) {
            Path relativePath = DeltaFileOperations$.MODULE$.tryRelativizePath(fs, basePath, path, DeltaFileOperations$.MODULE$.tryRelativizePath$default$4());
            Predef$.MODULE$.assert(!relativePath.isAbsolute(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Fail to relativize path ").append(path).append(" against base path ").append(basePath).append(".").toString());
            string = relativePath.toUri().toString();
        } else {
            string = path.toUri().toString();
        }
        String pathStrForAddFile = string;
        return new AddFile(pathStrForAddFile, (Map<String, String>)partition, file.length(), file.modificationTime(), true, AddFile$.MODULE$.apply$default$6(), AddFile$.MODULE$.apply$default$7(), AddFile$.MODULE$.apply$default$8(), AddFile$.MODULE$.apply$default$9(), AddFile$.MODULE$.apply$default$10());
    }

    public static /* synthetic */ boolean createAddFile$default$6$(ConvertUtilsBase $this) {
        return $this.createAddFile$default$6();
    }

    default public boolean createAddFile$default$6() {
        return false;
    }

    public static /* synthetic */ boolean hiddenDirNameFilter$(ConvertUtilsBase $this, String fileName) {
        return $this.hiddenDirNameFilter(fileName);
    }

    default public boolean hiddenDirNameFilter(String fileName) {
        return DeltaFileOperations$.MODULE$.defaultHiddenFileFilter(fileName) && !fileName.contains("=");
    }

    public static /* synthetic */ void $anonfun$createAddFile$10(Option tz$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            InternalRow x$1;
            Cast qual$1;
            Literal literal = (Literal)tuple2._1();
            StructField field = (StructField)tuple2._2();
            if (literal.eval(literal.eval$default$1()) != null && (qual$1 = Cast$.MODULE$.apply((Expression)literal, field.dataType(), tz$1, false)).eval(x$1 = qual$1.eval$default$1()) == null) {
                Cast qual$2 = Cast$.MODULE$.apply((Expression)literal, (DataType)StringType$.MODULE$, tz$1, false);
                InternalRow x$2 = qual$2.eval$default$1();
                Object partitionValue = qual$2.eval(x$2);
                String partitionValueStr = (String)Option$.MODULE$.apply(partitionValue).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toString()).orNull(Predef$.MODULE$.$conforms());
                throw DeltaErrors$.MODULE$.castPartitionValueException(partitionValueStr, field.dataType());
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static /* synthetic */ void $anonfun$createAddFile$15(Function2 resolver$1, String pathStr$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String parsed;
            String expected = (String)tuple2._1();
            if (!BoxesRunTime.unboxToBoolean((Object)resolver$1.apply((Object)expected, (Object)(parsed = (String)tuple2._2())))) {
                throw DeltaErrors$.MODULE$.unexpectedPartitionColumnFromFileNameException(pathStr$1, parsed, expected);
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static void $init$(ConvertUtilsBase $this) {
        $this.org$apache$spark$sql$delta$commands$convert$ConvertUtilsBase$_setter_$timestampPartitionPattern_$eq("yyyy-MM-dd HH:mm:ss[.S]");
        $this.icebergSparkTableClassPath_$eq("org.apache.spark.sql.delta.commands.convert.IcebergTable");
        $this.icebergLibTableClassPath_$eq("org.apache.iceberg.Table");
    }
}

