/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.files;

import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.delta.DeltaColumnMapping$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.RowIndexFilterType;
import org.apache.spark.sql.delta.SnapshotDescriptor;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.files.SupportsRowIndexFilters;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.PartitionDirectory;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005ud!B\n\u0015\u0003\u0003\t\u0003\u0002C\u000e\u0001\u0005\u000b\u0007I\u0011\u0001\u001d\t\u0011u\u0002!\u0011!Q\u0001\neB\u0001B\u0010\u0001\u0003\u0006\u0004%\te\u0010\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005\u0001\"AA\t\u0001BC\u0002\u0013\u0005Q\t\u0003\u0005O\u0001\t\u0005\t\u0015!\u0003G\u0011\u0015y\u0005\u0001\"\u0001Q\u0011\u0015)\u0006\u0001\"\u0011W\u0011\u0015\u0019\u0007A\"\u0001e\u0011\u0015I\b\u0001\"\u0011{\u0011\u001d\t\u0019\u0001\u0001C\u0005\u0003\u000bAq!a\t\u0001\t\u0013\t)\u0003C\u0004\u00024\u0001!\t\"!\u000e\t\u000f\u0005\u0005\u0003\u0001\"\u0011\u0002D!9\u0011\u0011\u000b\u0001\u0005\u0012\u0005M\u0003bBA-\u0001\u0011\u0005\u00131\f\u0005\b\u0003;\u0002A\u0011BA0\u0011\u001d\ty\u0007\u0001C\u0001\u0003c\u0012a\u0002V1i_\u00164\u0015\u000e\\3J]\u0012,\u0007P\u0003\u0002\u0016-\u0005)a-\u001b7fg*\u0011q\u0003G\u0001\u0006I\u0016dG/\u0019\u0006\u00033i\t1a]9m\u0015\tYB$A\u0003ta\u0006\u00148N\u0003\u0002\u001e=\u00051\u0011\r]1dQ\u0016T\u0011aH\u0001\u0004_J<7\u0001A\n\u0006\u0001\tB\u0003\u0007\u000e\t\u0003G\u0019j\u0011\u0001\n\u0006\u0002K\u0005)1oY1mC&\u0011q\u0005\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0005%rS\"\u0001\u0016\u000b\u0005-b\u0013a\u00033bi\u0006\u001cx.\u001e:dKNT!!\f\r\u0002\u0013\u0015DXmY;uS>t\u0017BA\u0018+\u0005%1\u0015\u000e\\3J]\u0012,\u0007\u0010\u0005\u00022e5\tA#\u0003\u00024)\t92+\u001e9q_J$8OU8x\u0013:$W\r\u001f$jYR,'o\u001d\t\u0003kYj\u0011AF\u0005\u0003oY\u0011!c\u00158baNDw\u000e\u001e#fg\u000e\u0014\u0018\u000e\u001d;peV\t\u0011\b\u0005\u0002;w5\t\u0001$\u0003\u0002=1\ta1\u000b]1sWN+7o]5p]\u000611\u000f]1sW\u0002\n\u0001\u0002Z3mi\u0006dunZ\u000b\u0002\u0001B\u0011Q'Q\u0005\u0003\u0005Z\u0011\u0001\u0002R3mi\u0006dunZ\u0001\nI\u0016dG/\u0019'pO\u0002\nA\u0001]1uQV\ta\t\u0005\u0002H\u00196\t\u0001J\u0003\u0002J\u0015\u0006\u0011am\u001d\u0006\u0003\u0017r\ta\u0001[1e_>\u0004\u0018BA'I\u0005\u0011\u0001\u0016\r\u001e5\u0002\u000bA\fG\u000f\u001b\u0011\u0002\rqJg.\u001b;?)\u0011\t&k\u0015+\u0011\u0005E\u0002\u0001\"B\u000e\b\u0001\u0004I\u0004\"\u0002 \b\u0001\u0004\u0001\u0005\"\u0002#\b\u0001\u00041\u0015!\u0003:p_R\u0004\u0016\r\u001e5t+\u00059\u0006c\u0001-a\r:\u0011\u0011L\u0018\b\u00035vk\u0011a\u0017\u0006\u00039\u0002\na\u0001\u0010:p_Rt\u0014\"A\u0013\n\u0005}#\u0013a\u00029bG.\fw-Z\u0005\u0003C\n\u00141aU3r\u0015\tyF%A\u0007nCR\u001c\u0007.\u001b8h\r&dWm\u001d\u000b\u0004K2<\bc\u0001-aMB\u0011qM[\u0007\u0002Q*\u0011\u0011NF\u0001\bC\u000e$\u0018n\u001c8t\u0013\tY\u0007NA\u0004BI\u00124\u0015\u000e\\3\t\u000b5L\u0001\u0019\u00018\u0002!A\f'\u000f^5uS>tg)\u001b7uKJ\u001c\bc\u0001-a_B\u0011\u0001/^\u0007\u0002c*\u0011!o]\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002u1\u0005A1-\u0019;bYf\u001cH/\u0003\u0002wc\nQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u000baL\u0001\u0019\u00018\u0002\u0017\u0011\fG/\u0019$jYR,'o]\u0001\nY&\u001cHOR5mKN$Ba_@\u0002\u0002A\u0019\u0001\f\u0019?\u0011\u0005%j\u0018B\u0001@+\u0005I\u0001\u0016M\u001d;ji&|g\u000eR5sK\u000e$xN]=\t\u000b5T\u0001\u0019\u00018\t\u000baT\u0001\u0019\u00018\u0002\u00191L7\u000f^!eI\u001aKG.Z:\u0015\r\u0005\u001d\u0011qDA\u0011!\u001d\tI!!\u0005\u0002\u0018\u0015tA!a\u0003\u0002\u000eA\u0011!\fJ\u0005\u0004\u0003\u001f!\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0014\u0005U!aA'ba*\u0019\u0011q\u0002\u0013\u0011\u0011\u0005%\u0011\u0011CA\r\u00033\u0001B!!\u0003\u0002\u001c%!\u0011QDA\u000b\u0005\u0019\u0019FO]5oO\")Qn\u0003a\u0001]\")\u0001p\u0003a\u0001]\u0006AR.Y6f!\u0006\u0014H/\u001b;j_:$\u0015N]3di>\u0014\u0018.Z:\u0015\u0007m\f9\u0003C\u0004\u0002*1\u0001\r!a\u000b\u0002-A\f'\u000f^5uS>tg+\u00197vKN$vNR5mKN\u0004B\u0001\u00171\u0002.A11%a\f\u0002\u0018\u0015L1!!\r%\u0005\u0019!V\u000f\u001d7fe\u0005)r-\u001a;QCJ$\u0018\u000e^5p]Z\u000bG.^3t%><H\u0003BA\u001c\u0003{\u00012\u0001]A\u001d\u0013\r\tY$\u001d\u0002\u0013\u000f\u0016tWM]5d\u0013:$XM\u001d8bYJ{w\u000fC\u0004\u0002@5\u0001\r!a\u0006\u0002\u001fA\f'\u000f^5uS>tg+\u00197vKN\fq\u0002]1si&$\u0018n\u001c8TG\",W.Y\u000b\u0003\u0003\u000b\u0002B!a\u0012\u0002N5\u0011\u0011\u0011\n\u0006\u0004\u0003\u0017B\u0012!\u0002;za\u0016\u001c\u0018\u0002BA(\u0003\u0013\u0012!b\u0015;sk\u000e$H+\u001f9f\u00031\t'm]8mkR,\u0007+\u0019;i)\r1\u0015Q\u000b\u0005\b\u0003/z\u0001\u0019AA\r\u0003\u0015\u0019\u0007.\u001b7e\u0003!!xn\u0015;sS:<GCAA\r\u00035!(/\u001e8dCR,'+[4iiR1\u0011\u0011DA1\u0003KBq!a\u0019\u0012\u0001\u0004\tI\"A\u0003j]B,H\u000fC\u0004\u0002hE\u0001\r!!\u001b\u0002\u00071,g\u000eE\u0002$\u0003WJ1!!\u001c%\u0005\rIe\u000e^\u0001\fO\u0016$()Y:f!\u0006$\b\u000e\u0006\u0003\u0002t\u0005e\u0004\u0003B\u0012\u0002v\u0019K1!a\u001e%\u0005\u0019y\u0005\u000f^5p]\"1\u00111\u0010\nA\u0002\u0019\u000b\u0001BZ5mKB\u000bG\u000f\u001b")
public abstract class TahoeFileIndex
implements FileIndex,
SupportsRowIndexFilters,
SnapshotDescriptor {
    private final SparkSession spark;
    private final DeltaLog deltaLog;
    private final Path path;

    @Override
    public StructType schema() {
        return SnapshotDescriptor.schema$(this);
    }

    @Override
    public Option<Map<String, RowIndexFilterType>> rowIndexFilters() {
        return SupportsRowIndexFilters.rowIndexFilters$(this);
    }

    public Option<Object> metadataOpsTimeNs() {
        return FileIndex.metadataOpsTimeNs$((FileIndex)this);
    }

    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public DeltaLog deltaLog() {
        return this.deltaLog;
    }

    public Path path() {
        return this.path;
    }

    public Seq<Path> rootPaths() {
        Path path = this.path();
        return Nil$.MODULE$.$colon$colon((Object)path);
    }

    public abstract Seq<AddFile> matchingFiles(Seq<Expression> var1, Seq<Expression> var2);

    public Seq<PartitionDirectory> listFiles(Seq<Expression> partitionFilters, Seq<Expression> dataFilters) {
        Map<Map<String, String>, Seq<AddFile>> partitionValuesToFiles = this.listAddFiles(partitionFilters, dataFilters);
        return this.makePartitionDirectories((Seq<Tuple2<Map<String, String>, Seq<AddFile>>>)partitionValuesToFiles.toSeq());
    }

    private Map<Map<String, String>, Seq<AddFile>> listAddFiles(Seq<Expression> partitionFilters, Seq<Expression> dataFilters) {
        return this.matchingFiles(partitionFilters, dataFilters).groupBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.partitionValues());
    }

    private Seq<PartitionDirectory> makePartitionDirectories(Seq<Tuple2<Map<String, String>, Seq<AddFile>>> partitionValuesToFiles) {
        String timeZone = this.spark().sessionState().conf().sessionLocalTimeZone();
        return (Seq)partitionValuesToFiles.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Map partitionValues = (Map)tuple2._1();
            Seq files = (Seq)tuple2._2();
            GenericInternalRow partitionValuesRow = this.getPartitionValuesRow((Map<String, String>)partitionValues);
            FileStatus[] fileStatuses = (FileStatus[])((TraversableOnce)files.map((Function1 & Serializable & scala.Serializable)f -> new FileStatus(f.size(), false, 0, 1L, f.modificationTime(), this.absolutePath(f.path())), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(FileStatus.class));
            PartitionDirectory partitionDirectory = new PartitionDirectory((InternalRow)partitionValuesRow, (Seq)Predef$.MODULE$.wrapRefArray((Object[])fileStatuses));
            return partitionDirectory;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public GenericInternalRow getPartitionValuesRow(Map<String, String> partitionValues) {
        String timeZone = this.spark().sessionState().conf().sessionLocalTimeZone();
        Object[] partitionRowValues = (Object[])((TraversableOnce)this.partitionSchema().map((Function1 & Serializable & scala.Serializable)p -> {
            String colName = DeltaColumnMapping$.MODULE$.getPhysicalName((StructField)p);
            Literal partValue = Literal$.MODULE$.apply(partitionValues.get((Object)colName).orNull(Predef$.MODULE$.$conforms()));
            Cast qual$1 = Cast$.MODULE$.apply((Expression)partValue, p.dataType(), Option$.MODULE$.apply((Object)timeZone), false);
            InternalRow x$1 = qual$1.eval$default$1();
            return qual$1.eval(x$1);
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Any());
        return new GenericInternalRow(partitionRowValues);
    }

    public StructType partitionSchema() {
        return this.metadata().partitionSchema();
    }

    public Path absolutePath(String child) {
        Path p = new Path(new URI(child));
        return p.isAbsolute() ? p : new Path(this.path(), p);
    }

    public String toString() {
        String truncatedPath = this.truncateRight(this.path().toString(), 100);
        return new StringBuilder(17).append("Delta[version=").append(this.version()).append(", ").append(truncatedPath).append("]").toString();
    }

    private String truncateRight(String input, int len) {
        return input.length() > len ? new StringBuilder(4).append("... ").append(new StringOps(Predef$.MODULE$.augmentString(input)).takeRight(len)).toString() : input;
    }

    public Option<Path> getBasePath(Path filePath) {
        return new Some((Object)this.path());
    }

    public TahoeFileIndex(SparkSession spark, DeltaLog deltaLog, Path path) {
        this.spark = spark;
        this.deltaLog = deltaLog;
        this.path = path;
        FileIndex.$init$((FileIndex)this);
        SupportsRowIndexFilters.$init$(this);
        SnapshotDescriptor.$init$(this);
    }
}

