/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.sources;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import java.util.Set;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaLog$;
import org.apache.spark.sql.delta.DeltaOperations;
import org.apache.spark.sql.delta.DeltaOptions;
import org.apache.spark.sql.delta.DeltaTable$;
import org.apache.spark.sql.delta.OptimisticTransaction;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.FileAction;
import org.apache.spark.sql.delta.actions.SetTransaction;
import org.apache.spark.sql.delta.files.TahoeFileIndex;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.schema.ImplicitMetadataOperation;
import org.apache.spark.sql.delta.schema.SchemaUtils$;
import org.apache.spark.sql.delta.sources.DeltaSink$PendingTxn$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.metric.SQLMetrics$;
import org.apache.spark.sql.execution.streaming.Sink;
import org.apache.spark.sql.execution.streaming.StreamExecution$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t]f\u0001B\u001a5\u0001\u0005C\u0001B\u0018\u0001\u0003\u0002\u0003\u0006Ia\u0018\u0005\tG\u0002\u0011\t\u0011)A\u0005I\"AA\u000e\u0001B\u0001B\u0003%Q\u000e\u0003\u0006\u0002\b\u0001\u0011\t\u0011)A\u0005\u0003\u0013A!\"a\u0005\u0001\u0005\u0003\u0005\u000b\u0011BA\u000b\u0011\u001d\ti\u0002\u0001C\u0001\u0003?A\u0011\"a\f\u0001\u0005\u0004%I!!\r\t\u0011\u0005e\u0002\u0001)A\u0005\u0003gA\u0011\"a\u000f\u0001\u0005\u0004%I!!\u0010\t\u0011\u0005-\u0003\u0001)A\u0005\u0003\u007fA!\"!\u0014\u0001\u0011\u000b\u0007I\u0011AA(\u0011%\t\t\u0006\u0001b\u0001\n#\n\u0019\u0006\u0003\u0005\u0002^\u0001\u0001\u000b\u0011BA+\u0011%\ty\u0006\u0001b\u0001\n#\n\u0019\u0006\u0003\u0005\u0002b\u0001\u0001\u000b\u0011BA+\r\u0019\t\u0019\u0007\u0001!\u0002f!Q\u0011\u0011\u0010\t\u0003\u0016\u0004%\t!a\u001f\t\u0015\u0005\r\u0005C!E!\u0002\u0013\ti\b\u0003\u0006\u0002\u0006B\u0011)\u001a!C\u0001\u0003\u000fC!\"a$\u0011\u0005#\u0005\u000b\u0011BAE\u0011)\t\t\n\u0005BK\u0002\u0013\u0005\u00111\u0013\u0005\u000b\u0003o\u0003\"\u0011#Q\u0001\n\u0005U\u0005BCA]!\tU\r\u0011\"\u0001\u0002<\"Q\u00111\u001a\t\u0003\u0012\u0003\u0006I!!0\t\u0015\u00055\u0007C!f\u0001\n\u0003\tY\f\u0003\u0006\u0002PB\u0011\t\u0012)A\u0005\u0003{Cq!!\b\u0011\t\u0003\t\t\u000eC\u0004\u0002bB!\t!a9\t\u0013\u0005-\b#!A\u0005\u0002\u00055\b\"CA}!E\u0005I\u0011AA~\u0011%\u0011\t\u0002EI\u0001\n\u0003\u0011\u0019\u0002C\u0005\u0003\u0018A\t\n\u0011\"\u0001\u0003\u001a!I!Q\u0004\t\u0012\u0002\u0013\u0005!q\u0004\u0005\n\u0005G\u0001\u0012\u0013!C\u0001\u0005?A\u0011B!\n\u0011\u0003\u0003%\tEa\n\t\u0013\t5\u0002#!A\u0005\u0002\t=\u0002\"\u0003B\u001c!\u0005\u0005I\u0011\u0001B\u001d\u0011%\u0011)\u0005EA\u0001\n\u0003\u00129\u0005C\u0005\u0003VA\t\t\u0011\"\u0001\u0003X!I!1\f\t\u0002\u0002\u0013\u0005#Q\f\u0005\n\u0005?\u0002\u0012\u0011!C!\u0005CB\u0011Ba\u0019\u0011\u0003\u0003%\tE!\u001a\b\u0013\t%\u0004!!A\t\u0002\t-d!CA2\u0001\u0005\u0005\t\u0012\u0001B7\u0011\u001d\ti\u0002\fC\u0001\u0005wB\u0011Ba\u0018-\u0003\u0003%)E!\u0019\t\u0013\tuD&!A\u0005\u0002\n}\u0004\"\u0003BFY\u0005\u0005I\u0011\u0011BG\u0011\u001d\u0011y\n\u0001C!\u0005CCqAa\u0018\u0001\t\u0003\u0012)LA\u0005EK2$\u0018mU5oW*\u0011QGN\u0001\bg>,(oY3t\u0015\t9\u0004(A\u0003eK2$\u0018M\u0003\u0002:u\u0005\u00191/\u001d7\u000b\u0005mb\u0014!B:qCJ\\'BA\u001f?\u0003\u0019\t\u0007/Y2iK*\tq(A\u0002pe\u001e\u001c\u0001aE\u0003\u0001\u0005*\u0013\u0006\f\u0005\u0002D\u00116\tAI\u0003\u0002F\r\u0006!A.\u00198h\u0015\u00059\u0015\u0001\u00026bm\u0006L!!\u0013#\u0003\r=\u0013'.Z2u!\tY\u0005+D\u0001M\u0015\tie*A\u0005tiJ,\u0017-\\5oO*\u0011q\nO\u0001\nKb,7-\u001e;j_:L!!\u0015'\u0003\tMKgn\u001b\t\u0003'Zk\u0011\u0001\u0016\u0006\u0003+Z\naa]2iK6\f\u0017BA,U\u0005eIU\u000e\u001d7jG&$X*\u001a;bI\u0006$\u0018m\u00149fe\u0006$\u0018n\u001c8\u0011\u0005ecV\"\u0001.\u000b\u0005m3\u0014\u0001C7fi\u0016\u0014\u0018N\\4\n\u0005uS&\u0001\u0004#fYR\fGj\\4hS:<\u0017AC:rY\u000e{g\u000e^3yiB\u0011\u0001-Y\u0007\u0002q%\u0011!\r\u000f\u0002\u000b'Fc5i\u001c8uKb$\u0018\u0001\u00029bi\"\u0004\"!\u001a6\u000e\u0003\u0019T!a\u001a5\u0002\u0005\u0019\u001c(BA5=\u0003\u0019A\u0017\rZ8pa&\u00111N\u001a\u0002\u0005!\u0006$\b.\u0001\tqCJ$\u0018\u000e^5p]\u000e{G.^7ogB\u0019a\u000e_>\u000f\u0005=,hB\u00019t\u001b\u0005\t(B\u0001:A\u0003\u0019a$o\\8u}%\tA/A\u0003tG\u0006d\u0017-\u0003\u0002wo\u00069\u0001/Y2lC\u001e,'\"\u0001;\n\u0005eT(aA*fc*\u0011ao\u001e\t\u0004y\u0006\u0005aBA?\u007f!\t\u0001x/\u0003\u0002\u0000o\u00061\u0001K]3eK\u001aLA!a\u0001\u0002\u0006\t11\u000b\u001e:j]\u001eT!a`<\u0002\u0015=,H\u000f];u\u001b>$W\r\u0005\u0003\u0002\f\u0005=QBAA\u0007\u0015\ti\u0005(\u0003\u0003\u0002\u0012\u00055!AC(viB,H/T8eK\u00069q\u000e\u001d;j_:\u001c\b\u0003BA\f\u00033i\u0011AN\u0005\u0004\u000371$\u0001\u0004#fYR\fw\n\u001d;j_:\u001c\u0018A\u0002\u001fj]&$h\b\u0006\u0007\u0002\"\u0005\u0015\u0012qEA\u0015\u0003W\ti\u0003E\u0002\u0002$\u0001i\u0011\u0001\u000e\u0005\u0006=\u001a\u0001\ra\u0018\u0005\u0006G\u001a\u0001\r\u0001\u001a\u0005\u0006Y\u001a\u0001\r!\u001c\u0005\b\u0003\u000f1\u0001\u0019AA\u0005\u0011\u001d\t\u0019B\u0002a\u0001\u0003+\t\u0001\u0002Z3mi\u0006dunZ\u000b\u0003\u0003g\u0001B!a\u0006\u00026%\u0019\u0011q\u0007\u001c\u0003\u0011\u0011+G\u000e^1M_\u001e\f\u0011\u0002Z3mi\u0006dun\u001a\u0011\u0002\u000fM\fHnQ8oMV\u0011\u0011q\b\t\u0005\u0003\u0003\n9%\u0004\u0002\u0002D)\u0019\u0011Q\t\u001d\u0002\u0011%tG/\u001a:oC2LA!!\u0013\u0002D\t91+\u0015'D_:4\u0017\u0001C:rY\u000e{gN\u001a\u0011\u0002\u000fE,XM]=JIV\t10\u0001\ndC:|e/\u001a:xe&$XmU2iK6\fWCAA+!\u0011\t9&!\u0017\u000e\u0003]L1!a\u0017x\u0005\u001d\u0011un\u001c7fC:\f1cY1o\u001fZ,'o\u001e:ji\u0016\u001c6\r[3nC\u0002\nabY1o\u001b\u0016\u0014x-Z*dQ\u0016l\u0017-A\bdC:lUM]4f'\u000eDW-\\1!\u0005)\u0001VM\u001c3j]\u001e$\u0006P\\\n\b!\u0005\u001d\u0014QNA:!\u0011\t9&!\u001b\n\u0007\u0005-tO\u0001\u0004B]f\u0014VM\u001a\t\u0005\u0003/\ny'C\u0002\u0002r]\u0014q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u0002X\u0005U\u0014bAA<o\na1+\u001a:jC2L'0\u00192mK\u00069!-\u0019;dQ&#WCAA?!\u0011\t9&a \n\u0007\u0005\u0005uO\u0001\u0003M_:<\u0017\u0001\u00032bi\u000eD\u0017\n\u001a\u0011\u0002+=\u0004H/[7jgRL7\r\u0016:b]N\f7\r^5p]V\u0011\u0011\u0011\u0012\t\u0005\u0003/\tY)C\u0002\u0002\u000eZ\u0012Qc\u00149uS6L7\u000f^5d)J\fgn]1di&|g.\u0001\fpaRLW.[:uS\u000e$&/\u00198tC\u000e$\u0018n\u001c8!\u0003=\u0019HO]3b[&tw-\u00169eCR,WCAAK!\u0011\t9*!-\u000f\t\u0005e\u0015Q\u0016\b\u0005\u00037\u000bYK\u0004\u0003\u0002\u001e\u0006%f\u0002BAP\u0003OsA!!)\u0002&:\u0019\u0001/a)\n\u0003}J!!\u0010 \n\u0005mb\u0014BA\u001d;\u0013\t9\u0004(C\u0002\u00020Z\nq\u0002R3mi\u0006|\u0005/\u001a:bi&|gn]\u0005\u0005\u0003g\u000b)LA\bTiJ,\u0017-\\5oOV\u0003H-\u0019;f\u0015\r\tyKN\u0001\u0011gR\u0014X-Y7j]\u001e,\u0006\u000fZ1uK\u0002\n\u0001B\\3x\r&dWm]\u000b\u0003\u0003{\u0003BA\u001c=\u0002@B!\u0011\u0011YAd\u001b\t\t\u0019MC\u0002\u0002FZ\nq!Y2uS>t7/\u0003\u0003\u0002J\u0006\r'A\u0003$jY\u0016\f5\r^5p]\u0006Ia.Z<GS2,7\u000fI\u0001\rI\u0016dW\r^3e\r&dWm]\u0001\u000eI\u0016dW\r^3e\r&dWm\u001d\u0011\u0015\u0019\u0005M\u0017q[Am\u00037\fi.a8\u0011\u0007\u0005U\u0007#D\u0001\u0001\u0011\u001d\tIh\u0007a\u0001\u0003{Bq!!\"\u001c\u0001\u0004\tI\tC\u0004\u0002\u0012n\u0001\r!!&\t\u000f\u0005e6\u00041\u0001\u0002>\"9\u0011QZ\u000eA\u0002\u0005u\u0016AB2p[6LG\u000f\u0006\u0002\u0002fB!\u0011qKAt\u0013\r\tIo\u001e\u0002\u0005+:LG/\u0001\u0003d_BLH\u0003DAj\u0003_\f\t0a=\u0002v\u0006]\b\"CA=;A\u0005\t\u0019AA?\u0011%\t))\bI\u0001\u0002\u0004\tI\tC\u0005\u0002\u0012v\u0001\n\u00111\u0001\u0002\u0016\"I\u0011\u0011X\u000f\u0011\u0002\u0003\u0007\u0011Q\u0018\u0005\n\u0003\u001bl\u0002\u0013!a\u0001\u0003{\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002~*\"\u0011QPA\u0000W\t\u0011\t\u0001\u0005\u0003\u0003\u0004\t5QB\u0001B\u0003\u0015\u0011\u00119A!\u0003\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u0006o\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t=!Q\u0001\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0005+QC!!#\u0002\u0000\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTC\u0001B\u000eU\u0011\t)*a@\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!\u0011\u0005\u0016\u0005\u0003{\u000by0\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001b\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0011I\u0003E\u0002D\u0005WI1!a\u0001E\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\u0011\t\u0004\u0005\u0003\u0002X\tM\u0012b\u0001B\u001bo\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!1\bB!!\u0011\t9F!\u0010\n\u0007\t}rOA\u0002B]fD\u0011Ba\u0011&\u0003\u0003\u0005\rA!\r\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011I\u0005\u0005\u0004\u0003L\tE#1H\u0007\u0003\u0005\u001bR1Aa\u0014x\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005'\u0012iE\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA+\u00053B\u0011Ba\u0011(\u0003\u0003\u0005\rAa\u000f\u0002\u0011!\f7\u000f[\"pI\u0016$\"A!\r\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"A!\u000b\u0002\r\u0015\fX/\u00197t)\u0011\t)Fa\u001a\t\u0013\t\r#&!AA\u0002\tm\u0012A\u0003)f]\u0012Lgn\u001a+y]B\u0019\u0011Q\u001b\u0017\u0014\u000b1\u0012y'a\u001d\u0011!\tE$qOA?\u0003\u0013\u000b)*!0\u0002>\u0006MWB\u0001B:\u0015\r\u0011)h^\u0001\beVtG/[7f\u0013\u0011\u0011IHa\u001d\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>tW\u0007\u0006\u0002\u0003l\u0005)\u0011\r\u001d9msRa\u00111\u001bBA\u0005\u0007\u0013)Ia\"\u0003\n\"9\u0011\u0011P\u0018A\u0002\u0005u\u0004bBAC_\u0001\u0007\u0011\u0011\u0012\u0005\b\u0003#{\u0003\u0019AAK\u0011\u001d\tIl\fa\u0001\u0003{Cq!!40\u0001\u0004\ti,A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t=%1\u0014\t\u0007\u0003/\u0012\tJ!&\n\u0007\tMuO\u0001\u0004PaRLwN\u001c\t\u000f\u0003/\u00129*! \u0002\n\u0006U\u0015QXA_\u0013\r\u0011Ij\u001e\u0002\u0007)V\u0004H.Z\u001b\t\u0013\tu\u0005'!AA\u0002\u0005M\u0017a\u0001=%a\u0005A\u0011\r\u001a3CCR\u001c\u0007\u000e\u0006\u0004\u0002f\n\r&Q\u0015\u0005\b\u0003s\n\u0004\u0019AA?\u0011\u001d\u00119+\ra\u0001\u0005S\u000bA\u0001Z1uCB!!1\u0016BX\u001d\u0011\tYJ!,\n\u0005YD\u0014\u0002\u0002BY\u0005g\u0013\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0005YDD#A>")
public class DeltaSink
implements Sink,
ImplicitMetadataOperation {
    private String queryId;
    private volatile DeltaSink$PendingTxn$ PendingTxn$module;
    public final SQLContext org$apache$spark$sql$delta$sources$DeltaSink$$sqlContext;
    private final Path path;
    private final Seq<String> partitionColumns;
    private final OutputMode outputMode;
    private final DeltaOptions options;
    private final DeltaLog org$apache$spark$sql$delta$sources$DeltaSink$$deltaLog;
    private final SQLConf sqlConf;
    private final boolean canOverwriteSchema;
    private final boolean canMergeSchema;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    @Override
    public final void updateMetadata(SparkSession spark, OptimisticTransaction txn, StructType schema, Seq<String> partitionColumns, Map<String, String> configuration, boolean isOverwriteMode, boolean rearrangeOnly) {
        ImplicitMetadataOperation.updateMetadata$(this, spark, txn, schema, partitionColumns, configuration, isOverwriteMode, rearrangeOnly);
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public String name() {
        return Sink.name$((Sink)this);
    }

    public StructType schema() {
        return Sink.schema$((Sink)this);
    }

    public Set<TableCapability> capabilities() {
        return Sink.capabilities$((Sink)this);
    }

    public DeltaSink$PendingTxn$ PendingTxn() {
        if (this.PendingTxn$module == null) {
            this.PendingTxn$lzycompute$1();
        }
        return this.PendingTxn$module;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public DeltaLog org$apache$spark$sql$delta$sources$DeltaSink$$deltaLog() {
        return this.org$apache$spark$sql$delta$sources$DeltaSink$$deltaLog;
    }

    private SQLConf sqlConf() {
        return this.sqlConf;
    }

    private String queryId$lzycompute() {
        DeltaSink deltaSink = this;
        synchronized (deltaSink) {
            if (!this.bitmap$0) {
                this.queryId = this.org$apache$spark$sql$delta$sources$DeltaSink$$sqlContext.sparkContext().getLocalProperty(StreamExecution$.MODULE$.QUERY_ID_KEY());
                this.bitmap$0 = true;
            }
        }
        return this.queryId;
    }

    public String queryId() {
        return !this.bitmap$0 ? this.queryId$lzycompute() : this.queryId;
    }

    @Override
    public boolean canOverwriteSchema() {
        return this.canOverwriteSchema;
    }

    @Override
    public boolean canMergeSchema() {
        return this.canMergeSchema;
    }

    public void addBatch(long batchId, Dataset<Row> data) {
        Nil$ nil$;
        OutputMode outputMode;
        OptimisticTransaction txn = this.org$apache$spark$sql$delta$sources$DeltaSink$$deltaLog().startTransaction();
        Predef$.MODULE$.assert(this.queryId() != null);
        if (SchemaUtils$.MODULE$.typeExistsRecursively((DataType)data.schema(), (Function1<DataType, Object>)(Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DeltaSink.$anonfun$addBatch$1(x$2)))) {
            throw DeltaErrors$.MODULE$.streamWriteNullTypeException();
        }
        boolean selfScan = data.queryExecution().analyzed().collectFirst((PartialFunction)new scala.Serializable(null, txn){
            public static final long serialVersionUID = 0L;
            private final OptimisticTransaction txn$1;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                TahoeFileIndex index;
                LogicalRelation logicalRelation;
                Option<TahoeFileIndex> option;
                A1 A1 = x1;
                Object object = A1 instanceof LogicalRelation && !(option = DeltaTable$.MODULE$.unapply(logicalRelation = (LogicalRelation)A1)).isEmpty() && (index = (TahoeFileIndex)option.get()).deltaLog().isSameLogAs(this.txn$1.deltaLog()) ? BoxesRunTime.boxToBoolean((boolean)true) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                TahoeFileIndex index;
                LogicalRelation logicalRelation;
                Option<TahoeFileIndex> option;
                LogicalPlan logicalPlan = x1;
                boolean bl = logicalPlan instanceof LogicalRelation && !(option = DeltaTable$.MODULE$.unapply(logicalRelation = (LogicalRelation)logicalPlan)).isEmpty() && (index = (TahoeFileIndex)option.get()).deltaLog().isSameLogAs(this.txn$1.deltaLog());
                return bl;
            }
            {
                this.txn$1 = txn$1;
            }
        }).nonEmpty();
        if (selfScan) {
            txn.readWholeTable();
        }
        OutputMode outputMode2 = this.outputMode;
        OutputMode outputMode3 = OutputMode.Complete();
        this.updateMetadata(data.sparkSession(), txn, data.schema(), this.partitionColumns, (Map<String, String>)Predef$.MODULE$.Map().empty(), !(outputMode2 != null ? !outputMode2.equals(outputMode3) : outputMode3 != null), false);
        long currentVersion = txn.txnVersion(this.queryId());
        if (currentVersion >= batchId) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Skipping already complete epoch ").append(batchId).append(", in query ").append(this.queryId()).toString());
            return;
        }
        OutputMode outputMode4 = outputMode = this.outputMode;
        OutputMode outputMode5 = OutputMode.Complete();
        if (!(outputMode4 != null ? !outputMode4.equals(outputMode5) : outputMode5 != null)) {
            DeltaLog$.MODULE$.assertRemovable(txn.snapshot());
            nil$ = (Seq)txn.filterFiles().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.remove(), Seq$.MODULE$.canBuildFrom());
        } else {
            nil$ = Nil$.MODULE$;
        }
        Nil$ deletedFiles = nil$;
        Tuple2 tuple2 = Utils$.MODULE$.timeTakenMs((Function0 & Serializable & scala.Serializable)() -> txn.writeFiles(data, (Option<DeltaOptions>)new Some((Object)$this.options)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq newFiles = (Seq)tuple2._1();
        long writeFilesTimeMs = tuple2._2$mcJ$sp();
        Tuple2 tuple22 = new Tuple2((Object)newFiles, (Object)BoxesRunTime.boxToLong((long)writeFilesTimeMs));
        Tuple2 tuple23 = tuple22;
        Seq newFiles2 = (Seq)tuple23._1();
        long writeFilesTimeMs2 = tuple23._2$mcJ$sp();
        long totalSize = BoxesRunTime.unboxToLong((Object)((TraversableOnce)newFiles2.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.getFileSize()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        long totalLogicalRecords = BoxesRunTime.unboxToLong((Object)((TraversableOnce)newFiles2.map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)DeltaSink.$anonfun$addBatch$6(x$6)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Wrote ").append(newFiles2.size()).append(" files, with total size ").append(totalSize).append(", ").append(totalLogicalRecords).append(" logical records, duration=").append(writeFilesTimeMs2).append(" ms.").toString());
        DeltaOperations.StreamingUpdate info = new DeltaOperations.StreamingUpdate(this.outputMode, this.queryId(), batchId, this.options.userMetadata());
        PendingTxn pendingTxn = new PendingTxn(this, batchId, txn, info, (Seq<FileAction>)newFiles2, (Seq<FileAction>)deletedFiles);
        pendingTxn.commit();
    }

    public String toString() {
        return new StringBuilder(11).append("DeltaSink[").append(this.path).append("]").toString();
    }

    private final void PendingTxn$lzycompute$1() {
        DeltaSink deltaSink = this;
        synchronized (deltaSink) {
            if (this.PendingTxn$module == null) {
                this.PendingTxn$module = new DeltaSink$PendingTxn$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$addBatch$1(DataType x$2) {
        return x$2 instanceof NullType;
    }

    public static final /* synthetic */ long $anonfun$addBatch$6(FileAction x$6) {
        return BoxesRunTime.unboxToLong((Object)x$6.numLogicalRecords().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
    }

    public DeltaSink(SQLContext sqlContext, Path path, Seq<String> partitionColumns, OutputMode outputMode, DeltaOptions options) {
        this.org$apache$spark$sql$delta$sources$DeltaSink$$sqlContext = sqlContext;
        this.path = path;
        this.partitionColumns = partitionColumns;
        this.outputMode = outputMode;
        this.options = options;
        Sink.$init$((Sink)this);
        Logging.$init$((Logging)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
        ImplicitMetadataOperation.$init$(this);
        this.org$apache$spark$sql$delta$sources$DeltaSink$$deltaLog = DeltaLog$.MODULE$.forTable(sqlContext.sparkSession(), path);
        this.sqlConf = sqlContext.sparkSession().sessionState().conf();
        OutputMode outputMode2 = outputMode;
        OutputMode outputMode3 = OutputMode.Complete();
        this.canOverwriteSchema = !(outputMode2 != null ? !outputMode2.equals(outputMode3) : outputMode3 != null) && options.canOverwriteSchema();
        this.canMergeSchema = options.canMergeSchema();
    }

    public class PendingTxn
    implements Product,
    scala.Serializable {
        private final long batchId;
        private final OptimisticTransaction optimisticTransaction;
        private final DeltaOperations.StreamingUpdate streamingUpdate;
        private final Seq<FileAction> newFiles;
        private final Seq<FileAction> deletedFiles;
        public final /* synthetic */ DeltaSink $outer;

        public long batchId() {
            return this.batchId;
        }

        public OptimisticTransaction optimisticTransaction() {
            return this.optimisticTransaction;
        }

        public DeltaOperations.StreamingUpdate streamingUpdate() {
            return this.streamingUpdate;
        }

        public Seq<FileAction> newFiles() {
            return this.newFiles;
        }

        public Seq<FileAction> deletedFiles() {
            return this.deletedFiles;
        }

        public void commit() {
            long durationMs;
            SparkContext sc = this.org$apache$spark$sql$delta$sources$DeltaSink$PendingTxn$$$outer().org$apache$spark$sql$delta$sources$DeltaSink$$sqlContext.sparkContext();
            Map metrics = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numAddedFiles"), (Object)SQLMetrics$.MODULE$.createMetric(sc, "number of files added")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numRemovedFiles"), (Object)SQLMetrics$.MODULE$.createMetric(sc, "number of files removed"))}));
            ((SQLMetric)metrics.apply((Object)"numRemovedFiles")).set((long)this.deletedFiles().size());
            ((SQLMetric)metrics.apply((Object)"numAddedFiles")).set((long)this.newFiles().size());
            this.optimisticTransaction().registerSQLMetrics(this.org$apache$spark$sql$delta$sources$DeltaSink$PendingTxn$$$outer().org$apache$spark$sql$delta$sources$DeltaSink$$sqlContext.sparkSession(), (Map<String, SQLMetric>)metrics);
            SetTransaction setTransaction = new SetTransaction(this.org$apache$spark$sql$delta$sources$DeltaSink$PendingTxn$$$outer().queryId(), this.batchId(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.org$apache$spark$sql$delta$sources$DeltaSink$PendingTxn$$$outer().org$apache$spark$sql$delta$sources$DeltaSink$$deltaLog().clock().getTimeMillis())));
            List setTxn = Nil$.MODULE$.$colon$colon((Object)setTransaction);
            Tuple2 tuple2 = Utils$.MODULE$.timeTakenMs((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.optimisticTransaction().commit((Seq<Action>)((Seq)((List)setTxn.$plus$plus(this.newFiles(), List$.MODULE$.canBuildFrom())).$plus$plus(this.deletedFiles(), List$.MODULE$.canBuildFrom())), this.streamingUpdate()));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long l = durationMs = tuple2._2$mcJ$sp();
            long durationMs2 = l;
            this.org$apache$spark$sql$delta$sources$DeltaSink$PendingTxn$$$outer().logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(76).append("Committed transaction, batchId=").append(this.batchId()).append(", duration=").append(durationMs2).append(" ms, ").append("added ").append(this.newFiles().size()).append(" files, removed ").append(this.deletedFiles().size()).append(" files.").toString());
            String executionId = sc.getLocalProperty(SQLExecution$.MODULE$.EXECUTION_ID_KEY());
            SQLMetrics$.MODULE$.postDriverMetricUpdates(sc, executionId, metrics.values().toSeq());
        }

        public PendingTxn copy(long batchId, OptimisticTransaction optimisticTransaction, DeltaOperations.StreamingUpdate streamingUpdate, Seq<FileAction> newFiles, Seq<FileAction> deletedFiles) {
            return new PendingTxn(this.org$apache$spark$sql$delta$sources$DeltaSink$PendingTxn$$$outer(), batchId, optimisticTransaction, streamingUpdate, newFiles, deletedFiles);
        }

        public long copy$default$1() {
            return this.batchId();
        }

        public OptimisticTransaction copy$default$2() {
            return this.optimisticTransaction();
        }

        public DeltaOperations.StreamingUpdate copy$default$3() {
            return this.streamingUpdate();
        }

        public Seq<FileAction> copy$default$4() {
            return this.newFiles();
        }

        public Seq<FileAction> copy$default$5() {
            return this.deletedFiles();
        }

        public String productPrefix() {
            return "PendingTxn";
        }

        public int productArity() {
            return 5;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = BoxesRunTime.boxToLong((long)this.batchId());
                    break;
                }
                case 1: {
                    object = this.optimisticTransaction();
                    break;
                }
                case 2: {
                    object = this.streamingUpdate();
                    break;
                }
                case 3: {
                    object = this.newFiles();
                    break;
                }
                case 4: {
                    object = this.deletedFiles();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof PendingTxn;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.batchId()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.optimisticTransaction()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.streamingUpdate()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.newFiles()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.deletedFiles()));
            return Statics.finalizeHash((int)n, (int)5);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof PendingTxn)) return false;
            if (((PendingTxn)object).org$apache$spark$sql$delta$sources$DeltaSink$PendingTxn$$$outer() != this.org$apache$spark$sql$delta$sources$DeltaSink$PendingTxn$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            PendingTxn pendingTxn = (PendingTxn)x$1;
            if (this.batchId() != pendingTxn.batchId()) return false;
            OptimisticTransaction optimisticTransaction = this.optimisticTransaction();
            OptimisticTransaction optimisticTransaction2 = pendingTxn.optimisticTransaction();
            if (optimisticTransaction == null) {
                if (optimisticTransaction2 != null) {
                    return false;
                }
            } else if (!optimisticTransaction.equals(optimisticTransaction2)) return false;
            DeltaOperations.StreamingUpdate streamingUpdate = this.streamingUpdate();
            DeltaOperations.StreamingUpdate streamingUpdate2 = pendingTxn.streamingUpdate();
            if (streamingUpdate == null) {
                if (streamingUpdate2 != null) {
                    return false;
                }
            } else if (!((Object)streamingUpdate).equals(streamingUpdate2)) return false;
            Seq<FileAction> seq = this.newFiles();
            Seq<FileAction> seq2 = pendingTxn.newFiles();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            Seq<FileAction> seq3 = this.deletedFiles();
            Seq<FileAction> seq4 = pendingTxn.deletedFiles();
            if (seq3 == null) {
                if (seq4 != null) {
                    return false;
                }
            } else if (!seq3.equals(seq4)) return false;
            if (!pendingTxn.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ DeltaSink org$apache$spark$sql$delta$sources$DeltaSink$PendingTxn$$$outer() {
            return this.$outer;
        }

        public PendingTxn(DeltaSink $outer, long batchId, OptimisticTransaction optimisticTransaction, DeltaOperations.StreamingUpdate streamingUpdate, Seq<FileAction> newFiles, Seq<FileAction> deletedFiles) {
            this.batchId = batchId;
            this.optimisticTransaction = optimisticTransaction;
            this.streamingUpdate = streamingUpdate;
            this.newFiles = newFiles;
            this.deletedFiles = deletedFiles;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

