/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.sources;

import com.fasterxml.jackson.module.scala.ScalaObjectMapper;
import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.connector.read.streaming.Offset;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.sources.DeltaSourceOffset;
import org.apache.spark.sql.delta.util.JsonUtils$;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple5;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;

public final class DeltaSourceOffset$
implements Logging,
scala.Serializable {
    public static DeltaSourceOffset$ MODULE$;
    private final int VERSION_1;
    private final int VERSION_2;
    private final int VERSION_3;
    private final int CURRENT_VERSION;
    private final long BASE_INDEX_V3;
    private final long BASE_INDEX_V1;
    private final long BASE_INDEX;
    private final long SCHEMA_CHANGE_INDEX;
    private final long POST_SCHEMA_CHANGE_INDEX;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new DeltaSourceOffset$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int VERSION_1() {
        return this.VERSION_1;
    }

    public int VERSION_2() {
        return this.VERSION_2;
    }

    public int VERSION_3() {
        return this.VERSION_3;
    }

    public int CURRENT_VERSION() {
        return this.CURRENT_VERSION;
    }

    public long BASE_INDEX_V3() {
        return this.BASE_INDEX_V3;
    }

    public long BASE_INDEX_V1() {
        return this.BASE_INDEX_V1;
    }

    public long BASE_INDEX() {
        return this.BASE_INDEX;
    }

    public long SCHEMA_CHANGE_INDEX() {
        return this.SCHEMA_CHANGE_INDEX;
    }

    public long POST_SCHEMA_CHANGE_INDEX() {
        return this.POST_SCHEMA_CHANGE_INDEX;
    }

    public DeltaSourceOffset apply(String reservoirId, long reservoirVersion, long index, boolean isStartingVersion) {
        return new DeltaSourceOffset(this.CURRENT_VERSION(), reservoirId, reservoirVersion, index, isStartingVersion);
    }

    public DeltaSourceOffset apply(String reservoirId, Offset offset) {
        DeltaSourceOffset deltaSourceOffset;
        Offset offset2 = offset;
        if (offset2 instanceof DeltaSourceOffset) {
            DeltaSourceOffset deltaSourceOffset2;
            deltaSourceOffset = deltaSourceOffset2 = (DeltaSourceOffset)offset2;
        } else {
            long l;
            this.validateSourceVersion(offset2.json());
            DeltaSourceOffset o = (DeltaSourceOffset)((ScalaObjectMapper)JsonUtils$.MODULE$.mapper()).readValue(offset2.json(), ManifestFactory$.MODULE$.classType(DeltaSourceOffset.class));
            String string = o.reservoirId();
            String string2 = reservoirId;
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw DeltaErrors$.MODULE$.nonExistentDeltaTableStreaming(o.reservoirId());
            }
            if (o.sourceVersion() < (long)this.VERSION_3() && o.index() == this.BASE_INDEX_V1()) {
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "upgrading offset to use latest version base index");
                l = this.BASE_INDEX();
            } else {
                l = o.index();
            }
            long offsetIndex = l;
            deltaSourceOffset = this.apply(o.reservoirId(), o.reservoirVersion(), offsetIndex, o.isStartingVersion());
        }
        return deltaSourceOffset;
    }

    private void validateSourceVersion(String json) {
        JsonAST.JValue parsedJson = JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(json), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
        Option<JsonAST.JValue> versionJValueOpt = this.jsonOption(package$.MODULE$.jvalue2monadic(parsedJson).$bslash("sourceVersion"));
        Option versionOpt = versionJValueOpt.map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToLong((long)DeltaSourceOffset$.$anonfun$validateSourceVersion$1(x0$1)));
        if (versionOpt.isEmpty()) {
            throw DeltaErrors$.MODULE$.cannotFindSourceVersionException(json);
        }
        if (BoxesRunTime.unboxToLong((Object)versionOpt.get()) == (long)this.VERSION_2()) {
            throw DeltaErrors$.MODULE$.invalidSourceVersion((JsonAST.JValue)versionJValueOpt.get());
        }
        int maxVersion = this.VERSION_3();
        if (BoxesRunTime.unboxToLong((Object)versionOpt.get()) > (long)maxVersion) {
            throw DeltaErrors$.MODULE$.invalidFormatFromSourceVersion(BoxesRunTime.unboxToLong((Object)versionOpt.get()), Predef$.MODULE$.int2Integer(maxVersion));
        }
    }

    private Option<JsonAST.JValue> jsonOption(JsonAST.JValue json) {
        None$ none$;
        JsonAST.JValue jValue = json;
        JsonAST.JNothing$ jNothing$ = package$.MODULE$.JNothing();
        JsonAST.JValue jValue2 = jValue;
        if (!(jNothing$ != null ? !jNothing$.equals(jValue2) : jValue2 != null)) {
            none$ = None$.MODULE$;
        } else if (jValue != null) {
            JsonAST.JValue jValue3 = jValue;
            none$ = new Some((Object)jValue3);
        } else {
            throw new MatchError((Object)jValue);
        }
        return none$;
    }

    public void validateOffsets(DeltaSourceOffset previousOffset, DeltaSourceOffset currentOffset) {
        if (!previousOffset.isStartingVersion() && currentOffset.isStartingVersion()) {
            throw new IllegalStateException(new StringBuilder(84).append("Found invalid offsets: 'isStartingVersion' fliped incorrectly. ").append("Previous: ").append(previousOffset).append(", Current: ").append(currentOffset).toString());
        }
        if (previousOffset.reservoirVersion() > currentOffset.reservoirVersion()) {
            throw new IllegalStateException(new StringBuilder(75).append("Found invalid offsets: 'reservoirVersion' moved back. ").append("Previous: ").append(previousOffset).append(", Current: ").append(currentOffset).toString());
        }
        if (previousOffset.reservoirVersion() == currentOffset.reservoirVersion() && previousOffset.index() > currentOffset.index()) {
            throw new IllegalStateException(new StringBuilder(64).append("Found invalid offsets. 'index' moved back. ").append("Previous: ").append(previousOffset).append(", Current: ").append(currentOffset).toString());
        }
    }

    public boolean isSchemaChangeIndex(long index) {
        return index == this.SCHEMA_CHANGE_INDEX() || index == this.POST_SCHEMA_CHANGE_INDEX();
    }

    public DeltaSourceOffset apply(long sourceVersion, String reservoirId, long reservoirVersion, long index, boolean isStartingVersion) {
        return new DeltaSourceOffset(sourceVersion, reservoirId, reservoirVersion, index, isStartingVersion);
    }

    public Option<Tuple5<Object, String, Object, Object, Object>> unapply(DeltaSourceOffset x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple5((Object)BoxesRunTime.boxToLong((long)x$0.sourceVersion()), (Object)x$0.reservoirId(), (Object)BoxesRunTime.boxToLong((long)x$0.reservoirVersion()), (Object)BoxesRunTime.boxToLong((long)x$0.index()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.isStartingVersion())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ long $anonfun$validateSourceVersion$1(JsonAST.JValue x0$1) {
        JsonAST.JValue jValue = x0$1;
        if (!(jValue instanceof JsonAST.JInt)) {
            throw DeltaErrors$.MODULE$.invalidSourceVersion(jValue);
        }
        JsonAST.JInt jInt = (JsonAST.JInt)jValue;
        long l = jInt.num().longValue();
        return l;
    }

    private DeltaSourceOffset$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.VERSION_1 = 1;
        this.VERSION_2 = 2;
        this.VERSION_3 = 3;
        this.CURRENT_VERSION = this.VERSION_3();
        this.BASE_INDEX_V3 = -100L;
        this.BASE_INDEX_V1 = -1L;
        this.BASE_INDEX = this.BASE_INDEX_V3();
        this.SCHEMA_CHANGE_INDEX = -20L;
        this.POST_SCHEMA_CHANGE_INDEX = -19L;
    }
}

