/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.sources;

import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.delta.DeltaColumnMapping$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.sources.NonAdditiveSchemaChangeTypes$;
import org.apache.spark.sql.delta.sources.PersistedSchema;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class DeltaSourceSchemaEvolutionSupport$ {
    public static DeltaSourceSchemaEvolutionSupport$ MODULE$;

    static {
        new DeltaSourceSchemaEvolutionSupport$();
    }

    private Option<String> determineNonAdditiveSchemaChangeType(StructType newSchema, StructType oldSchema) {
        boolean isRenameColumn = DeltaColumnMapping$.MODULE$.isRenameColumnOperation(newSchema, oldSchema);
        boolean isDropColumn = DeltaColumnMapping$.MODULE$.isDropColumnOperation(newSchema, oldSchema);
        return isRenameColumn && isDropColumn ? new Some((Object)NonAdditiveSchemaChangeTypes$.MODULE$.SCHEMA_CHANGE_RENAME_AND_DROP()) : (isRenameColumn ? new Some((Object)NonAdditiveSchemaChangeTypes$.MODULE$.SCHEMA_CHANGE_RENAME()) : (isDropColumn ? new Some((Object)NonAdditiveSchemaChangeTypes$.MODULE$.SCHEMA_CHANGE_DROP()) : None$.MODULE$));
    }

    public void validateIfSchemaChangeCanBeUnblockedWithSQLConf(SparkSession spark, String metadataPath, PersistedSchema currentSchema, PersistedSchema previousSchema) {
        String sqlConfPrefix = new StringBuilder(10).append(DeltaSQLConf$.MODULE$.SQL_CONF_PREFIX()).append(".streaming").toString();
        int checkpointHash = metadataPath.hashCode();
        String allowAll = "allowSourceColumnRenameAndDrop";
        String allowRename = "allowSourceColumnRename";
        String allowDrop = "allowSourceColumnDrop";
        long schemaChangeVersion = currentSchema.deltaCommitVersion();
        Seq confPairsToAllowAllSchemaChange = DeltaSourceSchemaEvolutionSupport$.getConfPairsToAllowSchemaChange$1(allowAll, schemaChangeVersion, sqlConfPrefix, checkpointHash);
        this.determineNonAdditiveSchemaChangeType(currentSchema.dataSchema(), previousSchema.dataSchema()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DeltaSourceSchemaEvolutionSupport$.$anonfun$validateIfSchemaChangeCanBeUnblockedWithSQLConf$2(allowDrop, schemaChangeVersion, confPairsToAllowAllSchemaChange, checkpointHash, allowAll, allowRename, sqlConfPrefix, spark, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private static final Option getConf$1(String key, SparkSession spark$1) {
        return Option$.MODULE$.apply((Object)spark$1.sessionState().conf().getConfString(key, null)).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.toLowerCase(Locale.ROOT));
    }

    private static final Seq getConfPairsToAllowSchemaChange$1(String allowSchemaChange, long schemaChangeVersion, String sqlConfPrefix$1, int checkpointHash$1) {
        return (Seq)new .colon.colon((Object)new Tuple2((Object)new StringBuilder(1).append(sqlConfPrefix$1).append(".").append(allowSchemaChange).toString(), (Object)"always"), (List)new .colon.colon((Object)new Tuple2((Object)new StringBuilder(7).append(sqlConfPrefix$1).append(".").append(allowSchemaChange).append(".ckpt_").append(checkpointHash$1).toString(), (Object)"always"), (List)new .colon.colon((Object)new Tuple2((Object)new StringBuilder(7).append(sqlConfPrefix$1).append(".").append(allowSchemaChange).append(".ckpt_").append(checkpointHash$1).toString(), (Object)Long.toString(schemaChangeVersion)), (List)Nil$.MODULE$)));
    }

    public static final /* synthetic */ boolean $anonfun$validateIfSchemaChangeCanBeUnblockedWithSQLConf$3(SparkSession spark$1, Tuple2 p) {
        return DeltaSourceSchemaEvolutionSupport$.getConf$1((String)p._1(), spark$1).contains(p._2());
    }

    public static final /* synthetic */ boolean $anonfun$validateIfSchemaChangeCanBeUnblockedWithSQLConf$4(SparkSession spark$1, Tuple2 p) {
        return DeltaSourceSchemaEvolutionSupport$.getConf$1((String)p._1(), spark$1).contains(p._2());
    }

    public static final /* synthetic */ boolean $anonfun$validateIfSchemaChangeCanBeUnblockedWithSQLConf$5(SparkSession spark$1, Tuple2 p) {
        return DeltaSourceSchemaEvolutionSupport$.getConf$1((String)p._1(), spark$1).contains(p._2());
    }

    public static final /* synthetic */ void $anonfun$validateIfSchemaChangeCanBeUnblockedWithSQLConf$2(String allowDrop$1, long schemaChangeVersion$1, Seq confPairsToAllowAllSchemaChange$1, int checkpointHash$1, String allowAll$1, String allowRename$1, String sqlConfPrefix$1, SparkSession spark$1, String x0$1) {
        String string = x0$1;
        String string2 = NonAdditiveSchemaChangeTypes$.MODULE$.SCHEMA_CHANGE_DROP();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            Seq validConfKeysValuePair = (Seq)DeltaSourceSchemaEvolutionSupport$.getConfPairsToAllowSchemaChange$1(allowDrop$1, schemaChangeVersion$1, sqlConfPrefix$1, checkpointHash$1).$plus$plus((GenTraversableOnce)confPairsToAllowAllSchemaChange$1, Seq$.MODULE$.canBuildFrom());
            if (!validConfKeysValuePair.exists((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)DeltaSourceSchemaEvolutionSupport$.$anonfun$validateIfSchemaChangeCanBeUnblockedWithSQLConf$3(spark$1, p)))) {
                throw DeltaErrors$.MODULE$.cannotContinueStreamingPostSchemaEvolution(NonAdditiveSchemaChangeTypes$.MODULE$.SCHEMA_CHANGE_DROP(), schemaChangeVersion$1, checkpointHash$1, allowAll$1, allowDrop$1);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            String string4 = NonAdditiveSchemaChangeTypes$.MODULE$.SCHEMA_CHANGE_RENAME();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                Seq validConfKeysValuePair = (Seq)DeltaSourceSchemaEvolutionSupport$.getConfPairsToAllowSchemaChange$1(allowRename$1, schemaChangeVersion$1, sqlConfPrefix$1, checkpointHash$1).$plus$plus((GenTraversableOnce)confPairsToAllowAllSchemaChange$1, Seq$.MODULE$.canBuildFrom());
                if (!validConfKeysValuePair.exists((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)DeltaSourceSchemaEvolutionSupport$.$anonfun$validateIfSchemaChangeCanBeUnblockedWithSQLConf$4(spark$1, p)))) {
                    throw DeltaErrors$.MODULE$.cannotContinueStreamingPostSchemaEvolution(NonAdditiveSchemaChangeTypes$.MODULE$.SCHEMA_CHANGE_RENAME(), schemaChangeVersion$1, checkpointHash$1, allowAll$1, allowRename$1);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                String string6 = NonAdditiveSchemaChangeTypes$.MODULE$.SCHEMA_CHANGE_RENAME_AND_DROP();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    Seq validConfKeysValuePair = confPairsToAllowAllSchemaChange$1;
                    if (!validConfKeysValuePair.exists((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)DeltaSourceSchemaEvolutionSupport$.$anonfun$validateIfSchemaChangeCanBeUnblockedWithSQLConf$5(spark$1, p)))) {
                        throw DeltaErrors$.MODULE$.cannotContinueStreamingPostSchemaEvolution(NonAdditiveSchemaChangeTypes$.MODULE$.SCHEMA_CHANGE_DROP(), schemaChangeVersion$1, checkpointHash$1, allowAll$1, allowAll$1);
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)string);
                }
            }
        }
    }

    private DeltaSourceSchemaEvolutionSupport$() {
        MODULE$ = this;
    }
}

