/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.util;

import java.util.regex.Pattern;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class FileNames$ {
    public static FileNames$ MODULE$;
    private final Regex deltaFileRegex;
    private final Regex checksumFileRegex;
    private final Regex checkpointFileRegex;
    private final Pattern deltaFilePattern;
    private final Pattern checksumFilePattern;
    private final Pattern checkpointFilePattern;

    static {
        new FileNames$();
    }

    public Regex deltaFileRegex() {
        return this.deltaFileRegex;
    }

    public Regex checksumFileRegex() {
        return this.checksumFileRegex;
    }

    public Regex checkpointFileRegex() {
        return this.checkpointFileRegex;
    }

    public Pattern deltaFilePattern() {
        return this.deltaFilePattern;
    }

    public Pattern checksumFilePattern() {
        return this.checksumFilePattern;
    }

    public Pattern checkpointFilePattern() {
        return this.checkpointFilePattern;
    }

    public Path deltaFile(Path path, long version) {
        long arg$macro$1 = version;
        return new Path(path, new StringOps("%020d.json").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$1)})));
    }

    public Path sampleFile(Path path, long version) {
        long arg$macro$1 = version;
        return new Path(path, new StringOps("%020d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$1)})));
    }

    public Path checksumFile(Path path, long version) {
        long arg$macro$1 = version;
        return new Path(path, new StringOps("%020d.crc").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$1)})));
    }

    public long deltaVersion(Path path) {
        return new StringOps(Predef$.MODULE$.augmentString(path.getName().split("\\.")[0])).toLong();
    }

    public long deltaVersion(FileStatus file) {
        return this.deltaVersion(file.getPath());
    }

    public long checksumVersion(Path path) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(path.getName())).stripSuffix(".crc"))).toLong();
    }

    public long checksumVersion(FileStatus file) {
        return this.checksumVersion(file.getPath());
    }

    public Path listingPrefix(Path path, long version) {
        long arg$macro$1 = version;
        return new Path(path, new StringOps("%020d.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$1)})));
    }

    public Path checkpointFileSingular(Path path, long version) {
        long arg$macro$1 = version;
        return new Path(path, new StringOps("%020d.checkpoint.parquet").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$1)})));
    }

    public Seq<Path> checkpointFileWithParts(Path path, long version, int numParts) {
        return (Seq)package$.MODULE$.Range().apply(1, numParts + 1).map((Function1 & java.io.Serializable & Serializable)i -> FileNames$.$anonfun$checkpointFileWithParts$1(path, version, numParts, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public Option<Object> numCheckpointParts(Path path) {
        String[] segments = path.getName().split("\\.");
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])segments)).size() != 5 ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(segments[3])).toInt()));
    }

    public boolean isCheckpointFile(Path path) {
        return this.checkpointFilePattern().matcher(path.getName()).matches();
    }

    public boolean isCheckpointFile(FileStatus file) {
        return this.isCheckpointFile(file.getPath());
    }

    public boolean isDeltaFile(Path path) {
        return this.deltaFilePattern().matcher(path.getName()).matches();
    }

    public boolean isDeltaFile(FileStatus file) {
        return this.isDeltaFile(file.getPath());
    }

    public boolean isChecksumFile(Path path) {
        return this.checksumFilePattern().matcher(path.getName()).matches();
    }

    public boolean isChecksumFile(FileStatus file) {
        return this.isChecksumFile(file.getPath());
    }

    public long checkpointVersion(Path path) {
        return new StringOps(Predef$.MODULE$.augmentString(path.getName().split("\\.")[0])).toLong();
    }

    public long checkpointVersion(FileStatus file) {
        return this.checkpointVersion(file.getPath());
    }

    public long getFileVersion(Path path) {
        long l;
        if (this.isCheckpointFile(path)) {
            l = this.checkpointVersion(path);
        } else if (this.isDeltaFile(path)) {
            l = this.deltaVersion(path);
        } else if (this.isChecksumFile(path)) {
            l = this.checksumVersion(path);
        } else {
            throw new AssertionError((Object)new StringBuilder(47).append("Unexpected file type found in transaction log: ").append(path).toString());
        }
        return l;
    }

    public long getFileVersion(FileStatus file) {
        return this.getFileVersion(file.getPath());
    }

    public static final /* synthetic */ Path $anonfun$checkpointFileWithParts$1(Path path$1, long version$1, int numParts$1, int i) {
        long arg$macro$1 = version$1;
        int arg$macro$2 = i;
        int arg$macro$3 = numParts$1;
        return new Path(path$1, new StringOps("%020d.checkpoint.%010d.%010d.parquet").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$1), BoxesRunTime.boxToInteger((int)arg$macro$2), BoxesRunTime.boxToInteger((int)arg$macro$3)})));
    }

    private FileNames$() {
        MODULE$ = this;
        this.deltaFileRegex = new StringOps(Predef$.MODULE$.augmentString("(\\d+)\\.json")).r();
        this.checksumFileRegex = new StringOps(Predef$.MODULE$.augmentString("(\\d+)\\.crc")).r();
        this.checkpointFileRegex = new StringOps(Predef$.MODULE$.augmentString("(\\d+)\\.checkpoint(\\.(\\d+)\\.(\\d+))?\\.parquet")).r();
        this.deltaFilePattern = this.deltaFileRegex().pattern();
        this.checksumFilePattern = this.checksumFileRegex().pattern();
        this.checkpointFilePattern = this.checkpointFileRegex().pattern();
    }
}

