/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.NoSuchElementException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaErrorsBase;
import org.apache.spark.sql.delta.DeltaHistory;
import org.apache.spark.sql.delta.DeltaHistory$;
import org.apache.spark.sql.delta.DeltaHistoryManager$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.VersionNotFoundException;
import org.apache.spark.sql.delta.actions.CommitInfo;
import org.apache.spark.sql.delta.actions.CommitMarker;
import org.apache.spark.sql.delta.implicits.package$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.storage.LogStore;
import org.apache.spark.sql.delta.storage.LogStore$;
import org.apache.spark.sql.delta.util.DateTimeUtils$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.delta.util.FileNames$;
import org.apache.spark.sql.delta.util.TimestampFormatter;
import org.apache.spark.sql.delta.util.TimestampFormatter$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Queue;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r-f\u0001B(Q\u0001mC\u0001\u0002\u001b\u0001\u0003\u0002\u0003\u0006I!\u001b\u0005\t[\u0002\u0011\t\u0011)A\u0005]\")\u0011\u000f\u0001C\u0001e\")Q\u000b\u0001C\u0005m\")1\u0010\u0001C\u0005y\"9\u0011q\u0001\u0001\u0005\u0002\u0005%\u0001bBA\u0004\u0001\u0011\u0005\u00111\u0007\u0005\n\u0003\u000b\u0002\u0011\u0013!C\u0001\u0003\u000fBq!!\u0018\u0001\t\u0003\ty\u0006C\u0005\u0004\b\u0002\t\n\u0011\"\u0001\u0004\n\"I1Q\u0012\u0001\u0012\u0002\u0013\u00051\u0011\u0012\u0005\b\u0007\u001f\u0003A\u0011ABI\u0011%\u0019Y\nAI\u0001\n\u0003\u0019I\tC\u0005\u0004\u001e\u0002\t\n\u0011\"\u0001\u0004\n\"91q\u0014\u0001\u0005\n\r\u0005\u0006\u0002CBU\u0001\u0011\u0005\u0001+!:\b\u000f\u0005\u0015\u0004\u000b#\u0001\u0002h\u00191q\n\u0015E\u0001\u0003SBa!\u001d\n\u0005\u0002\u0005-\u0004bBA7%\u0011%\u0011q\u000e\u0005\b\u0003k\u0013B\u0011AA\\\u0011)\tYL\u0005b\u0001\n\u0003\u0001\u0016Q\u0018\u0005\b\u0003\u007f\u0013\u0002\u0015!\u0003o\u0011!\t\tM\u0005C\u0001!\u0006\r\u0007b\u0002B4%\u0011%!\u0011\u000e\u0005\b\u0005\u0007\u0013B\u0011\u0002BC\u0011\u001d\u00119K\u0005C\u0005\u0005S3a!a4\u0013\u0001\u0006E\u0007BCAR9\tU\r\u0011\"\u0001\u0002f\"Q\u0011q\u001d\u000f\u0003\u0012\u0003\u0006I!!\u000f\t\u0015\u0005%HD!f\u0001\n\u0003\t)\u000f\u0003\u0006\u0002lr\u0011\t\u0012)A\u0005\u0003sAa!\u001d\u000f\u0005\u0002\u00055\bbBAz9\u0011\u0005\u0013Q\u001f\u0005\b\u0003sdB\u0011IAs\u0011\u001d\tY\u0010\bC!\u0003KD\u0011\"!@\u001d\u0003\u0003%\t!a@\t\u0013\t\u0015A$%A\u0005\u0002\t\u001d\u0001\"\u0003B\u00069E\u0005I\u0011\u0001B\u0004\u0011%\u0011i\u0001HA\u0001\n\u0003\u0012y\u0001C\u0005\u0003\"q\t\t\u0011\"\u0001\u0002>\"I!1\u0005\u000f\u0002\u0002\u0013\u0005!Q\u0005\u0005\n\u0005ca\u0012\u0011!C!\u0005gA\u0011B!\u0011\u001d\u0003\u0003%\tAa\u0011\t\u0013\t5C$!A\u0005B\t=\u0003\"\u0003B)9\u0005\u0005I\u0011\tB*\u0011%\u0011)\u0006HA\u0001\n\u0003\u00129fB\u0005\u00034J\t\t\u0011#\u0001\u00036\u001aI\u0011q\u001a\n\u0002\u0002#\u0005!q\u0017\u0005\u0007cF\"\tA!2\t\u0013\tE\u0013'!A\u0005F\tM\u0003\"\u0003Bdc\u0005\u0005I\u0011\u0011Be\u0011%\u0011y-MA\u0001\n\u0003\u0013\t\u000eC\u0005\u0003`F\n\t\u0011\"\u0003\u0003b\u001a1!\u0011\u001e\n\u0001\u0005WD!Ba>8\u0005\u0003\u0005\u000b\u0011\u0002Bw\u0011)\u0011Ip\u000eB\u0001B\u0003%\u0011\u0011\b\u0005\u000b\u0005w<$\u0011!Q\u0001\n\u0005e\u0002B\u0003B\u007fo\t\u0005\t\u0015!\u0003\u0003\u0000\"1\u0011o\u000eC\u0001\u0007\u000bA\u0011b!\u00058\u0005\u0004%Iaa\u0005\t\u0011\r\u0005r\u0007)A\u0005\u0007+A\u0011ba\t8\u0005\u0004%Ia!\n\t\u0011\r5r\u0007)A\u0005\u0007OA1ba\f8\u0001\u0004\u0005\r\u0011\"\u0003\u00042!Y11G\u001cA\u0002\u0003\u0007I\u0011BB\u001b\u0011-\u0019yd\u000ea\u0001\u0002\u0003\u0006KA!=\t\u0013\r\u0005s\u00071A\u0005\n\r\r\u0003\"CB#o\u0001\u0007I\u0011BB$\u0011!\u0019Ye\u000eQ!\n\t\u0015\u0003bBB'o\u0011%1q\n\u0005\b\u0007#:D\u0011BB*\u0011\u001d\u0019If\u000eC\u0005\u00077Bqaa\u00188\t\u0013\u0019y\u0005C\u0004\u0004b]\"Iaa\u0014\t\u000f\r\rt\u0007\"\u0011\u0004D!91QM\u001c\u0005B\r\u001d\u0004\"CB5%E\u0005I\u0011AB6\u0005M!U\r\u001c;b\u0011&\u001cHo\u001c:z\u001b\u0006t\u0017mZ3s\u0015\t\t&+A\u0003eK2$\u0018M\u0003\u0002T)\u0006\u00191/\u001d7\u000b\u0005U3\u0016!B:qCJ\\'BA,Y\u0003\u0019\t\u0007/Y2iK*\t\u0011,A\u0002pe\u001e\u001c\u0001aE\u0002\u00019\n\u0004\"!\u00181\u000e\u0003yS\u0011aX\u0001\u0006g\u000e\fG.Y\u0005\u0003Cz\u0013a!\u00118z%\u00164\u0007CA2g\u001b\u0005!'BA3Q\u0003!iW\r^3sS:<\u0017BA4e\u00051!U\r\u001c;b\u0019><w-\u001b8h\u0003!!W\r\u001c;b\u0019><\u0007C\u00016l\u001b\u0005\u0001\u0016B\u00017Q\u0005!!U\r\u001c;b\u0019><\u0017AD7bq.+\u0017p\u001d)fe2K7\u000f\u001e\t\u0003;>L!\u0001\u001d0\u0003\u0007%sG/\u0001\u0004=S:LGO\u0010\u000b\u0004gR,\bC\u00016\u0001\u0011\u0015A7\u00011\u0001j\u0011\u001di7\u0001%AA\u00029,\u0012a\u001e\t\u0003qfl\u0011AU\u0005\u0003uJ\u0013Ab\u00159be.\u001cVm]:j_:\f\u0011dZ3u'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a%bI>|\u0007oQ8oMV\tQ\u0010E\u0002\u007f\u0003\u0007i\u0011a \u0006\u0004\u0003\u0003!\u0016\u0001B;uS2L1!!\u0002\u0000\u0005e\u0019VM]5bY&T\u0018M\u00197f\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\u0015\u001d,G\u000fS5ti>\u0014\u0018\u0010\u0006\u0003\u0002\f\u0005%\u0002CBA\u0007\u0003;\t\u0019C\u0004\u0003\u0002\u0010\u0005ea\u0002BA\t\u0003/i!!a\u0005\u000b\u0007\u0005U!,\u0001\u0004=e>|GOP\u0005\u0002?&\u0019\u00111\u00040\u0002\u000fA\f7m[1hK&!\u0011qDA\u0011\u0005\r\u0019V-\u001d\u0006\u0004\u00037q\u0006c\u00016\u0002&%\u0019\u0011q\u0005)\u0003\u0019\u0011+G\u000e^1ISN$xN]=\t\u000f\u0005-b\u00011\u0001\u0002.\u0005AA.[7ji>\u0003H\u000f\u0005\u0003^\u0003_q\u0017bAA\u0019=\n1q\n\u001d;j_:$b!a\u0003\u00026\u0005}\u0002bBA\u001c\u000f\u0001\u0007\u0011\u0011H\u0001\u0006gR\f'\u000f\u001e\t\u0004;\u0006m\u0012bAA\u001f=\n!Aj\u001c8h\u0011%\t\te\u0002I\u0001\u0002\u0004\t\u0019%A\u0002f]\u0012\u0004R!XA\u0018\u0003s\tAcZ3u\u0011&\u001cHo\u001c:zI\u0011,g-Y;mi\u0012\u0012TCAA%U\u0011\t\u0019%a\u0013,\u0005\u00055\u0003\u0003BA(\u00033j!!!\u0015\u000b\t\u0005M\u0013QK\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0016_\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00037\n\tFA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQcZ3u\u0003\u000e$\u0018N^3D_6l\u0017\u000e^!u)&lW\r\u0006\u0006\u0002b\r=41PB@\u0007\u0007\u00032!a\u0019\u001d\u001d\tQ\u0017#A\nEK2$\u0018\rS5ti>\u0014\u00180T1oC\u001e,'\u000f\u0005\u0002k%M\u0019!\u0003\u00182\u0015\u0005\u0005\u001d\u0014!D4fi\u000e{W.\\5u\u0013:4w\u000e\u0006\u0006\u0002r\u0005u\u0014QRAQ\u0003K\u0003B!a\u001d\u0002z5\u0011\u0011Q\u000f\u0006\u0004\u0003o\u0002\u0016aB1di&|gn]\u0005\u0005\u0003w\n)H\u0001\u0006D_6l\u0017\u000e^%oM>Dq!a \u0015\u0001\u0004\t\t)\u0001\u0005m_\u001e\u001cFo\u001c:f!\u0011\t\u0019)!#\u000e\u0005\u0005\u0015%bAAD!\u000691\u000f^8sC\u001e,\u0017\u0002BAF\u0003\u000b\u0013\u0001\u0002T8h'R|'/\u001a\u0005\b\u0003\u001f#\u0002\u0019AAI\u0003!\u0011\u0017m]3QCRD\u0007\u0003BAJ\u0003;k!!!&\u000b\t\u0005]\u0015\u0011T\u0001\u0003MNT1!a'W\u0003\u0019A\u0017\rZ8pa&!\u0011qTAK\u0005\u0011\u0001\u0016\r\u001e5\t\u000f\u0005\rF\u00031\u0001\u0002:\u00059a/\u001a:tS>t\u0007bBAT)\u0001\u0007\u0011\u0011V\u0001\u000bQ\u0006$wn\u001c9D_:4\u0007\u0003BAV\u0003ck!!!,\u000b\t\u0005=\u0016\u0011T\u0001\u0005G>tg-\u0003\u0003\u00024\u00065&!D\"p]\u001aLw-\u001e:bi&|g.\u0001\u000bhKR,\u0015M\u001d7jKN$H)\u001a7uC\u001aKG.\u001a\u000b\u0005\u0003s\tI\fC\u0003i+\u0001\u0007\u0011.\u0001\u0013Q\u001fR+e\nV%B\u00192Kv,\u0016(N\u001f:{Ek\u0014(J5\u0016#u\fV%N\u000bN#\u0016)\u0014)T+\u0005q\u0017!\n)P)\u0016sE+S!M\u0019f{VKT'P\u001d>#vJT%[\u000b\u0012{F+S'F'R\u000bU\nU*!\u0003)9W\r^\"p[6LGo\u001d\u000b\r\u0003\u000b\u0014YF!\u0018\u0003b\t\r$Q\r\t\u0006;\u0006\u001d\u00171Z\u0005\u0004\u0003\u0013t&!B!se\u0006L\bcAAg95\t!C\u0001\u0004D_6l\u0017\u000e^\n\t9q\u000b\u0019.!7\u0002`B!\u00111OAk\u0013\u0011\t9.!\u001e\u0003\u0019\r{W.\\5u\u001b\u0006\u00148.\u001a:\u0011\u0007u\u000bY.C\u0002\u0002^z\u0013q\u0001\u0015:pIV\u001cG\u000fE\u0002^\u0003CL1!a9_\u00051\u0019VM]5bY&T\u0018M\u00197f+\t\tI$\u0001\u0005wKJ\u001c\u0018n\u001c8!\u0003%!\u0018.\\3ti\u0006l\u0007/\u0001\u0006uS6,7\u000f^1na\u0002\"b!a3\u0002p\u0006E\bbBARC\u0001\u0007\u0011\u0011\b\u0005\b\u0003S\f\u0003\u0019AA\u001d\u000359\u0018\u000e\u001e5US6,7\u000f^1naR!\u00111ZA|\u0011\u001d\tIO\ta\u0001\u0003s\tAbZ3u)&lWm\u001d;b[B\f!bZ3u-\u0016\u00148/[8o\u0003\u0011\u0019w\u000e]=\u0015\r\u0005-'\u0011\u0001B\u0002\u0011%\t\u0019+\nI\u0001\u0002\u0004\tI\u0004C\u0005\u0002j\u0016\u0002\n\u00111\u0001\u0002:\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001B\u0005U\u0011\tI$a\u0013\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"A!\u0005\u0011\t\tM!QD\u0007\u0003\u0005+QAAa\u0006\u0003\u001a\u0005!A.\u00198h\u0015\t\u0011Y\"\u0001\u0003kCZ\f\u0017\u0002\u0002B\u0010\u0005+\u0011aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005O\u0011i\u0003E\u0002^\u0005SI1Aa\u000b_\u0005\r\te.\u001f\u0005\t\u0005_Q\u0013\u0011!a\u0001]\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!\u000e\u0011\r\t]\"Q\bB\u0014\u001b\t\u0011IDC\u0002\u0003<y\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011yD!\u000f\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005\u000b\u0012Y\u0005E\u0002^\u0005\u000fJ1A!\u0013_\u0005\u001d\u0011un\u001c7fC:D\u0011Ba\f-\u0003\u0003\u0005\rAa\n\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012A\\\u0001\ti>\u001cFO]5oOR\u0011!\u0011C\u0001\u0007KF,\u0018\r\\:\u0015\t\t\u0015#\u0011\f\u0005\n\u0005_y\u0013\u0011!a\u0001\u0005OAq!a \u0019\u0001\u0004\t\t\tC\u0004\u0003`a\u0001\r!!%\u0002\u000f1|w\rU1uQ\"9\u0011q\u0007\rA\u0002\u0005e\u0002bBA!1\u0001\u0007\u00111\t\u0005\b\u0003OC\u0002\u0019AAU\u0003iiwN\\8u_:L'0Z\"p[6LG\u000fV5nKN$\u0018-\u001c9t+\u0011\u0011YGa\u001d\u0015\t\t5$q\u0010\t\u0006;\u0006\u001d'q\u000e\t\u0005\u0005c\u0012\u0019\b\u0004\u0001\u0005\u000f\tU\u0014D1\u0001\u0003x\t\tA+\u0005\u0003\u0003z\u0005M\u0007cA/\u0003|%\u0019!Q\u00100\u0003\u000f9{G\u000f[5oO\"9!\u0011Q\rA\u0002\t5\u0014aB2p[6LGo]\u0001\u0010a\u0006\u0014\u0018\r\u001c7fYN+\u0017M]2iaQ\u0001\u00121\u001aBD\u0005\u0013\u0013YIa'\u0003 \n\u0005&1\u0015\u0005\u0006+j\u0001\ra\u001e\u0005\u0007\u0003_S\u0002\u0019A?\t\u000f\t}#\u00041\u0001\u0003\u000eB!!q\u0012BL\u001d\u0011\u0011\tJa%\u0011\u0007\u0005Ea,C\u0002\u0003\u0016z\u000ba\u0001\u0015:fI\u00164\u0017\u0002\u0002B\u0010\u00053S1A!&_\u0011\u001d\u0011iJ\u0007a\u0001\u0003s\tA\u0001^5nK\"9\u0011q\u0007\u000eA\u0002\u0005e\u0002bBA!5\u0001\u0007\u0011\u0011\b\u0005\b\u0005KS\u0002\u0019AA\u001d\u0003\u0011\u0019H/\u001a9\u000231\f7\u000f^\"p[6LGOQ3g_J,G+[7fgR\fW\u000e\u001d\u000b\u0007\u0005W\u0013iK!-\u0011\u000bu\u000by#a3\t\u000f\t\u00055\u00041\u0001\u00030B1\u0011QBA\u000f\u0003\u0017DqA!(\u001c\u0001\u0004\tI$\u0001\u0004D_6l\u0017\u000e\u001e\t\u0004\u0003\u001b\f4#B\u0019\u0003:\u0006}\u0007C\u0003B^\u0005\u0003\fI$!\u000f\u0002L6\u0011!Q\u0018\u0006\u0004\u0005\u007fs\u0016a\u0002:v]RLW.Z\u0005\u0005\u0005\u0007\u0014iLA\tBEN$(/Y2u\rVt7\r^5p]J\"\"A!.\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\u0005-'1\u001aBg\u0011\u001d\t\u0019\u000b\u000ea\u0001\u0003sAq!!;5\u0001\u0004\tI$A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\tM'1\u001c\t\u0006;\u0006=\"Q\u001b\t\b;\n]\u0017\u0011HA\u001d\u0013\r\u0011IN\u0018\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\tuW'!AA\u0002\u0005-\u0017a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011\u0019\u000f\u0005\u0003\u0003\u0014\t\u0015\u0018\u0002\u0002Bt\u0005+\u0011aa\u00142kK\u000e$(\u0001\b\"vM\u001a,'/\u001b8h\u0019><G)\u001a7fi&|g.\u0013;fe\u0006$xN]\n\u0005oq\u0013i\u000f\u0005\u0004\u0002\u000e\t=(\u0011_\u0005\u0005\u0005\u007f\t\t\u0003\u0005\u0003\u0002\u0014\nM\u0018\u0002\u0002B{\u0003+\u0013!BR5mKN#\u0018\r^;t\u0003))h\u000eZ3sYfLgnZ\u0001\r[\u0006DH+[7fgR\fW\u000e]\u0001\u000b[\u0006Dh+\u001a:tS>t\u0017!\u0004<feNLwN\\$fiR,'\u000fE\u0004^\u0007\u0003\t\t*!\u000f\n\u0007\r\raLA\u0005Gk:\u001cG/[8ocQQ1qAB\u0005\u0007\u0017\u0019iaa\u0004\u0011\u0007\u00055w\u0007C\u0004\u0003xr\u0002\rA!<\t\u000f\teH\b1\u0001\u0002:!9!1 \u001fA\u0002\u0005e\u0002b\u0002B\u007fy\u0001\u0007!q`\u0001\u000eM&dWm\u001d+p\t\u0016dW\r^3\u0016\u0005\rU\u0001CBB\f\u0007;\u0011\t0\u0004\u0002\u0004\u001a)!11\u0004B\u001d\u0003\u001diW\u000f^1cY\u0016LAaa\b\u0004\u001a\t)\u0011+^3vK\u0006qa-\u001b7fgR{G)\u001a7fi\u0016\u0004\u0013\u0001E7bs\n,G)\u001a7fi\u00164\u0015\u000e\\3t+\t\u00199\u0003\u0005\u0004\u0004\u0018\r%\"\u0011_\u0005\u0005\u0007W\u0019IBA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\u0018!E7bs\n,G)\u001a7fi\u00164\u0015\u000e\\3tA\u0005AA.Y:u\r&dW-\u0006\u0002\u0003r\u0006aA.Y:u\r&dWm\u0018\u0013fcR!1qGB\u001f!\ri6\u0011H\u0005\u0004\u0007wq&\u0001B+oSRD\u0011Ba\fC\u0003\u0003\u0005\rA!=\u0002\u00131\f7\u000f\u001e$jY\u0016\u0004\u0013!\u00045bg:+\u0007\u0010^\"bY2,G-\u0006\u0002\u0003F\u0005\t\u0002.Y:OKb$8)\u00197mK\u0012|F%Z9\u0015\t\r]2\u0011\n\u0005\n\u0005_)\u0015\u0011!a\u0001\u0005\u000b\na\u0002[1t\u001d\u0016DHoQ1mY\u0016$\u0007%\u0001\u0003j]&$HCAB\u001c\u0003A\u0019\bn\\;mI\u0012+G.\u001a;f\r&dW\r\u0006\u0003\u0003F\rU\u0003bBB,\u0011\u0002\u0007!\u0011_\u0001\u0005M&dW-A\noK\u0016$7\u000fV5nK\u0006#'.^:u[\u0016tG\u000f\u0006\u0003\u0003F\ru\u0003bBB,\u0013\u0002\u0007!\u0011_\u0001\fM2,8\u000f\u001b\"vM\u001a,'/\u0001\nrk\u0016,XMR5mKNLeNQ;gM\u0016\u0014\u0018a\u00025bg:+\u0007\u0010^\u0001\u0005]\u0016DH\u000f\u0006\u0002\u0003r\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII*\"a!\u001c+\u00079\fY\u0005C\u0004\u0002j&\u0001\ra!\u001d\u0011\t\rM4qO\u0007\u0003\u0007kR1a\u0015B\r\u0013\u0011\u0019Ih!\u001e\u0003\u0013QKW.Z:uC6\u0004\bbBB?\u0013\u0001\u0007!QI\u0001\u0014G\u0006t'+\u001a;ve:d\u0015m\u001d;D_6l\u0017\u000e\u001e\u0005\n\u0007\u0003K\u0001\u0013!a\u0001\u0005\u000b\n\u0011#\\;ti\n+'+Z2sK\u0006$\u0018M\u00197f\u0011%\u0019))\u0003I\u0001\u0002\u0004\u0011)%A\fdC:\u0014V\r^;s]\u0016\u000b'\u000f\\5fgR\u001cu.\\7ji\u0006yr-\u001a;BGRLg/Z\"p[6LG/\u0011;US6,G\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\r-%\u0006\u0002B#\u0003\u0017\nqdZ3u\u0003\u000e$\u0018N^3D_6l\u0017\u000e^!u)&lW\r\n3fM\u0006,H\u000e\u001e\u00135\u0003I\u0019\u0007.Z2l-\u0016\u00148/[8o\u000bbL7\u000f^:\u0015\u0011\r]21SBK\u0007/Cq!a)\r\u0001\u0004\tI\u0004C\u0005\u0004\u00022\u0001\n\u00111\u0001\u0003F!I1\u0011\u0014\u0007\u0011\u0002\u0003\u0007!QI\u0001\u0010C2dwn^(vi>3'+\u00198hK\u0006a2\r[3dWZ+'o]5p]\u0016C\u0018n\u001d;tI\u0011,g-Y;mi\u0012\u0012\u0014\u0001H2iK\u000e\\g+\u001a:tS>tW\t_5tiN$C-\u001a4bk2$HeM\u0001\u000fa\u0006\u0014\u0018\r\u001c7fYN+\u0017M]2i)!\t\tga)\u0004&\u000e\u001d\u0006b\u0002BO\u001f\u0001\u0007\u0011\u0011\b\u0005\b\u0003oy\u0001\u0019AA\u001d\u0011\u001d\t\te\u0004a\u0001\u0003s\tAdZ3u\u000b\u0006\u0014H.[3tiJ+7M]3bi\u0006\u0014G.Z\"p[6LG\u000f")
public class DeltaHistoryManager
implements DeltaLogging {
    private final DeltaLog deltaLog;
    private final int maxKeysPerList;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static int $lessinit$greater$default$2() {
        return DeltaHistoryManager$.MODULE$.$lessinit$greater$default$2();
    }

    public static long getEarliestDeltaFile(DeltaLog deltaLog) {
        return DeltaHistoryManager$.MODULE$.getEarliestDeltaFile(deltaLog);
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SparkSession spark() {
        return SparkSession$.MODULE$.active();
    }

    private SerializableConfiguration getSerializableHadoopConf() {
        return new SerializableConfiguration(this.deltaLog.newDeltaHadoopConf());
    }

    public Seq<DeltaHistory> getHistory(Option<Object> limitOpt) {
        long listStart = BoxesRunTime.unboxToLong((Object)limitOpt.map((Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)limit -> scala.math.package$.MODULE$.max($this.deltaLog.update($this.deltaLog.update$default$1(), $this.deltaLog.update$default$2()).version() - (long)limit + 1L, 0L)).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> DeltaHistoryManager$.MODULE$.getEarliestDeltaFile($this.deltaLog)));
        return this.getHistory(listStart, this.getHistory$default$2());
    }

    public Seq<DeltaHistory> getHistory(long start, Option<Object> end) {
        SerializableConfiguration conf = this.getSerializableHadoopConf();
        String logPath = this.deltaLog.logPath().toString();
        Dataset info = this.spark().range(start, BoxesRunTime.unboxToLong((Object)end.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> $this.deltaLog.update($this.deltaLog.update$default$1(), $this.deltaLog.update$default$2()).version())) + 1L).mapPartitions((Function1 & Serializable & scala.Serializable)versions -> {
            LogStore logStore = LogStore$.MODULE$.apply(SparkEnv$.MODULE$.get().conf(), conf.value());
            Path basePath = new Path(logPath);
            FileSystem fs = basePath.getFileSystem(conf.value());
            return versions.flatMap((Function1 & Serializable & scala.Serializable)commit -> {
                Iterable iterable;
                try {
                    CommitInfo ci = DeltaHistoryManager$.MODULE$.org$apache$spark$sql$delta$DeltaHistoryManager$$getCommitInfo(logStore, basePath, Predef$.MODULE$.Long2long(commit), conf.value());
                    FileStatus metadata = fs.getFileStatus(FileNames$.MODULE$.deltaFile(basePath, Predef$.MODULE$.Long2long(commit)));
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)ci.withTimestamp(metadata.getModificationTime())));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                return iterable;
            }).map((Function1 & Serializable & scala.Serializable)ci -> DeltaHistory$.MODULE$.fromCommitInfo((CommitInfo)ci));
        }, package$.MODULE$.deltaHistoryEncoder());
        return Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])DeltaHistoryManager$.MODULE$.org$apache$spark$sql$delta$DeltaHistoryManager$$monotonizeCommitTimestamps((CommitMarker[])info.collect()))).reverse());
    }

    public Option<Object> getHistory$default$2() {
        return None$.MODULE$;
    }

    public Commit getActiveCommitAtTime(Timestamp timestamp, boolean canReturnLastCommit, boolean mustBeRecreatable, boolean canReturnEarliestCommit) {
        Commit commit;
        long time = timestamp.getTime();
        long earliest = mustBeRecreatable ? this.getEarliestRecreatableCommit() : DeltaHistoryManager$.MODULE$.getEarliestDeltaFile(this.deltaLog);
        long latestVersion = this.deltaLog.update(this.deltaLog.update$default$1(), this.deltaLog.update$default$2()).version();
        if (latestVersion - earliest > (long)(2 * this.maxKeysPerList)) {
            commit = this.parallelSearch(time, earliest, latestVersion + 1L);
        } else {
            Commit[] commits = DeltaHistoryManager$.MODULE$.getCommits(this.deltaLog.store(), this.deltaLog.logPath(), earliest, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)(latestVersion + 1L))), this.deltaLog.newDeltaHadoopConf());
            commit = (Commit)DeltaHistoryManager$.MODULE$.org$apache$spark$sql$delta$DeltaHistoryManager$$lastCommitBeforeTimestamp((Seq<Commit>)Predef$.MODULE$.wrapRefArray((Object[])commits), time).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Commit)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])commits)).head());
        }
        Commit commit2 = commit;
        Timestamp commitTs = new Timestamp(commit2.timestamp());
        TimestampFormatter timestampFormatter = TimestampFormatter$.MODULE$.apply(DateTimeUtils$.MODULE$.getTimeZone(SQLConf$.MODULE$.get().sessionLocalTimeZone()));
        String tsString = DateTimeUtils$.MODULE$.timestampToString(timestampFormatter, DateTimeUtils$.MODULE$.fromJavaTimestamp(commitTs));
        if (commit2.timestamp() > time && !canReturnEarliestCommit) {
            throw new DeltaErrorsBase.TimestampEarlierThanCommitRetentionException(DeltaErrors$.MODULE$, timestamp, commitTs, tsString);
        }
        if (commit2.version() == latestVersion && !canReturnLastCommit && commit2.timestamp() < time) {
            throw new DeltaErrorsBase.TemporallyUnstableInputException(DeltaErrors$.MODULE$, timestamp, commitTs, tsString, commit2.version());
        }
        return commit2;
    }

    public boolean getActiveCommitAtTime$default$3() {
        return true;
    }

    public boolean getActiveCommitAtTime$default$4() {
        return false;
    }

    public void checkVersionExists(long version, boolean mustBeRecreatable, boolean allowOutOfRange) {
        long earliest = mustBeRecreatable ? this.getEarliestRecreatableCommit() : DeltaHistoryManager$.MODULE$.getEarliestDeltaFile(this.deltaLog);
        long latest = this.deltaLog.update(this.deltaLog.update$default$1(), this.deltaLog.update$default$2()).version();
        if (version < earliest || version > latest && !allowOutOfRange) {
            throw new VersionNotFoundException(version, earliest, latest);
        }
    }

    public boolean checkVersionExists$default$2() {
        return true;
    }

    public boolean checkVersionExists$default$3() {
        return false;
    }

    private Commit parallelSearch(long time, long start, long end) {
        return DeltaHistoryManager$.MODULE$.org$apache$spark$sql$delta$DeltaHistoryManager$$parallelSearch0(this.spark(), this.getSerializableHadoopConf(), this.deltaLog.logPath().toString(), time, start, end, this.maxKeysPerList);
    }

    public long getEarliestRecreatableCommit() {
        Iterator files = this.deltaLog.store().listFrom(FileNames$.MODULE$.listingPrefix(this.deltaLog.logPath(), 0L), this.deltaLog.newDeltaHadoopConf()).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)DeltaHistoryManager.$anonfun$getEarliestRecreatableCommit$1(f)));
        HashMap checkpointMap = new HashMap();
        LongRef smallestDeltaVersion = LongRef.create((long)Long.MAX_VALUE);
        None$ lastCompleteCheckpoint = None$.MODULE$;
        while (files.hasNext()) {
            BoxedUnit boxedUnit;
            Path nextFilePath = ((FileStatus)files.next()).getPath();
            if (FileNames$.MODULE$.isDeltaFile(nextFilePath)) {
                long version = FileNames$.MODULE$.deltaVersion(nextFilePath);
                if (version == 0L) {
                    return version;
                }
                smallestDeltaVersion.elem = scala.math.package$.MODULE$.min(version, smallestDeltaVersion.elem);
                if (lastCompleteCheckpoint.exists((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$1 -> x$1 >= smallestDeltaVersion$1.elem - 1L)) {
                    return BoxesRunTime.unboxToLong((Object)lastCompleteCheckpoint.get());
                }
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (FileNames$.MODULE$.isCheckpointFile(nextFilePath)) {
                int preCount;
                long checkpointVersion = FileNames$.MODULE$.checkpointVersion(nextFilePath);
                Option<Object> parts = FileNames$.MODULE$.numCheckpointParts(nextFilePath);
                if (parts.isEmpty()) {
                    lastCompleteCheckpoint = new Some((Object)BoxesRunTime.boxToLong((long)checkpointVersion));
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                int numParts = BoxesRunTime.unboxToInt((Object)parts.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1));
                if (numParts == (preCount = BoxesRunTime.unboxToInt((Object)checkpointMap.getOrElse((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)checkpointVersion)), (Object)BoxesRunTime.boxToInteger((int)numParts)), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0))) + 1) {
                    lastCompleteCheckpoint = new Some((Object)BoxesRunTime.boxToLong((long)checkpointVersion));
                }
                boxedUnit = checkpointMap.put((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)checkpointVersion)), (Object)BoxesRunTime.boxToInteger((int)numParts)), (Object)BoxesRunTime.boxToInteger((int)(preCount + 1)));
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        if (lastCompleteCheckpoint.exists((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$2 -> x$2 >= smallestDeltaVersion$1.elem)) {
            return BoxesRunTime.unboxToLong((Object)lastCompleteCheckpoint.get());
        }
        if (smallestDeltaVersion.elem < Long.MAX_VALUE) {
            throw DeltaErrors$.MODULE$.noRecreatableHistoryFound(this.deltaLog.logPath());
        }
        throw DeltaErrors$.MODULE$.noHistoryFound(this.deltaLog.logPath());
    }

    public static final /* synthetic */ boolean $anonfun$getEarliestRecreatableCommit$1(FileStatus f) {
        return FileNames$.MODULE$.isDeltaFile(f) || FileNames$.MODULE$.isCheckpointFile(f);
    }

    public DeltaHistoryManager(DeltaLog deltaLog, int maxKeysPerList) {
        this.deltaLog = deltaLog;
        this.maxKeysPerList = maxKeysPerList;
        Logging.$init$((Logging)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
    }

    public static class BufferingLogDeletionIterator
    implements Iterator<FileStatus> {
        private final Iterator<FileStatus> underlying;
        private final long maxTimestamp;
        private final long maxVersion;
        private final Function1<Path, Object> versionGetter;
        private final Queue<FileStatus> filesToDelete;
        private final ArrayBuffer<FileStatus> maybeDeleteFiles;
        private FileStatus lastFile;
        private boolean hasNextCalled;

        public Iterator<FileStatus> seq() {
            return Iterator.seq$((Iterator)this);
        }

        public boolean isEmpty() {
            return Iterator.isEmpty$((Iterator)this);
        }

        public boolean isTraversableAgain() {
            return Iterator.isTraversableAgain$((Iterator)this);
        }

        public boolean hasDefiniteSize() {
            return Iterator.hasDefiniteSize$((Iterator)this);
        }

        public Iterator<FileStatus> take(int n) {
            return Iterator.take$((Iterator)this, (int)n);
        }

        public Iterator<FileStatus> drop(int n) {
            return Iterator.drop$((Iterator)this, (int)n);
        }

        public Iterator<FileStatus> slice(int from, int until) {
            return Iterator.slice$((Iterator)this, (int)from, (int)until);
        }

        public Iterator<FileStatus> sliceIterator(int from, int until) {
            return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
        }

        public <B> Iterator<B> map(Function1<FileStatus, B> f) {
            return Iterator.map$((Iterator)this, f);
        }

        public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
            return Iterator.$plus$plus$((Iterator)this, that);
        }

        public <B> Iterator<B> flatMap(Function1<FileStatus, GenTraversableOnce<B>> f) {
            return Iterator.flatMap$((Iterator)this, f);
        }

        public Iterator<FileStatus> filter(Function1<FileStatus, Object> p) {
            return Iterator.filter$((Iterator)this, p);
        }

        public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<FileStatus, B, Object> p) {
            return Iterator.corresponds$((Iterator)this, that, p);
        }

        public Iterator<FileStatus> withFilter(Function1<FileStatus, Object> p) {
            return Iterator.withFilter$((Iterator)this, p);
        }

        public Iterator<FileStatus> filterNot(Function1<FileStatus, Object> p) {
            return Iterator.filterNot$((Iterator)this, p);
        }

        public <B> Iterator<B> collect(PartialFunction<FileStatus, B> pf) {
            return Iterator.collect$((Iterator)this, pf);
        }

        public <B> Iterator<B> scanLeft(B z, Function2<B, FileStatus, B> op) {
            return Iterator.scanLeft$((Iterator)this, z, op);
        }

        public <B> Iterator<B> scanRight(B z, Function2<FileStatus, B, B> op) {
            return Iterator.scanRight$((Iterator)this, z, op);
        }

        public Iterator<FileStatus> takeWhile(Function1<FileStatus, Object> p) {
            return Iterator.takeWhile$((Iterator)this, p);
        }

        public Tuple2<Iterator<FileStatus>, Iterator<FileStatus>> partition(Function1<FileStatus, Object> p) {
            return Iterator.partition$((Iterator)this, p);
        }

        public Tuple2<Iterator<FileStatus>, Iterator<FileStatus>> span(Function1<FileStatus, Object> p) {
            return Iterator.span$((Iterator)this, p);
        }

        public Iterator<FileStatus> dropWhile(Function1<FileStatus, Object> p) {
            return Iterator.dropWhile$((Iterator)this, p);
        }

        public <B> Iterator<Tuple2<FileStatus, B>> zip(Iterator<B> that) {
            return Iterator.zip$((Iterator)this, that);
        }

        public <A1> Iterator<A1> padTo(int len, A1 elem) {
            return Iterator.padTo$((Iterator)this, (int)len, elem);
        }

        public Iterator<Tuple2<FileStatus, Object>> zipWithIndex() {
            return Iterator.zipWithIndex$((Iterator)this);
        }

        public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
            return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
        }

        public <U> void foreach(Function1<FileStatus, U> f) {
            Iterator.foreach$((Iterator)this, f);
        }

        public boolean forall(Function1<FileStatus, Object> p) {
            return Iterator.forall$((Iterator)this, p);
        }

        public boolean exists(Function1<FileStatus, Object> p) {
            return Iterator.exists$((Iterator)this, p);
        }

        public boolean contains(Object elem) {
            return Iterator.contains$((Iterator)this, (Object)elem);
        }

        public Option<FileStatus> find(Function1<FileStatus, Object> p) {
            return Iterator.find$((Iterator)this, p);
        }

        public int indexWhere(Function1<FileStatus, Object> p) {
            return Iterator.indexWhere$((Iterator)this, p);
        }

        public int indexWhere(Function1<FileStatus, Object> p, int from) {
            return Iterator.indexWhere$((Iterator)this, p, (int)from);
        }

        public <B> int indexOf(B elem) {
            return Iterator.indexOf$((Iterator)this, elem);
        }

        public <B> int indexOf(B elem, int from) {
            return Iterator.indexOf$((Iterator)this, elem, (int)from);
        }

        public BufferedIterator<FileStatus> buffered() {
            return Iterator.buffered$((Iterator)this);
        }

        public <B> Iterator.GroupedIterator<B> grouped(int size) {
            return Iterator.grouped$((Iterator)this, (int)size);
        }

        public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
            return Iterator.sliding$((Iterator)this, (int)size, (int)step);
        }

        public <B> int sliding$default$2() {
            return Iterator.sliding$default$2$((Iterator)this);
        }

        public int length() {
            return Iterator.length$((Iterator)this);
        }

        public Tuple2<Iterator<FileStatus>, Iterator<FileStatus>> duplicate() {
            return Iterator.duplicate$((Iterator)this);
        }

        public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
            return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
        }

        public <B> void copyToArray(Object xs, int start, int len) {
            Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
        }

        public boolean sameElements(Iterator<?> that) {
            return Iterator.sameElements$((Iterator)this, that);
        }

        public Traversable<FileStatus> toTraversable() {
            return Iterator.toTraversable$((Iterator)this);
        }

        public Iterator<FileStatus> toIterator() {
            return Iterator.toIterator$((Iterator)this);
        }

        public Stream<FileStatus> toStream() {
            return Iterator.toStream$((Iterator)this);
        }

        public String toString() {
            return Iterator.toString$((Iterator)this);
        }

        public List<FileStatus> reversed() {
            return TraversableOnce.reversed$((TraversableOnce)this);
        }

        public int size() {
            return TraversableOnce.size$((TraversableOnce)this);
        }

        public boolean nonEmpty() {
            return TraversableOnce.nonEmpty$((TraversableOnce)this);
        }

        public int count(Function1<FileStatus, Object> p) {
            return TraversableOnce.count$((TraversableOnce)this, p);
        }

        public <B> Option<B> collectFirst(PartialFunction<FileStatus, B> pf) {
            return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
        }

        public <B> B $div$colon(B z, Function2<B, FileStatus, B> op) {
            return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
        }

        public <B> B $colon$bslash(B z, Function2<FileStatus, B, B> op) {
            return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
        }

        public <B> B foldLeft(B z, Function2<B, FileStatus, B> op) {
            return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
        }

        public <B> B foldRight(B z, Function2<FileStatus, B, B> op) {
            return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
        }

        public <B> B reduceLeft(Function2<B, FileStatus, B> op) {
            return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
        }

        public <B> B reduceRight(Function2<FileStatus, B, B> op) {
            return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
        }

        public <B> Option<B> reduceLeftOption(Function2<B, FileStatus, B> op) {
            return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
        }

        public <B> Option<B> reduceRightOption(Function2<FileStatus, B, B> op) {
            return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
        }

        public <A1> A1 reduce(Function2<A1, A1, A1> op) {
            return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
        }

        public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
            return TraversableOnce.reduceOption$((TraversableOnce)this, op);
        }

        public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
            return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
        }

        public <B> B aggregate(Function0<B> z, Function2<B, FileStatus, B> seqop, Function2<B, B, B> combop) {
            return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
        }

        public <B> B sum(Numeric<B> num) {
            return (B)TraversableOnce.sum$((TraversableOnce)this, num);
        }

        public <B> B product(Numeric<B> num) {
            return (B)TraversableOnce.product$((TraversableOnce)this, num);
        }

        public Object min(Ordering cmp) {
            return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
        }

        public Object max(Ordering cmp) {
            return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
        }

        public Object maxBy(Function1 f, Ordering cmp) {
            return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
        }

        public Object minBy(Function1 f, Ordering cmp) {
            return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
        }

        public <B> void copyToBuffer(Buffer<B> dest) {
            TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
        }

        public <B> void copyToArray(Object xs, int start) {
            TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
        }

        public <B> void copyToArray(Object xs) {
            TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
        }

        public <B> Object toArray(ClassTag<B> evidence$1) {
            return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
        }

        public List<FileStatus> toList() {
            return TraversableOnce.toList$((TraversableOnce)this);
        }

        public Iterable<FileStatus> toIterable() {
            return TraversableOnce.toIterable$((TraversableOnce)this);
        }

        public Seq<FileStatus> toSeq() {
            return TraversableOnce.toSeq$((TraversableOnce)this);
        }

        public IndexedSeq<FileStatus> toIndexedSeq() {
            return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
        }

        public <B> Buffer<B> toBuffer() {
            return TraversableOnce.toBuffer$((TraversableOnce)this);
        }

        public <B> Set<B> toSet() {
            return TraversableOnce.toSet$((TraversableOnce)this);
        }

        public Vector<FileStatus> toVector() {
            return TraversableOnce.toVector$((TraversableOnce)this);
        }

        public <Col> Col to(CanBuildFrom<Nothing$, FileStatus, Col> cbf) {
            return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
        }

        public <T, U> Map<T, U> toMap(Predef.$less$colon$less<FileStatus, Tuple2<T, U>> ev) {
            return TraversableOnce.toMap$((TraversableOnce)this, ev);
        }

        public String mkString(String start, String sep, String end) {
            return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
        }

        public String mkString(String sep) {
            return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
        }

        public String mkString() {
            return TraversableOnce.mkString$((TraversableOnce)this);
        }

        public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
        }

        public StringBuilder addString(StringBuilder b, String sep) {
            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
        }

        public StringBuilder addString(StringBuilder b) {
            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
        }

        public int sizeHintIfCheap() {
            return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
        }

        private Queue<FileStatus> filesToDelete() {
            return this.filesToDelete;
        }

        private ArrayBuffer<FileStatus> maybeDeleteFiles() {
            return this.maybeDeleteFiles;
        }

        private FileStatus lastFile() {
            return this.lastFile;
        }

        private void lastFile_$eq(FileStatus x$1) {
            this.lastFile = x$1;
        }

        private boolean hasNextCalled() {
            return this.hasNextCalled;
        }

        private void hasNextCalled_$eq(boolean x$1) {
            this.hasNextCalled = x$1;
        }

        private void init() {
            if (this.underlying.hasNext()) {
                this.lastFile_$eq((FileStatus)this.underlying.next());
                this.maybeDeleteFiles().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FileStatus[]{this.lastFile()}));
                return;
            }
        }

        private boolean shouldDeleteFile(FileStatus file) {
            return file.getModificationTime() <= this.maxTimestamp && BoxesRunTime.unboxToLong((Object)this.versionGetter.apply((Object)file.getPath())) <= this.maxVersion;
        }

        private boolean needsTimeAdjustment(FileStatus file) {
            return BoxesRunTime.unboxToLong((Object)this.versionGetter.apply((Object)this.lastFile().getPath())) < BoxesRunTime.unboxToLong((Object)this.versionGetter.apply((Object)file.getPath())) && this.lastFile().getModificationTime() >= file.getModificationTime();
        }

        private void flushBuffer() {
            Object object = this.maybeDeleteFiles().lastOption().exists((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)this.shouldDeleteFile(file))) ? this.filesToDelete().$plus$plus$eq(this.maybeDeleteFiles()) : BoxedUnit.UNIT;
            this.maybeDeleteFiles().clear();
        }

        private void queueFilesInBuffer() {
            boolean continueBuffering = true;
            while (continueBuffering) {
                if (!this.underlying.hasNext()) {
                    this.flushBuffer();
                    return;
                }
                FileStatus currentFile = (FileStatus)this.underlying.next();
                Predef$.MODULE$.require(currentFile != null, (Function0 & Serializable & scala.Serializable)() -> "FileStatus iterator returned null");
                if (this.needsTimeAdjustment(currentFile)) {
                    currentFile = new FileStatus(currentFile.getLen(), currentFile.isDirectory(), (int)currentFile.getReplication(), currentFile.getBlockSize(), this.lastFile().getModificationTime() + 1L, currentFile.getPath());
                    this.maybeDeleteFiles().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FileStatus[]{currentFile}));
                } else {
                    this.flushBuffer();
                    this.maybeDeleteFiles().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FileStatus[]{currentFile}));
                    continueBuffering = false;
                }
                this.lastFile_$eq(currentFile);
            }
        }

        public boolean hasNext() {
            block0: {
                this.hasNextCalled_$eq(true);
                if (!this.filesToDelete().isEmpty()) break block0;
                this.queueFilesInBuffer();
            }
            return this.filesToDelete().nonEmpty();
        }

        public FileStatus next() {
            if (!this.hasNextCalled()) {
                throw new NoSuchElementException();
            }
            this.hasNextCalled_$eq(false);
            return (FileStatus)this.filesToDelete().dequeue();
        }

        public BufferingLogDeletionIterator(Iterator<FileStatus> underlying, long maxTimestamp, long maxVersion, Function1<Path, Object> versionGetter) {
            this.underlying = underlying;
            this.maxTimestamp = maxTimestamp;
            this.maxVersion = maxVersion;
            this.versionGetter = versionGetter;
            GenTraversableOnce.$init$((GenTraversableOnce)this);
            TraversableOnce.$init$((TraversableOnce)this);
            Iterator.$init$((Iterator)this);
            this.filesToDelete = new Queue();
            this.maybeDeleteFiles = new ArrayBuffer();
            this.hasNextCalled = false;
            this.init();
        }
    }

    public static class Commit
    implements CommitMarker,
    Product,
    scala.Serializable {
        private final long version;
        private final long timestamp;

        public long version() {
            return this.version;
        }

        public long timestamp() {
            return this.timestamp;
        }

        @Override
        public Commit withTimestamp(long timestamp) {
            long x$1 = timestamp;
            long x$2 = this.copy$default$1();
            return this.copy(x$2, x$1);
        }

        @Override
        public long getTimestamp() {
            return this.timestamp();
        }

        @Override
        public long getVersion() {
            return this.version();
        }

        public Commit copy(long version, long timestamp) {
            return new Commit(version, timestamp);
        }

        public long copy$default$1() {
            return this.version();
        }

        public long copy$default$2() {
            return this.timestamp();
        }

        public String productPrefix() {
            return "Commit";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this.version());
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.timestamp());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Commit;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.version()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.timestamp()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Commit)) return false;
            boolean bl = true;
            if (!bl) return false;
            Commit commit = (Commit)x$1;
            if (this.version() != commit.version()) return false;
            if (this.timestamp() != commit.timestamp()) return false;
            if (!commit.canEqual(this)) return false;
            return true;
        }

        public Commit(long version, long timestamp) {
            this.version = version;
            this.timestamp = timestamp;
            Product.$init$((Product)this);
        }
    }
}

