/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.RowTrackingFeature$;
import org.apache.spark.sql.delta.actions.Format;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.actions.TableFeatureProtocolUtils$;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class RowTracking$ {
    public static RowTracking$ MODULE$;

    static {
        new RowTracking$();
    }

    public boolean isSupported(Protocol protocol) {
        return protocol.isFeatureSupported(RowTrackingFeature$.MODULE$);
    }

    public boolean isEnabled(Protocol protocol, Metadata metadata) {
        boolean isEnabled = BoxesRunTime.unboxToBoolean((Object)DeltaConfigs$.MODULE$.ROW_TRACKING_ENABLED().fromMetaData(metadata));
        if (isEnabled && !this.isSupported(protocol)) {
            throw new IllegalStateException(new StringBuilder(94).append("Table property '").append(DeltaConfigs$.MODULE$.ROW_TRACKING_ENABLED().key()).append("' is ").append("set on the table but this table version doesn't support table feature ").append("'").append(TableFeatureProtocolUtils$.MODULE$.propertyKey(RowTrackingFeature$.MODULE$)).append("'.").toString());
        }
        return isEnabled;
    }

    public void checkStatsCollectedIfRowTrackingSupported(Protocol protocol, boolean convertToDeltaShouldCollectStats, boolean statsCollectionEnabled) {
        if (!this.isSupported(protocol)) {
            return;
        }
        if (!convertToDeltaShouldCollectStats || !statsCollectionEnabled) {
            throw DeltaErrors$.MODULE$.convertToDeltaRowTrackingEnabledWithoutStatsCollection();
        }
    }

    public Metadata takeRowTrackingPropertyFromTarget(Metadata targetMetadata, Metadata sourceMetadata) {
        ObjectRef newConfig = ObjectRef.create((Object)((Map)sourceMetadata.configuration().$minus((Object)DeltaConfigs$.MODULE$.ROW_TRACKING_ENABLED().key())));
        targetMetadata.configuration().get((Object)DeltaConfigs$.MODULE$.ROW_TRACKING_ENABLED().key()).foreach((Function1 & java.io.Serializable & Serializable)v -> {
            newConfig.elem = ((Map)newConfig.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DeltaConfigs$.MODULE$.ROW_TRACKING_ENABLED().key()), (Object)v));
            return BoxedUnit.UNIT;
        });
        Map x$1 = (Map)newConfig.elem;
        String x$2 = sourceMetadata.copy$default$1();
        String x$3 = sourceMetadata.copy$default$2();
        String x$4 = sourceMetadata.copy$default$3();
        Format x$5 = sourceMetadata.copy$default$4();
        String x$6 = sourceMetadata.copy$default$5();
        Seq<String> x$7 = sourceMetadata.copy$default$6();
        Option<Object> x$8 = sourceMetadata.copy$default$8();
        return sourceMetadata.copy(x$2, x$3, x$4, x$5, x$6, x$7, (Map<String, String>)x$1, x$8);
    }

    public Metadata removeRowTrackingProperty(Metadata metadata) {
        Map x$1 = (Map)metadata.configuration().$minus((Object)DeltaConfigs$.MODULE$.ROW_TRACKING_ENABLED().key());
        String x$2 = metadata.copy$default$1();
        String x$3 = metadata.copy$default$2();
        String x$4 = metadata.copy$default$3();
        Format x$5 = metadata.copy$default$4();
        String x$6 = metadata.copy$default$5();
        Seq<String> x$7 = metadata.copy$default$6();
        Option<Object> x$8 = metadata.copy$default$8();
        return metadata.copy(x$2, x$3, x$4, x$5, x$6, x$7, (Map<String, String>)x$1, x$8);
    }

    public Protocol removeRowTrackingTableFeature(Protocol protocol) {
        Option writerFeaturesWithoutRowTracking;
        Option x$12 = writerFeaturesWithoutRowTracking = protocol.writerFeatures().map((Function1 & java.io.Serializable & Serializable)x$1 -> (Set)x$1.$minus((Object)RowTrackingFeature$.MODULE$.name()));
        int x$2 = protocol.copy$default$1();
        int x$3 = protocol.copy$default$2();
        Option<Set<String>> x$4 = protocol.copy$default$3();
        return protocol.copy(x$2, x$3, x$4, (Option<Set<String>>)x$12);
    }

    private RowTracking$() {
        MODULE$ = this;
    }
}

