/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Not;
import org.apache.spark.sql.catalyst.plans.QueryPlan;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaLog$;
import org.apache.spark.sql.delta.DeltaOperations;
import org.apache.spark.sql.delta.DeltaOptions;
import org.apache.spark.sql.delta.DeltaTableUtils$;
import org.apache.spark.sql.delta.OptimisticTransaction;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.AddCDCFile;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.FileAction;
import org.apache.spark.sql.delta.actions.RemoveFile;
import org.apache.spark.sql.delta.actions.SetTransaction;
import org.apache.spark.sql.delta.catalog.DeltaTableV2;
import org.apache.spark.sql.delta.commands.DMLWithDeletionVectorsHelper$;
import org.apache.spark.sql.delta.commands.DeleteCommand$;
import org.apache.spark.sql.delta.commands.DeleteCommandMetrics;
import org.apache.spark.sql.delta.commands.DeleteMetric;
import org.apache.spark.sql.delta.commands.DeletionVectorUtils$;
import org.apache.spark.sql.delta.commands.DeltaCommand;
import org.apache.spark.sql.delta.commands.MergeIntoCommandBase$;
import org.apache.spark.sql.delta.commands.TouchedFileWithDV;
import org.apache.spark.sql.delta.commands.cdc.CDCReader$;
import org.apache.spark.sql.delta.files.TahoeBatchFileIndex;
import org.apache.spark.sql.delta.files.TahoeBatchFileIndex$;
import org.apache.spark.sql.delta.implicits.package$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.metric.IncrementMetric;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.execution.command.LeafRunnableCommand;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tmf\u0001B\u0015+\u0001^B\u0001B\u0017\u0001\u0003\u0016\u0004%\ta\u0017\u0005\tA\u0002\u0011\t\u0012)A\u00059\"A\u0011\r\u0001BK\u0002\u0013\u0005!\r\u0003\u0005m\u0001\tE\t\u0015!\u0003d\u0011!i\u0007A!f\u0001\n\u0003q\u0007\u0002C8\u0001\u0005#\u0005\u000b\u0011\u0002\u001d\t\u0011A\u0004!Q3A\u0005\u0002ED\u0001\"\u001f\u0001\u0003\u0012\u0003\u0006IA\u001d\u0005\u0006u\u0002!\ta\u001f\u0005\b\u0003\u0007\u0001A\u0011IA\u0003\u0011%\ty\u0004\u0001b\u0001\n\u0003\n\t\u0005\u0003\u0005\u0002L\u0001\u0001\u000b\u0011BA\"\u0011)\ti\u0005\u0001EC\u0002\u0013\u0005\u0013q\n\u0005\b\u0003g\u0002AQIA;\u0011\u001d\tY\t\u0001C\u0001\u0003\u001bCq!a+\u0001\t\u0013\ti\u000bC\u0004\u0002h\u0002!\t!!;\t\u0013\u0005U\b!!A\u0005\u0002\u0005]\b\"\u0003B\u0001\u0001E\u0005I\u0011\u0001B\u0002\u0011%\u0011I\u0002AI\u0001\n\u0003\u0011Y\u0002C\u0005\u0003 \u0001\t\n\u0011\"\u0001\u0003\"!I!Q\u0005\u0001\u0012\u0002\u0013\u0005!q\u0005\u0005\n\u0005W\u0001\u0011\u0011!C!\u0005[A\u0011B!\u0010\u0001\u0003\u0003%\tAa\u0010\t\u0013\t\u001d\u0003!!A\u0005\u0002\t%\u0003\"\u0003B(\u0001\u0005\u0005I\u0011\tB)\u0011%\u0011y\u0006AA\u0001\n\u0003\u0011\t\u0007C\u0005\u0003f\u0001\t\t\u0011\"\u0011\u0003h\u001d9!1\u000e\u0016\t\u0002\t5dAB\u0015+\u0011\u0003\u0011y\u0007\u0003\u0004{=\u0011\u0005!q\u000f\u0005\b\u0005srB\u0011\u0001B>\u0011%\u00119I\bb\u0001\n\u0003\u0011I\t\u0003\u0005\u0003\fz\u0001\u000b\u0011BA1\u0011%\u0011iI\bb\u0001\n\u0003\u0011I\t\u0003\u0005\u0003\u0010z\u0001\u000b\u0011BA1\u0011\u001d\u0011\tJ\bC\u0001\u0005'C\u0011B!\u001f\u001f\u0003\u0003%\tIa&\t\u0013\t\u0005f$!A\u0005\u0002\n\r\u0006\"\u0003BY=\u0005\u0005I\u0011\u0002BZ\u00055!U\r\\3uK\u000e{W.\\1oI*\u00111\u0006L\u0001\tG>lW.\u00198eg*\u0011QFL\u0001\u0006I\u0016dG/\u0019\u0006\u0003_A\n1a]9m\u0015\t\t$'A\u0003ta\u0006\u00148N\u0003\u00024i\u00051\u0011\r]1dQ\u0016T\u0011!N\u0001\u0004_J<7\u0001A\n\b\u0001a\u0012%JT)X!\tI\u0004)D\u0001;\u0015\tYD(A\u0004m_\u001eL7-\u00197\u000b\u0005ur\u0014!\u00029mC:\u001c(BA /\u0003!\u0019\u0017\r^1msN$\u0018BA!;\u0005-aunZ5dC2\u0004F.\u00198\u0011\u0005\rCU\"\u0001#\u000b\u0005\u00153\u0015aB2p[6\fg\u000e\u001a\u0006\u0003\u000f:\n\u0011\"\u001a=fGV$\u0018n\u001c8\n\u0005%#%a\u0005'fC\u001a\u0014VO\u001c8bE2,7i\\7nC:$\u0007CA&M\u001b\u0005Q\u0013BA'+\u00051!U\r\u001c;b\u0007>lW.\u00198e!\tYu*\u0003\u0002QU\t!B)\u001a7fi\u0016\u001cu.\\7b]\u0012lU\r\u001e:jGN\u0004\"AU+\u000e\u0003MS\u0011\u0001V\u0001\u0006g\u000e\fG.Y\u0005\u0003-N\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002S1&\u0011\u0011l\u0015\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\tI\u0016dG/\u0019'pOV\tA\f\u0005\u0002^=6\tA&\u0003\u0002`Y\tAA)\u001a7uC2{w-A\u0005eK2$\u0018\rT8hA\u0005a1-\u0019;bY><G+\u00192mKV\t1\rE\u0002SI\u001aL!!Z*\u0003\r=\u0003H/[8o!\t9'.D\u0001i\u0015\tIg(A\u0004dCR\fGn\\4\n\u0005-D'\u0001D\"bi\u0006dwn\u001a+bE2,\u0017!D2bi\u0006dwn\u001a+bE2,\u0007%\u0001\u0004uCJ<W\r^\u000b\u0002q\u00059A/\u0019:hKR\u0004\u0013!C2p]\u0012LG/[8o+\u0005\u0011\bc\u0001*egB\u0011Ao^\u0007\u0002k*\u0011aOP\u0001\fKb\u0004(/Z:tS>t7/\u0003\u0002yk\nQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u0015\r|g\u000eZ5uS>t\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0007yvtx0!\u0001\u0011\u0005-\u0003\u0001\"\u0002.\n\u0001\u0004a\u0006\"B1\n\u0001\u0004\u0019\u0007\"B7\n\u0001\u0004A\u0004\"\u00029\n\u0001\u0004\u0011\u0018!D5o]\u0016\u00148\t[5mIJ,g.\u0006\u0002\u0002\bA1\u0011\u0011BA\r\u0003?qA!a\u0003\u0002\u00169!\u0011QBA\n\u001b\t\tyAC\u0002\u0002\u0012Y\na\u0001\u0010:p_Rt\u0014\"\u0001+\n\u0007\u0005]1+A\u0004qC\u000e\\\u0017mZ3\n\t\u0005m\u0011Q\u0004\u0002\u0004'\u0016\f(bAA\f'B\"\u0011\u0011EA\u0017!\u0019\t\u0019#!\n\u0002*5\tA(C\u0002\u0002(q\u0012\u0011\"U;fef\u0004F.\u00198\u0011\t\u0005-\u0012Q\u0006\u0007\u0001\t-\tyCCA\u0001\u0002\u0003\u0015\t!!\r\u0003\u0007}#\u0013'\u0005\u0003\u00024\u0005e\u0002c\u0001*\u00026%\u0019\u0011qG*\u0003\u000f9{G\u000f[5oOB\u0019!+a\u000f\n\u0007\u0005u2KA\u0002B]f\faa\\;uaV$XCAA\"!\u0019\tI!!\u0007\u0002FA\u0019A/a\u0012\n\u0007\u0005%SOA\u0005BiR\u0014\u0018NY;uK\u00069q.\u001e;qkR\u0004\u0013aB7fiJL7m]\u000b\u0003\u0003#\u0002\u0002\"a\u0015\u0002\\\u0005\u0005\u0014q\r\b\u0005\u0003+\n9\u0006E\u0002\u0002\u000eMK1!!\u0017T\u0003\u0019\u0001&/\u001a3fM&!\u0011QLA0\u0005\ri\u0015\r\u001d\u0006\u0004\u00033\u001a\u0006\u0003BA*\u0003GJA!!\u001a\u0002`\t11\u000b\u001e:j]\u001e\u0004B!!\u001b\u0002p5\u0011\u00111\u000e\u0006\u0004\u0003[2\u0015AB7fiJL7-\u0003\u0003\u0002r\u0005-$!C*R\u00196+GO]5d\u0003\r\u0011XO\u001c\u000b\u0005\u0003o\n\t\t\u0005\u0004\u0002\n\u0005e\u0011\u0011\u0010\t\u0005\u0003w\ni(D\u0001/\u0013\r\tyH\f\u0002\u0004%><\bbBAB\u001d\u0001\u0007\u0011QQ\u0001\rgB\f'o[*fgNLwN\u001c\t\u0005\u0003w\n9)C\u0002\u0002\n:\u0012Ab\u00159be.\u001cVm]:j_:\fQ\u0002]3sM>\u0014X\u000eR3mKR,G\u0003CAH\u0003;\u000by*!)\u0011\r\u0005%\u0011\u0011DAI!\u0011\t\u0019*!'\u000e\u0005\u0005U%bAALY\u00059\u0011m\u0019;j_:\u001c\u0018\u0002BAN\u0003+\u0013a!Q2uS>t\u0007bBAB\u001f\u0001\u0007\u0011Q\u0011\u0005\u00065>\u0001\r\u0001\u0018\u0005\b\u0003G{\u0001\u0019AAS\u0003\r!\bP\u001c\t\u0004;\u0006\u001d\u0016bAAUY\t)r\n\u001d;j[&\u001cH/[2Ue\u0006t7/Y2uS>t\u0017\u0001\u0004:foJLG/\u001a$jY\u0016\u001cHCCAX\u0003o\u000bI,!7\u0002^B1\u0011\u0011BA\r\u0003c\u0003B!a%\u00024&!\u0011QWAK\u0005)1\u0015\u000e\\3BGRLwN\u001c\u0005\b\u0003G\u0003\u0002\u0019AAS\u0011\u001d\tY\f\u0005a\u0001\u0003{\u000b\u0001BY1tK\u0012\u000bG/\u0019\t\u0005\u0003\u007f\u000b\u0019N\u0004\u0003\u0002B\u0006Eg\u0002BAb\u0003\u001ftA!!2\u0002N:!\u0011qYAf\u001d\u0011\ti!!3\n\u0003UJ!a\r\u001b\n\u0005E\u0012\u0014BA\u00181\u0013\r\t9BL\u0005\u0005\u0003+\f9NA\u0005ECR\fgI]1nK*\u0019\u0011q\u0003\u0018\t\r\u0005m\u0007\u00031\u0001t\u0003=1\u0017\u000e\u001c;fe\u000e{g\u000eZ5uS>t\u0007bBAp!\u0001\u0007\u0011\u0011]\u0001\u0012]Vlg)\u001b7fgR{'+Z<sSR,\u0007c\u0001*\u0002d&\u0019\u0011Q]*\u0003\t1{gnZ\u0001%g\"|W\u000f\u001c3Xe&$X\rU3sg&\u001cH/\u001a8u\t\u0016dW\r^5p]Z+7\r^8sgR1\u00111^Ay\u0003g\u00042AUAw\u0013\r\tyo\u0015\u0002\b\u0005>|G.Z1o\u0011\u0019\t\u0014\u00031\u0001\u0002\u0006\"9\u00111U\tA\u0002\u0005\u0015\u0016\u0001B2paf$\u0012\u0002`A}\u0003w\fi0a@\t\u000fi\u0013\u0002\u0013!a\u00019\"9\u0011M\u0005I\u0001\u0002\u0004\u0019\u0007bB7\u0013!\u0003\u0005\r\u0001\u000f\u0005\baJ\u0001\n\u00111\u0001s\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"A!\u0002+\u0007q\u00139a\u000b\u0002\u0003\nA!!1\u0002B\u000b\u001b\t\u0011iA\u0003\u0003\u0003\u0010\tE\u0011!C;oG\",7m[3e\u0015\r\u0011\u0019bU\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\f\u0005\u001b\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"A!\b+\u0007\r\u00149!\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\t\r\"f\u0001\u001d\u0003\b\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"TC\u0001B\u0015U\r\u0011(qA\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\t=\u0002\u0003\u0002B\u0019\u0005wi!Aa\r\u000b\t\tU\"qG\u0001\u0005Y\u0006twM\u0003\u0002\u0003:\u0005!!.\u0019<b\u0013\u0011\t)Ga\r\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\t\u0005\u0003c\u0001*\u0003D%\u0019!QI*\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005e\"1\n\u0005\n\u0005\u001bJ\u0012\u0011!a\u0001\u0005\u0003\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B*!\u0019\u0011)Fa\u0017\u0002:5\u0011!q\u000b\u0006\u0004\u00053\u001a\u0016AC2pY2,7\r^5p]&!!Q\fB,\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005-(1\r\u0005\n\u0005\u001bZ\u0012\u0011!a\u0001\u0003s\ta!Z9vC2\u001cH\u0003BAv\u0005SB\u0011B!\u0014\u001d\u0003\u0003\u0005\r!!\u000f\u0002\u001b\u0011+G.\u001a;f\u0007>lW.\u00198e!\tYed\u0005\u0003\u001f\u0005c:\u0006c\u0001*\u0003t%\u0019!QO*\u0003\r\u0005s\u0017PU3g)\t\u0011i'A\u0003baBd\u0017\u0010F\u0002}\u0005{BqAa !\u0001\u0004\u0011\t)\u0001\u0004eK2,G/\u001a\t\u0004s\t\r\u0015b\u0001BCu\tYA)\u001a7uC\u0012+G.\u001a;f\u0003A1\u0015\nT#`\u001d\u0006kUiX\"P\u0019Vke*\u0006\u0002\u0002b\u0005\tb)\u0013'F?:\u000bU*R0D\u001f2+VJ\u0014\u0011\u00023\u0019Ke\nR%O\u000f~#v*V\"I\u000b\u0012{f)\u0013'F'~k5kR\u0001\u001b\r&sE)\u0013(H?R{Uk\u0011%F\t~3\u0015\nT#T?6\u001bv\tI\u0001\u0012e\u0016<(/\u001b;j]\u001e4\u0015\u000e\\3t\u001bN<G\u0003BA1\u0005+Cq!a8&\u0001\u0004\t\t\u000fF\u0005}\u00053\u0013YJ!(\u0003 \")!L\na\u00019\")\u0011M\na\u0001G\")QN\na\u0001q!)\u0001O\na\u0001e\u00069QO\\1qa2LH\u0003\u0002BS\u0005[\u0003BA\u00153\u0003(B9!K!+]Gb\u0012\u0018b\u0001BV'\n1A+\u001e9mKRB\u0001Ba,(\u0003\u0003\u0005\r\u0001`\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"A!.\u0011\t\tE\"qW\u0005\u0005\u0005s\u0013\u0019D\u0001\u0004PE*,7\r\u001e")
public class DeleteCommand
extends LogicalPlan
implements LeafRunnableCommand,
DeltaCommand,
DeleteCommandMetrics,
scala.Serializable {
    private Map<String, SQLMetric> metrics;
    private final DeltaLog deltaLog;
    private final Option<CatalogTable> catalogTable;
    private final LogicalPlan target;
    private final Option<Expression> condition;
    private final Seq<Attribute> output;
    private transient SparkContext org$apache$spark$sql$delta$commands$DeleteCommandMetrics$$sc;
    private final Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple4<DeltaLog, Option<CatalogTable>, LogicalPlan, Option<Expression>>> unapply(DeleteCommand deleteCommand) {
        return DeleteCommand$.MODULE$.unapply(deleteCommand);
    }

    public static String rewritingFilesMsg(long l) {
        return DeleteCommand$.MODULE$.rewritingFilesMsg(l);
    }

    public static String FINDING_TOUCHED_FILES_MSG() {
        return DeleteCommand$.MODULE$.FINDING_TOUCHED_FILES_MSG();
    }

    public static String FILE_NAME_COLUMN() {
        return DeleteCommand$.MODULE$.FILE_NAME_COLUMN();
    }

    @Override
    public Map<String, SQLMetric> createMetrics() {
        return DeleteCommandMetrics.createMetrics$(this);
    }

    @Override
    public Option<Object> getDeletedRowsFromAddFilesAndUpdateMetrics(Seq<AddFile> files) {
        return DeleteCommandMetrics.getDeletedRowsFromAddFilesAndUpdateMetrics$(this, files);
    }

    @Override
    public Seq<Expression> parsePredicates(SparkSession spark, String predicate) {
        return DeltaCommand.parsePredicates$(this, spark, predicate);
    }

    @Override
    public void verifyPartitionPredicates(SparkSession spark, Seq<String> partitionColumns, Seq<Expression> predicates) {
        DeltaCommand.verifyPartitionPredicates$(this, spark, partitionColumns, predicates);
    }

    @Override
    public Map<String, AddFile> generateCandidateFileMap(Path basePath, Seq<AddFile> candidateFiles) {
        return DeltaCommand.generateCandidateFileMap$(this, basePath, candidateFiles);
    }

    @Override
    public Seq<RemoveFile> removeFilesFromPaths(DeltaLog deltaLog, Map<String, AddFile> nameToAddFileMap, Seq<String> filesToRewrite, long operationTimestamp) {
        return DeltaCommand.removeFilesFromPaths$(this, deltaLog, nameToAddFileMap, filesToRewrite, operationTimestamp);
    }

    @Override
    public HadoopFsRelation buildBaseRelation(SparkSession spark, OptimisticTransaction txn, String actionType, Path rootPath, Seq<String> inputLeafFiles, Map<String, AddFile> nameToAddFileMap) {
        return DeltaCommand.buildBaseRelation$(this, spark, txn, actionType, rootPath, inputLeafFiles, nameToAddFileMap);
    }

    @Override
    public AddFile getTouchedFile(Path basePath, String filePath, Map<String, AddFile> nameToAddFileMap) {
        return DeltaCommand.getTouchedFile$(this, basePath, filePath, nameToAddFileMap);
    }

    @Override
    public LogicalPlan resolveIdentifier(Analyzer analyzer, TableIdentifier identifier) {
        return DeltaCommand.resolveIdentifier$(this, analyzer, identifier);
    }

    @Override
    public boolean isCatalogTable(Analyzer analyzer, TableIdentifier tableIdent) {
        return DeltaCommand.isCatalogTable$(this, analyzer, tableIdent);
    }

    @Override
    public boolean isPathIdentifier(TableIdentifier tableIdent) {
        return DeltaCommand.isPathIdentifier$(this, tableIdent);
    }

    @Override
    public DeltaLog getDeltaLog(SparkSession spark, Option<String> path, Option<TableIdentifier> tableIdentifier, String operationName, Map<String, String> hadoopConf) {
        return DeltaCommand.getDeltaLog$(this, spark, path, tableIdentifier, operationName, hadoopConf);
    }

    @Override
    public Map<String, String> getDeltaLog$default$5() {
        return DeltaCommand.getDeltaLog$default$5$(this);
    }

    @Override
    public void sendDriverMetrics(SparkSession spark, Map<String, SQLMetric> metrics) {
        DeltaCommand.sendDriverMetrics$(this, spark, metrics);
    }

    @Override
    public DeltaTableV2 getDeltaTable(LogicalPlan target, String cmd) {
        return DeltaCommand.getDeltaTable$(this, target, cmd);
    }

    @Override
    public Option<CatalogTable> getTableCatalogTable(LogicalPlan target, String cmd) {
        return DeltaCommand.getTableCatalogTable$(this, target, cmd);
    }

    @Override
    public Tuple2<Option<TableIdentifier>, Option<String>> getDeltaTablePathOrIdentifier(LogicalPlan target, String cmd) {
        return DeltaCommand.getDeltaTablePathOrIdentifier$(this, target, cmd);
    }

    @Override
    public Tuple2<Option<TableIdentifier>, Option<String>> getTablePathOrIdentifier(LogicalPlan target, String cmd) {
        return DeltaCommand.getTablePathOrIdentifier$(this, target, cmd);
    }

    @Override
    public boolean hasBeenExecuted(OptimisticTransaction txn, SparkSession sparkSession, Option<DeltaOptions> options) {
        return DeltaCommand.hasBeenExecuted$(this, txn, sparkSession, options);
    }

    @Override
    public Option<DeltaOptions> hasBeenExecuted$default$3() {
        return DeltaCommand.hasBeenExecuted$default$3$(this);
    }

    @Override
    public Option<SetTransaction> createSetTransaction(SparkSession sparkSession, DeltaLog deltaLog, Option<DeltaOptions> options) {
        return DeltaCommand.createSetTransaction$(this, sparkSession, deltaLog, options);
    }

    @Override
    public Option<DeltaOptions> createSetTransaction$default$3() {
        return DeltaCommand.createSetTransaction$default$3$(this);
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public final Seq<LogicalPlan> children() {
        return LeafLike.children$((LeafLike)this);
    }

    public final TreeNode mapChildren(Function1 f) {
        return LeafLike.mapChildren$((LeafLike)this, (Function1)f);
    }

    public TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return LeafLike.withNewChildrenInternal$((LeafLike)this, (IndexedSeq)newChildren);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private SparkContext org$apache$spark$sql$delta$commands$DeleteCommandMetrics$$sc$lzycompute() {
        DeleteCommand deleteCommand = this;
        synchronized (deleteCommand) {
            if (!this.bitmap$trans$0) {
                this.org$apache$spark$sql$delta$commands$DeleteCommandMetrics$$sc = DeleteCommandMetrics.org$apache$spark$sql$delta$commands$DeleteCommandMetrics$$sc$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.org$apache$spark$sql$delta$commands$DeleteCommandMetrics$$sc;
    }

    @Override
    public SparkContext org$apache$spark$sql$delta$commands$DeleteCommandMetrics$$sc() {
        if (!this.bitmap$trans$0) {
            return this.org$apache$spark$sql$delta$commands$DeleteCommandMetrics$$sc$lzycompute();
        }
        return this.org$apache$spark$sql$delta$commands$DeleteCommandMetrics$$sc;
    }

    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public DeltaLog deltaLog() {
        return this.deltaLog;
    }

    public Option<CatalogTable> catalogTable() {
        return this.catalogTable;
    }

    public LogicalPlan target() {
        return this.target;
    }

    public Option<Expression> condition() {
        return this.condition;
    }

    public Seq<QueryPlan<?>> innerChildren() {
        return (Seq)new .colon.colon((Object)this.target(), (List)Nil$.MODULE$);
    }

    public Seq<Attribute> output() {
        return this.output;
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        DeleteCommand deleteCommand = this;
        synchronized (deleteCommand) {
            if (!this.bitmap$0) {
                this.metrics = this.createMetrics();
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    public Map<String, SQLMetric> metrics() {
        if (!this.bitmap$0) {
            return this.metrics$lzycompute();
        }
        return this.metrics;
    }

    public final Seq<Row> run(SparkSession sparkSession) {
        Seq seq;
        Object object = new Object();
        try {
            this.recordDeltaOperation(this.deltaLog(), "delta.dml.delete", this.recordDeltaOperation$default$3(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.deltaLog().withNewTransaction(this.catalogTable(), this.deltaLog().withNewTransaction$default$2(), (Function1 & Serializable & scala.Serializable)txn -> {
                    DeleteCommand.$anonfun$run$2(this, sparkSession, object, txn);
                    return BoxedUnit.UNIT;
                });
                sparkSession.sharedState().cacheManager().recacheByPlan(sparkSession, this.target());
            });
            seq = ((SQLMetric)this.metrics().apply((Object)"numRemovedFiles")).value() > 0L && ((SQLMetric)this.metrics().apply((Object)"numDeletedRows")).value() == 0L ? (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)-1L)})), (List)Nil$.MODULE$) : (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)((SQLMetric)this.metrics().apply((Object)"numDeletedRows")).value())})), (List)Nil$.MODULE$);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                seq = (Seq)ex.value();
            }
            throw ex;
        }
        return seq;
    }

    public Seq<Action> performDelete(SparkSession sparkSession, DeltaLog deltaLog, OptimisticTransaction txn) {
        Seq seq;
        long numRemovedFiles = 0L;
        long numAddedFiles = 0L;
        long numAddedChangeFiles = 0L;
        long scanTimeMs = 0L;
        long rewriteTimeMs = 0L;
        long numAddedBytes = 0L;
        long changeFileBytes = 0L;
        long numRemovedBytes = 0L;
        long numFilesBeforeSkipping = 0L;
        long numBytesBeforeSkipping = 0L;
        long numFilesAfterSkipping = 0L;
        long numBytesAfterSkipping = 0L;
        None$ numPartitionsAfterSkipping = None$.MODULE$;
        None$ numPartitionsRemovedFrom = None$.MODULE$;
        None$ numPartitionsAddedTo = None$.MODULE$;
        Some numDeletedRows = None$.MODULE$;
        None$ numCopiedRows = None$.MODULE$;
        long numDeletionVectorsAdded = 0L;
        long numDeletionVectorsRemoved = 0L;
        long numDeletionVectorsUpdated = 0L;
        long startTime = System.nanoTime();
        long numFilesTotal = txn.snapshot().numOfFiles();
        Option<Expression> option = this.condition();
        if (None$.MODULE$.equals(option)) {
            boolean reportRowLevelMetrics = BoxesRunTime.unboxToBoolean((Object)this.conf().getConf(DeltaSQLConf$.MODULE$.DELTA_DML_METRICS_FROM_METADATA()));
            Seq<AddFile> allFiles = txn.filterFiles((Seq<Expression>)Nil$.MODULE$, reportRowLevelMetrics);
            numRemovedFiles = allFiles.size();
            numDeletionVectorsRemoved = allFiles.count((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DeleteCommand.$anonfun$performDelete$1(x$1)));
            scanTimeMs = (System.nanoTime() - startTime) / 1000L / 1000L;
            Tuple2<Object, Object> tuple2 = MergeIntoCommandBase$.MODULE$.totalBytesAndDistinctPartitionValues(allFiles);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            long numBytes = tuple2._1$mcJ$sp();
            int numPartitions = tuple2._2$mcI$sp();
            Tuple2.mcJI.sp sp2 = new Tuple2.mcJI.sp(numBytes, numPartitions);
            long numBytes2 = sp2._1$mcJ$sp();
            int numPartitions2 = sp2._2$mcI$sp();
            numRemovedBytes = numBytes2;
            numFilesBeforeSkipping = numRemovedFiles;
            numBytesBeforeSkipping = numBytes2;
            numFilesAfterSkipping = numRemovedFiles;
            numBytesAfterSkipping = numBytes2;
            numDeletedRows = this.getDeletedRowsFromAddFilesAndUpdateMetrics(allFiles);
            if (txn.metadata().partitionColumns().nonEmpty()) {
                numPartitionsAfterSkipping = new Some((Object)BoxesRunTime.boxToLong((long)numPartitions2));
                numPartitionsRemovedFrom = new Some((Object)BoxesRunTime.boxToLong((long)numPartitions2));
                numPartitionsAddedTo = new Some((Object)BoxesRunTime.boxToLong((long)0L));
            }
            long operationTimestamp = System.currentTimeMillis();
            seq = (Seq)allFiles.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.removeWithTimestamp(operationTimestamp, x$3.removeWithTimestamp$default$2()), Seq$.MODULE$.canBuildFrom());
        } else if (option instanceof Some) {
            Some some = (Some)option;
            Expression cond = (Expression)some.value();
            Tuple2<Seq<Expression>, Seq<Expression>> tuple2 = DeltaTableUtils$.MODULE$.splitMetadataAndDataPredicates(cond, txn.metadata().partitionColumns(), sparkSession);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Seq metadataPredicates = (Seq)tuple2._1();
            Seq otherPredicates = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)metadataPredicates, (Object)otherPredicates);
            Seq metadataPredicates2 = (Seq)tuple22._1();
            Seq otherPredicates2 = (Seq)tuple22._2();
            numFilesBeforeSkipping = txn.snapshot().numOfFiles();
            numBytesBeforeSkipping = txn.snapshot().sizeInBytes();
            if (otherPredicates2.isEmpty()) {
                long operationTimestamp = System.currentTimeMillis();
                boolean reportRowLevelMetrics = BoxesRunTime.unboxToBoolean((Object)this.conf().getConf(DeltaSQLConf$.MODULE$.DELTA_DML_METRICS_FROM_METADATA()));
                Seq<AddFile> candidateFiles = txn.filterFiles((Seq<Expression>)metadataPredicates2, reportRowLevelMetrics);
                scanTimeMs = (System.nanoTime() - startTime) / 1000L / 1000L;
                numRemovedFiles = candidateFiles.size();
                numRemovedBytes = BoxesRunTime.unboxToLong((Object)((TraversableOnce)candidateFiles.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.size()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                numFilesAfterSkipping = candidateFiles.size();
                numDeletionVectorsRemoved = candidateFiles.count((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)DeleteCommand.$anonfun$performDelete$4(x$6)));
                Tuple2<Object, Object> tuple23 = MergeIntoCommandBase$.MODULE$.totalBytesAndDistinctPartitionValues(candidateFiles);
                if (tuple23 == null) {
                    throw new MatchError(tuple23);
                }
                long numCandidateBytes = tuple23._1$mcJ$sp();
                int numCandidatePartitions = tuple23._2$mcI$sp();
                Tuple2.mcJI.sp sp3 = new Tuple2.mcJI.sp(numCandidateBytes, numCandidatePartitions);
                long numCandidateBytes2 = sp3._1$mcJ$sp();
                int numCandidatePartitions2 = sp3._2$mcI$sp();
                numBytesAfterSkipping = numCandidateBytes2;
                numDeletedRows = this.getDeletedRowsFromAddFilesAndUpdateMetrics(candidateFiles);
                if (txn.metadata().partitionColumns().nonEmpty()) {
                    numPartitionsAfterSkipping = new Some((Object)BoxesRunTime.boxToLong((long)numCandidatePartitions2));
                    numPartitionsRemovedFrom = new Some((Object)BoxesRunTime.boxToLong((long)numCandidatePartitions2));
                    numPartitionsAddedTo = new Some((Object)BoxesRunTime.boxToLong((long)0L));
                }
                seq = (Seq)candidateFiles.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.removeWithTimestamp(operationTimestamp, x$8.removeWithTimestamp$default$2()), Seq$.MODULE$.canBuildFrom());
            } else {
                boolean shouldWriteDVs = this.shouldWritePersistentDeletionVectors(sparkSession, txn);
                Seq<AddFile> candidateFiles = txn.filterFiles((Seq<Expression>)((Seq)metadataPredicates2.$plus$plus((GenTraversableOnce)otherPredicates2, Seq$.MODULE$.canBuildFrom())), shouldWriteDVs);
                numFilesAfterSkipping = candidateFiles.size();
                Tuple2<Object, Object> tuple24 = MergeIntoCommandBase$.MODULE$.totalBytesAndDistinctPartitionValues(candidateFiles);
                if (tuple24 == null) {
                    throw new MatchError(tuple24);
                }
                long numCandidateBytes = tuple24._1$mcJ$sp();
                int numCandidatePartitions = tuple24._2$mcI$sp();
                Tuple2.mcJI.sp sp4 = new Tuple2.mcJI.sp(numCandidateBytes, numCandidatePartitions);
                long numCandidateBytes3 = sp4._1$mcJ$sp();
                int numCandidatePartitions3 = sp4._2$mcI$sp();
                numBytesAfterSkipping = numCandidateBytes3;
                if (txn.metadata().partitionColumns().nonEmpty()) {
                    numPartitionsAfterSkipping = new Some((Object)BoxesRunTime.boxToLong((long)numCandidatePartitions3));
                }
                Map<String, AddFile> nameToAddFileMap = this.generateCandidateFileMap(deltaLog.dataPath(), candidateFiles);
                TahoeBatchFileIndex fileIndex = new TahoeBatchFileIndex(sparkSession, "delete", candidateFiles, deltaLog, deltaLog.dataPath(), txn.snapshot(), TahoeBatchFileIndex$.MODULE$.$lessinit$greater$default$7());
                if (shouldWriteDVs) {
                    Dataset<Row> targetDf = DMLWithDeletionVectorsHelper$.MODULE$.createTargetDfForScanningForMatches(sparkSession, this.target(), fileIndex);
                    boolean mustReadDeletionVectors = DeletionVectorUtils$.MODULE$.deletionVectorsReadable(txn.snapshot(), DeletionVectorUtils$.MODULE$.deletionVectorsReadable$default$2(), DeletionVectorUtils$.MODULE$.deletionVectorsReadable$default$3());
                    Seq<TouchedFileWithDV> touchedFiles = DMLWithDeletionVectorsHelper$.MODULE$.findTouchedFiles(sparkSession, txn, mustReadDeletionVectors, deltaLog, targetDf, fileIndex, cond, "DELETE");
                    if (touchedFiles.nonEmpty()) {
                        Tuple2<Seq<FileAction>, Map<String, Object>> tuple25 = DMLWithDeletionVectorsHelper$.MODULE$.processUnmodifiedData(sparkSession, touchedFiles, txn.snapshot());
                        if (tuple25 == null) {
                            throw new MatchError(tuple25);
                        }
                        Seq actions = (Seq)tuple25._1();
                        Map metricMap = (Map)tuple25._2();
                        Tuple2 tuple26 = new Tuple2((Object)actions, (Object)metricMap);
                        Seq actions2 = (Seq)tuple26._1();
                        Map metricMap2 = (Map)tuple26._2();
                        ((SQLMetric)this.metrics().apply((Object)"numDeletedRows")).set(BoxesRunTime.unboxToLong((Object)metricMap2.apply((Object)"numModifiedRows")));
                        numDeletionVectorsAdded = BoxesRunTime.unboxToLong((Object)metricMap2.apply((Object)"numDeletionVectorsAdded"));
                        numDeletionVectorsRemoved = BoxesRunTime.unboxToLong((Object)metricMap2.apply((Object)"numDeletionVectorsRemoved"));
                        numDeletionVectorsUpdated = BoxesRunTime.unboxToLong((Object)metricMap2.apply((Object)"numDeletionVectorsUpdated"));
                        numRemovedFiles = BoxesRunTime.unboxToLong((Object)metricMap2.apply((Object)"numRemovedFiles"));
                        seq = actions2;
                    } else {
                        seq = Nil$.MODULE$;
                    }
                } else {
                    LogicalPlan newTarget = DeltaTableUtils$.MODULE$.replaceFileIndex(this.target(), fileIndex);
                    Dataset data = Dataset$.MODULE$.ofRows(sparkSession, newTarget);
                    IncrementMetric incrDeletedCountExpr = new IncrementMetric((Expression)Literal$.MODULE$.TrueLiteral(), (SQLMetric)this.metrics().apply((Object)"numDeletedRows"));
                    String[] filesToRewrite = (String[])this.withStatusCode("DELTA", DeleteCommand$.MODULE$.FINDING_TOUCHED_FILES_MSG(), this.withStatusCode$default$3(), (Function0 & Serializable & scala.Serializable)() -> {
                        if (candidateFiles.isEmpty()) {
                            return (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
                        }
                        return (String[])data.filter(new Column(cond)).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.input_file_name()})).filter(new Column((Expression)incrDeletedCountExpr)).distinct().as(package$.MODULE$.stringEncoder()).collect();
                    });
                    numRemovedFiles = filesToRewrite.length;
                    scanTimeMs = (System.nanoTime() - startTime) / 1000L / 1000L;
                    if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filesToRewrite)).isEmpty()) {
                        if (txn.metadata().partitionColumns().nonEmpty()) {
                            numPartitionsRemovedFrom = new Some((Object)BoxesRunTime.boxToLong((long)0L));
                            numPartitionsAddedTo = new Some((Object)BoxesRunTime.boxToLong((long)0L));
                        }
                        seq = Nil$.MODULE$;
                    } else {
                        Not filterCond;
                        HadoopFsRelation baseRelation = this.buildBaseRelation(sparkSession, txn, "delete", deltaLog.dataPath(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])filesToRewrite), nameToAddFileMap);
                        LogicalPlan newTarget2 = DeltaTableUtils$.MODULE$.replaceFileIndex(this.target(), baseRelation.location());
                        Dataset targetDF = Dataset$.MODULE$.ofRows(sparkSession, newTarget2);
                        Seq<FileAction> rewrittenActions = this.rewriteFiles(txn, (Dataset<Row>)targetDF, (Expression)(filterCond = new Not((Expression)new EqualNullSafe(cond, (Expression)Literal$.MODULE$.TrueLiteral()))), filesToRewrite.length);
                        Tuple2 tuple27 = rewrittenActions.partition((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)DeleteCommand.$anonfun$performDelete$7(x$11)));
                        if (tuple27 == null) {
                            throw new MatchError((Object)tuple27);
                        }
                        Seq changeFiles = (Seq)tuple27._1();
                        Seq rewrittenFiles = (Seq)tuple27._2();
                        Tuple2 tuple28 = new Tuple2((Object)changeFiles, (Object)rewrittenFiles);
                        Seq changeFiles2 = (Seq)tuple28._1();
                        Seq rewrittenFiles2 = (Seq)tuple28._2();
                        numAddedFiles = rewrittenFiles2.size();
                        AddFile[] removedFiles = (AddFile[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filesToRewrite)).map((Function1 & Serializable & scala.Serializable)f -> this.getTouchedFile(deltaLog.dataPath(), (String)f, nameToAddFileMap), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(AddFile.class)));
                        Tuple2<Object, Object> tuple29 = MergeIntoCommandBase$.MODULE$.totalBytesAndDistinctPartitionValues((Seq<FileAction>)Predef$.MODULE$.wrapRefArray((Object[])removedFiles));
                        if (tuple29 == null) {
                            throw new MatchError(tuple29);
                        }
                        long removedBytes = tuple29._1$mcJ$sp();
                        int removedPartitions = tuple29._2$mcI$sp();
                        Tuple2.mcJI.sp sp5 = new Tuple2.mcJI.sp(removedBytes, removedPartitions);
                        long removedBytes2 = sp5._1$mcJ$sp();
                        int removedPartitions2 = sp5._2$mcI$sp();
                        numRemovedBytes = removedBytes2;
                        Tuple2<Object, Object> tuple210 = MergeIntoCommandBase$.MODULE$.totalBytesAndDistinctPartitionValues((Seq<FileAction>)rewrittenFiles2);
                        if (tuple210 == null) {
                            throw new MatchError(tuple210);
                        }
                        long rewrittenBytes = tuple210._1$mcJ$sp();
                        int rewrittenPartitions = tuple210._2$mcI$sp();
                        Tuple2.mcJI.sp sp6 = new Tuple2.mcJI.sp(rewrittenBytes, rewrittenPartitions);
                        long rewrittenBytes2 = sp6._1$mcJ$sp();
                        int rewrittenPartitions2 = sp6._2$mcI$sp();
                        numAddedBytes = rewrittenBytes2;
                        if (txn.metadata().partitionColumns().nonEmpty()) {
                            numPartitionsRemovedFrom = new Some((Object)BoxesRunTime.boxToLong((long)removedPartitions2));
                            numPartitionsAddedTo = new Some((Object)BoxesRunTime.boxToLong((long)rewrittenPartitions2));
                        }
                        numAddedChangeFiles = changeFiles2.size();
                        changeFileBytes = BoxesRunTime.unboxToLong((Object)((TraversableOnce)changeFiles2.collect((PartialFunction)new scala.Serializable(null){
                            public static final long serialVersionUID = 0L;

                            public final <A1 extends FileAction, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                A1 A1 = x1;
                                if (A1 instanceof AddCDCFile) {
                                    AddCDCFile addCDCFile = (AddCDCFile)A1;
                                    return (B1)BoxesRunTime.boxToLong((long)addCDCFile.size());
                                }
                                return (B1)function1.apply(x1);
                            }

                            public final boolean isDefinedAt(FileAction x1) {
                                FileAction fileAction = x1;
                                return fileAction instanceof AddCDCFile;
                            }
                        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                        rewriteTimeMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime) - scanTimeMs;
                        numDeletedRows = new Some((Object)BoxesRunTime.boxToLong((long)((SQLMetric)this.metrics().apply((Object)"numDeletedRows")).value()));
                        numCopiedRows = new Some((Object)BoxesRunTime.boxToLong((long)(((SQLMetric)this.metrics().apply((Object)"numTouchedRows")).value() - ((SQLMetric)this.metrics().apply((Object)"numDeletedRows")).value())));
                        numDeletionVectorsRemoved = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])removedFiles)).count((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)DeleteCommand.$anonfun$performDelete$9(x$15)));
                        long operationTimestamp = System.currentTimeMillis();
                        seq = (Seq)this.removeFilesFromPaths(deltaLog, nameToAddFileMap, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])filesToRewrite), operationTimestamp).$plus$plus(rewrittenActions, Seq$.MODULE$.canBuildFrom());
                    }
                }
            }
        } else {
            throw new MatchError(option);
        }
        Seq deleteActions = seq;
        ((SQLMetric)this.metrics().apply((Object)"numRemovedFiles")).set(numRemovedFiles);
        ((SQLMetric)this.metrics().apply((Object)"numAddedFiles")).set(numAddedFiles);
        long executionTimeMs = (System.nanoTime() - startTime) / 1000L / 1000L;
        ((SQLMetric)this.metrics().apply((Object)"executionTimeMs")).set(executionTimeMs);
        ((SQLMetric)this.metrics().apply((Object)"scanTimeMs")).set(scanTimeMs);
        ((SQLMetric)this.metrics().apply((Object)"rewriteTimeMs")).set(rewriteTimeMs);
        ((SQLMetric)this.metrics().apply((Object)"numAddedChangeFiles")).set(numAddedChangeFiles);
        ((SQLMetric)this.metrics().apply((Object)"changeFileBytes")).set(changeFileBytes);
        ((SQLMetric)this.metrics().apply((Object)"numAddedBytes")).set(numAddedBytes);
        ((SQLMetric)this.metrics().apply((Object)"numRemovedBytes")).set(numRemovedBytes);
        ((SQLMetric)this.metrics().apply((Object)"numFilesBeforeSkipping")).set(numFilesBeforeSkipping);
        ((SQLMetric)this.metrics().apply((Object)"numBytesBeforeSkipping")).set(numBytesBeforeSkipping);
        ((SQLMetric)this.metrics().apply((Object)"numFilesAfterSkipping")).set(numFilesAfterSkipping);
        ((SQLMetric)this.metrics().apply((Object)"numBytesAfterSkipping")).set(numBytesAfterSkipping);
        ((SQLMetric)this.metrics().apply((Object)"numDeletionVectorsAdded")).set(numDeletionVectorsAdded);
        ((SQLMetric)this.metrics().apply((Object)"numDeletionVectorsRemoved")).set(numDeletionVectorsRemoved);
        ((SQLMetric)this.metrics().apply((Object)"numDeletionVectorsUpdated")).set(numDeletionVectorsUpdated);
        SQLMetric sQLMetric = (SQLMetric)this.metrics().apply((Object)"numPartitionsAfterSkipping");
        numPartitionsAfterSkipping.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)v -> sQLMetric.set(v));
        SQLMetric sQLMetric2 = (SQLMetric)this.metrics().apply((Object)"numPartitionsAddedTo");
        numPartitionsAddedTo.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)v -> sQLMetric2.set(v));
        SQLMetric sQLMetric3 = (SQLMetric)this.metrics().apply((Object)"numPartitionsRemovedFrom");
        numPartitionsRemovedFrom.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)v -> sQLMetric3.set(v));
        SQLMetric sQLMetric4 = (SQLMetric)this.metrics().apply((Object)"numCopiedRows");
        numCopiedRows.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)v -> sQLMetric4.set(v));
        txn.registerSQLMetrics(sparkSession, this.metrics());
        this.sendDriverMetrics(sparkSession, this.metrics());
        DeltaLog x$12 = deltaLog;
        String x$2 = "delta.dml.delete.stats";
        DeleteMetric x$32 = new DeleteMetric((String)this.condition().map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.sql()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "true"), numFilesTotal, numFilesAfterSkipping, numAddedFiles, numRemovedFiles, numAddedFiles, numAddedChangeFiles, numFilesBeforeSkipping, numBytesBeforeSkipping, numFilesAfterSkipping, numBytesAfterSkipping, (Option<Object>)numPartitionsAfterSkipping, (Option<Object>)numPartitionsAddedTo, (Option<Object>)numPartitionsRemovedFrom, (Option<Object>)numCopiedRows, (Option<Object>)numDeletedRows, numAddedBytes, numRemovedBytes, changeFileBytes, scanTimeMs, rewriteTimeMs, numDeletionVectorsAdded, numDeletionVectorsRemoved, numDeletionVectorsUpdated);
        Map<TagDefinition, String> x$4 = this.recordDeltaEvent$default$3();
        Option<Path> x$52 = this.recordDeltaEvent$default$5();
        this.recordDeltaEvent(x$12, x$2, x$4, x$32, x$52);
        if (deleteActions.nonEmpty()) {
            return (Seq)Option$.MODULE$.option2Iterable(this.createSetTransaction(sparkSession, deltaLog, this.createSetTransaction$default$3())).toSeq().$plus$plus((GenTraversableOnce)deleteActions, Seq$.MODULE$.canBuildFrom());
        }
        return (Seq)Nil$.MODULE$;
    }

    private Seq<FileAction> rewriteFiles(OptimisticTransaction txn, Dataset<Row> baseData, Expression filterCondition, long numFilesToRewrite) {
        boolean shouldWriteCdc = BoxesRunTime.unboxToBoolean((Object)DeltaConfigs$.MODULE$.CHANGE_DATA_FEED().fromMetaData(txn.metadata()));
        IncrementMetric incrTouchedCountExpr = new IncrementMetric((Expression)Literal$.MODULE$.TrueLiteral(), (SQLMetric)this.metrics().apply((Object)"numTouchedRows"));
        return (Seq)this.withStatusCode("DELTA", DeleteCommand$.MODULE$.rewritingFilesMsg(numFilesToRewrite), this.withStatusCode$default$3(), (Function0 & Serializable & scala.Serializable)() -> {
            Dataset dfToWrite = shouldWriteCdc ? baseData.filter(new Column((Expression)incrTouchedCountExpr)).withColumn(CDCReader$.MODULE$.CDC_TYPE_COLUMN_NAME(), new Column((Expression)new If(filterCondition, (Expression)CDCReader$.MODULE$.CDC_TYPE_NOT_CDC(), (Expression)CDCReader$.MODULE$.CDC_TYPE_DELETE()))) : baseData.filter(new Column((Expression)incrTouchedCountExpr)).filter(new Column(filterCondition));
            return txn.writeFiles(dfToWrite);
        });
    }

    public boolean shouldWritePersistentDeletionVectors(SparkSession spark, OptimisticTransaction txn) {
        return BoxesRunTime.unboxToBoolean((Object)spark.conf().get(DeltaSQLConf$.MODULE$.DELETE_USE_PERSISTENT_DELETION_VECTORS())) && DeletionVectorUtils$.MODULE$.deletionVectorsWritable(txn.snapshot(), DeletionVectorUtils$.MODULE$.deletionVectorsWritable$default$2(), DeletionVectorUtils$.MODULE$.deletionVectorsWritable$default$3());
    }

    public DeleteCommand copy(DeltaLog deltaLog, Option<CatalogTable> catalogTable, LogicalPlan target, Option<Expression> condition) {
        return new DeleteCommand(deltaLog, catalogTable, target, condition);
    }

    public DeltaLog copy$default$1() {
        return this.deltaLog();
    }

    public Option<CatalogTable> copy$default$2() {
        return this.catalogTable();
    }

    public LogicalPlan copy$default$3() {
        return this.target();
    }

    public Option<Expression> copy$default$4() {
        return this.condition();
    }

    public String productPrefix() {
        return "DeleteCommand";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.deltaLog();
            }
            case 1: {
                return this.catalogTable();
            }
            case 2: {
                return this.target();
            }
            case 3: {
                return this.condition();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DeleteCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DeleteCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        DeleteCommand deleteCommand = (DeleteCommand)x$1;
        DeltaLog deltaLog = this.deltaLog();
        DeltaLog deltaLog2 = deleteCommand.deltaLog();
        if (deltaLog == null) {
            if (deltaLog2 != null) {
                return false;
            }
        } else if (!deltaLog.equals(deltaLog2)) return false;
        Option<CatalogTable> option = this.catalogTable();
        Option<CatalogTable> option2 = deleteCommand.catalogTable();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        LogicalPlan logicalPlan = this.target();
        LogicalPlan logicalPlan2 = deleteCommand.target();
        if (logicalPlan == null) {
            if (logicalPlan2 != null) {
                return false;
            }
        } else if (!logicalPlan.equals(logicalPlan2)) return false;
        Option<Expression> option3 = this.condition();
        Option<Expression> option4 = deleteCommand.condition();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        if (!deleteCommand.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$run$2(DeleteCommand $this, SparkSession sparkSession$1, Object nonLocalReturnKey2$1, OptimisticTransaction txn) {
        DeltaLog$.MODULE$.assertRemovable(txn.snapshot());
        if ($this.hasBeenExecuted(txn, sparkSession$1, $this.hasBeenExecuted$default$3())) {
            $this.sendDriverMetrics(sparkSession$1, $this.metrics());
            throw new NonLocalReturnControl(nonLocalReturnKey2$1, (Object)Nil$.MODULE$);
        }
        Seq<Action> deleteActions = $this.performDelete(sparkSession$1, $this.deltaLog(), txn);
        txn.commitIfNeeded(deleteActions, new DeltaOperations.Delete((Seq<Expression>)Option$.MODULE$.option2Iterable($this.condition()).toSeq()), txn.commitIfNeeded$default$3());
    }

    public static final /* synthetic */ boolean $anonfun$performDelete$1(AddFile x$1) {
        return x$1.deletionVector() != null;
    }

    public static final /* synthetic */ boolean $anonfun$performDelete$4(AddFile x$6) {
        return x$6.deletionVector() != null;
    }

    public static final /* synthetic */ boolean $anonfun$performDelete$7(FileAction x$11) {
        return x$11 instanceof AddCDCFile;
    }

    public static final /* synthetic */ boolean $anonfun$performDelete$9(AddFile x$15) {
        return x$15.deletionVector() != null;
    }

    public DeleteCommand(DeltaLog deltaLog, Option<CatalogTable> catalogTable, LogicalPlan target, Option<Expression> condition) {
        this.deltaLog = deltaLog;
        this.catalogTable = catalogTable;
        this.target = target;
        this.condition = condition;
        Command.$init$((Command)this);
        RunnableCommand.$init$((RunnableCommand)this);
        LeafLike.$init$((LeafLike)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
        DeltaCommand.$init$(this);
        DeleteCommandMetrics.$init$(this);
        String x$1 = "num_affected_rows";
        LongType$ x$2 = LongType$.MODULE$;
        boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, (DataType)x$2, x$3, x$4);
        Seq x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, (DataType)x$2, x$3, x$4);
        this.output = (Seq)new .colon.colon((Object)new AttributeReference(x$1, (DataType)x$2, x$3, x$4, x$5, x$6), (List)Nil$.MODULE$);
    }
}

