/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import java.util.ConcurrentModificationException;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaOperations;
import org.apache.spark.sql.delta.DeltaOperations$Reorg$;
import org.apache.spark.sql.delta.DeltaOptions;
import org.apache.spark.sql.delta.OptimisticTransaction;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.AddFile$Tags$ICEBERG_COMPAT_VERSION$;
import org.apache.spark.sql.delta.actions.DeletionVectorDescriptor;
import org.apache.spark.sql.delta.actions.FileAction;
import org.apache.spark.sql.delta.actions.RemoveFile;
import org.apache.spark.sql.delta.actions.SetTransaction;
import org.apache.spark.sql.delta.catalog.DeltaTableV2;
import org.apache.spark.sql.delta.commands.DeltaCommand;
import org.apache.spark.sql.delta.commands.DeltaOptimizeContext;
import org.apache.spark.sql.delta.commands.optimize.DeletionVectorStats;
import org.apache.spark.sql.delta.commands.optimize.FileSizeStatsWithHistogram;
import org.apache.spark.sql.delta.commands.optimize.FileSizeStatsWithHistogram$;
import org.apache.spark.sql.delta.commands.optimize.OptimizeStats;
import org.apache.spark.sql.delta.commands.optimize.OptimizeStats$;
import org.apache.spark.sql.delta.commands.optimize.ZOrderFileStats;
import org.apache.spark.sql.delta.commands.optimize.ZOrderStats;
import org.apache.spark.sql.delta.commands.optimize.ZOrderStats$;
import org.apache.spark.sql.delta.constraints.Constraint;
import org.apache.spark.sql.delta.files.SQLMetricsReporting;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.skipping.MultiDimClustering$;
import org.apache.spark.sql.delta.skipping.clustering.ClusteredTableUtils$;
import org.apache.spark.sql.delta.skipping.clustering.ClusteringColumnInfo$;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.metric.SQLMetrics$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SystemClock;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005eh\u0001\u0002\r\u001a\u0001\u0019B\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\"AA\t\u0001B\u0001B\u0003%Q\t\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003[\u0011!\u0019\u0007A!A!\u0002\u0013!\u0007\u0002C4\u0001\u0005\u0003\u0005\u000b\u0011\u00025\t\u000b-\u0004A\u0011\u00017\t\u000fQ\u0004!\u0019!C\u0005k\"1\u0011\u0010\u0001Q\u0001\nYDqA\u001f\u0001C\u0002\u0013%1\u0010\u0003\u0004}\u0001\u0001\u0006I\u0001\u001a\u0005\b{\u0002\u0011\r\u0011\"\u0003|\u0011\u0019q\b\u0001)A\u0005I\"Aq\u0010\u0001b\u0001\n\u0013\t\t\u0001C\u0004\u0002\u0004\u0001\u0001\u000b\u0011\u0002.\t\u0015\u0005\u0015\u0001\u0001#b\u0001\n\u0013\t9\u0001C\u0004\u0002\n\u0001!\t!a\u0003\t\u000f\u0005U\u0001\u0001\"\u0003\u0002\u0018!9\u0011q\u0007\u0001\u0005\n\u0005e\u0002bBA)\u0001\u0011%\u00111\u000b\u0005\b\u0003W\u0002A\u0011BA7\u0011\u001d\tI\r\u0001C\u0005\u0003\u0017Dq!!4\u0001\t\u0013\tyM\u0001\tPaRLW.\u001b>f\u000bb,7-\u001e;pe*\u0011!dG\u0001\tG>lW.\u00198eg*\u0011A$H\u0001\u0006I\u0016dG/\u0019\u0006\u0003=}\t1a]9m\u0015\t\u0001\u0013%A\u0003ta\u0006\u00148N\u0003\u0002#G\u00051\u0011\r]1dQ\u0016T\u0011\u0001J\u0001\u0004_J<7\u0001A\n\u0006\u0001\u001dj\u0013g\u000e\t\u0003Q-j\u0011!\u000b\u0006\u0002U\u0005)1oY1mC&\u0011A&\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u00059zS\"A\r\n\u0005AJ\"\u0001\u0004#fYR\f7i\\7nC:$\u0007C\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b\u001c\u0003\u00151\u0017\u000e\\3t\u0013\t14GA\nT#2kU\r\u001e:jGN\u0014V\r]8si&tw\r\u0005\u0002)q%\u0011\u0011(\u000b\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\rgB\f'o[*fgNLwN\u001c\t\u0003yuj\u0011!H\u0005\u0003}u\u0011Ab\u00159be.\u001cVm]:j_:\f1\u0001\u001e=o!\t\t%)D\u0001\u001c\u0013\t\u00195DA\u000bPaRLW.[:uS\u000e$&/\u00198tC\u000e$\u0018n\u001c8\u0002%A\f'\u000f^5uS>t\u0007K]3eS\u000e\fG/\u001a\t\u0004\r:\u000bfBA$M\u001d\tA5*D\u0001J\u0015\tQU%\u0001\u0004=e>|GOP\u0005\u0002U%\u0011Q*K\u0001\ba\u0006\u001c7.Y4f\u0013\ty\u0005KA\u0002TKFT!!T\u0015\u0011\u0005I;V\"A*\u000b\u0005Q+\u0016aC3yaJ,7o]5p]NT!AV\u000f\u0002\u0011\r\fG/\u00197zgRL!\u0001W*\u0003\u0015\u0015C\bO]3tg&|g.A\b{\u001fJ$WM\u001d\"z\u0007>dW/\u001c8t!\r1ej\u0017\t\u00039\u0002t!!\u00180\u0011\u0005!K\u0013BA0*\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011M\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005}K\u0013!D5t\u0003V$xnQ8na\u0006\u001cG\u000f\u0005\u0002)K&\u0011a-\u000b\u0002\b\u0005>|G.Z1o\u0003=y\u0007\u000f^5nSj,7i\u001c8uKb$\bC\u0001\u0018j\u0013\tQ\u0017D\u0001\u000bEK2$\u0018m\u00149uS6L'0Z\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f5tw\u000e]9sgB\u0011a\u0006\u0001\u0005\u0006u\u001d\u0001\ra\u000f\u0005\u0006\u007f\u001d\u0001\r\u0001\u0011\u0005\u0006\t\u001e\u0001\r!\u0012\u0005\u00063\u001e\u0001\rA\u0017\u0005\u0006G\u001e\u0001\r\u0001\u001a\u0005\u0006O\u001e\u0001\r\u0001[\u0001\u0013_B,'/\u0019;j_:$\u0016.\\3ti\u0006l\u0007/F\u0001w!\tAs/\u0003\u0002yS\t!Aj\u001c8h\u0003My\u0007/\u001a:bi&|g\u000eV5nKN$\u0018-\u001c9!\u0003AI7o\u00117vgR,'/\u001a3UC\ndW-F\u0001e\u0003EI7o\u00117vgR,'/\u001a3UC\ndW\rI\u0001\u0015SNlU\u000f\u001c;j\t&l7\t\\;ti\u0016\u0014\u0018N\\4\u0002+%\u001cX*\u001e7uS\u0012KWn\u00117vgR,'/\u001b8hA\u0005\t2\r\\;ti\u0016\u0014\u0018N\\4D_2,XN\\:\u0016\u0003i\u000b!c\u00197vgR,'/\u001b8h\u0007>dW/\u001c8tA\u0005)1-\u001e:wKV\t1,\u0001\u0005paRLW.\u001b>f)\t\ti\u0001\u0005\u0003G\u001d\u0006=\u0001c\u0001\u001f\u0002\u0012%\u0019\u00111C\u000f\u0003\u0007I{w/\u0001\fqeVtWmQ1oI&$\u0017\r^3GS2,G*[:u)!\tI\"a\n\u0002,\u0005U\u0002\u0003\u0002$O\u00037\u0001B!!\b\u0002$5\u0011\u0011q\u0004\u0006\u0004\u0003CY\u0012aB1di&|gn]\u0005\u0005\u0003K\tyBA\u0004BI\u00124\u0015\u000e\\3\t\r\u0005%\"\u00031\u0001w\u0003-i\u0017N\u001c$jY\u0016\u001c\u0016N_3\t\u000f\u00055\"\u00031\u0001\u00020\u0005\u0019R.\u0019=EK2,G/\u001a3S_^\u001c(+\u0019;j_B\u0019\u0001&!\r\n\u0007\u0005M\u0012F\u0001\u0004E_V\u0014G.\u001a\u0005\u0007iI\u0001\r!!\u0007\u0002%\u001d\u0014x.\u001e9GS2,7/\u00138u_\nKgn\u001d\u000b\u0007\u0003w\tI%!\u0014\u0011\t\u0019s\u0015Q\b\t\bQ\u0005}\u00121IA\r\u0013\r\t\t%\u000b\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u000bq\u000b)eW.\n\u0007\u0005\u001d#MA\u0002NCBDq!a\u0013\u0014\u0001\u0004\tY$A\nqCJ$\u0018\u000e^5p]N$vnQ8na\u0006\u001cG\u000f\u0003\u0004\u0002PM\u0001\rA^\u0001\u0012[\u0006DH+\u0019:hKR4\u0015\u000e\\3TSj,\u0017!\u0005:v]>\u0003H/[7ju\u0016\u0014\u0015N\u001c&pERQ\u0011QKA/\u0003?\n\u0019'a\u001a\u0011\t\u0019s\u0015q\u000b\t\u0005\u0003;\tI&\u0003\u0003\u0002\\\u0005}!A\u0003$jY\u0016\f5\r^5p]\")q\b\u0006a\u0001\u0001\"9\u0011\u0011\r\u000bA\u0002\u0005\r\u0013!\u00039beRLG/[8o\u0011\u001d\t)\u0007\u0006a\u0001\u00033\t1AY5o\u0011\u0019\tI\u0007\u0006a\u0001m\u0006YQ.\u0019=GS2,7+\u001b>f\u00039\u0019w.\\7ji\u0006sGMU3uef$\"\"a\u001c\u0002\u0002\u0006\r\u0015\u0011VAZ)\u0011\t\t(a\u001e\u0011\u0007!\n\u0019(C\u0002\u0002v%\u0012A!\u00168ji\"9\u0011\u0011P\u000bA\u0002\u0005m\u0014!\u00014\u0011\u000b!\ni\b\u00113\n\u0007\u0005}\u0014FA\u0005Gk:\u001cG/[8oc!)q(\u0006a\u0001\u0001\"9\u0011QQ\u000bA\u0002\u0005\u001d\u0015!E8qi&l\u0017N_3Pa\u0016\u0014\u0018\r^5p]B!\u0011\u0011RAR\u001d\u0011\tY)a(\u000f\t\u00055\u0015Q\u0014\b\u0005\u0003\u001f\u000bYJ\u0004\u0003\u0002\u0012\u0006ee\u0002BAJ\u0003/s1\u0001SAK\u0013\u0005!\u0013B\u0001\u0012$\u0013\t\u0001\u0013%\u0003\u0002\u001f?%\u0011A$H\u0005\u0004\u0003C[\u0012a\u0004#fYR\fw\n]3sCRLwN\\:\n\t\u0005\u0015\u0016q\u0015\u0002\n\u001fB,'/\u0019;j_:T1!!)\u001c\u0011\u001d\t\t#\u0006a\u0001\u0003W\u0003BA\u0012(\u0002.B!\u0011QDAX\u0013\u0011\t\t,a\b\u0003\r\u0005\u001bG/[8o\u0011\u001d\t),\u0006a\u0001\u0003o\u000bq!\\3ue&\u001c7\u000f\u0005\u0004]\u0003\u000bZ\u0016\u0011\u0018\t\u0005\u0003w\u000b)-\u0004\u0002\u0002>*!\u0011qXAa\u0003\u0019iW\r\u001e:jG*\u0019\u00111Y\u000f\u0002\u0013\u0015DXmY;uS>t\u0017\u0002BAd\u0003{\u0013\u0011bU)M\u001b\u0016$(/[2\u0002\u0019\u001d,Go\u00149fe\u0006$\u0018n\u001c8\u0015\u0005\u0005\u001d\u0015!D2sK\u0006$X-T3ue&\u001c7\u000f\u0006\u0006\u00028\u0006E\u0017Q\\Aq\u0003[Dq!a5\u0018\u0001\u0004\t).\u0001\u0007ta\u0006\u00148nQ8oi\u0016DH\u000f\u0005\u0003\u0002X\u0006eW\"A\u0010\n\u0007\u0005mwD\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH\u000fC\u0004\u0002`^\u0001\r!!\u0007\u0002\u0015\u0005$G-\u001a3GS2,7\u000fC\u0004\u0002d^\u0001\r!!:\u0002\u0019I,Wn\u001c<fI\u001aKG.Z:\u0011\t\u0019s\u0015q\u001d\t\u0005\u0003;\tI/\u0003\u0003\u0002l\u0006}!A\u0003*f[>4XMR5mK\"9\u0011q^\fA\u0002\u0005E\u0018A\u0003:f[>4X\r\u001a#WgB!aITAz!\u0011\ti\"!>\n\t\u0005]\u0018q\u0004\u0002\u0019\t\u0016dW\r^5p]Z+7\r^8s\t\u0016\u001c8M]5qi>\u0014\b")
public class OptimizeExecutor
implements DeltaCommand,
SQLMetricsReporting,
scala.Serializable {
    private String curve;
    private final SparkSession sparkSession;
    private final OptimisticTransaction txn;
    private final Seq<Expression> partitionPredicate;
    private Seq<String> zOrderByColumns;
    private final boolean isAutoCompact;
    private final DeltaOptimizeContext optimizeContext;
    private final long operationTimestamp;
    private final boolean org$apache$spark$sql$delta$commands$OptimizeExecutor$$isClusteredTable;
    private final boolean isMultiDimClustering;
    private final Seq<String> clusteringColumns;
    private Map<String, SQLMetric> org$apache$spark$sql$delta$files$SQLMetricsReporting$$operationSQLMetrics;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    @Override
    public void registerSQLMetrics(SparkSession spark, Map<String, SQLMetric> metrics) {
        SQLMetricsReporting.registerSQLMetrics$(this, spark, metrics);
    }

    @Override
    public Map<String, String> getMetricsForOperation(DeltaOperations.Operation operation) {
        return SQLMetricsReporting.getMetricsForOperation$(this, operation);
    }

    @Override
    public Option<SQLMetric> getMetric(String name) {
        return SQLMetricsReporting.getMetric$(this, name);
    }

    @Override
    public Seq<Expression> parsePredicates(SparkSession spark, String predicate) {
        return DeltaCommand.parsePredicates$(this, spark, predicate);
    }

    @Override
    public void verifyPartitionPredicates(SparkSession spark, Seq<String> partitionColumns, Seq<Expression> predicates) {
        DeltaCommand.verifyPartitionPredicates$(this, spark, partitionColumns, predicates);
    }

    @Override
    public Map<String, AddFile> generateCandidateFileMap(Path basePath, Seq<AddFile> candidateFiles) {
        return DeltaCommand.generateCandidateFileMap$(this, basePath, candidateFiles);
    }

    @Override
    public Seq<RemoveFile> removeFilesFromPaths(DeltaLog deltaLog, Map<String, AddFile> nameToAddFileMap, Seq<String> filesToRewrite, long operationTimestamp) {
        return DeltaCommand.removeFilesFromPaths$(this, deltaLog, nameToAddFileMap, filesToRewrite, operationTimestamp);
    }

    @Override
    public HadoopFsRelation buildBaseRelation(SparkSession spark, OptimisticTransaction txn, String actionType, Path rootPath, Seq<String> inputLeafFiles, Map<String, AddFile> nameToAddFileMap) {
        return DeltaCommand.buildBaseRelation$(this, spark, txn, actionType, rootPath, inputLeafFiles, nameToAddFileMap);
    }

    @Override
    public AddFile getTouchedFile(Path basePath, String filePath, Map<String, AddFile> nameToAddFileMap) {
        return DeltaCommand.getTouchedFile$(this, basePath, filePath, nameToAddFileMap);
    }

    @Override
    public LogicalPlan resolveIdentifier(Analyzer analyzer, TableIdentifier identifier) {
        return DeltaCommand.resolveIdentifier$(this, analyzer, identifier);
    }

    @Override
    public boolean isCatalogTable(Analyzer analyzer, TableIdentifier tableIdent) {
        return DeltaCommand.isCatalogTable$(this, analyzer, tableIdent);
    }

    @Override
    public boolean isPathIdentifier(TableIdentifier tableIdent) {
        return DeltaCommand.isPathIdentifier$(this, tableIdent);
    }

    @Override
    public DeltaLog getDeltaLog(SparkSession spark, Option<String> path, Option<TableIdentifier> tableIdentifier, String operationName, Map<String, String> hadoopConf) {
        return DeltaCommand.getDeltaLog$(this, spark, path, tableIdentifier, operationName, hadoopConf);
    }

    @Override
    public Map<String, String> getDeltaLog$default$5() {
        return DeltaCommand.getDeltaLog$default$5$(this);
    }

    @Override
    public void sendDriverMetrics(SparkSession spark, Map<String, SQLMetric> metrics) {
        DeltaCommand.sendDriverMetrics$(this, spark, metrics);
    }

    @Override
    public DeltaTableV2 getDeltaTable(LogicalPlan target, String cmd) {
        return DeltaCommand.getDeltaTable$(this, target, cmd);
    }

    @Override
    public Option<CatalogTable> getTableCatalogTable(LogicalPlan target, String cmd) {
        return DeltaCommand.getTableCatalogTable$(this, target, cmd);
    }

    @Override
    public Tuple2<Option<TableIdentifier>, Option<String>> getDeltaTablePathOrIdentifier(LogicalPlan target, String cmd) {
        return DeltaCommand.getDeltaTablePathOrIdentifier$(this, target, cmd);
    }

    @Override
    public Tuple2<Option<TableIdentifier>, Option<String>> getTablePathOrIdentifier(LogicalPlan target, String cmd) {
        return DeltaCommand.getTablePathOrIdentifier$(this, target, cmd);
    }

    @Override
    public boolean hasBeenExecuted(OptimisticTransaction txn, SparkSession sparkSession, Option<DeltaOptions> options) {
        return DeltaCommand.hasBeenExecuted$(this, txn, sparkSession, options);
    }

    @Override
    public Option<DeltaOptions> hasBeenExecuted$default$3() {
        return DeltaCommand.hasBeenExecuted$default$3$(this);
    }

    @Override
    public Option<SetTransaction> createSetTransaction(SparkSession sparkSession, DeltaLog deltaLog, Option<DeltaOptions> options) {
        return DeltaCommand.createSetTransaction$(this, sparkSession, deltaLog, options);
    }

    @Override
    public Option<DeltaOptions> createSetTransaction$default$3() {
        return DeltaCommand.createSetTransaction$default$3$(this);
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public Map<String, SQLMetric> org$apache$spark$sql$delta$files$SQLMetricsReporting$$operationSQLMetrics() {
        return this.org$apache$spark$sql$delta$files$SQLMetricsReporting$$operationSQLMetrics;
    }

    @Override
    public void org$apache$spark$sql$delta$files$SQLMetricsReporting$$operationSQLMetrics_$eq(Map<String, SQLMetric> x$1) {
        this.org$apache$spark$sql$delta$files$SQLMetricsReporting$$operationSQLMetrics = x$1;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private long operationTimestamp() {
        return this.operationTimestamp;
    }

    public boolean org$apache$spark$sql$delta$commands$OptimizeExecutor$$isClusteredTable() {
        return this.org$apache$spark$sql$delta$commands$OptimizeExecutor$$isClusteredTable;
    }

    private boolean isMultiDimClustering() {
        return this.isMultiDimClustering;
    }

    private Seq<String> clusteringColumns() {
        return this.clusteringColumns;
    }

    private String curve$lzycompute() {
        OptimizeExecutor optimizeExecutor = this;
        synchronized (optimizeExecutor) {
            if (!this.bitmap$0) {
                String string;
                if (this.zOrderByColumns.nonEmpty()) {
                    string = "zorder";
                } else {
                    Predef$.MODULE$.assert(this.org$apache$spark$sql$delta$commands$OptimizeExecutor$$isClusteredTable());
                    string = "hilbert";
                }
                this.curve = string;
                this.bitmap$0 = true;
            }
        }
        this.zOrderByColumns = null;
        return this.curve;
    }

    private String curve() {
        if (!this.bitmap$0) {
            return this.curve$lzycompute();
        }
        return this.curve;
    }

    public Seq<Row> optimize() {
        Seq seq;
        Object object = new Object();
        try {
            seq = (Seq)this.recordDeltaOperation(this.txn.deltaLog(), "delta.optimize", this.recordDeltaOperation$default$3(), (Function0 & Serializable & scala.Serializable)() -> {
                long minFileSize = BoxesRunTime.unboxToLong((Object)$this.optimizeContext.minFileSize().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToLong((Object)$this.sparkSession.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_OPTIMIZE_MIN_FILE_SIZE()))));
                long maxFileSize = BoxesRunTime.unboxToLong((Object)$this.optimizeContext.maxFileSize().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToLong((Object)$this.sparkSession.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_OPTIMIZE_MAX_FILE_SIZE()))));
                double maxDeletedRowsRatio = BoxesRunTime.unboxToDouble((Object)$this.optimizeContext.maxDeletedRowsRatio().getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToDouble((Object)$this.sparkSession.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_OPTIMIZE_MAX_DELETED_ROWS_RATIO()))));
                Seq<AddFile> candidateFiles = $this.txn.filterFiles($this.partitionPredicate, true);
                StructType partitionSchema = $this.txn.metadata().partitionSchema();
                Seq<AddFile> filesToProcess = this.pruneCandidateFileList(minFileSize, maxDeletedRowsRatio, candidateFiles);
                Seq partitionsToCompact = filesToProcess.groupBy((Function1 & Serializable & scala.Serializable)x$4 -> x$4.partitionValues()).toSeq();
                Seq<Tuple2<Map<String, String>, Seq<AddFile>>> jobs = this.groupFilesIntoBins((Seq<Tuple2<Map<String, String>, Seq<AddFile>>>)partitionsToCompact, maxFileSize);
                int maxThreads = BoxesRunTime.unboxToInt((Object)$this.sparkSession.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_OPTIMIZE_MAX_THREADS()));
                Seq updates = (Seq)ThreadUtils$.MODULE$.parmap(jobs, "OptimizeJob", maxThreads, (Function1 & Serializable & scala.Serializable)partitionBinGroup -> this.runOptimizeBinJob($this.txn, (Map<String, String>)((Map)partitionBinGroup._1()), (Seq<AddFile>)((Seq)partitionBinGroup._2()), maxFileSize)).flatten((Function1)Predef$.MODULE$.$conforms());
                Seq addedFiles = (Seq)updates.collect((PartialFunction)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends FileAction, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        if (A1 instanceof AddFile) {
                            AddFile addFile = (AddFile)A1;
                            return (B1)addFile;
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(FileAction x1) {
                        FileAction fileAction = x1;
                        return fileAction instanceof AddFile;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Seq removedFiles = (Seq)updates.collect((PartialFunction)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends FileAction, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        A1 A1 = x2;
                        if (A1 instanceof RemoveFile) {
                            RemoveFile removeFile = (RemoveFile)A1;
                            return (B1)removeFile;
                        }
                        return (B1)function1.apply(x2);
                    }

                    public final boolean isDefinedAt(FileAction x2) {
                        FileAction fileAction = x2;
                        return fileAction instanceof RemoveFile;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Seq removedDVs = ((SeqLike)((TraversableLike)filesToProcess.filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)OptimizeExecutor.$anonfun$optimize$7(x$5)))).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.deletionVector(), Seq$.MODULE$.canBuildFrom())).toSeq();
                if (addedFiles.size() > 0) {
                    Map<String, SQLMetric> metrics = this.createMetrics($this.sparkSession.sparkContext(), (Seq<AddFile>)addedFiles, (Seq<RemoveFile>)removedFiles, (Seq<DeletionVectorDescriptor>)removedDVs);
                    this.commitAndRetry($this.txn, this.getOperation(), (Seq<Action>)updates, metrics, (Function1<OptimisticTransaction, Object>)(Function1 & Serializable & scala.Serializable)newTxn -> BoxesRunTime.boxToBoolean((boolean)OptimizeExecutor.$anonfun$optimize$9(this, candidateFiles, partitionSchema, newTxn)));
                }
                OptimizeStats optimizeStats = new OptimizeStats(OptimizeStats$.MODULE$.apply$default$1(), OptimizeStats$.MODULE$.apply$default$2(), OptimizeStats$.MODULE$.apply$default$3(), OptimizeStats$.MODULE$.apply$default$4(), OptimizeStats$.MODULE$.apply$default$5(), OptimizeStats$.MODULE$.apply$default$6(), OptimizeStats$.MODULE$.apply$default$7(), OptimizeStats$.MODULE$.apply$default$8(), OptimizeStats$.MODULE$.apply$default$9(), OptimizeStats$.MODULE$.apply$default$10(), OptimizeStats$.MODULE$.apply$default$11(), OptimizeStats$.MODULE$.apply$default$12(), OptimizeStats$.MODULE$.apply$default$13(), OptimizeStats$.MODULE$.apply$default$14(), OptimizeStats$.MODULE$.apply$default$15(), OptimizeStats$.MODULE$.apply$default$16(), OptimizeStats$.MODULE$.apply$default$17(), OptimizeStats$.MODULE$.apply$default$18());
                optimizeStats.addedFilesSizeStats().merge((Seq<FileAction>)addedFiles);
                optimizeStats.removedFilesSizeStats().merge((Seq<FileAction>)removedFiles);
                optimizeStats.numPartitionsOptimized_$eq(((SeqLike)((SeqLike)jobs.map((Function1 & Serializable & scala.Serializable)j -> (Map)j._1(), Seq$.MODULE$.canBuildFrom())).distinct()).size());
                optimizeStats.numBatches_$eq(jobs.size());
                optimizeStats.totalConsideredFiles_$eq(candidateFiles.size());
                optimizeStats.totalFilesSkipped_$eq(optimizeStats.totalConsideredFiles() - (long)removedFiles.size());
                optimizeStats.totalClusterParallelism_$eq($this.sparkSession.sparkContext().defaultParallelism());
                int numTableColumns = $this.txn.snapshot().metadata().schema().size();
                optimizeStats.numTableColumns_$eq(numTableColumns);
                optimizeStats.numTableColumnsWithStats_$eq(RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt((Object)DeltaConfigs$.MODULE$.DATA_SKIPPING_NUM_INDEXED_COLS().fromMetaData($this.txn.snapshot().metadata()))), numTableColumns));
                if (removedDVs.size() > 0) {
                    optimizeStats.deletionVectorStats_$eq((Option<DeletionVectorStats>)new Some((Object)new DeletionVectorStats(removedDVs.size(), BoxesRunTime.unboxToLong((Object)((TraversableOnce)removedDVs.map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.cardinality()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)))));
                }
                if (this.isMultiDimClustering()) {
                    ZOrderFileStats inputFileStats = new ZOrderFileStats(removedFiles.size(), BoxesRunTime.unboxToLong((Object)((TraversableOnce)removedFiles.map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)OptimizeExecutor.$anonfun$optimize$15(x$10)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
                    optimizeStats.zOrderStats_$eq((Option<ZOrderStats>)new Some((Object)new ZOrderStats("all", new ZOrderFileStats(0L, 0L), inputFileStats, 0L, inputFileStats, optimizeStats.numPartitionsOptimized(), ZOrderStats$.MODULE$.apply$default$7())));
                }
                throw new NonLocalReturnControl(object, (Object)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.txn.deltaLog().dataPath().toString(), optimizeStats.toOptimizeMetrics()})), (List)Nil$.MODULE$));
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                seq = (Seq)ex.value();
            }
            throw ex;
        }
        return seq;
    }

    private Seq<AddFile> pruneCandidateFileList(long minFileSize, double maxDeletedRowsRatio, Seq<AddFile> files) {
        if (this.isMultiDimClustering()) {
            return files;
        }
        return (Seq)files.filter((Function1 & Serializable & scala.Serializable)addFile -> BoxesRunTime.boxToBoolean((boolean)OptimizeExecutor.$anonfun$pruneCandidateFileList$4(this, minFileSize, maxDeletedRowsRatio, addFile)));
    }

    private Seq<Tuple2<Map<String, String>, Seq<AddFile>>> groupFilesIntoBins(Seq<Tuple2<Map<String, String>, Seq<AddFile>>> partitionsToCompact, long maxTargetFileSize) {
        return (Seq)partitionsToCompact.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Map partition = (Map)tuple2._1();
                Seq files = (Seq)tuple2._2();
                ArrayBuffer bins = new ArrayBuffer();
                ArrayBuffer currentBin = new ArrayBuffer();
                LongRef currentBinSize = LongRef.create((long)0L);
                ((IterableLike)files.sortBy((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.size()), (Ordering)Ordering.Long$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)file -> {
                    OptimizeExecutor.$anonfun$groupFilesIntoBins$3(this, currentBinSize, maxTargetFileSize, bins, currentBin, file);
                    return BoxedUnit.UNIT;
                });
                Object object = currentBin.nonEmpty() ? bins.$plus$eq((Object)currentBin.toVector()) : BoxedUnit.UNIT;
                return (ArrayBuffer)((TraversableLike)bins.filter((Function1 & Serializable & scala.Serializable)bin -> BoxesRunTime.boxToBoolean((boolean)OptimizeExecutor.$anonfun$groupFilesIntoBins$4(this, bin)))).map((Function1 & Serializable & scala.Serializable)b -> new Tuple2((Object)partition, b), ArrayBuffer$.MODULE$.canBuildFrom());
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Seq<FileAction> runOptimizeBinJob(OptimisticTransaction txn, Map<String, String> partition, Seq<AddFile> bin, long maxFileSize) {
        Object object;
        Path baseTablePath = txn.deltaLog().dataPath();
        Snapshot x$1 = txn.snapshot();
        Seq<AddFile> x$2 = bin;
        Some x$3 = new Some((Object)"Optimize");
        boolean x$4 = txn.deltaLog().createDataFrame$default$3();
        Dataset<Row> input = txn.deltaLog().createDataFrame(x$1, x$2, x$4, (Option<String>)x$3);
        if (this.isMultiDimClustering()) {
            long totalSize = BoxesRunTime.unboxToLong((Object)((TraversableOnce)bin.map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.size()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            int approxNumFiles = (int)Math.max(1L, totalSize / maxFileSize);
            object = MultiDimClustering$.MODULE$.cluster(input, approxNumFiles, this.clusteringColumns(), this.curve());
        } else {
            boolean useRepartition = BoxesRunTime.unboxToBoolean((Object)this.sparkSession.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_OPTIMIZE_REPARTITION_ENABLED()));
            object = useRepartition ? input.repartition(1) : input.coalesce(1);
        }
        Dataset<Row> repartitionDF = object;
        String partitionDesc = ((TraversableOnce)partition.toSeq().map((Function1 & Serializable & scala.Serializable)entry -> new StringBuilder(1).append((String)entry._1()).append("=").append(entry._2()).toString(), Seq$.MODULE$.canBuildFrom())).mkString(",");
        String partitionName = partition.isEmpty() ? "" : new StringBuilder(16).append(" in partition (").append(partitionDesc).append(")").toString();
        String description = new StringBuilder(22).append(baseTablePath).append("<br/>Optimizing ").append(bin.size()).append(" files").append(partitionName).toString();
        this.sparkSession.sparkContext().setJobGroup(this.sparkSession.sparkContext().getLocalProperty(SparkContext$.MODULE$.SPARK_JOB_GROUP_ID()), description, this.sparkSession.sparkContext().setJobGroup$default$3());
        Seq addFiles = (Seq)txn.writeFiles(repartitionDF, (Option<DeltaOptions>)None$.MODULE$, true, (Seq<Constraint>)Nil$.MODULE$).collect((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OptimizeExecutor $outer;

            public final <A1 extends FileAction, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof AddFile) {
                    AddFile addFile;
                    AddFile addFile2 = (AddFile)A1;
                    if (this.$outer.org$apache$spark$sql$delta$commands$OptimizeExecutor$$isClusteredTable()) {
                        Some x$1 = new Some((Object)ClusteredTableUtils$.MODULE$.clusteringProvider());
                        String x$2 = addFile2.copy$default$1();
                        Map<String, String> x$3 = addFile2.copy$default$2();
                        long x$4 = addFile2.copy$default$3();
                        long x$5 = addFile2.copy$default$4();
                        boolean x$6 = addFile2.copy$default$5();
                        String x$7 = addFile2.copy$default$6();
                        Map<String, String> x$8 = addFile2.copy$default$7();
                        DeletionVectorDescriptor x$9 = addFile2.copy$default$8();
                        Option<Object> x$10 = addFile2.copy$default$9();
                        Option<Object> x$11 = addFile2.copy$default$10();
                        addFile = addFile2.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, (Option<String>)x$1);
                    } else {
                        addFile = addFile2;
                    }
                    AddFile qual$1 = addFile;
                    boolean x$12 = false;
                    String x$13 = qual$1.copy$default$1();
                    Map<String, String> x$14 = qual$1.copy$default$2();
                    long x$15 = qual$1.copy$default$3();
                    long x$16 = qual$1.copy$default$4();
                    String x$17 = qual$1.copy$default$6();
                    Map<String, String> x$18 = qual$1.copy$default$7();
                    DeletionVectorDescriptor x$19 = qual$1.copy$default$8();
                    Option<Object> x$20 = qual$1.copy$default$9();
                    Option<Object> x$21 = qual$1.copy$default$10();
                    Option<String> x$22 = qual$1.copy$default$11();
                    return (B1)qual$1.copy(x$13, x$14, x$15, x$16, x$12, x$17, x$18, x$19, x$20, x$21, x$22);
                }
                throw new IllegalStateException(new StringBuilder(82).append("Unexpected action ").append(A1).append(" with type ").append(A1.getClass()).append(". File compaction job output").append("should only have AddFiles").toString());
            }

            public final boolean isDefinedAt(FileAction x1) {
                FileAction fileAction = x1;
                if (fileAction instanceof AddFile) {
                    return true;
                }
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq removeFiles = (Seq)bin.map((Function1 & Serializable & scala.Serializable)f -> f.removeWithTimestamp(this.operationTimestamp(), false), Seq$.MODULE$.canBuildFrom());
        Seq updates = (Seq)addFiles.$plus$plus((GenTraversableOnce)removeFiles, Seq$.MODULE$.canBuildFrom());
        return updates;
    }

    private void commitAndRetry(OptimisticTransaction txn, DeltaOperations.Operation optimizeOperation, Seq<Action> actions, Map<String, SQLMetric> metrics, Function1<OptimisticTransaction, Object> f) {
        while (true) {
            try {
                txn.registerSQLMetrics(this.sparkSession, metrics);
                txn.commit(actions, optimizeOperation);
            }
            catch (ConcurrentModificationException e) {
                OptimisticTransaction newTxn = txn.deltaLog().startTransaction(txn.catalogTable(), txn.deltaLog().startTransaction$default$2());
                if (BoxesRunTime.unboxToBoolean((Object)f.apply((Object)newTxn))) {
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Retrying commit after checking for semantic conflicts with concurrent updates.");
                    txn = newTxn;
                    continue;
                }
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Semantic conflicts detected. Aborting operation.");
                throw e;
            }
            break;
        }
    }

    private DeltaOperations.Operation getOperation() {
        if (this.optimizeContext.isPurge()) {
            return new DeltaOperations.Reorg(this.partitionPredicate, DeltaOperations$Reorg$.MODULE$.apply$default$2());
        }
        return new DeltaOperations.Optimize(this.partitionPredicate, this.clusteringColumns(), this.isAutoCompact);
    }

    private Map<String, SQLMetric> createMetrics(SparkContext sparkContext, Seq<AddFile> addedFiles, Seq<RemoveFile> removedFiles, Seq<DeletionVectorDescriptor> removedDVs) {
        Tuple2 tuple2 = (Tuple2)((TraversableOnce)removedDVs.map((Function1 & Serializable & scala.Serializable)dv -> new Tuple2.mcJJ.sp(dv.cardinality(), (long)dv.sizeInBytes()), Seq$.MODULE$.canBuildFrom())).reduceLeftOption((Function2 & Serializable & scala.Serializable)(dv1, dv2) -> new Tuple2.mcJJ.sp(dv1._1$mcJ$sp() + dv2._1$mcJ$sp(), dv1._2$mcJ$sp() + dv2._2$mcJ$sp())).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Tuple2.mcJJ.sp(0L, 0L));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long deletionVectorRowsRemoved = tuple2._1$mcJ$sp();
        long deletionVectorBytesRemoved = tuple2._2$mcJ$sp();
        Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(deletionVectorRowsRemoved, deletionVectorBytesRemoved);
        long deletionVectorRowsRemoved2 = sp2._1$mcJ$sp();
        long deletionVectorBytesRemoved2 = sp2._2$mcJ$sp();
        Map dvMetrics = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numDeletionVectorsRemoved"), (Object)OptimizeExecutor.setAndReturnMetric$1("total number of deletion vectors removed", removedDVs.size(), sparkContext)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numDeletionVectorRowsRemoved"), (Object)OptimizeExecutor.setAndReturnMetric$1("total number of deletion vector rows removed", deletionVectorRowsRemoved2, sparkContext)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numDeletionVectorBytesRemoved"), (Object)OptimizeExecutor.setAndReturnMetric$1("total number of bytes of removed deletion vectors", deletionVectorBytesRemoved2, sparkContext))}));
        Option<FileSizeStatsWithHistogram> sizeStats = FileSizeStatsWithHistogram$.MODULE$.create((Seq<Object>)((Seq)((SeqLike)addedFiles.map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToLong((long)x$15.size()), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Long$.MODULE$)));
        return ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"minFileSize"), (Object)OptimizeExecutor.setAndReturnMetric$1("minimum file size", ((FileSizeStatsWithHistogram)sizeStats.get()).min(), sparkContext)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"p25FileSize"), (Object)OptimizeExecutor.setAndReturnMetric$1("25th percentile file size", ((FileSizeStatsWithHistogram)sizeStats.get()).p25(), sparkContext)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"p50FileSize"), (Object)OptimizeExecutor.setAndReturnMetric$1("50th percentile file size", ((FileSizeStatsWithHistogram)sizeStats.get()).p50(), sparkContext)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"p75FileSize"), (Object)OptimizeExecutor.setAndReturnMetric$1("75th percentile file size", ((FileSizeStatsWithHistogram)sizeStats.get()).p75(), sparkContext)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxFileSize"), (Object)OptimizeExecutor.setAndReturnMetric$1("maximum file size", ((FileSizeStatsWithHistogram)sizeStats.get()).max(), sparkContext)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numAddedFiles"), (Object)OptimizeExecutor.setAndReturnMetric$1("total number of files added.", addedFiles.size(), sparkContext)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numRemovedFiles"), (Object)OptimizeExecutor.setAndReturnMetric$1("total number of files removed.", removedFiles.size(), sparkContext)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numAddedBytes"), (Object)OptimizeExecutor.setAndReturnMetric$1("total number of bytes added", OptimizeExecutor.totalSize$1(addedFiles), sparkContext)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numRemovedBytes"), (Object)OptimizeExecutor.setAndReturnMetric$1("total number of bytes removed", OptimizeExecutor.totalSize$1(removedFiles), sparkContext))}))).$plus$plus((GenTraversableOnce)dvMetrics);
    }

    public static final /* synthetic */ boolean $anonfun$optimize$7(AddFile x$5) {
        return x$5.deletionVector() != null;
    }

    public static final /* synthetic */ boolean $anonfun$optimize$9(OptimizeExecutor $this, Seq candidateFiles$1, StructType partitionSchema$1, OptimisticTransaction newTxn) {
        Set candidateSetNew;
        StructType newPartitionSchema = newTxn.metadata().partitionSchema();
        Set candidateSetOld = ((TraversableOnce)candidateFiles$1.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.path(), Seq$.MODULE$.canBuildFrom())).toSet();
        if (candidateSetOld.subsetOf((GenSet)(candidateSetNew = ((TraversableOnce)newTxn.filterFiles($this.partitionPredicate, newTxn.filterFiles$default$2()).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.path(), Seq$.MODULE$.canBuildFrom())).toSet()))) {
            StructType structType = partitionSchema$1;
            StructType structType2 = newPartitionSchema;
            if (!(structType != null ? !structType.equals(structType2) : structType2 != null)) {
                return true;
            }
        }
        Set deleted = (Set)candidateSetOld.$minus$minus((GenTraversableOnce)candidateSetNew);
        $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(86).append("The following compacted files were delete ").append("during checkpoint ").append(deleted.mkString(",")).append(". Aborting the compaction.").toString());
        return false;
    }

    public static final /* synthetic */ long $anonfun$optimize$15(RemoveFile x$10) {
        return BoxesRunTime.unboxToLong((Object)x$10.size().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
    }

    private static final boolean shouldCompactBecauseOfDeletedRows$1(AddFile file, double maxDeletedRowsRatio$1) {
        return file.deletionVector() != null && file.numPhysicalRecords().isEmpty() || BoxesRunTime.unboxToDouble((Object)file.deletedToPhysicalRecordsRatio().getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0)) > maxDeletedRowsRatio$1;
    }

    private final boolean shouldRewriteToBeIcebergCompatible$1(AddFile file) {
        if (this.optimizeContext.icebergCompatVersion().isEmpty()) {
            return false;
        }
        if (file.tags() == null) {
            return true;
        }
        String icebergCompatVersion = (String)file.tags().getOrElse((Object)AddFile$Tags$ICEBERG_COMPAT_VERSION$.MODULE$.name(), (Function0 & Serializable & scala.Serializable)() -> "0");
        return !this.optimizeContext.icebergCompatVersion().exists((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$11 -> {
            String string = Integer.toString(x$11);
            String string2 = icebergCompatVersion;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
    }

    public static final /* synthetic */ boolean $anonfun$pruneCandidateFileList$4(OptimizeExecutor $this, long minFileSize$1, double maxDeletedRowsRatio$1, AddFile addFile) {
        return addFile.size() < minFileSize$1 || OptimizeExecutor.shouldCompactBecauseOfDeletedRows$1(addFile, maxDeletedRowsRatio$1) || $this.shouldRewriteToBeIcebergCompatible$1(addFile);
    }

    public static final /* synthetic */ void $anonfun$groupFilesIntoBins$3(OptimizeExecutor $this, LongRef currentBinSize$1, long maxTargetFileSize$1, ArrayBuffer bins$1, ArrayBuffer currentBin$1, AddFile file) {
        if (file.size() + currentBinSize$1.elem > maxTargetFileSize$1 && !$this.isMultiDimClustering()) {
            bins$1.$plus$eq((Object)currentBin$1.toVector());
            currentBin$1.clear();
            currentBin$1.$plus$eq((Object)file);
            currentBinSize$1.elem = file.size();
            return;
        }
        currentBin$1.$plus$eq((Object)file);
        currentBinSize$1.elem += file.size();
    }

    public static final /* synthetic */ boolean $anonfun$groupFilesIntoBins$4(OptimizeExecutor $this, Seq bin) {
        return bin.size() > 1 || bin.size() == 1 && ((AddFile)bin.apply(0)).deletionVector() != null || bin.size() == 1 && $this.optimizeContext.icebergCompatVersion().isDefined() || $this.isMultiDimClustering();
    }

    private static final SQLMetric setAndReturnMetric$1(String description, long value, SparkContext sparkContext$1) {
        SQLMetric metric = SQLMetrics$.MODULE$.createMetric(sparkContext$1, description);
        metric.set(value);
        return metric;
    }

    public static final /* synthetic */ void $anonfun$createMetrics$1(LongRef totalSize$2, FileAction file) {
        long l;
        FileAction fileAction = file;
        if (fileAction instanceof AddFile) {
            AddFile addFile = (AddFile)fileAction;
            l = addFile.size();
        } else if (fileAction instanceof RemoveFile) {
            RemoveFile removeFile = (RemoveFile)fileAction;
            l = BoxesRunTime.unboxToLong((Object)removeFile.size().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        } else {
            throw new IllegalArgumentException(new StringBuilder(25).append("Unknown FileAction type: ").append(fileAction.getClass()).toString());
        }
        long fileSize = l;
        totalSize$2.elem += fileSize;
    }

    private static final long totalSize$1(Seq actions) {
        LongRef totalSize = LongRef.create((long)0L);
        actions.foreach((Function1 & Serializable & scala.Serializable)file -> {
            OptimizeExecutor.$anonfun$createMetrics$1(totalSize, file);
            return BoxedUnit.UNIT;
        });
        return totalSize.elem;
    }

    public OptimizeExecutor(SparkSession sparkSession, OptimisticTransaction txn, Seq<Expression> partitionPredicate, Seq<String> zOrderByColumns, boolean isAutoCompact, DeltaOptimizeContext optimizeContext) {
        this.sparkSession = sparkSession;
        this.txn = txn;
        this.partitionPredicate = partitionPredicate;
        this.zOrderByColumns = zOrderByColumns;
        this.isAutoCompact = isAutoCompact;
        this.optimizeContext = optimizeContext;
        Logging.$init$((Logging)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
        DeltaCommand.$init$(this);
        SQLMetricsReporting.$init$(this);
        this.operationTimestamp = new SystemClock().getTimeMillis();
        this.org$apache$spark$sql$delta$commands$OptimizeExecutor$$isClusteredTable = ClusteredTableUtils$.MODULE$.isSupported(txn.snapshot().protocol());
        boolean bl = this.isMultiDimClustering = this.org$apache$spark$sql$delta$commands$OptimizeExecutor$$isClusteredTable() || zOrderByColumns.nonEmpty();
        this.clusteringColumns = zOrderByColumns.nonEmpty() ? zOrderByColumns : (this.org$apache$spark$sql$delta$commands$OptimizeExecutor$$isClusteredTable() ? ClusteringColumnInfo$.MODULE$.extractLogicalNames(txn.snapshot()) : Nil$.MODULE$);
    }
}

