/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands.convert;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.delta.DeltaColumnMappingMode;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.commands.convert.CatalogFileManifest;
import org.apache.spark.sql.delta.commands.convert.ConvertTargetFileManifest;
import org.apache.spark.sql.delta.commands.convert.ConvertTargetTable;
import org.apache.spark.sql.delta.commands.convert.ManualListingFileManifest;
import org.apache.spark.sql.delta.commands.convert.MetadataLogFileManifest;
import org.apache.spark.sql.delta.commands.convert.ParquetSchemaFetchConfig;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.execution.streaming.FileStreamSink$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001B\n\u0015\u0001\rB\u0001\"\b\u0001\u0003\u0006\u0004%\t\u0001\u000e\u0005\ts\u0001\u0011\t\u0011)A\u0005k!A!\b\u0001BC\u0002\u0013\u00051\b\u0003\u0005H\u0001\t\u0005\t\u0015!\u0003=\u0011!A\u0005A!b\u0001\n\u0003I\u0005\u0002C+\u0001\u0005\u0003\u0005\u000b\u0011\u0002&\t\u0011Y\u0003!Q1A\u0005\u0002]C\u0001b\u0018\u0001\u0003\u0002\u0003\u0006I\u0001\u0017\u0005\u0006A\u0002!\t!\u0019\u0005\tO\u0002A)\u0019!C\tQ\"9q\u000e\u0001b\u0001\n\u0003\u0002\bBB9\u0001A\u0003%\u0011\f\u0003\u0005s\u0001!\u0015\r\u0011\"\u0011t\u0011\u00159\b\u0001\"\u0001q\u0011\u001dA\bA1A\u0005BmBa!\u001f\u0001!\u0002\u0013a\u0004b\u0002>\u0001\u0005\u0004%\ta\u001f\u0005\u0007\u007f\u0002\u0001\u000b\u0011\u0002?\u0003\u0019A\u000b'/];fiR\u000b'\r\\3\u000b\u0005U1\u0012aB2p]Z,'\u000f\u001e\u0006\u0003/a\t\u0001bY8n[\u0006tGm\u001d\u0006\u00033i\tQ\u0001Z3mi\u0006T!a\u0007\u000f\u0002\u0007M\fHN\u0003\u0002\u001e=\u0005)1\u000f]1sW*\u0011q\u0004I\u0001\u0007CB\f7\r[3\u000b\u0003\u0005\n1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\u0013+]A\u0011Q\u0005K\u0007\u0002M)\tq%A\u0003tG\u0006d\u0017-\u0003\u0002*M\t1\u0011I\\=SK\u001a\u0004\"a\u000b\u0017\u000e\u0003QI!!\f\u000b\u0003%\r{gN^3siR\u000b'oZ3u)\u0006\u0014G.\u001a\t\u0003_Ij\u0011\u0001\r\u0006\u0003ca\t\u0001\"\\3uKJLgnZ\u0005\u0003gA\u0012A\u0002R3mi\u0006dunZ4j]\u001e,\u0012!\u000e\t\u0003m]j\u0011AG\u0005\u0003qi\u0011Ab\u00159be.\u001cVm]:j_:\faa\u001d9be.\u0004\u0013\u0001\u00032bg\u0016\u0004\u0016\r\u001e5\u0016\u0003q\u0002\"!\u0010#\u000f\u0005y\u0012\u0005CA '\u001b\u0005\u0001%BA!#\u0003\u0019a$o\\8u}%\u00111IJ\u0001\u0007!J,G-\u001a4\n\u0005\u00153%AB*ue&twM\u0003\u0002DM\u0005I!-Y:f!\u0006$\b\u000eI\u0001\rG\u0006$\u0018\r\\8h)\u0006\u0014G.Z\u000b\u0002\u0015B\u0019QeS'\n\u000513#AB(qi&|g\u000e\u0005\u0002O'6\tqJ\u0003\u0002Q#\u000691-\u0019;bY><'B\u0001*\u001b\u0003!\u0019\u0017\r^1msN$\u0018B\u0001+P\u00051\u0019\u0015\r^1m_\u001e$\u0016M\u00197f\u00035\u0019\u0017\r^1m_\u001e$\u0016M\u00197fA\u0005\u0019Ro]3s!\u0006\u0014H/\u001b;j_:\u001c6\r[3nCV\t\u0001\fE\u0002&\u0017f\u0003\"AW/\u000e\u0003mS!\u0001\u0018\u000e\u0002\u000bQL\b/Z:\n\u0005y[&AC*ueV\u001cG\u000fV=qK\u0006!Ro]3s!\u0006\u0014H/\u001b;j_:\u001c6\r[3nC\u0002\na\u0001P5oSRtD#\u00022dI\u00164\u0007CA\u0016\u0001\u0011\u0015i\u0012\u00021\u00016\u0011\u0015Q\u0014\u00021\u0001=\u0011\u0015A\u0015\u00021\u0001K\u0011\u00151\u0016\u00021\u0001Y\u0003A\u0019XM]5bY&T\u0018M\u00197f\u0007>tg-F\u0001j!\tQW.D\u0001l\u0015\taG$\u0001\u0003vi&d\u0017B\u00018l\u0005e\u0019VM]5bY&T\u0018M\u00197f\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\u001fA\f'\u000f^5uS>t7k\u00195f[\u0006,\u0012!W\u0001\u0011a\u0006\u0014H/\u001b;j_:\u001c6\r[3nC\u0002\n\u0001B\\;n\r&dWm]\u000b\u0002iB\u0011Q%^\u0005\u0003m\u001a\u0012A\u0001T8oO\u0006YA/\u00192mKN\u001b\u0007.Z7b\u0003\u00191wN]7bi\u00069am\u001c:nCR\u0004\u0013\u0001\u00044jY\u0016l\u0015M\\5gKN$X#\u0001?\u0011\u0005-j\u0018B\u0001@\u0015\u0005e\u0019uN\u001c<feR$\u0016M]4fi\u001aKG.Z'b]&4Wm\u001d;\u0002\u001b\u0019LG.Z'b]&4Wm\u001d;!\u0001")
public class ParquetTable
implements ConvertTargetTable,
DeltaLogging {
    private SerializableConfiguration serializableConf;
    private long numFiles;
    private final SparkSession spark;
    private final String basePath;
    private final Option<CatalogTable> catalogTable;
    private final Option<StructType> userPartitionSchema;
    private final StructType partitionSchema;
    private final String format;
    private final ConvertTargetFileManifest fileManifest;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public Map<String, String> properties() {
        return ConvertTargetTable.properties$(this);
    }

    @Override
    public DeltaColumnMappingMode requiredColumnMappingMode() {
        return ConvertTargetTable.requiredColumnMappingMode$(this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SparkSession spark() {
        return this.spark;
    }

    public String basePath() {
        return this.basePath;
    }

    public Option<CatalogTable> catalogTable() {
        return this.catalogTable;
    }

    public Option<StructType> userPartitionSchema() {
        return this.userPartitionSchema;
    }

    private SerializableConfiguration serializableConf$lzycompute() {
        ParquetTable parquetTable = this;
        synchronized (parquetTable) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.serializableConf = new SerializableConfiguration(this.spark().sessionState().newHadoopConf());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.serializableConf;
    }

    public SerializableConfiguration serializableConf() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.serializableConf$lzycompute();
        }
        return this.serializableConf;
    }

    @Override
    public StructType partitionSchema() {
        return this.partitionSchema;
    }

    private long numFiles$lzycompute() {
        ParquetTable parquetTable = this;
        synchronized (parquetTable) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.numFiles = this.fileManifest().numFiles();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.numFiles;
    }

    @Override
    public long numFiles() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.numFiles$lzycompute();
        }
        return this.numFiles;
    }

    @Override
    public StructType tableSchema() {
        return (StructType)this.fileManifest().parquetSchema().get();
    }

    @Override
    public String format() {
        return this.format;
    }

    @Override
    public ConvertTargetFileManifest fileManifest() {
        return this.fileManifest;
    }

    public ParquetTable(SparkSession spark, String basePath, Option<CatalogTable> catalogTable, Option<StructType> userPartitionSchema) {
        this.spark = spark;
        this.basePath = basePath;
        this.catalogTable = catalogTable;
        this.userPartitionSchema = userPartitionSchema;
        ConvertTargetTable.$init$(this);
        Logging.$init$((Logging)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
        if (catalogTable.isDefined() && userPartitionSchema.isDefined() && !((CatalogTable)catalogTable.get()).partitionSchema().equals(userPartitionSchema.get())) {
            throw DeltaErrors$.MODULE$.unexpectedPartitionSchemaFromUserException(((CatalogTable)catalogTable.get()).partitionSchema(), (StructType)userPartitionSchema.get());
        }
        this.partitionSchema = (StructType)userPartitionSchema.orElse((Function0 & Serializable & scala.Serializable)() -> this.catalogTable().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.partitionSchema())).getOrElse((Function0 & Serializable & scala.Serializable)() -> new StructType());
        this.format = "parquet";
        ParquetSchemaFetchConfig fetchConfig = new ParquetSchemaFetchConfig(spark.sessionState().conf().isParquetBinaryAsString(), spark.sessionState().conf().isParquetINT96AsTimestamp(), spark.sessionState().conf().ignoreCorruptFiles());
        this.fileManifest = BoxesRunTime.unboxToBoolean((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_CONVERT_USE_METADATA_LOG())) && FileStreamSink$.MODULE$.hasMetadata((Seq)new .colon.colon((Object)basePath, (List)Nil$.MODULE$), this.serializableConf().value(), spark.sessionState().conf()) ? new MetadataLogFileManifest(spark, basePath, this.partitionSchema(), fetchConfig, this.serializableConf()) : (BoxesRunTime.unboxToBoolean((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_CONVERT_USE_CATALOG_PARTITIONS())) && catalogTable.isDefined() ? new CatalogFileManifest(spark, basePath, (CatalogTable)catalogTable.get(), this.partitionSchema(), fetchConfig, this.serializableConf()) : new ManualListingFileManifest(spark, basePath, this.partitionSchema(), fetchConfig, this.serializableConf()));
    }
}

