/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.hooks;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.connector.catalog.CatalogManager$;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.hooks.UpdateCatalog;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.threads.DeltaThreadPool$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.ThreadUtils$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class UpdateCatalog$
implements scala.Serializable {
    public static UpdateCatalog$ MODULE$;
    private ExecutionContext tp;
    private final Charset latin1;
    private final int MAX_CATALOG_TYPE_DDL_LENGTH;
    private final String ERROR_KEY;
    private final String LONG_SCHEMA_ERROR;
    private final String HIVE_METASTORE_NAME;
    private final AtomicInteger org$apache$spark$sql$delta$hooks$UpdateCatalog$$activeAsyncRequests;

    static {
        new UpdateCatalog$();
    }

    private ExecutionContext tp() {
        return this.tp;
    }

    private void tp_$eq(ExecutionContext x$1) {
        this.tp = x$1;
    }

    private Charset latin1() {
        return this.latin1;
    }

    public int MAX_CATALOG_TYPE_DDL_LENGTH() {
        return this.MAX_CATALOG_TYPE_DDL_LENGTH;
    }

    public String ERROR_KEY() {
        return this.ERROR_KEY;
    }

    public String LONG_SCHEMA_ERROR() {
        return this.LONG_SCHEMA_ERROR;
    }

    public String HIVE_METASTORE_NAME() {
        return this.HIVE_METASTORE_NAME;
    }

    public synchronized ExecutionContext org$apache$spark$sql$delta$hooks$UpdateCatalog$$getOrCreateExecutionContext(SQLConf conf) {
        block0: {
            if (this.tp() != null) break block0;
            this.tp_$eq((ExecutionContext)ExecutionContext$.MODULE$.fromExecutorService((ExecutorService)DeltaThreadPool$.MODULE$.newDaemonCachedThreadPool("delta-catalog-update", BoxesRunTime.unboxToInt((Object)conf.getConf(DeltaSQLConf$.MODULE$.DELTA_UPDATE_CATALOG_THREAD_POOL_SIZE())))));
        }
        return this.tp();
    }

    public AtomicInteger org$apache$spark$sql$delta$hooks$UpdateCatalog$$activeAsyncRequests() {
        return this.org$apache$spark$sql$delta$hooks$UpdateCatalog$$activeAsyncRequests;
    }

    public boolean awaitCompletion(long timeoutMillis) {
        boolean bl;
        try {
            ThreadUtils$.MODULE$.runInNewThread("UpdateCatalog-awaitCompletion", ThreadUtils$.MODULE$.runInNewThread$default$2(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                long startTime = System.currentTimeMillis();
                while (MODULE$.org$apache$spark$sql$delta$hooks$UpdateCatalog$$activeAsyncRequests().get() > 0) {
                    Thread.sleep(100L);
                    long currentTime = System.currentTimeMillis();
                    if (currentTime - startTime <= timeoutMillis) continue;
                    throw new TimeoutException(new StringBuilder(59).append("Timed out waiting for catalog updates to complete after ").append(currentTime).append(" ms").toString());
                }
            });
            bl = true;
        }
        catch (TimeoutException timeoutException) {
            bl = false;
        }
        return bl;
    }

    public void org$apache$spark$sql$delta$hooks$UpdateCatalog$$replaceTable(SparkSession spark, Snapshot snapshot, CatalogTable table) {
        Map additionalProperties;
        SessionCatalog catalog;
        block5: {
            StructType schema;
            String tblName;
            String db;
            block4: {
                String catalogName;
                catalog = spark.sessionState().catalog();
                TableIdentifier qualifiedIdentifier = catalog.qualifyIdentifier(TableIdentifier$.MODULE$.apply(table.identifier().table(), (Option)new Some((Object)table.database())));
                db = (String)qualifiedIdentifier.database().get();
                tblName = qualifiedIdentifier.table();
                schema = this.truncateSchemaIfNecessary(snapshot.schema());
                additionalProperties = schema.isEmpty() ? (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.ERROR_KEY()), (Object)this.LONG_SCHEMA_ERROR())})) : Predef$.MODULE$.Map().empty();
                String string = catalogName = (String)table.identifier().catalog().getOrElse((Function0 & Serializable & scala.Serializable)() -> spark.sessionState().catalogManager().currentCatalog().name());
                String string2 = this.HIVE_METASTORE_NAME();
                if (!(string == null ? string2 != null : !string.equals(string2))) break block4;
                String string3 = catalogName;
                String string4 = CatalogManager$.MODULE$.SESSION_CATALOG_NAME();
                if (string3 != null ? !string3.equals(string4) : string4 != null) break block5;
            }
            if (catalog.externalCatalog().tableExists(db, tblName)) {
                catalog.externalCatalog().alterTableDataSchema(db, tblName, schema);
            }
        }
        Map x$1 = this.updatedProperties(snapshot).$plus$plus((GenTraversableOnce)additionalProperties);
        TableIdentifier x$2 = table.copy$default$1();
        CatalogTableType x$3 = table.copy$default$2();
        CatalogStorageFormat x$4 = table.copy$default$3();
        StructType x$5 = table.copy$default$4();
        Option x$6 = table.copy$default$5();
        Seq x$7 = table.copy$default$6();
        Option x$8 = table.copy$default$7();
        String x$9 = table.copy$default$8();
        long x$10 = table.copy$default$9();
        long x$11 = table.copy$default$10();
        String x$12 = table.copy$default$11();
        Option x$13 = table.copy$default$13();
        Option x$14 = table.copy$default$14();
        Option x$15 = table.copy$default$15();
        Seq x$16 = table.copy$default$16();
        boolean x$17 = table.copy$default$17();
        boolean x$18 = table.copy$default$18();
        Map x$19 = table.copy$default$19();
        Option x$20 = table.copy$default$20();
        catalog.alterTable(table.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$1, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20));
    }

    public Map<String, String> updatedProperties(Snapshot snapshot) {
        Map newProperties = snapshot.getProperties().toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DeltaConfigs$.MODULE$.METASTORE_LAST_UPDATE_VERSION()), (Object)Long.toString(snapshot.version())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DeltaConfigs$.MODULE$.METASTORE_LAST_COMMIT_TIMESTAMP()), (Object)Long.toString(snapshot.timestamp()))})));
        return newProperties;
    }

    public StructType truncateSchemaIfNecessary(StructType schema) {
        CharsetEncoder encoder = this.latin1().newEncoder();
        if (schema.exists((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)UpdateCatalog$.$anonfun$truncateSchemaIfNecessary$1(this, encoder, f)))) {
            return new StructType();
        }
        return schema;
    }

    public UpdateCatalog apply(CatalogTable table) {
        return new UpdateCatalog(table);
    }

    public Option<CatalogTable> unapply(UpdateCatalog x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)x$0.table());
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final boolean isColumnValid$1(StructField f, CharsetEncoder encoder$1) {
        String typeString = f.dataType().catalogString();
        return encoder$1.canEncode(f.name()) && typeString.length() <= this.MAX_CATALOG_TYPE_DDL_LENGTH() && encoder$1.canEncode(typeString);
    }

    public static final /* synthetic */ boolean $anonfun$truncateSchemaIfNecessary$1(UpdateCatalog$ $this, CharsetEncoder encoder$1, StructField f) {
        return !$this.isColumnValid$1(f, encoder$1);
    }

    private UpdateCatalog$() {
        MODULE$ = this;
        this.latin1 = Charset.forName("ISO-8859-1");
        this.MAX_CATALOG_TYPE_DDL_LENGTH = 4000;
        this.ERROR_KEY = "delta.catalogUpdateError";
        this.LONG_SCHEMA_ERROR = "The schema contains a very long nested field and cannot be stored in the catalog.";
        this.HIVE_METASTORE_NAME = "hive_metastore";
        this.org$apache$spark$sql$delta$hooks$UpdateCatalog$$activeAsyncRequests = new AtomicInteger(0);
    }
}

