/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.perf;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.MapOutputTracker;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.network.util.ByteUnit;
import org.apache.spark.rdd.RDD;
import org.apache.spark.shuffle.FetchFailedException;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.package$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.physical.HashPartitioning;
import org.apache.spark.sql.catalyst.plans.physical.Partitioning;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.UnaryLike;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.perf.DeltaOptimizedWriterExec$;
import org.apache.spark.sql.delta.perf.DeltaOptimizedWriterRDD;
import org.apache.spark.sql.delta.perf.OptimizedWriterBlocks;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.BinPackingUtils$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.execution.ShuffledRowRDD;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.UnaryExecNode;
import org.apache.spark.sql.execution.exchange.ShuffleExchangeExec;
import org.apache.spark.sql.execution.exchange.ShuffleExchangeExec$;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.metric.SQLMetrics$;
import org.apache.spark.sql.execution.metric.SQLShuffleReadMetricsReporter$;
import org.apache.spark.sql.execution.metric.SQLShuffleWriteMetricsReporter$;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.ShuffleBlockId;
import org.apache.spark.util.ThreadUtils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t\rf\u0001B\u0015+\u0001^B\u0001\u0002\u0015\u0001\u0003\u0016\u0004%\t!\u0015\u0005\t%\u0002\u0011\t\u0012)A\u0005q!A1\u000b\u0001BK\u0002\u0013\u0005A\u000b\u0003\u0005j\u0001\tE\t\u0015!\u0003V\u0011!Q\u0007A!f\u0001\n\u0003Y\u0007\u0002\u00039\u0001\u0005#\u0005\u000b\u0011\u00027\t\u000bU\u0004A\u0011\u0001<\t\u000bq\u0004A\u0011I?\t\u0015\u0005=\u0001\u0001#b\u0001\n\u0013\t\t\u0002\u0003\u0006\u0002&\u0001A)\u0019!C\u0005\u0003#A!\"a\n\u0001\u0011\u000b\u0007I\u0011IA\t\u0011)\tI\u0003\u0001EC\u0002\u0013%\u00111\u0006\u0005\u000b\u0003g\u0001\u0001R1A\u0005\n\u0005-\u0002bCA\u001b\u0001\u0001\u0007\t\u0019!C\u0005\u0003oA1\"a\u0010\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002B!Y\u0011Q\n\u0001A\u0002\u0003\u0005\u000b\u0015BA\u001d\u0011)\t\t\u0006\u0001EC\u0002\u0013%\u00111\u000b\u0005\b\u0003?\u0002A\u0011BA\u001c\u0011\u001d\t\t\u0007\u0001C\u0005\u0003GBq!!*\u0001\t\u0013\t9\u000bC\u0004\u00024\u0002!\t%!.\t\u000f\u0005-\u0007\u0001\"\u0003\u0002N\"9\u00111 \u0001\u0005R\u0005u\b\"\u0003B\u0002\u0001\u0005\u0005I\u0011\u0001B\u0003\u0011%\u0011i\u0001AI\u0001\n\u0003\u0011y\u0001C\u0005\u0003&\u0001\t\n\u0011\"\u0001\u0003(!I!1\u0006\u0001\u0012\u0002\u0013\u0005!Q\u0006\u0005\n\u0005c\u0001\u0011\u0011!C!\u0005gA\u0011Ba\u0011\u0001\u0003\u0003%\t!a\u000b\t\u0013\t\u0015\u0003!!A\u0005\u0002\t\u001d\u0003\"\u0003B&\u0001\u0005\u0005I\u0011\tB'\u0011%\u0011)\u0006AA\u0001\n\u0003\u00119\u0006C\u0005\u0003b\u0001\t\t\u0011\"\u0011\u0003d\u001dI!q\r\u0016\u0002\u0002#\u0005!\u0011\u000e\u0004\tS)\n\t\u0011#\u0001\u0003l!1Qo\tC\u0001\u0005sB\u0011Ba\u001f$\u0003\u0003%)E! \t\u0013\t}4%!A\u0005\u0002\n\u0005\u0005\"\u0003BEG\u0005\u0005I\u0011\u0011BF\u0011%\u0011IjIA\u0001\n\u0013\u0011YJ\u0001\rEK2$\u0018m\u00149uS6L'0\u001a3Xe&$XM]#yK\u000eT!a\u000b\u0017\u0002\tA,'O\u001a\u0006\u0003[9\nQ\u0001Z3mi\u0006T!a\f\u0019\u0002\u0007M\fHN\u0003\u00022e\u0005)1\u000f]1sW*\u00111\u0007N\u0001\u0007CB\f7\r[3\u000b\u0003U\n1a\u001c:h\u0007\u0001\u0019b\u0001\u0001\u001d?\u0003\u001ek\u0005CA\u001d=\u001b\u0005Q$BA\u001e/\u0003%)\u00070Z2vi&|g.\u0003\u0002>u\tI1\u000b]1sWBc\u0017M\u001c\t\u0003s}J!\u0001\u0011\u001e\u0003\u001bUs\u0017M]=Fq\u0016\u001cgj\u001c3f!\t\u0011U)D\u0001D\u0015\t!E&\u0001\u0005nKR,'/\u001b8h\u0013\t15I\u0001\u0007EK2$\u0018\rT8hO&tw\r\u0005\u0002I\u00176\t\u0011JC\u0001K\u0003\u0015\u00198-\u00197b\u0013\ta\u0015JA\u0004Qe>$Wo\u0019;\u0011\u0005!s\u0015BA(J\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0015\u0019\u0007.\u001b7e+\u0005A\u0014AB2iS2$\u0007%\u0001\tqCJ$\u0018\u000e^5p]\u000e{G.^7ogV\tQ\u000bE\u0002W=\u0006t!a\u0016/\u000f\u0005a[V\"A-\u000b\u0005i3\u0014A\u0002\u001fs_>$h(C\u0001K\u0013\ti\u0016*A\u0004qC\u000e\\\u0017mZ3\n\u0005}\u0003'aA*fc*\u0011Q,\u0013\t\u0003E\u001at!a\u00193\u0011\u0005aK\u0015BA3J\u0003\u0019\u0001&/\u001a3fM&\u0011q\r\u001b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0015L\u0015!\u00059beRLG/[8o\u0007>dW/\u001c8tA\u0005AA-\u001a7uC2{w-F\u0001m!\tig.D\u0001-\u0013\tyGF\u0001\u0005EK2$\u0018\rT8h\u0003%!W\r\u001c;b\u0019><\u0007\u0005\u000b\u0002\u0007eB\u0011\u0001j]\u0005\u0003i&\u0013\u0011\u0002\u001e:b]NLWM\u001c;\u0002\rqJg.\u001b;?)\u00119\u0018P_>\u0011\u0005a\u0004Q\"\u0001\u0016\t\u000bA;\u0001\u0019\u0001\u001d\t\u000bM;\u0001\u0019A+\t\u000b)<\u0001\u0019\u00017\u0002\r=,H\u000f];u+\u0005q\bc\u0001,_\u007fB!\u0011\u0011AA\u0006\u001b\t\t\u0019A\u0003\u0003\u0002\u0006\u0005\u001d\u0011aC3yaJ,7o]5p]NT1!!\u0003/\u0003!\u0019\u0017\r^1msN$\u0018\u0002BA\u0007\u0003\u0007\u0011\u0011\"\u0011;ue&\u0014W\u000f^3\u0002\u0019]\u0014\u0018\u000e^3NKR\u0014\u0018nY:\u0016\u0005\u0005M\u0001C\u00022\u0002\u0016\u0005\fI\"C\u0002\u0002\u0018!\u00141!T1q!\u0011\tY\"!\t\u000e\u0005\u0005u!bAA\u0010u\u00051Q.\u001a;sS\u000eLA!a\t\u0002\u001e\tI1+\u0015'NKR\u0014\u0018nY\u0001\fe\u0016\fG-T3ue&\u001c7/A\u0004nKR\u0014\u0018nY:\u0002%\rD\u0017\u000e\u001c3Ok6\u0004\u0016M\u001d;ji&|gn]\u000b\u0003\u0003[\u00012\u0001SA\u0018\u0013\r\t\t$\u0013\u0002\u0004\u0013:$\u0018!\u00048v[B\u000b'\u000f^5uS>t7/\u0001\tdC\u000eDW\rZ*ik\u001a4G.\u001a*E\tV\u0011\u0011\u0011\b\t\u0004s\u0005m\u0012bAA\u001fu\tq1\u000b[;gM2,GMU8x%\u0012#\u0015\u0001F2bG\",Gm\u00155vM\u001adWM\u0015#E?\u0012*\u0017\u000f\u0006\u0003\u0002D\u0005%\u0003c\u0001%\u0002F%\u0019\u0011qI%\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003\u0017z\u0011\u0011!a\u0001\u0003s\t1\u0001\u001f\u00132\u0003E\u0019\u0017m\u00195fINCWO\u001a4mKJ#E\t\t\u0015\u0003!I\f!\"\\1q)J\f7m[3s+\t\t)\u0006\u0005\u0003\u0002X\u0005eS\"\u0001\u0019\n\u0007\u0005m\u0003G\u0001\tNCB|U\u000f\u001e9viR\u0013\u0018mY6fe\"\u0012\u0011C]\u0001\u000eO\u0016$8\u000b[;gM2,'\u000b\u0012#\u0002\u0017\r|W\u000e];uK\nKgn\u001d\u000b\u0003\u0003K\u0002R\u0001SA4\u0003WJ1!!\u001bJ\u0005\u0015\t%O]1z!\u00151\u0016QNA9\u0013\r\ty\u0007\u0019\u0002\u0005\u0019&\u001cH\u000fE\u0004I\u0003g\n9(a!\n\u0007\u0005U\u0014J\u0001\u0004UkBdWM\r\t\u0005\u0003s\ny(\u0004\u0002\u0002|)\u0019\u0011Q\u0010\u0019\u0002\u000fM$xN]1hK&!\u0011\u0011QA>\u00059\u0011En\\2l\u001b\u0006t\u0017mZ3s\u0013\u0012\u0004b!!\"\u0002\u0010\u0006MUBAAD\u0015\u0011\tI)a#\u0002\u000f5,H/\u00192mK*\u0019\u0011QR%\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0012\u0006\u001d%aC!se\u0006L()\u001e4gKJ\u0004\u0012\u0002SAK\u00033\u000by*!\f\n\u0007\u0005]\u0015J\u0001\u0004UkBdWm\r\t\u0005\u0003s\nY*\u0003\u0003\u0002\u001e\u0006m$a\u0002\"m_\u000e\\\u0017\n\u001a\t\u0004\u0011\u0006\u0005\u0016bAAR\u0013\n!Aj\u001c8h\u0003=9W\r^*ik\u001a4G.Z*uCR\u001cHCAAU!\u0015A\u0015qMAV!\u001dA\u00151OA<\u0003[\u0003b!a,\u00022\u0006MUBAAF\u0013\ry\u00161R\u0001\nI>,\u00050Z2vi\u0016$\"!a.\u0011\r\u0005e\u0016qXAb\u001b\t\tYLC\u0002\u0002>B\n1A\u001d3e\u0013\u0011\t\t-a/\u0003\u0007I#E\t\u0005\u0003\u0002F\u0006\u001dWBAA\u0004\u0013\u0011\tI-a\u0002\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\bO\u0016$8i\u001c8g+\u0011\ty-!6\u0015\t\u0005E\u0017q\u001d\t\u0005\u0003'\f)\u000e\u0004\u0001\u0005\u000f\u0005]gC1\u0001\u0002Z\n\tA+\u0005\u0003\u0002\\\u0006\u0005\bc\u0001%\u0002^&\u0019\u0011q\\%\u0003\u000f9{G\u000f[5oOB\u0019\u0001*a9\n\u0007\u0005\u0015\u0018JA\u0002B]fDq!!;\u0017\u0001\u0004\tY/A\u0003f]R\u0014\u0018\u0010\u0005\u0004\u0002n\u0006]\u0018\u0011[\u0007\u0003\u0003_TA!!=\u0002t\u000611m\u001c8gS\u001eT1!!>1\u0003!Ig\u000e^3s]\u0006d\u0017\u0002BA}\u0003_\u00141bQ8oM&<WI\u001c;ss\u0006!r/\u001b;i\u001d\u0016<8\t[5mI&sG/\u001a:oC2$2a^A\u0000\u0011\u0019\u0011\ta\u0006a\u0001q\u0005Aa.Z<DQ&dG-\u0001\u0003d_BLHcB<\u0003\b\t%!1\u0002\u0005\b!b\u0001\n\u00111\u00019\u0011\u001d\u0019\u0006\u0004%AA\u0002UCqA\u001b\r\u0011\u0002\u0003\u0007A.\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\tE!f\u0001\u001d\u0003\u0014-\u0012!Q\u0003\t\u0005\u0005/\u0011\t#\u0004\u0002\u0003\u001a)!!1\u0004B\u000f\u0003%)hn\u00195fG.,GMC\u0002\u0003 %\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\u0019C!\u0007\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t%\"fA+\u0003\u0014\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTC\u0001B\u0018U\ra'1C\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\tU\u0002\u0003\u0002B\u001c\u0005\u0003j!A!\u000f\u000b\t\tm\"QH\u0001\u0005Y\u0006twM\u0003\u0002\u0003@\u0005!!.\u0019<b\u0013\r9'\u0011H\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\tO!\u0013\t\u0013\u0005-c$!AA\u0002\u00055\u0012a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t=\u0003CBAX\u0005#\n\t/\u0003\u0003\u0003T\u0005-%\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BA!\u0017\u0003`A\u0019\u0001Ja\u0017\n\u0007\tu\u0013JA\u0004C_>dW-\u00198\t\u0013\u0005-\u0003%!AA\u0002\u0005\u0005\u0018AB3rk\u0006d7\u000f\u0006\u0003\u0003Z\t\u0015\u0004\"CA&C\u0005\u0005\t\u0019AAq\u0003a!U\r\u001c;b\u001fB$\u0018.\\5{K\u0012<&/\u001b;fe\u0016CXm\u0019\t\u0003q\u000e\u001aBa\tB7\u001bBA!q\u000eB;qUcw/\u0004\u0002\u0003r)\u0019!1O%\u0002\u000fI,h\u000e^5nK&!!q\u000fB9\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u000b\u0003\u0005S\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005k\tQ!\u00199qYf$ra\u001eBB\u0005\u000b\u00139\tC\u0003QM\u0001\u0007\u0001\bC\u0003TM\u0001\u0007Q\u000bC\u0003kM\u0001\u0007A.A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t5%Q\u0013\t\u0006\u0011\n=%1S\u0005\u0004\u0005#K%AB(qi&|g\u000e\u0005\u0004I\u0003+CT\u000b\u001c\u0005\t\u0005/;\u0013\u0011!a\u0001o\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005;\u0003BAa\u000e\u0003 &!!\u0011\u0015B\u001d\u0005\u0019y%M[3di\u0002")
public class DeltaOptimizedWriterExec
extends SparkPlan
implements UnaryExecNode,
DeltaLogging {
    private Map<String, SQLMetric> writeMetrics;
    private Map<String, SQLMetric> readMetrics;
    private Map<String, SQLMetric> metrics;
    private int childNumPartitions;
    private int numPartitions;
    private transient MapOutputTracker mapTracker;
    private final SparkPlan child;
    private final Seq<String> partitionColumns;
    private final transient DeltaLog deltaLog;
    private transient ShuffledRowRDD cachedShuffleRDD;
    private transient Seq<SparkPlan> children;
    private volatile byte bitmap$0;
    private volatile transient byte bitmap$trans$0;

    public static Option<Tuple3<SparkPlan, Seq<String>, DeltaLog>> unapply(DeltaOptimizedWriterExec deltaOptimizedWriterExec) {
        return DeltaOptimizedWriterExec$.MODULE$.unapply(deltaOptimizedWriterExec);
    }

    public static Function1<Tuple3<SparkPlan, Seq<String>, DeltaLog>, DeltaOptimizedWriterExec> tupled() {
        return DeltaOptimizedWriterExec$.MODULE$.tupled();
    }

    public static Function1<SparkPlan, Function1<Seq<String>, Function1<DeltaLog, DeltaOptimizedWriterExec>>> curried() {
        return DeltaOptimizedWriterExec$.MODULE$.curried();
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public /* synthetic */ String org$apache$spark$sql$execution$UnaryExecNode$$super$formattedNodeName() {
        return super.formattedNodeName();
    }

    public String verboseStringWithOperatorId() {
        return UnaryExecNode.verboseStringWithOperatorId$((UnaryExecNode)this);
    }

    public final TreeNode mapChildren(Function1 f) {
        return UnaryLike.mapChildren$((UnaryLike)this, (Function1)f);
    }

    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return UnaryLike.withNewChildrenInternal$((UnaryLike)this, (IndexedSeq)newChildren);
    }

    private Seq<SparkPlan> children$lzycompute() {
        DeltaOptimizedWriterExec deltaOptimizedWriterExec = this;
        synchronized (deltaOptimizedWriterExec) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.children = UnaryLike.children$((UnaryLike)this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.children;
    }

    public final Seq<SparkPlan> children() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    public SparkPlan child() {
        return this.child;
    }

    public Seq<String> partitionColumns() {
        return this.partitionColumns;
    }

    public DeltaLog deltaLog() {
        return this.deltaLog;
    }

    public Seq<Attribute> output() {
        return this.child().output();
    }

    private Map<String, SQLMetric> writeMetrics$lzycompute() {
        DeltaOptimizedWriterExec deltaOptimizedWriterExec = this;
        synchronized (deltaOptimizedWriterExec) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.writeMetrics = SQLShuffleWriteMetricsReporter$.MODULE$.createShuffleWriteMetrics(this.sparkContext());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.writeMetrics;
    }

    private Map<String, SQLMetric> writeMetrics() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.writeMetrics$lzycompute();
        }
        return this.writeMetrics;
    }

    private Map<String, SQLMetric> readMetrics$lzycompute() {
        DeltaOptimizedWriterExec deltaOptimizedWriterExec = this;
        synchronized (deltaOptimizedWriterExec) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.readMetrics = SQLShuffleReadMetricsReporter$.MODULE$.createShuffleReadMetrics(this.sparkContext());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.readMetrics;
    }

    private Map<String, SQLMetric> readMetrics() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.readMetrics$lzycompute();
        }
        return this.readMetrics;
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        DeltaOptimizedWriterExec deltaOptimizedWriterExec = this;
        synchronized (deltaOptimizedWriterExec) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.metrics = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataSize"), (Object)SQLMetrics$.MODULE$.createSizeMetric(this.sparkContext(), "data size", SQLMetrics$.MODULE$.createSizeMetric$default$3()))}))).$plus$plus(this.readMetrics()).$plus$plus(this.writeMetrics());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.metrics;
    }

    public Map<String, SQLMetric> metrics() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.metrics$lzycompute();
        }
        return this.metrics;
    }

    private int childNumPartitions$lzycompute() {
        DeltaOptimizedWriterExec deltaOptimizedWriterExec = this;
        synchronized (deltaOptimizedWriterExec) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.childNumPartitions = this.child().execute().getNumPartitions();
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.childNumPartitions;
    }

    private int childNumPartitions() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.childNumPartitions$lzycompute();
        }
        return this.childNumPartitions;
    }

    private int numPartitions$lzycompute() {
        DeltaOptimizedWriterExec deltaOptimizedWriterExec = this;
        synchronized (deltaOptimizedWriterExec) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                int targetShuffleBlocks = BoxesRunTime.unboxToInt((Object)this.getConf(DeltaSQLConf$.MODULE$.DELTA_OPTIMIZE_WRITE_SHUFFLE_BLOCKS()));
                this.numPartitions = scala.math.package$.MODULE$.min(scala.math.package$.MODULE$.max(targetShuffleBlocks / this.childNumPartitions(), 1), BoxesRunTime.unboxToInt((Object)this.getConf(DeltaSQLConf$.MODULE$.DELTA_OPTIMIZE_WRITE_MAX_SHUFFLE_PARTITIONS())));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.numPartitions;
    }

    private int numPartitions() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.numPartitions$lzycompute();
        }
        return this.numPartitions;
    }

    private ShuffledRowRDD cachedShuffleRDD() {
        return this.cachedShuffleRDD;
    }

    private void cachedShuffleRDD_$eq(ShuffledRowRDD x$1) {
        this.cachedShuffleRDD = x$1;
    }

    private MapOutputTracker mapTracker$lzycompute() {
        DeltaOptimizedWriterExec deltaOptimizedWriterExec = this;
        synchronized (deltaOptimizedWriterExec) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.mapTracker = SparkEnv$.MODULE$.get().mapOutputTracker();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.mapTracker;
    }

    private MapOutputTracker mapTracker() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.mapTracker$lzycompute();
        }
        return this.mapTracker;
    }

    private ShuffledRowRDD getShuffleRDD() {
        block0: {
            if (this.cachedShuffleRDD() != null) break block0;
            Function2 resolver = package$.MODULE$.caseInsensitiveResolution();
            HashPartitioning saltedPartitioning = new HashPartitioning((Seq)this.partitionColumns().map((Function1 & Serializable & scala.Serializable)p -> (Attribute)this.output().find((Function1 & Serializable & scala.Serializable)o -> BoxesRunTime.boxToBoolean((boolean)DeltaOptimizedWriterExec.$anonfun$getShuffleRDD$2(resolver, p, o))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw DeltaErrors$.MODULE$.failedFindPartitionColumnInOutputPlan((String)p);
            }), Seq$.MODULE$.canBuildFrom()), this.numPartitions());
            ShuffledRowRDD shuffledRDD = (ShuffledRowRDD)new ShuffleExchangeExec((Partitioning)saltedPartitioning, this.child(), ShuffleExchangeExec$.MODULE$.apply$default$3(), ShuffleExchangeExec$.MODULE$.apply$default$4()).execute();
            this.cachedShuffleRDD_$eq(shuffledRDD);
        }
        return this.cachedShuffleRDD();
    }

    private List<Tuple2<BlockManagerId, ArrayBuffer<Tuple3<BlockId, Object, Object>>>>[] computeBins() {
        Tuple2<BlockManagerId, Seq<Tuple3<BlockId, Object, Object>>>[] shuffleStats = this.getShuffleStats();
        Map blockInfo = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])shuffleStats)).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                BlockManagerId bmId = (BlockManagerId)tuple2._1();
                Seq blocks = (Seq)tuple2._2();
                return (Seq)blocks.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple3 tuple3 = x0$2;
                    if (tuple3 != null) {
                        BlockId blockId = (BlockId)tuple3._1();
                        long size = BoxesRunTime.unboxToLong((Object)tuple3._2());
                        int index = BoxesRunTime.unboxToInt((Object)tuple3._3());
                        return new Tuple2((Object)blockId, (Object)new Tuple3((Object)bmId, (Object)BoxesRunTime.boxToLong((long)size), (Object)BoxesRunTime.boxToInteger((int)index)));
                    }
                    throw new MatchError((Object)tuple3);
                }, Seq$.MODULE$.canBuildFrom());
            }
            throw new MatchError((Object)tuple2);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        long maxBinSize = ByteUnit.BYTE.convertFrom(BoxesRunTime.unboxToLong((Object)this.getConf(DeltaSQLConf$.MODULE$.DELTA_OPTIMIZE_WRITE_BIN_SIZE())), ByteUnit.MiB);
        Iterable bins = (Iterable)((TraversableLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])shuffleStats)).toSeq().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> (Seq)x$1._2(), Seq$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)DeltaOptimizedWriterExec.$anonfun$computeBins$4(x$2))).flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                Seq blocks = (Seq)tuple2._2();
                return BinPackingUtils$.MODULE$.binPackBySize(blocks, (Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)DeltaOptimizedWriterExec.$anonfun$computeBins$6(x$3)), (Function1 & Serializable & scala.Serializable)x$4 -> (BlockId)x$4._1(), maxBinSize);
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom());
        return (List[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)bins.map((Function1 & Serializable & scala.Serializable)bin -> {
            LongRef binSize = LongRef.create((long)0L);
            HashMap blockLocations = new HashMap();
            bin.foreach((Function1 & Serializable & scala.Serializable)blockId -> {
                DeltaOptimizedWriterExec.$anonfun$computeBins$9(blockInfo, binSize, blockLocations, blockId);
                return BoxedUnit.UNIT;
            });
            return new Tuple2((Object)BoxesRunTime.boxToLong((long)binSize.elem), (Object)blockLocations.toList());
        }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tuple2.class)))).sortBy((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6._1$mcJ$sp()), scala.package$.MODULE$.Ordering().apply((Ordering)Ordering.Long$.MODULE$).reverse()))).map((Function1 & Serializable & scala.Serializable)x$7 -> (List)x$7._2(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(List.class)));
    }

    private Tuple2<BlockManagerId, Seq<Tuple3<BlockId, Object, Object>>>[] getShuffleStats() {
        Tuple2[] tuple2Array;
        ShuffleDependency dep = this.getShuffleRDD().dependency();
        try {
            Tuple2[] res = this.getStats$1(dep);
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])res)).isEmpty()) {
                this.awaitShuffleMapStage$1(dep);
            }
            tuple2Array = this.getStats$1(dep);
        }
        catch (FetchFailedException e) {
            this.logWarning((Function0 & Serializable & scala.Serializable)() -> "Failed to fetch shuffle blocks for the optimized writer. Retrying", e);
            this.awaitShuffleMapStage$1(dep);
            tuple2Array = this.getStats$1(dep);
        }
        return tuple2Array;
    }

    public RDD<InternalRow> doExecute() {
        if (this.childNumPartitions() <= 1) {
            return this.child().execute();
        }
        ShuffledRowRDD shuffledRDD = this.getShuffleRDD();
        List<Tuple2<BlockManagerId, ArrayBuffer<Tuple3<BlockId, Object, Object>>>>[] partitions = this.computeBins();
        DeltaLog x$1 = this.deltaLog();
        String x$2 = "delta.optimizeWrite.planned";
        Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"originalPartitions"), (Object)BoxesRunTime.boxToInteger((int)this.childNumPartitions())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"outputPartitions"), (Object)BoxesRunTime.boxToInteger((int)partitions.length)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"shufflePartitions"), (Object)BoxesRunTime.boxToInteger((int)this.numPartitions())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numShuffleBlocks"), this.getConf(DeltaSQLConf$.MODULE$.DELTA_OPTIMIZE_WRITE_SHUFFLE_BLOCKS())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"binSize"), this.getConf(DeltaSQLConf$.MODULE$.DELTA_OPTIMIZE_WRITE_BIN_SIZE())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxShufflePartitions"), this.getConf(DeltaSQLConf$.MODULE$.DELTA_OPTIMIZE_WRITE_MAX_SHUFFLE_PARTITIONS()))}));
        Map<TagDefinition, String> x$4 = this.recordDeltaEvent$default$3();
        Option<Path> x$5 = this.recordDeltaEvent$default$5();
        this.recordDeltaEvent(x$1, x$2, x$4, x$3, x$5);
        return new DeltaOptimizedWriterRDD(this.sparkContext(), shuffledRDD.dependency(), this.readMetrics(), new OptimizedWriterBlocks(partitions));
    }

    private <T> T getConf(ConfigEntry<T> entry) {
        return (T)this.conf().getConf(entry);
    }

    public DeltaOptimizedWriterExec withNewChildInternal(SparkPlan newChild) {
        return this.copy(newChild, this.copy$default$2(), this.copy$default$3());
    }

    public DeltaOptimizedWriterExec copy(SparkPlan child, Seq<String> partitionColumns, DeltaLog deltaLog) {
        return new DeltaOptimizedWriterExec(child, partitionColumns, deltaLog);
    }

    public SparkPlan copy$default$1() {
        return this.child();
    }

    public Seq<String> copy$default$2() {
        return this.partitionColumns();
    }

    public DeltaLog copy$default$3() {
        return this.deltaLog();
    }

    public String productPrefix() {
        return "DeltaOptimizedWriterExec";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return this.partitionColumns();
            }
            case 2: {
                return this.deltaLog();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DeltaOptimizedWriterExec;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DeltaOptimizedWriterExec)) return false;
        boolean bl = true;
        if (!bl) return false;
        DeltaOptimizedWriterExec deltaOptimizedWriterExec = (DeltaOptimizedWriterExec)x$1;
        SparkPlan sparkPlan = this.child();
        SparkPlan sparkPlan2 = deltaOptimizedWriterExec.child();
        if (sparkPlan == null) {
            if (sparkPlan2 != null) {
                return false;
            }
        } else if (!sparkPlan.equals(sparkPlan2)) return false;
        Seq<String> seq = this.partitionColumns();
        Seq<String> seq2 = deltaOptimizedWriterExec.partitionColumns();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        DeltaLog deltaLog = this.deltaLog();
        DeltaLog deltaLog2 = deltaOptimizedWriterExec.deltaLog();
        if (deltaLog == null) {
            if (deltaLog2 != null) {
                return false;
            }
        } else if (!deltaLog.equals(deltaLog2)) return false;
        if (!deltaOptimizedWriterExec.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$getShuffleRDD$2(Function2 resolver$1, String p$1, Attribute o) {
        return BoxesRunTime.unboxToBoolean((Object)resolver$1.apply((Object)p$1, (Object)o.name()));
    }

    public static final /* synthetic */ int $anonfun$computeBins$4(Tuple3 x$2) {
        return ((ShuffleBlockId)x$2._1()).reduceId();
    }

    public static final /* synthetic */ long $anonfun$computeBins$6(Tuple3 x$3) {
        return BoxesRunTime.unboxToLong((Object)x$3._2());
    }

    public static final /* synthetic */ void $anonfun$computeBins$9(Map blockInfo$1, LongRef binSize$1, HashMap blockLocations$1, BlockId blockId) {
        Tuple3 tuple3 = (Tuple3)blockInfo$1.apply((Object)blockId);
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        BlockManagerId bmId = (BlockManagerId)tuple3._1();
        long size = BoxesRunTime.unboxToLong((Object)tuple3._2());
        int index = BoxesRunTime.unboxToInt((Object)tuple3._3());
        Tuple3 tuple32 = new Tuple3((Object)bmId, (Object)BoxesRunTime.boxToLong((long)size), (Object)BoxesRunTime.boxToInteger((int)index));
        BlockManagerId bmId2 = (BlockManagerId)tuple32._1();
        long size2 = BoxesRunTime.unboxToLong((Object)tuple32._2());
        int index2 = BoxesRunTime.unboxToInt((Object)tuple32._3());
        binSize$1.elem += size2;
        ArrayBuffer blocksAtBM = (ArrayBuffer)blockLocations$1.getOrElseUpdate((Object)bmId2, (Function0 & Serializable & scala.Serializable)() -> new ArrayBuffer());
        blocksAtBM.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)blockId, (Object)BoxesRunTime.boxToLong((long)size2), (Object)BoxesRunTime.boxToInteger((int)index2))}));
    }

    private final Tuple2[] getStats$1(ShuffleDependency dep$1) {
        return (Tuple2[])this.mapTracker().getMapSizesByExecutorId(dep$1.shuffleId(), 0, Integer.MAX_VALUE, 0, this.numPartitions()).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
    }

    private final void awaitShuffleMapStage$1(ShuffleDependency dep$1) {
        Predef$.MODULE$.assert(dep$1 != null, (Function0 & Serializable & scala.Serializable)() -> "Shuffle dependency should not be null");
        ThreadUtils$.MODULE$.awaitResult((Awaitable)this.sparkContext().submitMapStage(dep$1), (Duration)Duration$.MODULE$.Inf());
    }

    public DeltaOptimizedWriterExec(SparkPlan child, Seq<String> partitionColumns, DeltaLog deltaLog) {
        this.child = child;
        this.partitionColumns = partitionColumns;
        this.deltaLog = deltaLog;
        UnaryLike.$init$((UnaryLike)this);
        UnaryExecNode.$init$((UnaryExecNode)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
    }
}

