/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.skipping.clustering;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.delta.ClusteringTableFeature$;
import org.apache.spark.sql.delta.DeltaColumnMappingMode;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.OptimisticTransaction;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.actions.DomainMetadata;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.actions.TableFeatureProtocolUtils$;
import org.apache.spark.sql.delta.clustering.ClusteringMetadataDomain$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.schema.SchemaUtils$;
import org.apache.spark.sql.delta.skipping.clustering.ClusteredTableUtils$;
import org.apache.spark.sql.delta.skipping.clustering.ClusteredTableUtilsBase$;
import org.apache.spark.sql.delta.skipping.clustering.ClusteringColumn;
import org.apache.spark.sql.delta.skipping.clustering.ClusteringColumn$;
import org.apache.spark.sql.delta.skipping.clustering.ClusteringColumnInfo;
import org.apache.spark.sql.delta.skipping.clustering.ClusteringColumnInfo$;
import org.apache.spark.sql.delta.skipping.clustering.temp.ClusterBySpec;
import org.apache.spark.sql.delta.skipping.clustering.temp.ClusterBySpec$;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.stats.DeltaStatistics$;
import org.apache.spark.sql.delta.stats.DeltaStatsColumnSpec;
import org.apache.spark.sql.delta.stats.StatisticsCollection;
import org.apache.spark.sql.delta.stats.StatisticsCollection$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.delta.util.Utils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=haB\r\u001b!\u0003\r\t!\u000b\u0005\u0006m\u0001!\ta\u000e\u0005\bw\u0001\u0011\r\u0011\"\u0001=\u0011\u0015A\u0005\u0001\"\u0001J\u0011\u0015)\u0006\u0001\"\u0001=\u0011\u00151\u0006\u0001\"\u0001X\u0011\u00151\u0006\u0001\"\u0001Z\u0011\u0015)\u0007\u0001\"\u0001g\u0011\u0015\t\b\u0001\"\u0001s\u0011\u0015A\b\u0001\"\u0001z\u0011\u0019y\b\u0001\"\u0001\u0002\u0002!I\u0011\u0011\u0006\u0001\u0012\u0002\u0013\u0005\u00111\u0006\u0005\b\u0003\u0003\u0002A\u0011AA\"\u0011\u001d\tI\u0005\u0001C\u0001\u0003\u0017Bq!a\u0019\u0001\t\u0003\t)\u0007C\u0004\u0002J\u0001!\t!a\u001d\t\u000f\u0005e\u0004\u0001\"\u0001\u0002|!9\u0011\u0011\u0012\u0001\u0005\u0002\u0005-\u0005bBAI\u0001\u0011\u0005\u00111\u0013\u0005\b\u00037\u0003A\u0011AAO\u0011\u001d\t\t\n\u0001C\u0001\u0003GCq!!.\u0001\t\u0013\t9\fC\u0004\u0002\u0012\u0002!I!a3\t\u000f\u0005u\u0007\u0001\"\u0001\u0002`\"9\u0011q\u001d\u0001\u0005\n\u0005%(aF\"mkN$XM]3e)\u0006\u0014G.Z+uS2\u001c()Y:f\u0015\tYB$\u0001\u0006dYV\u001cH/\u001a:j]\u001eT!!\b\u0010\u0002\u0011M\\\u0017\u000e\u001d9j]\u001eT!a\b\u0011\u0002\u000b\u0011,G\u000e^1\u000b\u0005\u0005\u0012\u0013aA:rY*\u00111\u0005J\u0001\u0006gB\f'o\u001b\u0006\u0003K\u0019\na!\u00199bG\",'\"A\u0014\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001Q\u0003\u0007\u0005\u0002,]5\tAFC\u0001.\u0003\u0015\u00198-\u00197b\u0013\tyCF\u0001\u0004B]f\u0014VM\u001a\t\u0003cQj\u0011A\r\u0006\u0003gy\t\u0001\"\\3uKJLgnZ\u0005\u0003kI\u0012A\u0002R3mi\u0006dunZ4j]\u001e\fa\u0001J5oSR$C#\u0001\u001d\u0011\u0005-J\u0014B\u0001\u001e-\u0005\u0011)f.\u001b;\u0002/A\u0013v\nU0D\u0019V\u001bF+\u0012*J\u001d\u001e{6i\u0014'V\u001b:\u001bV#A\u001f\u0011\u0005y*eBA D!\t\u0001E&D\u0001B\u0015\t\u0011\u0005&\u0001\u0004=e>|GOP\u0005\u0003\t2\na\u0001\u0015:fI\u00164\u0017B\u0001$H\u0005\u0019\u0019FO]5oO*\u0011A\tL\u0001\fSN\u001cV\u000f\u001d9peR,G\r\u0006\u0002K\u001bB\u00111fS\u0005\u0003\u00192\u0012qAQ8pY\u0016\fg\u000eC\u0003O\u0007\u0001\u0007q*\u0001\u0005qe>$xnY8m!\t\u00016+D\u0001R\u0015\t\u0011f$A\u0004bGRLwN\\:\n\u0005Q\u000b&\u0001\u0003)s_R|7m\u001c7\u0002%\rdWo\u001d;fe&tw\r\u0015:pm&$WM]\u0001\u0017m\u0006d\u0017\u000eZ1uKB\u0013XM^5fo\u0016s\u0017M\u00197fIR\u0011\u0001\b\u0017\u0005\u0006\u001d\u0016\u0001\ra\u0014\u000b\u0003qiCQa\u0017\u0004A\u0002q\u000b!#\\1zE\u0016\u001cE.^:uKJ\u0014\u0015p\u00159fGB\u00191&X0\n\u0005yc#AB(qi&|g\u000e\u0005\u0002aG6\t\u0011M\u0003\u0002c5\u0005!A/Z7q\u0013\t!\u0017MA\u0007DYV\u001cH/\u001a:CsN\u0003XmY\u0001\u0019O\u0016$8\t\\;ti\u0016\u0014()_*qK\u000e|\u0005\u000f^5p]\u0006dGC\u0001/h\u0011\u0015Aw\u00011\u0001j\u0003\u0015!\u0018M\u00197f!\tQw.D\u0001l\u0015\taW.A\u0004dCR\fGn\\4\u000b\u00059\u0004\u0013\u0001C2bi\u0006d\u0017p\u001d;\n\u0005A\\'\u0001D\"bi\u0006dwn\u001a+bE2,\u0017AH4fi\u000ecWo\u001d;fe&twmQ8mk6t7/Q:Qe>\u0004XM\u001d;z)\t\u0019x\u000fE\u0002,;R\u0004BaK;>{%\u0011a\u000f\f\u0002\u0007)V\u0004H.\u001a\u001a\t\u000bmC\u0001\u0019\u0001/\u00023\u001d,G\u000fV1cY\u00164U-\u0019;ve\u0016\u0004&o\u001c9feRLWm\u001d\u000b\u0003uv\u0004BAP>>{%\u0011Ap\u0012\u0002\u0004\u001b\u0006\u0004\b\"\u0002@\n\u0001\u0004Q\u0018AE3ySN$\u0018N\\4Qe>\u0004XM\u001d;jKN\fAD^1mS\u0012\fG/\u001a(v[\u000ecWo\u001d;fe&twmQ8mk6t7\u000fF\u00039\u0003\u0007\tY\u0002C\u0004\u0002\u0006)\u0001\r!a\u0002\u0002#\rdWo\u001d;fe&twmQ8mk6t7\u000f\u0005\u0004\u0002\n\u0005M\u0011\u0011\u0004\b\u0005\u0003\u0017\tyAD\u0002A\u0003\u001bI\u0011!L\u0005\u0004\u0003#a\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003+\t9BA\u0002TKFT1!!\u0005-!\u0015\tI!a\u0005>\u0011%\tiB\u0003I\u0001\u0002\u0004\ty\"A\u0006eK2$\u0018\rT8h\u001fB$\b\u0003B\u0016^\u0003C\u0001B!a\t\u0002&5\ta$C\u0002\u0002(y\u0011\u0001\u0002R3mi\u0006dunZ\u0001'm\u0006d\u0017\u000eZ1uK:+Xn\u00117vgR,'/\u001b8h\u0007>dW/\u001c8tI\u0011,g-Y;mi\u0012\u0012TCAA\u0017U\u0011\ty\"a\f,\u0005\u0005E\u0002\u0003BA\u001a\u0003{i!!!\u000e\u000b\t\u0005]\u0012\u0011H\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u000f-\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u007f\t)DA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fqD]3n_Z,7\t\\;ti\u0016\u0014\u0018N\\4D_2,XN\\:Qe>\u0004XM\u001d;z)\rQ\u0018Q\t\u0005\u0007\u0003\u000fb\u0001\u0019\u0001>\u0002\u001b\r|gNZ5hkJ\fG/[8o\u0003e9W\r\u001e#p[\u0006Lg.T3uC\u0012\fG/Y(qi&|g.\u00197\u0015\r\u00055\u0013QKA-!\u0011YS,a\u0014\u0011\u0007A\u000b\t&C\u0002\u0002TE\u0013a\u0002R8nC&tW*\u001a;bI\u0006$\u0018\r\u0003\u0004\u0002X5\u0001\r\u0001X\u0001\u0011G2,8\u000f^3s\u0005f\u001c\u0006/Z2PaRDq!a\u0017\u000e\u0001\u0004\ti&A\u0002uq:\u0004B!a\t\u0002`%\u0019\u0011\u0011\r\u0010\u0003+=\u0003H/[7jgRL7\r\u0016:b]N\f7\r^5p]\u0006!2M]3bi\u0016$u.\\1j]6+G/\u00193bi\u0006$B!a\u0014\u0002h!9\u0011Q\u0001\bA\u0002\u0005%\u0004CBA\u0005\u0003'\tY\u0007\u0005\u0003\u0002n\u0005=T\"\u0001\u000e\n\u0007\u0005E$D\u0001\tDYV\u001cH/\u001a:j]\u001e\u001cu\u000e\\;n]R1\u0011QJA;\u0003oBQ\u0001[\bA\u0002%Dq!a\u0017\u0010\u0001\u0004\ti&\u0001\u000fhKR\u001cE.^:uKJLgnZ\"pYVlgn](qi&|g.\u00197\u0015\t\u0005u\u0014q\u0010\t\u0005Wu\u000bI\u0007C\u0004\u0002\u0002B\u0001\r!a!\u0002\u0011Mt\u0017\r]:i_R\u0004B!a\t\u0002\u0006&\u0019\u0011q\u0011\u0010\u0003\u0011Ms\u0017\r]:i_R\f1dZ3u\u00072,8\u000f^3sS:<Gi\\7bS:lU\r^1eCR\fG\u0003BAG\u0003\u001f\u0003b!!\u0003\u0002\u0014\u0005=\u0003bBAA#\u0001\u0007\u00111Q\u0001'm\u0006d\u0017\u000eZ1uK\u000ecWo\u001d;fe&twmQ8mk6t7/\u00138Ti\u0006$8oU2iK6\fG#\u0002\u001d\u0002\u0016\u0006]\u0005bBAA%\u0001\u0007\u00111\u0011\u0005\b\u00033\u0013\u0002\u0019AA\r\u0003aawnZ5dC2\u001cE.^:uKJLgnZ\"pYVlgn]\u0001\"CJ,7\t\\;ti\u0016\u0014\u0018N\\4D_2,XN\\:J]N#\u0018\r^:TG\",W.\u0019\u000b\u0006\u0015\u0006}\u0015\u0011\u0015\u0005\b\u0003\u0003\u001b\u0002\u0019AAB\u0011\u001d\tIj\u0005a\u0001\u00033!r\u0001OAS\u0003O\u000b\t\fC\u0003O)\u0001\u0007q\nC\u0004\u0002*R\u0001\r!a+\u0002\u00115,G/\u00193bi\u0006\u00042\u0001UAW\u0013\r\ty+\u0015\u0002\t\u001b\u0016$\u0018\rZ1uC\"1\u00111\u0017\u000bA\u0002}\u000b\u0011b\u00197vgR,'OQ=\u0002AM$\u0018\r^5ti&\u001c7oQ8mY\u0016\u001cG/[8o\rJ|W.T3uC\u0012\fG/\u0019\u000b\u0007\u0003s\u000b)-!3\u0011\t\u0005m\u0016\u0011Y\u0007\u0003\u0003{S1!a0\u001f\u0003\u0015\u0019H/\u0019;t\u0013\u0011\t\u0019-!0\u0003)M#\u0018\r^5ti&\u001c7oQ8mY\u0016\u001cG/[8o\u0011\u0019\t9-\u0006a\u0001\u001f\u0006\t\u0001\u000fC\u0004\u0002*V\u0001\r!a+\u0015\u000ba\ni-!5\t\u000f\u0005=g\u00031\u0001\u0002:\u0006y1\u000f^1ug\u000e{G\u000e\\3di&|g\u000eC\u0004\u0002TZ\u0001\r!!6\u0002+\rdWo\u001d;fe&twmQ8mk6t\u0017J\u001c4pgB1\u0011\u0011BA\n\u0003/\u0004B!!\u001c\u0002Z&\u0019\u00111\u001c\u000e\u0003)\rcWo\u001d;fe&twmQ8mk6t\u0017J\u001c4p\u0003\r2\u0018\r\\5eCR,7\t\\;ti\u0016\u0014\u0018N\\4D_2,XN\\:J]Ns\u0017\r]:i_R$R\u0001OAq\u0003GDq!!!\u0018\u0001\u0004\t\u0019\t\u0003\u0004\u0002f^\u0001\raX\u0001\u000eG2,8\u000f^3s\u0005f\u001c\u0006/Z2\u0002I\u001d,Go\u00117vgR,'/\u001b8h\u0007>dW/\u001c8t\u001d>$\u0018J\\*uCR\u001c8k\u00195f[\u0006$b!!\u0007\u0002l\u00065\bbBAh1\u0001\u0007\u0011\u0011\u0018\u0005\b\u0003'D\u0002\u0019AAk\u0001")
public interface ClusteredTableUtilsBase
extends DeltaLogging {
    public void org$apache$spark$sql$delta$skipping$clustering$ClusteredTableUtilsBase$_setter_$PROP_CLUSTERING_COLUMNS_$eq(String var1);

    public String PROP_CLUSTERING_COLUMNS();

    public static /* synthetic */ boolean isSupported$(ClusteredTableUtilsBase $this, Protocol protocol) {
        return $this.isSupported(protocol);
    }

    default public boolean isSupported(Protocol protocol) {
        return protocol.isFeatureSupported(ClusteringTableFeature$.MODULE$);
    }

    public static /* synthetic */ String clusteringProvider$(ClusteredTableUtilsBase $this) {
        return $this.clusteringProvider();
    }

    default public String clusteringProvider() {
        return "liquid";
    }

    public static /* synthetic */ void validatePreviewEnabled$(ClusteredTableUtilsBase $this, Protocol protocol) {
        $this.validatePreviewEnabled(protocol);
    }

    default public void validatePreviewEnabled(Protocol protocol) {
        if (this.isSupported(protocol) && !BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(DeltaSQLConf$.MODULE$.DELTA_CLUSTERING_TABLE_PREVIEW_ENABLED())) && !Utils$.MODULE$.isTesting()) {
            throw DeltaErrors$.MODULE$.clusteringTablePreviewDisabledException();
        }
    }

    public static /* synthetic */ void validatePreviewEnabled$(ClusteredTableUtilsBase $this, Option maybeClusterBySpec) {
        $this.validatePreviewEnabled((Option<ClusterBySpec>)maybeClusterBySpec);
    }

    default public void validatePreviewEnabled(Option<ClusterBySpec> maybeClusterBySpec) {
        maybeClusterBySpec.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            ClusteredTableUtilsBase.$anonfun$validatePreviewEnabled$1(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ Option getClusterBySpecOptional$(ClusteredTableUtilsBase $this, CatalogTable table) {
        return $this.getClusterBySpecOptional(table);
    }

    default public Option<ClusterBySpec> getClusterBySpecOptional(CatalogTable table) {
        return table.properties().get((Object)this.PROP_CLUSTERING_COLUMNS()).map((Function1 & Serializable & scala.Serializable)columns -> ClusterBySpec$.MODULE$.fromProperty((String)columns));
    }

    public static /* synthetic */ Option getClusteringColumnsAsProperty$(ClusteredTableUtilsBase $this, Option maybeClusterBySpec) {
        return $this.getClusteringColumnsAsProperty((Option<ClusterBySpec>)maybeClusterBySpec);
    }

    default public Option<Tuple2<String, String>> getClusteringColumnsAsProperty(Option<ClusterBySpec> maybeClusterBySpec) {
        return maybeClusterBySpec.map((Function1 & Serializable & scala.Serializable)clusterBySpec -> ClusterBySpec$.MODULE$.toProperty((ClusterBySpec)clusterBySpec));
    }

    public static /* synthetic */ Map getTableFeatureProperties$(ClusteredTableUtilsBase $this, Map existingProperties) {
        return $this.getTableFeatureProperties((Map<String, String>)existingProperties);
    }

    default public Map<String, String> getTableFeatureProperties(Map<String, String> existingProperties) {
        scala.collection.mutable.Map properties = Map$.MODULE$.empty();
        properties.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TableFeatureProtocolUtils$.MODULE$.propertyKey(ClusteringTableFeature$.MODULE$)), (Object)TableFeatureProtocolUtils$.MODULE$.FEATURE_PROP_SUPPORTED()));
        return properties.toMap(Predef$.MODULE$.$conforms());
    }

    public static /* synthetic */ void validateNumClusteringColumns$(ClusteredTableUtilsBase $this, Seq clusteringColumns, Option deltaLogOpt) {
        $this.validateNumClusteringColumns((Seq<Seq<String>>)clusteringColumns, (Option<DeltaLog>)deltaLogOpt);
    }

    default public void validateNumClusteringColumns(Seq<Seq<String>> clusteringColumns, Option<DeltaLog> deltaLogOpt) {
        int numColumnsLimit = BoxesRunTime.unboxToInt((Object)SQLConf$.MODULE$.get().getConf(DeltaSQLConf$.MODULE$.DELTA_NUM_CLUSTERING_COLUMNS_LIMIT()));
        int actualNumColumns = clusteringColumns.size();
        if (actualNumColumns > numColumnsLimit) {
            deltaLogOpt.foreach((Function1 & Serializable & scala.Serializable)deltaLog -> {
                ClusteredTableUtilsBase.$anonfun$validateNumClusteringColumns$1(this, clusteringColumns, numColumnsLimit, deltaLog);
                return BoxedUnit.UNIT;
            });
            throw DeltaErrors$.MODULE$.clusterByInvalidNumColumnsException(numColumnsLimit, actualNumColumns);
        }
    }

    public static /* synthetic */ Option validateNumClusteringColumns$default$2$(ClusteredTableUtilsBase $this) {
        return $this.validateNumClusteringColumns$default$2();
    }

    default public Option<DeltaLog> validateNumClusteringColumns$default$2() {
        return None$.MODULE$;
    }

    public static /* synthetic */ Map removeClusteringColumnsProperty$(ClusteredTableUtilsBase $this, Map configuration) {
        return $this.removeClusteringColumnsProperty((Map<String, String>)configuration);
    }

    default public Map<String, String> removeClusteringColumnsProperty(Map<String, String> configuration) {
        return (Map)configuration.$minus((Object)this.PROP_CLUSTERING_COLUMNS());
    }

    public static /* synthetic */ Option getDomainMetadataOptional$(ClusteredTableUtilsBase $this, Option clusterBySpecOpt, OptimisticTransaction txn) {
        return $this.getDomainMetadataOptional((Option<ClusterBySpec>)clusterBySpecOpt, txn);
    }

    default public Option<DomainMetadata> getDomainMetadataOptional(Option<ClusterBySpec> clusterBySpecOpt, OptimisticTransaction txn) {
        return clusterBySpecOpt.map((Function1 & Serializable & scala.Serializable)clusterBy -> {
            ClusteredTableUtils$.MODULE$.validateClusteringColumnsInStatsSchema(txn.protocol(), txn.metadata(), (ClusterBySpec)clusterBy);
            Seq clusteringColumns = (Seq)((TraversableLike)clusterBy.columnNames().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toString(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$3 -> ClusteringColumn$.MODULE$.apply(txn.metadata().schema(), (String)x$3), Seq$.MODULE$.canBuildFrom());
            return this.createDomainMetadata((Seq<ClusteringColumn>)clusteringColumns);
        });
    }

    public static /* synthetic */ DomainMetadata createDomainMetadata$(ClusteredTableUtilsBase $this, Seq clusteringColumns) {
        return $this.createDomainMetadata((Seq<ClusteringColumn>)clusteringColumns);
    }

    default public DomainMetadata createDomainMetadata(Seq<ClusteringColumn> clusteringColumns) {
        return ClusteringMetadataDomain$.MODULE$.fromClusteringColumns(clusteringColumns).toDomainMetadata(ManifestFactory$.MODULE$.Nothing());
    }

    public static /* synthetic */ Option getDomainMetadataOptional$(ClusteredTableUtilsBase $this, CatalogTable table, OptimisticTransaction txn) {
        return $this.getDomainMetadataOptional(table, txn);
    }

    default public Option<DomainMetadata> getDomainMetadataOptional(CatalogTable table, OptimisticTransaction txn) {
        return this.getDomainMetadataOptional(this.getClusterBySpecOptional(table), txn);
    }

    public static /* synthetic */ Option getClusteringColumnsOptional$(ClusteredTableUtilsBase $this, Snapshot snapshot) {
        return $this.getClusteringColumnsOptional(snapshot);
    }

    default public Option<Seq<ClusteringColumn>> getClusteringColumnsOptional(Snapshot snapshot) {
        return ClusteringMetadataDomain$.MODULE$.fromSnapshot(snapshot).map((Function1 & Serializable & scala.Serializable)x$4 -> (Seq)x$4.clusteringColumns().map((Function1 & Serializable & scala.Serializable)physicalName -> new ClusteringColumn((Seq<String>)physicalName), Seq$.MODULE$.canBuildFrom()));
    }

    public static /* synthetic */ Seq getClusteringDomainMetadata$(ClusteredTableUtilsBase $this, Snapshot snapshot) {
        return $this.getClusteringDomainMetadata(snapshot);
    }

    default public Seq<DomainMetadata> getClusteringDomainMetadata(Snapshot snapshot) {
        return Option$.MODULE$.option2Iterable(ClusteringMetadataDomain$.MODULE$.fromSnapshot(snapshot).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.toDomainMetadata(ManifestFactory$.MODULE$.Nothing()))).toSeq();
    }

    public static /* synthetic */ void validateClusteringColumnsInStatsSchema$(ClusteredTableUtilsBase $this, Snapshot snapshot, Seq logicalClusteringColumns) {
        $this.validateClusteringColumnsInStatsSchema(snapshot, (Seq<String>)logicalClusteringColumns);
    }

    default public void validateClusteringColumnsInStatsSchema(Snapshot snapshot, Seq<String> logicalClusteringColumns) {
        this.validateClusteringColumnsInStatsSchema((StatisticsCollection)snapshot, (Seq<ClusteringColumnInfo>)((Seq)logicalClusteringColumns.map((Function1 & Serializable & scala.Serializable)name -> ClusteringColumnInfo$.MODULE$.apply(snapshot.schema(), ClusteringColumn$.MODULE$.apply(snapshot.schema(), (String)name)), Seq$.MODULE$.canBuildFrom())));
    }

    public static /* synthetic */ boolean areClusteringColumnsInStatsSchema$(ClusteredTableUtilsBase $this, Snapshot snapshot, Seq logicalClusteringColumns) {
        return $this.areClusteringColumnsInStatsSchema(snapshot, (Seq<String>)logicalClusteringColumns);
    }

    default public boolean areClusteringColumnsInStatsSchema(Snapshot snapshot, Seq<String> logicalClusteringColumns) {
        return this.getClusteringColumnsNotInStatsSchema(snapshot, (Seq<ClusteringColumnInfo>)((Seq)logicalClusteringColumns.map((Function1 & Serializable & scala.Serializable)name -> ClusteringColumnInfo$.MODULE$.apply(snapshot.schema(), ClusteringColumn$.MODULE$.apply(snapshot.schema(), (String)name)), Seq$.MODULE$.canBuildFrom()))).isEmpty();
    }

    public static /* synthetic */ void validateClusteringColumnsInStatsSchema$(ClusteredTableUtilsBase $this, Protocol protocol, Metadata metadata, ClusterBySpec clusterBy) {
        $this.validateClusteringColumnsInStatsSchema(protocol, metadata, clusterBy);
    }

    default public void validateClusteringColumnsInStatsSchema(Protocol protocol, Metadata metadata, ClusterBySpec clusterBy) {
        this.validateClusteringColumnsInStatsSchema(this.statisticsCollectionFromMetadata(protocol, metadata), (Seq<ClusteringColumnInfo>)((Seq)clusterBy.columnNames().map((Function1 & Serializable & scala.Serializable)column -> ClusteringColumnInfo$.MODULE$.apply(metadata.schema(), ClusteringColumn$.MODULE$.apply(metadata.schema(), column.toString())), Seq$.MODULE$.canBuildFrom())));
    }

    private StatisticsCollection statisticsCollectionFromMetadata(Protocol p, Metadata metadata) {
        return new StatisticsCollection(null, metadata, p){
            private final StructType tableSchema;
            private final StructType outputAttributeSchema;
            private final StructType outputTableStatsSchema;
            private final DeltaStatsColumnSpec statsColumnSpec;
            private final DeltaColumnMappingMode columnMappingMode;
            private final Protocol protocol;
            private boolean deletionVectorsSupported;
            private Seq<String> org$apache$spark$sql$delta$stats$StatisticsCollection$$explodedDataSchemaNames;
            private StructType statCollectionPhysicalSchema;
            private StructType statCollectionLogicalSchema;
            private Column statsCollector;
            private StructType statsSchema;
            private transient Logger org$apache$spark$internal$Logging$$log_;
            private volatile byte bitmap$0;

            public Seq<Column> applyFuncToStatisticsColumn(StructType statisticsSchema, Column statisticsColumn, PartialFunction<Tuple2<Column, StructField>, Option<Column>> function) {
                return StatisticsCollection.applyFuncToStatisticsColumn$(this, statisticsSchema, statisticsColumn, function);
            }

            public Dataset<Row> updateStatsToWideBounds(Dataset<Row> withStats, String statsColName) {
                return StatisticsCollection.updateStatsToWideBounds$(this, withStats, statsColName);
            }

            public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
                DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
            }

            public Map<TagDefinition, String> recordDeltaEvent$default$3() {
                return DeltaLogging.recordDeltaEvent$default$3$(this);
            }

            public Object recordDeltaEvent$default$4() {
                return DeltaLogging.recordDeltaEvent$default$4$(this);
            }

            public Option<Path> recordDeltaEvent$default$5() {
                return DeltaLogging.recordDeltaEvent$default$5$(this);
            }

            public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
                return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
            }

            public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
                return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
            }

            public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
                return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
            }

            public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
                return DeltaLogging.recordDeltaOperation$default$3$(this);
            }

            public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
                return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
            }

            public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
                return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
            }

            public void logConsole(String line) {
                DatabricksLogging.logConsole$(this, line);
            }

            public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
                DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
            }

            public Map<TagDefinition, String> recordUsage$default$3() {
                return DatabricksLogging.recordUsage$default$3$(this);
            }

            public String recordUsage$default$4() {
                return DatabricksLogging.recordUsage$default$4$(this);
            }

            public boolean recordUsage$default$5() {
                return DatabricksLogging.recordUsage$default$5$(this);
            }

            public boolean recordUsage$default$6() {
                return DatabricksLogging.recordUsage$default$6$(this);
            }

            public boolean recordUsage$default$7() {
                return DatabricksLogging.recordUsage$default$7$(this);
            }

            public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
                DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
            }

            public Map<TagDefinition, String> recordEvent$default$2() {
                return DatabricksLogging.recordEvent$default$2$(this);
            }

            public String recordEvent$default$3() {
                return DatabricksLogging.recordEvent$default$3$(this);
            }

            public boolean recordEvent$default$4() {
                return DatabricksLogging.recordEvent$default$4$(this);
            }

            public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
                return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
            }

            public <S> String recordOperation$default$2() {
                return DatabricksLogging.recordOperation$default$2$(this);
            }

            public <S> boolean recordOperation$default$4() {
                return DatabricksLogging.recordOperation$default$4$(this);
            }

            public <S> boolean recordOperation$default$5() {
                return DatabricksLogging.recordOperation$default$5$(this);
            }

            public <S> boolean recordOperation$default$6() {
                return DatabricksLogging.recordOperation$default$6$(this);
            }

            public <S> boolean recordOperation$default$7() {
                return DatabricksLogging.recordOperation$default$7$(this);
            }

            public <S> MetricDefinition recordOperation$default$8() {
                return DatabricksLogging.recordOperation$default$8$(this);
            }

            public <S> boolean recordOperation$default$9() {
                return DatabricksLogging.recordOperation$default$9$(this);
            }

            public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
                DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
            }

            public Map<TagDefinition, String> recordProductUsage$default$3() {
                return DatabricksLogging.recordProductUsage$default$3$(this);
            }

            public String recordProductUsage$default$4() {
                return DatabricksLogging.recordProductUsage$default$4$(this);
            }

            public boolean recordProductUsage$default$5() {
                return DatabricksLogging.recordProductUsage$default$5$(this);
            }

            public boolean recordProductUsage$default$6() {
                return DatabricksLogging.recordProductUsage$default$6$(this);
            }

            public boolean recordProductUsage$default$7() {
                return DatabricksLogging.recordProductUsage$default$7$(this);
            }

            public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
                DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
            }

            public Map<TagDefinition, String> recordProductEvent$default$2() {
                return DatabricksLogging.recordProductEvent$default$2$(this);
            }

            public String recordProductEvent$default$3() {
                return DatabricksLogging.recordProductEvent$default$3$(this);
            }

            public boolean recordProductEvent$default$4() {
                return DatabricksLogging.recordProductEvent$default$4$(this);
            }

            public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
                return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
            }

            public <T> Map<String, Object> withStatusCode$default$3() {
                return DeltaProgressReporter.withStatusCode$default$3$(this);
            }

            public String logName() {
                return Logging.logName$((Logging)this);
            }

            public Logger log() {
                return Logging.log$((Logging)this);
            }

            public void logInfo(Function0<String> msg) {
                Logging.logInfo$((Logging)this, msg);
            }

            public void logDebug(Function0<String> msg) {
                Logging.logDebug$((Logging)this, msg);
            }

            public void logTrace(Function0<String> msg) {
                Logging.logTrace$((Logging)this, msg);
            }

            public void logWarning(Function0<String> msg) {
                Logging.logWarning$((Logging)this, msg);
            }

            public void logError(Function0<String> msg) {
                Logging.logError$((Logging)this, msg);
            }

            public void logInfo(Function0<String> msg, Throwable throwable) {
                Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
            }

            public void logDebug(Function0<String> msg, Throwable throwable) {
                Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
            }

            public void logTrace(Function0<String> msg, Throwable throwable) {
                Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
            }

            public void logWarning(Function0<String> msg, Throwable throwable) {
                Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
            }

            public void logError(Function0<String> msg, Throwable throwable) {
                Logging.logError$((Logging)this, msg, (Throwable)throwable);
            }

            public boolean isTraceEnabled() {
                return Logging.isTraceEnabled$((Logging)this);
            }

            public void initializeLogIfNecessary(boolean isInterpreter) {
                Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
            }

            public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
                return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
            }

            public boolean initializeLogIfNecessary$default$2() {
                return Logging.initializeLogIfNecessary$default$2$((Logging)this);
            }

            public void initializeForcefully(boolean isInterpreter, boolean silent) {
                Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
            }

            private boolean deletionVectorsSupported$lzycompute() {
                $anon$1 var1_1 = this;
                synchronized (var1_1) {
                    if ((byte)(this.bitmap$0 & 1) == 0) {
                        this.deletionVectorsSupported = StatisticsCollection.deletionVectorsSupported$(this);
                        this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                    }
                }
                return this.deletionVectorsSupported;
            }

            public boolean deletionVectorsSupported() {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    return this.deletionVectorsSupported$lzycompute();
                }
                return this.deletionVectorsSupported;
            }

            private Seq<String> org$apache$spark$sql$delta$stats$StatisticsCollection$$explodedDataSchemaNames$lzycompute() {
                $anon$1 var1_1 = this;
                synchronized (var1_1) {
                    if ((byte)(this.bitmap$0 & 2) == 0) {
                        this.org$apache$spark$sql$delta$stats$StatisticsCollection$$explodedDataSchemaNames = StatisticsCollection.org$apache$spark$sql$delta$stats$StatisticsCollection$$explodedDataSchemaNames$(this);
                        this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                    }
                }
                return this.org$apache$spark$sql$delta$stats$StatisticsCollection$$explodedDataSchemaNames;
            }

            public Seq<String> org$apache$spark$sql$delta$stats$StatisticsCollection$$explodedDataSchemaNames() {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    return this.org$apache$spark$sql$delta$stats$StatisticsCollection$$explodedDataSchemaNames$lzycompute();
                }
                return this.org$apache$spark$sql$delta$stats$StatisticsCollection$$explodedDataSchemaNames;
            }

            private StructType statCollectionPhysicalSchema$lzycompute() {
                $anon$1 var1_1 = this;
                synchronized (var1_1) {
                    if ((byte)(this.bitmap$0 & 4) == 0) {
                        this.statCollectionPhysicalSchema = StatisticsCollection.statCollectionPhysicalSchema$(this);
                        this.bitmap$0 = (byte)(this.bitmap$0 | 4);
                    }
                }
                return this.statCollectionPhysicalSchema;
            }

            public StructType statCollectionPhysicalSchema() {
                if ((byte)(this.bitmap$0 & 4) == 0) {
                    return this.statCollectionPhysicalSchema$lzycompute();
                }
                return this.statCollectionPhysicalSchema;
            }

            private StructType statCollectionLogicalSchema$lzycompute() {
                $anon$1 var1_1 = this;
                synchronized (var1_1) {
                    if ((byte)(this.bitmap$0 & 8) == 0) {
                        this.statCollectionLogicalSchema = StatisticsCollection.statCollectionLogicalSchema$(this);
                        this.bitmap$0 = (byte)(this.bitmap$0 | 8);
                    }
                }
                return this.statCollectionLogicalSchema;
            }

            public StructType statCollectionLogicalSchema() {
                if ((byte)(this.bitmap$0 & 8) == 0) {
                    return this.statCollectionLogicalSchema$lzycompute();
                }
                return this.statCollectionLogicalSchema;
            }

            private Column statsCollector$lzycompute() {
                $anon$1 var1_1 = this;
                synchronized (var1_1) {
                    if ((byte)(this.bitmap$0 & 0x10) == 0) {
                        this.statsCollector = StatisticsCollection.statsCollector$(this);
                        this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
                    }
                }
                return this.statsCollector;
            }

            public Column statsCollector() {
                if ((byte)(this.bitmap$0 & 0x10) == 0) {
                    return this.statsCollector$lzycompute();
                }
                return this.statsCollector;
            }

            private StructType statsSchema$lzycompute() {
                $anon$1 var1_1 = this;
                synchronized (var1_1) {
                    if ((byte)(this.bitmap$0 & 0x20) == 0) {
                        this.statsSchema = StatisticsCollection.statsSchema$(this);
                        this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
                    }
                }
                return this.statsSchema;
            }

            public StructType statsSchema() {
                if ((byte)(this.bitmap$0 & 0x20) == 0) {
                    return this.statsSchema$lzycompute();
                }
                return this.statsSchema;
            }

            public Logger org$apache$spark$internal$Logging$$log_() {
                return this.org$apache$spark$internal$Logging$$log_;
            }

            public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
                this.org$apache$spark$internal$Logging$$log_ = x$1;
            }

            public StructType tableSchema() {
                return this.tableSchema;
            }

            public StructType outputAttributeSchema() {
                return this.outputAttributeSchema;
            }

            public StructType outputTableStatsSchema() {
                return this.outputTableStatsSchema;
            }

            public DeltaStatsColumnSpec statsColumnSpec() {
                return this.statsColumnSpec;
            }

            public DeltaColumnMappingMode columnMappingMode() {
                return this.columnMappingMode;
            }

            public Protocol protocol() {
                return this.protocol;
            }

            public SparkSession spark() {
                throw new Exception("Method not used in statisticsCollectionFromMetadata");
            }
            {
                Logging.$init$((Logging)this);
                DeltaProgressReporter.$init$(this);
                DatabricksLogging.$init$(this);
                DeltaLogging.$init$(this);
                StatisticsCollection.$init$(this);
                this.tableSchema = metadata$2.schema();
                this.outputAttributeSchema = this.tableSchema();
                this.outputTableStatsSchema = this.tableSchema();
                this.statsColumnSpec = StatisticsCollection$.MODULE$.configuredDeltaStatsColumnSpec(metadata$2);
                this.columnMappingMode = metadata$2.columnMappingMode();
                this.protocol = p$1;
            }
        };
    }

    private void validateClusteringColumnsInStatsSchema(StatisticsCollection statsCollection, Seq<ClusteringColumnInfo> clusteringColumnInfos) {
        Seq<String> missingColumn = this.getClusteringColumnsNotInStatsSchema(statsCollection, clusteringColumnInfos);
        if (missingColumn.nonEmpty()) {
            throw DeltaErrors$.MODULE$.clusteringColumnMissingStats(missingColumn.mkString(", "), statsCollection.statCollectionLogicalSchema().treeString());
        }
    }

    public static /* synthetic */ void validateClusteringColumnsInSnapshot$(ClusteredTableUtilsBase $this, Snapshot snapshot, ClusterBySpec clusterBySpec) {
        $this.validateClusteringColumnsInSnapshot(snapshot, clusterBySpec);
    }

    default public void validateClusteringColumnsInSnapshot(Snapshot snapshot, ClusterBySpec clusterBySpec) {
        Some providedClusteringColumns = new Some(clusterBySpec.columnNames().map((Function1 & Serializable & scala.Serializable)col -> ClusteringColumn$.MODULE$.apply(snapshot.schema(), col.toString()), Seq$.MODULE$.canBuildFrom()));
        Option<Seq<ClusteringColumn>> existingClusteringColumns = ClusteredTableUtils$.MODULE$.getClusteringColumnsOptional(snapshot);
        Some some = providedClusteringColumns;
        Option<Seq<ClusteringColumn>> option = existingClusteringColumns;
        if (some == null ? option != null : !some.equals(option)) {
            throw DeltaErrors$.MODULE$.clusteringColumnsMismatchException(((TraversableOnce)clusterBySpec.columnNames().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.toString(), Seq$.MODULE$.canBuildFrom())).mkString(","), (String)existingClusteringColumns.map((Function1 & Serializable & scala.Serializable)x$7 -> ((TraversableOnce)x$7.map((Function1 & Serializable & scala.Serializable)x$8 -> ClusteringColumnInfo$.MODULE$.apply(snapshot.schema(), (ClusteringColumn)x$8).logicalName(), Seq$.MODULE$.canBuildFrom())).mkString(",")).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        }
    }

    private Seq<String> getClusteringColumnsNotInStatsSchema(StatisticsCollection statsCollection, Seq<ClusteringColumnInfo> clusteringColumnInfos) {
        return (Seq)clusteringColumnInfos.flatMap((Function1 & Serializable & scala.Serializable)info -> {
            Some some;
            StructField structField;
            String string = DeltaStatistics$.MODULE$.MIN();
            Seq path = (Seq)info.physicalName().$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom());
            Option<StructField> option = SchemaUtils$.MODULE$.findNestedFieldIgnoreCase(statsCollection.statsSchema(), (Seq<String>)path, SchemaUtils$.MODULE$.findNestedFieldIgnoreCase$default$3());
            if (None$.MODULE$.equals(option) ? true : option instanceof Some && (structField = (StructField)(some = (Some)option).value()) != null && structField.dataType() instanceof StructType) {
                return Option$.MODULE$.option2Iterable((Option)new Some((Object)info.logicalName()));
            }
            return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static /* synthetic */ void $anonfun$validatePreviewEnabled$1(ClusterBySpec x$1) {
        if (!BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(DeltaSQLConf$.MODULE$.DELTA_CLUSTERING_TABLE_PREVIEW_ENABLED())) && !Utils$.MODULE$.isTesting()) {
            throw DeltaErrors$.MODULE$.clusteringTablePreviewDisabledException();
        }
    }

    public static /* synthetic */ void $anonfun$validateNumClusteringColumns$1(ClusteredTableUtilsBase $this, Seq clusteringColumns$1, int numColumnsLimit$1, DeltaLog deltaLog) {
        DeltaLog x$1 = deltaLog;
        String x$2 = "delta.clusteredTable.invalidNumClusteringColumns";
        Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numCols"), (Object)BoxesRunTime.boxToInteger((int)clusteringColumns$1.size())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numColsLimit"), (Object)BoxesRunTime.boxToInteger((int)numColumnsLimit$1))}));
        Map<TagDefinition, String> x$4 = $this.recordDeltaEvent$default$3();
        Option<Path> x$5 = $this.recordDeltaEvent$default$5();
        $this.recordDeltaEvent(x$1, x$2, x$4, x$3, x$5);
    }

    public static void $init$(ClusteredTableUtilsBase $this) {
        $this.org$apache$spark$sql$delta$skipping$clustering$ClusteredTableUtilsBase$_setter_$PROP_CLUSTERING_COLUMNS_$eq("clusteringColumns");
    }
}

