/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.ZoneId;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaOperations;
import org.apache.spark.sql.delta.DeltaOptions;
import org.apache.spark.sql.delta.DeltaTimeTravelSpec;
import org.apache.spark.sql.delta.OptimisticTransaction;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.DeletionVectorDescriptor;
import org.apache.spark.sql.delta.actions.DeletionVectorDescriptor$;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.actions.RemoveFile;
import org.apache.spark.sql.delta.actions.SetTransaction;
import org.apache.spark.sql.delta.catalog.DeltaTableV2;
import org.apache.spark.sql.delta.commands.DeletionVectorUtils$;
import org.apache.spark.sql.delta.commands.DeltaCommand;
import org.apache.spark.sql.delta.commands.RestoreTableCommand$;
import org.apache.spark.sql.delta.commands.RestoreTableCommandBase;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.DeltaFileOperations$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.execution.command.LeafRunnableCommand;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.SerializableConfiguration;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\tmb\u0001B\u000e\u001d\u0001&B\u0001\u0002\u0014\u0001\u0003\u0016\u0004%\t!\u0014\u0005\t)\u0002\u0011\t\u0012)A\u0005\u001d\")Q\u000b\u0001C\u0001-\"9\u0011\f\u0001b\u0001\n\u0003R\u0006BB7\u0001A\u0003%1\fC\u0003o\u0001\u0011\u0005s\u000eC\u0003z\u0001\u0011%!\u0010C\u0004\u00020\u0001!I!!\r\t\u000f\u0005-\u0003\u0001\"\u0003\u0002N!9\u0011\u0011\u0012\u0001\u0005\n\u0005-\u0005bBAS\u0001\u0011%\u0011q\u0015\u0005\n\u0003S\u0003\u0011\u0011!C\u0001\u0003WC\u0011\"a,\u0001#\u0003%\t!!-\t\u0013\u0005\u001d\u0007!!A\u0005B\u0005%\u0007\"CAk\u0001\u0005\u0005I\u0011AAl\u0011%\ty\u000eAA\u0001\n\u0003\t\t\u000fC\u0005\u0002h\u0002\t\t\u0011\"\u0011\u0002j\"I\u0011q\u001f\u0001\u0002\u0002\u0013\u0005\u0011\u0011 \u0005\n\u0005\u0007\u0001\u0011\u0011!C!\u0005\u000b9\u0011B!\u0003\u001d\u0003\u0003E\tAa\u0003\u0007\u0011ma\u0012\u0011!E\u0001\u0005\u001bAa!V\u000b\u0005\u0002\tm\u0001\"\u0003B\u000f+\u0005\u0005IQ\tB\u0010\u0011%\u0011\t#FA\u0001\n\u0003\u0013\u0019\u0003C\u0005\u0003(U\t\t\u0011\"!\u0003*!I!\u0011G\u000b\u0002\u0002\u0013%!1\u0007\u0002\u0014%\u0016\u001cHo\u001c:f)\u0006\u0014G.Z\"p[6\fg\u000e\u001a\u0006\u0003;y\t\u0001bY8n[\u0006tGm\u001d\u0006\u0003?\u0001\nQ\u0001Z3mi\u0006T!!\t\u0012\u0002\u0007M\fHN\u0003\u0002$I\u0005)1\u000f]1sW*\u0011QEJ\u0001\u0007CB\f7\r[3\u000b\u0003\u001d\n1a\u001c:h\u0007\u0001\u0019r\u0001\u0001\u00165y\u0001\u001b\u0015\n\u0005\u0002,e5\tAF\u0003\u0002.]\u00059An\\4jG\u0006d'BA\u00181\u0003\u0015\u0001H.\u00198t\u0015\t\t\u0004%\u0001\u0005dCR\fG._:u\u0013\t\u0019DFA\u0006M_\u001eL7-\u00197QY\u0006t\u0007CA\u001b;\u001b\u00051$BA\u001c9\u0003\u001d\u0019w.\\7b]\u0012T!!\u000f\u0011\u0002\u0013\u0015DXmY;uS>t\u0017BA\u001e7\u0005MaU-\u00194Sk:t\u0017M\u00197f\u0007>lW.\u00198e!\tid(D\u0001\u001d\u0013\tyDD\u0001\u0007EK2$\u0018mQ8n[\u0006tG\r\u0005\u0002>\u0003&\u0011!\t\b\u0002\u0018%\u0016\u001cHo\u001c:f)\u0006\u0014G.Z\"p[6\fg\u000e\u001a\"bg\u0016\u0004\"\u0001R$\u000e\u0003\u0015S\u0011AR\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0011\u0016\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002E\u0015&\u00111*\u0012\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\fg>,(oY3UC\ndW-F\u0001O!\ty%+D\u0001Q\u0015\t\tf$A\u0004dCR\fGn\\4\n\u0005M\u0003&\u0001\u0004#fYR\fG+\u00192mKZ\u0013\u0014\u0001D:pkJ\u001cW\rV1cY\u0016\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002X1B\u0011Q\b\u0001\u0005\u0006\u0019\u000e\u0001\rAT\u0001\u0007_V$\b/\u001e;\u0016\u0003m\u00032\u0001\u00183h\u001d\ti&M\u0004\u0002_C6\tqL\u0003\u0002aQ\u00051AH]8pizJ\u0011AR\u0005\u0003G\u0016\u000bq\u0001]1dW\u0006<W-\u0003\u0002fM\n\u00191+Z9\u000b\u0005\r,\u0005C\u00015l\u001b\u0005I'B\u000161\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\u00051L'!C!uiJL'-\u001e;f\u0003\u001dyW\u000f\u001e9vi\u0002\n1A];o)\t\u0001X\u000fE\u0002]IF\u0004\"A]:\u000e\u0003\u0001J!\u0001\u001e\u0011\u0003\u0007I{w\u000fC\u0003$\r\u0001\u0007a\u000f\u0005\u0002so&\u0011\u0001\u0010\t\u0002\r'B\f'o[*fgNLwN\\\u0001\u0010o&$\b\u000eR3tGJL\u0007\u000f^5p]V\u00111p \u000b\u0004y\u0006mAcA?\u0002\u0012A\u0011ap \u0007\u0001\t\u001d\t\ta\u0002b\u0001\u0003\u0007\u0011\u0011\u0001V\t\u0005\u0003\u000b\tY\u0001E\u0002E\u0003\u000fI1!!\u0003F\u0005\u001dqu\u000e\u001e5j]\u001e\u00042\u0001RA\u0007\u0013\r\ty!\u0012\u0002\u0004\u0003:L\b\u0002CA\n\u000f\u0011\u0005\r!!\u0006\u0002\u0003\u0019\u0004B\u0001RA\f{&\u0019\u0011\u0011D#\u0003\u0011q\u0012\u0017P\\1nKzBq!!\b\b\u0001\u0004\ty\"\u0001\u0004bGRLwN\u001c\t\u0005\u0003C\tIC\u0004\u0003\u0002$\u0005\u0015\u0002C\u00010F\u0013\r\t9#R\u0001\u0007!J,G-\u001a4\n\t\u0005-\u0012Q\u0006\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u001dR)A\bqCJ\u001cXm\u0015;sS:<Gk\u001c+t)\u0011\t\u0019$!\u0011\u0011\t\u0005U\u0012QH\u0007\u0003\u0003oQ1!IA\u001d\u0015\t\tY$\u0001\u0003kCZ\f\u0017\u0002BA \u0003o\u0011\u0011\u0002V5nKN$\u0018-\u001c9\t\u000f\u0005\r\u0003\u00021\u0001\u0002F\u0005IA/[7fgR\fW\u000e\u001d\t\u0006\t\u0006\u001d\u0013qD\u0005\u0004\u0003\u0013*%AB(qi&|g.\u0001\bd_6\u0004X\u000f^3NKR\u0014\u0018nY:\u0015\u0011\u0005=\u00131LA9\u0003{\u0002\u0002\"!\t\u0002R\u0005}\u0011QK\u0005\u0005\u0003'\niCA\u0002NCB\u00042\u0001RA,\u0013\r\tI&\u0012\u0002\u0005\u0019>tw\rC\u0004\u0002^%\u0001\r!a\u0018\u0002\u000bQ|\u0017\t\u001a3\u0011\u000bI\f\t'!\u001a\n\u0007\u0005\r\u0004EA\u0004ECR\f7/\u001a;\u0011\t\u0005\u001d\u0014QN\u0007\u0003\u0003SR1!a\u001b\u001f\u0003\u001d\t7\r^5p]NLA!a\u001c\u0002j\t9\u0011\t\u001a3GS2,\u0007bBA:\u0013\u0001\u0007\u0011QO\u0001\ti>\u0014V-\\8wKB)!/!\u0019\u0002xA!\u0011qMA=\u0013\u0011\tY(!\u001b\u0003\u0015I+Wn\u001c<f\r&dW\rC\u0004\u0002\u0000%\u0001\r!!!\u0002\u0011Mt\u0017\r]:i_R\u0004B!a!\u0002\u00066\ta$C\u0002\u0002\bz\u0011\u0001b\u00158baNDw\u000e^\u0001\u001fG\",7m[*oCB\u001c\bn\u001c;GS2,7/\u0011<bS2\f'-\u001b7jif$\u0002\"!$\u0002\u0014\u0006u\u0015\u0011\u0015\t\u0004\t\u0006=\u0015bAAI\u000b\n!QK\\5u\u0011\u001d\t)J\u0003a\u0001\u0003/\u000b\u0001\u0002Z3mi\u0006dun\u001a\t\u0005\u0003\u0007\u000bI*C\u0002\u0002\u001cz\u0011\u0001\u0002R3mi\u0006dun\u001a\u0005\b\u0003?S\u0001\u0019AA0\u0003\u00151\u0017\u000e\\3t\u0011\u001d\t\u0019K\u0003a\u0001\u0003+\nqA^3sg&|g.\u0001\u0007hKR$\u0016.\\3ti\u0006l\u0007\u000f\u0006\u0002\u0002F\u0005!1m\u001c9z)\r9\u0016Q\u0016\u0005\b\u00192\u0001\n\u00111\u0001O\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a-+\u00079\u000b)l\u000b\u0002\u00028B!\u0011\u0011XAb\u001b\t\tYL\u0003\u0003\u0002>\u0006}\u0016!C;oG\",7m[3e\u0015\r\t\t-R\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAc\u0003w\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u001a\t\u0005\u0003\u001b\f\u0019.\u0004\u0002\u0002P*!\u0011\u0011[A\u001d\u0003\u0011a\u0017M\\4\n\t\u0005-\u0012qZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u00033\u00042\u0001RAn\u0013\r\ti.\u0012\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u0017\t\u0019\u000fC\u0005\u0002fB\t\t\u00111\u0001\u0002Z\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a;\u0011\r\u00055\u00181_A\u0006\u001b\t\tyOC\u0002\u0002r\u0016\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t)0a<\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003w\u0014\t\u0001E\u0002E\u0003{L1!a@F\u0005\u001d\u0011un\u001c7fC:D\u0011\"!:\u0013\u0003\u0003\u0005\r!a\u0003\u0002\r\u0015\fX/\u00197t)\u0011\tYPa\u0002\t\u0013\u0005\u00158#!AA\u0002\u0005-\u0011a\u0005*fgR|'/\u001a+bE2,7i\\7nC:$\u0007CA\u001f\u0016'\u0011)\"qB%\u0011\r\tE!q\u0003(X\u001b\t\u0011\u0019BC\u0002\u0003\u0016\u0015\u000bqA];oi&lW-\u0003\u0003\u0003\u001a\tM!!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocQ\u0011!1B\u0001\ti>\u001cFO]5oOR\u0011\u00111Z\u0001\u0006CB\u0004H.\u001f\u000b\u0004/\n\u0015\u0002\"\u0002'\u0019\u0001\u0004q\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0005W\u0011i\u0003\u0005\u0003E\u0003\u000fr\u0005\u0002\u0003B\u00183\u0005\u0005\t\u0019A,\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GC\u0001B\u001b!\u0011\tiMa\u000e\n\t\te\u0012q\u001a\u0002\u0007\u001f\nTWm\u0019;")
public class RestoreTableCommand
extends LogicalPlan
implements LeafRunnableCommand,
DeltaCommand,
RestoreTableCommandBase,
scala.Serializable {
    private final DeltaTableV2 sourceTable;
    private final Seq<Attribute> output;
    private final String TABLE_SIZE_AFTER_RESTORE;
    private final String NUM_OF_FILES_AFTER_RESTORE;
    private final String NUM_REMOVED_FILES;
    private final String NUM_RESTORED_FILES;
    private final String REMOVED_FILES_SIZE;
    private final String RESTORED_FILES_SIZE;
    private final String org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_TABLE_SIZE_AFTER_RESTORE;
    private final String org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_NUM_OF_FILES_AFTER_RESTORE;
    private final String org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_NUM_REMOVED_FILES;
    private final String org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_NUM_RESTORED_FILES;
    private final String org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_REMOVED_FILES_SIZE;
    private final String org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_RESTORED_FILES_SIZE;
    private final Seq<Attribute> outputSchema;
    private Map<String, SQLMetric> metrics;
    private final Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<DeltaTableV2> unapply(RestoreTableCommand restoreTableCommand) {
        return RestoreTableCommand$.MODULE$.unapply(restoreTableCommand);
    }

    public static <A> Function1<DeltaTableV2, A> andThen(Function1<RestoreTableCommand, A> function1) {
        return RestoreTableCommand$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, RestoreTableCommand> compose(Function1<A, DeltaTableV2> function1) {
        return RestoreTableCommand$.MODULE$.compose(function1);
    }

    @Override
    public Seq<Expression> parsePredicates(SparkSession spark, String predicate) {
        return DeltaCommand.parsePredicates$(this, spark, predicate);
    }

    @Override
    public void verifyPartitionPredicates(SparkSession spark, Seq<String> partitionColumns, Seq<Expression> predicates) {
        DeltaCommand.verifyPartitionPredicates$(this, spark, partitionColumns, predicates);
    }

    @Override
    public Map<String, AddFile> generateCandidateFileMap(Path basePath, Seq<AddFile> candidateFiles) {
        return DeltaCommand.generateCandidateFileMap$(this, basePath, candidateFiles);
    }

    @Override
    public Seq<RemoveFile> removeFilesFromPaths(DeltaLog deltaLog, Map<String, AddFile> nameToAddFileMap, Seq<String> filesToRewrite, long operationTimestamp) {
        return DeltaCommand.removeFilesFromPaths$(this, deltaLog, nameToAddFileMap, filesToRewrite, operationTimestamp);
    }

    @Override
    public HadoopFsRelation buildBaseRelation(SparkSession spark, OptimisticTransaction txn, String actionType, Path rootPath, Seq<String> inputLeafFiles, Map<String, AddFile> nameToAddFileMap) {
        return DeltaCommand.buildBaseRelation$(this, spark, txn, actionType, rootPath, inputLeafFiles, nameToAddFileMap);
    }

    @Override
    public AddFile getTouchedFile(Path basePath, String escapedFilePath, Map<String, AddFile> nameToAddFileMap) {
        return DeltaCommand.getTouchedFile$(this, basePath, escapedFilePath, nameToAddFileMap);
    }

    @Override
    public LogicalPlan resolveIdentifier(Analyzer analyzer, TableIdentifier identifier) {
        return DeltaCommand.resolveIdentifier$(this, analyzer, identifier);
    }

    @Override
    public boolean isCatalogTable(Analyzer analyzer, TableIdentifier tableIdent) {
        return DeltaCommand.isCatalogTable$(this, analyzer, tableIdent);
    }

    @Override
    public boolean isPathIdentifier(TableIdentifier tableIdent) {
        return DeltaCommand.isPathIdentifier$(this, tableIdent);
    }

    @Override
    public DeltaLog getDeltaLog(SparkSession spark, Option<String> path, Option<TableIdentifier> tableIdentifier, String operationName, Map<String, String> hadoopConf) {
        return DeltaCommand.getDeltaLog$(this, spark, path, tableIdentifier, operationName, hadoopConf);
    }

    @Override
    public Map<String, String> getDeltaLog$default$5() {
        return DeltaCommand.getDeltaLog$default$5$(this);
    }

    @Override
    public void sendDriverMetrics(SparkSession spark, Map<String, SQLMetric> metrics) {
        DeltaCommand.sendDriverMetrics$(this, spark, metrics);
    }

    @Override
    public DeltaTableV2 getDeltaTable(LogicalPlan target, String cmd) {
        return DeltaCommand.getDeltaTable$(this, target, cmd);
    }

    @Override
    public Option<CatalogTable> getTableCatalogTable(LogicalPlan target, String cmd) {
        return DeltaCommand.getTableCatalogTable$(this, target, cmd);
    }

    @Override
    public Tuple2<Option<TableIdentifier>, Option<String>> getDeltaTablePathOrIdentifier(LogicalPlan target, String cmd) {
        return DeltaCommand.getDeltaTablePathOrIdentifier$(this, target, cmd);
    }

    @Override
    public Tuple2<Option<TableIdentifier>, Option<String>> getTablePathOrIdentifier(LogicalPlan target, String cmd) {
        return DeltaCommand.getTablePathOrIdentifier$(this, target, cmd);
    }

    @Override
    public boolean hasBeenExecuted(OptimisticTransaction txn, SparkSession sparkSession, Option<DeltaOptions> options) {
        return DeltaCommand.hasBeenExecuted$(this, txn, sparkSession, options);
    }

    @Override
    public Option<DeltaOptions> hasBeenExecuted$default$3() {
        return DeltaCommand.hasBeenExecuted$default$3$(this);
    }

    @Override
    public Option<SetTransaction> createSetTransaction(SparkSession sparkSession, DeltaLog deltaLog, Option<DeltaOptions> options) {
        return DeltaCommand.createSetTransaction$(this, sparkSession, deltaLog, options);
    }

    @Override
    public Option<DeltaOptions> createSetTransaction$default$3() {
        return DeltaCommand.createSetTransaction$default$3$(this);
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void deltaAssert(Function0<Object> check, String name, String msg, DeltaLog deltaLog, Object data, Option<Path> path) {
        DeltaLogging.deltaAssert$(this, check, name, msg, deltaLog, data, path);
    }

    @Override
    public DeltaLog deltaAssert$default$4() {
        return DeltaLogging.deltaAssert$default$4$(this);
    }

    @Override
    public Object deltaAssert$default$5() {
        return DeltaLogging.deltaAssert$default$5$(this);
    }

    @Override
    public Option<Path> deltaAssert$default$6() {
        return DeltaLogging.deltaAssert$default$6$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public Map<String, Object> getErrorData(Throwable e) {
        return DeltaLogging.getErrorData$(this, e);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public final Seq<LogicalPlan> children() {
        return LeafLike.children$((LeafLike)this);
    }

    public final TreeNode mapChildren(Function1 f) {
        return LeafLike.mapChildren$((LeafLike)this, (Function1)f);
    }

    public TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return LeafLike.withNewChildrenInternal$((LeafLike)this, (IndexedSeq)newChildren);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    @Override
    public String TABLE_SIZE_AFTER_RESTORE() {
        return this.TABLE_SIZE_AFTER_RESTORE;
    }

    @Override
    public String NUM_OF_FILES_AFTER_RESTORE() {
        return this.NUM_OF_FILES_AFTER_RESTORE;
    }

    @Override
    public String NUM_REMOVED_FILES() {
        return this.NUM_REMOVED_FILES;
    }

    @Override
    public String NUM_RESTORED_FILES() {
        return this.NUM_RESTORED_FILES;
    }

    @Override
    public String REMOVED_FILES_SIZE() {
        return this.REMOVED_FILES_SIZE;
    }

    @Override
    public String RESTORED_FILES_SIZE() {
        return this.RESTORED_FILES_SIZE;
    }

    @Override
    public String org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_TABLE_SIZE_AFTER_RESTORE() {
        return this.org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_TABLE_SIZE_AFTER_RESTORE;
    }

    @Override
    public String org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_NUM_OF_FILES_AFTER_RESTORE() {
        return this.org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_NUM_OF_FILES_AFTER_RESTORE;
    }

    @Override
    public String org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_NUM_REMOVED_FILES() {
        return this.org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_NUM_REMOVED_FILES;
    }

    @Override
    public String org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_NUM_RESTORED_FILES() {
        return this.org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_NUM_RESTORED_FILES;
    }

    @Override
    public String org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_REMOVED_FILES_SIZE() {
        return this.org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_REMOVED_FILES_SIZE;
    }

    @Override
    public String org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_RESTORED_FILES_SIZE() {
        return this.org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_RESTORED_FILES_SIZE;
    }

    @Override
    public Seq<Attribute> outputSchema() {
        return this.outputSchema;
    }

    @Override
    public void org$apache$spark$sql$delta$commands$RestoreTableCommandBase$_setter_$TABLE_SIZE_AFTER_RESTORE_$eq(String x$1) {
        this.TABLE_SIZE_AFTER_RESTORE = x$1;
    }

    @Override
    public void org$apache$spark$sql$delta$commands$RestoreTableCommandBase$_setter_$NUM_OF_FILES_AFTER_RESTORE_$eq(String x$1) {
        this.NUM_OF_FILES_AFTER_RESTORE = x$1;
    }

    @Override
    public void org$apache$spark$sql$delta$commands$RestoreTableCommandBase$_setter_$NUM_REMOVED_FILES_$eq(String x$1) {
        this.NUM_REMOVED_FILES = x$1;
    }

    @Override
    public void org$apache$spark$sql$delta$commands$RestoreTableCommandBase$_setter_$NUM_RESTORED_FILES_$eq(String x$1) {
        this.NUM_RESTORED_FILES = x$1;
    }

    @Override
    public void org$apache$spark$sql$delta$commands$RestoreTableCommandBase$_setter_$REMOVED_FILES_SIZE_$eq(String x$1) {
        this.REMOVED_FILES_SIZE = x$1;
    }

    @Override
    public void org$apache$spark$sql$delta$commands$RestoreTableCommandBase$_setter_$RESTORED_FILES_SIZE_$eq(String x$1) {
        this.RESTORED_FILES_SIZE = x$1;
    }

    @Override
    public final void org$apache$spark$sql$delta$commands$RestoreTableCommandBase$_setter_$org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_TABLE_SIZE_AFTER_RESTORE_$eq(String x$1) {
        this.org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_TABLE_SIZE_AFTER_RESTORE = x$1;
    }

    @Override
    public final void org$apache$spark$sql$delta$commands$RestoreTableCommandBase$_setter_$org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_NUM_OF_FILES_AFTER_RESTORE_$eq(String x$1) {
        this.org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_NUM_OF_FILES_AFTER_RESTORE = x$1;
    }

    @Override
    public final void org$apache$spark$sql$delta$commands$RestoreTableCommandBase$_setter_$org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_NUM_REMOVED_FILES_$eq(String x$1) {
        this.org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_NUM_REMOVED_FILES = x$1;
    }

    @Override
    public final void org$apache$spark$sql$delta$commands$RestoreTableCommandBase$_setter_$org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_NUM_RESTORED_FILES_$eq(String x$1) {
        this.org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_NUM_RESTORED_FILES = x$1;
    }

    @Override
    public final void org$apache$spark$sql$delta$commands$RestoreTableCommandBase$_setter_$org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_REMOVED_FILES_SIZE_$eq(String x$1) {
        this.org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_REMOVED_FILES_SIZE = x$1;
    }

    @Override
    public final void org$apache$spark$sql$delta$commands$RestoreTableCommandBase$_setter_$org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_RESTORED_FILES_SIZE_$eq(String x$1) {
        this.org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_RESTORED_FILES_SIZE = x$1;
    }

    @Override
    public void org$apache$spark$sql$delta$commands$RestoreTableCommandBase$_setter_$outputSchema_$eq(Seq<Attribute> x$1) {
        this.outputSchema = x$1;
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        RestoreTableCommand restoreTableCommand = this;
        synchronized (restoreTableCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$((RunnableCommand)this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    public Map<String, SQLMetric> metrics() {
        if (!this.bitmap$0) {
            return this.metrics$lzycompute();
        }
        return this.metrics;
    }

    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public DeltaTableV2 sourceTable() {
        return this.sourceTable;
    }

    public Seq<Attribute> output() {
        return this.output;
    }

    public Seq<Row> run(SparkSession spark) {
        DeltaLog deltaLog = this.sourceTable().deltaLog();
        Option<Object> version = ((DeltaTimeTravelSpec)this.sourceTable().timeTravelOpt().get()).version();
        Option<String> timestamp = this.getTimestamp();
        return (Seq)this.recordDeltaOperation(deltaLog, "delta.restore", this.recordDeltaOperation$default$3(), (Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(version.isEmpty() ^ timestamp.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Either the version or timestamp should be provided for restore");
            long versionToRestore = BoxesRunTime.unboxToLong((Object)version.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> deltaLog.history().getActiveCommitAtTime(this.parseStringToTs(timestamp), true, deltaLog.history().getActiveCommitAtTime$default$3(), deltaLog.history().getActiveCommitAtTime$default$4()).version()));
            long latestVersion = deltaLog.update(deltaLog.update$default$1(), deltaLog.update$default$2()).version();
            Predef$.MODULE$.require(versionToRestore < latestVersion, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Version to restore (").append(versionToRestore).append(")").append("should be less then last available version (").append(latestVersion).append(")").toString());
            return (Seq)deltaLog.withNewTransaction(this.sourceTable().catalogTable(), deltaLog.withNewTransaction$default$2(), (Function1 & Serializable & scala.Serializable)txn -> {
                Snapshot latestSnapshot = txn.snapshot();
                Snapshot snapshotToRestore = deltaLog.getSnapshotAt(versionToRestore, deltaLog.getSnapshotAt$default$2());
                Dataset<AddFile> latestSnapshotFiles = latestSnapshot.allFiles();
                Dataset<AddFile> snapshotToRestoreFiles = snapshotToRestore.allFiles();
                boolean targetMayHaveDVs = DeletionVectorUtils$.MODULE$.deletionVectorsReadable(latestSnapshot, DeletionVectorUtils$.MODULE$.deletionVectorsReadable$default$2(), DeletionVectorUtils$.MODULE$.deletionVectorsReadable$default$3());
                boolean sourceMayHaveDVs = DeletionVectorUtils$.MODULE$.deletionVectorsReadable(snapshotToRestore, DeletionVectorUtils$.MODULE$.deletionVectorsReadable$default$2(), DeletionVectorUtils$.MODULE$.deletionVectorsReadable$default$3());
                Dataset normalizedSourceWithoutDVs = snapshotToRestoreFiles.mapPartitions((Function1 & Serializable & scala.Serializable)files -> files.map((Function1 & Serializable & scala.Serializable)file -> new Tuple2(file, (Object)file.path())), org.apache.spark.sql.delta.implicits.package$.MODULE$.addFileWithSourcePathEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"srcAddFile", "srcPath"}));
                Dataset normalizedTargetWithoutDVs = latestSnapshotFiles.mapPartitions((Function1 & Serializable & scala.Serializable)files -> files.map((Function1 & Serializable & scala.Serializable)file -> new Tuple2(file, (Object)file.path())), org.apache.spark.sql.delta.implicits.package$.MODULE$.addFileWithSourcePathEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tgtAddFile", "tgtPath"}));
                Dataset normalizedSource = RestoreTableCommand.addDVsToNormalizedDF$1(sourceMayHaveDVs, "srcDeletionVectorId", functions$.MODULE$.column("srcAddFile.deletionVector"), normalizedSourceWithoutDVs);
                Dataset normalizedTarget = RestoreTableCommand.addDVsToNormalizedDF$1(targetMayHaveDVs, "tgtDeletionVectorId", functions$.MODULE$.column("tgtAddFile.deletionVector"), normalizedTargetWithoutDVs);
                Column joinExprs = functions$.MODULE$.column("srcPath").$eq$eq$eq((Object)functions$.MODULE$.column("tgtPath")).and(functions$.MODULE$.column("srcDeletionVectorId").$less$eq$greater((Object)functions$.MODULE$.column("tgtDeletionVectorId")));
                Dataset filesToAdd = normalizedSource.join(normalizedTarget, joinExprs, "left_anti").select(functions$.MODULE$.column("srcAddFile").as(org.apache.spark.sql.delta.implicits.package$.MODULE$.addFileEncoder())).map((Function1 & Serializable & scala.Serializable)x$1 -> {
                    boolean x$12 = true;
                    String x$2 = x$1.copy$default$1();
                    Map<String, String> x$3 = x$1.copy$default$2();
                    long x$4 = x$1.copy$default$3();
                    long x$5 = x$1.copy$default$4();
                    String x$6 = x$1.copy$default$6();
                    Map<String, String> x$7 = x$1.copy$default$7();
                    DeletionVectorDescriptor x$8 = x$1.copy$default$8();
                    Option<Object> x$9 = x$1.copy$default$9();
                    Option<Object> x$10 = x$1.copy$default$10();
                    Option<String> x$11 = x$1.copy$default$11();
                    return x$1.copy(x$2, x$3, x$4, x$5, x$12, x$6, x$7, x$8, x$9, x$10, x$11);
                }, org.apache.spark.sql.delta.implicits.package$.MODULE$.addFileEncoder());
                Dataset filesToRemove = normalizedTarget.join(normalizedSource, joinExprs, "left_anti").select(functions$.MODULE$.column("tgtAddFile").as(org.apache.spark.sql.delta.implicits.package$.MODULE$.addFileEncoder())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.removeWithTimestamp(x$2.removeWithTimestamp$default$1(), x$2.removeWithTimestamp$default$2()), org.apache.spark.sql.delta.implicits.package$.MODULE$.removeFileEncoder());
                boolean ignoreMissingFiles = BoxesRunTime.unboxToBoolean((Object)spark.sessionState().conf().getConf(SQLConf$.MODULE$.IGNORE_MISSING_FILES()));
                if (!ignoreMissingFiles) {
                    this.checkSnapshotFilesAvailability(deltaLog, (Dataset<AddFile>)filesToAdd, versionToRestore);
                }
                Map metrics = (Map)this.withDescription("metrics", (Function0 & Serializable & scala.Serializable)() -> this.computeMetrics((Dataset<AddFile>)filesToAdd, (Dataset<RemoveFile>)filesToRemove, snapshotToRestore));
                Iterator addActions = (Iterator)this.withDescription("add actions", (Function0 & Serializable & scala.Serializable)() -> (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(filesToAdd.toLocalIterator()).asScala());
                Iterator removeActions = (Iterator)this.withDescription("remove actions", (Function0 & Serializable & scala.Serializable)() -> (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(filesToRemove.toLocalIterator()).asScala());
                txn.updateMetadata(snapshotToRestore.metadata(), txn.updateMetadata$default$2());
                Protocol sourceProtocol = snapshotToRestore.protocol();
                Protocol targetProtocol = latestSnapshot.protocol();
                boolean protocolDowngradeAllowed = BoxesRunTime.unboxToBoolean((Object)this.conf().getConf(DeltaSQLConf$.MODULE$.RESTORE_TABLE_PROTOCOL_DOWNGRADE_ALLOWED()));
                Protocol newProtocol = protocolDowngradeAllowed ? sourceProtocol : sourceProtocol.merge((Seq<Protocol>)Predef$.MODULE$.wrapRefArray((Object[])new Protocol[]{targetProtocol}));
                txn.commitLarge(spark, (Iterator<Action>)addActions.$plus$plus((Function0 & Serializable & scala.Serializable)() -> removeActions), (Option<Protocol>)new Some((Object)newProtocol), new DeltaOperations.Restore(version, timestamp), (Map<String, String>)Predef$.MODULE$.Map().empty(), (Map<String, String>)metrics.mapValues((Function1 & Serializable & scala.Serializable)x$3 -> RestoreTableCommand.$anonfun$run$16(BoxesRunTime.unboxToLong((Object)x$3))).toMap(Predef$.MODULE$.$conforms()));
                return (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metrics.get((Object)this.TABLE_SIZE_AFTER_RESTORE()), metrics.get((Object)this.NUM_OF_FILES_AFTER_RESTORE()), metrics.get((Object)this.NUM_REMOVED_FILES()), metrics.get((Object)this.NUM_RESTORED_FILES()), metrics.get((Object)this.REMOVED_FILES_SIZE()), metrics.get((Object)this.RESTORED_FILES_SIZE())})), (List)Nil$.MODULE$);
            });
        });
    }

    private <T> T withDescription(String action, Function0<T> f) {
        return this.withStatusCode("DELTA", new StringBuilder(44).append("RestoreTableCommand: compute ").append(action).append("  (table path ").append(this.sourceTable().deltaLog().dataPath()).append(")").toString(), this.withStatusCode$default$3(), f);
    }

    private Timestamp parseStringToTs(Option<String> timestamp) {
        Success success;
        Option option;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> timestamp.flatMap((Function1 & Serializable & scala.Serializable)tsStr -> {
            ZoneId tz = DateTimeUtils$.MODULE$.getZoneId(SQLConf$.MODULE$.get().sessionLocalTimeZone());
            UTF8String utfStr = UTF8String.fromString((String)tsStr);
            return DateTimeUtils$.MODULE$.stringToTimestamp(utfStr, tz);
        }));
        if (try_ instanceof Success && (option = (Option)(success = (Success)try_).value()) instanceof Some) {
            Some some = (Some)option;
            long tsMicroseconds = BoxesRunTime.unboxToLong((Object)some.value());
            return new Timestamp(tsMicroseconds / 1000L);
        }
        throw DeltaErrors$.MODULE$.timestampInvalid((Expression)Literal$.MODULE$.apply(timestamp.get()));
    }

    private Map<String, Object> computeMetrics(Dataset<AddFile> toAdd, Dataset<RemoveFile> toRemove, Snapshot snapshot) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(RestoreTableCommand.class.getClassLoader());
        public final class Org_apache_spark_sql_delta_commands_RestoreTableCommand$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_delta_commands_RestoreTableCommand$$typecreator5$1(RestoreTableCommand $outer) {
            }
        }
        Tuple2 tuple2 = (Tuple2)toAdd.agg(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"size"), (Object)"count"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"size"), (Object)"sum")})).as(toAdd.sparkSession().implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_delta_commands_RestoreTableCommand$$typecreator5$1(null)))).head();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long numRestoredFiles = tuple2._1$mcJ$sp();
        Option restoredFilesSize = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)numRestoredFiles), (Object)restoredFilesSize);
        long numRestoredFiles2 = tuple22._1$mcJ$sp();
        Option restoredFilesSize2 = (Option)tuple22._2();
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(RestoreTableCommand.class.getClassLoader());
        public final class Org_apache_spark_sql_delta_commands_RestoreTableCommand$$typecreator6$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_delta_commands_RestoreTableCommand$$typecreator6$1(RestoreTableCommand $outer) {
            }
        }
        Tuple2 tuple23 = (Tuple2)toRemove.agg(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"size"), (Object)"count"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"size"), (Object)"sum")})).as(toAdd.sparkSession().implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_delta_commands_RestoreTableCommand$$typecreator6$1(null)))).head();
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        long numRemovedFiles = tuple23._1$mcJ$sp();
        Option removedFilesSize = (Option)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)BoxesRunTime.boxToLong((long)numRemovedFiles), (Object)removedFilesSize);
        long numRemovedFiles2 = tuple24._1$mcJ$sp();
        Option removedFilesSize2 = (Option)tuple24._2();
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.NUM_RESTORED_FILES()), (Object)BoxesRunTime.boxToLong((long)numRestoredFiles2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RESTORED_FILES_SIZE()), restoredFilesSize2.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.NUM_REMOVED_FILES()), (Object)BoxesRunTime.boxToLong((long)numRemovedFiles2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.REMOVED_FILES_SIZE()), removedFilesSize2.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.NUM_OF_FILES_AFTER_RESTORE()), (Object)BoxesRunTime.boxToLong((long)snapshot.numOfFiles())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.TABLE_SIZE_AFTER_RESTORE()), (Object)BoxesRunTime.boxToLong((long)snapshot.sizeInBytes()))}));
    }

    private void checkSnapshotFilesAvailability(DeltaLog deltaLog, Dataset<AddFile> files, long version) {
        this.withDescription("missing files validation", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Broadcast hadoopConf;
            SparkSession spark = files.sparkSession();
            String pathString = deltaLog.dataPath().toString();
            String[] missedFiles = (String[])files.mapPartitions(arg_0 -> RestoreTableCommand.$anonfun$checkSnapshotFilesAvailability$2(pathString, hadoopConf = spark.sparkContext().broadcast((Object)new SerializableConfiguration(deltaLog.newDeltaHadoopConf()), ClassTag$.MODULE$.apply(SerializableConfiguration.class)), arg_0), org.apache.spark.sql.delta.implicits.package$.MODULE$.addFileEncoder()).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.path(), org.apache.spark.sql.delta.implicits.package$.MODULE$.stringEncoder()).head(100);
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])missedFiles)).nonEmpty()) {
                throw DeltaErrors$.MODULE$.restoreMissedDataFilesError(missedFiles, version);
            }
        });
    }

    private Option<String> getTimestamp() {
        if (((DeltaTimeTravelSpec)this.sourceTable().timeTravelOpt().get()).timestamp().isDefined()) {
            return new Some((Object)((DeltaTimeTravelSpec)this.sourceTable().timeTravelOpt().get()).getTimestamp(this.conf()).toString());
        }
        return None$.MODULE$;
    }

    public RestoreTableCommand copy(DeltaTableV2 sourceTable) {
        return new RestoreTableCommand(sourceTable);
    }

    public DeltaTableV2 copy$default$1() {
        return this.sourceTable();
    }

    public String productPrefix() {
        return "RestoreTableCommand";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.sourceTable();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RestoreTableCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RestoreTableCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        RestoreTableCommand restoreTableCommand = (RestoreTableCommand)x$1;
        DeltaTableV2 deltaTableV2 = this.sourceTable();
        DeltaTableV2 deltaTableV22 = restoreTableCommand.sourceTable();
        if (deltaTableV2 == null) {
            if (deltaTableV22 != null) {
                return false;
            }
        } else if (!((Object)deltaTableV2).equals(deltaTableV22)) return false;
        if (!restoreTableCommand.canEqual(this)) return false;
        return true;
    }

    private static final Dataset addDVsToNormalizedDF$1(boolean mayHaveDVs, String dvIdColumnName, Column dvAccessColumn, Dataset normalizedDf) {
        if (mayHaveDVs) {
            return normalizedDf.withColumn(dvIdColumnName, DeletionVectorDescriptor$.MODULE$.uniqueIdExpression(dvAccessColumn));
        }
        return normalizedDf.withColumn(dvIdColumnName, functions$.MODULE$.lit(null));
    }

    public static final /* synthetic */ String $anonfun$run$16(long x$3) {
        return Long.toString(x$3);
    }

    public static final /* synthetic */ Iterator $anonfun$checkSnapshotFilesAvailability$2(String pathString$1, Broadcast hadoopConf$1, Iterator files) {
        Path path = new Path(pathString$1);
        FileSystem fs = path.getFileSystem(((SerializableConfiguration)hadoopConf$1.value()).value());
        return files.filterNot((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)fs.exists(DeltaFileOperations$.MODULE$.absolutePath(pathString$1, f.path()))));
    }

    public RestoreTableCommand(DeltaTableV2 sourceTable) {
        this.sourceTable = sourceTable;
        Command.$init$((Command)this);
        RunnableCommand.$init$((RunnableCommand)this);
        LeafLike.$init$((LeafLike)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
        DeltaCommand.$init$(this);
        RestoreTableCommandBase.$init$(this);
        this.output = this.outputSchema();
    }
}

