/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.LoggingShims;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Column$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.delta.ColumnWithDefaultExprUtils$;
import org.apache.spark.sql.delta.DeltaColumnMapping$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaIdentityColumnStatsTracker;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.GenerateIdentityValues$;
import org.apache.spark.sql.delta.IdentityColumn;
import org.apache.spark.sql.delta.IdentityColumnHighWaterMarkUpdateInfo$;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.sources.DeltaSourceUtils$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class IdentityColumn$
implements DeltaLogging {
    public static IdentityColumn$ MODULE$;
    private final int defaultStart;
    private final int defaultStep;
    private final String opTypeDefinition;
    private final String opTypeWrite;
    private final String opTypeAbort;
    private final String opTypeHighWaterMarkUpdate;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new IdentityColumn$();
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void deltaAssert(Function0<Object> check, String name, String msg, DeltaLog deltaLog, Object data, Option<Path> path) {
        DeltaLogging.deltaAssert$(this, check, name, msg, deltaLog, data, path);
    }

    @Override
    public DeltaLog deltaAssert$default$4() {
        return DeltaLogging.deltaAssert$default$4$(this);
    }

    @Override
    public Object deltaAssert$default$5() {
        return DeltaLogging.deltaAssert$default$5$(this);
    }

    @Override
    public Option<Path> deltaAssert$default$6() {
        return DeltaLogging.deltaAssert$default$6$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public Map<String, Object> getErrorData(Throwable e) {
        return DeltaLogging.getErrorData$(this, e);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    @Override
    public LoggingShims.LogStringContext LogStringContext(StringContext sc) {
        return LoggingShims.LogStringContext$(this, sc);
    }

    @Override
    public void logInfo(LogEntry entry) {
        LoggingShims.logInfo$(this, entry);
    }

    @Override
    public void logInfo(LogEntry entry, Throwable throwable) {
        LoggingShims.logInfo$(this, entry, throwable);
    }

    @Override
    public void logDebug(LogEntry entry) {
        LoggingShims.logDebug$(this, entry);
    }

    @Override
    public void logDebug(LogEntry entry, Throwable throwable) {
        LoggingShims.logDebug$(this, entry, throwable);
    }

    @Override
    public void logTrace(LogEntry entry) {
        LoggingShims.logTrace$(this, entry);
    }

    @Override
    public void logTrace(LogEntry entry, Throwable throwable) {
        LoggingShims.logTrace$(this, entry, throwable);
    }

    @Override
    public void logWarning(LogEntry entry) {
        LoggingShims.logWarning$(this, entry);
    }

    @Override
    public void logWarning(LogEntry entry, Throwable throwable) {
        LoggingShims.logWarning$(this, entry, throwable);
    }

    @Override
    public void logError(LogEntry entry) {
        LoggingShims.logError$(this, entry);
    }

    @Override
    public void logError(LogEntry entry, Throwable throwable) {
        LoggingShims.logError$(this, entry, throwable);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int defaultStart() {
        return this.defaultStart;
    }

    public int defaultStep() {
        return this.defaultStep;
    }

    public String opTypeDefinition() {
        return this.opTypeDefinition;
    }

    public String opTypeWrite() {
        return this.opTypeWrite;
    }

    public String opTypeAbort() {
        return this.opTypeAbort;
    }

    public String opTypeHighWaterMarkUpdate() {
        return this.opTypeHighWaterMarkUpdate;
    }

    public boolean allowExplicitInsert(StructField field) {
        return field.metadata().getBoolean(DeltaSourceUtils$.MODULE$.IDENTITY_INFO_ALLOW_EXPLICIT_INSERT());
    }

    public Seq<StructField> getIdentityColumns(StructType schema) {
        return (Seq)schema.filter((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)ColumnWithDefaultExprUtils$.MODULE$.isIdentityColumn(field)));
    }

    private int getNumberOfIdentityColumns(StructType schema) {
        return this.getIdentityColumns(schema).size();
    }

    public Expression createIdentityColumnGenerationExpr(StructField field) {
        IdentityColumn.IdentityInfo info = this.getIdentityInfo(field);
        return GenerateIdentityValues$.MODULE$.apply(info.start(), info.step(), info.highWaterMark());
    }

    public Column createIdentityColumnGenerationExprAsColumn(StructField field) {
        return Column$.MODULE$.apply(this.createIdentityColumnGenerationExpr(field)).alias(field.name());
    }

    public Option<DeltaIdentityColumnStatsTracker> createIdentityColumnStatsTracker(SparkSession spark, Configuration hadoopConf, Path path, StructType schema, Seq<Attribute> statsDataSchema, Set<String> trackHighWaterMarks) {
        if (trackHighWaterMarks.isEmpty()) {
            return None$.MODULE$;
        }
        Seq identityColumnInfo = (Seq)((TraversableLike)schema.filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)trackHighWaterMarks.contains((Object)f.name())))).map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DeltaColumnMapping$.MODULE$.getPhysicalName((StructField)f)), (Object)BoxesRunTime.boxToBoolean((f.metadata().getLong(DeltaSourceUtils$.MODULE$.IDENTITY_INFO_STEP()) > 0L ? 1 : 0) != 0)), Seq$.MODULE$.canBuildFrom());
        Predef$.MODULE$.assert(identityColumnInfo.size() == trackHighWaterMarks.size(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("expect: ").append(trackHighWaterMarks).append(", found (physical names): ").append(identityColumnInfo.map((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1._1(), Seq$.MODULE$.canBuildFrom())).toString());
        Seq aggregates = (Seq)identityColumnInfo.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                boolean positiveStep = tuple2._2$mcZ$sp();
                Column col = Column$.MODULE$.apply((Expression)UnresolvedAttribute$.MODULE$.quoted(name));
                if (positiveStep) {
                    return functions$.MODULE$.max(col);
                }
                return functions$.MODULE$.min(col);
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
        Column unresolvedExpr = functions$.MODULE$.to_json(functions$.MODULE$.array(aggregates));
        Expression resolvedExpr = (Expression)Dataset$.MODULE$.ofRows(spark, (LogicalPlan)new LocalRelation(statsDataSchema, LocalRelation$.MODULE$.apply$default$2(), LocalRelation$.MODULE$.apply$default$3())).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{unresolvedExpr})).queryExecution().analyzed().expressions().head();
        return new Some((Object)new DeltaIdentityColumnStatsTracker(hadoopConf, path, statsDataSchema, resolvedExpr, (Seq<Tuple2<String, Object>>)identityColumnInfo));
    }

    public long roundToNext(long start, long step, long value) {
        long valueOffset = Math.subtractExact(value, start);
        if (valueOffset % step == 0L) {
            return value;
        }
        long quotient = valueOffset / step;
        long stepMultiple = Math.signum(valueOffset) == Math.signum(step) ? Math.addExact(quotient, 1L) : quotient;
        return Math.addExact(start, Math.multiplyExact(step, stepMultiple));
    }

    /*
     * Unable to fully structure code
     */
    public Tuple2<StructField, Seq<String>> updateToValidHighWaterMark(StructField field, long candidateHighWaterMark, boolean allowLoweringHighWaterMarkForSyncIdentity) {
        Predef$.MODULE$.require(ColumnWithDefaultExprUtils$.MODULE$.isIdentityColumn(field));
        info = this.getIdentityInfo(field);
        positiveStep = info.step() > 0L;
        orderInStepDirection = positiveStep != false ? Ordering.Long$.MODULE$ : Ordering.Long$.MODULE$.reverse();
        loggingBuffer = new ArrayBuffer();
        isBeforeStart = orderInStepDirection.lt((Object)BoxesRunTime.boxToLong((long)candidateHighWaterMark), (Object)BoxesRunTime.boxToLong((long)info.start()));
        if (isBeforeStart) {
            loggingBuffer.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{IdentityColumnHighWaterMarkUpdateInfo$.MODULE$.CANDIDATE_HIGH_WATER_MARK_BEFORE_START()}));
        }
        if ((roundedCandidateHighWaterMark = this.roundToNext(info.start(), info.step(), candidateHighWaterMark)) != candidateHighWaterMark) {
            loggingBuffer.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{IdentityColumnHighWaterMarkUpdateInfo$.MODULE$.CANDIDATE_HIGH_WATER_MARK_ROUNDED()}));
        }
        if (!((var16_10 = info.highWaterMark()) instanceof Some)) ** GOTO lbl-1000
        var17_11 = (Some)var16_10;
        oldWaterMark = BoxesRunTime.unboxToLong((Object)var17_11.value());
        if (!allowLoweringHighWaterMarkForSyncIdentity) {
            v0 = BoxesRunTime.unboxToLong((Object)orderInStepDirection.max((Object)BoxesRunTime.boxToLong((long)oldWaterMark), (Object)BoxesRunTime.boxToLong((long)roundedCandidateHighWaterMark)));
        } else lbl-1000:
        // 2 sources

        {
            v0 = roundedCandidateHighWaterMark;
        }
        newHighWaterMark = v0;
        tableHasBadHighWaterMark = info.highWaterMark().exists((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (J)Z, $anonfun$updateToValidHighWaterMark$1(scala.math.Ordering org.apache.spark.sql.delta.IdentityColumn$IdentityInfo long ), (J)Z)((Ordering)orderInStepDirection, (IdentityColumn.IdentityInfo)info));
        if (tableHasBadHighWaterMark) {
            loggingBuffer.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{IdentityColumnHighWaterMarkUpdateInfo$.MODULE$.EXISTING_WATER_MARK_BEFORE_START()}));
        }
        v1 = isChanged = info.highWaterMark().contains((Object)BoxesRunTime.boxToLong((long)newHighWaterMark)) == false;
        if (tableHasBadHighWaterMark || !isBeforeStart && isChanged) {
            x$1 = newMetadata = new MetadataBuilder().withMetadata(field.metadata()).putLong(DeltaSourceUtils$.MODULE$.IDENTITY_INFO_HIGHWATERMARK(), newHighWaterMark).build();
            x$2 = field.copy$default$1();
            x$3 = field.copy$default$2();
            x$4 = field.copy$default$3();
            return new Tuple2((Object)field.copy(x$2, x$3, x$4, x$1), (Object)loggingBuffer.toIndexedSeq());
        }
        return new Tuple2((Object)field, (Object)Nil$.MODULE$);
    }

    public StructType updateSchema(DeltaLog deltaLog, StructType schema, Seq<Tuple2<String, Object>> updatedIdentityHighWaterMarks) {
        Map updatedIdentityHighWaterMarksGrouped = updatedIdentityHighWaterMarks.groupBy((Function1 & Serializable & scala.Serializable)x$2 -> (String)x$2._1()).mapValues((Function1 & Serializable & scala.Serializable)v -> (Seq)v.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3._2$mcJ$sp()), Seq$.MODULE$.canBuildFrom()));
        return StructType$.MODULE$.apply((Seq)schema.map((Function1 & Serializable & scala.Serializable)f -> {
            Option option = updatedIdentityHighWaterMarksGrouped.get((Object)DeltaColumnMapping$.MODULE$.getPhysicalName((StructField)f));
            if (option instanceof Some) {
                Some some = (Some)option;
                Seq newWatermarks = (Seq)some.value();
                if (ColumnWithDefaultExprUtils$.MODULE$.isIdentityColumn((StructField)f)) {
                    IdentityColumn.IdentityInfo oldIdentityInfo = MODULE$.getIdentityInfo((StructField)f);
                    boolean positiveStep = oldIdentityInfo.step() > 0L;
                    long candidateHighWaterMark = positiveStep ? BoxesRunTime.unboxToLong((Object)newWatermarks.max((Ordering)Ordering.Long$.MODULE$)) : BoxesRunTime.unboxToLong((Object)newWatermarks.min((Ordering)Ordering.Long$.MODULE$));
                    Tuple2<StructField, Seq<String>> tuple2 = MODULE$.updateToValidHighWaterMark((StructField)f, candidateHighWaterMark, false);
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    StructField newField = (StructField)tuple2._1();
                    Seq loggingSeq = (Seq)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)newField, (Object)loggingSeq);
                    StructField newField2 = (StructField)tuple22._1();
                    Seq loggingSeq2 = (Seq)tuple22._2();
                    if (loggingSeq2.nonEmpty()) {
                        DeltaLog x$1 = deltaLog;
                        String x$2 = MODULE$.opTypeHighWaterMarkUpdate();
                        Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)f.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"debugInfo"), (Object)loggingSeq2.mkString(", ")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"oldHighWaterMark"), oldIdentityInfo.highWaterMark()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"candidateHighWaterMark"), (Object)BoxesRunTime.boxToLong((long)candidateHighWaterMark)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"updatedFrom"), (Object)"updateSchema")}));
                        Map<TagDefinition, String> x$4 = MODULE$.recordDeltaEvent$default$3();
                        Option<Path> x$5 = MODULE$.recordDeltaEvent$default$5();
                        MODULE$.recordDeltaEvent(x$1, x$2, x$4, x$3, x$5);
                    }
                    return newField2;
                }
            }
            return f;
        }, Seq$.MODULE$.canBuildFrom()));
    }

    public void blockExplicitIdentityColumnInsert(StructType schema, LogicalPlan query) {
        Seq nonInsertableIdentityColumns = (Seq)((TraversableLike)schema.filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)IdentityColumn$.$anonfun$blockExplicitIdentityColumnInsert$1(f)))).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.name(), Seq$.MODULE$.canBuildFrom());
        this.blockIdentityColumn((Seq<String>)nonInsertableIdentityColumns, (Seq<Seq<String>>)((Seq)query.output().map((Function1 & Serializable & scala.Serializable)attr -> (Seq)new .colon.colon((Object)attr.name(), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())), false);
    }

    public void blockExplicitIdentityColumnInsert(Seq<StructField> identityColumns, Seq<Seq<String>> insertedColNameParts) {
        Seq nonInsertableIdentityColumns = (Seq)((TraversableLike)identityColumns.filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)IdentityColumn$.$anonfun$blockExplicitIdentityColumnInsert$4(x$6)))).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.name(), Seq$.MODULE$.canBuildFrom());
        this.blockIdentityColumn((Seq<String>)nonInsertableIdentityColumns, insertedColNameParts, false);
    }

    public void blockIdentityColumnUpdate(StructType schema, Seq<Seq<String>> updatedColNameParts) {
        this.blockIdentityColumnUpdate(this.getIdentityColumns(schema), updatedColNameParts);
    }

    public void blockIdentityColumnUpdate(Seq<StructField> identityColumns, Seq<Seq<String>> updatedColNameParts) {
        this.blockIdentityColumn((Seq<String>)((Seq)identityColumns.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.name(), Seq$.MODULE$.canBuildFrom())), updatedColNameParts, true);
    }

    public void logTableCreation(DeltaLog deltaLog, StructType schema) {
        int numIdentityColumns = this.getNumberOfIdentityColumns(schema);
        if (numIdentityColumns != 0) {
            DeltaLog x$1 = deltaLog;
            String x$2 = this.opTypeDefinition();
            Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numIdentityColumns"), (Object)BoxesRunTime.boxToInteger((int)numIdentityColumns))}));
            Map<TagDefinition, String> x$4 = this.recordDeltaEvent$default$3();
            Option<Path> x$5 = this.recordDeltaEvent$default$5();
            this.recordDeltaEvent(x$1, x$2, x$4, x$3, x$5);
            return;
        }
    }

    public void logTableWrite(Snapshot snapshot, Set<String> generatedIdentityColumns, Option<Object> numInsertedRowsOpt) {
        Seq<StructField> identityColumns = this.getIdentityColumns(snapshot.schema());
        if (identityColumns.nonEmpty()) {
            Seq explicitIdentityColumns = (Seq)((TraversableLike)identityColumns.filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)IdentityColumn$.$anonfun$logTableWrite$1(generatedIdentityColumns, f)))).map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.name(), Seq$.MODULE$.canBuildFrom());
            DeltaLog x$1 = snapshot.deltaLog();
            String x$2 = this.opTypeWrite();
            Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numInsertedRows"), numInsertedRowsOpt), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"generatedIdentityColumnNames"), (Object)generatedIdentityColumns.mkString(",")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"generatedIdentityColumnCount"), (Object)BoxesRunTime.boxToInteger((int)generatedIdentityColumns.size())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"explicitIdentityColumnNames"), (Object)explicitIdentityColumns.mkString(",")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"explicitIdentityColumnCount"), (Object)BoxesRunTime.boxToInteger((int)explicitIdentityColumns.size()))}));
            Map<TagDefinition, String> x$4 = this.recordDeltaEvent$default$3();
            Option<Path> x$5 = this.recordDeltaEvent$default$5();
            this.recordDeltaEvent(x$1, x$2, x$4, x$3, x$5);
            return;
        }
    }

    public void logTransactionAbort(DeltaLog deltaLog) {
        this.recordDeltaEvent(deltaLog, this.opTypeAbort(), this.recordDeltaEvent$default$3(), this.recordDeltaEvent$default$4(), this.recordDeltaEvent$default$5());
    }

    public StructField syncIdentity(DeltaLog deltaLog, StructField field, Dataset<Row> df, boolean allowLoweringHighWaterMarkForSyncIdentity) {
        Predef$.MODULE$.assert(ColumnWithDefaultExprUtils$.MODULE$.isIdentityColumn(field));
        IdentityColumn.IdentityInfo info = this.getIdentityInfo(field);
        boolean positiveStep = info.step() > 0L;
        Column expr = positiveStep ? functions$.MODULE$.max(field.name()) : functions$.MODULE$.min(field.name());
        Row resultRow = (Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{expr})).collect())).head();
        if (!resultRow.isNullAt(0)) {
            long candidateHighWaterMark = resultRow.getLong(0);
            Tuple2<StructField, Seq<String>> tuple2 = this.updateToValidHighWaterMark(field, candidateHighWaterMark, allowLoweringHighWaterMarkForSyncIdentity);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            StructField newField = (StructField)tuple2._1();
            Seq loggingSeq = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)newField, (Object)loggingSeq);
            StructField newField2 = (StructField)tuple22._1();
            Seq loggingSeq2 = (Seq)tuple22._2();
            if (loggingSeq2.nonEmpty()) {
                DeltaLog x$1 = deltaLog;
                String x$2 = this.opTypeHighWaterMarkUpdate();
                Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)field.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"debugInfo"), (Object)loggingSeq2.mkString(", ")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"oldHighWaterMark"), info.highWaterMark()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"candidateHighWaterMark"), (Object)BoxesRunTime.boxToLong((long)candidateHighWaterMark)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"updatedFrom"), (Object)"syncIdentity")}));
                Map<TagDefinition, String> x$4 = this.recordDeltaEvent$default$3();
                Option<Path> x$5 = this.recordDeltaEvent$default$5();
                this.recordDeltaEvent(x$1, x$2, x$4, x$3, x$5);
            }
            return newField2;
        }
        return field;
    }

    public StructType copySchemaWithMergedHighWaterMarks(DeltaLog deltaLog, StructType schemaToCopy, StructType schemaWithHighWaterMarksToMerge) {
        Seq newHighWatermarks = (Seq)this.getIdentityColumns(schemaWithHighWaterMarksToMerge).flatMap((Function1 & Serializable & scala.Serializable)f -> {
            IdentityColumn.IdentityInfo info = MODULE$.getIdentityInfo((StructField)f);
            return Option$.MODULE$.option2Iterable(info.highWaterMark().map((Function1 & Serializable & scala.Serializable)waterMark -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DeltaColumnMapping$.MODULE$.getPhysicalName(f)), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)waterMark)))));
        }, Seq$.MODULE$.canBuildFrom());
        return this.updateSchema(deltaLog, schemaToCopy, (Seq<Tuple2<String, Object>>)newHighWatermarks);
    }

    private void blockIdentityColumn(Seq<String> columnNamesToBlock, Seq<Seq<String>> colNameParts, boolean isUpdate) {
        if (columnNamesToBlock.nonEmpty()) {
            Function2 resolver = SparkSession$.MODULE$.active().sessionState().analyzer().resolver();
            colNameParts.foreach((Function1 & Serializable & scala.Serializable)namePart -> {
                IdentityColumn$.$anonfun$blockIdentityColumn$1(columnNamesToBlock, resolver, isUpdate, namePart);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public IdentityColumn.IdentityInfo getIdentityInfo(StructField field) {
        Metadata md = field.metadata();
        long start = md.getLong(DeltaSourceUtils$.MODULE$.IDENTITY_INFO_START());
        long step = md.getLong(DeltaSourceUtils$.MODULE$.IDENTITY_INFO_STEP());
        None$ highWaterMark = md.contains(DeltaSourceUtils$.MODULE$.IDENTITY_INFO_HIGHWATERMARK()) ? new Some((Object)BoxesRunTime.boxToLong((long)md.getLong(DeltaSourceUtils$.MODULE$.IDENTITY_INFO_HIGHWATERMARK()))) : None$.MODULE$;
        return new IdentityColumn.IdentityInfo(start, step, (Option<Object>)highWaterMark);
    }

    public static final /* synthetic */ boolean $anonfun$updateToValidHighWaterMark$1(Ordering orderInStepDirection$1, IdentityColumn.IdentityInfo info$1, long oldWaterMark) {
        return orderInStepDirection$1.lt((Object)BoxesRunTime.boxToLong((long)oldWaterMark), (Object)BoxesRunTime.boxToLong((long)info$1.start()));
    }

    public static final /* synthetic */ boolean $anonfun$blockExplicitIdentityColumnInsert$1(StructField f) {
        return ColumnWithDefaultExprUtils$.MODULE$.isIdentityColumn(f) && !MODULE$.allowExplicitInsert(f);
    }

    public static final /* synthetic */ boolean $anonfun$blockExplicitIdentityColumnInsert$4(StructField x$6) {
        return !MODULE$.allowExplicitInsert(x$6);
    }

    public static final /* synthetic */ boolean $anonfun$logTableWrite$1(Set generatedIdentityColumns$1, StructField f) {
        return !generatedIdentityColumns$1.contains((Object)f.name());
    }

    public static final /* synthetic */ boolean $anonfun$blockIdentityColumn$2(Function2 resolver$1, String colName$1, String x$11) {
        return BoxesRunTime.unboxToBoolean((Object)resolver$1.apply((Object)x$11, (Object)colName$1));
    }

    public static final /* synthetic */ void $anonfun$blockIdentityColumn$1(Seq columnNamesToBlock$1, Function2 resolver$1, boolean isUpdate$1, Seq namePart) {
        if (namePart.size() == 1) {
            String colName = (String)namePart.head();
            if (columnNamesToBlock$1.exists((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)IdentityColumn$.$anonfun$blockIdentityColumn$2(resolver$1, colName, x$11)))) {
                if (isUpdate$1) {
                    throw DeltaErrors$.MODULE$.identityColumnUpdateNotSupported(colName);
                }
                throw DeltaErrors$.MODULE$.identityColumnExplicitInsertNotSupported(colName);
            }
            return;
        }
    }

    private IdentityColumn$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        LoggingShims.$init$(this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
        this.defaultStart = 1;
        this.defaultStep = 1;
        this.opTypeDefinition = "delta.identityColumn.definition";
        this.opTypeWrite = "delta.identityColumn.write";
        this.opTypeAbort = "delta.identityColumn.abort";
        this.opTypeHighWaterMarkUpdate = "delta.identityColumn.highWaterMarkUpdate";
    }
}

