/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaLog$;
import org.apache.spark.sql.delta.DeltaOperations$ManualUpdate$;
import org.apache.spark.sql.delta.RecordChecksum$;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.VersionChecksum;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.CommitInfo;
import org.apache.spark.sql.delta.actions.DomainMetadata;
import org.apache.spark.sql.delta.actions.InMemoryLogReplay;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.actions.RemoveFile;
import org.apache.spark.sql.delta.actions.SetTransaction;
import org.apache.spark.sql.delta.commands.DeletionVectorUtils$;
import org.apache.spark.sql.delta.logging.DeltaLogKeys$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.stats.DeletedRecordCountsHistogram;
import org.apache.spark.sql.delta.stats.DeletedRecordCountsHistogram$;
import org.apache.spark.sql.delta.stats.FileSizeHistogram;
import org.apache.spark.sql.delta.util.FileNames$;
import org.apache.spark.sql.delta.util.JsonUtils$;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005]faB\t\u0013!\u0003\r\t!\b\u0005\u0006U\u0001!\ta\u000b\u0005\b_\u0001\u0011\rQ\"\u00011\u0011\u00159\u0002A\"\u00056\u0011!Q\u0004\u0001#b\u0001\n\u0013Y\u0004\"\u0002#\u0001\t\u0013)\u0005\"\u0002(\u0001\t#y\u0005\"\u00020\u0001\t\u0003y\u0006\u0002CA\u0014\u0001\u0011\u0005!#!\u000b\t\u000f\u0005=\u0003\u0001\"\u0003\u0002R!9\u0011q\r\u0001\u0005\n\u0005%\u0004bBA?\u0001\u0011%\u0011qP\u0004\b\u0003/\u0013\u0002\u0012AAM\r\u0019\t\"\u0003#\u0001\u0002\u001c\"9\u0011QT\u0007\u0005\u0002\u0005}\u0005\"CAQ\u001b\t\u0007I\u0011AAR\u0011!\t),\u0004Q\u0001\n\u0005\u0015&A\u0004*fG>\u0014Hm\u00115fG.\u001cX/\u001c\u0006\u0003'Q\tQ\u0001Z3mi\u0006T!!\u0006\f\u0002\u0007M\fHN\u0003\u0002\u00181\u0005)1\u000f]1sW*\u0011\u0011DG\u0001\u0007CB\f7\r[3\u000b\u0003m\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u0010%!\ty\"%D\u0001!\u0015\u0005\t\u0013!B:dC2\f\u0017BA\u0012!\u0005\u0019\te.\u001f*fMB\u0011Q\u0005K\u0007\u0002M)\u0011qEE\u0001\t[\u0016$XM]5oO&\u0011\u0011F\n\u0002\r\t\u0016dG/\u0019'pO\u001eLgnZ\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0015\u00031\u0002\"aH\u0017\n\u00059\u0002#\u0001B+oSR\f\u0001\u0002Z3mi\u0006dunZ\u000b\u0002cA\u0011!gM\u0007\u0002%%\u0011AG\u0005\u0002\t\t\u0016dG/\u0019'pOV\ta\u0007\u0005\u00028q5\tA#\u0003\u0002:)\ta1\u000b]1sWN+7o]5p]\u00061qO]5uKJ,\u0012\u0001\u0010\t\u0003{\tk\u0011A\u0010\u0006\u0003\u007f\u0001\u000b\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u0005#\u0012!C3yK\u000e,H/[8o\u0013\t\u0019eHA\u000bDQ\u0016\u001c7\u000e]8j]R4\u0015\u000e\\3NC:\fw-\u001a:\u0002\u0017\u001d,Go\u00115fG.\u001cX/\u001c\u000b\u0003\r&\u0003\"AM$\n\u0005!\u0013\"a\u0004,feNLwN\\\"iK\u000e\\7/^7\t\u000b)+\u0001\u0019A&\u0002\u0011Mt\u0017\r]:i_R\u0004\"A\r'\n\u00055\u0013\"\u0001C*oCB\u001c\bn\u001c;\u0002#]\u0014\u0018\u000e^3DQ\u0016\u001c7n];n\r&dW\rF\u0002-!vCQ!\u0015\u0004A\u0002I\u000bQ\u0001\u001e=o\u0013\u0012\u0004\"a\u0015.\u000f\u0005QC\u0006CA+!\u001b\u00051&BA,\u001d\u0003\u0019a$o\\8u}%\u0011\u0011\fI\u0001\u0007!J,G-\u001a4\n\u0005mc&AB*ue&twM\u0003\u0002ZA!)!J\u0002a\u0001\u0017\u0006Y\u0012N\\2sK6,g\u000e^1mYf$UM]5wK\u000eCWmY6tk6$r\u0002Y5kWBTx0!\u0003\u0002\u000e\u0005]\u0011Q\u0004\t\u0005C\u001a\u0014fI\u0004\u0002cI:\u0011QkY\u0005\u0002C%\u0011Q\rI\u0001\ba\u0006\u001c7.Y4f\u0013\t9\u0007N\u0001\u0004FSRDWM\u001d\u0006\u0003K\u0002BQaF\u0004A\u0002YBQaL\u0004A\u0002EBQ\u0001\\\u0004A\u00025\f\u0001C^3sg&|g\u000eV8D_6\u0004X\u000f^3\u0011\u0005}q\u0017BA8!\u0005\u0011auN\\4\t\u000bE<\u0001\u0019\u0001:\u0002\u000f\u0005\u001cG/[8ogB\u0019\u0011m];\n\u0005QD'aA*fcB\u0011a\u000f_\u0007\u0002o*\u0011\u0011OE\u0005\u0003s^\u0014a!Q2uS>t\u0007\"B>\b\u0001\u0004a\u0018\u0001C7fi\u0006$\u0017\r^1\u0011\u0005Yl\u0018B\u0001@x\u0005!iU\r^1eCR\f\u0007bBA\u0001\u000f\u0001\u0007\u00111A\u0001\taJ|Go\\2pYB\u0019a/!\u0002\n\u0007\u0005\u001dqO\u0001\u0005Qe>$xnY8m\u0011\u0019\tYa\u0002a\u0001%\u0006iq\u000e]3sCRLwN\u001c(b[\u0016Dq!a\u0004\b\u0001\u0004\t\t\"\u0001\u0005uq:LEm\u00149u!\u0011y\u00121\u0003*\n\u0007\u0005U\u0001E\u0001\u0004PaRLwN\u001c\u0005\b\u000339\u0001\u0019AA\u000e\u0003Q\u0001(/\u001a<j_V\u001ch+\u001a:tS>t7\u000b^1uKB!\u0011MZ&G\u0011\u001d\tyb\u0002a\u0001\u0003C\tA#\u001b8dYV$W-\u00113e\r&dWm]%o\u0007J\u001c\u0007cA\u0010\u0002$%\u0019\u0011Q\u0005\u0011\u0003\u000f\t{w\u000e\\3b]\u0006\u00112m\\7qkR,g*Z<DQ\u0016\u001c7n];n)U\u0001\u00171FA\u0018\u0003c\t\u0019$a\u000e\u0002>\u0005}\u00121IA$\u0003\u0017Ba!!\f\t\u0001\u0004i\u0017AD1ui\u0016l\u0007\u000f\u001e,feNLwN\u001c\u0005\u0007\u0003\u0017A\u0001\u0019\u0001*\t\u000f\u0005=\u0001\u00021\u0001\u0002\u0012!1\u0011Q\u0007\u0005A\u0002\u0019\u000b!c\u001c7e-\u0016\u00148/[8o\u0007\",7m[:v[\"9\u0011\u0011\b\u0005A\u0002\u0005m\u0012aC8mINs\u0017\r]:i_R\u0004BaHA\n\u0017\")\u0011\u000f\u0003a\u0001e\"9\u0011\u0011\t\u0005A\u0002\u0005\u0005\u0012AD5h]>\u0014X-\u00113e\r&dWm\u001d\u0005\b\u0003\u000bB\u0001\u0019AA\u0011\u0003QIgn\u00197vI\u0016\fE\u000e\u001c$jY\u0016\u001c\u0018J\\\"S\u0007\"9\u0011\u0011\n\u0005A\u0002\u0005\u0005\u0012\u0001\b9feNL7\u000f^3oi\u001236o\u00148UC\ndWMU3bI\u0006\u0014G.\u001a\u0005\b\u0003\u001bB\u0001\u0019AA\u0011\u0003q\u0001XM]:jgR,g\u000e\u001e#Wg>sG+\u00192mK^\u0013\u0018\u000e^1cY\u0016\f1%\u001b8de\u0016lWM\u001c;bY2L8i\\7qkR,7+\u001a;Ue\u0006t7/Y2uS>t7\u000f\u0006\u0006\u0002T\u0005u\u0013qLA1\u0003G\u0002RaHA\n\u0003+\u0002B!Y:\u0002XA\u0019a/!\u0017\n\u0007\u0005msO\u0001\bTKR$&/\u00198tC\u000e$\u0018n\u001c8\t\u000f\u0005e\u0012\u00021\u0001\u0002<!1\u0011QG\u0005A\u0002\u0019Ca!!\f\n\u0001\u0004i\u0007BBA3\u0013\u0001\u0007!/A\bbGRLwN\\:U_\u000e{W.\\5u\u0003\rJgn\u0019:f[\u0016tG/\u00197ms\u000e{W\u000e];uK\u0012{W.Y5o\u001b\u0016$\u0018\rZ1uCN$\"\"a\u001b\u0002v\u0005]\u0014\u0011PA>!\u0015y\u00121CA7!\u0011\t7/a\u001c\u0011\u0007Y\f\t(C\u0002\u0002t]\u0014a\u0002R8nC&tW*\u001a;bI\u0006$\u0018\rC\u0004\u0002:)\u0001\r!a\u000f\t\r\u0005U\"\u00021\u0001G\u0011\u0019\tiC\u0003a\u0001[\"1\u0011Q\r\u0006A\u0002I\fA$\u001b8de\u0016lWM\u001c;bY2L8i\\7qkR,\u0017\t\u001a3GS2,7\u000f\u0006\u0007\u0002\u0002\u0006-\u0015QRAH\u0003#\u000b)\nE\u0003 \u0003'\t\u0019\t\u0005\u0003bg\u0006\u0015\u0005c\u0001<\u0002\b&\u0019\u0011\u0011R<\u0003\u000f\u0005#GMR5mK\"9\u0011\u0011H\u0006A\u0002\u0005m\u0002BBA\u001b\u0017\u0001\u0007a\t\u0003\u0004\u0002.-\u0001\r!\u001c\u0005\u0007\u0003'[\u0001\u0019A7\u0002'9,XNR5mKN\fe\r^3s\u0007>lW.\u001b;\t\r\u0005\u00154\u00021\u0001s\u00039\u0011VmY8sI\u000eCWmY6tk6\u0004\"AM\u0007\u0014\u00055q\u0012A\u0002\u001fj]&$h\b\u0006\u0002\u0002\u001a\u0006\u0019t\u000e]3sCRLwN\u001c(b[\u0016\u001cx\u000b[3sK\u0006#GMR5mKNLuM\\8sK\u00124uN]%oGJ,W.\u001a8uC2\u001c%oY\u000b\u0003\u0003K\u0003R!a*\u00022Jk!!!+\u000b\t\u0005-\u0016QV\u0001\nS6lW\u000f^1cY\u0016T1!a,!\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003g\u000bIKA\u0002TKR\fAg\u001c9fe\u0006$\u0018n\u001c8OC6,7o\u00165fe\u0016\fE\r\u001a$jY\u0016\u001c\u0018j\u001a8pe\u0016$gi\u001c:J]\u000e\u0014X-\\3oi\u0006d7I]2!\u0001")
public interface RecordChecksum
extends DeltaLogging {
    public static Set<String> operationNamesWhereAddFilesIgnoredForIncrementalCrc() {
        return RecordChecksum$.MODULE$.operationNamesWhereAddFilesIgnoredForIncrementalCrc();
    }

    public DeltaLog deltaLog();

    public SparkSession spark();

    public static /* synthetic */ CheckpointFileManager org$apache$spark$sql$delta$RecordChecksum$$writer$(RecordChecksum $this) {
        return $this.org$apache$spark$sql$delta$RecordChecksum$$writer();
    }

    default public CheckpointFileManager org$apache$spark$sql$delta$RecordChecksum$$writer() {
        return CheckpointFileManager$.MODULE$.create(this.deltaLog().logPath(), this.deltaLog().newDeltaHadoopConf());
    }

    private VersionChecksum getChecksum(Snapshot snapshot) {
        return snapshot.computeChecksum();
    }

    public static /* synthetic */ void writeChecksumFile$(RecordChecksum $this, String txnId, Snapshot snapshot) {
        $this.writeChecksumFile(txnId, snapshot);
    }

    default public void writeChecksumFile(String txnId, Snapshot snapshot) {
        Map eventData;
        block7: {
            if (!BoxesRunTime.unboxToBoolean((Object)this.spark().sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_WRITE_CHECKSUM_ENABLED()))) {
                return;
            }
            long version = snapshot.version();
            VersionChecksum checksumWithoutTxnId = this.getChecksum(snapshot);
            VersionChecksum checksum = checksumWithoutTxnId.copy((Option<String>)new Some((Object)txnId), checksumWithoutTxnId.copy$default$2(), checksumWithoutTxnId.copy$default$3(), checksumWithoutTxnId.copy$default$4(), checksumWithoutTxnId.copy$default$5(), checksumWithoutTxnId.copy$default$6(), checksumWithoutTxnId.copy$default$7(), checksumWithoutTxnId.copy$default$8(), checksumWithoutTxnId.copy$default$9(), checksumWithoutTxnId.copy$default$10(), checksumWithoutTxnId.copy$default$11(), checksumWithoutTxnId.copy$default$12(), checksumWithoutTxnId.copy$default$13(), checksumWithoutTxnId.copy$default$14(), checksumWithoutTxnId.copy$default$15());
            eventData = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operationSucceeded"), (Object)BoxesRunTime.boxToBoolean((boolean)false))}));
            eventData.update((Object)"numAddFileActions", checksum.allFiles().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.size())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1));
            eventData.update((Object)"numSetTransactionActions", checksum.setTransactions().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.size())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1));
            long startTimeMs = System.currentTimeMillis();
            try {
                String toWrite = new StringBuilder(1).append(JsonUtils$.MODULE$.toJson(checksum, ManifestFactory$.MODULE$.classType(VersionChecksum.class))).append("\n").toString();
                eventData.update((Object)"jsonSerializationTimeTakenMs", (Object)BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - startTimeMs)));
                eventData.update((Object)"checksumLength", (Object)BoxesRunTime.boxToInteger((int)toWrite.length()));
                CheckpointFileManager.CancellableFSDataOutputStream stream = this.org$apache$spark$sql$delta$RecordChecksum$$writer().createAtomic(FileNames$.MODULE$.checksumFile(this.deltaLog().logPath(), version), false);
                try {
                    stream.write(toWrite.getBytes(StandardCharsets.UTF_8));
                    stream.close();
                    eventData.update((Object)"overallTimeTakenMs", (Object)BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - startTimeMs)));
                    eventData.update((Object)"operationSucceeded", (Object)BoxesRunTime.boxToBoolean((boolean)true));
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        Throwable e = (Throwable)option.get();
                        this.logWarning(LogEntry$.MODULE$.from((Function0<MessageWithContext>)(Function0 & Serializable & scala.Serializable)() -> this.LogStringContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to write the checksum for version: "}))).log((Seq<MDC>)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq<MDC>)Predef$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.VERSION(), BoxesRunTime.boxToLong((long)version))})))), e);
                        stream.cancel();
                        break block7;
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                Throwable throwable3 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable3);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    this.logWarning(LogEntry$.MODULE$.from((Function0<MessageWithContext>)(Function0 & Serializable & scala.Serializable)() -> this.LogStringContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to write the checksum for version: "}))).log((Seq<MDC>)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq<MDC>)Predef$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.VERSION(), BoxesRunTime.boxToLong((long)version))})))), e);
                }
                throw throwable;
            }
        }
        DeltaLog x$12 = this.deltaLog();
        String x$22 = "delta.checksum.write";
        Map x$3 = eventData;
        scala.collection.immutable.Map<TagDefinition, String> x$4 = this.recordDeltaEvent$default$3();
        Option<Path> x$5 = this.recordDeltaEvent$default$5();
        this.recordDeltaEvent(x$12, x$22, x$4, x$3, x$5);
    }

    public static /* synthetic */ Either incrementallyDeriveChecksum$(RecordChecksum $this, SparkSession spark, DeltaLog deltaLog, long versionToCompute, Seq actions, Metadata metadata, Protocol protocol, String operationName, Option txnIdOpt, Either previousVersionState, boolean includeAddFilesInCrc) {
        return $this.incrementallyDeriveChecksum(spark, deltaLog, versionToCompute, (Seq<Action>)actions, metadata, protocol, operationName, (Option<String>)txnIdOpt, (Either<Snapshot, VersionChecksum>)previousVersionState, includeAddFilesInCrc);
    }

    default public Either<String, VersionChecksum> incrementallyDeriveChecksum(SparkSession spark, DeltaLog deltaLog, long versionToCompute, Seq<Action> actions, Metadata metadata, Protocol protocol, String operationName, Option<String> txnIdOpt, Either<Snapshot, VersionChecksum> previousVersionState, boolean includeAddFilesInCrc) {
        Either<String, VersionChecksum> either;
        Object object = new Object();
        try {
            Tuple2 tuple2;
            Left left;
            Snapshot snapshot2;
            Tuple2 tuple22;
            if (!deltaLog.incrementalCommitEnabled()) {
                return package$.MODULE$.Left().apply((Object)"INCREMENTAL_COMMITS_DISABLED");
            }
            String string = operationName;
            String string2 = DeltaOperations$ManualUpdate$.MODULE$.name();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return package$.MODULE$.Left().apply((Object)"INVALID_OPERATION_MANUAL_UPDATE");
            }
            long expectedVersion = versionToCompute - 1L;
            Either<Snapshot, VersionChecksum> either2 = previousVersionState;
            if (either2 instanceof Right) {
                Right right = (Right)either2;
                VersionChecksum checksum = (VersionChecksum)right.value();
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)checksum), (Object)None$.MODULE$);
            } else if (either2 instanceof Left && (snapshot2 = (Snapshot)(left = (Left)either2).value()).version() == expectedVersion) {
                this.logInfo(LogEntry$.MODULE$.from((Function0<MessageWithContext>)(Function0 & Serializable & scala.Serializable)() -> this.LogStringContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Incremental commit: starting with snapshot version "}))).log((Seq<MDC>)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq<MDC>)Predef$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.VERSION(), BoxesRunTime.boxToLong((long)expectedVersion))})))));
                VersionChecksum qual$1 = this.getChecksum(snapshot2);
                long x$1 = 1L;
                long x$2 = 1L;
                Option<String> x$32 = qual$1.copy$default$1();
                long x$42 = qual$1.copy$default$2();
                long x$5 = qual$1.copy$default$3();
                Option<Object> x$6 = qual$1.copy$default$4();
                Option<Object> x$7 = qual$1.copy$default$5();
                Option<Object> x$8 = qual$1.copy$default$8();
                Option<Seq<SetTransaction>> x$9 = qual$1.copy$default$9();
                Option<Seq<DomainMetadata>> x$10 = qual$1.copy$default$10();
                Metadata x$11 = qual$1.copy$default$11();
                Protocol x$12 = qual$1.copy$default$12();
                Option<FileSizeHistogram> x$13 = qual$1.copy$default$13();
                Option<DeletedRecordCountsHistogram> x$14 = qual$1.copy$default$14();
                Option<Seq<AddFile>> x$15 = qual$1.copy$default$15();
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)qual$1.copy(x$32, x$42, x$5, x$6, x$7, x$1, x$2, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15)), (Object)new Some((Object)snapshot2));
            } else {
                previousVersionState.swap().foreach((Function1 & Serializable & scala.Serializable)snapshot -> {
                    RecordChecksum.$anonfun$incrementallyDeriveChecksum$2(this, deltaLog, versionToCompute, snapshot);
                    return BoxedUnit.UNIT;
                });
                Option<VersionChecksum> oldCrcOpt = deltaLog.readChecksum(expectedVersion, deltaLog.readChecksum$default$2());
                if (oldCrcOpt.isEmpty()) {
                    return package$.MODULE$.Left().apply((Object)"MISSING_OLD_CRC");
                }
                Option oldCrcFiltered = oldCrcOpt.filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)RecordChecksum.$anonfun$incrementallyDeriveChecksum$3(x$3))).filterNot((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)RecordChecksum.$anonfun$incrementallyDeriveChecksum$4(x$4)));
                VersionChecksum oldCrc = (VersionChecksum)oldCrcFiltered.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new NonLocalReturnControl(object, (Object)package$.MODULE$.Left().apply((Object)"OLD_CRC_INCOMPLETE"));
                });
                tuple22 = tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)oldCrc), (Object)None$.MODULE$);
            }
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            VersionChecksum oldVersionChecksum = (VersionChecksum)tuple2._1();
            Option oldSnapshot = (Option)tuple2._2();
            Tuple2 tuple23 = new Tuple2((Object)oldVersionChecksum, (Object)oldSnapshot);
            VersionChecksum oldVersionChecksum2 = (VersionChecksum)tuple23._1();
            Option oldSnapshot2 = (Option)tuple23._2();
            boolean ignoreAddFilesInOperation = RecordChecksum$.MODULE$.operationNamesWhereAddFilesIgnoredForIncrementalCrc().contains((Object)operationName);
            boolean persistentDVsOnTableReadable = DeletionVectorUtils$.MODULE$.deletionVectorsReadable(protocol, metadata);
            boolean persistentDVsOnTableWritable = DeletionVectorUtils$.MODULE$.deletionVectorsWritable(protocol, metadata);
            either = this.computeNewChecksum(versionToCompute, operationName, txnIdOpt, oldVersionChecksum2, (Option<Snapshot>)oldSnapshot2, actions, ignoreAddFilesInOperation, includeAddFilesInCrc, persistentDVsOnTableReadable, persistentDVsOnTableWritable);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                either = (Either<String, VersionChecksum>)ex.value();
            }
            throw ex;
        }
        return either;
    }

    public static /* synthetic */ Either computeNewChecksum$(RecordChecksum $this, long attemptVersion, String operationName, Option txnIdOpt, VersionChecksum oldVersionChecksum, Option oldSnapshot, Seq actions, boolean ignoreAddFiles, boolean includeAllFilesInCRC, boolean persistentDVsOnTableReadable, boolean persistentDVsOnTableWritable) {
        return $this.computeNewChecksum(attemptVersion, operationName, (Option<String>)txnIdOpt, oldVersionChecksum, (Option<Snapshot>)oldSnapshot, (Seq<Action>)actions, ignoreAddFiles, includeAllFilesInCRC, persistentDVsOnTableReadable, persistentDVsOnTableWritable);
    }

    default public Either<String, VersionChecksum> computeNewChecksum(long attemptVersion, String operationName, Option<String> txnIdOpt, VersionChecksum oldVersionChecksum, Option<Snapshot> oldSnapshot, Seq<Action> actions, boolean ignoreAddFiles, boolean includeAllFilesInCRC, boolean persistentDVsOnTableReadable, boolean persistentDVsOnTableWritable) {
        Either either;
        Object object = new Object();
        try {
            oldSnapshot.foreach((Function1 & Serializable & scala.Serializable)s -> {
                Predef$.MODULE$.require(s.version() == attemptVersion - 1L);
                return BoxedUnit.UNIT;
            });
            LongRef tableSizeBytes = LongRef.create((long)oldVersionChecksum.tableSizeBytes());
            LongRef numFiles = LongRef.create((long)oldVersionChecksum.numFiles());
            ObjectRef protocol = ObjectRef.create((Object)oldVersionChecksum.protocol());
            ObjectRef metadata = ObjectRef.create((Object)oldVersionChecksum.metadata());
            SQLConf conf = this.spark().sessionState().conf();
            boolean isFirstVersion = oldSnapshot.forall((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)RecordChecksum.$anonfun$computeNewChecksum$2(x$6)));
            boolean checksumDVMetricsEnabled = BoxesRunTime.unboxToBoolean((Object)conf.getConf(DeltaSQLConf$.MODULE$.DELTA_CHECKSUM_DV_METRICS_ENABLED()));
            boolean deletedRecordCountsHistogramEnabled = BoxesRunTime.unboxToBoolean((Object)conf.getConf(DeltaSQLConf$.MODULE$.DELTA_DELETED_RECORD_COUNTS_HISTOGRAM_ENABLED()));
            boolean computeDVMetricsWhenDVsNotWritable = persistentDVsOnTableReadable && oldVersionChecksum.numDeletionVectorsOpt().isDefined() && !isFirstVersion;
            boolean computeDVMetrics = checksumDVMetricsEnabled && (persistentDVsOnTableWritable || computeDVMetricsWhenDVsNotWritable);
            ObjectRef numDeletedRecordsOpt = ObjectRef.create((Object)(computeDVMetrics ? oldVersionChecksum.numDeletedRecordsOpt().orElse((Function0 & Serializable & scala.Serializable)() -> oldSnapshot.flatMap((Function1 & Serializable & scala.Serializable)x$7 -> x$7.numDeletedRecordsOpt())) : None$.MODULE$));
            ObjectRef numDeletionVectorsOpt = ObjectRef.create((Object)(computeDVMetrics ? oldVersionChecksum.numDeletionVectorsOpt().orElse((Function0 & Serializable & scala.Serializable)() -> oldSnapshot.flatMap((Function1 & Serializable & scala.Serializable)x$8 -> x$8.numDeletionVectorsOpt())) : None$.MODULE$));
            None$ deletedRecordCountsHistogramOpt = computeDVMetrics && deletedRecordCountsHistogramEnabled ? oldVersionChecksum.deletedRecordCountsHistogramOpt().orElse((Function0 & Serializable & scala.Serializable)() -> oldSnapshot.flatMap((Function1 & Serializable & scala.Serializable)x$9 -> x$9.deletedRecordCountsHistogramOpt())).map((Function1 & Serializable & scala.Serializable)h -> DeletedRecordCountsHistogram$.MODULE$.apply((long[])h.deletedRecordCounts().clone())) : None$.MODULE$;
            ObjectRef inCommitTimestamp = ObjectRef.create((Object)None$.MODULE$);
            actions.foreach(arg_0 -> RecordChecksum.$anonfun$computeNewChecksum$10$adapted(this, ignoreAddFiles, tableSizeBytes, numFiles, numDeletedRecordsOpt, numDeletionVectorsOpt, (Option)deletedRecordCountsHistogramOpt, object, protocol, metadata, inCommitTimestamp, arg_0));
            Option<Seq<SetTransaction>> setTransactions = this.incrementallyComputeSetTransactions(oldSnapshot, oldVersionChecksum, attemptVersion, actions);
            Option<Seq<DomainMetadata>> domainMetadata = this.incrementallyComputeDomainMetadatas(oldSnapshot, oldVersionChecksum, attemptVersion, actions);
            Option computeAddFiles = includeAllFilesInCRC ? this.incrementallyComputeAddFiles(oldSnapshot, oldVersionChecksum, attemptVersion, numFiles.elem, actions) : (numFiles.elem == 0L ? Option$.MODULE$.apply((Object)Nil$.MODULE$) : None$.MODULE$);
            Option allFiles = computeAddFiles.filter((Function1 & Serializable & scala.Serializable)files -> BoxesRunTime.boxToBoolean((boolean)RecordChecksum.$anonfun$computeNewChecksum$21(this, numFiles, tableSizeBytes, oldVersionChecksum, oldSnapshot, actions, attemptVersion, operationName, files)));
            Option<String> x$11 = txnIdOpt;
            long x$12 = tableSizeBytes.elem;
            long x$13 = numFiles.elem;
            Option x$14 = (Option)numDeletedRecordsOpt.elem;
            Option x$15 = (Option)numDeletionVectorsOpt.elem;
            long x$16 = 1L;
            long x$17 = 1L;
            Option x$18 = (Option)inCommitTimestamp.elem;
            Metadata x$19 = (Metadata)metadata.elem;
            Protocol x$20 = (Protocol)protocol.elem;
            Option<Seq<SetTransaction>> x$21 = setTransactions;
            Option<Seq<DomainMetadata>> x$22 = domainMetadata;
            Option x$23 = allFiles;
            None$ x$24 = deletedRecordCountsHistogramOpt;
            None$ x$25 = None$.MODULE$;
            either = package$.MODULE$.Right().apply((Object)new VersionChecksum(x$11, x$12, x$13, (Option<Object>)x$14, (Option<Object>)x$15, x$16, x$17, (Option<Object>)x$18, x$21, x$22, x$19, x$20, (Option<FileSizeHistogram>)x$25, (Option<DeletedRecordCountsHistogram>)x$24, (Option<Seq<AddFile>>)x$23));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                either = (Either)ex.value();
            }
            throw ex;
        }
        return either;
    }

    private Option<Seq<SetTransaction>> incrementallyComputeSetTransactions(Option<Snapshot> oldSnapshot, VersionChecksum oldVersionChecksum, long attemptVersion, Seq<Action> actionsToCommit) {
        Option option;
        Object object = new Object();
        try {
            if (!BoxesRunTime.unboxToBoolean((Object)this.spark().conf().get(DeltaSQLConf$.MODULE$.DELTA_WRITE_SET_TRANSACTIONS_IN_CRC()))) {
                return None$.MODULE$;
            }
            Option newMetadataToCommit = actionsToCommit.collectFirst((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends Action, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof Metadata) {
                        Metadata metadata = (Metadata)A1;
                        return (B1)metadata;
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Action x1) {
                    Action action = x1;
                    return action instanceof Metadata;
                }
            });
            boolean setTransactionRetentionTimestampConfigured = ((IterableLike)((TraversableLike)Option$.MODULE$.option2Iterable(oldSnapshot.map((Function1 & Serializable & scala.Serializable)x$24 -> x$24.metadata())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)oldVersionChecksum.metadata())), Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(newMetadataToCommit), Iterable$.MODULE$.canBuildFrom())).exists((Function1 & Serializable & scala.Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)RecordChecksum.$anonfun$incrementallyComputeSetTransactions$2(x$25)));
            if (setTransactionRetentionTimestampConfigured) {
                return None$.MODULE$;
            }
            Seq oldSetTransactions = (Seq)oldVersionChecksum.setTransactions().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new NonLocalReturnControl(object, (Object)None$.MODULE$);
            });
            Seq setTransactionsToCommit = (Seq)actionsToCommit.filter((Function1 & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)RecordChecksum.$anonfun$incrementallyComputeSetTransactions$4(x$26)));
            long threshold = BoxesRunTime.unboxToLong((Object)this.spark().sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_MAX_SET_TRANSACTIONS_IN_CRC()));
            if ((long)Math.max(setTransactionsToCommit.size(), oldSetTransactions.size()) > threshold) {
                return None$.MODULE$;
            }
            InMemoryLogReplay logReplay = new InMemoryLogReplay(0L, (Option<Object>)None$.MODULE$);
            logReplay.append(attemptVersion - 1L, (Iterator<Action>)oldSetTransactions.toIterator());
            logReplay.append(attemptVersion, (Iterator<Action>)setTransactionsToCommit.toIterator());
            option = new Some((Object)logReplay.getTransactions().toSeq()).filter((Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)RecordChecksum.$anonfun$incrementallyComputeSetTransactions$5(threshold, x$27)));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    private Option<Seq<DomainMetadata>> incrementallyComputeDomainMetadatas(Option<Snapshot> oldSnapshot, VersionChecksum oldVersionChecksum, long attemptVersion, Seq<Action> actionsToCommit) {
        Option option;
        Object object = new Object();
        try {
            Seq oldDomainMetadatas = (Seq)oldVersionChecksum.domainMetadata().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new NonLocalReturnControl(object, (Object)None$.MODULE$);
            });
            Seq newDomainMetadatas = (Seq)actionsToCommit.filter((Function1 & Serializable & scala.Serializable)x$28 -> BoxesRunTime.boxToBoolean((boolean)RecordChecksum.$anonfun$incrementallyComputeDomainMetadatas$2(x$28)));
            InMemoryLogReplay logReplay = new InMemoryLogReplay(0L, (Option<Object>)None$.MODULE$);
            long threshold = BoxesRunTime.unboxToLong((Object)this.spark().sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_MAX_DOMAIN_METADATAS_IN_CRC()));
            logReplay.append(attemptVersion - 1L, (Iterator<Action>)oldDomainMetadatas.iterator());
            logReplay.append(attemptVersion, (Iterator<Action>)newDomainMetadatas.iterator());
            option = new Some((Object)logReplay.getDomainMetadatas().toSeq()).filter((Function1 & Serializable & scala.Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)RecordChecksum.$anonfun$incrementallyComputeDomainMetadatas$3(threshold, x$29)));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    private Option<Seq<AddFile>> incrementallyComputeAddFiles(Option<Snapshot> oldSnapshot, VersionChecksum oldVersionChecksum, long attemptVersion, long numFilesAfterCommit, Seq<Action> actionsToCommit) {
        Option option;
        Object object = new Object();
        try {
            int incrementalAllFilesThreshold = BoxesRunTime.unboxToInt((Object)this.spark().sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_ALL_FILES_IN_CRC_THRESHOLD_FILES()));
            long numFilesBeforeCommit = oldVersionChecksum.numFiles();
            if (Math.max(numFilesAfterCommit, numFilesBeforeCommit) > (long)incrementalAllFilesThreshold) {
                return None$.MODULE$;
            }
            Seq oldAllFiles = (Seq)oldVersionChecksum.allFiles().orElse((Function0 & Serializable & scala.Serializable)() -> (Option)this.recordFrameProfile("Delta", "VersionChecksum.incrementallyComputeAddFiles", (Function0 & Serializable & scala.Serializable)() -> oldSnapshot.map((Function1 & Serializable & scala.Serializable)x$30 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$30.allFiles().collect())).toSeq()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new NonLocalReturnControl(object, (Object)None$.MODULE$);
            });
            DeltaLog.CanonicalPathFunction canonicalPath = new DeltaLog.CanonicalPathFunction((Function0<Configuration>)(Function0 & Serializable & scala.Serializable)() -> this.deltaLog().newDeltaHadoopConf());
            InMemoryLogReplay logReplay = new InMemoryLogReplay(0L, (Option<Object>)None$.MODULE$);
            logReplay.append(attemptVersion - 1L, (Iterator<Action>)((IterableLike)oldAllFiles.map((Function1 & Serializable & scala.Serializable)action -> RecordChecksum.normalizePath$1(action, canonicalPath), Seq$.MODULE$.canBuildFrom())).toIterator());
            logReplay.append(attemptVersion, (Iterator<Action>)((IterableLike)actionsToCommit.map((Function1 & Serializable & scala.Serializable)action -> RecordChecksum.normalizePath$1(action, canonicalPath), Seq$.MODULE$.canBuildFrom())).toIterator());
            option = new Some(logReplay.allFiles());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    public static /* synthetic */ void $anonfun$incrementallyDeriveChecksum$2(RecordChecksum $this, DeltaLog deltaLog$1, long versionToCompute$1, Snapshot snapshot) {
        DeltaLog x$16 = deltaLog$1;
        String x$17 = "delta.commit.snapshotAgedOut";
        scala.collection.immutable.Map x$18 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"snapshotVersion"), (Object)BoxesRunTime.boxToLong((long)snapshot.version())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"commitAttemptVersion"), (Object)BoxesRunTime.boxToLong((long)versionToCompute$1))}));
        scala.collection.immutable.Map<TagDefinition, String> x$19 = $this.recordDeltaEvent$default$3();
        Option<Path> x$20 = $this.recordDeltaEvent$default$5();
        $this.recordDeltaEvent(x$16, x$17, x$19, x$18, x$20);
    }

    public static /* synthetic */ boolean $anonfun$incrementallyDeriveChecksum$3(VersionChecksum x$3) {
        return x$3.metadata() == null;
    }

    public static /* synthetic */ boolean $anonfun$incrementallyDeriveChecksum$4(VersionChecksum x$4) {
        return x$4.protocol() == null;
    }

    public static /* synthetic */ boolean $anonfun$computeNewChecksum$2(Snapshot x$6) {
        return x$6.version() == -1L;
    }

    public static /* synthetic */ void $anonfun$computeNewChecksum$10(RecordChecksum $this, boolean ignoreAddFiles$1, LongRef tableSizeBytes$1, LongRef numFiles$1, ObjectRef numDeletedRecordsOpt$1, ObjectRef numDeletionVectorsOpt$1, Option deletedRecordCountsHistogramOpt$1, Object nonLocalReturnKey2$1, ObjectRef protocol$1, ObjectRef metadata$1, ObjectRef inCommitTimestamp$1, Action x0$1) {
        boolean bl = false;
        RemoveFile removeFile = null;
        Action action = x0$1;
        if (action instanceof AddFile) {
            AddFile addFile = (AddFile)action;
            if (!ignoreAddFiles$1) {
                tableSizeBytes$1.elem += addFile.size();
                ++numFiles$1.elem;
                Tuple2 tuple2 = (Tuple2)Option$.MODULE$.apply((Object)addFile.deletionVector()).map((Function1 & Serializable & scala.Serializable)x$10 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)1L)), (Object)BoxesRunTime.boxToLong((long)x$10.cardinality()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)0L)), (Object)BoxesRunTime.boxToLong((long)0L)));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                long dvCount = tuple2._1$mcJ$sp();
                long dvCardinality = tuple2._2$mcJ$sp();
                Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(dvCount, dvCardinality);
                long dvCount2 = sp2._1$mcJ$sp();
                long dvCardinality2 = sp2._2$mcJ$sp();
                numDeletedRecordsOpt$1.elem = ((Option)numDeletedRecordsOpt$1.elem).map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)x$12 -> x$12 + dvCardinality2);
                numDeletionVectorsOpt$1.elem = ((Option)numDeletionVectorsOpt$1.elem).map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)x$13 -> x$13 + dvCount2);
                deletedRecordCountsHistogramOpt$1.foreach((Function1 & Serializable & scala.Serializable)x$14 -> {
                    x$14.insert(dvCardinality2);
                    return BoxedUnit.UNIT;
                });
                return;
            }
        }
        if (action instanceof RemoveFile) {
            bl = true;
            removeFile = (RemoveFile)action;
            Option<Object> option = removeFile.extendedFileMetadata();
            Some some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)true));
            if (!(option != null ? !option.equals((Object)some) : some != null)) {
                long size = BoxesRunTime.unboxToLong((Object)removeFile.size().get());
                tableSizeBytes$1.elem -= size;
                --numFiles$1.elem;
                Tuple2 tuple2 = (Tuple2)Option$.MODULE$.apply((Object)removeFile.deletionVector()).map((Function1 & Serializable & scala.Serializable)x$15 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)1L)), (Object)BoxesRunTime.boxToLong((long)x$15.cardinality()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)0L)), (Object)BoxesRunTime.boxToLong((long)0L)));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                long dvCount = tuple2._1$mcJ$sp();
                long dvCardinality = tuple2._2$mcJ$sp();
                Tuple2.mcJJ.sp sp3 = new Tuple2.mcJJ.sp(dvCount, dvCardinality);
                long dvCount3 = sp3._1$mcJ$sp();
                long dvCardinality3 = sp3._2$mcJ$sp();
                numDeletedRecordsOpt$1.elem = ((Option)numDeletedRecordsOpt$1.elem).map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)x$17 -> x$17 - dvCardinality3);
                numDeletionVectorsOpt$1.elem = ((Option)numDeletionVectorsOpt$1.elem).map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)x$18 -> x$18 - dvCount3);
                deletedRecordCountsHistogramOpt$1.foreach((Function1 & Serializable & scala.Serializable)x$19 -> {
                    x$19.remove(dvCardinality3);
                    return BoxedUnit.UNIT;
                });
                return;
            }
        }
        if (bl) {
            String msg = new StringBuilder(126).append("A remove action with a missing file size was detected in file ").append(removeFile.path()).append(" ").append("causing incremental commit to fallback to state reconstruction.").toString();
            DeltaLog x$1 = $this.deltaLog();
            String x$2 = "delta.checksum.compute";
            scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)msg)}));
            scala.collection.immutable.Map<TagDefinition, String> x$4 = $this.recordDeltaEvent$default$3();
            Option<Path> x$5 = $this.recordDeltaEvent$default$5();
            $this.recordDeltaEvent(x$1, x$2, x$4, x$3, x$5);
            throw new NonLocalReturnControl(nonLocalReturnKey2$1, (Object)package$.MODULE$.Left().apply((Object)"ENCOUNTERED_REMOVE_FILE_MISSING_SIZE"));
        }
        if (action instanceof Protocol) {
            Protocol protocol = (Protocol)action;
            protocol$1.elem = protocol;
            return;
        }
        if (action instanceof Metadata) {
            Metadata metadata = (Metadata)action;
            metadata$1.elem = metadata;
            return;
        }
        if (action instanceof CommitInfo) {
            CommitInfo commitInfo = (CommitInfo)action;
            inCommitTimestamp$1.elem = commitInfo.inCommitTimestamp();
            return;
        }
    }

    public static /* synthetic */ boolean $anonfun$computeNewChecksum$21(RecordChecksum $this, LongRef numFiles$1, LongRef tableSizeBytes$1, VersionChecksum oldVersionChecksum$1, Option oldSnapshot$1, Seq actions$1, long attemptVersion$1, String operationName$1, Seq files) {
        int computedNumFiles = files.size();
        long computedTableSizeBytes = BoxesRunTime.unboxToLong((Object)((TraversableOnce)files.map((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToLong((long)x$20.size()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        if ((long)computedNumFiles != numFiles$1.elem || computedTableSizeBytes != tableSizeBytes$1.elem) {
            Seq filePathsFromPreviousVersion = (Seq)((TraversableLike)oldVersionChecksum$1.allFiles().orElse((Function0 & Serializable & scala.Serializable)() -> (Option)$this.recordFrameProfile("Delta", "VersionChecksum.computeNewChecksum.allFiles", (Function0 & Serializable & scala.Serializable)() -> oldSnapshot$1.map((Function1 & Serializable & scala.Serializable)x$21 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$21.allFiles().collect())).toSeq()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$22 -> x$22.path(), Seq$.MODULE$.canBuildFrom());
            Seq addFilePathsInThisCommit = (Seq)actions$1.collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends Action, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof AddFile) {
                        AddFile addFile = (AddFile)A1;
                        return (B1)addFile.path();
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Action x1) {
                    Action action = x1;
                    return action instanceof AddFile;
                }
            }, Seq$.MODULE$.canBuildFrom());
            Seq removeFilePathsInThisCommit = (Seq)actions$1.collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends Action, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    A1 A1 = x2;
                    if (A1 instanceof RemoveFile) {
                        RemoveFile removeFile = (RemoveFile)A1;
                        return (B1)removeFile.path();
                    }
                    return (B1)function1.apply(x2);
                }

                public final boolean isDefinedAt(Action x2) {
                    Action action = x2;
                    return action instanceof RemoveFile;
                }
            }, Seq$.MODULE$.canBuildFrom());
            $this.logWarning(LogEntry$.MODULE$.from((Function0<MessageWithContext>)(Function0 & Serializable & scala.Serializable)() -> $this.LogStringContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Incrementally computed files does not match the incremental checksum "}))).log((Seq<MDC>)Nil$.MODULE$).$plus($this.LogStringContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"for commit attempt: ", ". "}))).log((Seq<MDC>)Predef$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.VERSION(), BoxesRunTime.boxToLong((long)attemptVersion$1))}))).$plus($this.LogStringContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"addFilePathsInThisCommit: [", "], "}))).log((Seq<MDC>)Predef$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.PATHS(), addFilePathsInThisCommit.mkString(","))}))).$plus($this.LogStringContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"removeFilePathsInThisCommit: [", "], "}))).log((Seq<MDC>)Predef$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.PATHS2(), removeFilePathsInThisCommit.mkString(","))}))).$plus($this.LogStringContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"filePathsFromPreviousVersion: [", "], "}))).log((Seq<MDC>)Predef$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.PATHS3(), filePathsFromPreviousVersion.mkString(","))}))).$plus($this.LogStringContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"computedFiles: [", "]"}))).log((Seq<MDC>)Predef$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.PATHS4(), ((TraversableOnce)files.map((Function1 & Serializable & scala.Serializable)x$23 -> x$23.path(), Seq$.MODULE$.canBuildFrom())).mkString(","))})))));
            scala.collection.immutable.Map eventData = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"attemptVersion"), (Object)BoxesRunTime.boxToLong((long)attemptVersion$1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expectedNumFiles"), (Object)BoxesRunTime.boxToLong((long)numFiles$1.elem)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expectedTableSizeBytes"), (Object)BoxesRunTime.boxToLong((long)tableSizeBytes$1.elem)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"computedNumFiles"), (Object)BoxesRunTime.boxToInteger((int)computedNumFiles)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"computedTableSizeBytes"), (Object)BoxesRunTime.boxToLong((long)computedTableSizeBytes)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numAddFilePathsInThisCommit"), (Object)BoxesRunTime.boxToInteger((int)addFilePathsInThisCommit.size())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numRemoveFilePathsInThisCommit"), (Object)BoxesRunTime.boxToInteger((int)removeFilePathsInThisCommit.size())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numFilesInPreviousVersion"), (Object)BoxesRunTime.boxToInteger((int)filePathsFromPreviousVersion.size())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operationName"), (Object)operationName$1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"addFilePathsInThisCommit"), (Object)JsonUtils$.MODULE$.toJson(addFilePathsInThisCommit.take(10), ManifestFactory$.MODULE$.classType(Seq.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"removeFilePathsInThisCommit"), (Object)JsonUtils$.MODULE$.toJson(removeFilePathsInThisCommit.take(10), ManifestFactory$.MODULE$.classType(Seq.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"filePathsFromPreviousVersion"), (Object)JsonUtils$.MODULE$.toJson(filePathsFromPreviousVersion.take(10), ManifestFactory$.MODULE$.classType(Seq.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"computedFiles"), (Object)JsonUtils$.MODULE$.toJson(files.take(10), ManifestFactory$.MODULE$.classType(Seq.class, ManifestFactory$.MODULE$.classType(AddFile.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0]))))}));
            DeltaLog x$6 = $this.deltaLog();
            String x$7 = "delta.allFilesInCrc.checksumMismatch.aggregated";
            scala.collection.immutable.Map x$8 = eventData;
            scala.collection.immutable.Map<TagDefinition, String> x$9 = $this.recordDeltaEvent$default$3();
            Option<Path> x$10 = $this.recordDeltaEvent$default$5();
            $this.recordDeltaEvent(x$6, x$7, x$9, x$8, x$10);
            if (Utils$.MODULE$.isTesting()) {
                throw new IllegalStateException(new StringBuilder(65).append("Incrementally Computed State failed checksum check").append(" for commit ").append(attemptVersion$1).append(" [").append(eventData).append("]").toString());
            }
            return false;
        }
        return true;
    }

    public static /* synthetic */ boolean $anonfun$incrementallyComputeSetTransactions$2(Metadata x$25) {
        return DeltaLog$.MODULE$.minSetTransactionRetentionInterval(x$25).nonEmpty();
    }

    public static /* synthetic */ boolean $anonfun$incrementallyComputeSetTransactions$4(Action x$26) {
        return x$26 instanceof SetTransaction;
    }

    public static /* synthetic */ boolean $anonfun$incrementallyComputeSetTransactions$5(long threshold$1, Seq x$27) {
        return (long)x$27.size() <= threshold$1;
    }

    public static /* synthetic */ boolean $anonfun$incrementallyComputeDomainMetadatas$2(Action x$28) {
        return x$28 instanceof DomainMetadata;
    }

    public static /* synthetic */ boolean $anonfun$incrementallyComputeDomainMetadatas$3(long threshold$2, Seq x$29) {
        return (long)x$29.size() <= threshold$2;
    }

    private static Action normalizePath$1(Action action, DeltaLog.CanonicalPathFunction canonicalPath$1) {
        Action action2 = action;
        if (action2 instanceof AddFile) {
            AddFile addFile = (AddFile)action2;
            return addFile.copy(canonicalPath$1.apply(addFile.path()), addFile.copy$default$2(), addFile.copy$default$3(), addFile.copy$default$4(), addFile.copy$default$5(), addFile.copy$default$6(), addFile.copy$default$7(), addFile.copy$default$8(), addFile.copy$default$9(), addFile.copy$default$10(), addFile.copy$default$11());
        }
        if (action2 instanceof RemoveFile) {
            RemoveFile removeFile = (RemoveFile)action2;
            return removeFile.copy(canonicalPath$1.apply(removeFile.path()), removeFile.copy$default$2(), removeFile.copy$default$3(), removeFile.copy$default$4(), removeFile.copy$default$5(), removeFile.copy$default$6(), removeFile.copy$default$7(), removeFile.copy$default$8(), removeFile.copy$default$9(), removeFile.copy$default$10(), removeFile.copy$default$11());
        }
        return action2;
    }

    public static void $init$(RecordChecksum $this) {
    }

    public static /* synthetic */ Object $anonfun$computeNewChecksum$10$adapted(RecordChecksum $this, boolean ignoreAddFiles$1, LongRef tableSizeBytes$1, LongRef numFiles$1, ObjectRef numDeletedRecordsOpt$1, ObjectRef numDeletionVectorsOpt$1, Option deletedRecordCountsHistogramOpt$1, Object nonLocalReturnKey2$1, ObjectRef protocol$1, ObjectRef metadata$1, ObjectRef inCommitTimestamp$1, Action x0$1) {
        RecordChecksum.$anonfun$computeNewChecksum$10($this, ignoreAddFiles$1, tableSizeBytes$1, numFiles$1, numDeletedRecordsOpt$1, numDeletionVectorsOpt$1, deletedRecordCountsHistogramOpt$1, nonLocalReturnKey2$1, protocol$1, metadata$1, inCommitTimestamp$1, x0$1);
        return BoxedUnit.UNIT;
    }
}

