/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.actions;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.Base64;
import java.util.UUID;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.delta.actions.Action$;
import org.apache.spark.sql.delta.actions.DeletionVectorDescriptor;
import org.apache.spark.sql.delta.actions.DeletionVectorDescriptor$;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.Codec$Base85Codec$;
import org.apache.spark.sql.delta.util.DeltaEncoder;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructType;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple6;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

public final class DeletionVectorDescriptor$
implements Serializable {
    public static DeletionVectorDescriptor$ MODULE$;
    private StructType STRUCT_TYPE;
    private DeltaEncoder<DeletionVectorDescriptor> _encoder;
    private final String DELETION_VECTOR_FILE_NAME_PREFIX;
    private final String DELETION_VECTOR_FILE_NAME_CORE;
    private final String PATH_DV_MARKER;
    private final String INLINE_DV_MARKER;
    private final String UUID_DV_MARKER;
    private final DeletionVectorDescriptor EMPTY;
    private volatile byte bitmap$0;

    static {
        new DeletionVectorDescriptor$();
    }

    public Option<Object> $lessinit$greater$default$3() {
        return None$.MODULE$;
    }

    public Option<Object> $lessinit$greater$default$6() {
        return None$.MODULE$;
    }

    public String DELETION_VECTOR_FILE_NAME_PREFIX() {
        return this.DELETION_VECTOR_FILE_NAME_PREFIX;
    }

    public String DELETION_VECTOR_FILE_NAME_CORE() {
        return this.DELETION_VECTOR_FILE_NAME_CORE;
    }

    public final String PATH_DV_MARKER() {
        return this.PATH_DV_MARKER;
    }

    public final String INLINE_DV_MARKER() {
        return this.INLINE_DV_MARKER;
    }

    public final String UUID_DV_MARKER() {
        return this.UUID_DV_MARKER;
    }

    private StructType STRUCT_TYPE$lzycompute() {
        DeletionVectorDescriptor$ deletionVectorDescriptor$ = this;
        synchronized (deletionVectorDescriptor$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.STRUCT_TYPE = (StructType)Action$.MODULE$.addFileSchema().apply("deletionVector").dataType();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.STRUCT_TYPE;
    }

    public final StructType STRUCT_TYPE() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.STRUCT_TYPE$lzycompute();
        }
        return this.STRUCT_TYPE;
    }

    private DeltaEncoder<DeletionVectorDescriptor> _encoder$lzycompute() {
        DeletionVectorDescriptor$ deletionVectorDescriptor$ = this;
        synchronized (deletionVectorDescriptor$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
                public final class Org_apache_spark_sql_delta_actions_DeletionVectorDescriptor$$typecreator1$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.sql.delta.actions.DeletionVectorDescriptor").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_sql_delta_actions_DeletionVectorDescriptor$$typecreator1$1() {
                    }
                }
                this._encoder = new DeltaEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_delta_actions_DeletionVectorDescriptor$$typecreator1$1()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this._encoder;
    }

    private DeltaEncoder<DeletionVectorDescriptor> _encoder() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this._encoder$lzycompute();
        }
        return this._encoder;
    }

    public Encoder<DeletionVectorDescriptor> encoder() {
        return this._encoder().get();
    }

    public DeletionVectorDescriptor onDiskWithRelativePath(UUID id, String randomPrefix, int sizeInBytes, long cardinality, Option<Object> offset, Option<Object> maxRowIndex) {
        return new DeletionVectorDescriptor(this.UUID_DV_MARKER(), this.encodeUUID(id, randomPrefix), offset, sizeInBytes, cardinality, maxRowIndex);
    }

    public String onDiskWithRelativePath$default$2() {
        return "";
    }

    public Option<Object> onDiskWithRelativePath$default$5() {
        return None$.MODULE$;
    }

    public Option<Object> onDiskWithRelativePath$default$6() {
        return None$.MODULE$;
    }

    public DeletionVectorDescriptor onDiskWithAbsolutePath(String path, int sizeInBytes, long cardinality, Option<Object> offset, Option<Object> maxRowIndex) {
        return new DeletionVectorDescriptor(this.PATH_DV_MARKER(), path, offset, sizeInBytes, cardinality, maxRowIndex);
    }

    public Option<Object> onDiskWithAbsolutePath$default$4() {
        return None$.MODULE$;
    }

    public Option<Object> onDiskWithAbsolutePath$default$5() {
        return None$.MODULE$;
    }

    public DeletionVectorDescriptor inlineInLog(byte[] data, long cardinality) {
        String x$1 = this.INLINE_DV_MARKER();
        String x$2 = this.encodeData(data);
        int x$3 = data.length;
        long x$4 = cardinality;
        Option<Object> x$5 = this.apply$default$3();
        Option<Object> x$6 = this.apply$default$6();
        return new DeletionVectorDescriptor(x$1, x$2, x$5, x$3, x$4, x$6);
    }

    public Column uniqueIdExpression(Column deletionVectorCol) {
        return functions$.MODULE$.when(deletionVectorCol.apply((Object)"offset").isNotNull(), (Object)functions$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{deletionVectorCol.apply((Object)"storageType"), deletionVectorCol.apply((Object)"pathOrInlineDv"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToCharacter((char)'@')), deletionVectorCol.apply((Object)"offset")}))).otherwise((Object)functions$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{deletionVectorCol.apply((Object)"storageType"), deletionVectorCol.apply((Object)"pathOrInlineDv")})));
    }

    public Path assembleDeletionVectorPath(Path targetParentPath, UUID id, String prefix) {
        String fileName = new StringBuilder(5).append(this.DELETION_VECTOR_FILE_NAME_CORE()).append("_").append(id).append(".bin").toString();
        if (new StringOps(Predef$.MODULE$.augmentString(prefix)).nonEmpty()) {
            return new Path(new Path(targetParentPath, prefix), fileName);
        }
        return new Path(targetParentPath, fileName);
    }

    public String assembleDeletionVectorPath$default$3() {
        return "";
    }

    public DeletionVectorDescriptor EMPTY() {
        return this.EMPTY;
    }

    public String encodeUUID(UUID id, String randomPrefix) {
        String uuidData = Codec$Base85Codec$.MODULE$.encodeUUID(id);
        Predef$.MODULE$.assert(uuidData.length() == 20);
        return new StringBuilder(0).append(randomPrefix).append(uuidData).toString();
    }

    public String encodeData(byte[] bytes) {
        return Codec$Base85Codec$.MODULE$.encodeBytes(bytes);
    }

    public DeletionVectorDescriptor deserializeFromBase64(String encoded) {
        DeletionVectorDescriptor deletionVectorDescriptor;
        byte[] buffer = Base64.getDecoder().decode(encoded);
        try (DataInputStream ds = new DataInputStream(new ByteArrayInputStream(buffer));){
            String storageType;
            long cardinality = ds.readLong();
            int sizeInBytes = ds.readInt();
            String string = storageType = Character.toString((char)ds.readByte());
            String string2 = this.INLINE_DV_MARKER();
            None$ offset = (string == null ? string2 != null : !string.equals(string2)) ? new Some((Object)BoxesRunTime.boxToInteger((int)ds.readInt())) : None$.MODULE$;
            String pathOrInlineDv = ds.readUTF();
            deletionVectorDescriptor = new DeletionVectorDescriptor(storageType, pathOrInlineDv, (Option<Object>)offset, sizeInBytes, cardinality, this.apply$default$6());
        }
        return deletionVectorDescriptor;
    }

    public DeletionVectorDescriptor apply(String storageType, String pathOrInlineDv, Option<Object> offset, int sizeInBytes, long cardinality, Option<Object> maxRowIndex) {
        return new DeletionVectorDescriptor(storageType, pathOrInlineDv, offset, sizeInBytes, cardinality, maxRowIndex);
    }

    public Option<Object> apply$default$3() {
        return None$.MODULE$;
    }

    public Option<Object> apply$default$6() {
        return None$.MODULE$;
    }

    public Option<Tuple6<String, String, Option<Object>, Object, Object, Option<Object>>> unapply(DeletionVectorDescriptor x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple6((Object)x$0.storageType(), (Object)x$0.pathOrInlineDv(), x$0.offset(), (Object)BoxesRunTime.boxToInteger((int)x$0.sizeInBytes()), (Object)BoxesRunTime.boxToLong((long)x$0.cardinality()), x$0.maxRowIndex()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private DeletionVectorDescriptor$() {
        MODULE$ = this;
        this.DELETION_VECTOR_FILE_NAME_PREFIX = (String)SQLConf$.MODULE$.get().getConf(DeltaSQLConf$.MODULE$.TEST_DV_NAME_PREFIX());
        this.DELETION_VECTOR_FILE_NAME_CORE = new StringBuilder(15).append(this.DELETION_VECTOR_FILE_NAME_PREFIX()).append("deletion_vector").toString();
        this.PATH_DV_MARKER = "p";
        this.INLINE_DV_MARKER = "i";
        this.UUID_DV_MARKER = "u";
        String x$1 = this.INLINE_DV_MARKER();
        String x$2 = "";
        int x$3 = 0;
        long x$4 = 0L;
        Option<Object> x$5 = this.apply$default$3();
        Option<Object> x$6 = this.apply$default$6();
        this.EMPTY = new DeletionVectorDescriptor(x$1, x$2, x$5, x$3, x$4, x$6);
    }
}

