/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.LoggingShims;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaOptions;
import org.apache.spark.sql.delta.DeltaParquetFileFormat;
import org.apache.spark.sql.delta.DeltaParquetFileFormat$;
import org.apache.spark.sql.delta.OptimisticTransaction;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.FileAction;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.actions.RemoveFile;
import org.apache.spark.sql.delta.actions.SetTransaction;
import org.apache.spark.sql.delta.catalog.DeltaTableV2;
import org.apache.spark.sql.delta.commands.DeletionVectorBitmapGenerator$;
import org.apache.spark.sql.delta.commands.DeletionVectorResult;
import org.apache.spark.sql.delta.commands.DeltaCommand;
import org.apache.spark.sql.delta.commands.TouchedFileWithDV;
import org.apache.spark.sql.delta.files.TahoeBatchFileIndex;
import org.apache.spark.sql.delta.files.TahoeFileIndex;
import org.apache.spark.sql.delta.implicits.package$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.stats.StatsCollectionUtils$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelationWithTable$;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class DMLWithDeletionVectorsHelper$
implements DeltaCommand {
    public static DMLWithDeletionVectorsHelper$ MODULE$;
    private final Seq<String> SUPPORTED_DML_COMMANDS;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new DMLWithDeletionVectorsHelper$();
    }

    @Override
    public Seq<Expression> parsePredicates(SparkSession spark, String predicate) {
        return DeltaCommand.parsePredicates$(this, spark, predicate);
    }

    @Override
    public void verifyPartitionPredicates(SparkSession spark, Seq<String> partitionColumns, Seq<Expression> predicates) {
        DeltaCommand.verifyPartitionPredicates$(this, spark, partitionColumns, predicates);
    }

    @Override
    public Map<String, AddFile> generateCandidateFileMap(Path basePath, Seq<AddFile> candidateFiles) {
        return DeltaCommand.generateCandidateFileMap$(this, basePath, candidateFiles);
    }

    @Override
    public Seq<RemoveFile> removeFilesFromPaths(DeltaLog deltaLog, Map<String, AddFile> nameToAddFileMap, Seq<String> filesToRewrite, long operationTimestamp) {
        return DeltaCommand.removeFilesFromPaths$(this, deltaLog, nameToAddFileMap, filesToRewrite, operationTimestamp);
    }

    @Override
    public HadoopFsRelation buildBaseRelation(SparkSession spark, OptimisticTransaction txn, String actionType, Path rootPath, Seq<String> inputLeafFiles, Map<String, AddFile> nameToAddFileMap) {
        return DeltaCommand.buildBaseRelation$(this, spark, txn, actionType, rootPath, inputLeafFiles, nameToAddFileMap);
    }

    @Override
    public AddFile getTouchedFile(Path basePath, String escapedFilePath, Map<String, AddFile> nameToAddFileMap) {
        return DeltaCommand.getTouchedFile$(this, basePath, escapedFilePath, nameToAddFileMap);
    }

    @Override
    public LogicalPlan resolveIdentifier(Analyzer analyzer, TableIdentifier identifier) {
        return DeltaCommand.resolveIdentifier$(this, analyzer, identifier);
    }

    @Override
    public boolean isCatalogTable(Analyzer analyzer, TableIdentifier tableIdent) {
        return DeltaCommand.isCatalogTable$(this, analyzer, tableIdent);
    }

    @Override
    public boolean isPathIdentifier(TableIdentifier tableIdent) {
        return DeltaCommand.isPathIdentifier$(this, tableIdent);
    }

    @Override
    public DeltaLog getDeltaLog(SparkSession spark, Option<String> path, Option<TableIdentifier> tableIdentifier, String operationName, Map<String, String> hadoopConf) {
        return DeltaCommand.getDeltaLog$(this, spark, path, tableIdentifier, operationName, hadoopConf);
    }

    @Override
    public Map<String, String> getDeltaLog$default$5() {
        return DeltaCommand.getDeltaLog$default$5$(this);
    }

    @Override
    public void sendDriverMetrics(SparkSession spark, Map<String, SQLMetric> metrics) {
        DeltaCommand.sendDriverMetrics$(this, spark, metrics);
    }

    @Override
    public DeltaTableV2 getDeltaTable(LogicalPlan target, String cmd) {
        return DeltaCommand.getDeltaTable$(this, target, cmd);
    }

    @Override
    public Option<CatalogTable> getTableCatalogTable(LogicalPlan target, String cmd) {
        return DeltaCommand.getTableCatalogTable$(this, target, cmd);
    }

    @Override
    public Tuple2<Option<TableIdentifier>, Option<String>> getDeltaTablePathOrIdentifier(LogicalPlan target, String cmd) {
        return DeltaCommand.getDeltaTablePathOrIdentifier$(this, target, cmd);
    }

    @Override
    public Tuple2<Option<TableIdentifier>, Option<String>> getTablePathOrIdentifier(LogicalPlan target, String cmd) {
        return DeltaCommand.getTablePathOrIdentifier$(this, target, cmd);
    }

    @Override
    public boolean hasBeenExecuted(OptimisticTransaction txn, SparkSession sparkSession, Option<DeltaOptions> options) {
        return DeltaCommand.hasBeenExecuted$(this, txn, sparkSession, options);
    }

    @Override
    public Option<DeltaOptions> hasBeenExecuted$default$3() {
        return DeltaCommand.hasBeenExecuted$default$3$(this);
    }

    @Override
    public Option<SetTransaction> createSetTransaction(SparkSession sparkSession, DeltaLog deltaLog, Option<DeltaOptions> options) {
        return DeltaCommand.createSetTransaction$(this, sparkSession, deltaLog, options);
    }

    @Override
    public Option<DeltaOptions> createSetTransaction$default$3() {
        return DeltaCommand.createSetTransaction$default$3$(this);
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void deltaAssert(Function0<Object> check, String name, String msg, DeltaLog deltaLog, Object data, Option<Path> path) {
        DeltaLogging.deltaAssert$(this, check, name, msg, deltaLog, data, path);
    }

    @Override
    public DeltaLog deltaAssert$default$4() {
        return DeltaLogging.deltaAssert$default$4$(this);
    }

    @Override
    public Object deltaAssert$default$5() {
        return DeltaLogging.deltaAssert$default$5$(this);
    }

    @Override
    public Option<Path> deltaAssert$default$6() {
        return DeltaLogging.deltaAssert$default$6$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public Map<String, Object> getErrorData(Throwable e) {
        return DeltaLogging.getErrorData$(this, e);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    @Override
    public LoggingShims.LogStringContext LogStringContext(StringContext sc) {
        return LoggingShims.LogStringContext$(this, sc);
    }

    @Override
    public void logInfo(LogEntry entry) {
        LoggingShims.logInfo$(this, entry);
    }

    @Override
    public void logInfo(LogEntry entry, Throwable throwable) {
        LoggingShims.logInfo$(this, entry, throwable);
    }

    @Override
    public void logDebug(LogEntry entry) {
        LoggingShims.logDebug$(this, entry);
    }

    @Override
    public void logDebug(LogEntry entry, Throwable throwable) {
        LoggingShims.logDebug$(this, entry, throwable);
    }

    @Override
    public void logTrace(LogEntry entry) {
        LoggingShims.logTrace$(this, entry);
    }

    @Override
    public void logTrace(LogEntry entry, Throwable throwable) {
        LoggingShims.logTrace$(this, entry, throwable);
    }

    @Override
    public void logWarning(LogEntry entry) {
        LoggingShims.logWarning$(this, entry);
    }

    @Override
    public void logWarning(LogEntry entry, Throwable throwable) {
        LoggingShims.logWarning$(this, entry, throwable);
    }

    @Override
    public void logError(LogEntry entry) {
        LoggingShims.logError$(this, entry);
    }

    @Override
    public void logError(LogEntry entry, Throwable throwable) {
        LoggingShims.logError$(this, entry, throwable);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Seq<String> SUPPORTED_DML_COMMANDS() {
        return this.SUPPORTED_DML_COMMANDS;
    }

    public Dataset<Row> createTargetDfForScanningForMatches(SparkSession spark, LogicalPlan target, TahoeFileIndex fileIndex) {
        return Dataset$.MODULE$.ofRows(spark, this.replaceFileIndex(spark, target, fileIndex));
    }

    private LogicalPlan replaceFileIndex(SparkSession spark, LogicalPlan target, TahoeFileIndex fileIndex) {
        boolean useMetadataRowIndex = BoxesRunTime.unboxToBoolean((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELETION_VECTORS_USE_METADATA_ROW_INDEX()));
        String x$1 = DeltaParquetFileFormat$.MODULE$.ROW_INDEX_COLUMN_NAME();
        DataType x$2 = DeltaParquetFileFormat$.MODULE$.ROW_INDEX_STRUCT_FIELD().dataType();
        boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, x$2, x$3, x$4);
        Seq x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, x$2, x$3, x$4);
        AttributeReference rowIndexCol = new AttributeReference(x$1, x$2, x$3, x$4, x$5, x$6);
        ObjectRef fileMetadataCol = ObjectRef.create(null);
        LogicalPlan newTarget = (LogicalPlan)target.transformUp((PartialFunction)new scala.Serializable(fileMetadataCol, useMetadataRowIndex, fileIndex, rowIndexCol){
            public static final long serialVersionUID = 0L;
            private final ObjectRef fileMetadataCol$1;
            private final boolean useMetadataRowIndex$1;
            private final TahoeFileIndex fileIndex$1;
            private final AttributeReference rowIndexCol$1;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                HadoopFsRelation hadoopFsRelation;
                FileFormat format;
                BaseRelation hfsr;
                LogicalRelation logicalRelation;
                Option<Tuple2<BaseRelation, Option<CatalogTable>>> option;
                A1 A1 = x1;
                if (A1 instanceof LogicalRelation && !(option = LogicalRelationWithTable$.MODULE$.unapply(logicalRelation = (LogicalRelation)A1)).isEmpty() && (hfsr = (BaseRelation)((Tuple2)option.get())._1()) instanceof HadoopFsRelation && (format = (hadoopFsRelation = (HadoopFsRelation)hfsr).fileFormat()) instanceof DeltaParquetFileFormat) {
                    DeltaParquetFileFormat deltaParquetFileFormat = (DeltaParquetFileFormat)format;
                    this.fileMetadataCol$1.elem = deltaParquetFileFormat.createFileMetadataCol();
                    if (this.useMetadataRowIndex$1) {
                        return (B1)logicalRelation.copy((BaseRelation)hadoopFsRelation.copy((FileIndex)this.fileIndex$1, hadoopFsRelation.copy$default$2(), hadoopFsRelation.copy$default$3(), hadoopFsRelation.copy$default$4(), hadoopFsRelation.copy$default$5(), hadoopFsRelation.copy$default$6(), hadoopFsRelation.sparkSession()), (Seq)logicalRelation.output().$colon$plus((Object)((AttributeReference)this.fileMetadataCol$1.elem), Seq$.MODULE$.canBuildFrom()), logicalRelation.copy$default$3(), logicalRelation.copy$default$4());
                    }
                    StructType newDataSchema = StructType$.MODULE$.apply((Seq)hadoopFsRelation.dataSchema()).add(DeltaParquetFileFormat$.MODULE$.ROW_INDEX_STRUCT_FIELD());
                    Seq finalOutput = (Seq)logicalRelation.output().$plus$plus((GenTraversableOnce)new .colon.colon((Object)this.rowIndexCol$1, (List)new .colon.colon((Object)((AttributeReference)this.fileMetadataCol$1.elem), (List)Nil$.MODULE$)), Seq$.MODULE$.canBuildFrom());
                    boolean x$1 = false;
                    Protocol x$2 = deltaParquetFileFormat.copy$default$1();
                    org.apache.spark.sql.delta.actions.Metadata x$3 = deltaParquetFileFormat.copy$default$2();
                    boolean x$4 = deltaParquetFileFormat.copy$default$3();
                    Option<String> x$5 = deltaParquetFileFormat.copy$default$5();
                    boolean x$6 = deltaParquetFileFormat.copy$default$6();
                    DeltaParquetFileFormat newFormat = deltaParquetFileFormat.copy(x$2, x$3, x$4, x$1, x$5, x$6);
                    TahoeFileIndex x$7 = this.fileIndex$1;
                    StructType x$8 = newDataSchema;
                    DeltaParquetFileFormat x$9 = newFormat;
                    StructType x$10 = hadoopFsRelation.copy$default$2();
                    Option x$11 = hadoopFsRelation.copy$default$4();
                    Map x$12 = hadoopFsRelation.copy$default$6();
                    SparkSession x$13 = hadoopFsRelation.sparkSession();
                    HadoopFsRelation newBaseRelation = hadoopFsRelation.copy((FileIndex)x$7, x$10, x$8, x$11, (FileFormat)x$9, x$12, x$13);
                    return (B1)logicalRelation.copy((BaseRelation)newBaseRelation, finalOutput, logicalRelation.copy$default$3(), logicalRelation.copy$default$4());
                }
                if (A1 instanceof Project) {
                    Project project = (Project)A1;
                    Seq projectList = project.projectList();
                    if ((AttributeReference)this.fileMetadataCol$1.elem == null) {
                        throw new IllegalStateException("File metadata column is not yet created.");
                    }
                    None$ rowIndexColOpt = this.useMetadataRowIndex$1 ? None$.MODULE$ : new Some((Object)this.rowIndexCol$1);
                    Seq additionalColumns = (Seq)((TraversableLike)new .colon.colon((Object)((AttributeReference)this.fileMetadataCol$1.elem), (List)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable((Option)rowIndexColOpt), Seq$.MODULE$.canBuildFrom());
                    return (B1)project.copy((Seq)projectList.$plus$plus((GenTraversableOnce)additionalColumns, Seq$.MODULE$.canBuildFrom()), project.copy$default$2());
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                HadoopFsRelation hadoopFsRelation;
                FileFormat format;
                BaseRelation hfsr;
                LogicalRelation logicalRelation;
                Option<Tuple2<BaseRelation, Option<CatalogTable>>> option;
                LogicalPlan logicalPlan = x1;
                if (logicalPlan instanceof LogicalRelation && !(option = LogicalRelationWithTable$.MODULE$.unapply(logicalRelation = (LogicalRelation)logicalPlan)).isEmpty() && (hfsr = (BaseRelation)((Tuple2)option.get())._1()) instanceof HadoopFsRelation && (format = (hadoopFsRelation = (HadoopFsRelation)hfsr).fileFormat()) instanceof DeltaParquetFileFormat) {
                    return true;
                }
                return logicalPlan instanceof Project;
            }
            {
                this.fileMetadataCol$1 = fileMetadataCol$1;
                this.useMetadataRowIndex$1 = useMetadataRowIndex$1;
                this.fileIndex$1 = fileIndex$1;
                this.rowIndexCol$1 = rowIndexCol$1;
            }
        });
        return newTarget;
    }

    public Seq<TouchedFileWithDV> findTouchedFiles(SparkSession sparkSession, OptimisticTransaction txn, boolean hasDVsEnabled, DeltaLog deltaLog, Dataset<Row> targetDf, TahoeFileIndex fileIndex, Expression condition, String opName) {
        Predef$.MODULE$.require(this.SUPPORTED_DML_COMMANDS().contains((Object)opName), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Expecting opName to be one of ").append(MODULE$.SUPPORTED_DML_COMMANDS().mkString(", ")).append(", ").append("but got '").append(opName).append("'.").toString());
        return (Seq)this.recordDeltaOperation(deltaLog, new StringBuilder(17).append(opName).append(".findTouchedFiles").toString(), this.recordDeltaOperation$default$3(), (Function0 & Serializable & scala.Serializable)() -> {
            TahoeFileIndex tahoeFileIndex = fileIndex;
            if (!(tahoeFileIndex instanceof TahoeBatchFileIndex)) {
                throw new IllegalArgumentException("Unexpected file index found!");
            }
            TahoeBatchFileIndex tahoeBatchFileIndex = (TahoeBatchFileIndex)tahoeFileIndex;
            Seq<AddFile> candidateFiles = tahoeBatchFileIndex.addFiles();
            Seq<DeletionVectorResult> matchedRowIndexSets = DeletionVectorBitmapGenerator$.MODULE$.buildRowIndexSetsForFilesMatchingCondition(sparkSession, txn, hasDVsEnabled, targetDf, candidateFiles, condition, DeletionVectorBitmapGenerator$.MODULE$.buildRowIndexSetsForFilesMatchingCondition$default$7(), DeletionVectorBitmapGenerator$.MODULE$.buildRowIndexSetsForFilesMatchingCondition$default$8());
            Map<String, AddFile> nameToAddFileMap = MODULE$.generateCandidateFileMap(txn.deltaLog().dataPath(), candidateFiles);
            return MODULE$.findFilesWithMatchingRows(txn, nameToAddFileMap, matchedRowIndexSets);
        });
    }

    public Seq<TouchedFileWithDV> findFilesWithMatchingRows(OptimisticTransaction txn, Map<String, AddFile> nameToAddFileMap, Seq<DeletionVectorResult> matchedFileRowIndexSets) {
        Path dataPath = txn.deltaLog().dataPath();
        Seq touchedFilesWithMatchedRowIndices = (Seq)matchedFileRowIndexSets.map((Function1 & Serializable & scala.Serializable)fileRowIndex -> {
            String filePath = fileRowIndex.filePath();
            AddFile addFile = MODULE$.getTouchedFile(dataPath, filePath, nameToAddFileMap);
            return new TouchedFileWithDV(filePath, addFile, fileRowIndex.deletionVector(), fileRowIndex.matchedRowCount());
        }, Seq$.MODULE$.canBuildFrom());
        this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("findTouchedFiles: matched files:\n\t").append(((TraversableOnce)touchedFilesWithMatchedRowIndices.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.inputFilePath(), Seq$.MODULE$.canBuildFrom())).mkString("\n\t")).toString());
        return (Seq)touchedFilesWithMatchedRowIndices.filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isUnchanged()));
    }

    public Tuple2<Seq<FileAction>, Map<String, Object>> processUnmodifiedData(SparkSession spark, Seq<TouchedFileWithDV> touchedFiles, Snapshot snapshot) {
        long numModifiedRows = BoxesRunTime.unboxToLong((Object)((TraversableOnce)touchedFiles.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.numberOfModifiedRows()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        long numRemovedFiles = touchedFiles.count((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isFullyReplaced()));
        Tuple2 tuple2 = touchedFiles.partition((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isFullyReplaced()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq fullyRemovedFiles = (Seq)tuple2._1();
        Seq notFullyRemovedFiles = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)fullyRemovedFiles, (Object)notFullyRemovedFiles);
        Seq fullyRemovedFiles2 = (Seq)tuple22._1();
        Seq notFullyRemovedFiles2 = (Seq)tuple22._2();
        long timestamp = System.currentTimeMillis();
        Seq fullyRemoved = (Seq)fullyRemovedFiles2.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.fileLogEntry().removeWithTimestamp(timestamp, x$7.fileLogEntry().removeWithTimestamp$default$2()), Seq$.MODULE$.canBuildFrom());
        Seq dvUpdates = (Seq)notFullyRemovedFiles2.map((Function1 & Serializable & scala.Serializable)fileWithDVInfo -> fileWithDVInfo.fileLogEntry().removeRows(fileWithDVInfo.newDeletionVector(), false, fileWithDVInfo.fileLogEntry().removeRows$default$3()), Seq$.MODULE$.canBuildFrom());
        Tuple2 tuple23 = dvUpdates.unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        Seq dvAddFiles = (Seq)tuple23._1();
        Seq dvRemoveFiles = (Seq)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)dvAddFiles, (Object)dvRemoveFiles);
        Seq dvAddFiles2 = (Seq)tuple24._1();
        Seq dvRemoveFiles2 = (Seq)tuple24._2();
        Seq<AddFile> dvAddFilesWithStats = this.getActionsWithStats(spark, (Seq<AddFile>)dvAddFiles2, snapshot);
        Tuple3 tuple3 = (Tuple3)dvUpdates.foldLeft((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToLong((long)0L)), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Tuple3 tuple3 = (Tuple3)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple3 != null) {
                    long added = BoxesRunTime.unboxToLong((Object)tuple3._1());
                    long removed = BoxesRunTime.unboxToLong((Object)tuple3._2());
                    long updated = BoxesRunTime.unboxToLong((Object)tuple3._3());
                    if (tuple22 != null) {
                        AddFile addFile = (AddFile)tuple22._1();
                        RemoveFile removeFile = (RemoveFile)tuple22._2();
                        Tuple2 tuple23 = new Tuple2((Object)Option$.MODULE$.apply((Object)addFile.deletionVector()), (Object)Option$.MODULE$.apply((Object)removeFile.deletionVector()));
                        if (tuple23 != null) {
                            Option option = (Option)tuple23._1();
                            Option option2 = (Option)tuple23._2();
                            if (option instanceof Some && option2 instanceof Some) {
                                return new Tuple3((Object)BoxesRunTime.boxToLong((long)added), (Object)BoxesRunTime.boxToLong((long)removed), (Object)BoxesRunTime.boxToLong((long)(updated + 1L)));
                            }
                        }
                        if (tuple23 != null) {
                            Option option = (Option)tuple23._1();
                            Option option3 = (Option)tuple23._2();
                            if (None$.MODULE$.equals(option) && option3 instanceof Some) {
                                return new Tuple3((Object)BoxesRunTime.boxToLong((long)added), (Object)BoxesRunTime.boxToLong((long)(removed + 1L)), (Object)BoxesRunTime.boxToLong((long)updated));
                            }
                        }
                        if (tuple23 != null) {
                            Option option = (Option)tuple23._1();
                            Option option4 = (Option)tuple23._2();
                            if (option instanceof Some && None$.MODULE$.equals(option4)) {
                                return new Tuple3((Object)BoxesRunTime.boxToLong((long)(added + 1L)), (Object)BoxesRunTime.boxToLong((long)removed), (Object)BoxesRunTime.boxToLong((long)updated));
                            }
                        }
                        return new Tuple3((Object)BoxesRunTime.boxToLong((long)added), (Object)BoxesRunTime.boxToLong((long)removed), (Object)BoxesRunTime.boxToLong((long)updated));
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        });
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        long numDeletionVectorsAdded = BoxesRunTime.unboxToLong((Object)tuple3._1());
        long numDeletionVectorsRemoved = BoxesRunTime.unboxToLong((Object)tuple3._2());
        long numDeletionVectorsUpdated = BoxesRunTime.unboxToLong((Object)tuple3._3());
        Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToLong((long)numDeletionVectorsAdded), (Object)BoxesRunTime.boxToLong((long)numDeletionVectorsRemoved), (Object)BoxesRunTime.boxToLong((long)numDeletionVectorsUpdated));
        long numDeletionVectorsAdded2 = BoxesRunTime.unboxToLong((Object)tuple32._1());
        long numDeletionVectorsRemoved2 = BoxesRunTime.unboxToLong((Object)tuple32._2());
        long numDeletionVectorsUpdated2 = BoxesRunTime.unboxToLong((Object)tuple32._3());
        Map metricMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numModifiedRows"), (Object)BoxesRunTime.boxToLong((long)numModifiedRows)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numRemovedFiles"), (Object)BoxesRunTime.boxToLong((long)numRemovedFiles)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numDeletionVectorsAdded"), (Object)BoxesRunTime.boxToLong((long)numDeletionVectorsAdded2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numDeletionVectorsRemoved"), (Object)BoxesRunTime.boxToLong((long)(numDeletionVectorsRemoved2 += (long)fullyRemoved.count((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)DMLWithDeletionVectorsHelper$.$anonfun$processUnmodifiedData$7(x$10)))))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numDeletionVectorsUpdated"), (Object)BoxesRunTime.boxToLong((long)numDeletionVectorsUpdated2))}));
        return new Tuple2(((TraversableLike)fullyRemoved.$plus$plus(dvAddFilesWithStats, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)dvRemoveFiles2, Seq$.MODULE$.canBuildFrom()), (Object)metricMap);
    }

    private Seq<AddFile> getActionsWithStats(SparkSession spark, Seq<AddFile> addFilesWithNewDvs, Snapshot snapshot) {
        Seq seq;
        String statsColName;
        if (addFilesWithNewDvs.isEmpty()) {
            return (Seq)Nil$.MODULE$;
        }
        Seq selectionPathAndStatsCols = (Seq)new .colon.colon((Object)functions$.MODULE$.col("path"), (List)new .colon.colon((Object)functions$.MODULE$.col("stats"), (List)Nil$.MODULE$));
        Dataset<Row> addFilesWithNewDvsDf = package$.MODULE$.RichAddFileSeq(addFilesWithNewDvs).toDF(spark);
        Dataset addFileWithStatsDf = snapshot.withStats().join(addFilesWithNewDvsDf.select("path", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])), "path");
        Dataset<Row> addFilesWithWideBoundsDf = snapshot.updateStatsToWideBounds((Dataset<Row>)addFileWithStatsDf, statsColName = snapshot.getBaseStatsColumnName());
        Tuple2 tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])addFilesWithWideBoundsDf.as(package$.MODULE$.addFileEncoder()).collect())).toSeq().partition((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)DMLWithDeletionVectorsHelper$.$anonfun$getActionsWithStats$1(x$11)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq filesWithNoStats = (Seq)tuple2._1();
        Seq filesWithExistingStats = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)filesWithNoStats, (Object)filesWithExistingStats);
        Seq filesWithNoStats2 = (Seq)tuple22._1();
        Seq filesWithExistingStats2 = (Seq)tuple22._2();
        if (filesWithNoStats2.nonEmpty()) {
            SparkSession x$1 = spark;
            Configuration x$2 = snapshot.deltaLog().newDeltaHadoopConf();
            DeltaLog x$3 = snapshot.deltaLog();
            Snapshot x$4 = snapshot;
            Dataset<AddFile> x$5 = package$.MODULE$.RichAddFileSeq((Seq<AddFile>)filesWithNoStats2).toDS(spark);
            Some x$6 = new Some((Object)BoxesRunTime.boxToLong((long)filesWithNoStats2.size()));
            boolean x$7 = true;
            boolean x$8 = StatsCollectionUtils$.MODULE$.computeStats$default$7();
            seq = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])StatsCollectionUtils$.MODULE$.computeStats(x$1, x$2, x$3, x$4, x$5, (Option<Object>)x$6, x$8, x$7).collect())).toSeq();
        } else {
            seq = (Seq)Nil$.MODULE$;
        }
        Seq filesWithFetchedStats = seq;
        Dataset<Row> allAddFilesWithUpdatedStats = package$.MODULE$.RichAddFileSeq((Seq<AddFile>)((SeqLike)filesWithExistingStats2.$plus$plus((GenTraversableOnce)filesWithFetchedStats, Seq$.MODULE$.canBuildFrom())).toSeq()).toDF(spark);
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])addFilesWithNewDvsDf.drop("stats").join(allAddFilesWithUpdatedStats.select(selectionPathAndStatsCols), "path").as(package$.MODULE$.addFileEncoder()).collect())).toSeq();
    }

    public static final /* synthetic */ boolean $anonfun$processUnmodifiedData$7(RemoveFile x$10) {
        return x$10.deletionVector() != null;
    }

    public static final /* synthetic */ boolean $anonfun$getActionsWithStats$1(AddFile x$11) {
        return x$11.numPhysicalRecords().isEmpty();
    }

    private DMLWithDeletionVectorsHelper$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        LoggingShims.$init$(this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
        DeltaCommand.$init$(this);
        this.SUPPORTED_DML_COMMANDS = (Seq)new .colon.colon((Object)"DELETE", (List)new .colon.colon((Object)"UPDATE", (List)Nil$.MODULE$));
    }
}

