/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands.merge;

import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.FileSourceOptions$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.optimizer.EliminateResolvedHint$;
import org.apache.spark.sql.catalyst.plans.logical.DeltaMergeIntoMatchedClause;
import org.apache.spark.sql.catalyst.plans.logical.DeltaMergeIntoNotMatchedClause;
import org.apache.spark.sql.catalyst.plans.logical.HintInfo;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.ResolvedHint;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.commands.merge.MergeIntoMaterializeSource$;
import org.apache.spark.sql.delta.commands.merge.MergeIntoMaterializeSource$RetryHandling$;
import org.apache.spark.sql.delta.commands.merge.MergeIntoMaterializeSourceError;
import org.apache.spark.sql.delta.commands.merge.MergeIntoMaterializeSourceError$;
import org.apache.spark.sql.delta.commands.merge.MergeIntoMaterializeSourceErrorType$;
import org.apache.spark.sql.delta.commands.merge.MergeIntoMaterializeSourceReason$;
import org.apache.spark.sql.delta.logging.DeltaLogKeys$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.DeltaSparkPlanUtils;
import org.apache.spark.sql.execution.LogicalRDD;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\r5da\u0002\u001e<!\u0003\r\tA\u0013\u0005\u0006;\u0002!\tA\u0018\u0005\bE\u0002\u0001\r\u0011\"\u0003d\u0011%\u0011i\u0007\u0001a\u0001\n\u0013\u0011y\u0007C\u0005\u0003t\u0001\u0001\r\u0011\"\u0005\u0003v!I!Q\u0012\u0001A\u0002\u0013E!q\u0012\u0005\n\u0005'\u0003\u0001\u0019!C\t\u0003\u0013C\u0011B!&\u0001\u0001\u0004%\tBa&\t\u000f\tm\u0005\u0001\"\u0005\u0003\u001e\u001e9!\u0011\u001d\u0001\t\u0002\t\rha\u0002Bt\u0001!\u0005!\u0011\u001e\u0005\u0007[*!\tA!=\u0006\r\tM(\u0002\u0001B{\u0011%\u0011iP\u0003b\u0001\n\u0003\u0011y\u0010\u0003\u0005\u0004\u0002)\u0001\u000b\u0011\u0002B{\u0011%\u0019\u0019A\u0003b\u0001\n\u0003\u0011y\u0010\u0003\u0005\u0004\u0006)\u0001\u000b\u0011\u0002B{\u0011%\u00199A\u0003b\u0001\n\u0003\u0011y\u0010\u0003\u0005\u0004\n)\u0001\u000b\u0011\u0002B{\u0011\u001d\u0019Y\u0001\u0001C\u0005\u0007\u001bAqa!\f\u0001\t\u0013\u0019y\u0003C\u0004\u00046\u0001!Iaa\u000e\t\u000f\ru\u0002\u0001\"\u0005\u0004@!91q\n\u0001\u0005\u0012\rE\u0003bBB0\u0001\u0011E1\u0011\r\u0005\b\u0007G\u0002A\u0011BB3\u000f\u0015Q7\b#\u0001l\r\u0015Q4\b#\u0001m\u0011\u0015i7\u0004\"\u0001o\r\u0011y7\u0004\u00119\t\u0011]l\"Q3A\u0005\u0002aD\u0011\"a\u0006\u001e\u0005#\u0005\u000b\u0011B=\t\u0015\u0005eQD!f\u0001\n\u0003\tY\u0002\u0003\u0006\u0002$u\u0011\t\u0012)A\u0005\u0003;A!\"!\n\u001e\u0005+\u0007I\u0011AA\u0014\u0011)\t9$\bB\tB\u0003%\u0011\u0011\u0006\u0005\u0007[v!\t!!\u000f\t\u0013\u0005\u0015S$!A\u0005\u0002\u0005\u001d\u0003\"CA(;E\u0005I\u0011AA)\u0011%\t9'HI\u0001\n\u0003\tI\u0007C\u0005\u0002nu\t\n\u0011\"\u0001\u0002p!I\u00111O\u000f\u0002\u0002\u0013\u0005\u0013Q\u000f\u0005\n\u0003\u000fk\u0012\u0011!C\u0001\u0003\u0013C\u0011\"!%\u001e\u0003\u0003%\t!a%\t\u0013\u0005}U$!A\u0005B\u0005\u0005\u0006\"CAX;\u0005\u0005I\u0011AAY\u0011%\t),HA\u0001\n\u0003\n9\fC\u0005\u0002:v\t\t\u0011\"\u0011\u0002<\"I\u0011QX\u000f\u0002\u0002\u0013\u0005\u0013qX\u0004\n\u0003\u0007\\\u0012\u0011!E\u0001\u0003\u000b4\u0001b\\\u000e\u0002\u0002#\u0005\u0011q\u0019\u0005\u0007[J\"\t!!6\t\u0013\u0005e&'!A\u0005F\u0005m\u0006\"CAle\u0005\u0005I\u0011QAm\u0011%\t\tOMA\u0001\n\u0003\u000b\u0019\u000fC\u0005\u0002rJ\n\t\u0011\"\u0003\u0002t\"9\u00111`\u000e\u0005\u0002\u0005u\bb\u0002B\t7\u0011%!1\u0003\u0002\u001b\u001b\u0016\u0014x-Z%oi>l\u0015\r^3sS\u0006d\u0017N_3T_V\u00148-\u001a\u0006\u0003yu\nQ!\\3sO\u0016T!AP \u0002\u0011\r|W.\\1oINT!\u0001Q!\u0002\u000b\u0011,G\u000e^1\u000b\u0005\t\u001b\u0015aA:rY*\u0011A)R\u0001\u0006gB\f'o\u001b\u0006\u0003\r\u001e\u000ba!\u00199bG\",'\"\u0001%\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001Y\u0015k\u0016\t\u0003\u0019>k\u0011!\u0014\u0006\u0002\u001d\u0006)1oY1mC&\u0011\u0001+\u0014\u0002\u0007\u0003:L(+\u001a4\u0011\u0005I+V\"A*\u000b\u0005Q{\u0014\u0001C7fi\u0016\u0014\u0018N\\4\n\u0005Y\u001b&\u0001\u0004#fYR\fGj\\4hS:<\u0007C\u0001-\\\u001b\u0005I&B\u0001.@\u0003\u0011)H/\u001b7\n\u0005qK&a\u0005#fYR\f7\u000b]1sWBc\u0017M\\+uS2\u001c\u0018A\u0002\u0013j]&$H\u0005F\u0001`!\ta\u0005-\u0003\u0002b\u001b\n!QK\\5u\u0003-iWM]4f'>,(oY3\u0016\u0003\u0011\u00042\u0001T3h\u0013\t1WJ\u0001\u0004PaRLwN\u001c\t\u0003Qvq!!\u001b\u000e\u000e\u0003m\n!$T3sO\u0016Le\u000e^8NCR,'/[1mSj,7k\\;sG\u0016\u0004\"![\u000e\u0014\u0005mY\u0015A\u0002\u001fj]&$h\bF\u0001l\u0005-iUM]4f'>,(oY3\u0014\tuY\u0015\u000f\u001e\t\u0003\u0019JL!a]'\u0003\u000fA\u0013x\u000eZ;diB\u0011A*^\u0005\u0003m6\u0013AbU3sS\u0006d\u0017N_1cY\u0016\f!\u0001\u001a4\u0016\u0003e\u00042A_A\t\u001d\rY\u0018Q\u0002\b\u0004y\u0006-abA?\u0002\n9\u0019a0a\u0002\u000f\u0007}\f)!\u0004\u0002\u0002\u0002)\u0019\u00111A%\u0002\rq\u0012xn\u001c;?\u0013\u0005A\u0015B\u0001$H\u0013\t!U)\u0003\u0002C\u0007&\u0019\u0011qB!\u0002\u000fA\f7m[1hK&!\u00111CA\u000b\u0005%!\u0015\r^1Ge\u0006lWMC\u0002\u0002\u0010\u0005\u000b1\u0001\u001a4!\u00039I7/T1uKJL\u0017\r\\5{K\u0012,\"!!\b\u0011\u00071\u000by\"C\u0002\u0002\"5\u0013qAQ8pY\u0016\fg.A\bjg6\u000bG/\u001a:jC2L'0\u001a3!\u0003Ei\u0017\r^3sS\u0006d\u0017N_3SK\u0006\u001cxN\\\u000b\u0003\u0003S\u0001B!a\u000b\u000229\u0019\u0011.!\f\n\u0007\u0005=2(\u0001\u0011NKJ<W-\u00138u_6\u000bG/\u001a:jC2L'0Z*pkJ\u001cWMU3bg>t\u0017\u0002BA\u001a\u0003k\u0011\u0001%T3sO\u0016Le\u000e^8NCR,'/[1mSj,7k\\;sG\u0016\u0014V-Y:p]*\u0019\u0011qF\u001e\u0002%5\fG/\u001a:jC2L'0\u001a*fCN|g\u000e\t\u000b\t\u0003w\ty$!\u0011\u0002DA\u0019\u0011QH\u000f\u000e\u0003mAQa\u001e\u0013A\u0002eDq!!\u0007%\u0001\u0004\ti\u0002C\u0004\u0002&\u0011\u0002\r!!\u000b\u0002\t\r|\u0007/\u001f\u000b\t\u0003w\tI%a\u0013\u0002N!9q/\nI\u0001\u0002\u0004I\b\"CA\rKA\u0005\t\u0019AA\u000f\u0011%\t)#\nI\u0001\u0002\u0004\tI#\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005M#fA=\u0002V-\u0012\u0011q\u000b\t\u0005\u00033\n\u0019'\u0004\u0002\u0002\\)!\u0011QLA0\u0003%)hn\u00195fG.,GMC\u0002\u0002b5\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t)'a\u0017\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005-$\u0006BA\u000f\u0003+\nabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002r)\"\u0011\u0011FA+\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\u000f\t\u0005\u0003s\n\u0019)\u0004\u0002\u0002|)!\u0011QPA@\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0005\u0015\u0001\u00026bm\u0006LA!!\"\u0002|\t11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a#\u0011\u00071\u000bi)C\u0002\u0002\u00106\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!&\u0002\u001cB\u0019A*a&\n\u0007\u0005eUJA\u0002B]fD\u0011\"!(,\u0003\u0003\u0005\r!a#\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\u0019\u000b\u0005\u0004\u0002&\u0006-\u0016QS\u0007\u0003\u0003OS1!!+N\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003[\u000b9K\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\u000f\u0003gC\u0011\"!(.\u0003\u0003\u0005\r!!&\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a#\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u001e\u0002\r\u0015\fX/\u00197t)\u0011\ti\"!1\t\u0013\u0005u\u0005'!AA\u0002\u0005U\u0015aC'fe\u001e,7k\\;sG\u0016\u00042!!\u00103'\u0011\u0011\u0014\u0011\u001a;\u0011\u0017\u0005-\u0017\u0011[=\u0002\u001e\u0005%\u00121H\u0007\u0003\u0003\u001bT1!a4N\u0003\u001d\u0011XO\u001c;j[\u0016LA!a5\u0002N\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0015\u0005\u0005\u0015\u0017!B1qa2LH\u0003CA\u001e\u00037\fi.a8\t\u000b],\u0004\u0019A=\t\u000f\u0005eQ\u00071\u0001\u0002\u001e!9\u0011QE\u001bA\u0002\u0005%\u0012aB;oCB\u0004H.\u001f\u000b\u0005\u0003K\fi\u000f\u0005\u0003MK\u0006\u001d\b\u0003\u0003'\u0002jf\fi\"!\u000b\n\u0007\u0005-XJ\u0001\u0004UkBdWm\r\u0005\n\u0003_4\u0014\u0011!a\u0001\u0003w\t1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005U\b\u0003BA=\u0003oLA!!?\u0002|\t1qJ\u00196fGR\fQ&\\3sO\u0016l\u0015\r^3sS\u0006d\u0017N_3e'>,(oY3SI\u0012\u0014En\\2l\u0019>\u001cH/\u0012:s_J\u0014VmZ3y)\u0011\tyP!\u0004\u0011\t\t\u0005!\u0011\u0002\b\u0005\u0005\u0007\u0011)\u0001\u0005\u0002\u0000\u001b&\u0019!qA'\u0002\rA\u0013X\rZ3g\u0013\u0011\t)Ia\u0003\u000b\u0007\t\u001dQ\nC\u0004\u0003\u0010a\u0002\r!a#\u0002\u000bI$G-\u00133\u00025\u001d,GOU3gKJ,gnY3e'>,(oY3D_2,XN\\:\u0015\u0015\tU!1\u0006B \u0005\u0013\u0012\t\u0007\u0005\u0004\u0002&\n]!1D\u0005\u0005\u00053\t9KA\u0002TKF\u0004BA!\b\u0003(5\u0011!q\u0004\u0006\u0005\u0005C\u0011\u0019#A\u0006fqB\u0014Xm]:j_:\u001c(b\u0001B\u0013\u0003\u0006A1-\u0019;bYf\u001cH/\u0003\u0003\u0003*\t}!!C!uiJL'-\u001e;f\u0011\u001d\u0011i#\u000fa\u0001\u0005_\taa]8ve\u000e,\u0007\u0003\u0002B\u0019\u0005wi!Aa\r\u000b\t\tU\"qG\u0001\bY><\u0017nY1m\u0015\u0011\u0011IDa\t\u0002\u000bAd\u0017M\\:\n\t\tu\"1\u0007\u0002\f\u0019><\u0017nY1m!2\fg\u000eC\u0004\u0003Be\u0002\rAa\u0011\u0002\u0013\r|g\u000eZ5uS>t\u0007\u0003\u0002B\u000f\u0005\u000bJAAa\u0012\u0003 \tQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u000f\t-\u0013\b1\u0001\u0003N\u0005qQ.\u0019;dQ\u0016$7\t\\1vg\u0016\u001c\bC\u0002B(\u0005/\u0012YF\u0004\u0003\u0003R\tUcbA@\u0003T%\ta*C\u0002\u0002\u00105KAA!\u0007\u0003Z)\u0019\u0011qB'\u0011\t\tE\"QL\u0005\u0005\u0005?\u0012\u0019DA\u000eEK2$\u0018-T3sO\u0016Le\u000e^8NCR\u001c\u0007.\u001a3DY\u0006,8/\u001a\u0005\b\u0005GJ\u0004\u0019\u0001B3\u0003Eqw\u000e^'bi\u000eDW\rZ\"mCV\u001cXm\u001d\t\u0007\u0005\u001f\u00129Fa\u001a\u0011\t\tE\"\u0011N\u0005\u0005\u0005W\u0012\u0019D\u0001\u0010EK2$\u0018-T3sO\u0016Le\u000e^8O_Rl\u0015\r^2iK\u0012\u001cE.Y;tK\u0006yQ.\u001a:hKN{WO]2f?\u0012*\u0017\u000fF\u0002`\u0005cB\u0001\"!(\u0004\u0003\u0003\u0005\r\u0001Z\u0001\u0016[\u0006$XM]5bY&TX\rZ*pkJ\u001cWM\u0015#E+\t\u00119\b\u0005\u0003MK\ne\u0004C\u0002B>\u0005\u0003\u0013))\u0004\u0002\u0003~)\u0019!qP\"\u0002\u0007I$G-\u0003\u0003\u0003\u0004\nu$a\u0001*E\tB!!q\u0011BE\u001b\t\u0011\u0019#\u0003\u0003\u0003\f\n\r\"aC%oi\u0016\u0014h.\u00197S_^\f\u0011$\\1uKJL\u0017\r\\5{K\u0012\u001cv.\u001e:dKJ#Ei\u0018\u0013fcR\u0019qL!%\t\u0013\u0005uU!!AA\u0002\t]\u0014aB1ui\u0016l\u0007\u000f^\u0001\fCR$X-\u001c9u?\u0012*\u0017\u000fF\u0002`\u00053C\u0011\"!(\b\u0003\u0003\u0005\r!a#\u0002II,hnV5uQ6\u000bG/\u001a:jC2L'0\u001a3T_V\u00148-\u001a'pgR\u0014V\r\u001e:jKN$\"Ba(\u0003*\nE&Q\u0018Bl!\u0019\u0011yEa\u0016\u0003\"B!!1\u0015BS\u001b\u0005\t\u0015b\u0001BT\u0003\n\u0019!k\\<\t\r\u0011C\u0001\u0019\u0001BV!\u0011\u0011\u0019K!,\n\u0007\t=\u0016I\u0001\u0007Ta\u0006\u00148nU3tg&|g\u000eC\u0004\u00034\"\u0001\rA!.\u0002\u0011\u0011,G\u000e^1M_\u001e\u0004BAa.\u0003:6\tq(C\u0002\u0003<~\u0012\u0001\u0002R3mi\u0006dun\u001a\u0005\b\u0005\u007fC\u0001\u0019\u0001Ba\u0003\u001diW\r\u001e:jGN\u0004\u0002B!\u0001\u0003D\u0006}(qY\u0005\u0005\u0005\u000b\u0014YAA\u0002NCB\u0004BA!3\u0003T6\u0011!1\u001a\u0006\u0005\u0005\u001b\u0014y-\u0001\u0004nKR\u0014\u0018n\u0019\u0006\u0004\u0005#\f\u0015!C3yK\u000e,H/[8o\u0013\u0011\u0011)Na3\u0003\u0013M\u000bF*T3ue&\u001c\u0007b\u0002Bm\u0011\u0001\u0007!1\\\u0001\reVtW*\u001a:hK\u001a+hn\u0019\t\b\u0019\nu'1\u0016BP\u0013\r\u0011y.\u0014\u0002\n\rVt7\r^5p]F\nQBU3uefD\u0015M\u001c3mS:<\u0007c\u0001Bs\u00155\t\u0001AA\u0007SKR\u0014\u0018\u0010S1oI2LgnZ\n\u0004\u0015\t-\bc\u0001'\u0003n&\u0019!q^'\u0003\u0017\u0015sW/\\3sCRLwN\u001c\u000b\u0003\u0005G\u0014aAU3tk2$\b\u0003\u0002B|\u0005sl\u0011AC\u0005\u0005\u0005w\u0014iOA\u0003WC2,X-A\u0003SKR\u0014\u00180\u0006\u0002\u0003v\u00061!+\u001a;ss\u0002\n\u0001CU3uQJ|w/\u0012=dKB$\u0018n\u001c8\u0002#I+G\u000f\u001b:po\u0016C8-\u001a9uS>t\u0007%\u0001\tFq\"\fWo\u001d;fIJ+GO]5fg\u0006\tR\t\u001f5bkN$X\r\u001a*fiJLWm\u001d\u0011\u00029!\fg\u000e\u001a7f\u000bb\u001cW\r\u001d;j_:$UO]5oO\u0006#H/Z7qiRA1qBB\n\u0007;\u0019\t\u0003E\u0002\u0004\u00121q1A!:\n\u0011\u001d\u0019)b\u0005a\u0001\u0007/\t!!\u001a=\u0011\t\t=3\u0011D\u0005\u0005\u00077\u0011IFA\u0005UQJ|w/\u00192mK\"91qD\nA\u0002\u0005u\u0011!D5t\u0019\u0006\u001cH/\u0011;uK6\u0004H\u000fC\u0004\u00034N\u0001\rA!.)\u0007M\u0019)\u0003\u0005\u0003\u0004(\r%RBAA0\u0013\u0011\u0019Y#a\u0018\u0003\u000fQ\f\u0017\u000e\u001c:fG\u0006a\u0003\u000f\\1o\u0007>tG/Y5og&;gn\u001c:f+:\u0014X-\u00193bE2,g)\u001b7fgJ+\u0017\rZ(qi&|gn\u001d\u000b\u0005\u0003;\u0019\t\u0004C\u0004\u00044Q\u0001\rAa\f\u0002\tAd\u0017M\\\u0001#S\u001etwN]3V]J,\u0017\rZ1cY\u00164\u0015\u000e\\3t\u0007>tg-[4t\u0003J,7+\u001a;\u0015\r\u0005u1\u0011HB\u001e\u0011\u001d\u0019\u0019$\u0006a\u0001\u0005_Aa\u0001R\u000bA\u0002\t-\u0016aF:i_VdG-T1uKJL\u0017\r\\5{KN{WO]2f)!\u0019\tea\u0012\u0004J\r-\u0003c\u0002'\u0004D\u0005u\u0011\u0011F\u0005\u0004\u0007\u000bj%A\u0002+va2,'\u0007\u0003\u0004E-\u0001\u0007!1\u0016\u0005\b\u0005[1\u0002\u0019\u0001B\u0018\u0011\u001d\u0019iE\u0006a\u0001\u0003;\tA\"[:J]N,'\u000f^(oYf\f!\u0003\u001d:fa\u0006\u0014X-T3sO\u0016\u001cv.\u001e:dKRiqla\u0015\u0004V\r]3\u0011LB.\u0007;Ba\u0001R\fA\u0002\t-\u0006b\u0002B\u0017/\u0001\u0007!q\u0006\u0005\b\u0005\u0003:\u0002\u0019\u0001B\"\u0011\u001d\u0011Ye\u0006a\u0001\u0005\u001bBqAa\u0019\u0018\u0001\u0004\u0011)\u0007C\u0004\u0004N]\u0001\r!!\b\u0002\u001d\u001d,G/T3sO\u0016\u001cv.\u001e:dKV\tq-\u0001\bbI\u0012D\u0015N\u001c;t)>\u0004F.\u00198\u0015\r\t=2qMB6\u0011\u001d\u0019I'\u0007a\u0001\u0005_\t!b]8ve\u000e,\u0007\u000b\\1o\u0011\u001d\u0019\u0019$\u0007a\u0001\u0005_\u0001")
public interface MergeIntoMaterializeSource
extends DeltaLogging,
DeltaSparkPlanUtils {
    public static String mergeMaterializedSourceRddBlockLostErrorRegex(int n) {
        return MergeIntoMaterializeSource$.MODULE$.mergeMaterializedSourceRddBlockLostErrorRegex(n);
    }

    public MergeIntoMaterializeSource$RetryHandling$ RetryHandling();

    public Option<MergeSource> org$apache$spark$sql$delta$commands$merge$MergeIntoMaterializeSource$$mergeSource();

    public void org$apache$spark$sql$delta$commands$merge$MergeIntoMaterializeSource$$mergeSource_$eq(Option<MergeSource> var1);

    public Option<RDD<InternalRow>> materializedSourceRDD();

    public void materializedSourceRDD_$eq(Option<RDD<InternalRow>> var1);

    public int attempt();

    public void attempt_$eq(int var1);

    public static /* synthetic */ Seq runWithMaterializedSourceLostRetries$(MergeIntoMaterializeSource $this, SparkSession spark, DeltaLog deltaLog, Map metrics, Function1 runMergeFunc) {
        return $this.runWithMaterializedSourceLostRetries(spark, deltaLog, (Map<String, SQLMetric>)metrics, (Function1<SparkSession, Seq<Row>>)runMergeFunc);
    }

    default public Seq<Row> runWithMaterializedSourceLostRetries(SparkSession spark, DeltaLog deltaLog, Map<String, SQLMetric> metrics, Function1<SparkSession, Seq<Row>> runMergeFunc) {
        boolean doRetry = false;
        Seq runResult = null;
        this.attempt_$eq(1);
        do {
            doRetry = false;
            metrics.values().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                x$1.reset();
                return BoxedUnit.UNIT;
            });
            try {
                try {
                    runResult = (Seq)runMergeFunc.apply((Object)spark);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        Throwable ex = (Throwable)option.get();
                        boolean isLastAttempt = this.attempt() == BoxesRunTime.unboxToInt((Object)spark.conf().get(DeltaSQLConf$.MODULE$.MERGE_MATERIALIZE_SOURCE_MAX_ATTEMPTS()));
                        Enumeration.Value value = this.handleExceptionDuringAttempt(ex, isLastAttempt, deltaLog);
                        Enumeration.Value value2 = this.RetryHandling().Retry();
                        Enumeration.Value value3 = value;
                        if (value2 != null ? !value2.equals(value3) : value3 != null) {
                            Enumeration.Value value4 = this.RetryHandling().ExhaustedRetries();
                            Enumeration.Value value5 = value;
                            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                                this.logError(LogEntry$.MODULE$.from((Function0<MessageWithContext>)(Function0 & Serializable & scala.Serializable)() -> this.LogStringContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exhausted retries after ", ""}))).log((Seq<MDC>)Predef$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.NUM_ATTEMPT(), BoxesRunTime.boxToInteger((int)this.attempt()))})).$plus(this.LogStringContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" attempts in MERGE with materialized source. Logging latest exception."}))).log((Seq<MDC>)Nil$.MODULE$))), ex);
                                throw DeltaErrors$.MODULE$.sourceMaterializationFailedRepeatedlyInMerge();
                            }
                            Enumeration.Value value6 = this.RetryHandling().RethrowException();
                            Enumeration.Value value7 = value;
                            if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                                this.logError(LogEntry$.MODULE$.from((Function0<MessageWithContext>)(Function0 & Serializable & scala.Serializable)() -> this.LogStringContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fatal error in MERGE with materialized source in "}))).log((Seq<MDC>)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"attempt ", ""}))).log((Seq<MDC>)Predef$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.NUM_ATTEMPT(), BoxesRunTime.boxToInteger((int)this.attempt()))})))), ex);
                                throw ex;
                            }
                            throw new MatchError((Object)value);
                        }
                        this.logInfo(LogEntry$.MODULE$.from((Function0<MessageWithContext>)(Function0 & Serializable & scala.Serializable)() -> this.LogStringContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Retrying MERGE with materialized source. Attempt "}))).log((Seq<MDC>)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " failed."}))).log((Seq<MDC>)Predef$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.NUM_ATTEMPT(), BoxesRunTime.boxToInteger((int)this.attempt()))})))));
                        doRetry = true;
                        this.attempt_$eq(this.attempt() + 1);
                        continue;
                    }
                    throw throwable;
                }
            }
            finally {
                this.materializedSourceRDD().foreach((Function1 & Serializable & scala.Serializable)rdd -> rdd.unpersist(rdd.unpersist$default$1()));
                this.materializedSourceRDD_$eq((Option<RDD<InternalRow>>)None$.MODULE$);
                this.org$apache$spark$sql$delta$commands$merge$MergeIntoMaterializeSource$$mergeSource_$eq((Option<MergeSource>)None$.MODULE$);
            }
        } while (doRetry);
        return runResult;
    }

    private Enumeration.Value handleExceptionDuringAttempt(Throwable ex, boolean isLastAttempt, DeltaLog deltaLog) {
        while (true) {
            Throwable ex2;
            boolean bl = false;
            SparkException sparkException = null;
            Throwable throwable = ex;
            if (throwable instanceof SparkException) {
                bl = true;
                sparkException = (SparkException)throwable;
                if (this.materializedSourceRDD().nonEmpty() && sparkException.getMessage().matches(MergeIntoMaterializeSource$.MODULE$.mergeMaterializedSourceRddBlockLostErrorRegex(((RDD)this.materializedSourceRDD().get()).id()))) {
                    this.log().warn(new StringBuilder(96).append("Materialized Merge source RDD block lost. Merge needs to be restarted. ").append("This was attempt number ").append(this.attempt()).append(".").toString());
                    if (!isLastAttempt) {
                        return this.RetryHandling().Retry();
                    }
                    DeltaLog x$1 = deltaLog;
                    String x$2 = MergeIntoMaterializeSourceError$.MODULE$.OP_TYPE();
                    MergeIntoMaterializeSourceError x$3 = new MergeIntoMaterializeSourceError(MergeIntoMaterializeSourceErrorType$.MODULE$.RDD_BLOCK_LOST().toString(), this.attempt(), ((RDD)this.materializedSourceRDD().get()).getStorageLevel().toString());
                    Map<TagDefinition, String> x$4 = this.recordDeltaEvent$default$3();
                    Option<Path> x$5 = this.recordDeltaEvent$default$5();
                    this.recordDeltaEvent(x$1, x$2, x$4, x$3, x$5);
                    return this.RetryHandling().ExhaustedRetries();
                }
            }
            if (bl && this.materializedSourceRDD().nonEmpty() && sparkException.getMessage().contains("java.io.IOException: No space left on device")) {
                DeltaLog x$6 = deltaLog;
                String x$7 = MergeIntoMaterializeSourceError$.MODULE$.OP_TYPE();
                MergeIntoMaterializeSourceError x$8 = new MergeIntoMaterializeSourceError(MergeIntoMaterializeSourceErrorType$.MODULE$.OUT_OF_DISK().toString(), this.attempt(), ((RDD)this.materializedSourceRDD().get()).getStorageLevel().toString());
                Map<TagDefinition, String> x$9 = this.recordDeltaEvent$default$3();
                Option<Path> x$10 = this.recordDeltaEvent$default$5();
                this.recordDeltaEvent(x$6, x$7, x$9, x$8, x$10);
                return this.RetryHandling().RethrowException();
            }
            Option option = NonFatal$.MODULE$.unapply(throwable);
            if (option.isEmpty() || (ex2 = (Throwable)option.get()).getCause() == null) break;
            ex = ex2.getCause();
        }
        return this.RetryHandling().RethrowException();
    }

    private boolean planContainsIgnoreUnreadableFilesReadOptions(LogicalPlan plan) {
        Option res = plan.collectFirst((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MergeIntoMaterializeSource $outer;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                LogicalRelation logicalRelation;
                A1 A1 = x1;
                if (A1 instanceof LogicalRelation && MergeIntoMaterializeSource.org$apache$spark$sql$delta$commands$merge$MergeIntoMaterializeSource$$relationContainsOptions$1((logicalRelation = (LogicalRelation)A1).relation())) {
                    return (B1)logicalRelation;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalRelation logicalRelation;
                LogicalPlan logicalPlan = x1;
                return logicalPlan instanceof LogicalRelation && MergeIntoMaterializeSource.org$apache$spark$sql$delta$commands$merge$MergeIntoMaterializeSource$$relationContainsOptions$1((logicalRelation = (LogicalRelation)logicalPlan).relation());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return res.nonEmpty();
    }

    private boolean ignoreUnreadableFilesConfigsAreSet(LogicalPlan plan, SparkSession spark) {
        return BoxesRunTime.unboxToBoolean((Object)spark.conf().get(SQLConf$.MODULE$.IGNORE_MISSING_FILES())) || BoxesRunTime.unboxToBoolean((Object)spark.conf().get(SQLConf$.MODULE$.IGNORE_CORRUPT_FILES())) || this.planContainsIgnoreUnreadableFilesReadOptions(plan);
    }

    public static /* synthetic */ Tuple2 shouldMaterializeSource$(MergeIntoMaterializeSource $this, SparkSession spark, LogicalPlan source, boolean isInsertOnly) {
        return $this.shouldMaterializeSource(spark, source, isInsertOnly);
    }

    default public Tuple2<Object, Enumeration.Value> shouldMaterializeSource(SparkSession spark, LogicalPlan source, boolean isInsertOnly) {
        String materializeType = (String)spark.conf().get(DeltaSQLConf$.MODULE$.MERGE_MATERIALIZE_SOURCE());
        boolean forceMaterializationWithUnreadableFiles = BoxesRunTime.unboxToBoolean((Object)spark.conf().get(DeltaSQLConf$.MODULE$.MERGE_FORCE_SOURCE_MATERIALIZATION_WITH_UNREADABLE_FILES()));
        DeltaSparkPlanUtils.CheckDeterministicOptions checkDeterministicOptions = new DeltaSparkPlanUtils.CheckDeterministicOptions(true);
        String string = materializeType;
        if ("all".equals(string)) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)MergeIntoMaterializeSourceReason$.MODULE$.MATERIALIZE_ALL());
        }
        if ("none".equals(string)) {
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)MergeIntoMaterializeSourceReason$.MODULE$.NOT_MATERIALIZED_NONE());
        }
        if ("auto".equals(string)) {
            if (isInsertOnly && BoxesRunTime.unboxToBoolean((Object)spark.conf().get(DeltaSQLConf$.MODULE$.MERGE_INSERT_ONLY_ENABLED()))) {
                return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)MergeIntoMaterializeSourceReason$.MODULE$.NOT_MATERIALIZED_AUTO_INSERT_ONLY());
            }
            if (!this.planContainsOnlyDeltaScans(source)) {
                return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)MergeIntoMaterializeSourceReason$.MODULE$.NON_DETERMINISTIC_SOURCE_NON_DELTA());
            }
            if (!this.planIsDeterministic(source, checkDeterministicOptions)) {
                return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)MergeIntoMaterializeSourceReason$.MODULE$.NON_DETERMINISTIC_SOURCE_OPERATORS());
            }
            if (forceMaterializationWithUnreadableFiles && this.ignoreUnreadableFilesConfigsAreSet(source, spark)) {
                return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)MergeIntoMaterializeSourceReason$.MODULE$.IGNORE_UNREADABLE_FILES_CONFIGS_ARE_SET());
            }
            if (this.planContainsUdf(source)) {
                return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)MergeIntoMaterializeSourceReason$.MODULE$.NON_DETERMINISTIC_SOURCE_WITH_DETERMINISTIC_UDF());
            }
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)MergeIntoMaterializeSourceReason$.MODULE$.NOT_MATERIALIZED_AUTO());
        }
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)MergeIntoMaterializeSourceReason$.MODULE$.INVALID_CONFIG());
    }

    public static /* synthetic */ void prepareMergeSource$(MergeIntoMaterializeSource $this, SparkSession spark, LogicalPlan source, Expression condition, Seq matchedClauses, Seq notMatchedClauses, boolean isInsertOnly) {
        $this.prepareMergeSource(spark, source, condition, (Seq<DeltaMergeIntoMatchedClause>)matchedClauses, (Seq<DeltaMergeIntoNotMatchedClause>)notMatchedClauses, isInsertOnly);
    }

    default public void prepareMergeSource(SparkSession spark, LogicalPlan source, Expression condition, Seq<DeltaMergeIntoMatchedClause> matchedClauses, Seq<DeltaMergeIntoNotMatchedClause> notMatchedClauses, boolean isInsertOnly) {
        Tuple2<Object, Enumeration.Value> tuple2 = this.shouldMaterializeSource(spark, source, isInsertOnly);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        boolean materialize = tuple2._1$mcZ$sp();
        Enumeration.Value materializeReason = (Enumeration.Value)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)materialize), (Object)materializeReason);
        boolean materialize2 = tuple22._1$mcZ$sp();
        Enumeration.Value materializeReason2 = (Enumeration.Value)tuple22._2();
        if (!materialize2) {
            this.org$apache$spark$sql$delta$commands$merge$MergeIntoMaterializeSource$$mergeSource_$eq((Option<MergeSource>)new Some((Object)new MergeSource((Dataset<Row>)Dataset$.MODULE$.ofRows(spark, source), false, materializeReason2)));
            return;
        }
        Seq<Attribute> referencedSourceColumns = MergeIntoMaterializeSource$.MODULE$.org$apache$spark$sql$delta$commands$merge$MergeIntoMaterializeSource$$getReferencedSourceColumns(source, condition, matchedClauses, notMatchedClauses);
        Project sourceWithSelectedColumns = new Project(referencedSourceColumns, source);
        Dataset baseSourcePlanDF = Dataset$.MODULE$.ofRows(spark, (LogicalPlan)sourceWithSelectedColumns);
        Dataset checkpointedSourcePlanDF = baseSourcePlanDF.localCheckpoint(false);
        LogicalPlan checkpointedPlan = checkpointedSourcePlanDF.queryExecution().analyzed();
        RDD rdd = ((LogicalRDD)checkpointedPlan).rdd();
        this.materializedSourceRDD_$eq((Option<RDD<InternalRow>>)new Some((Object)rdd));
        rdd.setName("mergeMaterializedSource");
        checkpointedPlan = this.addHintsToPlan(source, checkpointedPlan);
        this.org$apache$spark$sql$delta$commands$merge$MergeIntoMaterializeSource$$mergeSource_$eq((Option<MergeSource>)new Some((Object)new MergeSource((Dataset<Row>)Dataset$.MODULE$.ofRows(spark, checkpointedPlan), true, materializeReason2)));
        StorageLevel storageLevel = StorageLevel$.MODULE$.fromString(this.attempt() == 1 ? (String)spark.conf().get(DeltaSQLConf$.MODULE$.MERGE_MATERIALIZE_SOURCE_RDD_STORAGE_LEVEL()) : (this.attempt() == 2 ? (String)spark.conf().get(DeltaSQLConf$.MODULE$.MERGE_MATERIALIZE_SOURCE_RDD_STORAGE_LEVEL_FIRST_RETRY()) : (String)spark.conf().get(DeltaSQLConf$.MODULE$.MERGE_MATERIALIZE_SOURCE_RDD_STORAGE_LEVEL_RETRY())));
        rdd.persist(storageLevel);
        if (BoxesRunTime.unboxToBoolean((Object)spark.conf().get(DeltaSQLConf$.MODULE$.MERGE_MATERIALIZE_SOURCE_EAGER()))) {
            rdd.mapPartitions((Function1 & Serializable & scala.Serializable)x$3 -> package$.MODULE$.Iterator().empty(), rdd.mapPartitions$default$2(), ClassTag$.MODULE$.apply(InternalRow.class)).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                MergeIntoMaterializeSource.$anonfun$prepareMergeSource$2(x$4);
                return BoxedUnit.UNIT;
            });
            Predef$.MODULE$.assert(rdd.isCheckpointed());
        }
        this.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Materializing MERGE with pruned columns ").append(referencedSourceColumns).append(".").toString());
        this.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Materialized MERGE source plan:\n").append(this.getMergeSource().df().queryExecution()).toString());
    }

    public static /* synthetic */ MergeSource getMergeSource$(MergeIntoMaterializeSource $this) {
        return $this.getMergeSource();
    }

    default public MergeSource getMergeSource() {
        Option<MergeSource> option = this.org$apache$spark$sql$delta$commands$merge$MergeIntoMaterializeSource$$mergeSource();
        if (option instanceof Some) {
            Some some = (Some)option;
            MergeSource source = (MergeSource)some.value();
            return source;
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalStateException("mergeSource was not initialized! Call prepareMergeSource before.");
        }
        throw new MatchError(option);
    }

    private LogicalPlan addHintsToPlan(LogicalPlan sourcePlan, LogicalPlan plan) {
        Seq hints = (Seq)EliminateResolvedHint$.MODULE$.extractHintsFromPlan(sourcePlan)._2();
        if (hints.nonEmpty()) {
            LogicalPlan planWithHints = (LogicalPlan)hints.foldRight((Object)plan, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (tuple2 != null) {
                    HintInfo hint = (HintInfo)tuple2._1();
                    LogicalPlan p = (LogicalPlan)tuple2._2();
                    return new ResolvedHint(p, hint);
                }
                throw new MatchError((Object)tuple2);
            });
            return planWithHints;
        }
        return plan;
    }

    public static boolean org$apache$spark$sql$delta$commands$merge$MergeIntoMaterializeSource$$relationContainsOptions$1(BaseRelation relation) {
        BaseRelation baseRelation = relation;
        if (baseRelation instanceof HadoopFsRelation) {
            HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)baseRelation;
            return hadoopFsRelation.options().get((Object)FileSourceOptions$.MODULE$.IGNORE_CORRUPT_FILES()).contains((Object)"true") || hadoopFsRelation.options().get((Object)FileSourceOptions$.MODULE$.IGNORE_MISSING_FILES()).contains((Object)"true");
        }
        return false;
    }

    public static /* synthetic */ void $anonfun$prepareMergeSource$2(InternalRow x$4) {
    }

    public static void $init$(MergeIntoMaterializeSource $this) {
        $this.org$apache$spark$sql$delta$commands$merge$MergeIntoMaterializeSource$$mergeSource_$eq((Option<MergeSource>)None$.MODULE$);
        $this.materializedSourceRDD_$eq((Option<RDD<InternalRow>>)None$.MODULE$);
        $this.attempt_$eq(0);
    }

    public static class MergeSource
    implements Product,
    scala.Serializable {
        private final Dataset<Row> df;
        private final boolean isMaterialized;
        private final Enumeration.Value materializeReason;

        public Dataset<Row> df() {
            return this.df;
        }

        public boolean isMaterialized() {
            return this.isMaterialized;
        }

        public Enumeration.Value materializeReason() {
            return this.materializeReason;
        }

        public MergeSource copy(Dataset<Row> df, boolean isMaterialized, Enumeration.Value materializeReason) {
            return new MergeSource(df, isMaterialized, materializeReason);
        }

        public Dataset<Row> copy$default$1() {
            return this.df();
        }

        public boolean copy$default$2() {
            return this.isMaterialized();
        }

        public Enumeration.Value copy$default$3() {
            return this.materializeReason();
        }

        public String productPrefix() {
            return "MergeSource";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.df();
                }
                case 1: {
                    return BoxesRunTime.boxToBoolean((boolean)this.isMaterialized());
                }
                case 2: {
                    return this.materializeReason();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MergeSource;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash(this.df()));
            n = Statics.mix((int)n, (int)(this.isMaterialized() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.materializeReason()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MergeSource)) return false;
            boolean bl = true;
            if (!bl) return false;
            MergeSource mergeSource = (MergeSource)x$1;
            Dataset<Row> dataset = this.df();
            Dataset<Row> dataset2 = mergeSource.df();
            if (dataset == null) {
                if (dataset2 != null) {
                    return false;
                }
            } else if (!dataset.equals(dataset2)) return false;
            if (this.isMaterialized() != mergeSource.isMaterialized()) return false;
            Enumeration.Value value = this.materializeReason();
            Enumeration.Value value2 = mergeSource.materializeReason();
            if (value == null) {
                if (value2 != null) {
                    return false;
                }
            } else if (!value.equals(value2)) return false;
            if (!mergeSource.canEqual(this)) return false;
            return true;
        }

        public MergeSource(Dataset<Row> df, boolean isMaterialized, Enumeration.Value materializeReason) {
            this.df = df;
            this.isMaterialized = isMaterialized;
            this.materializeReason = materializeReason;
            Product.$init$((Product)this);
            Predef$.MODULE$.assert(!isMaterialized || MergeIntoMaterializeSourceReason$.MODULE$.MATERIALIZED_REASONS().contains((Object)materializeReason));
        }
    }
}

