/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.hooks;

import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaTableIdentifier$;
import org.apache.spark.sql.delta.OptimisticTransactionImpl;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.hooks.PostCommitHook;
import org.apache.spark.sql.delta.logging.DeltaLogKeys$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.skipping.clustering.ClusteredTableUtils$;
import org.apache.spark.sql.delta.skipping.clustering.ClusteringColumnInfo$;
import org.apache.spark.sql.delta.skipping.clustering.temp.ClusterBySpec;
import org.apache.spark.sql.delta.skipping.clustering.temp.ClusterBySpec$;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005mbaB\u0007\u000f!\u0003\r\ta\u0007\u0005\u0006Y\u0001!\t!\f\u0005\bc\u0001\u0011\rQ\"\u00053\u0011\u0015Y\u0004\u0001\"\u0011=\u0011\u0015)\u0007A\"\u0001g\u0011\u0015Q\u0007A\"\u0001l\u0011\u0015q\u0007A\"\u0005p\u0011\u0015\u0011\bA\"\u0005t\u0011\u0019I\bA\"\u0005\u0013u\"9\u0011Q\u0004\u0001\u0005\u0012\u0005}\u0001bBA\u0013\u0001\u0011%\u0011q\u0005\u0005\b\u0003[\u0001A\u0011CA\u0018\u0011\u001d\t\u0019\u0004\u0001C\t\u0003k\u0011\u0011#\u00169eCR,7)\u0019;bY><')Y:f\u0015\ty\u0001#A\u0003i_>\\7O\u0003\u0002\u0012%\u0005)A-\u001a7uC*\u00111\u0003F\u0001\u0004gFd'BA\u000b\u0017\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0002$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00023\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\b\u0012'!\ti\u0002%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0005\u0019\te.\u001f*fMB\u00111\u0005J\u0007\u0002\u001d%\u0011QE\u0004\u0002\u000f!>\u001cHoQ8n[&$\bj\\8l!\t9#&D\u0001)\u0015\tI\u0003#\u0001\u0005nKR,'/\u001b8h\u0013\tY\u0003F\u0001\u0007EK2$\u0018\rT8hO&tw-\u0001\u0004%S:LG\u000f\n\u000b\u0002]A\u0011QdL\u0005\u0003ay\u0011A!\u00168ji\u0006)A/\u00192mKV\t1\u0007\u0005\u00025s5\tQG\u0003\u00027o\u000591-\u0019;bY><'B\u0001\u001d\u0013\u0003!\u0019\u0017\r^1msN$\u0018B\u0001\u001e6\u00051\u0019\u0015\r^1m_\u001e$\u0016M\u00197f\u0003\r\u0011XO\u001c\u000b\u0007]u\u0012\u0005*\u0014*\t\u000bU\u0019\u0001\u0019\u0001 \u0011\u0005}\u0002U\"\u0001\n\n\u0005\u0005\u0013\"\u0001D*qCJ\\7+Z:tS>t\u0007\"B\"\u0004\u0001\u0004!\u0015a\u0001;y]B\u0011QIR\u0007\u0002!%\u0011q\t\u0005\u0002\u001a\u001fB$\u0018.\\5ti&\u001cGK]1og\u0006\u001cG/[8o\u00136\u0004H\u000eC\u0003J\u0007\u0001\u0007!*\u0001\td_6l\u0017\u000e\u001e;fIZ+'o]5p]B\u0011QdS\u0005\u0003\u0019z\u0011A\u0001T8oO\")aj\u0001a\u0001\u001f\u0006\u0011\u0002o\\:u\u0007>lW.\u001b;T]\u0006\u00048\u000f[8u!\t)\u0005+\u0003\u0002R!\tA1K\\1qg\"|G\u000fC\u0003T\u0007\u0001\u0007A+A\u0004bGRLwN\\:\u0011\u0007Uk\u0006M\u0004\u0002W7:\u0011qKW\u0007\u00021*\u0011\u0011LG\u0001\u0007yI|w\u000e\u001e \n\u0003}I!\u0001\u0018\u0010\u0002\u000fA\f7m[1hK&\u0011al\u0018\u0002\u0004'\u0016\f(B\u0001/\u001f!\t\t7-D\u0001c\u0015\t\u0019\u0006#\u0003\u0002eE\n1\u0011i\u0019;j_:\fa\"\u001a=fGV$Xm\u00148Xe&$X\rF\u0002/O\"DQ!\u0006\u0003A\u0002yBQ!\u001b\u0003A\u0002=\u000b\u0001b\u001d8baNDw\u000e^\u0001\rkB$\u0017\r^3TG\",W.\u0019\u000b\u0004]1l\u0007\"B\u000b\u0006\u0001\u0004q\u0004\"B5\u0006\u0001\u0004y\u0015\u0001E;qI\u0006$X\r\u0015:pa\u0016\u0014H/[3t)\rq\u0003/\u001d\u0005\u0006+\u0019\u0001\rA\u0010\u0005\u0006S\u001a\u0001\raT\u0001\u0011g\u000eDW-\\1ICN\u001c\u0005.\u00198hK\u0012$2\u0001^<y!\tiR/\u0003\u0002w=\t9!i\\8mK\u0006t\u0007\"B5\b\u0001\u0004y\u0005\"B\u000b\b\u0001\u0004q\u0014!\u00069s_B,'\u000f^5fg\"\u000bg/Z\"iC:<W\r\u001a\u000b\u0007in\f\t\"a\u0007\t\u000bqD\u0001\u0019A?\u0002\u0015A\u0014x\u000e]3si&,7\u000fE\u0004\u007f\u0003\u000b\tY!a\u0003\u000f\u0007}\f\t\u0001\u0005\u0002X=%\u0019\u00111\u0001\u0010\u0002\rA\u0013X\rZ3g\u0013\u0011\t9!!\u0003\u0003\u00075\u000b\u0007OC\u0002\u0002\u0004y\u00012A`A\u0007\u0013\u0011\ty!!\u0003\u0003\rM#(/\u001b8h\u0011\u001d\t\u0019\u0002\u0003a\u0001\u0003+\t\u0001\"\\3uC\u0012\fG/\u0019\t\u0004C\u0006]\u0011bAA\rE\nAQ*\u001a;bI\u0006$\u0018\rC\u0003\u0016\u0011\u0001\u0007a(A\u0005tQ>,H\u000e\u001a*v]R)A/!\t\u0002$!)Q#\u0003a\u0001}!)\u0011.\u0003a\u0001\u001f\u0006)\u0012n\u001d)bi\"\u0014\u0015m]3e\t\u0016dG/\u0019+bE2,G#\u0002;\u0002*\u0005-\u0002\"B\u0019\u000b\u0001\u0004\u0019\u0004\"B\u000b\u000b\u0001\u0004q\u0014\u0001G2mkN$XM]5oO\u000e{G.^7og\u000eC\u0017M\\4fIR\u0019A/!\r\t\u000b%\\\u0001\u0019A(\u0002\u000f\u0015DXmY;uKR)a&a\u000e\u0002:!)Q\u0003\u0004a\u0001}!)\u0011\u000e\u0004a\u0001\u001f\u0002")
public interface UpdateCatalogBase
extends PostCommitHook,
DeltaLogging {
    public CatalogTable table();

    public static /* synthetic */ void run$(UpdateCatalogBase $this, SparkSession spark, OptimisticTransactionImpl txn, long committedVersion, Snapshot postCommitSnapshot, Seq actions) {
        $this.run(spark, txn, committedVersion, postCommitSnapshot, (Seq<Action>)actions);
    }

    @Override
    default public void run(SparkSession spark, OptimisticTransactionImpl txn, long committedVersion, Snapshot postCommitSnapshot, Seq<Action> actions) {
        this.executeOnWrite(spark, postCommitSnapshot);
    }

    public void executeOnWrite(SparkSession var1, Snapshot var2);

    public void updateSchema(SparkSession var1, Snapshot var2);

    public void updateProperties(SparkSession var1, Snapshot var2);

    public boolean schemaHasChanged(Snapshot var1, SparkSession var2);

    public boolean propertiesHaveChanged(Map<String, String> var1, Metadata var2, SparkSession var3);

    public static /* synthetic */ boolean shouldRun$(UpdateCatalogBase $this, SparkSession spark, Snapshot snapshot) {
        return $this.shouldRun(spark, snapshot);
    }

    default public boolean shouldRun(SparkSession spark, Snapshot snapshot) {
        if (!BoxesRunTime.unboxToBoolean((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_UPDATE_CATALOG_ENABLED()))) {
            return false;
        }
        if (this.isPathBasedDeltaTable(this.table(), spark)) {
            return false;
        }
        return snapshot.version() >= 0L;
    }

    private boolean isPathBasedDeltaTable(CatalogTable table, SparkSession spark) {
        return DeltaTableIdentifier$.MODULE$.isDeltaPath(spark, table.identifier());
    }

    public static /* synthetic */ boolean clusteringColumnsChanged$(UpdateCatalogBase $this, Snapshot snapshot) {
        return $this.clusteringColumnsChanged(snapshot);
    }

    default public boolean clusteringColumnsChanged(Snapshot snapshot) {
        if (!ClusteredTableUtils$.MODULE$.isSupported(snapshot.protocol())) {
            return false;
        }
        String currentLogicalClusteringNames = ClusteringColumnInfo$.MODULE$.extractLogicalNames(snapshot).mkString(",");
        Option<ClusterBySpec> clusterBySpecOpt = ClusterBySpec$.MODULE$.fromProperties((Map<String, String>)this.table().properties());
        Predef$.MODULE$.assert(!new StringOps(Predef$.MODULE$.augmentString(currentLogicalClusteringNames)).nonEmpty() || !clusterBySpecOpt.isEmpty());
        return clusterBySpecOpt.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)UpdateCatalogBase.$anonfun$clusteringColumnsChanged$1(currentLogicalClusteringNames, x$1)));
    }

    public static /* synthetic */ void execute$(UpdateCatalogBase $this, SparkSession spark, Snapshot snapshot) {
        $this.execute(spark, snapshot);
    }

    default public void execute(SparkSession spark, Snapshot snapshot) {
        this.recordDeltaOperation(snapshot.deltaLog(), "delta.catalog.update", this.recordDeltaOperation$default$3(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Map properties = snapshot.getProperties().toMap(Predef$.MODULE$.$conforms());
            long v2 = BoxesRunTime.unboxToLong((Object)this.table().properties().get((Object)DeltaConfigs$.MODULE$.METASTORE_LAST_UPDATE_VERSION()).flatMap((Function1 & Serializable & scala.Serializable)v -> Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(v)).toLong()).toOption()).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L));
            long lastCommitTimestamp = BoxesRunTime.unboxToLong((Object)this.table().properties().get((Object)DeltaConfigs$.MODULE$.METASTORE_LAST_COMMIT_TIMESTAMP()).flatMap((Function1 & Serializable & scala.Serializable)v -> Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(v)).toLong()).toOption()).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L));
            if (v2 <= snapshot.version() || lastCommitTimestamp < snapshot.timestamp()) {
                try {
                    Map loggingData = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"identifier"), (Object)this.table().identifier()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"snapshotVersion"), (Object)BoxesRunTime.boxToLong((long)snapshot.version())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"snapshotTimestamp"), (Object)BoxesRunTime.boxToLong((long)snapshot.timestamp())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"catalogVersion"), (Object)BoxesRunTime.boxToLong((long)v2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"catalogTimestamp"), (Object)BoxesRunTime.boxToLong((long)lastCommitTimestamp))}));
                    if (this.schemaHasChanged(snapshot, spark)) {
                        this.updateSchema(spark, snapshot);
                        DeltaLog x$1 = snapshot.deltaLog();
                        String x$2 = "delta.catalog.update.schema";
                        Map x$3 = loggingData;
                        Map<TagDefinition, String> x$4 = this.recordDeltaEvent$default$3();
                        Option<Path> x$5 = this.recordDeltaEvent$default$5();
                        this.recordDeltaEvent(x$1, x$2, x$4, x$3, x$5);
                    } else if (this.propertiesHaveChanged((Map<String, String>)properties, snapshot.metadata(), spark)) {
                        this.updateProperties(spark, snapshot);
                        DeltaLog x$6 = snapshot.deltaLog();
                        String x$7 = "delta.catalog.update.properties";
                        Map x$8 = loggingData;
                        Map<TagDefinition, String> x$9 = this.recordDeltaEvent$default$3();
                        Option<Path> x$10 = this.recordDeltaEvent$default$5();
                        this.recordDeltaEvent(x$6, x$7, x$9, x$8, x$10);
                    } else if (this.clusteringColumnsChanged(snapshot)) {
                        this.updateProperties(spark, snapshot);
                        DeltaLog x$11 = snapshot.deltaLog();
                        String x$12 = "delta.catalog.update.clusteringColumns";
                        Map x$13 = loggingData;
                        Map<TagDefinition, String> x$14 = this.recordDeltaEvent$default$3();
                        Option<Path> x$15 = this.recordDeltaEvent$default$5();
                        this.recordDeltaEvent(x$11, x$12, x$14, x$13, x$15);
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        Throwable e = (Throwable)option.get();
                        DeltaLog x$16 = snapshot.deltaLog();
                        String x$17 = "delta.catalog.update.error";
                        Map x$18 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exceptionMsg"), (Object)ExceptionUtils.getMessage((Throwable)e)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stackTrace"), (Object)ExceptionUtils.getStackTrace((Throwable)e))}));
                        Map<TagDefinition, String> x$19 = this.recordDeltaEvent$default$3();
                        Option<Path> x$20 = this.recordDeltaEvent$default$5();
                        this.recordDeltaEvent(x$16, x$17, x$19, x$18, x$20);
                        this.logWarning(LogEntry$.MODULE$.from((Function0<MessageWithContext>)(Function0 & Serializable & scala.Serializable)() -> this.LogStringContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to update the catalog for "}))).log((Seq<MDC>)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " with the latest "}))).log((Seq<MDC>)Predef$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.TABLE_NAME(), this.table().identifier())}))).$plus(this.LogStringContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table information."}))).log((Seq<MDC>)Nil$.MODULE$))), e);
                    }
                    throw throwable;
                }
                return;
            }
        });
    }

    public static /* synthetic */ boolean $anonfun$clusteringColumnsChanged$1(String currentLogicalClusteringNames$1, ClusterBySpec x$1) {
        String string = ((TraversableOnce)x$1.columnNames().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toString(), Seq$.MODULE$.canBuildFrom())).mkString(",");
        String string2 = currentLogicalClusteringNames$1;
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static void $init$(UpdateCatalogBase $this) {
    }
}

