/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.stats;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import java.util.Locale;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.LoggingShims;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.delta.DeltaColumnMapping$;
import org.apache.spark.sql.delta.DeltaColumnMappingMode;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaIllegalArgumentException;
import org.apache.spark.sql.delta.DeltaIllegalArgumentException$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaOperations;
import org.apache.spark.sql.delta.DeltaOptions;
import org.apache.spark.sql.delta.NoMapping$;
import org.apache.spark.sql.delta.OptimisticTransaction;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.DeletionVectorDescriptor;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.RemoveFile;
import org.apache.spark.sql.delta.actions.SetTransaction;
import org.apache.spark.sql.delta.catalog.DeltaTableV2;
import org.apache.spark.sql.delta.commands.DeletionVectorUtils$;
import org.apache.spark.sql.delta.commands.DeltaCommand;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.schema.SchemaUtils$;
import org.apache.spark.sql.delta.stats.DeltaStatsColumnSpec;
import org.apache.spark.sql.delta.stats.SkippingEligibleDataType$;
import org.apache.spark.sql.delta.stats.StatisticsCollection;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class StatisticsCollection$
implements DeltaCommand {
    public static StatisticsCollection$ MODULE$;
    private final char ASCII_MAX_CHARACTER;
    private final String UTF8_MAX_CHARACTER;
    private final StatisticsCollection.SqlParser parser;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new StatisticsCollection$();
    }

    @Override
    public Seq<Expression> parsePredicates(SparkSession spark, String predicate) {
        return DeltaCommand.parsePredicates$(this, spark, predicate);
    }

    @Override
    public void verifyPartitionPredicates(SparkSession spark, Seq<String> partitionColumns, Seq<Expression> predicates) {
        DeltaCommand.verifyPartitionPredicates$(this, spark, partitionColumns, predicates);
    }

    @Override
    public Map<String, AddFile> generateCandidateFileMap(Path basePath, Seq<AddFile> candidateFiles) {
        return DeltaCommand.generateCandidateFileMap$(this, basePath, candidateFiles);
    }

    @Override
    public Seq<RemoveFile> removeFilesFromPaths(DeltaLog deltaLog, Map<String, AddFile> nameToAddFileMap, Seq<String> filesToRewrite, long operationTimestamp) {
        return DeltaCommand.removeFilesFromPaths$(this, deltaLog, nameToAddFileMap, filesToRewrite, operationTimestamp);
    }

    @Override
    public HadoopFsRelation buildBaseRelation(SparkSession spark, OptimisticTransaction txn, String actionType, Path rootPath, Seq<String> inputLeafFiles, Map<String, AddFile> nameToAddFileMap) {
        return DeltaCommand.buildBaseRelation$(this, spark, txn, actionType, rootPath, inputLeafFiles, nameToAddFileMap);
    }

    @Override
    public AddFile getTouchedFile(Path basePath, String escapedFilePath, Map<String, AddFile> nameToAddFileMap) {
        return DeltaCommand.getTouchedFile$(this, basePath, escapedFilePath, nameToAddFileMap);
    }

    @Override
    public LogicalPlan resolveIdentifier(Analyzer analyzer, TableIdentifier identifier) {
        return DeltaCommand.resolveIdentifier$(this, analyzer, identifier);
    }

    @Override
    public boolean isCatalogTable(Analyzer analyzer, TableIdentifier tableIdent) {
        return DeltaCommand.isCatalogTable$(this, analyzer, tableIdent);
    }

    @Override
    public boolean isPathIdentifier(TableIdentifier tableIdent) {
        return DeltaCommand.isPathIdentifier$(this, tableIdent);
    }

    @Override
    public DeltaLog getDeltaLog(SparkSession spark, Option<String> path, Option<TableIdentifier> tableIdentifier, String operationName, Map<String, String> hadoopConf) {
        return DeltaCommand.getDeltaLog$(this, spark, path, tableIdentifier, operationName, hadoopConf);
    }

    @Override
    public Map<String, String> getDeltaLog$default$5() {
        return DeltaCommand.getDeltaLog$default$5$(this);
    }

    @Override
    public void sendDriverMetrics(SparkSession spark, Map<String, SQLMetric> metrics) {
        DeltaCommand.sendDriverMetrics$(this, spark, metrics);
    }

    @Override
    public DeltaTableV2 getDeltaTable(LogicalPlan target, String cmd) {
        return DeltaCommand.getDeltaTable$(this, target, cmd);
    }

    @Override
    public Option<CatalogTable> getTableCatalogTable(LogicalPlan target, String cmd) {
        return DeltaCommand.getTableCatalogTable$(this, target, cmd);
    }

    @Override
    public Tuple2<Option<TableIdentifier>, Option<String>> getDeltaTablePathOrIdentifier(LogicalPlan target, String cmd) {
        return DeltaCommand.getDeltaTablePathOrIdentifier$(this, target, cmd);
    }

    @Override
    public Tuple2<Option<TableIdentifier>, Option<String>> getTablePathOrIdentifier(LogicalPlan target, String cmd) {
        return DeltaCommand.getTablePathOrIdentifier$(this, target, cmd);
    }

    @Override
    public boolean hasBeenExecuted(OptimisticTransaction txn, SparkSession sparkSession, Option<DeltaOptions> options) {
        return DeltaCommand.hasBeenExecuted$(this, txn, sparkSession, options);
    }

    @Override
    public Option<DeltaOptions> hasBeenExecuted$default$3() {
        return DeltaCommand.hasBeenExecuted$default$3$(this);
    }

    @Override
    public Option<SetTransaction> createSetTransaction(SparkSession sparkSession, DeltaLog deltaLog, Option<DeltaOptions> options) {
        return DeltaCommand.createSetTransaction$(this, sparkSession, deltaLog, options);
    }

    @Override
    public Option<DeltaOptions> createSetTransaction$default$3() {
        return DeltaCommand.createSetTransaction$default$3$(this);
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void deltaAssert(Function0<Object> check, String name, String msg, DeltaLog deltaLog, Object data, Option<Path> path) {
        DeltaLogging.deltaAssert$(this, check, name, msg, deltaLog, data, path);
    }

    @Override
    public DeltaLog deltaAssert$default$4() {
        return DeltaLogging.deltaAssert$default$4$(this);
    }

    @Override
    public Object deltaAssert$default$5() {
        return DeltaLogging.deltaAssert$default$5$(this);
    }

    @Override
    public Option<Path> deltaAssert$default$6() {
        return DeltaLogging.deltaAssert$default$6$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public Map<String, Object> getErrorData(Throwable e) {
        return DeltaLogging.getErrorData$(this, e);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    @Override
    public LoggingShims.LogStringContext LogStringContext(StringContext sc) {
        return LoggingShims.LogStringContext$(this, sc);
    }

    @Override
    public void logInfo(LogEntry entry) {
        LoggingShims.logInfo$(this, entry);
    }

    @Override
    public void logInfo(LogEntry entry, Throwable throwable) {
        LoggingShims.logInfo$(this, entry, throwable);
    }

    @Override
    public void logDebug(LogEntry entry) {
        LoggingShims.logDebug$(this, entry);
    }

    @Override
    public void logDebug(LogEntry entry, Throwable throwable) {
        LoggingShims.logDebug$(this, entry, throwable);
    }

    @Override
    public void logTrace(LogEntry entry) {
        LoggingShims.logTrace$(this, entry);
    }

    @Override
    public void logTrace(LogEntry entry, Throwable throwable) {
        LoggingShims.logTrace$(this, entry, throwable);
    }

    @Override
    public void logWarning(LogEntry entry) {
        LoggingShims.logWarning$(this, entry);
    }

    @Override
    public void logWarning(LogEntry entry, Throwable throwable) {
        LoggingShims.logWarning$(this, entry, throwable);
    }

    @Override
    public void logError(LogEntry entry) {
        LoggingShims.logError$(this, entry);
    }

    @Override
    public void logError(LogEntry entry, Throwable throwable) {
        LoggingShims.logError$(this, entry, throwable);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public char ASCII_MAX_CHARACTER() {
        return this.ASCII_MAX_CHARACTER;
    }

    public String UTF8_MAX_CHARACTER() {
        return this.UTF8_MAX_CHARACTER;
    }

    private StatisticsCollection.SqlParser parser() {
        return this.parser;
    }

    public Option<Seq<UnresolvedAttribute>> parseDeltaStatsColumnNames(String deltaStatsColNames) {
        Some some;
        if (deltaStatsColNames.trim().isEmpty()) {
            return new Some((Object)Nil$.MODULE$);
        }
        try {
            some = new Some(this.parser().parseMultipartIdentifierList(deltaStatsColNames));
        }
        catch (ParseException parseException) {
            some = None$.MODULE$;
        }
        return some;
    }

    public void validateDeltaStatsColumns(Metadata metadata) {
        DeltaConfigs$.MODULE$.DATA_SKIPPING_STATS_COLUMNS().fromMetaData(metadata).foreach((Function1 & Serializable & scala.Serializable)statsColumns -> {
            StatisticsCollection$.MODULE$.validateDeltaStatsColumns(metadata.dataSchema(), metadata.partitionColumns(), statsColumns);
            return BoxedUnit.UNIT;
        });
    }

    private void validateDataSkippingType(String name, DataType dataType, ArrayBuffer<String> columnPaths, boolean insideStruct) {
        DataType dataType2 = dataType;
        if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            structType.foreach((Function1 & Serializable & scala.Serializable)field -> {
                StatisticsCollection$.MODULE$.validateDataSkippingType(new StringBuilder(1).append(name).append(".").append(field.name()).toString(), field.dataType(), (ArrayBuffer<String>)columnPaths, true);
                return BoxedUnit.UNIT;
            });
            return;
        }
        Option<DataType> option = SkippingEligibleDataType$.MODULE$.unapply(dataType2);
        if (!option.isEmpty()) {
            columnPaths.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{name}));
            return;
        }
        if (insideStruct) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Data skipping is not supported for column ").append(name).append(" of type ").append(dataType).toString());
            columnPaths.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{name}));
            return;
        }
        throw new DeltaIllegalArgumentException("DELTA_COLUMN_DATA_SKIPPING_NOT_SUPPORTED_TYPE", (String[])((Object[])new String[]{name, dataType.toString()}), DeltaIllegalArgumentException$.MODULE$.$lessinit$greater$default$3());
    }

    private boolean validateDataSkippingType$default$4() {
        return false;
    }

    public void validateDeltaStatsColumns(StructType schema, Seq<String> partitionColumns, String deltaStatsColumnsConfigs) {
        Set partitionColumnSet = ((TraversableOnce)partitionColumns.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.toLowerCase(Locale.ROOT), Seq$.MODULE$.canBuildFrom())).toSet();
        ArrayBuffer visitedColumns = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        this.parseDeltaStatsColumnNames(deltaStatsColumnsConfigs).foreach((Function1 & Serializable & scala.Serializable)columns -> {
            columns.foreach((Function1 & Serializable & scala.Serializable)columnAttribute -> {
                Seq columnFullPath = columnAttribute.nameParts();
                if (partitionColumnSet$1.contains((Object)columnAttribute.name().toLowerCase(Locale.ROOT))) {
                    throw new DeltaIllegalArgumentException("DELTA_COLUMN_DATA_SKIPPING_NOT_SUPPORTED_PARTITIONED_COLUMN", (String[])((Object[])new String[]{columnAttribute.name()}), DeltaIllegalArgumentException$.MODULE$.$lessinit$greater$default$3());
                }
                SchemaUtils$.MODULE$.findColumnPosition((Seq<String>)columnFullPath, (DataType)schema$1, SchemaUtils$.MODULE$.findColumnPosition$default$3());
                Tuple2 tuple2 = columnFullPath.splitAt(columnFullPath.size() - 1);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Seq prefixPath = (Seq)tuple2._1();
                Seq columnName = (Seq)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)prefixPath, (Object)columnName);
                Seq prefixPath2 = (Seq)tuple22._1();
                Seq columnName2 = (Seq)tuple22._2();
                return SchemaUtils$.MODULE$.transformSchema(schema$1, (Option<String>)new Some(columnName2.head()), (Function3<Seq<String>, DataType, Function2<String, String, Object>, DataType>)(Function3 & Serializable & scala.Serializable)(x0$1, x1$1, x2$1) -> {
                    Tuple3 tuple3 = new Tuple3(x0$1, x1$1, x2$1);
                    if (tuple3 != null) {
                        Seq seq = (Seq)tuple3._1();
                        DataType struct = (DataType)tuple3._2();
                        Seq seq2 = prefixPath2;
                        Seq seq3 = seq;
                        if (!(seq2 != null ? !seq2.equals(seq3) : seq3 != null) && struct instanceof StructType) {
                            StructType structType = (StructType)struct;
                            StructField columnField = structType.apply((String)columnName2.head());
                            StatisticsCollection$.MODULE$.validateDataSkippingType(columnAttribute.name(), columnField.dataType(), (ArrayBuffer<String>)visitedColumns$1, StatisticsCollection$.MODULE$.validateDataSkippingType$default$4());
                            return structType;
                        }
                    }
                    if (tuple3 != null) {
                        DataType other = (DataType)tuple3._2();
                        return other;
                    }
                    throw new MatchError((Object)tuple3);
                });
            });
            return BoxedUnit.UNIT;
        });
        Seq duplicatedColumnNames = ((TraversableOnce)visitedColumns.groupBy((Function1 & Serializable & scala.Serializable)x -> (String)Predef$.MODULE$.identity(x)).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Tuple2<String, ArrayBuffer<String>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    String attribute = (String)A1._1();
                    ArrayBuffer occurrences = (ArrayBuffer)A1._2();
                    if (occurrences.size() > 1) {
                        return (B1)attribute;
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<String, ArrayBuffer<String>> x1) {
                ArrayBuffer occurrences;
                Tuple2<String, ArrayBuffer<String>> tuple2 = x1;
                return tuple2 != null && (occurrences = (ArrayBuffer)tuple2._2()).size() > 1;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        if (duplicatedColumnNames.size() > 0) {
            throw new DeltaIllegalArgumentException("DELTA_DUPLICATE_DATA_SKIPPING_COLUMNS", (String[])((Object[])new String[]{duplicatedColumnNames.mkString(",")}), DeltaIllegalArgumentException$.MODULE$.$lessinit$greater$default$3());
        }
    }

    public Map<String, String> dropDeltaStatsColumns(Metadata metadata, Seq<Seq<String>> columnsToDrop) {
        if (columnsToDrop.isEmpty()) {
            return Predef$.MODULE$.Map().empty();
        }
        DeltaStatsColumnSpec deltaStatsColumnSpec = this.configuredDeltaStatsColumnSpec(metadata);
        return (Map)deltaStatsColumnSpec.deltaStatsColumnNamesOpt().map((Function1 & Serializable & scala.Serializable)deltaColumnsNames -> {
            Set droppedColumnSet = columnsToDrop.toSet();
            String deltaStatsColumnStr = ((TraversableOnce)((TraversableLike)((TraversableLike)deltaColumnsNames.map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.nameParts(), Seq$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)attributeNameParts -> BoxesRunTime.boxToBoolean((boolean)StatisticsCollection$.$anonfun$dropDeltaStatsColumns$3(droppedColumnSet, attributeNameParts)))).map((Function1 & Serializable & scala.Serializable)columnParts -> new UnresolvedAttribute(columnParts).name(), Seq$.MODULE$.canBuildFrom())).mkString(",");
            return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DeltaConfigs$.MODULE$.DATA_SKIPPING_STATS_COLUMNS().key()), (Object)deltaStatsColumnStr)}));
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
    }

    public Map<String, String> renameDeltaStatsColumn(Metadata metadata, Seq<String> oldColumnPath, Seq<String> newColumnPath) {
        Seq<String> seq = oldColumnPath;
        Seq<String> seq2 = newColumnPath;
        if (!(seq != null ? !seq.equals(seq2) : seq2 != null)) {
            return Predef$.MODULE$.Map().empty();
        }
        DeltaStatsColumnSpec deltaStatsColumnSpec = this.configuredDeltaStatsColumnSpec(metadata);
        return (Map)deltaStatsColumnSpec.deltaStatsColumnNamesOpt().map((Function1 & Serializable & scala.Serializable)deltaColumnsNames -> {
            Seq deltaStatsColumnsPath = (Seq)((TraversableLike)((TraversableLike)deltaColumnsNames.map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.nameParts(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)attributeNameParts -> {
                int commonPrefix = ((SeqLike)((IterableLike)oldColumnPath.zip((GenIterable)attributeNameParts, Seq$.MODULE$.canBuildFrom())).takeWhile((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)StatisticsCollection$.$anonfun$renameDeltaStatsColumn$4(x0$1)))).size();
                if (commonPrefix == oldColumnPath.size()) {
                    return (Seq)newColumnPath.$plus$plus((GenTraversableOnce)attributeNameParts.takeRight(attributeNameParts.size() - commonPrefix), Seq$.MODULE$.canBuildFrom());
                }
                return attributeNameParts;
            }, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)columnParts -> new UnresolvedAttribute(columnParts).name(), Seq$.MODULE$.canBuildFrom());
            return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DeltaConfigs$.MODULE$.DATA_SKIPPING_STATS_COLUMNS().key()), (Object)deltaStatsColumnsPath.mkString(","))}));
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
    }

    public DeltaStatsColumnSpec configuredDeltaStatsColumnSpec(Metadata metadata) {
        Option<String> indexedColNamesOpt = DeltaConfigs$.MODULE$.DATA_SKIPPING_STATS_COLUMNS().fromMetaData(metadata);
        int numIndexedCols = BoxesRunTime.unboxToInt((Object)DeltaConfigs$.MODULE$.DATA_SKIPPING_NUM_INDEXED_COLS().fromMetaData(metadata));
        return (DeltaStatsColumnSpec)indexedColNamesOpt.map((Function1 & Serializable & scala.Serializable)indexedColNames -> new DeltaStatsColumnSpec(MODULE$.parseDeltaStatsColumnNames((String)indexedColNames), (Option<Object>)None$.MODULE$)).getOrElse((Function0 & Serializable & scala.Serializable)() -> new DeltaStatsColumnSpec((Option<Seq<UnresolvedAttribute>>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)numIndexedCols))));
    }

    private StructField convertToPhysicalName(String fullPath, StructField field, Seq<String> schemaNames, DeltaColumnMappingMode mappingMode) {
        DeltaColumnMappingMode deltaColumnMappingMode = mappingMode;
        NoMapping$ noMapping$ = NoMapping$.MODULE$;
        if (!(deltaColumnMappingMode == null ? noMapping$ != null : !deltaColumnMappingMode.equals(noMapping$)) || schemaNames.contains((Object)fullPath)) {
            return field;
        }
        String physicalName = field.metadata().getString(DeltaColumnMapping$.MODULE$.COLUMN_MAPPING_PHYSICAL_NAME_KEY());
        DataType dataType = field.dataType();
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructType newDataType = StructType$.MODULE$.apply((Seq)structType.map((Function1 & Serializable & scala.Serializable)child -> MODULE$.convertToPhysicalName(fullPath, (StructField)child, schemaNames, mappingMode), Seq$.MODULE$.canBuildFrom()));
            return field.copy(physicalName, (DataType)newDataType, field.copy$default$3(), field.copy$default$4());
        }
        return field.copy(physicalName, field.copy$default$2(), field.copy$default$3(), field.copy$default$4());
    }

    private StructType filterSchema(Seq<String> schemaNames, StructType schema, Seq<Seq<String>> statsColPaths, DeltaColumnMappingMode mappingMode, Seq<String> parentPath) {
        Map cols = statsColPaths.groupBy((Function1 & Serializable & scala.Serializable)x$13 -> (String)x$13.head()).mapValues((Function1 & Serializable & scala.Serializable)x$14 -> (Seq)x$14.map((Function1 & Serializable & scala.Serializable)x$15 -> (Seq)x$15.tail(), Seq$.MODULE$.canBuildFrom()));
        Seq newSchema = (Seq)schema.flatMap((Function1 & Serializable & scala.Serializable)field -> {
            String lowerCaseFieldName = field.name().toLowerCase(Locale.ROOT);
            return Option$.MODULE$.option2Iterable(cols.get((Object)lowerCaseFieldName).flatMap((Function1 & Serializable & scala.Serializable)paths -> {
                DataType dataType = field.dataType();
                if (paths.forall((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)x$16.isEmpty()))) {
                    String fullPath = ((TraversableOnce)parentPath.$colon$plus((Object)field.name(), Seq$.MODULE$.canBuildFrom())).mkString(".").toLowerCase(Locale.ROOT);
                    return new Some((Object)MODULE$.convertToPhysicalName(fullPath, (StructField)field, schemaNames, mappingMode));
                }
                if (dataType instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    String fullPath = ((TraversableOnce)parentPath.$colon$plus((Object)field.name(), Seq$.MODULE$.canBuildFrom())).mkString(".").toLowerCase(Locale.ROOT);
                    DeltaColumnMappingMode deltaColumnMappingMode = mappingMode;
                    NoMapping$ noMapping$ = NoMapping$.MODULE$;
                    String physicalName = !(deltaColumnMappingMode == null ? noMapping$ != null : !deltaColumnMappingMode.equals(noMapping$)) || schemaNames.contains((Object)fullPath) ? field.name() : field.metadata().getString(DeltaColumnMapping$.MODULE$.COLUMN_MAPPING_PHYSICAL_NAME_KEY());
                    StructType newSchema = MODULE$.filterSchema(schemaNames, structType, (Seq<Seq<String>>)((Seq)paths.filterNot((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)x$17.isEmpty()))), mappingMode, (Seq<String>)((Seq)parentPath.$colon$plus((Object)field.name(), Seq$.MODULE$.canBuildFrom())));
                    return new Some((Object)field.copy(physicalName, (DataType)newSchema, field.copy$default$3(), field.copy$default$4()));
                }
                return None$.MODULE$;
            }));
        }, Seq$.MODULE$.canBuildFrom());
        return new StructType((StructField[])newSchema.toArray(ClassTag$.MODULE$.apply(StructField.class)));
    }

    private Seq<String> filterSchema$default$5() {
        return (Seq)Nil$.MODULE$;
    }

    public StructType getIndexedColumns(Seq<String> schemaNames, DeltaStatsColumnSpec spec, StructType schema, DeltaColumnMappingMode mappingMode) {
        return (StructType)spec.deltaStatsColumnNamesOpt().map((Function1 & Serializable & scala.Serializable)indexedColNames -> {
            Seq indexedColPaths = (Seq)indexedColNames.map((Function1 & Serializable & scala.Serializable)x$18 -> (Seq)x$18.nameParts().map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.toLowerCase(Locale.ROOT), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
            return MODULE$.filterSchema(schemaNames, schema, (Seq<Seq<String>>)indexedColPaths, mappingMode, MODULE$.filterSchema$default$5());
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            int numIndexedCols = BoxesRunTime.unboxToInt((Object)spec.numIndexedColsOpt().get());
            if (numIndexedCols < 0) {
                return schema;
            }
            return (StructType)MODULE$.truncateSchema(schema, numIndexedCols)._1();
        });
    }

    /*
     * Unable to fully structure code
     */
    private Tuple2<StructType, Object> truncateSchema(StructType schema, int indexedCols) {
        accCnt = 0;
        fields = new ArrayBuffer();
        for (i = 0; i < schema.length() && accCnt < indexedCols; ++i) {
            field = schema.fields()[i];
            var10_8 = field;
            if (var10_8 == null) ** GOTO lbl-1000
            name = var10_8.name();
            st = var10_8.dataType();
            nullable = var10_8.nullable();
            metadata = var10_8.metadata();
            if (st instanceof StructType) {
                var15_13 = (StructType)st;
                var17_15 = this.truncateSchema(var15_13, indexedCols - accCnt);
                if (var17_15 == null) {
                    throw new MatchError(var17_15);
                }
                newSt = (StructType)var17_15._1();
                cnt = var17_15._2$mcI$sp();
                var16_14 = new Tuple2((Object)newSt, (Object)BoxesRunTime.boxToInteger((int)cnt));
                newSt = (StructType)var16_14._1();
                cnt = var16_14._2$mcI$sp();
                accCnt += cnt;
                v0 = new StructField(name, (DataType)newSt, nullable, metadata);
            } else lbl-1000:
            // 2 sources

            {
                ++accCnt;
                v0 = var10_8;
            }
            newField = v0;
            fields.$plus$eq((Object)newField);
        }
        return new Tuple2((Object)StructType$.MODULE$.apply(fields.toSeq()), (Object)BoxesRunTime.boxToInteger((int)accCnt));
    }

    private AddFile[] computeNewAddFiles(DeltaLog deltaLog, OptimisticTransaction txn, Seq<AddFile> files) {
        Path dataPath = deltaLog.dataPath();
        Map<String, AddFile> pathToAddFileMap = this.generateCandidateFileMap(dataPath, files);
        boolean persistentDVsReadable = DeletionVectorUtils$.MODULE$.deletionVectorsReadable(txn.snapshot(), DeletionVectorUtils$.MODULE$.deletionVectorsReadable$default$2(), DeletionVectorUtils$.MODULE$.deletionVectorsReadable$default$3());
        if (persistentDVsReadable) {
            throw DeltaErrors$.MODULE$.statsRecomputeNotSupportedOnDvTables();
        }
        Dataset fileDataFrame = deltaLog.createDataFrame(txn.snapshot(), files, false, deltaLog.createDataFrame$default$4()).withColumn("path", functions$.MODULE$.col("_metadata.file_path"));
        Dataset newStats = fileDataFrame.groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("path")})).agg(functions$.MODULE$.to_json(txn.statsCollector()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0]));
        return (AddFile[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newStats.collect())).map((Function1 & Serializable & scala.Serializable)r -> {
            AddFile add = MODULE$.getTouchedFile(dataPath, r.getString(0), pathToAddFileMap);
            boolean x$1 = false;
            String x$2 = r.getString(1);
            String x$3 = add.copy$default$1();
            Map<String, String> x$4 = add.copy$default$2();
            long x$5 = add.copy$default$3();
            long x$6 = add.copy$default$4();
            Map<String, String> x$7 = add.copy$default$7();
            DeletionVectorDescriptor x$8 = add.copy$default$8();
            Option<Object> x$9 = add.copy$default$9();
            Option<Object> x$10 = add.copy$default$10();
            Option<String> x$11 = add.copy$default$11();
            return add.copy(x$3, x$4, x$5, x$6, x$1, x$2, x$7, x$8, x$9, x$10, x$11);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(AddFile.class)));
    }

    public void recompute(SparkSession spark, DeltaLog deltaLog, Option<CatalogTable> catalogTable, Seq<Expression> predicates, Function1<AddFile, Object> fileFilter) {
        OptimisticTransaction txn = deltaLog.startTransaction(catalogTable, deltaLog.startTransaction$default$2());
        this.verifyPartitionPredicates(spark, txn.metadata().partitionColumns(), predicates);
        Seq files = (Seq)txn.filterFiles(predicates, txn.filterFiles$default$2()).filter(fileFilter);
        AddFile[] newAddFiles = this.computeNewAddFiles(deltaLog, txn, (Seq<AddFile>)files);
        txn.commit((Seq<Action>)Predef$.MODULE$.wrapRefArray((Object[])newAddFiles), new DeltaOperations.ComputeStats(predicates));
    }

    public Seq<Expression> recompute$default$4() {
        return (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)Nil$.MODULE$);
    }

    public Function1<AddFile, Object> recompute$default$5() {
        return (Function1 & Serializable & scala.Serializable)af -> BoxesRunTime.boxToBoolean((boolean)StatisticsCollection$.$anonfun$recompute$default$5$1(af));
    }

    public String truncateMinStringAgg(int prefixLen, String input) {
        if (input == null || input.length() <= prefixLen) {
            return input;
        }
        if (prefixLen <= 0) {
            return null;
        }
        if (Character.isHighSurrogate(input.charAt(prefixLen - 1)) && Character.isLowSurrogate(input.charAt(prefixLen))) {
            return (String)new StringOps(Predef$.MODULE$.augmentString(input)).take(prefixLen + 1);
        }
        return (String)new StringOps(Predef$.MODULE$.augmentString(input)).take(prefixLen);
    }

    public String truncateMaxStringAgg(int prefixLen, String originalMax) {
        if (originalMax == null || originalMax.length() <= prefixLen) {
            return originalMax;
        }
        if (prefixLen <= 0) {
            return null;
        }
        int maxLen = this.getExpansionLimit(prefixLen);
        for (int currLen = this.truncateMinStringAgg(prefixLen, originalMax).length(); currLen <= maxLen; currLen += 2) {
            if (currLen >= originalMax.length()) {
                return originalMax;
            }
            if (currLen + 1 < originalMax.length()) {
                String string = originalMax.substring(currLen, currLen + 2);
                String string2 = this.UTF8_MAX_CHARACTER();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    continue;
                }
            }
            if (originalMax.charAt(currLen) < this.ASCII_MAX_CHARACTER()) {
                return new StringBuilder(0).append((String)new StringOps(Predef$.MODULE$.augmentString(originalMax)).take(currLen)).append(this.ASCII_MAX_CHARACTER()).toString();
            }
            return new StringBuilder(0).append((String)new StringOps(Predef$.MODULE$.augmentString(originalMax)).take(currLen)).append(this.UTF8_MAX_CHARACTER()).toString();
        }
        return null;
    }

    private int getExpansionLimit(int prefixLen) {
        return 2 * prefixLen;
    }

    public static final /* synthetic */ boolean $anonfun$dropDeltaStatsColumns$5(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String left = (String)tuple2._1();
            String right = (String)tuple2._2();
            String string = left;
            String string2 = right;
            return !(string != null ? !string.equals(string2) : string2 != null);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$dropDeltaStatsColumns$4(Seq attributeNameParts$1, Seq droppedColumnParts) {
        int commonPrefix = ((SeqLike)((IterableLike)droppedColumnParts.zip((GenIterable)attributeNameParts$1, Seq$.MODULE$.canBuildFrom())).takeWhile((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)StatisticsCollection$.$anonfun$dropDeltaStatsColumns$5(x0$1)))).size();
        return commonPrefix == droppedColumnParts.size();
    }

    public static final /* synthetic */ boolean $anonfun$dropDeltaStatsColumns$3(Set droppedColumnSet$1, Seq attributeNameParts) {
        return ((TraversableOnce)droppedColumnSet$1.filter((Function1 & Serializable & scala.Serializable)droppedColumnParts -> BoxesRunTime.boxToBoolean((boolean)StatisticsCollection$.$anonfun$dropDeltaStatsColumns$4(attributeNameParts, droppedColumnParts)))).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$renameDeltaStatsColumn$4(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String left = (String)tuple2._1();
            String right = (String)tuple2._2();
            String string = left;
            String string2 = right;
            return !(string != null ? !string.equals(string2) : string2 != null);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$recompute$default$5$1(AddFile af) {
        return true;
    }

    private StatisticsCollection$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        LoggingShims.$init$(this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
        DeltaCommand.$init$(this);
        this.ASCII_MAX_CHARACTER = (char)127;
        this.UTF8_MAX_CHARACTER = new String(Character.toChars(0x10FFFF));
        this.parser = new StatisticsCollection.SqlParser();
    }
}

