/*
 * Decompiled with CFR 0.152.
 */
package io.delta.dynamodbcommitcoordinator;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import io.delta.dynamodbcommitcoordinator.DynamoDBCommitCoordinatorClient;
import io.delta.dynamodbcommitcoordinator.ReflectionUtils;
import io.delta.storage.commit.CommitCoordinatorClient;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.delta.coordinatedcommits.CommitCoordinatorBuilder;
import org.apache.spark.sql.delta.sources.DeltaSQLConf;
import scala.collection.immutable.Map;

public class DynamoDBCommitCoordinatorClientBuilder
implements CommitCoordinatorBuilder {
    private final long BACKFILL_BATCH_SIZE = 1L;
    private static final String COORDINATED_COMMITS_TABLE_NAME_KEY = "dynamoDBTableName";
    private static final String DYNAMO_DB_ENDPOINT_KEY = "dynamoDBEndpoint";

    @Override
    public String getName() {
        return "dynamodb";
    }

    @Override
    public CommitCoordinatorClient build(SparkSession sparkSession, Map<String, String> map) {
        String string = (String)map.get((Object)COORDINATED_COMMITS_TABLE_NAME_KEY).getOrElse(() -> {
            throw new RuntimeException("dynamoDBTableName not found");
        });
        String string2 = (String)map.get((Object)DYNAMO_DB_ENDPOINT_KEY).getOrElse(() -> {
            throw new RuntimeException("dynamoDBEndpoint not found");
        });
        String string3 = (String)sparkSession.conf().get(DeltaSQLConf.COORDINATED_COMMITS_DDB_AWS_CREDENTIALS_PROVIDER_NAME());
        int n = Integer.parseInt(sparkSession.conf().get(DeltaSQLConf.COORDINATED_COMMITS_DDB_READ_CAPACITY_UNITS().key()));
        int n2 = Integer.parseInt(sparkSession.conf().get(DeltaSQLConf.COORDINATED_COMMITS_DDB_WRITE_CAPACITY_UNITS().key()));
        boolean bl = Boolean.parseBoolean(sparkSession.conf().get(DeltaSQLConf.COORDINATED_COMMITS_DDB_SKIP_PATH_CHECK().key()));
        try {
            AmazonDynamoDB amazonDynamoDB = this.createAmazonDDBClient(string2, string3, sparkSession.sessionState().newHadoopConf());
            return this.getDynamoDBCommitCoordinatorClient(string, string2, amazonDynamoDB, 1L, n, n2, bl);
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to create DynamoDB client", exception);
        }
    }

    protected DynamoDBCommitCoordinatorClient getDynamoDBCommitCoordinatorClient(String string, String string2, AmazonDynamoDB amazonDynamoDB, long l, int n, int n2, boolean bl) throws IOException {
        return new DynamoDBCommitCoordinatorClient(string, string2, amazonDynamoDB, l, n, n2, bl);
    }

    protected AmazonDynamoDB createAmazonDDBClient(String string, String string2, Configuration configuration) throws ReflectiveOperationException {
        AWSCredentialsProvider aWSCredentialsProvider = ReflectionUtils.createAwsCredentialsProvider(string2, configuration);
        AmazonDynamoDBClient amazonDynamoDBClient = new AmazonDynamoDBClient(aWSCredentialsProvider);
        amazonDynamoDBClient.setEndpoint(string);
        return amazonDynamoDBClient;
    }
}

