/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import java.io.Serializable;
import java.sql.Timestamp;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.delta.CurrentTransactionInfo;
import org.apache.spark.sql.delta.DefaultRowCommitVersion$;
import org.apache.spark.sql.delta.DeltaCommitTag$;
import org.apache.spark.sql.delta.DeltaCommitTag$PreservedRowTrackingTag$;
import org.apache.spark.sql.delta.DeltaCommitTag$RowTrackingEnablementOnlyTag$;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaOperations;
import org.apache.spark.sql.delta.DeltaTableReadPredicate;
import org.apache.spark.sql.delta.RowCommitVersion$;
import org.apache.spark.sql.delta.RowId$;
import org.apache.spark.sql.delta.RowTrackingFeature$;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.SnapshotDescriptor;
import org.apache.spark.sql.delta.WinningCommitSummary;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.CommitInfo;
import org.apache.spark.sql.delta.actions.DomainMetadata;
import org.apache.spark.sql.delta.actions.JobInfo;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.NotebookInfo;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.actions.TableFeatureProtocolUtils$;
import org.apache.spark.sql.types.StructField;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class RowTracking$ {
    public static RowTracking$ MODULE$;

    static {
        new RowTracking$();
    }

    public boolean isSupported(Protocol protocol) {
        return protocol.isFeatureSupported(RowTrackingFeature$.MODULE$);
    }

    public boolean isEnabled(Protocol protocol, Metadata metadata) {
        boolean isEnabled = BoxesRunTime.unboxToBoolean((Object)DeltaConfigs$.MODULE$.ROW_TRACKING_ENABLED().fromMetaData(metadata));
        if (isEnabled && !this.isSupported(protocol)) {
            throw new IllegalStateException(new StringBuilder(94).append("Table property '").append(DeltaConfigs$.MODULE$.ROW_TRACKING_ENABLED().key()).append("' is ").append("set on the table but this table version doesn't support table feature ").append("'").append(TableFeatureProtocolUtils$.MODULE$.propertyKey(RowTrackingFeature$.MODULE$)).append("'.").toString());
        }
        return isEnabled;
    }

    public void checkStatsCollectedIfRowTrackingSupported(Protocol protocol, boolean convertToDeltaShouldCollectStats, boolean statsCollectionEnabled) {
        if (!this.isSupported(protocol)) {
            return;
        }
        if (!convertToDeltaShouldCollectStats || !statsCollectionEnabled) {
            throw DeltaErrors$.MODULE$.convertToDeltaRowTrackingEnabledWithoutStatsCollection();
        }
    }

    public Iterable<StructField> createMetadataStructFields(Protocol protocol, Metadata metadata, boolean nullable) {
        return (Iterable)((TraversableLike)((TraversableLike)Option$.MODULE$.option2Iterable(RowId$.MODULE$.createRowIdField(protocol, metadata, nullable)).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(RowId$.MODULE$.createBaseRowIdField(protocol, metadata)), Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(DefaultRowCommitVersion$.MODULE$.createDefaultRowCommitVersionField(protocol, metadata)), Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(RowCommitVersion$.MODULE$.createMetadataStructField(protocol, metadata, nullable)), Iterable$.MODULE$.canBuildFrom());
    }

    private Map<String, String> addPreservedRowTrackingTag(Map<String, String> tagsMap, boolean preserved) {
        return tagsMap.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DeltaCommitTag$PreservedRowTrackingTag$.MODULE$.key()), (Object)Boolean.toString(preserved)));
    }

    private boolean addPreservedRowTrackingTag$default$2() {
        return true;
    }

    public Map<String, String> addPreservedRowTrackingTagIfNotSet(SnapshotDescriptor snapshot, Map<String, String> tagsMap) {
        if (!this.isEnabled(snapshot.protocol(), snapshot.metadata()) || tagsMap.contains((Object)DeltaCommitTag$PreservedRowTrackingTag$.MODULE$.key())) {
            return tagsMap;
        }
        return this.addPreservedRowTrackingTag(tagsMap, this.addPreservedRowTrackingTag$default$2());
    }

    public Map<String, String> addPreservedRowTrackingTagIfNotSet$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    private CommitInfo addRowTrackingNotPreservedTag(CommitInfo commitInfo) {
        Map tagsMap = (Map)commitInfo.tags().getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
        Map<String, String> newCommitInfoTags = this.addPreservedRowTrackingTag((Map<String, String>)tagsMap, false);
        Some x$1 = new Some(newCommitInfoTags);
        Option<Object> x$2 = commitInfo.copy$default$1();
        Option<Object> x$3 = commitInfo.copy$default$2();
        Timestamp x$4 = commitInfo.copy$default$3();
        Option<String> x$5 = commitInfo.copy$default$4();
        Option<String> x$6 = commitInfo.copy$default$5();
        String x$7 = commitInfo.copy$default$6();
        Map<String, String> x$8 = commitInfo.copy$default$7();
        Option<JobInfo> x$9 = commitInfo.copy$default$8();
        Option<NotebookInfo> x$10 = commitInfo.copy$default$9();
        Option<String> x$11 = commitInfo.copy$default$10();
        Option<Object> x$12 = commitInfo.copy$default$11();
        Option<String> x$13 = commitInfo.copy$default$12();
        Option<Object> x$14 = commitInfo.copy$default$13();
        Option<Map<String, String>> x$15 = commitInfo.copy$default$14();
        Option<String> x$16 = commitInfo.copy$default$15();
        Option<String> x$17 = commitInfo.copy$default$17();
        Option<String> x$18 = commitInfo.copy$default$18();
        return commitInfo.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, (Option<Map<String, String>>)x$1, x$17, x$18);
    }

    private boolean isRowTrackingEnablementOnlyCommit(Option<CommitInfo> commitInfo) {
        return DeltaCommitTag$.MODULE$.getTagValueFromCommitInfo(commitInfo, DeltaCommitTag$RowTrackingEnablementOnlyTag$.MODULE$.key()).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)RowTracking$.$anonfun$isRowTrackingEnablementOnlyCommit$1(x$1)));
    }

    public boolean canResolveMetadataUpdateConflict(CurrentTransactionInfo currentTransactionInfo, WinningCommitSummary winningCommitSummary) {
        if (!this.isSupported(currentTransactionInfo.protocol())) {
            return false;
        }
        return this.isRowTrackingEnablementOnlyCommit(winningCommitSummary.commitInfo()) && !currentTransactionInfo.metadataChanged();
    }

    public CurrentTransactionInfo resolveRowTrackingEnablementOnlyMetadataUpdateConflict(CurrentTransactionInfo currentTransactionInfo, WinningCommitSummary winningCommitSummary) {
        Metadata newMetadata;
        Predef$.MODULE$.require(this.canResolveMetadataUpdateConflict(currentTransactionInfo, winningCommitSummary));
        Option newCommitInfo = currentTransactionInfo.commitInfo().map((Function1 & Serializable & scala.Serializable)commitInfo -> MODULE$.addRowTrackingNotPreservedTag((CommitInfo)commitInfo));
        Metadata x$1 = newMetadata = (Metadata)winningCommitSummary.metadataUpdates().head();
        Option x$2 = newCommitInfo;
        String x$3 = currentTransactionInfo.copy$default$1();
        Seq<DeltaTableReadPredicate> x$4 = currentTransactionInfo.copy$default$2();
        Set<AddFile> x$5 = currentTransactionInfo.copy$default$3();
        boolean x$6 = currentTransactionInfo.copy$default$4();
        Set<String> x$7 = currentTransactionInfo.copy$default$5();
        Protocol x$8 = currentTransactionInfo.copy$default$7();
        Seq<Action> x$9 = currentTransactionInfo.copy$default$8();
        Snapshot x$10 = currentTransactionInfo.copy$default$9();
        long x$11 = currentTransactionInfo.copy$default$11();
        Seq<DomainMetadata> x$12 = currentTransactionInfo.copy$default$12();
        DeltaOperations.Operation x$13 = currentTransactionInfo.copy$default$13();
        return currentTransactionInfo.copy(x$3, x$4, x$5, x$6, x$7, x$1, x$8, x$9, x$10, (Option<CommitInfo>)x$2, x$11, x$12, x$13);
    }

    public Dataset<Row> preserveRowTrackingColumns(Dataset<Row> dfWithoutRowTrackingColumns, SnapshotDescriptor snapshot) {
        Dataset<Row> dfWithRowIds = RowId$.MODULE$.preserveRowIds(dfWithoutRowTrackingColumns, snapshot);
        return RowCommitVersion$.MODULE$.preserveRowCommitVersions(dfWithRowIds, snapshot);
    }

    public static final /* synthetic */ boolean $anonfun$isRowTrackingEnablementOnlyCommit$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toBoolean();
    }

    private RowTracking$() {
        MODULE$ = this;
    }
}

