/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands;

import java.io.FileNotFoundException;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaOperations;
import org.apache.spark.sql.delta.OptimisticTransaction;
import org.apache.spark.sql.delta.commands.CloneSource;
import org.apache.spark.sql.delta.commands.CloneTableBase;
import org.apache.spark.sql.delta.commands.CloneTableCommand$;
import org.apache.spark.sql.delta.logging.DeltaLogKeys$;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.execution.metric.SQLMetric;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t]d\u0001\u0002\u001d:\u0001\u001aC\u0001\u0002\u0016\u0001\u0003\u0016\u0004%\t!\u0016\u0005\t3\u0002\u0011\t\u0012)A\u0005-\"A!\f\u0001BK\u0002\u0013\u00051\f\u0003\u0005c\u0001\tE\t\u0015!\u0003]\u0011!\u0019\u0007A!f\u0001\n\u0003!\u0007\u0002C:\u0001\u0005#\u0005\u000b\u0011B3\t\u0011Q\u0004!Q3A\u0005\u0002UD\u0001B \u0001\u0003\u0012\u0003\u0006IA\u001e\u0005\u0007\u007f\u0002!\t!!\u0001\t\u000f\u00055\u0001\u0001\"\u0015\u0002\u0010!9\u0011q\u0007\u0001\u0005\u0002\u0005e\u0002\"CA<\u0001E\u0005I\u0011AA=\u0011%\ty\tAA\u0001\n\u0003\t\t\nC\u0005\u0002\u001c\u0002\t\n\u0011\"\u0001\u0002\u001e\"I\u0011\u0011\u0015\u0001\u0012\u0002\u0013\u0005\u00111\u0015\u0005\n\u0003O\u0003\u0011\u0013!C\u0001\u0003SC\u0011\"!,\u0001#\u0003%\t!a,\t\u0013\u0005M\u0006!!A\u0005B\u0005U\u0006\"CAc\u0001\u0005\u0005I\u0011AAd\u0011%\ty\rAA\u0001\n\u0003\t\t\u000eC\u0005\u0002^\u0002\t\t\u0011\"\u0011\u0002`\"I\u0011Q\u001e\u0001\u0002\u0002\u0013\u0005\u0011q\u001e\u0005\n\u0003s\u0004\u0011\u0011!C!\u0003w<q!a@:\u0011\u0003\u0011\tA\u0002\u00049s!\u0005!1\u0001\u0005\u0007\u007ff!\tAa\u0003\t\u0013\t5\u0011D1A\u0005\u0002\u0005U\u0006\u0002\u0003B\b3\u0001\u0006I!a.\t\u0013\tE\u0011D1A\u0005\u0002\u0005U\u0006\u0002\u0003B\n3\u0001\u0006I!a.\t\u0013\tU\u0011D1A\u0005\u0002\u0005U\u0006\u0002\u0003B\f3\u0001\u0006I!a.\t\u0013\te\u0011D1A\u0005\u0002\u0005U\u0006\u0002\u0003B\u000e3\u0001\u0006I!a.\t\u0013\tu\u0011D1A\u0005\u0002\u0005U\u0006\u0002\u0003B\u00103\u0001\u0006I!a.\t\u0013\t\u0005\u0012D1A\u0005\u0002\u0005U\u0006\u0002\u0003B\u00123\u0001\u0006I!a.\t\u0013\t\u0015\u0012D1A\u0005\n\u0005U\u0006\u0002\u0003B\u00143\u0001\u0006I!a.\t\u0013\t%\u0012D1A\u0005\n\u0005U\u0006\u0002\u0003B\u00163\u0001\u0006I!a.\t\u0013\t5\u0012D1A\u0005\n\u0005U\u0006\u0002\u0003B\u00183\u0001\u0006I!a.\t\u0013\tE\u0012D1A\u0005\n\u0005U\u0006\u0002\u0003B\u001a3\u0001\u0006I!a.\t\u0013\tU\u0012D1A\u0005\n\u0005U\u0006\u0002\u0003B\u001c3\u0001\u0006I!a.\t\u0013\te\u0012D1A\u0005\n\u0005U\u0006\u0002\u0003B\u001e3\u0001\u0006I!a.\t\u0013\tu\u0012D1A\u0005\u0002\t}\u0002\u0002\u0003B(3\u0001\u0006IA!\u0011\t\u0013\tE\u0013$!A\u0005\u0002\nM\u0003\"\u0003B/3\u0005\u0005I\u0011\u0011B0\u0011%\u0011i'GA\u0001\n\u0013\u0011yGA\tDY>tW\rV1cY\u0016\u001cu.\\7b]\u0012T!AO\u001e\u0002\u0011\r|W.\\1oINT!\u0001P\u001f\u0002\u000b\u0011,G\u000e^1\u000b\u0005yz\u0014aA:rY*\u0011\u0001)Q\u0001\u0006gB\f'o\u001b\u0006\u0003\u0005\u000e\u000ba!\u00199bG\",'\"\u0001#\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u000195*\u0015\t\u0003\u0011&k\u0011!O\u0005\u0003\u0015f\u0012ab\u00117p]\u0016$\u0016M\u00197f\u0005\u0006\u001cX\r\u0005\u0002M\u001f6\tQJC\u0001O\u0003\u0015\u00198-\u00197b\u0013\t\u0001VJA\u0004Qe>$Wo\u0019;\u0011\u00051\u0013\u0016BA*N\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003-\u0019x.\u001e:dKR\u000b'\r\\3\u0016\u0003Y\u0003\"\u0001S,\n\u0005aK$aC\"m_:,7k\\;sG\u0016\fAb]8ve\u000e,G+\u00192mK\u0002\n1\u0002^1sO\u0016$\u0018\nZ3oiV\tA\f\u0005\u0002^A6\taL\u0003\u0002`{\u0005A1-\u0019;bYf\u001cH/\u0003\u0002b=\nyA+\u00192mK&#WM\u001c;jM&,'/\u0001\u0007uCJ<W\r^%eK:$\b%\u0001\fuC\ndW\r\u0015:pa\u0016\u0014H/_(wKJ\u0014\u0018\u000eZ3t+\u0005)\u0007\u0003\u00024naBt!aZ6\u0011\u0005!lU\"A5\u000b\u0005),\u0015A\u0002\u001fs_>$h(\u0003\u0002m\u001b\u00061\u0001K]3eK\u001aL!A\\8\u0003\u00075\u000b\u0007O\u0003\u0002m\u001bB\u0011a-]\u0005\u0003e>\u0014aa\u0015;sS:<\u0017a\u0006;bE2,\u0007K]8qKJ$\u0018p\u0014<feJLG-Z:!\u0003)!\u0018M]4fiB\u000bG\u000f[\u000b\u0002mB\u0011q\u000f`\u0007\u0002q*\u0011\u0011P_\u0001\u0003MNT!a_!\u0002\r!\fGm\\8q\u0013\ti\bP\u0001\u0003QCRD\u0017a\u0003;be\u001e,G\u000fU1uQ\u0002\na\u0001P5oSRtDCCA\u0002\u0003\u000b\t9!!\u0003\u0002\fA\u0011\u0001\n\u0001\u0005\u0006)&\u0001\rA\u0016\u0005\u00065&\u0001\r\u0001\u0018\u0005\u0006G&\u0001\r!\u001a\u0005\u0006i&\u0001\rA^\u0001\rO\u0016$x*\u001e;qkR\u001cV-\u001d\u000b\u0005\u0003#\tY\u0003\u0005\u0004\u0002\u0014\u0005u\u00111\u0005\b\u0005\u0003+\tIBD\u0002i\u0003/I\u0011AT\u0005\u0004\u00037i\u0015a\u00029bG.\fw-Z\u0005\u0005\u0003?\t\tCA\u0002TKFT1!a\u0007N!\u0011\t)#a\n\u000e\u0003uJ1!!\u000b>\u0005\r\u0011vn\u001e\u0005\b\u0003[Q\u0001\u0019AA\u0018\u0003Ay\u0007/\u001a:bi&|g.T3ue&\u001c7\u000fE\u0003g[B\f\t\u0004E\u0002M\u0003gI1!!\u000eN\u0005\u0011auN\\4\u0002\u0017!\fg\u000e\u001a7f\u00072|g.\u001a\u000b\u000b\u0003#\tY$!\u0012\u0002R\u0005m\u0003bBA\u001f\u0017\u0001\u0007\u0011qH\u0001\rgB\f'o[*fgNLwN\u001c\t\u0005\u0003K\t\t%C\u0002\u0002Du\u0012Ab\u00159be.\u001cVm]:j_:Dq!a\u0012\f\u0001\u0004\tI%A\u0002uq:\u0004B!a\u0013\u0002N5\t1(C\u0002\u0002Pm\u0012Qc\u00149uS6L7\u000f^5d)J\fgn]1di&|g\u000eC\u0004\u0002T-\u0001\r!!\u0016\u0002\u001dQ\f'oZ3u\t\u0016dG/\u0019'pOB!\u00111JA,\u0013\r\tIf\u000f\u0002\t\t\u0016dG/\u0019'pO\"I\u0011QL\u0006\u0011\u0002\u0003\u0007\u0011qL\u0001\u000fG>lW.\u00198e\u001b\u0016$(/[2t!\u0015a\u0015\u0011MA3\u0013\r\t\u0019'\u0014\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000b\u0019l\u0007/a\u001a\u0011\t\u0005%\u00141O\u0007\u0003\u0003WRA!!\u001c\u0002p\u00051Q.\u001a;sS\u000eT1!!\u001d>\u0003%)\u00070Z2vi&|g.\u0003\u0003\u0002v\u0005-$!C*R\u00196+GO]5d\u0003UA\u0017M\u001c3mK\u000ecwN\\3%I\u00164\u0017-\u001e7uIQ*\"!a\u001f+\t\u0005}\u0013QP\u0016\u0003\u0003\u007f\u0002B!!!\u0002\f6\u0011\u00111\u0011\u0006\u0005\u0003\u000b\u000b9)A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011R'\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u000e\u0006\r%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006!1m\u001c9z))\t\u0019!a%\u0002\u0016\u0006]\u0015\u0011\u0014\u0005\b)6\u0001\n\u00111\u0001W\u0011\u001dQV\u0002%AA\u0002qCqaY\u0007\u0011\u0002\u0003\u0007Q\rC\u0004u\u001bA\u0005\t\u0019\u0001<\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u0014\u0016\u0004-\u0006u\u0014AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003KS3\u0001XA?\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!a++\u0007\u0015\fi(\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005E&f\u0001<\u0002~\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a.\u0011\t\u0005e\u00161Y\u0007\u0003\u0003wSA!!0\u0002@\u0006!A.\u00198h\u0015\t\t\t-\u0001\u0003kCZ\f\u0017b\u0001:\u0002<\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011\u001a\t\u0004\u0019\u0006-\u0017bAAg\u001b\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111[Am!\ra\u0015Q[\u0005\u0004\u0003/l%aA!os\"I\u00111\u001c\u000b\u0002\u0002\u0003\u0007\u0011\u0011Z\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\u0005\bCBAr\u0003S\f\u0019.\u0004\u0002\u0002f*\u0019\u0011q]'\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002l\u0006\u0015(\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!=\u0002xB\u0019A*a=\n\u0007\u0005UXJA\u0004C_>dW-\u00198\t\u0013\u0005mg#!AA\u0002\u0005M\u0017AB3rk\u0006d7\u000f\u0006\u0003\u0002r\u0006u\b\"CAn/\u0005\u0005\t\u0019AAj\u0003E\u0019En\u001c8f)\u0006\u0014G.Z\"p[6\fg\u000e\u001a\t\u0003\u0011f\u0019B!\u0007B\u0003#B\u0019AJa\u0002\n\u0007\t%QJ\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0005\u0003\t\u0011cU(V%\u000e+u\fV!C\u0019\u0016{6+\u0013.F\u0003I\u0019v*\u0016*D\u000b~#\u0016I\u0011'F?NK%,\u0012\u0011\u0002'M{UKU\"F?:+VjX(G?\u001aKE*R*\u0002)M{UKU\"F?:+VjX(G?\u001aKE*R*!\u0003EqU+T0S\u000b6{e+\u0012#`\r&cUiU\u0001\u0013\u001dVkuLU#N\u001fZ+Ei\u0018$J\u0019\u0016\u001b\u0006%\u0001\tO+6{6i\u0014)J\u000b\u0012{f)\u0013'F'\u0006\tb*V'`\u0007>\u0003\u0016*\u0012#`\r&cUi\u0015\u0011\u0002%I+Uj\u0014,F\t~3\u0015\nT#T?NK%,R\u0001\u0014%\u0016kuJV#E?\u001aKE*R*`'&SV\tI\u0001\u0012\u0007>\u0003\u0016*\u0012#`\r&cUiU0T\u0013j+\u0015AE\"P!&+Ei\u0018$J\u0019\u0016\u001bvlU%[\u000b\u0002\n\u0001dQ(M+6sulU(V%\u000e+u\fV!C\u0019\u0016{6+\u0013.F\u0003e\u0019u\nT+N\u001d~\u001bv*\u0016*D\u000b~#\u0016I\u0011'F?NK%,\u0012\u0011\u00025\r{E*V'O?N{UKU\"F?:+VjX(G?\u001aKE*R*\u00027\r{E*V'O?N{UKU\"F?:+VjX(G?\u001aKE*R*!\u0003a\u0019u\nT+N\u001d~sU+T0S\u000b6{e+\u0012#`\r&cUiU\u0001\u001a\u0007>cU+\u0014(`\u001dVkuLU#N\u001fZ+Ei\u0018$J\u0019\u0016\u001b\u0006%A\fD\u001f2+VJT0O+6{6i\u0014)J\u000b\u0012{f)\u0013'F'\u0006A2i\u0014'V\u001b:{f*V'`\u0007>\u0003\u0016*\u0012#`\r&cUi\u0015\u0011\u00023\r{E*V'O?J+Uj\u0014,F\t~3\u0015\nT#T?NK%,R\u0001\u001b\u0007>cU+\u0014(`%\u0016kuJV#E?\u001aKE*R*`'&SV\tI\u0001\u0019\u0007>cU+\u0014(`\u0007>\u0003\u0016*\u0012#`\r&cUiU0T\u0013j+\u0015!G\"P\u0019VkejX\"P!&+Ei\u0018$J\u0019\u0016\u001bvlU%[\u000b\u0002\naa\\;uaV$XC\u0001B!!\u0019\t\u0019\"!\b\u0003DA!!Q\tB&\u001b\t\u00119EC\u0002\u0003Jy\u000b1\"\u001a=qe\u0016\u001c8/[8og&!!Q\nB$\u0005%\tE\u000f\u001e:jEV$X-A\u0004pkR\u0004X\u000f\u001e\u0011\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0015\u0005\r!Q\u000bB,\u00053\u0012Y\u0006C\u0003Uk\u0001\u0007a\u000bC\u0003[k\u0001\u0007A\fC\u0003dk\u0001\u0007Q\rC\u0003uk\u0001\u0007a/A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t\u0005$\u0011\u000e\t\u0006\u0019\u0006\u0005$1\r\t\b\u0019\n\u0015d\u000bX3w\u0013\r\u00119'\u0014\u0002\u0007)V\u0004H.\u001a\u001b\t\u0013\t-d'!AA\u0002\u0005\r\u0011a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011\t\b\u0005\u0003\u0002:\nM\u0014\u0002\u0002B;\u0003w\u0013aa\u00142kK\u000e$\b")
public class CloneTableCommand
extends CloneTableBase
implements scala.Serializable {
    private final CloneSource sourceTable;
    private final TableIdentifier targetIdent;
    private final Map<String, String> tablePropertyOverrides;
    private final Path targetPath;

    public static Option<Tuple4<CloneSource, TableIdentifier, Map<String, String>, Path>> unapply(CloneTableCommand cloneTableCommand) {
        return CloneTableCommand$.MODULE$.unapply(cloneTableCommand);
    }

    public static String COPIED_FILES_SIZE() {
        return CloneTableCommand$.MODULE$.COPIED_FILES_SIZE();
    }

    public static String REMOVED_FILES_SIZE() {
        return CloneTableCommand$.MODULE$.REMOVED_FILES_SIZE();
    }

    public static String NUM_COPIED_FILES() {
        return CloneTableCommand$.MODULE$.NUM_COPIED_FILES();
    }

    public static String NUM_REMOVED_FILES() {
        return CloneTableCommand$.MODULE$.NUM_REMOVED_FILES();
    }

    public static String SOURCE_NUM_OF_FILES() {
        return CloneTableCommand$.MODULE$.SOURCE_NUM_OF_FILES();
    }

    public static String SOURCE_TABLE_SIZE() {
        return CloneTableCommand$.MODULE$.SOURCE_TABLE_SIZE();
    }

    public CloneSource sourceTable() {
        return this.sourceTable;
    }

    public TableIdentifier targetIdent() {
        return this.targetIdent;
    }

    public Map<String, String> tablePropertyOverrides() {
        return this.tablePropertyOverrides;
    }

    public Path targetPath() {
        return this.targetPath;
    }

    @Override
    public Seq<Row> getOutputSeq(Map<String, Object> operationMetrics) {
        return (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operationMetrics.get((Object)CloneTableCommand$.MODULE$.SOURCE_TABLE_SIZE()), operationMetrics.get((Object)CloneTableCommand$.MODULE$.SOURCE_NUM_OF_FILES()), operationMetrics.get((Object)CloneTableCommand$.MODULE$.NUM_REMOVED_FILES()), operationMetrics.get((Object)CloneTableCommand$.MODULE$.NUM_COPIED_FILES()), operationMetrics.get((Object)CloneTableCommand$.MODULE$.REMOVED_FILES_SIZE()), operationMetrics.get((Object)CloneTableCommand$.MODULE$.COPIED_FILES_SIZE())})), (List)Nil$.MODULE$);
    }

    public Seq<Row> handleClone(SparkSession sparkSession, OptimisticTransaction txn, DeltaLog targetDeltaLog, Option<Map<String, SQLMetric>> commandMetrics) {
        Object object;
        if (!this.targetPath().isAbsolute()) {
            throw DeltaErrors$.MODULE$.cloneOnRelativePath(this.targetIdent().toString());
        }
        this.logInfo(LogEntry$.MODULE$.from((Function0<MessageWithContext>)(Function0 & Serializable & scala.Serializable)() -> this.LogStringContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cloning ", " to "}))).log((Seq<MDC>)Predef$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.CLONE_SOURCE_DESC(), this.sourceTable().description())})).$plus(this.LogStringContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq<MDC>)Predef$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.PATH(), this.targetPath())})))));
        Configuration hdpConf = sparkSession.sessionState().newHadoopConf();
        if (!BoxesRunTime.unboxToBoolean((Object)sparkSession.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_CLONE_REPLACE_ENABLED()))) {
            FileSystem targetFs = this.targetPath().getFileSystem(hdpConf);
            try {
                FileStatus[] subFiles = targetFs.listStatus(this.targetPath());
                if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])subFiles)).nonEmpty()) {
                    throw DeltaErrors$.MODULE$.cloneReplaceUnsupported(this.targetIdent());
                }
                object = BoxedUnit.UNIT;
            }
            catch (FileNotFoundException fileNotFoundException) {
                object = BoxesRunTime.boxToBoolean((boolean)targetFs.mkdirs(this.targetPath()));
            }
        } else {
            object = BoxedUnit.UNIT;
        }
        return this.handleClone(sparkSession, txn, targetDeltaLog, hdpConf, new DeltaOperations.Clone(this.sourceTable().name(), BoxesRunTime.unboxToLong((Object)this.sourceTable().snapshot().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.version())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L))), commandMetrics);
    }

    public Option<Map<String, SQLMetric>> handleClone$default$4() {
        return None$.MODULE$;
    }

    public CloneTableCommand copy(CloneSource sourceTable, TableIdentifier targetIdent, Map<String, String> tablePropertyOverrides, Path targetPath) {
        return new CloneTableCommand(sourceTable, targetIdent, tablePropertyOverrides, targetPath);
    }

    public CloneSource copy$default$1() {
        return this.sourceTable();
    }

    public TableIdentifier copy$default$2() {
        return this.targetIdent();
    }

    public Map<String, String> copy$default$3() {
        return this.tablePropertyOverrides();
    }

    public Path copy$default$4() {
        return this.targetPath();
    }

    public String productPrefix() {
        return "CloneTableCommand";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.sourceTable();
            }
            case 1: {
                return this.targetIdent();
            }
            case 2: {
                return this.tablePropertyOverrides();
            }
            case 3: {
                return this.targetPath();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CloneTableCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CloneTableCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        CloneTableCommand cloneTableCommand = (CloneTableCommand)x$1;
        CloneSource cloneSource = this.sourceTable();
        CloneSource cloneSource2 = cloneTableCommand.sourceTable();
        if (cloneSource == null) {
            if (cloneSource2 != null) {
                return false;
            }
        } else if (!cloneSource.equals(cloneSource2)) return false;
        TableIdentifier tableIdentifier = this.targetIdent();
        TableIdentifier tableIdentifier2 = cloneTableCommand.targetIdent();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        Map<String, String> map = this.tablePropertyOverrides();
        Map<String, String> map2 = cloneTableCommand.tablePropertyOverrides();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Path path = this.targetPath();
        Path path2 = cloneTableCommand.targetPath();
        if (path == null) {
            if (path2 != null) {
                return false;
            }
        } else if (!path.equals(path2)) return false;
        if (!cloneTableCommand.canEqual(this)) return false;
        return true;
    }

    public CloneTableCommand(CloneSource sourceTable, TableIdentifier targetIdent, Map<String, String> tablePropertyOverrides, Path targetPath) {
        this.sourceTable = sourceTable;
        this.targetIdent = targetIdent;
        this.tablePropertyOverrides = tablePropertyOverrides;
        this.targetPath = targetPath;
        super(sourceTable, tablePropertyOverrides, targetPath);
    }
}

