/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.LoggingShims;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.paths.SparkPath$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaErrorsBase;
import org.apache.spark.sql.delta.DeltaHistoryManager;
import org.apache.spark.sql.delta.DeltaHistoryManager$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaLog$;
import org.apache.spark.sql.delta.DeltaLogFileIndex;
import org.apache.spark.sql.delta.DeltaLogFileIndex$;
import org.apache.spark.sql.delta.DeltaOptions;
import org.apache.spark.sql.delta.DeltaTableUtils$;
import org.apache.spark.sql.delta.OptimisticTransaction;
import org.apache.spark.sql.delta.SerializableFileStatus;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.UniversalFormat$;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.FileAction;
import org.apache.spark.sql.delta.actions.RemoveFile;
import org.apache.spark.sql.delta.actions.SetTransaction;
import org.apache.spark.sql.delta.catalog.DeltaTableV2;
import org.apache.spark.sql.delta.commands.DeltaCommand;
import org.apache.spark.sql.delta.commands.DeltaVacuumStats;
import org.apache.spark.sql.delta.commands.LastVacuumInfo;
import org.apache.spark.sql.delta.commands.LastVacuumInfo$;
import org.apache.spark.sql.delta.commands.VacuumCommand;
import org.apache.spark.sql.delta.commands.VacuumCommand$;
import org.apache.spark.sql.delta.commands.VacuumCommand$VacuumType$;
import org.apache.spark.sql.delta.commands.VacuumCommandImpl;
import org.apache.spark.sql.delta.logging.DeltaLogKeys$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.DeltaFileOperations$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.delta.util.FileNames$;
import org.apache.spark.sql.delta.util.FileNames$DeltaFile$;
import org.apache.spark.sql.delta.util.FileNames$UnbackfilledDeltaFile$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.SystemClock;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class VacuumCommand$
implements VacuumCommandImpl,
scala.Serializable {
    public static VacuumCommand$ MODULE$;
    private final StructType INVENTORY_SCHEMA;
    private final Seq<String> org$apache$spark$sql$delta$commands$VacuumCommandImpl$$supportedFsForLogging;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new VacuumCommand$();
    }

    @Override
    public void logVacuumStart(SparkSession spark, DeltaLog deltaLog, Path path, Dataset<String> diff, long sizeOfDataToDelete, Option<Object> specifiedRetentionMillis, long defaultRetentionMillis) {
        VacuumCommandImpl.logVacuumStart$(this, spark, deltaLog, path, diff, sizeOfDataToDelete, specifiedRetentionMillis, defaultRetentionMillis);
    }

    @Override
    public void logVacuumEnd(DeltaLog deltaLog, SparkSession spark, Path path, Map<String, SQLMetric> commandMetrics, Option<Object> filesDeleted, Option<Object> dirCounts) {
        VacuumCommandImpl.logVacuumEnd$(this, deltaLog, spark, path, commandMetrics, filesDeleted, dirCounts);
    }

    @Override
    public Option<Object> logVacuumEnd$default$5() {
        return VacuumCommandImpl.logVacuumEnd$default$5$(this);
    }

    @Override
    public Option<Object> logVacuumEnd$default$6() {
        return VacuumCommandImpl.logVacuumEnd$default$6$(this);
    }

    @Override
    public void setCommitClock(DeltaLog deltaLog, long version) {
        VacuumCommandImpl.setCommitClock$(this, deltaLog, version);
    }

    @Override
    public String relativize(Path path, FileSystem fs, Path reservoirBase, boolean isDir) {
        return VacuumCommandImpl.relativize$(this, path, fs, reservoirBase, isDir);
    }

    @Override
    public Iterator<String> getAllSubdirs(String base, String file, FileSystem fs) {
        return VacuumCommandImpl.getAllSubdirs$(this, base, file, fs);
    }

    @Override
    public long delete(Dataset<String> diff, SparkSession spark, String basePath, Broadcast<SerializableConfiguration> hadoopConf, boolean parallel, int parallelPartitions) {
        return VacuumCommandImpl.delete$(this, diff, spark, basePath, hadoopConf, parallel, parallelPartitions);
    }

    @Override
    public Path urlEncodedStringToPath(String path) {
        return VacuumCommandImpl.urlEncodedStringToPath$(this, path);
    }

    @Override
    public String pathToUrlEncodedString(Path path) {
        return VacuumCommandImpl.pathToUrlEncodedString$(this, path);
    }

    @Override
    public String pathStringtoUrlEncodedString(String path) {
        return VacuumCommandImpl.pathStringtoUrlEncodedString$(this, path);
    }

    @Override
    public Option<String> getActionRelativePath(FileAction action, FileSystem fs, Path basePath, boolean relativizeIgnoreError) {
        return VacuumCommandImpl.getActionRelativePath$(this, action, fs, basePath, relativizeIgnoreError);
    }

    @Override
    public Option<String> getRelativePath(String path, FileSystem fs, Path basePath, boolean relativizeIgnoreError) {
        return VacuumCommandImpl.getRelativePath$(this, path, fs, basePath, relativizeIgnoreError);
    }

    @Override
    public Seq<String> getValidRelativePathsAndSubdirs(FileAction action, FileSystem fs, Path basePath, boolean relativizeIgnoreError) {
        return VacuumCommandImpl.getValidRelativePathsAndSubdirs$(this, action, fs, basePath, relativizeIgnoreError);
    }

    @Override
    public Option<Tuple2<String, Object>> getDeletionVectorRelativePathAndSize(FileAction action) {
        return VacuumCommandImpl.getDeletionVectorRelativePathAndSize$(this, action);
    }

    @Override
    public Seq<Expression> parsePredicates(SparkSession spark, String predicate) {
        return DeltaCommand.parsePredicates$(this, spark, predicate);
    }

    @Override
    public void verifyPartitionPredicates(SparkSession spark, Seq<String> partitionColumns, Seq<Expression> predicates) {
        DeltaCommand.verifyPartitionPredicates$(this, spark, partitionColumns, predicates);
    }

    @Override
    public Map<String, AddFile> generateCandidateFileMap(Path basePath, Seq<AddFile> candidateFiles) {
        return DeltaCommand.generateCandidateFileMap$(this, basePath, candidateFiles);
    }

    @Override
    public Seq<RemoveFile> removeFilesFromPaths(DeltaLog deltaLog, Map<String, AddFile> nameToAddFileMap, Seq<String> filesToRewrite, long operationTimestamp) {
        return DeltaCommand.removeFilesFromPaths$(this, deltaLog, nameToAddFileMap, filesToRewrite, operationTimestamp);
    }

    @Override
    public HadoopFsRelation buildBaseRelation(SparkSession spark, OptimisticTransaction txn, String actionType, Path rootPath, Seq<String> inputLeafFiles, Map<String, AddFile> nameToAddFileMap) {
        return DeltaCommand.buildBaseRelation$(this, spark, txn, actionType, rootPath, inputLeafFiles, nameToAddFileMap);
    }

    @Override
    public AddFile getTouchedFile(Path basePath, String escapedFilePath, Map<String, AddFile> nameToAddFileMap) {
        return DeltaCommand.getTouchedFile$(this, basePath, escapedFilePath, nameToAddFileMap);
    }

    @Override
    public LogicalPlan resolveIdentifier(Analyzer analyzer, TableIdentifier identifier) {
        return DeltaCommand.resolveIdentifier$(this, analyzer, identifier);
    }

    @Override
    public boolean isCatalogTable(Analyzer analyzer, TableIdentifier tableIdent) {
        return DeltaCommand.isCatalogTable$(this, analyzer, tableIdent);
    }

    @Override
    public boolean isPathIdentifier(TableIdentifier tableIdent) {
        return DeltaCommand.isPathIdentifier$(this, tableIdent);
    }

    @Override
    public DeltaLog getDeltaLog(SparkSession spark, Option<String> path, Option<TableIdentifier> tableIdentifier, String operationName, Map<String, String> hadoopConf) {
        return DeltaCommand.getDeltaLog$(this, spark, path, tableIdentifier, operationName, hadoopConf);
    }

    @Override
    public Map<String, String> getDeltaLog$default$5() {
        return DeltaCommand.getDeltaLog$default$5$(this);
    }

    @Override
    public void sendDriverMetrics(SparkSession spark, Map<String, SQLMetric> metrics) {
        DeltaCommand.sendDriverMetrics$(this, spark, metrics);
    }

    @Override
    public DeltaTableV2 getDeltaTable(LogicalPlan target, String cmd) {
        return DeltaCommand.getDeltaTable$(this, target, cmd);
    }

    @Override
    public Option<CatalogTable> getTableCatalogTable(LogicalPlan target, String cmd) {
        return DeltaCommand.getTableCatalogTable$(this, target, cmd);
    }

    @Override
    public Tuple2<Option<TableIdentifier>, Option<String>> getDeltaTablePathOrIdentifier(LogicalPlan target, String cmd) {
        return DeltaCommand.getDeltaTablePathOrIdentifier$(this, target, cmd);
    }

    @Override
    public Tuple2<Option<TableIdentifier>, Option<String>> getTablePathOrIdentifier(LogicalPlan target, String cmd) {
        return DeltaCommand.getTablePathOrIdentifier$(this, target, cmd);
    }

    @Override
    public boolean hasBeenExecuted(OptimisticTransaction txn, SparkSession sparkSession, Option<DeltaOptions> options) {
        return DeltaCommand.hasBeenExecuted$(this, txn, sparkSession, options);
    }

    @Override
    public Option<DeltaOptions> hasBeenExecuted$default$3() {
        return DeltaCommand.hasBeenExecuted$default$3$(this);
    }

    @Override
    public Option<SetTransaction> createSetTransaction(SparkSession sparkSession, DeltaLog deltaLog, Option<DeltaOptions> options) {
        return DeltaCommand.createSetTransaction$(this, sparkSession, deltaLog, options);
    }

    @Override
    public Option<DeltaOptions> createSetTransaction$default$3() {
        return DeltaCommand.createSetTransaction$default$3$(this);
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void deltaAssert(Function0<Object> check, String name, String msg, DeltaLog deltaLog, Object data, Option<Path> path) {
        DeltaLogging.deltaAssert$(this, check, name, msg, deltaLog, data, path);
    }

    @Override
    public DeltaLog deltaAssert$default$4() {
        return DeltaLogging.deltaAssert$default$4$(this);
    }

    @Override
    public Object deltaAssert$default$5() {
        return DeltaLogging.deltaAssert$default$5$(this);
    }

    @Override
    public Option<Path> deltaAssert$default$6() {
        return DeltaLogging.deltaAssert$default$6$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public Map<String, Object> getErrorData(Throwable e) {
        return DeltaLogging.getErrorData$(this, e);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    @Override
    public LoggingShims.LogStringContext LogStringContext(StringContext sc) {
        return LoggingShims.LogStringContext$(this, sc);
    }

    @Override
    public void logInfo(LogEntry entry) {
        LoggingShims.logInfo$(this, entry);
    }

    @Override
    public void logInfo(LogEntry entry, Throwable throwable) {
        LoggingShims.logInfo$(this, entry, throwable);
    }

    @Override
    public void logDebug(LogEntry entry) {
        LoggingShims.logDebug$(this, entry);
    }

    @Override
    public void logDebug(LogEntry entry, Throwable throwable) {
        LoggingShims.logDebug$(this, entry, throwable);
    }

    @Override
    public void logTrace(LogEntry entry) {
        LoggingShims.logTrace$(this, entry);
    }

    @Override
    public void logTrace(LogEntry entry, Throwable throwable) {
        LoggingShims.logTrace$(this, entry, throwable);
    }

    @Override
    public void logWarning(LogEntry entry) {
        LoggingShims.logWarning$(this, entry);
    }

    @Override
    public void logWarning(LogEntry entry, Throwable throwable) {
        LoggingShims.logWarning$(this, entry, throwable);
    }

    @Override
    public void logError(LogEntry entry) {
        LoggingShims.logError$(this, entry);
    }

    @Override
    public void logError(LogEntry entry, Throwable throwable) {
        LoggingShims.logError$(this, entry, throwable);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public Seq<String> org$apache$spark$sql$delta$commands$VacuumCommandImpl$$supportedFsForLogging() {
        return this.org$apache$spark$sql$delta$commands$VacuumCommandImpl$$supportedFsForLogging;
    }

    @Override
    public final void org$apache$spark$sql$delta$commands$VacuumCommandImpl$_setter_$org$apache$spark$sql$delta$commands$VacuumCommandImpl$$supportedFsForLogging_$eq(Seq<String> x$1) {
        this.org$apache$spark$sql$delta$commands$VacuumCommandImpl$$supportedFsForLogging = x$1;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public StructType INVENTORY_SCHEMA() {
        return this.INVENTORY_SCHEMA;
    }

    public void checkRetentionPeriodSafety(SparkSession spark, Option<Object> retentionMs, long configuredRetention) {
        Predef$.MODULE$.require(retentionMs.forall((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$1 -> x$1 >= 0L), (Function0 & Serializable & scala.Serializable)() -> "Retention for Vacuum can't be less than 0.");
        boolean checkEnabled = BoxesRunTime.unboxToBoolean((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_VACUUM_RETENTION_CHECK_ENABLED()));
        boolean retentionSafe = retentionMs.forall((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$2 -> x$2 >= configuredRetention);
        LongRef configuredRetentionHours = LongRef.create((long)TimeUnit.MILLISECONDS.toHours(configuredRetention));
        if (TimeUnit.HOURS.toMillis(configuredRetentionHours.elem) < configuredRetention) {
            ++configuredRetentionHours.elem;
        }
        Predef$.MODULE$.require(!checkEnabled || retentionSafe, (Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(578).append("Are you sure you would like to vacuum files with such a low retention period? If you have\n        |writers that are currently writing to this table, there is a risk that you may corrupt the\n        |state of your Delta table.\n        |\n        |If you are certain that there are no operations being performed on this table, such as\n        |insert/upsert/delete/optimize, then you may turn off this check by setting:\n        |spark.databricks.delta.retentionDurationCheck.enabled = false\n        |\n        |If you are not sure, please use a value not less than \"").append(configuredRetentionHours$1.elem).append(" hours\".\n       ").toString())).stripMargin());
    }

    private Dataset<Row> getValidFilesFromSnapshot(SparkSession spark, String basePath, Snapshot snapshot, Option<Object> retentionMillis, Broadcast<SerializableConfiguration> hadoopConf, Clock clock, boolean checkAbsolutePathOnly) {
        long l;
        Predef$.MODULE$.require(snapshot.version() >= 0L, (Function0 & Serializable & scala.Serializable)() -> "No state defined for this table. Is this really a Delta table? Refusing to garbage collect.");
        long snapshotTombstoneRetentionMillis = DeltaLog$.MODULE$.tombstoneRetentionMillis(snapshot.metadata());
        this.checkRetentionPeriodSafety(spark, retentionMillis, snapshotTombstoneRetentionMillis);
        Option<Object> option = retentionMillis;
        if (option instanceof Some) {
            Some some = (Some)option;
            long millis = BoxesRunTime.unboxToLong((Object)some.value());
            l = clock.getTimeMillis() - millis;
        } else {
            l = snapshot.minFileRetentionTimestamp();
        }
        long deleteBeforeTimestamp = l;
        boolean relativizeIgnoreError = BoxesRunTime.unboxToBoolean((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_VACUUM_RELATIVIZE_IGNORE_ERROR()));
        String canonicalizedBasePath = SparkPath$.MODULE$.fromPathString(basePath).urlEncoded();
        return snapshot.stateDS().mapPartitions((Function1 & Serializable & scala.Serializable)actions -> {
            Path reservoirBase = new Path(basePath);
            FileSystem fs = reservoirBase.getFileSystem(((SerializableConfiguration)hadoopConf.value()).value());
            return actions.flatMap((Function1 & Serializable & scala.Serializable)x$3 -> {
                RemoveFile removeFile;
                boolean bl = false;
                FileAction fileAction = null;
                Action action = x$3.unwrap();
                if (action instanceof FileAction) {
                    bl = true;
                    fileAction = (FileAction)action;
                    if (checkAbsolutePathOnly && !fileAction.path().contains(basePath) && !fileAction.path().contains(canonicalizedBasePath)) {
                        return Nil$.MODULE$;
                    }
                }
                if (action instanceof RemoveFile && (removeFile = (RemoveFile)action).delTimestamp() < deleteBeforeTimestamp) {
                    return Nil$.MODULE$;
                }
                if (bl) {
                    return MODULE$.getValidRelativePathsAndSubdirs(fileAction, fs, reservoirBase, relativizeIgnoreError);
                }
                return Nil$.MODULE$;
            });
        }, org.apache.spark.sql.delta.implicits.package$.MODULE$.stringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"path"}));
    }

    public Dataset<SerializableFileStatus> getFilesFromInventory(String basePath, Seq<String> partitionColumns, Dataset<Row> inventory, boolean shouldIcebergMetadataDirBeHidden) {
        StructType inventorySchema;
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_sql_delta_commands_VacuumCommand$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.delta.SerializableFileStatus").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_delta_commands_VacuumCommand$$typecreator1$1() {
            }
        }
        Encoder fileNameAndSizeEncoder = Encoders$.MODULE$.product(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_delta_commands_VacuumCommand$$typecreator1$1()));
        StructType structType = inventorySchema = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inventory.schema().fields())).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)VacuumCommand$.$anonfun$getFilesFromInventory$1(f))));
        StructType structType2 = this.INVENTORY_SCHEMA();
        if (structType == null ? structType2 != null : !structType.equals(structType2)) {
            throw DeltaErrors$.MODULE$.invalidInventorySchema(this.INVENTORY_SCHEMA().treeString());
        }
        return inventory.filter(functions$.MODULE$.startswith(functions$.MODULE$.col("path"), functions$.MODULE$.lit((Object)new StringBuilder(1).append(basePath).append("/").toString()))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.substr(functions$.MODULE$.col("path"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)(basePath.length() + 2)))).as("path"), functions$.MODULE$.col("length"), functions$.MODULE$.col("isDir"), functions$.MODULE$.col("modificationTime")})).flatMap((Function1 & Serializable & scala.Serializable)row -> {
            String path = row.getString(0);
            if (!DeltaTableUtils$.MODULE$.isHiddenDirectory(partitionColumns, path, shouldIcebergMetadataDirBeHidden)) {
                return (Iterable)new .colon.colon((Object)new SerializableFileStatus(path, row.getLong(1), row.getBoolean(2), row.getLong(3)), (List)Nil$.MODULE$);
            }
            return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
        }, fileNameAndSizeEncoder).map((Function1 & Serializable & scala.Serializable)f -> new SerializableFileStatus(MODULE$.pathStringtoUrlEncodedString(f.path()), f.length(), f.isDir(), f.modificationTime()), fileNameAndSizeEncoder);
    }

    public Dataset<Row> gc(SparkSession spark, DeltaLog deltaLog, boolean dryRun, Option<Object> retentionHours, Option<Dataset<Row>> inventory, Option<String> vacuumTypeOpt, Map<String, SQLMetric> commandMetrics, Clock clock) {
        Dataset dataset;
        Object object = new Object();
        try {
            dataset = (Dataset)this.recordDeltaOperation(deltaLog, "delta.gc", this.recordDeltaOperation$default$3(), (Function0 & Serializable & scala.Serializable)() -> {
                Tuple3 tuple3;
                Tuple3 tuple32;
                Option option;
                None$ latestCommitVersionOutsideOfRetentionWindowOpt;
                None$ none$;
                Enumeration.Value vacuumType;
                long l;
                Option retentionMillis;
                long vacuumStartTime = System.currentTimeMillis();
                Path path = deltaLog.dataPath();
                Configuration deltaHadoopConf = deltaLog.newDeltaHadoopConf();
                FileSystem fs = path.getFileSystem(deltaHadoopConf);
                Snapshot snapshot = deltaLog.update(deltaLog.update$default$1(), deltaLog.update$default$2(), deltaLog.update$default$3());
                deltaLog.protocolWrite(snapshot.protocol());
                long snapshotTombstoneRetentionMillis = DeltaLog$.MODULE$.tombstoneRetentionMillis(snapshot.metadata());
                Option option2 = retentionMillis = retentionHours.map((Function1)(JFunction1.mcJD.sp & Serializable & scala.Serializable)h -> TimeUnit.HOURS.toMillis(scala.math.package$.MODULE$.round(h)));
                if (option2 instanceof Some) {
                    Some some = (Some)option2;
                    long millis = BoxesRunTime.unboxToLong((Object)some.value());
                    l = clock.getTimeMillis() - millis;
                } else {
                    l = snapshot.minFileRetentionTimestamp();
                }
                long deleteBeforeTimestamp = l;
                MODULE$.logInfo(LogEntry$.MODULE$.from((Function0<MessageWithContext>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Starting garbage collection (dryRun = "}))).log((Seq<MDC>)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ") of untracked "}))).log((Seq<MDC>)Predef$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.IS_DRY_RUN(), BoxesRunTime.boxToBoolean((boolean)dryRun))}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"files older than ", " in "}))).log((Seq<MDC>)Predef$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.DATE(), new Date(deleteBeforeTimestamp).toGMTString())}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq<MDC>)Predef$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.PATH(), path)})))));
                Broadcast hadoopConf = spark.sparkContext().broadcast((Object)new SerializableConfiguration(deltaHadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
                String basePath = fs.makeQualified(path).toString();
                boolean parallelDeleteEnabled = BoxesRunTime.unboxToBoolean((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_VACUUM_PARALLEL_DELETE_ENABLED()));
                int parallelDeletePartitions = BoxesRunTime.unboxToInt((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_VACUUM_PARALLEL_DELETE_PARALLELISM()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> spark.sessionState().conf().numShufflePartitions()));
                long startTimeToIdentifyEligibleFiles = System.currentTimeMillis();
                Dataset<Row> validFiles = MODULE$.getValidFilesFromSnapshot(spark, basePath, snapshot, (Option<Object>)retentionMillis, (Broadcast<SerializableConfiguration>)hadoopConf, clock, false);
                String[] partitionColumns = snapshot.metadata().partitionSchema().fieldNames();
                int parallelism = spark.sessionState().conf().parallelPartitionDiscoveryParallelism();
                boolean shouldIcebergMetadataDirBeHidden = UniversalFormat$.MODULE$.icebergEnabled(snapshot.metadata());
                boolean isLiteVacuumEnabled = BoxesRunTime.unboxToBoolean((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.LITE_VACUUM_ENABLED()));
                Enumeration.Value defaultType = isLiteVacuumEnabled ? VacuumCommand$VacuumType$.MODULE$.LITE() : VacuumCommand$VacuumType$.MODULE$.FULL();
                Enumeration.Value value = vacuumType = (Enumeration.Value)vacuumTypeOpt.map((Function1 & Serializable & scala.Serializable)s -> VacuumCommand$VacuumType$.MODULE$.withName((String)s)).getOrElse((Function0 & Serializable & scala.Serializable)() -> defaultType);
                Enumeration.Value value2 = VacuumCommand$VacuumType$.MODULE$.LITE();
                if (!(value != null ? !value.equals(value2) : value2 != null)) {
                    try {
                        Timestamp timestamp = new Timestamp(deleteBeforeTimestamp);
                        DeltaHistoryManager qual$1 = new DeltaHistoryManager(deltaLog, DeltaHistoryManager$.MODULE$.$lessinit$greater$default$2());
                        Timestamp x$1 = timestamp;
                        boolean x$2 = true;
                        boolean x$3 = false;
                        boolean x$4 = qual$1.getActiveCommitAtTime$default$4();
                        DeltaHistoryManager.Commit commit = qual$1.getActiveCommitAtTime(x$1, x$2, x$3, x$4);
                        none$ = new Some((Object)BoxesRunTime.boxToLong((long)commit.version()));
                    }
                    catch (DeltaErrorsBase.TimestampEarlierThanCommitRetentionException ex) {
                        none$ = None$.MODULE$;
                    }
                } else {
                    none$ = latestCommitVersionOutsideOfRetentionWindowOpt = None$.MODULE$;
                }
                if ((option = inventory) instanceof Some) {
                    Some some = (Some)option;
                    Dataset inventoryDF = (Dataset)some.value();
                    Dataset<SerializableFileStatus> files = MODULE$.getFilesFromInventory(basePath, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])partitionColumns), (Dataset<Row>)inventoryDF, shouldIcebergMetadataDirBeHidden);
                    tuple32 = new Tuple3(files, (Object)None$.MODULE$, (Object)None$.MODULE$);
                } else {
                    Enumeration.Value value3 = vacuumType;
                    Enumeration.Value value4 = VacuumCommand$VacuumType$.MODULE$.LITE();
                    if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
                        tuple32 = MODULE$.getFilesFromDeltaLog(spark, snapshot, basePath, (Broadcast<SerializableConfiguration>)hadoopConf, (Option<Object>)latestCommitVersionOutsideOfRetentionWindowOpt);
                    } else {
                        Dataset files = DeltaFileOperations$.MODULE$.recursiveListDirs(spark, (Seq<String>)((Seq)new .colon.colon((Object)basePath, (List)Nil$.MODULE$)), (Broadcast<SerializableConfiguration>)hadoopConf, (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)DeltaTableUtils$.MODULE$.isHiddenDirectory((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])partitionColumns), x$5, shouldIcebergMetadataDirBeHidden)), (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)DeltaTableUtils$.MODULE$.isHiddenDirectory((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])partitionColumns), x$6, shouldIcebergMetadataDirBeHidden)), (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)parallelism)), DeltaFileOperations$.MODULE$.recursiveListDirs$default$7()).map((Function1 & Serializable & scala.Serializable)f -> {
                            String path = MODULE$.pathStringtoUrlEncodedString(f.path());
                            return new SerializableFileStatus(path, f.length(), f.isDir(), f.modificationTime());
                        }, org.apache.spark.sql.delta.implicits.package$.MODULE$.serializableFileStatusEncoder());
                        tuple32 = tuple3 = new Tuple3((Object)files, (Object)None$.MODULE$, (Object)None$.MODULE$);
                    }
                }
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                Dataset allFilesAndDirsWithDuplicates = (Dataset)tuple3._1();
                Option eligibleStartCommitVersionOpt = (Option)tuple3._2();
                Option eligibleEndCommitVersionOpt = (Option)tuple3._3();
                Tuple3 tuple33 = new Tuple3((Object)allFilesAndDirsWithDuplicates, (Object)eligibleStartCommitVersionOpt, (Object)eligibleEndCommitVersionOpt);
                Dataset allFilesAndDirsWithDuplicates2 = (Dataset)tuple33._1();
                Option eligibleStartCommitVersionOpt2 = (Option)tuple33._2();
                Option eligibleEndCommitVersionOpt2 = (Option)tuple33._3();
                Dataset allFilesAndDirs = allFilesAndDirsWithDuplicates2.groupByKey((Function1 & Serializable & scala.Serializable)x$8 -> x$8.path(), org.apache.spark.sql.delta.implicits.package$.MODULE$.stringEncoder()).mapGroups((Function2 & Serializable & scala.Serializable)(k, v) -> {
                    Seq duplicates = v.toSeq();
                    return (SerializableFileStatus)duplicates.maxBy((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.modificationTime()), (Ordering)Ordering.Long$.MODULE$);
                }, org.apache.spark.sql.delta.implicits.package$.MODULE$.serializableFileStatusEncoder());
                return (Dataset)MODULE$.recordFrameProfile("Delta", "VacuumCommand.gc", () -> VacuumCommand$.$anonfun$gc$13(allFilesAndDirs, basePath, deleteBeforeTimestamp, hadoopConf, validFiles, startTimeToIdentifyEligibleFiles, dryRun, retentionMillis, snapshotTombstoneRetentionMillis, vacuumStartTime, partitionColumns, snapshot, eligibleStartCommitVersionOpt2, eligibleEndCommitVersionOpt2, vacuumType, deltaLog, object, spark, path, parallelDeleteEnabled, parallelDeletePartitions, commandMetrics, (Option)latestCommitVersionOutsideOfRetentionWindowOpt));
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                dataset = (Dataset)ex.value();
            }
            throw ex;
        }
        return dataset;
    }

    public boolean gc$default$3() {
        return true;
    }

    public Option<Object> gc$default$4() {
        return None$.MODULE$;
    }

    public Option<Dataset<Row>> gc$default$5() {
        return None$.MODULE$;
    }

    public Option<String> gc$default$6() {
        return None$.MODULE$;
    }

    public Map<String, SQLMetric> gc$default$7() {
        return Predef$.MODULE$.Map().empty();
    }

    public Clock gc$default$8() {
        return new SystemClock();
    }

    public Tuple3<Dataset<SerializableFileStatus>, Option<Object>, Option<Object>> getFilesFromDeltaLog(SparkSession spark, Snapshot snapshot, String basePath, Broadcast<SerializableConfiguration> hadoopConf, Option<Object> latestCommitVersionOutsideOfRetentionWindowOpt) {
        Tuple3 tuple3;
        Object object = new Object();
        try {
            DeltaLog deltaLog = snapshot.deltaLog();
            long earliestCommitVersion = DeltaHistoryManager$.MODULE$.getEarliestDeltaFile(deltaLog);
            Option latestCommitVersionOutsideOfRetentionWindowAsOfLastVacuumOpt = LastVacuumInfo$.MODULE$.getLastVacuumInfo(deltaLog).flatMap((Function1 & Serializable & scala.Serializable)x$10 -> x$10.latestCommitVersionOutsideOfRetentionWindow());
            long latestCommitVersionOutsideOfRetentionWindow = BoxesRunTime.unboxToLong((Object)latestCommitVersionOutsideOfRetentionWindowOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new NonLocalReturnControl(object, (Object)new Tuple3((Object)spark.emptyDataset(org.apache.spark.sql.delta.implicits.package$.MODULE$.serializableFileStatusEncoder()), (Object)None$.MODULE$, (Object)None$.MODULE$));
            }));
            if (earliestCommitVersion != 0L && latestCommitVersionOutsideOfRetentionWindowAsOfLastVacuumOpt.forall((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$11 -> x$11 < earliestCommitVersion)) {
                throw DeltaErrors$.MODULE$.deltaCannotVacuumLite();
            }
            long eligibleStartCommitVersion = scala.math.package$.MODULE$.min(deltaLog.update(deltaLog.update$default$1(), deltaLog.update$default$2(), deltaLog.update$default$3()).version(), BoxesRunTime.unboxToLong((Object)latestCommitVersionOutsideOfRetentionWindowAsOfLastVacuumOpt.map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)x$12 -> x$12 + 1L).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> earliestCommitVersion)));
            long eligibleEndCommitVersion = latestCommitVersionOutsideOfRetentionWindow;
            if (eligibleStartCommitVersion > latestCommitVersionOutsideOfRetentionWindow) {
                return new Tuple3((Object)spark.emptyDataset(org.apache.spark.sql.delta.implicits.package$.MODULE$.serializableFileStatusEncoder()), (Object)None$.MODULE$, (Object)None$.MODULE$);
            }
            tuple3 = new Tuple3(this.getFilesFromDeltaLog(spark, deltaLog, basePath, hadoopConf, eligibleStartCommitVersion, eligibleEndCommitVersion), (Object)new Some((Object)BoxesRunTime.boxToLong((long)eligibleStartCommitVersion)), (Object)new Some((Object)BoxesRunTime.boxToLong((long)eligibleEndCommitVersion)));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                tuple3 = (Tuple3)ex.value();
            }
            throw ex;
        }
        return tuple3;
    }

    public Dataset<SerializableFileStatus> getFilesFromDeltaLog(SparkSession spark, DeltaLog deltaLog, String basePath, Broadcast<SerializableConfiguration> hadoopConf, long eligibleStartCommitVersion, long eligibleEndCommitVersion) {
        Path prefix = FileNames$.MODULE$.listingPrefix(deltaLog.logPath(), eligibleStartCommitVersion);
        Seq eligibleDeltaLogFilesFromDeltaLogDirectory = deltaLog.store().listFrom(prefix, deltaLog.newDeltaHadoopConf()).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends FileStatus, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Option<Tuple2<FileStatus, Object>> option = FileNames$DeltaFile$.MODULE$.unapply(A1);
                if (!option.isEmpty()) {
                    FileStatus f = (FileStatus)((Tuple2)option.get())._1();
                    long deltaFileVersion = ((Tuple2)option.get())._2$mcJ$sp();
                    return (B1)new Tuple2((Object)f, (Object)BoxesRunTime.boxToLong((long)deltaFileVersion));
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(FileStatus x1) {
                FileStatus fileStatus = x1;
                Option<Tuple2<FileStatus, Object>> option = FileNames$DeltaFile$.MODULE$.unapply(fileStatus);
                return !option.isEmpty();
            }
        }).takeWhile((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)VacuumCommand$.$anonfun$getFilesFromDeltaLog$6(eligibleEndCommitVersion, x$13))).toSeq();
        FileSystem fs = deltaLog.logPath().getFileSystem(deltaLog.newDeltaHadoopConf());
        Path commitDirPath = FileNames$.MODULE$.commitDirPath(deltaLog.logPath());
        long updatedStartCommitVersion = BoxesRunTime.unboxToLong((Object)eligibleDeltaLogFilesFromDeltaLogDirectory.lastOption().map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToLong((long)x$14._2$mcJ$sp())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> eligibleStartCommitVersion));
        Seq eligibleDeltaLogFilesFromCommitDirectory = fs.exists(commitDirPath) ? deltaLog.store().listFrom(FileNames$.MODULE$.listingPrefix(commitDirPath, updatedStartCommitVersion), deltaLog.newDeltaHadoopConf()).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends FileStatus, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                Option<Tuple3<FileStatus, Object, String>> option = FileNames$UnbackfilledDeltaFile$.MODULE$.unapply(A1);
                if (!option.isEmpty()) {
                    FileStatus f = (FileStatus)((Tuple3)option.get())._1();
                    long deltaFileVersion = BoxesRunTime.unboxToLong((Object)((Tuple3)option.get())._2());
                    return (B1)new Tuple2((Object)f, (Object)BoxesRunTime.boxToLong((long)deltaFileVersion));
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(FileStatus x2) {
                FileStatus fileStatus = x2;
                Option<Tuple3<FileStatus, Object, String>> option = FileNames$UnbackfilledDeltaFile$.MODULE$.unapply(fileStatus);
                return !option.isEmpty();
            }
        }).takeWhile((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)VacuumCommand$.$anonfun$getFilesFromDeltaLog$9(eligibleEndCommitVersion, x$15))).toSeq() : (Seq)Nil$.MODULE$;
        Seq allDeltaLogFilesOutsideTheRetentionWindow = (Seq)eligibleDeltaLogFilesFromDeltaLogDirectory.$plus$plus((GenTraversableOnce)eligibleDeltaLogFilesFromCommitDirectory, Seq$.MODULE$.canBuildFrom());
        DeltaLogFileIndex deltaLogFileIndex = (DeltaLogFileIndex)DeltaLogFileIndex$.MODULE$.apply((FileFormat)DeltaLogFileIndex$.MODULE$.COMMIT_FILE_FORMAT(), (Seq<FileStatus>)((Seq)allDeltaLogFilesOutsideTheRetentionWindow.map((Function1 & Serializable & scala.Serializable)x$16 -> (FileStatus)x$16._1(), Seq$.MODULE$.canBuildFrom()))).get();
        Dataset allActions = deltaLog.loadIndex(deltaLogFileIndex, deltaLog.loadIndex$default$2()).as(org.apache.spark.sql.delta.implicits.package$.MODULE$.singleActionEncoder());
        Dataset nonCDFFiles = allActions.where("remove IS NOT NULL").select(functions$.MODULE$.col("remove").as(org.apache.spark.sql.delta.implicits.package$.MODULE$.removeFileEncoder())).mapPartitions((Function1 & Serializable & scala.Serializable)iter -> iter.flatMap((Function1 & Serializable & scala.Serializable)r -> {
            long modificationTime = BoxesRunTime.unboxToLong((Object)r.deletionTimestamp().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
            Option dv = MODULE$.getDeletionVectorRelativePathAndSize((FileAction)r).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String path = (String)tuple2._1();
                    long length = tuple2._2$mcJ$sp();
                    return new SerializableFileStatus(path, length, false, modificationTime);
                }
                throw new MatchError((Object)tuple2);
            });
            return dv.iterator().$plus$plus((Function0 & Serializable & scala.Serializable)() -> scala.package$.MODULE$.Iterator().single((Object)new SerializableFileStatus(r.path(), BoxesRunTime.unboxToLong((Object)r.size().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), false, modificationTime)));
        }), org.apache.spark.sql.delta.implicits.package$.MODULE$.serializableFileStatusEncoder()).as(org.apache.spark.sql.delta.implicits.package$.MODULE$.serializableFileStatusEncoder());
        Dataset cdfFiles = allActions.where("cdc IS NOT NULL").select(functions$.MODULE$.col("cdc").as(org.apache.spark.sql.delta.implicits.package$.MODULE$.addCdcFileEncoder())).map((Function1 & Serializable & scala.Serializable)cdc -> new SerializableFileStatus(cdc.path(), cdc.size(), false, 0L), org.apache.spark.sql.delta.implicits.package$.MODULE$.serializableFileStatusEncoder());
        boolean relativizeIgnoreError = BoxesRunTime.unboxToBoolean((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_VACUUM_RELATIVIZE_IGNORE_ERROR()));
        return nonCDFFiles.union(cdfFiles).mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            Path reservoirBase = new Path(basePath);
            FileSystem fs = reservoirBase.getFileSystem(((SerializableConfiguration)hadoopConf.value()).value());
            return iter.flatMap((Function1 & Serializable & scala.Serializable)f -> Option$.MODULE$.option2Iterable(MODULE$.getRelativePath(f.path(), fs, reservoirBase, relativizeIgnoreError).map((Function1 & Serializable & scala.Serializable)x$17 -> new SerializableFileStatus((String)x$17, f.length(), f.isDir(), f.modificationTime()))));
        }, org.apache.spark.sql.delta.implicits.package$.MODULE$.serializableFileStatusEncoder());
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$getFilesFromInventory$1(StructField f) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])MODULE$.INVENTORY_SCHEMA().fields())).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).contains((Object)f.name());
    }

    public static final /* synthetic */ Dataset $anonfun$gc$13(Dataset allFilesAndDirs$1, String basePath$2, long deleteBeforeTimestamp$2, Broadcast hadoopConf$2, Dataset validFiles$1, long startTimeToIdentifyEligibleFiles$1, boolean dryRun$1, Option retentionMillis$1, long snapshotTombstoneRetentionMillis$1, long vacuumStartTime$1, String[] partitionColumns$2, Snapshot snapshot$1, Option eligibleStartCommitVersionOpt$1, Option eligibleEndCommitVersionOpt$1, Enumeration.Value vacuumType$1, DeltaLog deltaLog$1, Object nonLocalReturnKey1$1, SparkSession spark$1, Path path$1, boolean parallelDeleteEnabled$1, int parallelDeletePartitions$1, Map commandMetrics$1, Option latestCommitVersionOutsideOfRetentionWindowOpt$1) {
        Dataset dataset;
        try {
            long l;
            allFilesAndDirs$1.cache();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MODULE$.getClass().getClassLoader());
            public final class Org_apache_spark_sql_delta_commands_VacuumCommand$$typecreator1$2
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.sql.delta.commands.VacuumCommand.FileNameAndSize").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_delta_commands_VacuumCommand$$typecreator1$2() {
                }
            }
            Encoder fileNameAndSizeEncoder = Encoders$.MODULE$.product(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_delta_commands_VacuumCommand$$typecreator1$2()));
            long dirCounts = allFilesAndDirs$1.where(functions$.MODULE$.col("isDir")).count() + 1L;
            long filesAndDirsPresentBeforeDelete = allFilesAndDirs$1.count();
            String canonicalizedBasePath = SparkPath$.MODULE$.fromPathString(basePath$2).urlEncoded();
            Dataset diff = allFilesAndDirs$1.where(functions$.MODULE$.col("modificationTime").$less((Object)BoxesRunTime.boxToLong((long)deleteBeforeTimestamp$2)).$bar$bar((Object)functions$.MODULE$.col("isDir"))).mapPartitions((Function1 & Serializable & scala.Serializable)fileStatusIterator -> {
                Path reservoirBase = new Path(basePath$2);
                FileSystem fs = reservoirBase.getFileSystem(((SerializableConfiguration)hadoopConf$2.value()).value());
                return fileStatusIterator.flatMap((Function1 & Serializable & scala.Serializable)fileStatus -> {
                    if (fileStatus.isDir()) {
                        return scala.package$.MODULE$.Iterator().single((Object)new VacuumCommand.FileNameAndSize(MODULE$.relativize(MODULE$.urlEncodedStringToPath(fileStatus.path()), fs, reservoirBase, true), 0L));
                    }
                    Iterator<String> dirs = MODULE$.getAllSubdirs(canonicalizedBasePath, fileStatus.path(), fs);
                    Iterator dirsWithSlash = dirs.map((Function1 & Serializable & scala.Serializable)p -> {
                        String relativizedPath = MODULE$.relativize(MODULE$.urlEncodedStringToPath((String)p), fs, reservoirBase, true);
                        return new VacuumCommand.FileNameAndSize(relativizedPath, 0L);
                    });
                    return dirsWithSlash.$plus$plus((Function0 & Serializable & scala.Serializable)() -> scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new VacuumCommand.FileNameAndSize[]{new VacuumCommand.FileNameAndSize(MODULE$.relativize(MODULE$.urlEncodedStringToPath(fileStatus.path()), fs, reservoirBase, false), fileStatus.length())})));
                });
            }, fileNameAndSizeEncoder).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("path")})).agg(functions$.MODULE$.count(new Column("*")).as("count"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.sum("length").as("length")})).join(validFiles$1, (Seq)new .colon.colon((Object)"path", (List)Nil$.MODULE$), "leftanti").where(functions$.MODULE$.col("count").$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
            Row sizeOfDataToDeleteRow = (Row)diff.agg(functions$.MODULE$.sum("length").cast("long"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0])).first();
            long sizeOfDataToDelete = sizeOfDataToDeleteRow.isNullAt(0) ? 0L : sizeOfDataToDeleteRow.getLong(0);
            Dataset diffFiles = diff.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("path")})).as(org.apache.spark.sql.delta.implicits.package$.MODULE$.stringEncoder()).map((Function1 & Serializable & scala.Serializable)relativePath -> {
                Predef$.MODULE$.assert(!MODULE$.urlEncodedStringToPath((String)relativePath).isAbsolute(), (Function0 & Serializable & scala.Serializable)() -> "Shouldn't have any absolute paths for deletion here.");
                return MODULE$.pathToUrlEncodedString(DeltaFileOperations$.MODULE$.absolutePath(basePath$2, (String)relativePath));
            }, org.apache.spark.sql.delta.implicits.package$.MODULE$.stringEncoder());
            long timeTakenToIdentifyEligibleFiles = System.currentTimeMillis() - startTimeToIdentifyEligibleFiles$1;
            long numFiles = diffFiles.count();
            if (dryRun$1) {
                DeltaVacuumStats stats = new DeltaVacuumStats(true, (Option<Object>)retentionMillis$1, snapshotTombstoneRetentionMillis$1, deleteBeforeTimestamp$2, dirCounts, filesAndDirsPresentBeforeDelete, numFiles, sizeOfDataToDelete, timeTakenToIdentifyEligibleFiles, 0L, vacuumStartTime$1, System.currentTimeMillis(), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionColumns$2)).size(), snapshot$1.version(), (Option<Object>)eligibleStartCommitVersionOpt$1, (Option<Object>)eligibleEndCommitVersionOpt$1, vacuumType$1.toString());
                DeltaLog x$5 = deltaLog$1;
                String x$6 = "delta.gc.stats";
                DeltaVacuumStats x$7 = stats;
                Map<TagDefinition, String> x$8 = MODULE$.recordDeltaEvent$default$3();
                Option<Path> x$9 = MODULE$.recordDeltaEvent$default$5();
                MODULE$.recordDeltaEvent(x$5, x$6, x$8, x$7, x$9);
                MODULE$.logInfo(LogEntry$.MODULE$.from((Function0<MessageWithContext>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " files "}))).log((Seq<MDC>)Predef$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.NUM_FILES(), BoxesRunTime.boxToLong((long)numFiles))})).$plus(MODULE$.LogStringContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", " bytes) and directories in "}))).log((Seq<MDC>)Predef$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.NUM_BYTES(), BoxesRunTime.boxToLong((long)sizeOfDataToDelete))}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a total of ", " directories "}))).log((Seq<MDC>)Predef$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.NUM_DIRS(), BoxesRunTime.boxToLong((long)dirCounts))}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"that are safe to delete. Vacuum stats: ", ""}))).log((Seq<MDC>)Predef$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.VACUUM_STATS(), stats)})))));
                throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)diffFiles.map((Function1 & Serializable & scala.Serializable)f -> MODULE$.urlEncodedStringToPath((String)f).toString(), org.apache.spark.sql.delta.implicits.package$.MODULE$.stringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"path"})));
            }
            MODULE$.logVacuumStart(spark$1, deltaLog$1, path$1, (Dataset<String>)diffFiles, sizeOfDataToDelete, (Option<Object>)retentionMillis$1, snapshotTombstoneRetentionMillis$1);
            long deleteStartTime = System.currentTimeMillis();
            try {
                l = MODULE$.delete((Dataset<String>)diffFiles, spark$1, basePath$2, (Broadcast<SerializableConfiguration>)hadoopConf$2, parallelDeleteEnabled$1, parallelDeletePartitions$1);
            }
            catch (Throwable t) {
                MODULE$.logVacuumEnd(deltaLog$1, spark$1, path$1, (Map<String, SQLMetric>)commandMetrics$1, MODULE$.logVacuumEnd$default$5(), MODULE$.logVacuumEnd$default$6());
                throw t;
            }
            long filesDeleted = l;
            long timeTakenForDelete = System.currentTimeMillis() - deleteStartTime;
            DeltaVacuumStats stats = new DeltaVacuumStats(false, (Option<Object>)retentionMillis$1, snapshotTombstoneRetentionMillis$1, deleteBeforeTimestamp$2, dirCounts, filesAndDirsPresentBeforeDelete, filesDeleted, sizeOfDataToDelete, timeTakenToIdentifyEligibleFiles, timeTakenForDelete, vacuumStartTime$1, System.currentTimeMillis(), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionColumns$2)).size(), snapshot$1.version(), (Option<Object>)eligibleStartCommitVersionOpt$1, (Option<Object>)eligibleEndCommitVersionOpt$1, vacuumType$1.toString());
            DeltaLog x$10 = deltaLog$1;
            String x$11 = "delta.gc.stats";
            DeltaVacuumStats x$12 = stats;
            Map<TagDefinition, String> x$13 = MODULE$.recordDeltaEvent$default$3();
            Option<Path> x$14 = MODULE$.recordDeltaEvent$default$5();
            MODULE$.recordDeltaEvent(x$10, x$11, x$13, x$12, x$14);
            MODULE$.logVacuumEnd(deltaLog$1, spark$1, path$1, (Map<String, SQLMetric>)commandMetrics$1, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)filesDeleted)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)dirCounts)));
            LastVacuumInfo$.MODULE$.persistLastVacuumInfo(new LastVacuumInfo((Option<Object>)latestCommitVersionOutsideOfRetentionWindowOpt$1), deltaLog$1);
            MODULE$.logInfo(LogEntry$.MODULE$.from((Function0<MessageWithContext>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleted ", " files "}))).log((Seq<MDC>)Predef$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.NUM_FILES(), BoxesRunTime.boxToLong((long)filesDeleted))})).$plus(MODULE$.LogStringContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", " bytes) and directories in "}))).log((Seq<MDC>)Predef$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.NUM_BYTES(), BoxesRunTime.boxToLong((long)sizeOfDataToDelete))}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a total of ", " directories. "}))).log((Seq<MDC>)Predef$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.NUM_DIRS(), BoxesRunTime.boxToLong((long)dirCounts))}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Vacuum stats: ", ""}))).log((Seq<MDC>)Predef$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC(DeltaLogKeys$.MODULE$.VACUUM_STATS(), stats)})))));
            dataset = spark$1.createDataset((Seq)new .colon.colon((Object)basePath$2, (List)Nil$.MODULE$), org.apache.spark.sql.delta.implicits.package$.MODULE$.stringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"path"}));
        }
        finally {
            allFilesAndDirs$1.unpersist();
        }
        return dataset;
    }

    public static final /* synthetic */ boolean $anonfun$getFilesFromDeltaLog$6(long eligibleEndCommitVersion$1, Tuple2 x$13) {
        return x$13._2$mcJ$sp() <= eligibleEndCommitVersion$1;
    }

    public static final /* synthetic */ boolean $anonfun$getFilesFromDeltaLog$9(long eligibleEndCommitVersion$1, Tuple2 x$15) {
        return x$15._2$mcJ$sp() <= eligibleEndCommitVersion$1;
    }

    private VacuumCommand$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        LoggingShims.$init$(this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
        DeltaCommand.$init$(this);
        VacuumCommandImpl.$init$(this);
        this.INVENTORY_SCHEMA = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("path", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("length", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("isDir", (DataType)BooleanType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("modificationTime", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))));
    }
}

